/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.types.DataTypeManager;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimestampWithTimezone {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    private static final int NANO_DIGITS = 9;

    public static Object create(Date date, TimeZone initial, Calendar target, Class type) {
        if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            return TimestampWithTimezone.createTime(date, initial, target);
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return TimestampWithTimezone.createDate(date, initial, target);
        }
        return TimestampWithTimezone.createTimestamp(date, initial, target);
    }

    public static Timestamp createTimestamp(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = Calendar.getInstance();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        target.set(14, 0);
        Timestamp tsInTz = new Timestamp(target.getTimeInMillis());
        if (date instanceof Timestamp) {
            tsInTz.setNanos(((Timestamp)date).getNanos());
        }
        target.setTimeInMillis(time);
        return tsInTz;
    }

    public static Time createTime(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = Calendar.getInstance();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        Time result = TimestampWithTimezone.normalizeTime(date, target);
        target.setTimeInMillis(time);
        return result;
    }

    public static java.sql.Date createDate(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = Calendar.getInstance();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        java.sql.Date result = TimestampWithTimezone.normalizeDate(date, target);
        target.setTimeInMillis(time);
        return result;
    }

    public static Time createTime(Date date) {
        if (date instanceof Time) {
            return (Time)date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return TimestampWithTimezone.normalizeTime(date, cal);
    }

    public static java.sql.Date createDate(Date date) {
        if (date instanceof java.sql.Date) {
            return (java.sql.Date)date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return TimestampWithTimezone.normalizeDate(date, cal);
    }

    public static Timestamp createTimestamp(Date date) {
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    private static java.sql.Date normalizeDate(Date date, Calendar target) {
        if (!(date instanceof java.sql.Date)) {
            target.set(11, 0);
            target.set(12, 0);
            target.set(13, 0);
            target.set(14, 0);
        }
        java.sql.Date result = new java.sql.Date(target.getTimeInMillis());
        return result;
    }

    private static Time normalizeTime(Date date, Calendar target) {
        if (!(date instanceof Time)) {
            target.set(1, 1970);
            target.set(2, 0);
            target.set(5, 1);
            target.set(14, 0);
        }
        Time result = new Time(target.getTimeInMillis());
        return result;
    }

    private static void adjustCalendar(Date date, TimeZone initial, Calendar target) {
        if (initial == null) {
            initial = DEFAULT_TIME_ZONE;
        }
        if (initial == target.getTimeZone()) {
            return;
        }
        long time = date.getTime();
        Calendar cal = Calendar.getInstance(initial);
        cal.setTimeInMillis(time);
        for (int i = 0; i < 14; ++i) {
            target.set(i, cal.get(i));
        }
    }

    public static Timestamp parseTimestampWithTimezone(String inStr) throws ParseException {
        int lastSpace = inStr.lastIndexOf(32);
        if (lastSpace < 0) {
            throw new ParseException(inStr, lastSpace);
        }
        String tzOffset = inStr.substring(lastSpace + 1);
        int nanos = 0;
        int decimalIndex = inStr.lastIndexOf(".", lastSpace);
        if (decimalIndex >= 0) {
            String partialSeconds = inStr.substring(decimalIndex + 1, lastSpace);
            nanos = TimestampWithTimezone.parseNanos(partialSeconds.trim());
        } else {
            decimalIndex = lastSpace;
        }
        TimeZone tz = TimestampWithTimezone.parseTimezoneOffset(tzOffset);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        df.setTimeZone(tz);
        Timestamp ts = new Timestamp(df.parse(inStr.substring(0, decimalIndex)).getTime());
        ts.setNanos(nanos);
        return ts;
    }

    private static TimeZone parseTimezoneOffset(String tzOffset) {
        return TimeZone.getTimeZone("GMT" + tzOffset);
    }

    private static int parseNanos(String partialSeconds) {
        int digits = partialSeconds.length();
        int rawValue = Integer.parseInt(partialSeconds);
        return (int)((double)rawValue * Math.pow(10.0, 9 - digits));
    }
}

