/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.common.util.crypto.CryptoFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

class PortableStringUtil {
    static char EQUALS = (char)61;
    static char PROP_SEPARATOR = (char)59;
    static char CTX_SEPARATOR = (char)124;
    private static char ESCAPE = (char)92;

    PortableStringUtil() {
    }

    static String escapeString(String val) {
        StringBuffer buf = new StringBuffer(val);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != EQUALS && c != PROP_SEPARATOR && c != CTX_SEPARATOR && c != ESCAPE) continue;
            buf.insert(i, ESCAPE);
            ++i;
        }
        return buf.toString();
    }

    static String unescapeString(String val) {
        StringBuffer buf = new StringBuffer(val);
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != ESCAPE) continue;
            buf.deleteCharAt(i);
        }
        return buf.toString();
    }

    static String encode(Object val) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(val);
        out.flush();
        String encodedString = new String(CryptoFactory.encodeBytes(bout.toByteArray()));
        out.close();
        return PortableStringUtil.escapeString(encodedString);
    }

    static Object decode(String encodedString) throws IOException, ClassNotFoundException {
        String unescapedString = PortableStringUtil.unescapeString(encodedString);
        byte[] bytes = CryptoFactory.decodeBytes(unescapedString.toCharArray());
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bin);
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    static String[] getParts(String whole, char separator) {
        if (whole == null || whole.length() == 0) {
            return null;
        }
        char[] chars = whole.toCharArray();
        ArrayList<String> parts = new ArrayList<String>();
        char previous = chars[0];
        int currentOffset = 0;
        for (int i = 1; i < chars.length; ++i) {
            char current = chars[i];
            if (current == separator && previous != ESCAPE) {
                parts.add(new String(chars, currentOffset, i - currentOffset));
                currentOffset = i + 1;
            }
            previous = current;
        }
        if (currentOffset < chars.length) {
            parts.add(new String(chars, currentOffset, chars.length - currentOffset));
        }
        return parts.toArray(new String[parts.size()]);
    }
}

