/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.dqp.message.ResultsMessage;

final class ResponseReceiver
implements MessageListener {
    private Message responseMessage;
    private boolean messageReceived = false;

    ResponseReceiver() {
    }

    public synchronized void deliverMessage(Message message, String messageKey) {
        if (!this.messageReceived) {
            this.responseMessage = message;
            this.messageReceived = true;
            this.notify();
        }
    }

    synchronized Message waitForResponse(long timeout) throws InterruptedException, MetaMatrixComponentException {
        if (!this.messageReceived) {
            this.wait(timeout);
        }
        if (this.messageReceived) {
            return this.responseMessage;
        }
        throw new MetaMatrixComponentException();
    }

    static ResultsMessage waitForResponseMessage(ResponseReceiver receiver, long wait) throws MetaMatrixComponentException {
        try {
            Message message = receiver.waitForResponse(wait);
            if (message instanceof MessageHolder) {
                ExceptionHolder holder = (ExceptionHolder)((MessageHolder)message).contents;
                ResultsMessage results = new ResultsMessage();
                results.setException(holder.exception);
                return results;
            }
            return (ResultsMessage)message;
        }
        catch (InterruptedException e) {
            throw new MetaMatrixComponentException(e);
        }
        catch (MetaMatrixComponentException e) {
            return null;
        }
    }
}

