/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.core.log.Logger;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;

public class DriverManagerLogger
implements Logger {
    int allowedSeverity = 0;
    PrintWriter writer = null;

    public DriverManagerLogger(int loglevel, PrintWriter writer) {
        this.allowedSeverity = loglevel;
        this.writer = writer;
    }

    private boolean allow(int level) {
        return this.converToJDBCLogLevel(level) <= this.allowedSeverity;
    }

    private int converToJDBCLogLevel(int messageLevel) {
        switch (messageLevel) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return 0;
    }

    public void log(IStatus status) {
        throw new RuntimeException();
    }

    public void log(int severity, String message) {
        if (this.writer != null && this.allow(severity)) {
            this.writer.println(message);
        }
    }

    public void log(int severity, Throwable t, String message) {
        if (this.writer != null && this.allow(severity)) {
            this.writer.println(message);
            t.printStackTrace(this.writer);
        }
    }

    public void log(Object obj) {
        if (this.writer != null && this.allow(4)) {
            this.writer.println(obj.toString());
        }
    }

    public void log(Throwable t) {
        if (this.writer != null && this.allow(2)) {
            this.writer.println(t.getMessage());
            t.printStackTrace(this.writer);
        }
    }
}

