/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.DeferredMetadataProvider;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMResultSet;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ResultsMetadataWithProvider;
import com.metamatrix.jdbc.WarningUtil;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ResultsImpl
extends MMResultSet {
    protected List[] results;
    protected int currentRow;
    protected int lastRow;
    protected int firstRow;
    protected int finalRow = -1;
    protected static final int BEFORE_FIRST_ROW = 0;
    protected static final int FIRST_ROW = 1;
    private ResultSetMetaData rmetadata;
    protected MMStatement statement;
    protected List warnings;
    private MetaMatrixException exception;
    protected String[] fields;
    protected Map columnInfos;
    protected int resultSetType;
    private Date processingTimestamp;
    private Date completedTimestamp;

    ResultsImpl(ResultsMessage resultsMsg, MMStatement statement) {
        this(resultsMsg, statement, null);
    }

    ResultsImpl(ResultsMessage resultsMsg, MMStatement statement, ResultSetMetaData metadata) {
        this.results = resultsMsg.getResults();
        this.statement = statement;
        this.processingTimestamp = resultsMsg.getProcessingTimestamp();
        this.completedTimestamp = resultsMsg.getCompletedTimestamp();
        this.currentRow = 0;
        this.firstRow = 1;
        this.exception = resultsMsg.getException();
        this.warnings = resultsMsg.getWarnings();
        resultsMsg.getSchemas();
        this.fields = resultsMsg.getColumnNames();
        this.columnInfos = new HashMap();
        this.resultSetType = statement.getResultSetType();
        if (this.exception == null) {
            if (metadata == null) {
                DeferredMetadataProvider provider = DeferredMetadataProvider.createWithInitialData(resultsMsg.getColumnNames(), resultsMsg.getDataTypes(), statement, resultsMsg.getRequestID(), this.getLogger());
                this.rmetadata = ResultsMetadataWithProvider.newInstance(provider, this.getLogger());
            } else {
                this.rmetadata = metadata;
            }
        }
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.rmetadata == null) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.Metadata_null"));
        }
        return this.rmetadata;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.statement.getFetchSize();
    }

    public MetaMatrixException getException() {
        return this.exception;
    }

    void setException(MetaMatrixException exception) {
        this.exception = exception;
    }

    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.statement;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.warnings != null && !this.warnings.isEmpty()) {
            return WarningUtil.convertWarnings(this.warnings);
        }
        return null;
    }

    public Date getProcessingTimestamp() throws SQLException {
        this.checkClosed();
        return this.processingTimestamp;
    }

    public Date getCompletedTimestamp() throws SQLException {
        this.checkClosed();
        return this.completedTimestamp;
    }

    public long getProcessingTime() throws SQLException {
        this.checkClosed();
        if (this.completedTimestamp != null && this.processingTimestamp != null) {
            return this.completedTimestamp.getTime() - this.processingTimestamp.getTime();
        }
        return -1L;
    }

    public abstract void close() throws SQLException;

    public int findColumn(String columnName) throws SQLException {
        this.checkClosed();
        return this.findColumnIndex(columnName);
    }

    protected int findColumnIndex(String columnName) throws SQLException {
        int colCount = this.rmetadata.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            if (!this.rmetadata.getColumnName(i).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        String msg = JDBCPlugin.Util.getString("MMResultsImpl.Col_doesnt_exist", columnName);
        throw new MMSQLException(msg);
    }

    public abstract boolean isFirst() throws SQLException;

    public abstract boolean isLast() throws SQLException;

    public abstract boolean hasNext() throws SQLException;

    public abstract boolean next() throws SQLException;

    public abstract boolean previous() throws SQLException;

    public abstract int getRow() throws SQLException;

    public abstract List getCurrentRecord() throws SQLException;

    public boolean isAfterLast() throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        this.checkClosed();
        return !this.hasNext() && !this.isLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        this.checkClosed();
        return this.getRow() == 0 && this.hasNext();
    }

    public boolean relative(int rows) throws SQLException {
        if (!this.hasResults()) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.Null_results"));
        }
        if (!this.isValidRow()) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.The_cursor_is_not_on_a_valid_row._1"));
        }
        this.checkClosed();
        if (this.getType() != 1003) {
            if (rows > 0) {
                while (rows > 0 && this.next()) {
                    --rows;
                }
            } else if (rows < 0) {
                while (rows < 0 && this.previous()) {
                    ++rows;
                }
            }
            return this.isValidRow();
        }
        String msg = JDBCPlugin.Util.getString("ResultsImpl.Op_invalid_fwd_only");
        throw new MMSQLException(msg);
    }

    public boolean last() throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        this.checkClosed();
        if (this.getType() != 1003) {
            if (this.isLast()) {
                return true;
            }
            this.afterLast();
            return this.previous();
        }
        String msg = JDBCPlugin.Util.getString("ResultsImpl.Op_invalid_fwd_only");
        throw new MMSQLException(msg);
    }

    public void afterLast() throws SQLException {
        if (this.hasResults()) {
            this.checkClosed();
            if (this.getType() == 1003) {
                String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
                throw new MMSQLException(msg);
            }
            while (this.next()) {
            }
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.hasResults()) {
            this.checkClosed();
            if (this.getType() == 1003) {
                String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
                throw new MMSQLException(msg);
            }
            while (this.previous()) {
            }
        }
    }

    public boolean absolute(int row) throws SQLException {
        if (!this.hasResults()) {
            throw new MMSQLException(JDBCPlugin.Util.getString("ResultsImpl.Null_results"));
        }
        if (row == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        this.checkClosed();
        if (this.getType() == 1003) {
            String msg = JDBCPlugin.Util.getString("ResultsImpl.Fwd_only");
            throw new MMSQLException(msg);
        }
        if (row > 0) {
            if (this.isValidRow()) {
                return this.relative(row - this.getRow());
            }
            this.first();
            --row;
        } else {
            this.last();
            ++row;
        }
        return this.relative(row);
    }

    public boolean first() throws SQLException {
        if (!this.hasResults()) {
            return false;
        }
        this.checkClosed();
        if (this.getType() == 1003) {
            String msg = JDBCPlugin.Util.getString("ResultsImpl.Op_invalid_fwd_only");
            throw new MMSQLException(msg);
        }
        if (this.isBeforeFirst()) {
            this.next();
        } else if (!this.isFirst()) {
            this.beforeFirst();
            this.next();
        }
        return this.getRow() == 1;
    }

    protected boolean isValidRow() throws SQLException {
        return this.getRow() != 0;
    }

    protected boolean hasResults() throws SQLException {
        return this.results != null;
    }

    protected Calendar getDefaultCalendar() {
        return this.statement.getDefaultCalendar();
    }
}

