/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.metadata;

import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TempMetadataStore
implements Serializable {
    private Map tempGroups;

    public TempMetadataStore() {
        this(new HashMap());
    }

    public TempMetadataStore(Map data) {
        this.tempGroups = data == null ? new HashMap() : data;
    }

    public Map getData() {
        return this.tempGroups;
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols) {
        return this.addTempGroup(tempGroup, tempSymbols, true);
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols, boolean isVirtual) {
        return this.addTempGroup(tempGroup, tempSymbols, isVirtual, false);
    }

    public TempMetadataID addTempGroup(String tempGroup, List tempSymbols, boolean isVirtual, boolean isTempTable) {
        String tempName = tempGroup.toUpperCase();
        ArrayList<TempMetadataID> elementIDs = new ArrayList<TempMetadataID>(tempSymbols.size());
        Iterator symbolIter = tempSymbols.iterator();
        while (symbolIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)symbolIter.next();
            TempMetadataID elementID = this.createElementSymbol(tempName, symbol, isTempTable);
            elementIDs.add(elementID);
        }
        TempMetadataID groupID = new TempMetadataID(tempName, tempGroup, elementIDs, isVirtual, isTempTable);
        this.tempGroups.put(tempName, groupID);
        return groupID;
    }

    private TempMetadataID createElementSymbol(String tempName, SingleElementSymbol symbol, boolean isTempTable) {
        String elementName = tempName + "." + symbol.getShortCanonicalName();
        Object metadataID = null;
        if (symbol instanceof AliasSymbol) {
            AliasSymbol as = (AliasSymbol)symbol;
            symbol = as.getSymbol();
        }
        if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
            Expression expr = ((ExpressionSymbol)symbol).getExpression();
            if (expr instanceof Reference) {
                expr = ((Reference)expr).getExpression();
            }
            if (expr instanceof ElementSymbol) {
                symbol = (ElementSymbol)expr;
            }
        }
        if (symbol instanceof ElementSymbol) {
            metadataID = ((ElementSymbol)symbol).getMetadataID();
        }
        while (metadataID != null && metadataID instanceof TempMetadataID) {
            metadataID = ((TempMetadataID)metadataID).getOriginalMetadataID();
        }
        TempMetadataID elementID = new TempMetadataID(elementName, symbol.getType(), metadataID);
        elementID.setTempTable(isTempTable);
        return elementID;
    }

    public TempMetadataID addElementSymbolToTempGroup(String tempGroup, SingleElementSymbol symbol) {
        String tempName = tempGroup.toUpperCase();
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(tempName);
        if (groupID != null) {
            TempMetadataID elementID = this.createElementSymbol(tempName, symbol, false);
            groupID.addElement(elementID);
            return elementID;
        }
        return null;
    }

    public void addTempGroups(Map tempGroupMap) {
        if (tempGroupMap != null && tempGroupMap.size() > 0) {
            Iterator keyIter = tempGroupMap.keySet().iterator();
            while (keyIter.hasNext()) {
                String tempGroupName = (String)keyIter.next();
                TempMetadataID groupID = (TempMetadataID)tempGroupMap.get(tempGroupName);
                this.tempGroups.put(tempGroupName, groupID);
            }
        }
    }

    public TempMetadataID getTempGroupID(String tempGroup) {
        return (TempMetadataID)this.tempGroups.get(tempGroup.toUpperCase());
    }

    public TempMetadataID getTempElementID(String tempElement) {
        int index = tempElement.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        String groupName = tempElement.substring(0, index);
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(groupName.toUpperCase());
        if (groupID != null) {
            Iterator elementIter = groupID.getElements().iterator();
            while (elementIter.hasNext()) {
                TempMetadataID elementID = (TempMetadataID)elementIter.next();
                if (!elementID.getID().equalsIgnoreCase(tempElement)) continue;
                return elementID;
            }
        }
        return null;
    }

    public List getTempElementElementIDs(String tempGroup) {
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(tempGroup.toUpperCase());
        if (groupID != null) {
            return groupID.getElements();
        }
        return null;
    }

    public void addElementToTempGroup(String tempGroup, ElementSymbol symbol) {
        TempMetadataID groupID = (TempMetadataID)this.tempGroups.get(tempGroup.toUpperCase());
        if (groupID != null) {
            groupID.getElements().add(symbol.getMetadataID());
        }
    }

    public void removeTempGroup(String tempGroup) {
        this.tempGroups.remove(tempGroup.toUpperCase());
    }
}

