/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.AbstractCompareCriteria;
import com.metamatrix.query.sql.symbol.Expression;

public class CompareCriteria
extends AbstractCompareCriteria {
    private Expression rightExpression;

    public CompareCriteria() {
    }

    public CompareCriteria(Expression leftExpression, int operator, Expression rightExpression) {
        this.set(leftExpression, operator, rightExpression);
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void set(Expression leftExpression, int operator, Expression rightExpression) {
        this.setLeftExpression(leftExpression);
        this.setOperator(operator);
        this.setRightExpression(rightExpression);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode(hc, this.getOperator());
        hc = HashCodeUtil.hashCode(hc, this.getLeftExpression());
        hc = HashCodeUtil.hashCode(hc, this.getRightExpression());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        CompareCriteria cc = (CompareCriteria)obj;
        return this.getOperator() == cc.getOperator() && EquivalenceUtil.areEqual(this.getLeftExpression(), cc.getLeftExpression()) && EquivalenceUtil.areEqual(this.getRightExpression(), cc.getRightExpression());
    }

    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Expression rightCopy = null;
        if (this.getRightExpression() != null) {
            rightCopy = (Expression)this.getRightExpression().clone();
        }
        return new CompareCriteria(leftCopy, this.getOperator(), rightCopy);
    }
}

