/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.query.xquery.XQueryExpression;
import java.util.ArrayList;
import java.util.List;

public class XQuery
extends Command {
    private String xQuery;
    private XQueryExpression compiledXQuery;

    public XQuery() {
    }

    public XQuery(String xQuery, XQueryExpression compiledXQuery) {
        this.xQuery = xQuery;
        this.compiledXQuery = compiledXQuery;
    }

    public String getXQuery() {
        return this.xQuery;
    }

    public XQueryExpression getCompiledXQuery() {
        return this.compiledXQuery;
    }

    public int getType() {
        return 8;
    }

    public List getProjectedSymbols() {
        ArrayList<ElementSymbol> selectList = new ArrayList<ElementSymbol>(1);
        ElementSymbol xmlElement = new ElementSymbol("xml");
        xmlElement.setType(DataTypeManager.DefaultDataClasses.XML);
        selectList.add(xmlElement);
        return selectList;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getXQuery(), ((XQuery)obj).getXQuery());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(0, this.getXQuery());
    }

    public Object clone() {
        XQuery copy = new XQuery(this.getXQuery(), this.compiledXQuery);
        this.copyMetadataState(copy);
        return copy;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean areResultsCachable() {
        return false;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return 2;
    }
}

