/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.MultiSourcePackage;
import org.eclipse.osgi.framework.internal.core.NullPackageSource;
import org.eclipse.osgi.framework.internal.core.PackageSource;
import org.eclipse.osgi.framework.internal.core.PolicyHandler;
import org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleLoader
implements ClassLoaderDelegate {
    public static final String DEFAULT_PACKAGE = ".";
    public static final String JAVA_PACKAGE = "java.";
    public static final byte FLAG_IMPORTSINIT = 1;
    public static final byte FLAG_HASDYNAMICIMPORTS = 2;
    public static final byte FLAG_HASDYNAMICEIMPORTALL = 4;
    public static final byte FLAG_CLOSED = 8;
    public static final ClassContext CLASS_CONTEXT = (ClassContext)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ClassContext();
        }
    });
    public static final ClassLoader FW_CLASSLOADER;
    BundleLoaderProxy proxy;
    BundleHost bundle;
    BundleClassLoader classloader;
    ClassLoader parent;
    KeyedHashSet importedSources;
    KeyedHashSet requiredSources;
    String[] dynamicImportPackageStems;
    String[] dynamicImportPackages;
    ArrayList exportedPackages;
    BundleLoaderProxy[] requiredBundles;
    int[] reexportTable;
    byte loaderFlags = 0;
    private PolicyHandler policy;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$Framework;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$internal$core$BundleLoader;

    public static final String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return DEFAULT_PACKAGE;
    }

    public static final String getResourcePackageName(String name) {
        if (name != null) {
            int begin = name.length() > 1 && name.charAt(0) == '/' ? 1 : 0;
            int end = name.lastIndexOf(47);
            if (end > begin) {
                return name.substring(begin, end).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    protected BundleLoader(BundleHost bundle, BundleLoaderProxy proxy) throws BundleException {
        this.bundle = bundle;
        this.proxy = proxy;
        try {
            bundle.getBundleData().open();
        }
        catch (IOException e) {
            throw new BundleException(Msg.BUNDLE_READ_EXCEPTION, e);
        }
        this.initialize(proxy.getBundleDescription());
    }

    final void initialize(BundleDescription description) {
        int i;
        Bundle[] fragmentObjects;
        ExportPackageDescription[] exports;
        BundleDescription[] required = description.getResolvedRequires();
        if (required.length > 0) {
            HashSet<String> reExportSet = new HashSet<String>(required.length);
            BundleSpecification[] requiredSpecs = description.getRequiredBundles();
            if (requiredSpecs != null && requiredSpecs.length > 0) {
                for (int i2 = 0; i2 < requiredSpecs.length; ++i2) {
                    if (!requiredSpecs[i2].isExported()) continue;
                    reExportSet.add(requiredSpecs[i2].getName());
                }
            }
            this.requiredBundles = new BundleLoaderProxy[required.length];
            int[] reexported = new int[required.length];
            int reexportIndex = 0;
            for (int i3 = 0; i3 < required.length; ++i3) {
                this.requiredBundles[i3] = this.getLoaderProxy(required[i3]);
                if (!reExportSet.contains(required[i3].getSymbolicName())) continue;
                reexported[reexportIndex++] = i3;
            }
            if (reexportIndex > 0) {
                this.reexportTable = new int[reexportIndex];
                System.arraycopy(reexported, 0, this.reexportTable, 0, reexportIndex);
            }
        }
        if ((exports = description.getSelectedExports()) != null && exports.length > 0) {
            this.exportedPackages = new ArrayList(exports.length);
            for (int i4 = 0; i4 < exports.length; ++i4) {
                if (this.exportedPackages.contains(exports[i4].getName())) continue;
                this.exportedPackages.add(exports[i4].getName());
                this.proxy.createPackageSource(exports[i4], true);
            }
        }
        BundleDescription[] fragments = new BundleDescription[(fragmentObjects = this.bundle.getFragments()) == null ? 0 : fragmentObjects.length];
        for (i = 0; i < fragments.length; ++i) {
            fragments[i] = ((AbstractBundle)fragmentObjects[i]).getBundleDescription();
        }
        if (description.hasDynamicImports()) {
            this.addDynamicImportPackage(description.getImportPackages());
        }
        for (i = 0; i < fragments.length; ++i) {
            if (!fragments[i].isResolved() || !fragments[i].hasDynamicImports()) continue;
            this.addDynamicImportPackage(fragments[i].getImportPackages());
        }
        try {
            String buddyList = null;
            buddyList = (String)this.bundle.getBundleData().getManifest().get("Eclipse-BuddyPolicy");
            if (buddyList != null) {
                this.policy = new PolicyHandler(this, buddyList);
            }
        }
        catch (BundleException e) {
            // empty catch block
        }
    }

    private synchronized void addImportedPackages(ExportPackageDescription[] packages) {
        if ((this.loaderFlags & 1) != 0) {
            return;
        }
        if (packages != null && packages.length > 0) {
            if (this.importedSources == null) {
                this.importedSources = new KeyedHashSet(packages.length, false);
            }
            for (int i = 0; i < packages.length; ++i) {
                PackageSource source = this.createExportPackageSource(packages[i]);
                if (source == null) continue;
                this.importedSources.add(source);
            }
        }
        this.loaderFlags = (byte)(this.loaderFlags | 1);
    }

    final PackageSource createExportPackageSource(ExportPackageDescription export) {
        BundleLoaderProxy exportProxy = this.getLoaderProxy(export.getExporter());
        if (exportProxy == null) {
            return null;
        }
        PackageSource requiredSource = exportProxy.getBundleLoader().findRequiredSource(export.getName());
        PackageSource exportSource = exportProxy.createPackageSource(export, false);
        if (requiredSource == null) {
            return exportSource;
        }
        return BundleLoader.createMultiSource(export.getName(), new PackageSource[]{requiredSource, exportSource});
    }

    private static PackageSource createMultiSource(String packageName, PackageSource[] sources) {
        if (sources.length == 1) {
            return sources[0];
        }
        ArrayList<SingleSourcePackage> sourceList = new ArrayList<SingleSourcePackage>(sources.length);
        for (int i = 0; i < sources.length; ++i) {
            SingleSourcePackage[] innerSources = sources[i].getSuppliers();
            for (int j = 0; j < innerSources.length; ++j) {
                if (sourceList.contains(innerSources[j])) continue;
                sourceList.add(innerSources[j]);
            }
        }
        return new MultiSourcePackage(packageName, sourceList.toArray(new SingleSourcePackage[sourceList.size()]));
    }

    final BundleLoaderProxy getLoaderProxy(BundleDescription source) {
        BundleLoaderProxy sourceProxy = (BundleLoaderProxy)source.getUserObject();
        if (sourceProxy == null) {
            long exportingID = source.getBundleId();
            BundleHost exportingBundle = (BundleHost)this.bundle.framework.getBundle(exportingID);
            if (exportingBundle == null) {
                return null;
            }
            sourceProxy = exportingBundle.getLoaderProxy();
        }
        return sourceProxy;
    }

    void close() {
        if ((this.loaderFlags & 8) != 0) {
            return;
        }
        if (this.classloader != null) {
            this.classloader.close();
        }
        if (this.policy != null) {
            this.policy.close();
            this.policy = null;
        }
        this.loaderFlags = (byte)(this.loaderFlags | 8);
    }

    final Class loadClass(String name) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(name);
    }

    final URL getResource(String name) {
        return this.createClassLoader().getResource(name);
    }

    final Enumeration getResources(String name) throws IOException {
        return this.createClassLoader().getResources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final BundleClassLoader createClassLoader() {
        if (this.classloader != null) {
            return this.classloader;
        }
        BundleLoader bundleLoader = this;
        synchronized (bundleLoader) {
            if (this.classloader != null) {
                return this.classloader;
            }
            try {
                String[] classpath = this.bundle.getBundleData().getClassPath();
                if (classpath != null) {
                    BundleClassLoader bcl = this.createBCLPrevileged(this.bundle.getProtectionDomain(), classpath);
                    this.parent = this.getParentPrivileged(bcl);
                    this.classloader = bcl;
                } else {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, new BundleException(Msg.BUNDLE_NO_CLASSPATH_MATCH));
                }
            }
            catch (BundleException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
            }
        }
        return this.classloader;
    }

    Class findLocalClass(String name) {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + name + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(name);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    Class findClass(String name, boolean checkParent) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + name + ")");
        }
        String pkgName = BundleLoader.getPackageName(name);
        if (checkParent && this.parent != null) {
            if (name.startsWith(JAVA_PACKAGE)) {
                return this.parent.loadClass(name);
            }
            if (this.isBootDelegationPackage(pkgName)) {
                try {
                    return this.parent.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
        }
        Class<?> result = null;
        PackageSource source = this.findImportedSource(pkgName);
        if (source != null) {
            result = source.loadClass(name);
            if (result != null) {
                return result;
            }
            throw new ClassNotFoundException(name);
        }
        source = this.findRequiredSource(pkgName);
        if (source != null) {
            result = source.loadClass(name);
        }
        if (result == null) {
            result = this.findLocalClass(name);
        }
        if (result != null) {
            return result;
        }
        source = this.findDynamicSource(pkgName);
        if (source != null) {
            result = source.loadClass(name);
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyClassLoading(name);
        }
        if (result == null && this.findParentResource(name)) {
            result = this.parent.loadClass(name);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private boolean findParentResource(String name) {
        if (this.bundle.framework.bootDelegateAll || !this.bundle.framework.contextBootDelegation) {
            return false;
        }
        Class[] context = CLASS_CONTEXT.getClassContext();
        if (context == null || context.length < 2) {
            return false;
        }
        for (int i = 1; i < context.length; ++i) {
            ClassLoader cl;
            Class clazz = context[i];
            Class<?> clazz2 = class$org$eclipse$osgi$framework$internal$core$BundleLoader;
            if (clazz2 == null) {
                clazz2 = new BundleLoader[0].getClass().getComponentType();
            }
            if (clazz == clazz2) continue;
            Class<?> clazz3 = class$java$lang$ClassLoader;
            if (clazz3 == null) {
                clazz3 = new ClassLoader[0].getClass().getComponentType();
            }
            if (clazz3.isAssignableFrom(context[i]) || (cl = BundleLoader.getClassLoader(context[i])) == FW_CLASSLOADER) continue;
            Class<?> clazz4 = class$java$lang$Class;
            if (clazz4 == null) {
                clazz4 = class$java$lang$Class = new Class[0].getClass().getComponentType();
            }
            if (clazz4 == context[i] || cl instanceof BundleClassLoader) break;
            return true;
        }
        return false;
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    final boolean isClosed() {
        return (this.loaderFlags & 8) != 0;
    }

    public URL findResource(String name) {
        return this.findResource(name, true);
    }

    URL findResource(String name, boolean checkParent) {
        URL result;
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        if (checkParent && this.parent != null) {
            if (pkgName.startsWith(JAVA_PACKAGE)) {
                return this.parent.getResource(name);
            }
            if (this.isBootDelegationPackage(pkgName) && (result = this.parent.getResource(name)) != null) {
                return result;
            }
        }
        result = null;
        PackageSource source = this.findImportedSource(pkgName);
        if (source != null) {
            return source.getResource(name);
        }
        source = this.findRequiredSource(pkgName);
        if (source != null) {
            result = source.getResource(name);
        }
        if (result == null) {
            result = this.findLocalResource(name);
        }
        if (result != null) {
            return result;
        }
        source = this.findDynamicSource(pkgName);
        if (source != null) {
            result = source.getResource(name);
        }
        if (result == null && this.policy != null) {
            return this.policy.doBuddyResourceLoading(name);
        }
        if (result == null && this.findParentResource(name)) {
            result = this.parent.getResource(name);
        }
        return result;
    }

    private boolean isBootDelegationPackage(String name) {
        int i;
        if (this.bundle.framework.bootDelegateAll) {
            return true;
        }
        if (this.bundle.framework.bootDelegation != null) {
            for (i = 0; i < this.bundle.framework.bootDelegation.length; ++i) {
                if (!name.equals(this.bundle.framework.bootDelegation[i])) continue;
                return true;
            }
        }
        if (this.bundle.framework.bootDelegationStems != null) {
            for (i = 0; i < this.bundle.framework.bootDelegationStems.length; ++i) {
                if (!name.startsWith(this.bundle.framework.bootDelegationStems[i])) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration findResources(String name) throws IOException {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        String pkgName = BundleLoader.getResourcePackageName(name);
        Enumeration result = null;
        PackageSource source = this.findImportedSource(pkgName);
        if (source != null) {
            return source.getResources(name);
        }
        source = this.findRequiredSource(pkgName);
        if (source != null) {
            result = source.getResources(name);
        }
        if (result == null) {
            result = this.findLocalResources(name);
        }
        if (result != null) {
            return result;
        }
        source = this.findDynamicSource(pkgName);
        if (source != null) {
            result = source.getResources(name);
        }
        if (result == null && this.policy != null) {
            result = this.policy.doBuddyResourcesLoading(name);
        }
        return result;
    }

    URL findLocalResource(String name) {
        return this.createClassLoader().findLocalResource(name);
    }

    Enumeration findLocalResources(String name) {
        return this.createClassLoader().findLocalResources(name);
    }

    public String findLibrary(final String name) {
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(name);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(name);
            }
        });
    }

    final String findLocalLibrary(String name) {
        String result = this.bundle.getBundleData().findLibrary(name);
        if (result != null) {
            return result;
        }
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        for (int i = 0; i < fragments.length; ++i) {
            result = ((AbstractBundle)fragments[i]).getBundleData().findLibrary(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    final AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final BundleProtectionDomain pd, final String[] cp) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(pd, cp);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(pd, cp);
            }
        });
    }

    BundleClassLoader createBCL(BundleProtectionDomain pd, String[] cp) {
        BundleClassLoader bcl = this.bundle.getBundleData().createClassLoader(this, pd, cp);
        Bundle[] fragments = this.bundle.getFragments();
        if (fragments != null) {
            for (int i = 0; i < fragments.length; ++i) {
                AbstractBundle fragment = (AbstractBundle)fragments[i];
                try {
                    bcl.attachFragment(fragment.getBundleData(), fragment.domain, fragment.getBundleData().getClassPath());
                    continue;
                }
                catch (BundleException be) {
                    this.bundle.framework.publishFrameworkEvent(2, this.bundle, be);
                }
            }
        }
        bcl.initialize();
        return bcl;
    }

    public final String toString() {
        BundleData result = this.bundle.getBundleData();
        return result == null ? "BundleLoader.bundledata == null!" : result.toString();
    }

    final boolean isDynamicallyImported(String pkgname) {
        int i;
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (pkgname.startsWith(JAVA_PACKAGE)) {
            return true;
        }
        if ((this.loaderFlags & 2) == 0) {
            return false;
        }
        if ((this.loaderFlags & 4) != 0) {
            return true;
        }
        if (this.dynamicImportPackages != null) {
            for (i = 0; i < this.dynamicImportPackages.length; ++i) {
                if (!pkgname.equals(this.dynamicImportPackages[i])) continue;
                return true;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            for (i = 0; i < this.dynamicImportPackageStems.length; ++i) {
                if (!pkgname.startsWith(this.dynamicImportPackageStems[i])) continue;
                return true;
            }
        }
        return false;
    }

    final void addExportedProvidersFor(String symbolicName, String packageName, ArrayList result, KeyedHashSet visited) {
        if (!visited.add(this.bundle)) {
            return;
        }
        PackageSource local = null;
        if (this.isExportedPackage(packageName)) {
            local = this.proxy.getPackageSource(packageName);
        }
        if (this.requiredBundles != null) {
            int size = this.reexportTable == null ? 0 : this.reexportTable.length;
            int reexportIndex = 0;
            for (int i = 0; i < this.requiredBundles.length; ++i) {
                if (local != null) {
                    this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(symbolicName, packageName, result, visited);
                    continue;
                }
                if (reexportIndex >= size || this.reexportTable[reexportIndex] != i) continue;
                ++reexportIndex;
                this.requiredBundles[i].getBundleLoader().addExportedProvidersFor(symbolicName, packageName, result, visited);
            }
        }
        if (local != null && local.isFriend(symbolicName)) {
            if (local instanceof BundleLoaderProxy.ReexportPackageSource) {
                local = new SingleSourcePackage(packageName, -1, this.proxy);
            }
            result.add(local);
        }
    }

    final boolean isExportedPackage(String name) {
        if (this.exportedPackages == null) {
            return false;
        }
        if (name.startsWith("[L")) {
            name = name.substring(2);
        }
        return this.exportedPackages.contains(name);
    }

    private void addDynamicImportPackage(ImportPackageSpecification[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            if (!"dynamic".equals(packages[i].getDirective("resolution"))) continue;
            dynamicImports.add(packages[i].getName());
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    private void addDynamicImportPackage(String[] packages) {
        int i;
        ArrayList<String> names;
        ArrayList<String> stems;
        if (packages == null) {
            return;
        }
        this.loaderFlags = (byte)(this.loaderFlags | 2);
        if (this.importedSources == null) {
            this.importedSources = new KeyedHashSet(10, false);
        }
        if (packages == null) {
            return;
        }
        int size = packages.length;
        if (this.dynamicImportPackageStems == null) {
            stems = new ArrayList<String>(size);
        } else {
            stems = new ArrayList(size + this.dynamicImportPackageStems.length);
            for (int i2 = 0; i2 < this.dynamicImportPackageStems.length; ++i2) {
                stems.add(this.dynamicImportPackageStems[i2]);
            }
        }
        if (this.dynamicImportPackages == null) {
            names = new ArrayList<String>(size);
        } else {
            names = new ArrayList(size + this.dynamicImportPackages.length);
            for (i = 0; i < this.dynamicImportPackages.length; ++i) {
                names.add(this.dynamicImportPackages[i]);
            }
        }
        for (i = 0; i < size; ++i) {
            String name = packages[i];
            if (this.isDynamicallyImported(name)) continue;
            if (name.equals("*")) {
                this.loaderFlags = (byte)(this.loaderFlags | 4);
                return;
            }
            if (name.endsWith(".*")) {
                stems.add(name.substring(0, name.length() - 1));
                continue;
            }
            names.add(name);
        }
        size = stems.size();
        if (size > 0) {
            this.dynamicImportPackageStems = stems.toArray(new String[size]);
        }
        if ((size = names.size()) > 0) {
            this.dynamicImportPackages = names.toArray(new String[size]);
        }
    }

    public final void addDynamicImportPackage(ManifestElement[] packages) {
        if (packages == null) {
            return;
        }
        ArrayList<String> dynamicImports = new ArrayList<String>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            dynamicImports.add(packages[i].getValue());
        }
        if (dynamicImports.size() > 0) {
            this.addDynamicImportPackage(dynamicImports.toArray(new String[dynamicImports.size()]));
        }
    }

    final void attachFragment(BundleFragment fragment) throws BundleException {
        if (this.classloader == null) {
            return;
        }
        String[] classpath = fragment.getBundleData().getClassPath();
        if (classpath != null) {
            this.classloader.attachFragment(fragment.getBundleData(), fragment.domain, classpath);
        }
    }

    private PackageSource findSource(String pkgName) {
        if (pkgName == null) {
            return null;
        }
        PackageSource result = this.findImportedSource(pkgName);
        if (result != null) {
            return result;
        }
        result = this.findRequiredSource(pkgName);
        if (result == null) {
            result = this.findDynamicSource(pkgName);
        }
        return result;
    }

    private PackageSource findImportedSource(String pkgName) {
        if ((this.loaderFlags & 1) == 0) {
            this.addImportedPackages(this.proxy.getBundleDescription().getResolvedImports());
        }
        return this.importedSources == null ? null : (PackageSource)this.importedSources.getByKey(pkgName);
    }

    private PackageSource findDynamicSource(String pkgName) {
        ExportPackageDescription exportPackage;
        if (this.isDynamicallyImported(pkgName) && (exportPackage = this.bundle.framework.adaptor.getState().linkDynamicImport(this.proxy.getBundleDescription(), pkgName)) != null) {
            PackageSource source = this.createExportPackageSource(exportPackage);
            this.importedSources.add(source);
            return source;
        }
        return null;
    }

    private PackageSource findRequiredSource(String pkgName) {
        PackageSource result;
        if (this.requiredBundles == null) {
            return null;
        }
        if (this.requiredSources != null && (result = (PackageSource)this.requiredSources.getByKey(pkgName)) != null) {
            return result.isNullSource() ? null : result;
        }
        KeyedHashSet visited = new KeyedHashSet(false);
        ArrayList result2 = new ArrayList(3);
        for (int i = 0; i < this.requiredBundles.length; ++i) {
            BundleLoader requiredLoader = this.requiredBundles[i].getBundleLoader();
            requiredLoader.addExportedProvidersFor(this.proxy.getSymbolicName(), pkgName, result2, visited);
        }
        if (this.requiredSources == null) {
            this.requiredSources = new KeyedHashSet(10, false);
        }
        if (result2.size() == 0) {
            this.requiredSources.add(NullPackageSource.getNullPackageSource(pkgName));
            return null;
        }
        if (result2.size() == 1) {
            PackageSource source = (PackageSource)result2.get(0);
            this.requiredSources.add(source);
            return source;
        }
        PackageSource[] srcs = result2.toArray(new PackageSource[result2.size()]);
        PackageSource source = BundleLoader.createMultiSource(pkgName, srcs);
        this.requiredSources.add(source);
        return source;
    }

    final PackageSource getPackageSource(String pkgName) {
        PackageSource result = this.findSource(pkgName);
        if (!this.isExportedPackage(pkgName)) {
            return result;
        }
        PackageSource localSource = this.proxy.getPackageSource(pkgName);
        if (localSource instanceof BundleLoaderProxy.ReexportPackageSource) {
            localSource = new SingleSourcePackage(pkgName, -1, this.proxy);
        }
        if (result == null) {
            return localSource;
        }
        if (localSource == null) {
            return result;
        }
        return BundleLoader.createMultiSource(pkgName, new PackageSource[]{result, localSource});
    }

    private ClassLoader getParentPrivileged(final BundleClassLoader bcl) {
        if (System.getSecurityManager() == null) {
            return bcl.getParent();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bcl.getParent();
            }
        });
    }

    static {
        Class<?> clazz = class$org$eclipse$osgi$framework$internal$core$Framework;
        if (clazz == null) {
            clazz = class$org$eclipse$osgi$framework$internal$core$Framework = new Framework[0].getClass().getComponentType();
        }
        FW_CLASSLOADER = BundleLoader.getClassLoader(clazz);
    }

    private static final class ClassContext
    extends SecurityManager {
        private ClassContext() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

