/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import org.eclipse.osgi.framework.internal.core.DependentPolicy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class RegisteredPolicy
extends DependentPolicy {
    public RegisteredPolicy(BundleLoader requester) {
        super(requester);
        if (this.allDependents == null) {
            return;
        }
        Iterator iter = this.allDependents.iterator();
        while (iter.hasNext()) {
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)iter.next());
            if (proxy == null) {
                iter.remove();
            }
            try {
                String[] allContributions = ManifestElement.getArrayFromList((String)((AbstractBundle)proxy.getBundle()).getBundleData().getManifest().get("Eclipse-RegisterBuddy"));
                if (allContributions == null) {
                    iter.remove();
                    continue;
                }
                boolean contributes = false;
                for (int j = 0; j < allContributions.length && !contributes; ++j) {
                    if (!allContributions[j].equals(this.buddyRequester.bundle.getSymbolicName())) continue;
                    contributes = true;
                }
                if (contributes) continue;
                iter.remove();
            }
            catch (BundleException e) {
                iter.remove();
            }
        }
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class result = null;
        for (int i = 0; i < this.allDependents.size() && result == null; ++i) {
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)this.allDependents.get(i));
                if (proxy == null) continue;
                result = proxy.getBundleLoader().findClass(name, true);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return result;
    }

    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        for (int i = 0; i < this.allDependents.size() && result == null; ++i) {
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)this.allDependents.get(i));
            if (proxy == null) continue;
            result = proxy.getBundleLoader().findResource(name, true);
        }
        return result;
    }

    public Enumeration loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration result = null;
        for (int i = 0; i < this.allDependents.size() && result == null; ++i) {
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy((BundleDescription)this.allDependents.get(i));
                if (proxy == null) continue;
                result = proxy.getBundleLoader().findResources(name);
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return result;
    }
}

