/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sybase;

import com.metamatrix.connector.jdbc.sybase.SybaseSQLConversionVisitor;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageObject;

public class Sybase11SQLConversionVisitor
extends SybaseSQLConversionVisitor {
    public static final int SYBASE_LOJ = 100;
    public static final int SYBASE_ROJ = 101;

    public void visit(ICompareCriteria obj) {
        if (obj.getOperator() == 100 || obj.getOperator() == 101) {
            this.append((ILanguageObject)obj.getLeftExpression());
            this.buffer.append(" ");
            int op = obj.getOperator();
            switch (op) {
                case 100: {
                    this.buffer.append("*=");
                    break;
                }
                case 101: {
                    this.buffer.append("=*");
                }
            }
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getRightExpression());
        } else {
            super.visit(obj);
        }
    }

    public void visit(IJoin obj) {
        int type = obj.getJoinType();
        if (type != 1) {
            super.visit(obj);
            return;
        }
        IFromItem leftItem = obj.getLeftItem();
        if (leftItem instanceof IJoin) {
            this.buffer.append("(");
            this.append((ILanguageObject)leftItem);
            this.buffer.append(")");
        } else {
            this.append((ILanguageObject)leftItem);
        }
        this.buffer.append(" ").append("INNER").append(" ").append("JOIN").append(" ");
        IFromItem rightItem = obj.getRightItem();
        if (rightItem instanceof IJoin) {
            this.buffer.append("(");
            this.append((ILanguageObject)rightItem);
            this.buffer.append(")");
        } else {
            this.append((ILanguageObject)rightItem);
        }
        this.buffer.append(" ").append("ON").append(" ").append("1=1");
    }
}

