/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.http;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.SAXFilterProvider;
import com.metamatrix.connector.xml.XMLConnection;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentBuilder;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.RequestGenerator;
import com.metamatrix.connector.xml.base.RequestResponseDocumentProducer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.DocumentCache;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.http.HTTPConnectorState;
import com.metamatrix.connector.xml.http.HTTPRequestor;
import com.metamatrix.connector.xml.http.HTTPTrustDeserializer;
import com.metamatrix.connector.xml.http.HttpInfo;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.util.ParameterParser;
import org.jdom.Document;

public class HTTPExecutor
extends RequestResponseDocumentProducer {
    protected HTTPRequestor m_requestor;
    protected HttpMethod request;
    private HTTPConnectorState h_state;
    private boolean m_allowHttp500;
    public static final String PARM_INPUT_XPATH_TABLE_PROPERTY_NAME = "XPathRootForInput";
    public static final String PARM_INPUT_NAMESPACE_TABLE_PROPERTY_NAME = "NamespaceForDocument";

    public HTTPExecutor(XMLConnectorState state, XMLExecution execution) throws ConnectorException {
        super(state, execution);
        this.h_state = (HTTPConnectorState)state;
        this.m_requestor = new HTTPRequestor(this.getLogger(), this.h_state.getAccessMethod());
        this.setAllowHttp500(false);
        String proxyUri = this.getProxyUri();
        String uri = null;
        uri = proxyUri != null && proxyUri.length() > 0 ? proxyUri : this.buildRawUriString();
        try {
            this.m_requestor.validateURL(uri);
        }
        catch (IOException ioe) {
            throw new ConnectorException((Throwable)ioe);
        }
        this.getLogger().logDetail(Messages.getString((String)"HTTPExecutor.url.validated"));
    }

    public void releaseDocumentStream(int i) throws ConnectorException {
        if (this.request != null) {
            this.request.releaseConnection();
            this.request = null;
        }
    }

    public int getDocumentCount() throws ConnectorException {
        return 1;
    }

    public String getCacheKey(int i) throws ConnectorException {
        if (this.request == null) {
            String message = Messages.getString((String)"HttpExecutor.cannot.create.cachekey");
            throw new ConnectorException(message);
        }
        String userName = this.getExecution().getConnection().getUser();
        String session = this.getExecution().getConnection().getQueryId();
        StringBuffer cacheKey = new StringBuffer();
        cacheKey.append("|");
        cacheKey.append(userName);
        cacheKey.append("|");
        cacheKey.append(session);
        cacheKey.append("|");
        cacheKey.append(this.buildUriString());
        cacheKey.append("|");
        if (this.request instanceof PostMethod) {
            NameValuePair[] pairs = ((PostMethod)this.request).getParameters();
            if (pairs == null || pairs.length == 0) {
                if (((PostMethod)this.request).getRequestEntity() != null) {
                    String requestBodyAsString = ((StringRequestEntity)((PostMethod)this.request).getRequestEntity()).getContent();
                    cacheKey.append(requestBodyAsString);
                }
            } else {
                cacheKey.append(this.generatePairString(pairs));
            }
        } else {
            cacheKey.append(this.request.getQueryString());
        }
        return cacheKey.toString();
    }

    public InputStream getDocumentStream(int i) throws ConnectorException {
        HttpClient client = ((HTTPConnectorState)this.getState()).getClient();
        XMLConnection conn = this.getExecution().getConnection();
        try {
            HTTPTrustDeserializer ser = (HTTPTrustDeserializer)conn.getTrustedPayloadHandler();
            ser.modifyRequest(client, this.request);
        }
        catch (ClassCastException cce) {
            throw new ConnectorException(Messages.getString((String)"HTTPExecutor.class.not.instance.of.HTTPTrustDeserializer"));
        }
        catch (Exception e) {
            ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.create.trust.deserializer"));
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        this.modifyRequest(client, this.request);
        InputStream responseBody = this.m_requestor.fetchXMLDocument(client, this.request, this.getAllowHttp500());
        return responseBody;
    }

    public Response getXMLResponse(int invocationNumber) throws ConnectorException {
        this.createRequests();
        CachingConnector connector = this.getExecution().getConnection().getConnector();
        IDocumentCache cache = this.getExecution().getCache();
        ExecutionContext exeContext = this.getExecution().getExeContext();
        String requestID = exeContext.getRequestIdentifier();
        String partID = exeContext.getPartIdentifier();
        String executionID = exeContext.getExecutionCountIdentifier();
        String cacheReference = requestID + partID + executionID + Integer.toString(invocationNumber);
        CriteriaDesc criterion = this.getExecutionInfo().getResponseIDCriterion();
        if (null != criterion) {
            String responseid = (String)criterion.getValues().get(0);
            this.getExecution().getConnection().getConnector().createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), responseid);
            return new Response(responseid, (DocumentProducer)this, cache, this.h_state.isErrorOnRecreateDoc(), cacheReference);
        }
        int documentCount = this.getDocumentCount();
        String[] cacheKeys = new String[documentCount];
        XMLDocument[] docs = new XMLDocument[documentCount];
        for (int i = 0; i < documentCount; ++i) {
            String cacheKey = this.getCacheKey(i);
            XMLDocument doc = DocumentCache.cacheLookup((IDocumentCache)cache, (String)cacheKey, (String)cacheReference);
            if (doc == null) {
                String documentDistinguishingId = "";
                if (documentCount > 1) {
                    documentDistinguishingId = new Integer(i).toString();
                }
                SAXFilterProvider provider = null;
                provider = this.h_state.getSAXFilterProvider();
                InputStream responseBody = this.getDocumentStream(i);
                InputStream filteredStream = this.addStreamFilters(responseBody, this.getLogger());
                DocumentInfo info = this.xmlExtractor.createDocumentFromStream(filteredStream, documentDistinguishingId, provider);
                Document domDoc = info.m_domDoc;
                doc = new XMLDocument((Object)domDoc, info.m_externalFiles);
                cache.addToCache(cacheKey, (Object)doc, info.m_memoryCacheSize, cacheReference);
                connector.createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), cacheKey);
            }
            docs[i] = doc;
            cacheKeys[i] = cacheKey;
        }
        return new Response(docs, cacheKeys, (DocumentProducer)this, cache, this.h_state.isErrorOnRecreateDoc(), cacheReference);
    }

    private void createRequests() throws ConnectorException {
        if (HTTPExecutor.checkIfRequestIsNeeded((ExecutionInfo)this.getExecutionInfo())) {
            String uriString = this.buildUriString();
            this.setRequests(this.getExecutionInfo().getParameters(), uriString);
        }
    }

    protected void modifyRequest(HttpClient client, HttpMethod method) throws ConnectorException {
    }

    public boolean cannotProjectParameter(CriteriaDesc parmCriteria) {
        return parmCriteria.getNumberOfValues() > 1 && parmCriteria.isUnlimited() && ((HTTPConnectorState)this.getState()).getParameterMethod() != "Name/Value";
    }

    protected Document buildInputXMLDocument(List parameters, String inputParmsXPath) throws ConnectorException {
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty("NamespacePrefixes");
        DocumentBuilder builder = new DocumentBuilder();
        return builder.buildDocument(parameters, inputParmsXPath, namespacePrefixes);
    }

    protected NameValuePair[] createNameValuePairs(List paramPairs) throws ConnectorException {
        NameValuePair[] pairs = new NameValuePair[paramPairs.size()];
        for (int i = 0; i < pairs.length; ++i) {
            NameValuePair pair;
            CriteriaDesc cd = (CriteriaDesc)paramPairs.get(i);
            String name = cd.getInputXpath() == null || cd.getInputXpath().length() == 0 ? cd.getColumnName() : cd.getInputXpath();
            pairs[i] = pair = new NameValuePair(name, cd.getCurrentIndexValue());
        }
        return pairs;
    }

    private String getProxyUri() {
        String proxyUri = ((HTTPConnectorState)this.getState()).getProxyUri();
        return proxyUri;
    }

    protected void setRequests(List params, String bindingURIValue) throws ConnectorException {
        String xmlDoc = null;
        HTTPConnectorState state = (HTTPConnectorState)this.getState();
        if (state.getParameterMethod() == "None" || params.size() == 0) {
            this.getLogger().logTrace("XML Connector Framework: no parameters for request");
        }
        ArrayList requestPerms = RequestGenerator.getRequestPerms((List)params);
        for (int i = 0; i < requestPerms.size(); ++i) {
            NameValuePair[] pairs = null;
            String bindingURI = null;
            String bindingQueryString = null;
            if (-1 != bindingURIValue.indexOf(63)) {
                bindingURI = bindingURIValue.substring(1, bindingURIValue.indexOf(63));
                bindingQueryString = bindingURIValue.substring(bindingURIValue.indexOf(63) + 1, bindingURIValue.length() - 1);
            } else {
                bindingURI = bindingURIValue;
            }
            if (-1 != bindingURI.indexOf("<") || -1 != bindingURI.indexOf("<")) {
                bindingURI = this.removeAngleBrackets(bindingURI);
            }
            CriteriaDesc[] queryParameters = (CriteriaDesc[])requestPerms.get(i);
            List<CriteriaDesc> newList = Arrays.asList(queryParameters);
            ArrayList<CriteriaDesc> queryList = new ArrayList<CriteriaDesc>(newList);
            String parameterMethod = state.getParameterMethod();
            if (parameterMethod == "XMLRequest" || parameterMethod == "XMLInQueryString") {
                xmlDoc = this.createXMLRequestDocString(queryList);
                String paramName = state.getXmlParameterName();
                if (null != paramName && (pairs = new NameValuePair[]{new NameValuePair(state.getXmlParameterName(), xmlDoc)}) != null) {
                    this.attemptConditionalLog("XML Connector Framework: request parameters -\n " + this.generatePairString(pairs));
                }
            } else if (parameterMethod == "Name/Value" || parameterMethod == "None") {
                pairs = this.createNameValuePairs(queryList);
            }
            HttpMethod method = null;
            String accessMethod = state.getAccessMethod();
            if (accessMethod.equals("POST")) {
                method = this.m_requestor.generateMethod(bindingURI);
                PostMethod post = (PostMethod)method;
                if (pairs == null) {
                    if (bindingQueryString != null) {
                        pairs = this.getPairsFromQueryString(xmlDoc, bindingQueryString);
                        post.addParameters(pairs);
                        this.attemptConditionalLog("XML Connector Framework: request parameters -\n " + this.generatePairString(pairs));
                    } else {
                        post.setRequestEntity((RequestEntity)new StringRequestEntity(xmlDoc));
                        this.attemptConditionalLog("XML Connector Framework: request body set to: " + xmlDoc);
                    }
                } else if (parameterMethod == "XMLInQueryString") {
                    StringBuffer requestEntity = new StringBuffer();
                    if (null != bindingQueryString) {
                        requestEntity.append(bindingQueryString);
                        requestEntity.append('&');
                    }
                    requestEntity.append(state.getXmlParameterName());
                    requestEntity.append('=');
                    requestEntity.append(xmlDoc);
                    URI realURI = null;
                    try {
                        realURI = new URI(bindingURI + "?" + URLEncoder.encode(requestEntity.toString()));
                        String fullQueryString = realURI.toString();
                        method = this.m_requestor.generateMethod(fullQueryString);
                        this.attemptConditionalLog("XML Connector Framework: request set to -\n " + fullQueryString);
                    }
                    catch (URISyntaxException e) {
                        throw new ConnectorException(e.getMessage());
                    }
                } else {
                    if (null != bindingQueryString) {
                        NameValuePair[] bindingPairs = this.getPairsFromQueryString(xmlDoc, bindingQueryString);
                        pairs = this.combinePairArrays(pairs, bindingPairs);
                    }
                    post.addParameters(pairs);
                    this.attemptConditionalLog("XML Connector Framework: request parameters -\n " + this.generatePairString(pairs));
                }
            } else if (accessMethod.equals("GET")) {
                method = this.m_requestor.generateMethod(bindingURI);
                if (pairs == null) {
                    throw new ConnectorException(Messages.getString((String)"HTTPExecutor.parameter.name.required.for.get"));
                }
                if (null != bindingQueryString && bindingQueryString.length() != 0) {
                    NameValuePair[] bindingPairs = this.getPairsFromQueryString(xmlDoc, bindingQueryString);
                    pairs = this.combinePairArrays(pairs, bindingPairs);
                }
                this.addGetValues(pairs, method);
                this.attemptConditionalLog("XML Connector Framework: request paramters -\n " + this.generatePairString(pairs));
            }
            this.request = method;
            this.getLogger().logInfo("XML Connector Framework: request created");
        }
    }

    protected void addGetValues(NameValuePair[] pairs, HttpMethod method) throws ConnectorException {
        method.setQueryString(pairs);
    }

    protected void addPostValues(NameValuePair[] pairs, PostMethod method) throws ConnectorException {
        method.addParameters(pairs);
    }

    protected Document createXMLRequestDoc(List parameterPairs) throws ConnectorException {
        Properties props = this.getExecutionInfo().getOtherProperties();
        String inputParmsXPath = props.getProperty(PARM_INPUT_XPATH_TABLE_PROPERTY_NAME);
        Document inputXMLDoc = this.buildInputXMLDocument(parameterPairs, inputParmsXPath);
        return inputXMLDoc;
    }

    protected String createXMLRequestDocString(List parameterPairs) throws ConnectorException {
        Document inputXMLDoc = this.createXMLRequestDoc(parameterPairs);
        String xmlStr = HTTPRequestor.outputStringFromDoc((Document)inputXMLDoc);
        return xmlStr;
    }

    private String generatePairString(NameValuePair[] pairs) {
        StringBuffer pairString = new StringBuffer();
        for (int j = 0; j < pairs.length; ++j) {
            if (j > 0) {
                pairString.append("&");
            }
            pairString.append(pairs[j].getName());
            pairString.append("=");
            pairString.append(pairs[j].getValue());
        }
        return pairString.toString();
    }

    private NameValuePair[] combinePairArrays(NameValuePair[] pairs, NameValuePair[] bindingPairs) {
        NameValuePair[] allPairs = new NameValuePair[bindingPairs.length + pairs.length];
        System.arraycopy(bindingPairs, 0, allPairs, 0, bindingPairs.length);
        System.arraycopy(pairs, 0, allPairs, bindingPairs.length, pairs.length);
        return allPairs;
    }

    private NameValuePair[] getPairsFromQueryString(String xmlDoc, String bindingQueryString) {
        ParameterParser parser = new ParameterParser();
        List bindingQueryParams = parser.parse(bindingQueryString, '=');
        bindingQueryParams.add(new NameValuePair(null, xmlDoc));
        NameValuePair[] pairs = (NameValuePair[])bindingQueryParams.toArray();
        return pairs;
    }

    protected NameValuePair[] generatePairs(String pairString) {
        int numPairs = 1;
        String dummy = pairString;
        while (dummy.indexOf(38) >= 0) {
            ++numPairs;
            dummy = dummy.substring(dummy.indexOf(38));
        }
        NameValuePair[] pairs = new NameValuePair[numPairs];
        dummy = pairString;
        int ctr = 0;
        if (numPairs > 1) {
            String value;
            String name;
            while (dummy.indexOf(38) >= 0) {
                name = dummy.substring(0, dummy.indexOf(61));
                value = dummy.substring(dummy.indexOf(61), dummy.indexOf(38));
                pairs[ctr] = new NameValuePair(name, value);
                ++ctr;
            }
            name = dummy.substring(0, dummy.indexOf(61));
            value = dummy.substring(dummy.indexOf(61), dummy.indexOf(38));
            pairs[ctr] = new NameValuePair(name, value);
        }
        return pairs;
    }

    public Serializable getRequestObject(int i) throws ConnectorException {
        HttpMethod method = this.request;
        HttpInfo newInfo = new HttpInfo();
        newInfo.m_distinguishingId = i;
        try {
            newInfo.m_uri = method.getURI().getEscapedURI();
        }
        catch (URIException urie) {
            ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.recreate.uri"));
            ce.setStackTrace(urie.getStackTrace());
            throw ce;
        }
        if (method instanceof GetMethod) {
            newInfo.m_request = method.getQueryString();
            newInfo.m_method = "GET";
            newInfo.m_paramMethod = null;
        } else {
            newInfo.m_method = "POST";
            NameValuePair[] pairs = ((PostMethod)method).getParameters();
            if (pairs == null) {
                newInfo.m_paramMethod = "ResponseBody";
                newInfo.m_request = ((StringRequestEntity)((PostMethod)method).getRequestEntity()).getContent();
                if (newInfo.m_request == null) {
                    ConnectorException ce = new ConnectorException(Messages.getString((String)"HTTPExecutor.unable.to.recreate.request"));
                    throw ce;
                }
            } else {
                newInfo.m_paramMethod = "NameValuePairs";
                newInfo.m_request = this.generatePairString(pairs);
            }
        }
        return newInfo;
    }

    public void setAllowHttp500(boolean allowHttp500) {
        this.m_allowHttp500 = allowHttp500;
    }

    public boolean getAllowHttp500() {
        return this.m_allowHttp500;
    }
}

