#! /bin/sh
. locations.include
# Hacked by bv@bnl.gov from the originals at
# Hacked by csieh@fnal.gov from the originals at
# ftp://apt-rpm.tuxfamily.org/pub/ftp.tuxfamily.org/apt-rpm/scripts/
# to be more generic.

# Relative directory from the top of the apt repository to the top of the mirror
#MIRRORDIR=../mirror
MIRRORDIR=.

# The idea of full/all/quick is:
#	* the first time you create the apt repository, choose "full".
#	* each night (when updates are downloaded), relaunch with "quick"
#	* if extra packages are put in 'extra' repository, relaunch with "quick"
#	* if the main os packages change (should not), use "all"

if [ $# -ne 2 -o \( "$1" != "full" -a "$1" != "all" -a "$1" != "quick" \) ]; then
	echo "Usage: $0 <mode> <default> "
	echo "  <mode> is one of:"
	echo "        \"full\": full apt repository creation"
	echo "        \"all\": no apt repository creation, but full indexes regeneration"
	echo "        \"quick\": no apt repository creation, only updates indexes regeneration"
	exit 1
fi

MODE=$1
#getting from locations.include
DEFAULT=$2

if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $RELEASEDIR/$ARCH/apt-rpm/base || exit 1

	# Create the main release file
	cat >$RELEASEDIR/$ARCH/apt-rpm/base/release <<EOF
Origin: ftp.scientificlinux.org
Label: ${APTVERSION}
Suite: ${APTVERSION}
Architectures: ${ARCH}
Components: os updates contrib 
Description: apt mirror of ${APTVERSION} + updates
EOF

fi

###########################################################################
#### REDHAT I386 MAIN OS
###########################################################################

if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $RELEASEDIR/$ARCH/apt-rpm/base || exit 1

	# Create the release files
	cat >$RELEASEDIR/$ARCH/apt-rpm/base/release.os <<EOF
Archive: stable
Component: os
Version: ${APTVERSION}
Origin: ftp.scientificlinux.org
Label: ${APTVERSION}
Architecture: ${ARCH} 
EOF

	# Put the symlinks for the base OS packages
	cd $RELEASEDIR/$ARCH/apt-rpm
	rm -f SRPMS.os
	ln -sf ../../SRPMS/vendor/original SRPMS.os
	cd $RELEASEDIR/$ARCH/apt-rpm
	rm -f RPMS.os
	ln -sf ../$DEFAULT/RPMS RPMS.os
fi

if [ "$MODE" = "full" -o "$MODE" = "all" ]; then
	# Generate APT indexes
	genbasedir --flat --bloat --progress $RELEASEDIR/$ARCH/apt-rpm os
fi

###########################################################################
#### REDHAT  updates
###########################################################################

if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $RELEASEDIR/$ARCH/apt-rpm/base || exit 1
#	mkdir -p $RELEASEDIR/$ARCH/apt-rpm/RPMS.updates || exit 1

	# Create the release files
	cat >$RELEASEDIR/$ARCH/apt-rpm/base/release.updates <<EOF
Archive: stable
Component: updates
Version: ${APTVERSION}
Origin: ftp.scientificlinux.org 

Label: ${APTVERSION}
Architecture: ${ARCH}
EOF

	cd $RELEASEDIR/$ARCH/apt-rpm
	rm -f SRPMS.updates
	ln -sf ../../SRPMS/vendor/errata SRPMS.updates
	rm -rf RPMS.updates
	mkdir RPMS.updates
	cd ../errata/$DEFAULT/RPMS
        find *.rpm -type l -printf "%l\n" | xargs -n1 --replace ln {} $RELEASEDIR/$ARCH/apt-rpm/RPMS.updates/
        find *.rpm -type f -print | xargs -n1 --replace ln {} $RELEASEDIR/$ARCH/apt-rpm/RPMS.updates/
fi

# Regenerate the apt indexes
genbasedir --flat --bloat --progress $RELEASEDIR/$ARCH/apt-rpm/ updates

###########################################################################
#### contrib packages
###########################################################################

if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $RELEASEDIR/$ARCH/apt-rpm/base || exit 1
	cd $RELEASEDIR/$ARCH/apt-rpm
	rm -f SRPMS.contrib
	ln -sf ../contrib/SRPMS/ SRPMS.contrib
	cd $RELEASEDIR/$ARCH/apt-rpm
	rm -f RPMS.contrib
	ln -sf ../contrib/RPMS RPMS.contrib

	# Create the release files
	cat >$RELEASEDIR/$ARCH/apt-rpm/base/release.contrib <<EOF
Archive: stable
Component: contrib
Version: ${APTVERSION}
Origin: ftp.scientificlinux.org
Label: ${APTVERSION}
Architecture: ${ARCH}
EOF

fi

# Regenerate the apt indexes
genbasedir --flat --bloat --progress $RELEASEDIR/$ARCH/apt-rpm contrib 

###########################################################################
#### notsupported packages
###########################################################################

if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $RELEASEDIR/$ARCH/apt-rpm/base || exit 1
	cd $RELEASEDIR/$ARCH/apt-rpm
	rm -f RPMS.notsupported
	ln -sf ../notsupported/RPMS RPMS.notsupported

	# Create the release files
	cat >$RELEASEDIR/$ARCH/apt-rpm/base/release.notsupported <<EOF
Archive: stable
Component: notsupported
Version: ${APTVERSION}
Origin: ftp.scientificlinux.org
Label: ${APTVERSION}
Architecture: ${ARCH}
EOF

fi

# Regenerate the apt indexes
genbasedir --flat --bloat --progress $RELEASEDIR/$ARCH/apt-rpm notsupported 

####################################
########### Remake hash ############
####################################
genbasedir --hashonly $RELEASEDIR/$ARCH/apt-rpm os updates contrib notsupported 

