. ../locations.include
if [ -f ./locations.include.site ] ; then
	. ./locations.include.site
fi
MYPWD=`pwd`
export MYPWD

#clean up old ones
for i in 1 2 3 4 5
do
   if [ -d $RELEASEDIR/$ARCH-disc0-disc$i ] ; then
	rm -r $RELEASEDIR/$ARCH-disc0-disc$i
   fi
done
if [ -d $RELEASEDIR/$ARCH-disc0 ] ; then
	rm -r $RELEASEDIR/$ARCH-disc0
fi
# Make disc0
#link $SITE and $DEFAULT together to not have to change anaconda anymore
mkdir -vp $RELEASEDIR/$ARCH-disc0/$DEFAULT
mkdir -vp $RELEASEDIR/$ARCH-disc0/sites
cd $RELEASEDIR/$ARCH-disc0/
ln -s $DEFAULT $SITE
cd sites
ln -s ../$DEFAULT $SITE
cd $MYPWD
#copy in $SITE/base
mkdir -v $RELEASEDIR/$ARCH-disc0/$SITE/base
ln $RELEASEDIR/$ARCH/sites/$SITE/base/* $RELEASEDIR/$ARCH-disc0/$SITE/base
#remove things that we are going to modify/rebuild later so as to get our
#own copy, otherwise we change the original too
rm $RELEASEDIR/$ARCH-disc0/$SITE/base/hdlist
rm $RELEASEDIR/$ARCH-disc0/$SITE/base/hdlist2
rm $RELEASEDIR/$ARCH-disc0/$SITE/base/pkgorder
#copy in $SITE/documentation
mkdir $RELEASEDIR/$ARCH-disc0/documentation
ln $RELEASEDIR/$ARCH/sites/$SITE/documentation/* $RELEASEDIR/$ARCH-disc0/documentation
if [ -f $RELEASEDIR/$ARCH/sites/$SITE/documentation/$SITE.releasenote ] ; then
  cp $RELEASEDIR/$ARCH/sites/$SITE/documentation/$SITE.releasenote $RELEASEDIR/$ARCH-disc0/
fi
cp $RELEASEDIR/$ARCH/$DEFAULT.releasenote $RELEASEDIR/$ARCH-disc0/
cp $RELEASEDIR/$ARCH/README $RELEASEDIR/$ARCH-disc0/
#copy in $SITE/isolinux and special *.iso config files
mkdir $RELEASEDIR/$ARCH-disc0/isolinux
cp -f $RELEASEDIR/$ARCH/sites/$SITE/isolinux/* $RELEASEDIR/$ARCH-disc0/isolinux/
if [ -f $RELEASEDIR/$ARCH/sites/$SITE/build/isolinux/isolinux.cfg.iso ] ; then
 cp -f $RELEASEDIR/$ARCH/sites/$SITE/build/isolinux/isolinux.cfg.iso $RELEASEDIR/$ARCH-disc0/isolinux/isolinux.cfg
fi
if [ -f $RELEASEDIR/$ARCH/sites/$SITE/build/isolinux/boot.msg.iso ] ; then
 cp -f $RELEASEDIR/$ARCH/sites/$SITE/build/isolinux/boot.msg.iso $RELEASEDIR/$ARCH-disc0/isolinux/boot.msg
fi
#make updates.img from original area and copy in
$MYPWD/../make.updates.img.sh 
#Copy over misc things
cp $RELEASEDIR/$ARCH/.discinfo $RELEASEDIR/$ARCH-disc0/
mkdir -p $RELEASEDIR/$ARCH-disc0/$SITE/build
cp -a $RELEASEDIR/$ARCH/sites/$SITE/build $RELEASEDIR/$ARCH-disc0/$SITE/
cp -a $RELEASEDIR/$ARCH/RPM-GPG-KEYs $RELEASEDIR/$ARCH-disc0/
cp -a $RELEASEDIR/$ARCH/RELEASE-NOTES*.html $RELEASEDIR/$ARCH-disc0/
#Check size of $SITE/Updates .  Current limitation is that is must fit on
#one cdr along with the other things that we need.  So this means it has to
#less than 
AVAIL=550
SIZE=`du -s -BM $RELEASEDIR/$ARCH-disc0 | cut -f1`
echo $SIZE
if [ $SIZE -gt $AVAIL ] ; then
   echo "Your $RELEASEDIR/sites/$SITE/Updates area is $SIZE MB big which is larger than a cdr along with the other files that we need, you need to use less than $AVAIL MB"
   exit 1
fi
#copy in $SITE/Updates which are RPMS for $SITE
mkdir $RELEASEDIR/$ARCH-disc0/$SITE/Updates
ln $RELEASEDIR/$ARCH/sites/$SITE/Updates/* $RELEASEDIR/$ARCH-disc0/$SITE/Updates
#copy in $DEFAULT/RPMS which are the default rpms
mkdir -p $RELEASEDIR/$ARCH-disc0/$SITE/RPMS
ln $RELEASEDIR/$ARCH/$DEFAULT/RPMS/* $RELEASEDIR/$ARCH-disc0/$SITE/RPMS/
#
#yumgroups.xml confuses splittree.py so removing it as we really do not need it
rm $RELEASEDIR/$ARCH-disc0/$DEFAULT/RPMS/yumgroups.xml
#Need to move the big SRPMS/vendor directory out of the way as splittree.py
#cannot handle this, we put it back at the end, this also means that these
#will not be on the cd's
mv $RELEASEDIR/SRPMS/vendor .. 
#
echo "Using $RELEASEDIR/$ARCH/sites/$SITE/base/$FILEORDER as the fileorder file"
#echo "and not making a new one"
#cp -v $RELEASEDIR/$ARCH/sites/$SITE/base/$FILEORDER $RELEASEDIR/$ARCH-disc0/$SITE/base/
echo "and making a new one"
$ANACONDADIR/pkgorder $RELEASEDIR/$ARCH $ARCH $DEFAULT sites/$SITE > $RELEASEDIR/$ARCH-disc0/$SITE/base/$FILEORDER
#Run splittree.py to split the $DEFAULT/RPMS onto multiple cd's
echo "Running splittree to decide on how to span the cd images"
#Depending on how many RPMS you have in /Updates you might have to increase 
# total-discs and bin-discs , look at output and if you see messages about
# rpms not fitting then you need to increase these.  If you do so
# uncomment out the disc 5 section.  You will also have to add to the genhdlist
# below to look in your disc4 
$ANACONDADIR/splittree.py --arch=$ARCH --total-discs=4 --bin-discs=3 --src-discs=1 --release-string=$SITE --default=$DEFAULT --pkgorderfile=$RELEASEDIR/$ARCH-disc0/$SITE/base/$FILEORDER --distdir=$RELEASEDIR/$ARCH-disc0 --srcdir=$RELEASEDIR/SRPMS/
mv ../vendor $RELEASEDIR/SRPMS/
#Need to remake these links on $ARCH-disc0-disc1 as splittree did not preserve 
echo "making special directories on $RELEASEDIR/$ARCH-disc0-disc1"
mkdir -vp $RELEASEDIR/$ARCH-disc0-disc1/sites
cd $RELEASEDIR/$ARCH-disc0-disc1/
ln -s $DEFAULT $SITE
cd sites
ln -s ../$DEFAULT $SITE
#Run genhdlist to create new hdlist's with cd numbers 
echo "Running genhdlist against $RELEASEDIR/`pwd`/$ARCH-disc0-disc[123]"
cd $RELEASEDIR
$ANACONDADIR/genhdlist --withnumbers --fileorder `pwd`/$ARCH-disc0/$SITE/base/$FILEORDER --default $DEFAULT `pwd`/$ARCH-disc0-disc1  `pwd`/$ARCH-disc0-disc2 `pwd`/$ARCH-disc0-disc3 
# comment out the genhdlist below if you have to go to 4 cd's and comment out
# the one above
#$ANACONDADIR/genhdlist --withnumbers --fileorder `pwd`/$ARCH-disc0/$SITE/base/$FILEORDER --default $DEFAULT `pwd`/$ARCH-disc0-disc1  `pwd`/$ARCH-disc0-disc2 `pwd`/$ARCH-disc0-disc3 `pwd`/$ARCH-disc0-disc4
#
#Now make the iso images
#CHECK that $CDISOAREA exists and make if it does not
if [ -d $CDISOAREA ] ; then
  echo "Creating CD iso images in $CDISOAREA"
else
  mkdir -p $CDISOAREA 
fi
# Make disc1
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.site.iso.sh 1
$MYPWD/subscripts/mkisoimage.disc1.site.sh --site $SITE --dest "$CDISOAREA/$SITE.$VERSION.$DATE.disc1.iso" --subdir "$ARCH-disc0-disc1"
echo "implanting md5sum in disc1 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$SITE.$VERSION.$DATE.disc1.iso
# Make disc2
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.site.iso.sh 2
$MYPWD/subscripts/mkisoimage.disc2.site.sh --site $SITE --dest "$CDISOAREA/$SITE.$VERSION.$DATE.disc2.iso" --subdir "$ARCH-disc0-disc2"
echo "implanting md5sum in disc2 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$SITE.$VERSION.$DATE.disc2.iso
# Make disc3
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.site.iso.sh 3
$MYPWD/subscripts/mkisoimage.disc3.site.sh --site $SITE --dest "$CDISOAREA/$SITE.$VERSION.$DATE.disc3.iso" --subdir "$ARCH-disc0-disc3"
echo "implanting md5sum in disc3 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$SITE.$VERSION.$DATE.disc3.iso
# Make disc4
cd $MYPWD/subscripts
$MYPWD/subscripts/makeapt.site.iso.sh 4
$MYPWD/subscripts/mkisoimage.disc4.site.sh --site $SITE --dest "$CDISOAREA/$SITE.$VERSION.$DATE.disc4.iso" --subdir "$ARCH-disc0-disc4"
echo "implanting md5sum in disc4 now"
/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$SITE.$VERSION.$DATE.disc4.iso
# Make disc5
#cd $MYPWD/subscripts
#$MYPWD/subscripts/makeapt.site.iso.sh 5
#$MYPWD/subscripts/mkisoimage.disc5.site.sh --site $SITE --dest "$CDISOAREA/$SITE.$VERSION.$DATE.disc5.iso" --subdir "$ARCH-disc0-disc5"
#echo "implanting md5sum in disc5 now"
#/usr/lib/anaconda-runtime/implantisomd5 $CDISOAREA/$SITE.$VERSION.$DATE.disc5.iso
