#!/bin/sh

# runbb.sh
# BIG BROTHER MAIN SCRIPT
# Sean MacGuire
# Version 1.9c
# May 15th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#
# THE MOTHER OF ALL SHELL SCRIPTS...
#

#
# BBHOME IS THE ROOT DIRECTORY OF BIG BROTHER!!!
# YOU MUST SET THE NEXT LINE TO WHERE BB LIVES

BBHOME="/bb/bb19c"
export BBHOME

if [ "$BBHOME" = "" -o ! -d "$BBHOME" ]
then
	echo "BBHOME IS INVALID IN runbb.sh"
	echo "Please edit runbb.sh to correct this problem!"
	exit 1
fi

cd $BBHOME	# AVOID ANOTHER REDHAT BUG - CAN'T WRITE IN cwd
		# IF NOT STARTED IN BBHOME

ACTION="$1"
if [ -z "$ACTION" ]
then
	ACTION="start"
fi

. $BBHOME/etc/bbdef.sh		# GET STANDARD INCLUDES

uid=`$ID 2>/dev/null`
if [ "$?" -eq 0 -a "$uid" != "" ]
then
	# Get 1st word
	set $uid >/dev/null 2>&1

	# 1st word whould be in this format: uid=0(root)
	# now set just: uid=0 root
	#uid=`echo $1 | $SED 's/=/ /' | $SED 's/(/ /' | $SED 's/)/ /'`
	# Use single SED, thanks to JStoner@blackboard.com
	uid=`echo $1 | $SED 's/[()=]/ /g'`
	set $uid >/dev/null 2>&1

	uid=$2
	uname=$3
	
	if [ "$uid" -eq 0 -a "$STOPROOT" = "TRUE" ]
	then
		echo "
*** NOTICE: BB has been configured not to run as root ! ***
"
		echo "
*** NOTICE: BB has been configured not to run as root ! ***
" >> $BBOUT
		exit 1
	elif [ "$uid" -eq 0 -a "$STOPROOT" != "TRUE" ]
	then
		echo "
*** WARNING: Running BB as root is not recommended ! ***
"
		echo "
*** WARNING: Running BB as root is not recommended ! ***
" >> $BBOUT
	elif [ "$uname" != "$BBUSER" -a "$uid" != "$BBUSER" ]
	then
		echo "
*** NOTICE: BB must be started with user/uid <$BBUSER>
"
		echo "
*** NOTICE: BB must be started with user/uid <$BBUSER>
" >> $BBOUT
		exit 1
	fi
fi

case $ACTION in

#
# SMM - STOP EVERYTHING... AND MADE SURE.
#
	stop | restart )

		echo "Stopping Big Brother..." 
		echo "`date`: Stopping Big Brother..." >>  $BBOUT
		if [ "$uid" -ne 0 -a -f $BBPID ]
		then
			kill -9 `$CAT $BBPID`
		fi
		$RM -f $BBTMP/runbb.sh.$$

		# IF PSTYPE IS NOT EMPTY, KILL THE SECOND ARGUMENT
		# OTHERWISE THE PID IS THE FIRST ARGUMENT
		PSTYPE=`echo $PS |  $GREP ef`

		$PS | $GREP $BBHOME | $GREP -v grep | $GREP -v runbb.sh >> $BBTMP/runbb.sh.$$
		$PS | $GREP bbrun | $GREP "$BBUSER" | $GREP -v grep | $GREP -v runbb.sh >> $BBTMP/runbb.sh.$$
		$CAT $BBTMP/runbb.sh.$$ | \
		while read line
		do
			set $line

			if test "$PSTYPE" 
			then
				kill -9 $2
			else
				kill -9 $1
			fi
		done

		$RM -f $BBTMP/runbb.sh.$$
		$RM -f $BBPID

		if test "$ACTION" = "stop"
		then
			exit 0
		fi
		echo "`date`: Restarting Big Brother..." >>  $BBOUT
		;;

	start ) 
	
		echo "Starting the Big Brother System & Network monitor" 
		echo "`date`: Starting Big Brother..." >>  $BBOUT
		if [ -f "$BBPID" ]
		then
			$PS | $GREP "$BBHOME/bin/bb" | $GREP -v "grep" >/dev/null 2>&1
			rc1=$?
			$PS | $GREP "bbrun" | $GREP "$BBUSER" | $GREP -v "grep" >/dev/null 2>&1
			rc2=$?
			if [ "$rc1" -eq 0 -o "$rc2" -eq 0 ]
			then
				echo "Big Brother is already running, aborting start procedure"
				exit 1
			else
				$RM $BBPID	# remove the stale BBPID file
			fi
		fi
		;;

	* )

		echo "Usage: runbb.sh start|restart|stop"
		exit 1
		;;

esac

$PS | $GREP "$BBHOME" | $GREP -v "grep" | $GREP -v runbb.sh >/dev/null 2>&1 
rc1=$?
$PS | $GREP "bbrun" | $GREP "$BBUSER" | $GREP -v "grep" | $GREP -v runbb.sh >/dev/null 2>&1 
rc2=$?
if [ "$rc1" -eq 0 -o "$rc2" -eq 0 ]
then
	echo "You seem to have rogue BB processes running, please investigate"
	echo "  They may not have been killed properly when BB was stopped"
	echo "  Startup of BB will continue anyhow"
	echo "You seem to have rogue BB processes running, please investigate" >> $BBOUT
	echo "  They may not have been killed properly when BB was stopped" >> $BBOUT
	echo "  Startup of BB will continue anyhow" >> $BBOUT
fi

# start of bbd block
#
# echo "BBDISPLAY=$BBDISPLAY BBPAGER=$BBPAGER BBNET=$BBNET"
#
# IF WE NEED THE BIG BROTHER DAEMON ON THIS MACHINE THEN START IT
#
if test "$BBSERVER" = "TRUE"
then
	BBSLEEP=300; export BBSLEEP	# UPDATE FREQUENCY IN SECONDS
	echo "	Starting Big Brother Daemon (bbd)..."
	echo "	Starting Big Brother Daemon (bbd)..." >> $BBOUT
	$BBHOME/bin/bbd >> $BBOUT 2>&1
	sleep 2
fi
$RM -f ${PAGINGLOCK}_*		# Spotted by Martin Richard
#
# end of bbd block

$RM -f ${BBTMP}/BB.$$

# start of bb-network block
#
if test "$BBNET" = "TRUE"
then
	echo "	Starting Network tests (bb-network)..."
	echo "	Starting Network tests (bb-network)..." >> $BBOUT
	BBSLEEP=300; export BBSLEEP             # NETWORK TESTING FREQUENCY
	# echo "*** CALLING BB-NETWORK ***"
	{ sleep 30; nohup $BBHOME/bin/bbrun $BBHOME/bin/bb-network.sh ;} >> $BBOUT 2>&1 &
fi
#
# end of bb-network block

# start of bbdisplay block
#
if test "$BBDISPLAY" = "TRUE"
then
	echo "	Starting Display process (bb-display)..."
	echo "	Starting Display process (bb-display)..." >> $BBOUT
	BBSLEEP=300; export BBSLEEP	# HOW OFTEN TO UPDATE DISPLAY (IN SECONDS)
	# echo "*** CALLING BB-DISPLAY ***"
	> $BBLOGS/.bbstartup
	{ sleep 90; nohup $BBHOME/bin/bbrun -a $BBHOME/bin/bb-display.sh ;} >> $BBOUT 2>&1 &
fi
#
# end of bbdisplay block

# start of bbext block
#
# ******   BBEXT HAS BEEN MOVED TO etc/bbdef.sh *****
# ******   FOR THOSE WHO USED TO SET IT HERE    *****
#
# YOU CAN SET BBEXT IN etc/bb-bbexttab NOW
# CHECK IF IT WAS THE CASE
# IT OVERRIDES VALUES OF BBEXT IN etc/bbdef.sh
#

if [ -f "$BBEXTTAB" ]
then
	# a line can start with
	# :....
	#  :....
	# localhost:...
	# www:....
	# www.bb4.com:...
	#
	# All mask should allow for spaces/tabs before :
	# Grep for each mask
	$RM -f $BBTMP/BBEXT.$$
	for mask in "[ 	]*:" "[ 	]*localhost[ 	]*:" "[ 	]*${MACHINEDOTS}[ 	]*:" "[ 	]*${MACHINEDOTS}\..*:"
	do
		# SAVE MATCHING LINES in BBEXT.$$
		bbextline=`$GREP "^${mask}" $BBEXTTAB >>$BBTMP/BBEXT.$$ 2>/dev/null`
	done

	# IF any line matched then continue
	if [ -s $BBTMP/BBEXT.$$ ]
	then
		# Get rid of defaults
		BBEXT=""
		$RM -f $BBTMP/BBEXT.1.$$
		cat $BBTMP/BBEXT.$$ | $SORT -u |
		while read line
		do
			# If any ":" are found, force spaces around it to
			# make Solaris happy :(
			# Thanks to  Larry Parmelee <parmelee@CS.Cornell.EDU>
			line=`echo "$line" | $SED 's/:/ : /g'`
#			line=`echo "$line" | $SED 's/::/: :/g'`
			OLDIFS=$IFS
			IFS=':'
			set $line 2>/dev/null
			IFS=$OLDIFS
			shift		# Get rid of host
			shift		# Get rid of optional settings for now
			# Results are sent to a file because some shells go into a subshell
			# during a while preceded by a pipe such that variables set within
			# that while will not be visible after exiting the while. The {} should
			# not send it within a subshell but I'm wary (especially SUN & DIGITAL)
			line=`echo "$*" | $SED 's/;/:/g' 2>/dev/null`
			echo $line >> $BBTMP/BBEXT.1.$$
		done
		BBEXT=`$CAT $BBTMP/BBEXT.1.$$`
		$RM -f $BBTMP/BBEXT.1.$$
	fi
	$RM -f $BBTMP/BBEXT.$$
fi

#
EXTSTARTSLEEP=0
for file in $BBEXT 
do
	# Get the interval of testing of defined (i.e. test:120 -> run every 120 seconds)
	OLDIFS=$IFS
	IFS=':'
	set $file
	IFS=$OLDIFS
	file=$1;export file
	if [ "$#" -gt 1 ]
	then
		BBSLEEP=$2
	else
		BBSLEEP=$BBDEFSLEEP
	fi
	export BBSLEEP

	if test "$EXTSTARTSLEEP" = "0"
	then
		echo "	Starting external scripts"
		echo "	Starting external scripts" >> $BBOUT
	fi

	echo "		Starting external script $file"
	echo "		Starting external script $file" >> $BBOUT

	# bbrun -a will prefix all error messages with the date and script name
	{ sleep $EXTSTARTSLEEP; nohup $BBHOME/bin/bbrun -a $BBHOME/ext/$file ;} >> $BBOUT 2>&1 &

	# Make sure external don't start all at the same time
	EXTSTARTSLEEP=`$EXPR $EXTSTARTSLEEP + 2`
done
#
# end of bbext block

# start of bb-local block
#
echo "	Starting Local tests (bb-local)..."
echo "	Starting Local tests (bb-local)..." >> $BBOUT
BBSLEEP=300; export BBSLEEP	# HOW OFTEN TO UPDATE LOCAL INFO (IN SECONDS)
# echo "*** CALLING BB-LOCAL ***"
{ nohup $BBHOME/bin/bbrun -a $BBHOME/bin/bb-local.sh ;} >> $BBOUT 2>&1 &
#
# end of bb-local block

echo "Big Brother $BBREL started"
echo "Big Brother $BBREL started" >> $BBOUT
