/**********************************************************************
This software program is available to you under a choice of one of two 
licenses. You may choose to be licensed under either the GNU General Public 
License (GPL) Version 2, June 1991, available at 
http://www.fsf.org/copyleft/gpl.html, or the Intel BSD + Patent License, the 
text of which follows:

Recipient has requested a license and Intel Corporation ("Intel") is willing
to grant a license for the software entitled Linux Base Driver for the 
Intel(R) PRO/100 Family of Adapters (e100) (the "Software") being provided 
by Intel Corporation. The following definitions apply to this license:

"Licensed Patents" means patent claims licensable by Intel Corporation which 
are necessarily infringed by the use of sale of the Software alone or when 
combined with the operating system referred to below.

"Recipient" means the party to whom Intel delivers this Software.

"Licensee" means Recipient and those third parties that receive a license to 
any operating system available under the GNU Public License version 2.0 or 
later.

Copyright (c) 1999 - 2002 Intel Corporation.
All rights reserved.

The license is provided to Recipient and Recipient's Licensees under the 
following terms.

Redistribution and use in source and binary forms of the Software, with or 
without modification, are permitted provided that the following conditions 
are met:

Redistributions of source code of the Software may retain the above 
copyright notice, this list of conditions and the following disclaimer.

Redistributions in binary form of the Software may reproduce the above 
copyright notice, this list of conditions and the following disclaimer in 
the documentation and/or materials provided with the distribution.

Neither the name of Intel Corporation nor the names of its contributors 
shall be used to endorse or promote products derived from this Software 
without specific prior written permission.

Intel hereby grants Recipient and Licensees a non-exclusive, worldwide, 
royalty-free patent license under Licensed Patents to make, use, sell, offer 
to sell, import and otherwise transfer the Software, if any, in source code 
and object code form. This license shall include changes to the Software 
that are error corrections or other minor changes to the Software that do 
not add functionality or features when the Software is incorporated in any 
version of an operating system that has been distributed under the GNU 
General Public License 2.0 or later. This patent license shall apply to the 
combination of the Software and any operating system licensed under the GNU 
Public License version 2.0 or later if, at the time Intel provides the 
Software to Recipient, such addition of the Software to the then publicly 
available versions of such operating systems available under the GNU Public 
License version 2.0 or later (whether in gold, beta or alpha form) causes 
such combination to be covered by the Licensed Patents. The patent license 
shall not apply to any other combinations which include the Software. NO 
hardware per se is licensed hereunder.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
IMPLIED WARRANTIES OF MECHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR IT CONTRIBUTORS BE LIABLE FOR ANY 
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
ANY LOSS OF USE; DATA, OR PROFITS; OR BUSINESS INTERUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR 
TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/

/**********************************************************************
*                                                                     *
* INTEL CORPORATION                                                   *
*                                                                     *
* This software is supplied under the terms of the license included   *
* above.  All use of this driver must be in accordance with the terms *
* of that license.                                                    *
*                                                                     *
* Module Name:  e100_main.c                                           *
*                                                                     *
* Abstract:     Functions for the driver entry points like load,      *
*               unload, open and close. All board specific calls made *
*               by the network interface section of the driver.       *
*                                                                     *
* Environment:  This file is intended to be specific to the Linux     *
*               operating system.                                     *
*                                                                     *
**********************************************************************/



#define PHY_NC3133      1

#define COND_FREE(X)            if (X) kfree(X)
#define ALLOC_SKBS(bdp, nskb)  \
  for (; (bdp)->skb_req > 0; (bdp)->skb_req--) { \
      (nskb) = e100_alloc_skb( (bdp) );\
      if ((nskb) == NULL) break;\
      e100_add_skb_to_end( (bdp), (nskb) );\
  }

 
#define _IANS_MAIN_MODULE_C_

/* includes */
#undef __NO_VERSION__
#include "e100.h"
#include "rcvbundl.h"
#include "e100_config.h"
#include "e100_proc.h"

#ifdef IDIAG_PRO_SUPPORT
extern idiag_pro_stat_t e100_run_diag (struct net_device *dev, idiag_pro_data_t *diag_data);
#endif

#ifndef SIOCETHTOOL
 #undef E100_ETHTOOL_IOCTL
#endif /*SIOCETHTOOL*/

#ifdef E100_ETHTOOL_IOCTL
 #include <linux/ethtool.h>
 static int e100_do_ethtool_ioctl (struct net_device *dev, struct ifreq *ifr);
 static void e100_get_speed_duplex_caps(bd_config_t * bdp);
 static int e100_ethtool_get_settings (struct net_device *dev, struct ifreq *ifr);
 static int e100_ethtool_set_settings (struct net_device *dev, struct ifreq *ifr);
 #ifdef ETHTOOL_GDRVINFO
  static int e100_ethtool_get_drvinfo (struct net_device *dev, struct ifreq *ifr);
 #endif /*ETHTOOL_GDRVINFO*/

 #define E100_SPEED_10_HALF	 1
 #define E100_SPEED_10_FULL	 2
 #define E100_SPEED_100_HALF 3
 #define E100_SPEED_100_FULL 4
#endif /*E100_ETHTOOL_IOCTL*/

#ifndef SIOCGMIIPHY
 #undef E100_MII_IOCTL
#endif /*SIOCGMIIPHY*/

#ifdef E100_MII_IOCTL
 #include <linux/mii.h>
 static int e100_mii_ioctl(struct net_device *dev, struct ifreq *rq, int cmd);
#endif //E100_MII_IOCTL

/****************************************************************************
 * Parameter checking for compile time variables
 */


u8         e100_tx_thld =
(TX_THRSHLD < 0) ? DEFAULT_TRANSMIT_THRESHOLD : ((TX_THRSHLD >
    200) ? DEFAULT_TRANSMIT_THRESHOLD : TX_THRSHLD);

/* Congestion enable flag for National Phy */
static unsigned int          e100_cong_enbl = TX_CONG_DFLT;

/* 
 * Auto-polarity enable/disable
 * e100_autopolarity = 0 => disable auto-polarity
 * e100_autopolarity = 1 => enable auto-polarity
 * e100_autopolarity = 2 => let software determine
 */

static int             e100_autopolarity = 2;

/* 
 * Number of consecutive transmit frames without the CU getting suspended or
 * going idle before generating an interrupt
 */

static unsigned int    e100_batch_tx_frames = TX_FRAME_CNT;

/* Global Data structures and variables */
char  e100id_string[128] =  "e100 - Intel(R) PRO/100 Fast Ethernet Adapter, ";
char  e100_copyright[] =    "Copyright (c) 2002 Intel Corporation";

#define E100_VERSION  "1.8.38"
#define E100_FULL_DRIVER_NAME 	"Intel(R) PRO/100 Fast Ethernet Adapter - Loadable driver, ver "

const char *e100_version = E100_VERSION;
const char *e100_full_driver_name = E100_FULL_DRIVER_NAME E100_VERSION;
const char *e100_short_driver_name = "e100";

//PCI Vendor ID,PCI Device ID,PCI Sub Vendor ID,PCI Sub system ID,PCI Rev,Branding String,
e100_vendor_info_t e100_vendor_info_array[] = {  
  { 0x8086,0x1229,0x8086,0x0001,1,"Intel(R) PRO/100B PCI Adapter (TX)"},
  { 0x8086,0x1229,0x8086,0x0002,1,"Intel(R) PRO/100B PCI Adapter (T4)"},
  { 0x8086,0x1229,0x8086,0x0003,1,"Intel(R) PRO/10+ PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0004,1,"Intel(R) PRO/100 WfM PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0005,1,"Intel(R) 82557-based Integrated Ethernet PCI (10/100)"},
  { 0x8086,0x1229,0x8086,0x0006,1,"Intel(R) 82557-based Integrated Ethernet with Wake on LAN*"},
  { 0x8086,0x1229,0x8086,0x0002,2,"Intel(R) PRO/100B PCI Adapter (T4)"},
  { 0x8086,0x1229,0x8086,0x0003,2,"Intel(R) PRO/10+ PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0004,2,"Intel(R) PRO/100 WfM PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x0005,2,"Intel(R) 82557-based Integrated Ethernet PCI (10/100)"},
  { 0x8086,0x1229,0x8086,0x0006,2,"Intel(R) 82557-based Integrated Ethernet with Wake on LAN*"},
  { 0x8086,0x1229,0x8086,0x0007,4,"Intel(R) 82558-based Integrated Ethernet"},
  { 0x8086,0x1229,0x8086,0x0008,4,"Intel(R) 82558-based Integrated Ethernet with Wake on LAN*"},
  { 0x8086,0x1229,0x8086,0x0009,5,"Intel(R) PRO/100+ PCI Adapter"},
  { 0x8086,0x1229,0x8086,0x000A,5,"Intel(R) PRO/100+ Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000A,5,"Intel(R) PRO/100+ Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000B,8,"Intel(R) PRO/100+ Adapter"},
  { 0x8086,0x1229,0x8086,0x000C,8,"Intel(R) PRO/100+ Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000D,8,"Intel(R) PRO/100+ Alert on LAN* 2 Management Adapter"},
  { 0x8086,0x1229,0x8086,0x000E,8,"Intel(R) PRO/100+ Alert on LAN* Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0010,9,"Intel(R) PRO/100 S Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0011,9,"Intel(R) PRO/100 S Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0012,9,"Intel(R) PRO/100 S Advanced Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0013,9,"Intel(R) PRO/100 S Advanced Management Adapter"},
  { 0x8086,0x1229,0x8086,0x0030,8,"Intel(R) PRO/100+ Management Adapter with Alert On LAN* GC"},
  { 0x8086,0x1229,0x8086,0x0040,0xC,"Intel(R) PRO/100 S Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0041,0xC,"Intel(R) PRO/100 S Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0042,0xC,"Intel(R) PRO/100 Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0050,0xD,"Intel(R) PRO/100 S Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x0070,0xF,"Intel(R) PRO/100 M Desktop Adapter"},
  { 0x8086,0x1229,0x8086,0x1009,4,"Intel(R) PRO/100+ Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1009,5,"Intel(R) PRO/100+ Server Adapter"},
  { 0x8086,0x1229,0x8086,0x100C,8,"Intel(R) PRO/100+ Server Adapter (PILA8470B)"},
  { 0x8086,0x1229,0x8086,0x1012,9,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1013,9,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1014,0xD,"Intel(R) PRO/100 Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1015,0xD,"Intel(R) PRO/100 S Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1016,0xD,"Intel(R) PRO/100 S Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1017,8,"Intel(R) PRO/100+ Dual Port Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1030,8,"Intel(R) PRO/100+ Management Adapter with Alert On LAN* G Server"},
  { 0x8086,0x1229,0x8086,0x1040,0xC,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1041,0xC,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1042,0xC,"Intel(R) PRO/100 Server Adapter"},
  { 0x8086,0x1229,0x8086,0x1050,0xD,"Intel(R) PRO/100 S Server Adapter"},
  { 0x8086,0x1229,0x8086,0x10F0,4,"Intel(R) PRO/100+ Dual Port Server Adapter "}, 
  { 0x8086,0x1229,0x8086,0x10F0,5,"Intel(R) PRO/100+ Dual Port Server Adapter "}, 
  { 0x8086,0x1229,0x8086,0x2009,0xC,"Intel(R) PRO/100 S Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x200D,8,"Intel(R) PRO/100 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200D,8,"Intel(R) PRO/100 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200E,8,"Intel(R) PRO/100 LAN+Modem56 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200E,8,"Intel(R) PRO/100 LAN+Modem56 CardBus II"},
  { 0x8086,0x1229,0x8086,0x200F,0xC,"Intel(R) PRO/100 SR Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2010,0xC,"Intel(R) PRO/100 S Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2013,0xC,"Intel(R) PRO/100 SR Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2016,0xD,"Intel(R) PRO/100 S Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2017,0xD,"Intel(R) PRO/100 S Combo Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2018,0xD,"Intel(R) PRO/100 SR Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2019,0xD,"Intel(R) PRO/100 SR Combo Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2101,0xC,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2102,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2103,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2104,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2105,0xC,"Intel(R) PRO/100 SP Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2106,0xA,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x1229,0x8086,0x2107,0xA,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x8086,0x2108,0xC,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x8086,0x2200,0xC,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2201,0xC,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2202,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2203,CATCHALL,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x2204,CATCHALL,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x2205,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2206,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2207,0xC,"Intel(R) PRO/100 SP Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2208,0xC,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x1229,0x8086,0x2408,9,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x240F,9,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x2411,9,"Intel(R) PRO/100+ Mini PCI"},
  { 0x8086,0x1229,0x8086,0x3400,8,"Intel(R) 82559 Fast Ethernet LAN on Motherboard"},
  { 0x8086,0x1229,0x8086,0x3000,8,"Intel(R) 82559 Fast Ethernet LAN on Motherboard"},
  { 0x8086,0x1229,0x8086,0x3001,8,"Intel(R) 82559 Fast Ethernet LOM with Alert on LAN*"},
  { 0x8086,0x1229,0x8086,0x3002,8,"Intel(R) 82559 Fast Ethernet LOM with Alert on LAN* 2"},
  { 0x8086,0x1229,0x8086,0x3006,0xC,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3007,0xC,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3008,0xC,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x8086,0x3010,CATCHALL,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3011,CATCHALL,"Intel(R) PRO/100 S Network Connection"},
  { 0x8086,0x1229,0x8086,0x3012,CATCHALL,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1229,0x1014,0x005C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x305C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x405C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x605C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x505C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x105C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x805C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x705C,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x01F1,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x0232,CATCHALL,"IBM Mobile, Desktop & Server Adapters"},   
  { 0x8086,0x1229,0x1014,0x0207,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x023F,CATCHALL,"Intel(R) PRO/100 Network Connection"},   
  { 0x8086,0x1229,0x1014,0x01BC,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01CE,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01DC,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01EB,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x01EC,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x0202,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x0205,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x1014,0x0217,CATCHALL,"Intel(R) PRO/100 Network Connection"},     
  { 0x8086,0x1229,0x0E11,0xB01E,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB01F,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB02F,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB04A,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0C6,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0C7,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0D7,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0DD,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0DE,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB0E1,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB134,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB13C,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB144,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB163,CATCHALL,"Compaq Fast Ethernet Server Adapter"},     
  { 0x8086,0x1229,0x0E11,0xB164,CATCHALL,"Compaq Fast Ethernet Server Adapter"},
  { 0x8086,0x2449,0x0E11, CATCHALL, CATCHALL,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x2449,0x1014,0x0265,CATCHALL,"Intel(R) PRO/100 VE Desktop Connection"},
  { 0x8086,0x2449,0x1014,0x0267,CATCHALL,"Intel(R) PRO/100 VE Desktop Connection"},
  { 0x8086,0x2449,0x1014,0x026A,CATCHALL,"Intel(R) PRO/100 VE Desktop Connection"},
  { 0x8086,0x2449,0x1014, CATCHALL, CATCHALL,"Intel(R) PRO/100 VE Desktop Connection"},
  { 0x8086,0x2449,0x8086,0x3010,1,"Intel(R) PRO/100 VE Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3010,3,"Intel(R) PRO/100 VE Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3011,1,"Intel(R) PRO/100 VM Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3011,3,"Intel(R) PRO/100 VM Desktop Adapter"},
  { 0x8086,0x2449,0x8086,0x3013,1,"Intel(R) PRO/100 VE Network ConnectionPLC LOM"},
  { 0x8086,0x2449,0x8086,0x3013,3,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x2449,0x8086,0x3014,1,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x2449,0x8086,0x3014,3,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x2449,0x8086,0x3016,1,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x2449,0x8086,0x3016,3,"Intel(R) PRO/100 P Mobile Combo Adapter"},
  { 0x8086,0x2449,0x8086,0x3017,1,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x2449,0x8086,0x3017,3,"Intel(R) PRO/100 P Mobile Adapter"},
  { 0x8086,0x2449,0x8086,0x3018,1,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x2449,0x8086,0x3018,3,"Intel(R) PRO/100 Network Connection"},
  { 0x8086,0x1031,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"}, 
  { 0x8086,0x1032,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x1033,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"}, 
  { 0x8086,0x1034,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"}, 
  { 0x8086,0x1038,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x1039,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x103A,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x103B,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x103C,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x103D,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VE Network Connection"},
  { 0x8086,0x103E,CATCHALL,CATCHALL,CATCHALL,"Intel(R) PRO/100 VM Network Connection"},
  { 0x8086,0x2459,CATCHALL,CATCHALL,CATCHALL,"Intel(R)82562 based Fast Ethernet Connection"},
  { 0x8086,0x245D,CATCHALL,CATCHALL,CATCHALL,"Intel(R)82562 based Fast Ethernet Connection"},
  {CATCHALL, CATCHALL, CATCHALL, CATCHALL, CATCHALL, "Intel(R) 8255x-based Ethernet Adapter"},
  {0x0, 0x0, 0x0, 0x0, 0x0, NULL}  // This has to be the last entry
};



static bd_config_t    *e100_first = NULL;
static int             e100nics = 0;


/*********************************************************************/
/*! This is a GCC extension to ANSI C.
 *  See the item "Labeled Elements in Initializers" in the section
 *  "Extensions to the C Language Family" of the GCC documentation.
 *********************************************************************/

#define E100_OPTION_INIT { [0 ... MAX_NIC-1] = -1 }

/* Start Command Line Options */
/* 
 * Set the line speed and duplex mode of the controller.
 *  0 indicates autodetection for both speed and duplex mode
 *  1 indicates a speed of 10Mbps and a duplex mode of half 
 *  2 indicates a speed of 10Mbps and a duplex mode of full 
 *  3 indicates a speed of 100Mbps and a duplex mode of half 
 *  4 indicates a speed of 100Mbps and a duplex mode of full 
 *
 *    NOTE: The PRO/10+ can't autodetect so if the setting is left at
 *    0 the driver will force it to 10/HALF.  If full duplex is desired
 *    a setting of 2 is required.  Setting 3 and 4 are invalid for the
 *    PRO/10+ hardware.
 *
 * We support up to 16 nics with this structure.  If you need more, 
 * add new members to the structure.
 */
int e100_speed_duplex[MAX_NIC] = E100_OPTION_INIT;
int RxDescriptors[MAX_NIC] = E100_OPTION_INIT;
int TxDescriptors[MAX_NIC] = E100_OPTION_INIT; 
int XsumRX[MAX_NIC] =  E100_OPTION_INIT; 
int ucode[MAX_NIC] = E100_OPTION_INIT;
int IntDelay[MAX_NIC] = E100_OPTION_INIT;
int BundleSmallFr[MAX_NIC] = E100_OPTION_INIT;
int BundleMax[MAX_NIC] = E100_OPTION_INIT;
int ber[MAX_NIC] = E100_OPTION_INIT;
int flow_control[MAX_NIC] = E100_OPTION_INIT;
int IFS[MAX_NIC] = E100_OPTION_INIT;

/* ====================================================================== */
static unsigned char e100_D101M_checksum(bd_config_t *bdp,rfd_t *rfdp,struct sk_buff *skb);
static unsigned char e100_D102_check_checksum(rfd_t * rfdp);
static int e100_ioctl(struct net_device *dev, struct ifreq *ifr, int cmd);
static void e100_free_rfd_pool(bd_config_t *bdp);
static void e100_free_tbds(bd_config_t *bdp);



static int  e100_open (struct net_device *),
    e100_close (struct net_device *),
    e100_xmit_frame (struct sk_buff *, struct net_device *),
    e100init (bd_config_t *), e100_set_mac (struct net_device *, void *);

struct net_device_stats *e100_get_stats (struct net_device *);

static void e100intr (int, void *, struct pt_regs *),
    e100_print_brd_conf (bd_config_t *),
        e100_set_multi (struct net_device *);

char *e100_GetBrandingMesg (bd_config_t *);

static u8 e100_get_pci_info (struct pci_dev *, bd_config_t *);
static u8 e100_sw_init (bd_config_t *);

static u8 e100_alloc_space (struct pci_dev *, bd_config_t **);
static int e100_alloc_tcbs(bd_config_t *);


static void e100_dealloc_space (bd_config_t *),
    e100_setup_tcb_pool (ptcb_t, unsigned int, bd_config_t *);

static struct sk_buff *e100_alloc_rfd_pool (bd_config_t *);


/* EEPROM access functions */
static void e100_rd_eaddr (bd_config_t *),
        e100_rd_pwa_no(bd_config_t * bdp);

extern void WriteEEprom (bd_config_t *, u16, u16);
extern u16 ReadEEprom (bd_config_t *, u16);
extern u16  GetEEpromSize (bd_config_t *);
extern void UpdateChecksum (bd_config_t *);

/* Functions for accessing the adapter hardware */
static unsigned char e100_clr_cntrs (bd_config_t *),
    e100_load_microcode (bd_config_t *, u8),
    e100_hw_init (bd_config_t *, u32),
    e100_setup_iaaddr (bd_config_t *, u8 *),
    e100_update_stats(bd_config_t *bdp);

static void e100_start_ru (bd_config_t *),
    e100_dis_intr (bd_config_t *),
    e100_enbl_intr (bd_config_t *),
    e100_trigger_SWI(bd_config_t * bdp),
    e100_dump_stats_cntrs (bd_config_t *);

void e100_check_options(int board, u8 rev_id);
void e100_set_int_option(int *option, int min, int max, int default_val, char *name);
void e100_set_bool_option(int *option, int default_val, char *name);

/* 
 * Procedure:   e100_alloc_skb
 *
 * Description: allocates skb with enough room for rfd, ans and data,
 *              and reserve non-data space
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      struct sk_buff * - the new sk_buff or NULL if we failed to allocate one.
 */
inline struct sk_buff *
e100_alloc_skb(bd_config_t *bdp)
{
    struct sk_buff      *new_skb;
    u32 skb_size;
    skb_size = sizeof(rfd_t);

#ifdef IANS
	skb_size += BD_ANS_INFO_SIZE;
#endif

#if (defined __ia64__)	
	new_skb = (struct sk_buff *) __dev_alloc_skb(skb_size, GFP_ATOMIC|GFP_DMA);
	if (new_skb==NULL){ //Try to alloc non-DMA skb if failed to get from the DMA zone
		new_skb = (struct sk_buff *) dev_alloc_skb(skb_size);
	}
#else
	new_skb = (struct sk_buff *) dev_alloc_skb(skb_size);
#endif

    if (new_skb) {

#if (defined __ia64__)
        /* The IP data should be 
           DWORD aligned. since the ethernet header is 14 bytes long, 
           we need to reserve 2 extra bytes so that the TCP/IP headers
           will be DWORD aligned. */
        skb_reserve(new_skb, 2);
#endif  /* __ia64__ */


#ifdef IANS
        /* we need to allocate extra room for the ans stuff */
        bd_ans_os_ReserveSpaceForANS(new_skb);
#endif
        skb_reserve(new_skb, bdp->rfd_size);
        
        return new_skb;
    }
    
    return NULL;
}



/* 
 * Procedure:   e100_add_skb_to_end
 *
 * Description: Adds an skb to the end of our rfd list.
 *        
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      skb_buff_t *new_skb - Ptr to the new skb
 *
 * Returns:
 *    -     NONE
 */


inline void
e100_add_skb_to_end(bd_config_t *bdp, struct sk_buff * new_skb)
{
    rfd_t          *rfdn;      /* The new rfd */
    rfd_t          *rfdp;      /* The old rfd */
    dma_addr_t      dma_addr;
    /* set who this is from */
    new_skb->dev = bdp->device;
    
    rfdn = RFD_POINTER(new_skb, bdp);
 
    /* init all fields in rfd */
    rfdn->rfd_header.cb_status = 0;
    rfdn->rfd_header.cb_cmd = __constant_cpu_to_le16(RFD_EL_BIT);
    rfdn->rfd_act_cnt = 0;
    rfdn->rfd_sz = __constant_cpu_to_le16(RFD_DATA_SIZE);

    /* append new_skb to the end of the rx skb queue */
    new_skb->prev = bdp->rfd_tail;
    new_skb->next = NULL;
    
    dma_addr =  pci_map_single(bdp->ppci_dev,rfdn,
				     sizeof(rfd_t),PCI_DMA_FROMDEVICE);
    SET_SKB_DMA_ADDR(new_skb,dma_addr);
    pci_dma_sync_single(bdp->ppci_dev,dma_addr,bdp->rfd_size,PCI_DMA_TODEVICE);

    if (bdp->rfd_tail != NULL) {
        rfdp = RFD_POINTER(bdp->rfd_tail, bdp);
        bdp->rfd_tail->next = new_skb;

        // sync up only the first dword of RFD
        pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(bdp->rfd_tail),
			    4 ,PCI_DMA_FROMDEVICE);
	
        //first write the link pointer
	put_unaligned(cpu_to_le32(dma_addr),
		      ( (u32 *)(&(rfdp->rfd_header.cb_lnk_ptr))));

        pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(bdp->rfd_tail),
			    8,PCI_DMA_TODEVICE);
        
        // next clear the EL bit on the previous rfd 
        rfdp->rfd_header.cb_cmd &= __constant_cpu_to_le16((u16) ~RFD_EL_BIT);
	pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(bdp->rfd_tail),
			    4,PCI_DMA_TODEVICE);

    }
    bdp->rfd_tail = new_skb;      /* reset the tail pointer */
    if (bdp->rfd_head == NULL) 
        bdp->rfd_head = new_skb;

    return;
}



/* 
 * Procedure:   e100_wait_exec_cmd
 *
 * Description: This general routine will issue a command to the e100.
 *      bdp -          Ptr to this card's e100_bdconfig structure
 *      scb_cmd_low - The command that is to be issued.
 * Returns:
 *      B_TRUE if the command was issued to the chip successfully
 *      B_FALSE if the command was not issued to the chip
 */
inline unsigned char
e100_wait_exec_cmd(bd_config_t * bdp, u8 scb_cmd_low)
{
    if (e100_wait_scb(bdp) != B_TRUE) {
        printk(KERN_ERR "%s e100_wait_exec_cmd: Wait failed.\n",bdp->device->name);
        return (B_FALSE);
    }
    
    e100_exec_cmd(bdp, scb_cmd_low);
    return (B_TRUE);
}


//void e100_tx_queued_frames (bd_config_t *);
void e100_tx_srv (bd_config_t *);
void e100_rx_srv (bd_config_t *);
void e100_watchdog (struct net_device *);
void e100_refresh_txthld (bd_config_t *);
void e100_manage_adaptive_ifs(bd_config_t *);
void e100_clear_pools(bd_config_t *);
void e100_clear_structs(struct net_device *, bd_config_t *);

static ptcb_t e100_prepare_xmit_buff (bd_config_t *, struct sk_buff *),
    e100_prepare_ext_xmit_buff (bd_config_t *, struct sk_buff *);

/* Functions for accessing the physical layer (PHY) hardware */
static unsigned char e100_SetupPhy (bd_config_t *),
    e100_UpdatePhyLinkState (bd_config_t *),
    e100_phydetect (bd_config_t *);

void e100_FindPhySpeedAndDpx (bd_config_t *, unsigned int);
void e100_ForceSpeedAndDuplex (bd_config_t *);
void e100_auto_neg (bd_config_t *);
void e100_fix_polarity (bd_config_t * bdp);
void e100_ResetPhy (bd_config_t *);
void e100_MdiWrite (bd_config_t *, u32, u32, u16);
void e100_MdiRead (bd_config_t *, u32, u32, u16 *);
void e100_phy_check (bd_config_t *);

static void e100_handle_zero_lock_state(bd_config_t * bdp);

static void e100_set_multi_exec(struct net_device * dev);
static void e100_tx_notify_stop(bd_config_t *bdp,enum tx_queue_stop_type);


#ifdef MODULE
/* Exported symbols */
/* vars */
EXPORT_SYMBOL(e100_speed_duplex);
EXPORT_SYMBOL(e100_first);
EXPORT_SYMBOL(e100nics);

MODULE_AUTHOR("Intel Corporation, <linux.nics@intel.com>");
MODULE_DESCRIPTION(E100_FULL_DRIVER_NAME E100_VERSION);
MODULE_PARM(TxDescriptors,     "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(RxDescriptors,     "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(XsumRX,            "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(e100_speed_duplex, "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(ucode,             "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(ber,               "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(flow_control,      "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(IntDelay,          "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(BundleSmallFr,     "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(BundleMax,         "1-" __MODULE_STRING(MAX_NIC) "i");
MODULE_PARM(IFS,               "1-" __MODULE_STRING(MAX_NIC) "i");
#endif /* MODULE */

/***************************************************************************/
/***************************************************************************/
/*     Module Install/Uninstall Stuff                                      */
/***************************************************************************/

static int 
e100_found1(struct pci_dev *pcid, const struct pci_device_id *ent)
{
    static int	       first_time = B_TRUE;
    struct net_device *dev = NULL;
    bd_config_t       *bdp = NULL;
    static int         e100_ohio_flag = 0;   /* will be set if ohio found */
    static int         found_max = 0;
    
    /* If we've already found the max number of NICs, return silently */
    if (found_max)
        return -ENODEV;
    
    /* first check if the max number of supported NICs was already found */
    if (e100nics == MAX_NIC) {
        printk(KERN_NOTICE "e100: found %d NICs, stop searching further\n", MAX_NIC);
        found_max = 1;
        return -ENODEV;
    }
    
    dev = init_etherdev(dev, 0);
    
    if (dev == NULL) {
        printk(KERN_ERR "Not able to alloc etherdev struct\n");
        return -ENODEV;
    }
    
    if (first_time == B_TRUE) {
        /* print out the version */
        first_time = B_FALSE;
        printk(KERN_NOTICE "%s\n", e100_full_driver_name);
        printk(KERN_NOTICE "%s\n", e100_copyright);
    }
    
    /* Allocate all the memory that the driver will need */
    /* Tx and Rx descriptors will be allocated later in this function */
    if (!e100_alloc_space(pcid, &bdp)) {
        printk(KERN_ERR "%s - Failed to allocate memory\n", e100_short_driver_name);
        e100_clear_structs(dev, bdp);
        return -ENOMEM;
    }
    
    /* link the device and the bdp */
    bdp->device = dev;
    dev->priv = bdp;
    
    bdp->flags  = 0;
    bdp->ppci_dev = pcid;
    
    /* zero out fields - just in case */
    bdp->ifs_state = 0;
    bdp->ifs_value = 0;
    bdp->io_start = 0;
    bdp->scbp = 0;
    
    if (pci_enable_device(pcid)) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    pci_set_drvdata(pcid, bdp);
    
    /* Obtain the PCI specific information about the driver. */
    if (e100_get_pci_info(pcid, bdp) == B_FALSE) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    if (check_region(bdp->io_start, 32)) { /* card is taken */
        printk(KERN_ERR "%s - Failed to find PCI device\n", e100_short_driver_name);
        bdp->io_start = 0;  /* so we'll know not to release the region */
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    request_region(bdp->io_start, 32, e100_short_driver_name);
    
    /* Decide whether to load or not based on the * sub-device ID file.
     * This also sets the id string. */
    if (!e100_GetBrandingMesg(bdp)) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    /* save off the needed information */
    dev->irq = pcid->irq;
    
    if ( ((bdp->ppci_dev->device > 0x1030) && (bdp->ppci_dev->device < 0x103F)) ||
         (bdp->ppci_dev->device == 0x2449) || 
		 (bdp->ppci_dev->device == 0x2459) ||
		 (bdp->ppci_dev->device == 0x245D)) {
        bdp->rev_id = D101MA_REV_ID; /* workaround for ICH */ 
		bdp->flags |= IS_ICH;
    }
    
    /* set up other board info based on PCI info */
    if (bdp->rev_id == 0xff)
        bdp->rev_id = 1; 
    /* If rev_id is invalid, treat this as a 82557 */
    if ((u8) bdp->rev_id >= D101A4_REV_ID)
        bdp->flags |= IS_BACHELOR;
    
    if ((u8) bdp->rev_id >= D102_REV_ID) {
        bdp->flags |= USE_IPCB;
        bdp->rfd_size = 32;
    } else {
        bdp->rfd_size = 16;
    }
    
    
    /* Identify Ohio's Port number */
    if (bdp->sub_dev_id == PCI_OHIO_BOARD) {
        /* identify Port 1 or Port 2 based on static ohio flag */
        if (!e100_ohio_flag) {
            strcat(e100id_string, " (Port 1)");
            e100_ohio_flag = 1; /* so that the next 
                                 * port shows as port 2 */
        } else {
            strcat(e100id_string, " (Port 2)");
            e100_ohio_flag = 0;   /* in case there is > 1 
                                   * ohio board */
        }
    }
    
    printk(KERN_NOTICE "\n");
    printk(KERN_NOTICE "%s: %s\n", bdp->device->name, e100id_string);
    e100_check_options(e100nics,bdp->rev_id);
    /* init all the data structure and find the rest of the pci info */
    if (!e100init(bdp)) {
        printk(KERN_ERR "Failed to initialize e100, instance #%d\n", e100nics);
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }
    
    if (e100_create_proc_subdir(bdp) < 0) {
        e100_clear_structs(dev, bdp);
        return -ENODEV;
    }

    /* Printout the board configuration */
    e100_print_brd_conf(bdp);
    
    /* assign driver methods */
    dev->open = &e100_open;
    dev->hard_start_xmit = &e100_xmit_frame;
    dev->stop = &e100_close;
    dev->get_stats = &e100_get_stats;
    dev->set_multicast_list = &e100_set_multi;
    dev->set_mac_address = &e100_set_mac;
    dev->do_ioctl = &e100_ioctl;
    e100nics++;
    
#ifdef E100_ETHTOOL_IOCTL
	e100_get_speed_duplex_caps(bdp);
#endif /*E100_ETHTOOL_IOCTL*/
 
#ifdef STB_WA
    if(bdp->rev_id >= D101MA_REV_ID)
    {
                __u16 id_reg;
                id_reg = ReadEEprom(bdp, EEPROM_ID_WORD);
                
                if(id_reg & (0x02)){ 
                        
                        id_reg &=  ( (__u16)(~0x02) );
                        
                        WriteEEprom(bdp, EEPROM_ID_WORD, id_reg);

                        UpdateChecksum(bdp);
                        printk("%s Changed the eeprom values\n",dev->name);
                        printk("for sane operation, a reboot is required\n");
                }
        }
#endif /* STB_WA */


    return 0;
}

/****************************************************************************
 * Name:        e100_clear_structs
 *
 * Description: free all device specific structs, unregister the device,
 *                   unmap i/o address, etc.
 *
 *             
 * Born on Date:    03/18/01
 *
 * Arguments: dev * - a pointer to the device
 *                  bdp * - a pointer to the bd_config struct associated with the device
 *
 *                  Both these parameters are needed, because this function might be called
 *                  before the 'dev' and the 'bdp' were linked to each other.
 *
 * Returns: none
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
void
e100_clear_structs(struct net_device *dev, bd_config_t *bdp)
{
    if (!dev) {
        return;
    }
    
    unregister_netdev(dev);
    
    if (!bdp) {
        kfree(dev);
        return;
    }
    
    if (bdp->scbp) {
        iounmap(bdp->scbp);
    }
    
    if (bdp->io_start) {
        release_region(bdp->io_start, 32);
    }
    
    if (bdp->ppci_dev) {
        pci_set_drvdata(bdp->ppci_dev, NULL);
    }
    
    e100_dealloc_space(bdp);
    kfree(dev);
}

static void __devexit e100_remove1(struct pci_dev *pcid)
{
    bd_config_t       *bdp;
    
    bdp = (bd_config_t *)pci_get_drvdata(pcid);

    if (!bdp)
        return;

    e100_remove_proc_subdir(bdp);

    e100_ResetPhy(bdp);
    e100_sw_reset(bdp, PORT_SOFTWARE_RESET);
    
    e100_clear_structs(bdp->device, bdp);
    
    --e100nics;
}

static struct pci_device_id e100_id_table[] __devinitdata = {
	{ 0x8086, 0x1029, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1030, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1031, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1032, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1033, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1034, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1038, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1039, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x103A, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x103B, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x103C, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x103D, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x103E, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1209, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x1229, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x2449, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x2459, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0x8086, 0x245D, PCI_ANY_ID, PCI_ANY_ID, },
	{ 0, }
};
MODULE_DEVICE_TABLE(pci, e100_id_table);
	

static struct pci_driver e100_driver = {
        name:		"e100",
        id_table:	e100_id_table,
        probe:		e100_found1,
        remove:		e100_remove1,
	suspend:	NULL,
        resume:		NULL
};

#if (defined __ia64__)
static int non_DMA32_memory_present;
#endif

static int __init e100_init_module(void)
{
#if (defined __ia64__)	
	struct sysinfo si;
	si_meminfo(&si);
	if (si.totalram >= (0x100000000UL)/PAGE_SIZE){
		non_DMA32_memory_present = 1;
	}
	else {
		non_DMA32_memory_present =0;
	}

#endif 
 
    return pci_module_init(&e100_driver);
}

static void __exit e100_cleanup_module(void)
{
    pci_unregister_driver(&e100_driver);
}

module_init(e100_init_module);
module_exit(e100_cleanup_module);
MODULE_LICENSE("Dual BSD/GPL");

/****************************************************************************
 * Name:          e100_check_options
 *
 * Description:   This routine does range checking on command-line options
 *
 * Born on Data:  05/02/2000
 *
 * Arguments:     int board
 *				  u8 rev_id  - Revision ID of the board
 *
 * Returns:       void  (cannot fail)
 *
 ***************************************************************************/
void
e100_check_options(int board, u8 rev_id)
{
    e100_set_int_option(&TxDescriptors[board], E100_MIN_TCB, E100_MAX_TCB,
                        E100_DEFAULT_TCB, "TxDescriptor count");
    
    e100_set_int_option(&RxDescriptors[board], E100_MIN_RFD, E100_MAX_RFD,
                        E100_DEFAULT_RFD, "RxDescriptor count");
    
    e100_set_int_option(&e100_speed_duplex[board], 0, 4,
                        E100_DEFAULT_SPEED_DUPLEX, "speed/duplex mode");
    
    e100_set_int_option(&ber[board], 0, ZLOCK_MAX_ERRORS,
                        E100_DEFAULT_BER, "Bit Error Rate count");

    e100_set_bool_option(&XsumRX[board], E100_DEFAULT_XSUM, "XsumRX value");
    
    /* Default ucode value depended on controller revision */
    if (rev_id >= D101MA_REV_ID) {
      e100_set_bool_option(&ucode[board], E100_DEFAULT_UCODE, "ucode value");
    } else {
      e100_set_bool_option(&ucode[board], FALSE, "ucode value");
    }

    e100_set_bool_option(&flow_control[board], E100_DEFAULT_FC, "flow control value");

    e100_set_bool_option(&IFS[board], E100_DEFAULT_IFS, "IFS value");

    e100_set_bool_option(&BundleSmallFr[board], E100_DEFAULT_BUNDLE_SMALL_FR,
                         "CPU saver bundle small frames value");

    e100_set_int_option(&IntDelay[board], 0x0, 0xFFFF, E100_DEFAULT_CPUSAVER_INTERRUPT_DELAY,
                        "CPU saver interrupt delay value");

    e100_set_int_option(&BundleMax[board], 0x1, 0xFFFF,	E100_DEFAULT_CPUSAVER_BUNDLE_MAX,
                        "CPU saver bundle max value");

}

/****************************************************************************
 * Name:          e100_set_int_option
 *
 * Description:   This routine does range checking on a command-line option.
 *                      If the option's value is '-1' use the specified default.
 *                      Otherwise, if the value is invalid, change it to the default.
 *
 * Arguments:     int *option - a pointer to the relevant option field
 *                      int min - the minimum valid value
 *                      int max - the maximum valid value
 *                      int default_val - the default value
 *                      char *name - the name of the option
 *
 * Returns:       void  (cannot fail)
 *
 ***************************************************************************/
void
e100_set_int_option(int *option, int min, int max, int default_val, char *name)
{
    if (*option == -1) {  /* no value specified. use default */
        *option = default_val;
        
    } else if ( (*option < min) || (*option > max) ) {
        printk(KERN_NOTICE "Invalid %s specified (%i). Valid range is %i-%i.\n",
               name, *option, min, max);
        printk(KERN_NOTICE "Using default %s of %i.\n", name, default_val);
        
        *option = default_val;
        
    } else {
        printk(KERN_INFO "Using specified %s of %i.\n", name, *option);
    }
}

/****************************************************************************
 * Name:          e100_set_bool_option
 *
 * Description:   This routine checks a boolean command-line option.
 *                      If the option's value is '-1' use the specified default.
 *                      Otherwise, if the value is invalid (not 0 or 1), change it to the default.
 *
 * Arguments:     int *option - a pointer to the relevant option field
 *                      int default_val - the default value
 *                      char *name - the name of the option
 *
 * Returns:       void  (cannot fail)
 *
 ***************************************************************************/
void
e100_set_bool_option(int *option, int default_val, char *name)
{
    if (*option == -1) {  /* no value specified. use default */
        *option = default_val;
        
    } else if ( (*option != TRUE) && (*option != FALSE) ) {
        printk(KERN_NOTICE "Invalid %s specified (%i). Valid values are %i/%i.\n",
               name, *option, FALSE, TRUE);
        printk(KERN_NOTICE "Using default %s of %i.\n", name, default_val);
        
        *option = default_val;
        
    } else {
	printk(KERN_INFO "Using specified %s of %i.\n", name, *option);
    }
}


/* This function handles stopping of the tx upper queue & notifies ANS accurdingly
 * param: tx_queue_stop_type - if we're not able to transmit for a __long__ time
 * (link is down) & ANS is above, we don't stop directly the queue but notify ANS
 * instead. 
 */ 
static void e100_tx_notify_stop(bd_config_t *bdp, enum tx_queue_stop_type stop_type)
{
#ifdef IANS
    if ((ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) &&
		(ANS_PRIVATE_DATA_FIELD(bdp)->reporting_mode == IANS_STATUS_REPORTING_ON)){
        if (ans_notify)
            ans_notify(bdp->device, IANS_IND_XMIT_QUEUE_FULL);
    } else {
            stop_type = SHORT_STOP;
    }
#else
    stop_type = SHORT_STOP;
#endif /* IANS */

    if(stop_type == SHORT_STOP){
	netif_stop_queue(bdp->device);
    }
}

void e100_tx_notify_start(bd_config_t *bdp, enum tx_queue_stop_type stop_type)
{
    if (bdp->flags & DF_OPENED) {
#ifdef IANS
        if ((ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) && 
			(ANS_PRIVATE_DATA_FIELD(bdp)->reporting_mode == IANS_STATUS_REPORTING_ON)){
            if (ans_notify)
                ans_notify(bdp->device, IANS_IND_XMIT_QUEUE_READY);
        }
#endif
        netif_wake_queue(bdp->device);
    }
}


/***************************************************************************/
/***************************************************************************/
/*       Driver Methods (i.e. procvars at struct net_device                    */
/***************************************************************************/

/****************************************************************************
 * Name:        e100_open
 *
 * Description: This routine is the open call for the interface.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments:    dev *
 *
 * Returns:
 *        It returns 0 on success 
 *         -EAGAIN on failure
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static int
e100_open(struct net_device * dev)
{
    bd_config_t    *bdp;
    pbuf_pool_t     ptcb_pool;

    bdp = dev->priv;

    if( ! try_read_lock(&(bdp->isolate_lock)) )
    	return -EBUSY;
    
    if (bdp->flags & DF_OPENED) {
      try_read_unlock(&(bdp->isolate_lock));
      return -EBUSY;
    }

    bdp->flags |= DF_OPENED;

    MOD_INC_USE_COUNT;
    
    bdp->rfd_head = NULL;
    
    /* setup the tcb pool */    
    if (!e100_alloc_tcbs(bdp)) {
        e100_clear_pools(bdp);
        try_read_unlock(&(bdp->isolate_lock));
        return -ENOMEM;
    }
    bdp->last_tcbp = NULL;

    ptcb_pool = &bdp->tcb_pool;
    ptcb_pool->head = 0;
    ptcb_pool->tail = 2;
    e100_setup_tcb_pool((ptcb_t) ptcb_pool->data,
        TxDescriptors[bdp->bd_number], bdp);

    /* Arrange dynamic RFD's in a circular queue & setup buffer pool */
    if (e100_alloc_rfd_pool(bdp) == NULL) {
        e100_clear_pools(bdp);
        try_read_unlock(&(bdp->isolate_lock));
        return -ENOMEM;
    }

    
    /* We have to reload CU and RU base because they could have been
       corrupted from a TCO packet */
    /* Load the CU BASE (set to 0, because we use linear mode) */
    
    writel(0,&bdp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_CUC_LOAD_BASE);

    /* Wait for the SCB command word to clear before we set the * general
     * pointer */
    if (e100_wait_scb(bdp) != B_TRUE){
        e100_clear_pools(bdp);
        try_read_unlock(&(bdp->isolate_lock));
        return -EAGAIN;
    }

    /* Load the RU BASE (set to 0, because we use linear mode) */
    writel(0,&bdp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_RUC_LOAD_BASE);
    
    /* launch the watchdog timer */
    init_timer(&bdp->timer_id);
    bdp->timer_id.expires = jiffies + (2 * HZ);
    bdp->timer_id.data = (unsigned long) dev;
    bdp->timer_id.function = (void *) &e100_watchdog;
    add_timer(&bdp->timer_id);

    netif_start_queue(dev);

    e100_start_ru(bdp);
    if (request_irq(dev->irq, &e100intr, SA_SHIRQ, e100_short_driver_name, dev)) {
        e100_clear_pools(bdp);
        del_timer_sync(&bdp->timer_id);
        try_read_unlock(&(bdp->isolate_lock));
        return -EAGAIN;
    }

    e100_enbl_intr(bdp);

    try_read_unlock(&(bdp->isolate_lock));

    return 0;
}

/****************************************************************************
 * Name:        e100_close
 *
 * Description: This routine is an entry point into the driver.
 *
 *               This is a Linux required routine.
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *         struct net_device pointer
 *
 * Returns:
 *        It returns 0 and can not fail.
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/

static int
e100_close(struct net_device * dev)
{
    bd_config_t *bdp = dev->priv;
    
    bdp->flags &= ~DF_OPENED;
    e100_isolate_driver(bdp);
    
    free_irq(dev->irq, dev);  /* we don't want to receive more interrupts */
    e100_clear_pools(bdp);
    
    e100_deisolate_driver(bdp,B_FALSE);
    
    return (0);
}


/****************************************************************************
 * Name:        e100_xmit_frame
 *
 * Description: This routine is called to transmit a frame.
 *
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *         sb_buff   pointer
 *         struct net_device pointer
 *
 * Returns:
 *        1 on failure
 *        0 on success
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static int
e100_xmit_frame(struct sk_buff * skb, struct net_device * dev)
{
    bd_config_t *bdp = dev->priv;

    if( ! try_read_lock(&(bdp->isolate_lock)) )
    	return -EBUSY;

    // check if a non-cu is currently running
    if (!spin_trylock(&bdp->bd_tx_lock)){
        e100_tx_notify_stop(bdp, SHORT_STOP);
        try_read_unlock(&(bdp->isolate_lock));
        return 1;
    }
    
    /* if there are no tcbs, tell stack to stop sending frames to us for now */
    if (!TCBS_AVAIL(&(bdp->tcb_pool))) {
        e100_tx_notify_stop(bdp, SHORT_STOP);
        spin_unlock(&bdp->bd_tx_lock);
        try_read_unlock(&(bdp->isolate_lock));
        return 1;
    }

#if (defined __ia64__)	
	if((u64) skb->head >= (PAGE_OFFSET + 0x100000000UL))
		skb_linearize(skb, GFP_ATOMIC|GFP_DMA);
#endif
    
    if (bdp->flags & USE_IPCB) 
        e100_prepare_xmit_buff(bdp, skb);
    else if (bdp->flags & IS_BACHELOR)
        e100_prepare_ext_xmit_buff(bdp, skb);
    else
        e100_prepare_xmit_buff(bdp, skb);

    bdp->drv_stats.net_stats.tx_bytes += skb->len;
    
    dev->trans_start = jiffies;
    spin_unlock(&bdp->bd_tx_lock);

    try_read_unlock(&(bdp->isolate_lock));
	
    return 0;
}


/****************************************************************************
 * Name:        e100_get_stats
 *
 * Description: This routine is called when the OS wants the nic stats returned
 *
 * Arguments:   
 *        struct net_device dev         - the device stucture to return stats on
 *
 * Returns:
 *         the address of the net_device_stats stucture for the device
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
struct net_device_stats *
e100_get_stats(struct net_device * dev)
{
    bd_config_t *bdp = dev->priv;

    /* calculate errors */
    bdp->drv_stats.net_stats.tx_errors =
        bdp->drv_stats.net_stats.tx_carrier_errors +
        bdp->drv_stats.net_stats.tx_aborted_errors;

    bdp->drv_stats.net_stats.rx_errors =
        bdp->drv_stats.net_stats.rx_crc_errors +
        bdp->drv_stats.net_stats.rx_frame_errors +
        bdp->drv_stats.net_stats.rx_length_errors +
        bdp->drv_stats.rcv_cdt_frames;

    return &(bdp->drv_stats.net_stats);
}


/****************************************************************************
 * Name:        e100_set_mac
 *
 * Description: This routine sets the ethernet address of the board
 *
 * Born on Date:    07/11/99
 *
 * Arguments:   
 *        dev    - Ptr to the dev structure for this card
 *      addr   - Ptr to the new ethernet address
 *
 * Returns:
 *      0  - If successful
 *      -1 - If not successful
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static int
e100_set_mac(struct net_device * dev, void *addr)
{
  bd_config_t    *bdp;
  struct sockaddr *p_sockaddr = (struct sockaddr *) addr;

  bdp = dev->priv;

  if (! try_read_lock(&(bdp->isolate_lock)) )
      return -1;

  if (e100_setup_iaaddr(bdp, (u8 *)(p_sockaddr->sa_data)) == B_TRUE ) {
      memcpy(&(dev->dev_addr[0]), p_sockaddr->sa_data, ETH_ALEN);
      try_read_unlock(&(bdp->isolate_lock));
      return 0;
  }
  try_read_unlock(&(bdp->isolate_lock));
  return  -1;
    
}

/*****************************************************************************
 * Name:        e100_set_multi_exec
 *
 * Description:
 *
 * Born on Date:   
 *
 * Arguments:
 *            dev - device structure
 *
 * Returns:
 *      (none)
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
static void
e100_set_multi_exec(struct net_device * dev)
{
    bd_config_t        *bdp = dev->priv;
    mltcst_cb_t        *mcast_buff;
    cb_header_t        *cb_hdr;
    struct dev_mc_list *mc_list;
    unsigned int        i;

    mcast_buff = &(bdp->pntcb->ntcb.multicast);
    cb_hdr = &(bdp->pntcb->ntcb.multicast.mc_cbhdr);

    /* initialize the multi cast command */
    cb_hdr->cb_cmd = __constant_cpu_to_le16(CB_MULTICAST);

    /* now fill in the rest of the multicast command */
    *(u16 *)(&(mcast_buff->mc_count)) = cpu_to_le16(dev->mc_count*6);
    for (i = 0, mc_list = dev->mc_list;
         (i < dev->mc_count) && (i < MAX_MULTICAST_ADDRS);
         i++, mc_list = mc_list->next) {
        /* copy into the command */
        memcpy(&(mcast_buff->mc_addr[i * ETH_ALEN]),
            (u8 *) & (mc_list->dmi_addr), ETH_ALEN);
    }

    if( e100_exec_non_cu_cmd(bdp) != B_TRUE){
            printk(KERN_WARNING "%s: Multicast setup failed\n",dev->name);
    }
    
    return;

}


/*****************************************************************************
 * Name:        e100_set_multi
 *
 * Description: this routine is called to add multicast addresses
 *
 * Born on Date:    1/5/00
 *
 * Arguments:
 *            dev - device structure
 *
 * Returns:
 *      (none)
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
static void
e100_set_multi(struct net_device * dev)
{
    bd_config_t    *bdp = dev->priv;
    u8         rx_mode;
    unsigned char       promisc_enbl;
    unsigned char       mulcast_enbl;

    if( !try_read_lock( &(bdp->isolate_lock) ) )
    	return;

    promisc_enbl = (dev->flags & IFF_PROMISC) ? B_TRUE : B_FALSE;
    mulcast_enbl = ((dev->flags & IFF_ALLMULTI) ||
                    (dev->mc_count > MAX_MULTICAST_ADDRS)) ? B_TRUE : B_FALSE;

    if (promisc_enbl == B_TRUE)       rx_mode = 3;
    else if (mulcast_enbl == B_TRUE)  rx_mode = 1;
    else                              rx_mode = 0;

    e100_config_promisc(bdp, promisc_enbl);
    e100_config_mulcast_enbl(bdp, mulcast_enbl);

    /* if rx mode has changed - reconfigure the chip */
    if (bdp->prev_rx_mode != rx_mode) {
        bdp->prev_rx_mode = rx_mode;
        e100_config(bdp);
    }

    if ((promisc_enbl == B_TRUE) || (mulcast_enbl == B_TRUE)){
                try_read_unlock(&(bdp->isolate_lock));
        return;               /* no need for Multicast Cmd */
    }
    /* get the multicast CB */
    spin_lock_bh(&(bdp->bd_tx_lock));

    e100_set_multi_exec(dev);

    spin_unlock_bh(&(bdp->bd_tx_lock));
    e100_tx_notify_start(bdp, SHORT_STOP);

    try_read_unlock(&(bdp->isolate_lock));
    return;
}



/****************************************************************************
 * Name:    e100_ioctl
 *
 * Description: Driver's ioctl method
 *
 * Arguments: 
 *        
 * Returns: 0 - on success, negative value on failure
 ****************************************************************************/
static int
e100_ioctl(struct net_device *dev, struct ifreq *ifr, int cmd)
{
#ifdef IANS
    bd_config_t * bdp = dev->priv;

    /* get the private data structure from the dev struct */
    BOARD_PRIVATE_STRUCT *bps = dev->priv;
    IANS_BD_PARAM_HEADER *header =  (IANS_BD_PARAM_HEADER *)ifr->ifr_data;
    iANSsupport_t *iANSdata = ANS_PRIVATE_DATA_FIELD(bps);
    BD_ANS_STATUS status;
#endif

#ifdef IDIAG_PRO_SUPPORT
    idiag_pro_stat_t diag_status;
    idiag_pro_data_t *diag_data = (idiag_pro_data_t *)ifr->ifr_data;
#endif    

    
    /* switch on the command */
    switch(cmd) {
#ifdef IANS     
    case IANS_BASE_SIOC:
    	if( !try_read_lock( &(bdp->isolate_lock) ))
    		return -EAGAIN;
        status = bd_ans_ProcessRequest(bps, iANSdata, header);
        try_read_unlock( &(bdp->isolate_lock) );
        if (status == BD_ANS_SUCCESS)
            return 0;
        /* some problem occured, return error value */
        return -EAGAIN;
#endif

#ifdef IDIAG_PRO_SUPPORT
    case IDIAG_PRO_BASE_SIOC:
        diag_status = e100_run_diag (dev, diag_data);
        switch (diag_status) {
        case IDIAG_PRO_STAT_OK:
	    case IDIAG_PRO_STAT_TEST_FAILED: 
            return 0;
        case IDIAG_PRO_STAT_NOT_SUPPORTED:
	        return -EINVAL;
	    case IDIAG_PRO_STAT_INVALID_STATE:
	        return -EBUSY;
	    default: /* should not happen*/
	        return -EINVAL;
	}
#endif /* IDIAG_PRO_SUPPORT */

#ifdef E100_ETHTOOL_IOCTL
	case SIOCETHTOOL:		
		return e100_do_ethtool_ioctl(dev, ifr); 
		break;
#endif /*E100_ETHTOOL_IOCTL*/

#ifdef E100_MII_IOCTL
	case SIOCGMIIPHY:		/* Get address of MII PHY in use. */
	case SIOCGMIIREG:		/* Read MII PHY register. */
	case SIOCSMIIREG:		/* Write to MII PHY register. */
		return e100_mii_ioctl(dev, ifr, cmd);
		break;
#endif /*E100_MII_IOCTL*/

    default:
        return -EOPNOTSUPP;
    }
    return 0;

}


/***************************************************************************/
/***************************************************************************/
/*       Initialization Routines                                           */
/***************************************************************************/


/****************************************************************************
 * Name:        e100init
 *
 * Description: This routine is called when this driver is loaded. This is
 *        the initialization routine which allocates memory
 *        configures the adapter & determines the system
 *        resources.
 *
 * Arguments: bd_config_t *bdp  
 *        
 *
 * Returns:
 *       NONE 
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
int
e100init(bd_config_t * bdp)
{
    struct net_device       *dev = bdp->device;

    /* init private vars: never fails */
    e100_sw_init(bdp);    

    /* Do a self test of the adapter */
    if (e100_selftest(bdp, NULL, NULL) != B_TRUE) {
        printk(KERN_ERR "selftest failed\n");
        return 0;
    }

    /* read the MAC address from the eprom */
    e100_rd_eaddr(bdp);
    /* read NIC's part number */
    e100_rd_pwa_no(bdp);

    /* Do the adapter initialization */
    if (!e100_hw_init(bdp, PORT_SOFTWARE_RESET)) {
        printk(KERN_ERR "hw init failed\n");
        return 0;
    }
    /* Disable interrupts on the PRO/100 card */
    e100_dis_intr(bdp);

    dev->base_addr = bdp->io_start;


    return 1;
}


/****************************************************************************
 * Procedure : e100_sw_init
 * 
 * Description : This routine initializes all software structures. Sets up
 *    the circular structures for the RFD's & TCB's. Allocates the per board
 *    structure for storing adapter information. The CSR is also memory 
 *    mapped in this routine.
 *
 * Input : 
 *    bdp - 
 *
 * Returns :
 *    B_TRUE  - if successfully initialized
 *    B_FALSE - if S/W initialization failed
 */
unsigned char
e100_sw_init(bd_config_t * bdp)
{
#ifdef IANS
    bd_ans_drv_InitANS(bdp, bdp->iANSdata);
#endif
    
    bdp->next_cu_cmd = START_WAIT; // init the next cu state
    bdp->prev_rx_mode = 0;
    
    /* 
     * Set the value for # of good xmits per underrun. the value assigned
     * here is an intelligent  suggested default. Nothing magical about it.
     */
    bdp->tx_per_underrun = DEFAULT_TX_PER_UNDERRUN;

    /* get the default transmit threshold value */
    bdp->tx_thld = e100_tx_thld;

    /* get the EPROM size */
    bdp->EEpromSize = GetEEpromSize(bdp);

    /* Initialize our spinlocks */
    spin_lock_init(&(bdp->bd_lock));
    spin_lock_init(&(bdp->bd_tx_lock));
    spin_lock_init(&(bdp->config_lock));
    spin_lock_init(&(bdp->mdi_access_lock));
    
    lock_init(&(bdp->isolate_lock));
    
    bdp->ZeroLockState = ZLOCK_INITIAL;
    
    return 1;
}


/*****************************************************************************
 * Procedure:   e100_hw_init
 *
 * Description: This routine performs a reset on the adapter, and configures
 *              the adapter.  This includes configuring the 82557 LAN
 *              controller, validating and setting the node address, detecting
 *              and configuring the Phy chip on the adapter, and initializing
 *              all of the on chip counters.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *        reset_cmd - s/w reset or selective reset. 
 *
 * Returns:
 *      B_TRUE - If the adapter was initialized
 *      B_FALSE - If the adapter failed initialization
 */
unsigned char
e100_hw_init(bd_config_t * bdp, u32 reset_cmd)
{
    /* Detect the serial component, and set up the Phy if necessary */
    if (!e100_phydetect(bdp))
        return (B_FALSE);
    
    e100_fix_polarity(bdp);
    
    /* Issue a software reset to the e100 */
    e100_sw_reset(bdp, reset_cmd);

    /* Load the CU BASE (set to 0, because we use linear mode) */

    writel(0,&bdp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_CUC_LOAD_BASE);
    

    /* Wait for the SCB command word to clear before we set the * general
     * pointer */
    if (e100_wait_scb(bdp) != B_TRUE)
        return (B_FALSE);

    /* Load the RU BASE (set to 0, because we use linear mode) */
    writel(0,&bdp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_RUC_LOAD_BASE);

    /* Load interrupt microcode  */
    if (e100_load_microcode(bdp, bdp->rev_id) == B_TRUE) {
        bdp->flags |= DF_UCODE_LOADED;
        mdelay(1);   
    }
    /* Configure the adapter in non promiscuous mode */
    e100_config_init(bdp);
    if (e100_config(bdp) != B_TRUE) {
        return (B_FALSE);
    }
   
    if (e100_setup_iaaddr(bdp, bdp->device->dev_addr) != B_TRUE)
        return (B_FALSE);

    /* Clear the internal counters */
    if (e100_clr_cntrs(bdp) != B_TRUE)
        return (B_FALSE);

    /* Change for 82558 enhancement */
    /* If 82558/9 and if the user has enabled flow control, set up * the
     * Flow Control Reg. in the CSR */
    if ((bdp->flags & IS_BACHELOR) && (flow_control[bdp->bd_number] == TRUE)) {
        writeb(DFLT_FC_THLD,&bdp->scbp->scb_ext.d101_scb.scb_fc_thld);
        writeb(DFLT_FC_CMD,&bdp->scbp->scb_ext.d101_scb.scb_fc_xon_xoff);
    }

    return (B_TRUE);
}



/**************************************************************************** 
 * Procedure : e100_setup_tcb_pool
 * 
 * Description : This routine arranges the contigiously allocated TCB's 
 *    in a circular list . Also does the one time initialization of the 
 *    TCBs.
 *
 * Input : 
 *    head - Pointer to head of the allocated TCBs'.
 *    qlen - Number of elements in the queue.
 *    bdp    - Ptr to this card's e100_bdconfig structure
 *
 * Returns :
 *    NONE
 */
static void
e100_setup_tcb_pool(ptcb_t head, unsigned int qlen, bd_config_t * bdp)
{
    int             ele_no;
    ptcb_t          pcurr_tcb;   /* point to current tcb */
    ptcb_t          pnext_tcb;   /* point to next tcb */
    u32             next_paddr;   /* the next phys addr */

    pcurr_tcb = head;
    pnext_tcb = head;

    for (ele_no = 0, next_paddr = bdp->tcb_paddr;
         ele_no < qlen; ele_no++, pcurr_tcb++) {

        /* set the phys addr for this TCB, next_paddr has not incr. yet */
        pcurr_tcb->tcb_paddr = next_paddr;

        pnext_tcb++;         /* point to next tcb */

        next_paddr += sizeof(tcb_t);

        /* set the link to next tcb */
        if (ele_no == (qlen - 1))
            pcurr_tcb->tcb_hdr.cb_lnk_ptr = cpu_to_le32( bdp->tcb_paddr);
        else
            pcurr_tcb->tcb_hdr.cb_lnk_ptr = cpu_to_le32(next_paddr);
        
        /* initialize TCB status to zero */
        pcurr_tcb->tcb_hdr.cb_status = 0;

        
        /* init the fixed fields in the TCB */
        pcurr_tcb->tcb_cnt = 0; //no immidiate data
        if (bdp->flags & IS_BACHELOR) {
                pcurr_tcb->tcb_tbd_num = 0xff; 
                
                pcurr_tcb->tcb_tbd_ptr = 
                        __constant_cpu_to_le32(0xFFFFFFFF);
                /* set the 2nd tbd to end the chain */
                (pcurr_tcb->tcbu).tcb_ext.tbd1_buf_addr = 
                        __constant_cpu_to_le32(0xFFFFFFFF);
                (pcurr_tcb->tcbu).tcb_ext.tbd1_buf_cnt  = 
                        __constant_cpu_to_le32(CB_EL_BIT);
        }
        /* initialize TCB skb pointer to NULL */
        pcurr_tcb->tcb_skb = NULL;


        if(ele_no < 2){
                pcurr_tcb->tcb_hdr.cb_status = 
                        cpu_to_le16(CB_STATUS_COMPLETE);
        }
        /* initialize the early xmit threshold */
        pcurr_tcb->tcb_thrshld = bdp->tx_thld;
    }
    

    return;
}




/***************************************************************************/
/***************************************************************************/
/*       Memory Management Routines                                        */
/***************************************************************************/



/****************************************************************************
 * Name:        e100_alloc_space
 *
 * Description : This routine allocates memory for
 *                the driver. Memory allocated is for the following structures
 *               - bdp 
 *               - error count structure for adapter statistics
 *
 * Arguments:   
 *   pcid: ptr to pci device  kernel struct
 *
 * Returns: bd_config_t *
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
unsigned char
e100_alloc_space(struct pci_dev *pcid, bd_config_t **bdpp)
{
    bd_config_t    *bdp, *temp_bd;
    
    /* allocate space for the private structures */
    if (!(bdp = (bd_config_t *) kmalloc(sizeof(bd_config_t), GFP_ATOMIC)))
        return B_FALSE;
    memset(bdp, 0x00, sizeof(*bdp));
    
    *bdpp = bdp;
    
    /* link the bdp's, if needed */
    if (!e100_first) {         /* do we have at least 1 already alloc'd? */
        e100_first = bdp;
        bdp->bd_number = 0;
        bdp->bd_next = NULL;
        bdp->bd_prev = NULL;
    } else {
        /* No, so find last in list and link the new one in */
        temp_bd = e100_first;
        bdp->bd_number = 1;      /* it is at least 1 */
        while (temp_bd->bd_next != NULL) {
            temp_bd = (bd_config_t *) temp_bd->bd_next;
            bdp->bd_number++;   /* set the board number */
        }
        temp_bd->bd_next = bdp;
        bdp->bd_next = NULL;
        bdp->bd_prev = temp_bd;
    }
    
#ifdef IANS
    if (!(bdp->iANSdata = kmalloc(sizeof(iANSsupport_t), GFP_ATOMIC)))
        return B_FALSE;
    memset((void *) bdp->iANSdata, 0, sizeof(iANSsupport_t));
#endif
      
    /* allocate space for self test results */
    if (!(bdp->pselftest = 
	  pci_alloc_consistent(pcid,sizeof(self_test_t),&(bdp->selftest_paddr) )))
        return B_FALSE;
    
    /* allocate space for 82557 adapter statistics area */
    if (!(bdp->pstats_counters = 
	  pci_alloc_consistent(pcid,sizeof(max_counters_t),&(bdp->stat_cnt_paddr) )))
      return B_FALSE;
   
    
    /* allocate space for non transmit cb commands */
     if (!(bdp->pntcb =
	   pci_alloc_consistent(pcid,sizeof(nxmit_cb_t),&bdp->nontx_paddr)))
       return B_FALSE;
      
      return B_TRUE;
}


/****************************************************************************
 * Name:        e100_alloc_tcbs
 *
 * Description : This routine allocates memory for the transmit
 *               descriptors.
 *
 * Arguments:   
 *    bd_config_t *
 *
 * Returns:
 *       0 - Allocation has failed.
 *       1 - Otherwise. 
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
int
e100_alloc_tcbs(bd_config_t *bdp)
{
    int stcb = sizeof(tcb_t) * TxDescriptors[bdp->bd_number];
    int stbd = sizeof(tbd_t) * TxDescriptors[bdp->bd_number];
    
    /* allocate space for the TCBs */
    if (!(bdp->tcb_pool.data = 
	  pci_alloc_consistent(bdp->ppci_dev,stcb,&bdp->tcb_paddr)))
      return 0;

    memset(bdp->tcb_pool.data, 0x00, stcb);

    /* there is ALWAYS only going to 1 phys frag  */
    /* tbd_paddr is a phys_addr but stored as an unsigned long */
    if (!(bdp->tbd_pool.data =
	  pci_alloc_consistent(bdp->ppci_dev,stbd,&(bdp->tbd_paddr))))
      return 0;
    
    memset(bdp->tbd_pool.data, 0x00, stbd);

    return 1;
}

void
e100_free_tbds(bd_config_t * bdp)
{
    pci_free_consistent(bdp->ppci_dev, sizeof(tcb_t) * TxDescriptors[bdp->bd_number],
                        bdp->tcb_pool.data, bdp->tcb_paddr);
    pci_free_consistent(bdp->ppci_dev, sizeof(tbd_t) * TxDescriptors[bdp->bd_number],
                        bdp->tbd_pool.data, bdp->tbd_paddr);
}

/****************************************************************************
 * Name:        e100_dealloc_space
 *
 * Description : This routine frees all the memory allocated by "alloc_space".
 *               and e100_alloc_tbds.
 *
 * Born on Date:    7/17/97
 *
 * Arguments:   bd_config_t * 
 *
 * Returns:
 *    none
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  -------------------------------------------------------- 
 *
 ****************************************************************************/
static void
e100_dealloc_space(bd_config_t * bdp)
{
  /* do we have valid board structure? */
  if (!bdp)
      return;

#ifdef IANS
  COND_FREE(bdp->iANSdata);
#endif
 
  pci_free_consistent(bdp->ppci_dev,sizeof(self_test_t),
                      bdp->pselftest,bdp->selftest_paddr);
  pci_free_consistent(bdp->ppci_dev,sizeof(max_counters_t),
                      bdp->pstats_counters,bdp->stat_cnt_paddr);
  pci_free_consistent(bdp->ppci_dev,sizeof(nxmit_cb_t),
                      bdp->pntcb,bdp->nontx_paddr);

  bdp->tcb_paddr = 0;
  bdp->tbd_paddr = 0;
  bdp->selftest_paddr = 0;
  bdp->stat_cnt_paddr = 0;
  bdp->nontx_paddr = 0;

  /* un-link the bdp from the linked list */
  if (bdp == e100_first) {
    e100_first = (bd_config_t *) bdp->bd_next;
    if (bdp->bd_next)
      ((bd_config_t *) bdp->bd_next)->bd_prev = NULL;
  } else {
    if (bdp->bd_next)
      ((bd_config_t *) bdp->bd_next)->bd_prev = bdp->bd_prev;
    if (bdp->bd_prev)
      ((bd_config_t *) bdp->bd_prev)->bd_next = bdp->bd_next;
  }
    
  kfree(bdp);
}

void
e100_free_rfd_pool(bd_config_t *bdp)
{
    struct sk_buff  *skb, *nskb;

    while (bdp->rfd_head != NULL) {
        skb = bdp->rfd_head;
        nskb = skb->next;
        // use TODEVICE to avoid memcpy 
        pci_unmap_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb),
			 sizeof(rfd_t),PCI_DMA_TODEVICE);
	dev_kfree_skb_irq(skb);
        bdp->rfd_head = nskb;
    }
    bdp->rfd_head = NULL;
    bdp->rfd_tail = NULL;
}



/* 
 * Procedure : e100_alloc_rfd_pool
 *
 * Description : allocates initial pool of skb which holds both rfd and data
 * Input : 
 *    bdp  - pointer to board specific data
 *
 * Returns :
 *    pointer to head of list
 */

static struct sk_buff *
e100_alloc_rfd_pool(bd_config_t *bdp)
{
    struct sk_buff *nskb;
    
    bdp->rfd_tail = NULL;
    bdp->rfd_head = NULL;
    bdp->skb_req  = RxDescriptors[bdp->bd_number];

    ALLOC_SKBS(bdp, nskb);
    return bdp->rfd_head;
}


/****************************************************************************
 * Name:        e100_clear_pools
 *
 * Description: free all Tx/Rx pools, decrease useage counters, etc.
 *
 *             
 * Born on Date:    03/18/01
 *
 * Arguments: bdp * - a pointer to the bd_config struct associated with the device
 *
 * Returns: none
 *
 ****************************************************************************/
void
e100_clear_pools(bd_config_t *bdp)
{
    bdp->last_tcbp = NULL;
    e100_free_rfd_pool(bdp);
    e100_free_tbds(bdp);
    bdp->flags &= ~DF_OPENED;
    MOD_DEC_USE_COUNT;
}


/*****************************************************************************/
/*****************************************************************************/
/*      Run Time Functions                                                   */
/*****************************************************************************/ 

/*****************************************************************************
 * Name:        e100_watchdog
 *
 * Description: This routine updates our statitics and refreshs the txthld
 *                  value.
 *
 * Born on Date:    1/5/00
 *
 * Arguments:
 *            dev - device structure
 *
 * Returns:
 *      (none)
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
void
e100_watchdog(struct net_device * dev)
{
    bd_config_t    *bdp = dev->priv;

    if(!try_read_lock(&(bdp->isolate_lock)) || !(bdp->flags & DF_OPENED) )
    	return;
    
    spin_lock_bh(&(bdp->mdi_access_lock));

    e100_phy_check(bdp);
    // toggle the tx queue according to link status
    // this also resolves a race condition between tx & non-cu cmd flows
    if (bdp->flags & DF_LINK_UP){
            e100_tx_notify_start(bdp, LONG_STOP);
    } else {
            e100_tx_notify_stop(bdp, LONG_STOP);
    }

    if (e100_update_stats(bdp) == B_TRUE) {
        
        /* Check if a change in the IFS parameter is needed,
           and configure the device accordingly */
        if (IFS[bdp->bd_number] == TRUE)
            e100_manage_adaptive_ifs(bdp);
        
        /* Now adjust our dynamic tx threshold value */
        e100_refresh_txthld(bdp);
        
        /* Now if we are on a 557 and we havn't received any frames then we
         * should issue a multicast command to reset the RU */
        if (bdp->rev_id < D101A4_REV_ID)  {
            if (bdp->pstats_counters->basic_stats.rcv_gd_frames == 0) {
                e100_set_multi(dev);
            }
        }
        
        /* Update the statistics needed by the upper interface */
        /* This should be the last statistic related command
         * as it's async. now */
        e100_dump_stats_cntrs(bdp);
    }
   
#ifdef IANS
    /* Now do the ANS stuff */
    if ((ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) &&
        (ANS_PRIVATE_DATA_FIELD(bdp)->reporting_mode == IANS_STATUS_REPORTING_ON))
    {
        bd_ans_os_Watchdog(dev, bdp);
    }
#endif

    e100_handle_zero_lock_state(bdp);
 
	spin_unlock_bh(&(bdp->mdi_access_lock));

    /* relaunch watchdog timer in 2 sec */
	bdp->timer_id.expires = jiffies + (2 * HZ);
	add_timer(&bdp->timer_id);

    if (bdp->rfd_head == NULL) 
        e100_trigger_SWI(bdp);
    
    try_read_unlock(&(bdp->isolate_lock));

    return;
}

/*
 * Procedure:  e100_manage_adaptive_ifs
 *
 * Description: This routine manages the adaptive IFS algorithm
 *              using a state machine.
 *
 * Returns:
 *      NONE
 *
 */

void
e100_manage_adaptive_ifs(bd_config_t *bdp)
{
    static u16 state_table[9][4] = {     // rows are states
        {2, 0,  0,  0},   // state0         // column0: next state if increasing
        {2, 0,  5, 30},   // state1         // column1: next state if decreasing
        {5, 1,  5, 30},   // state2         // column2: IFS value for 100 mbit
        {5, 3,  0,  0},   // state3         // column3: IFS value for 10 mbit
        {5, 3, 10, 60},   // state4
        {8, 4, 10, 60},   // state5
        {8, 6,  0,  0},   // state6
        {8, 6, 20, 60},   // state7
        {8, 7, 20, 60}    // state8
    };

    u32 transmits  = le32_to_cpu(bdp->pstats_counters->basic_stats.xmt_gd_frames);
    u32 collisions = le32_to_cpu(bdp->pstats_counters->basic_stats.xmt_ttl_coll);
    u32 state      = bdp->ifs_state;
    u32 old_value  = bdp->ifs_value;
    int next_col;
    u32 min_transmits;
    
    if (bdp->cur_dplx_mode == FULL_DUPLEX) {
        bdp->ifs_state = 0;
        bdp->ifs_value = 0;

    } else {   /* Half Duplex */
        /* Set speed specific parameters */
        if (bdp->cur_line_speed == 100) {
            next_col = 2;
            min_transmits = MIN_NUMBER_OF_TRANSMITS_100;
            
        } else {   /* 10 Mbps */
            next_col = 3;
            min_transmits = MIN_NUMBER_OF_TRANSMITS_10;
        }
        
        if ((transmits / 32 < collisions) && (transmits > min_transmits)) {
            state = state_table[state][0];                 /* increment */
            
        } else if (transmits < min_transmits) {
            state = state_table[state][1];                 /* decrement */
        }
        
        bdp->ifs_value = state_table[state][next_col];
        bdp->ifs_state = state;
    }        

    /* If the IFS value has changed, configure the device */
    if (bdp->ifs_value != old_value) {
        e100_config_ifs(bdp);
        e100_config(bdp);
    }
}


/* 
 * Procedure:   e100intr
 *
 * Description: This routine is the ISR for the e100 board. It services
 *        the RX & TX queues & starts the RU if it has stopped due
 *        to no resources.
 *
 * Returns:
 *      NONE
 *
 */
void
e100intr(int irq, void *dev_inst, struct pt_regs *regs)
{
    struct net_device *dev;
    bd_config_t       *bdp;
    u16                intr_status;
   
    dev = (struct net_device *) dev_inst;
    bdp = dev->priv;



    intr_status = readw(&bdp->scbp->scb_status) ;
    if (!intr_status){ 
            return;   
    }

    /* disable intr before we ack & after identifying the intr as ours*/
    e100_dis_intr(bdp);

    writew(intr_status,&bdp->scbp->scb_status);   /* ack intrs */   
    
    //the device is closed, don't continue or else bad things may happen.
    if(!(bdp->flags & DF_OPENED)){
            return;
    }
    if (!try_read_lock( &(bdp->isolate_lock) )){
            // avoid race condition & enable intr
            e100_enbl_intr(bdp);
            return;
    }

        
    /* SWI intr (triggered by watchdog) is signal to allocate new skb buffers */
    if (intr_status & SCB_STATUS_ACK_SWI) {
        struct sk_buff  *nskb;
        ALLOC_SKBS(bdp, nskb);
    }
    /* do recv work if any */
    if (intr_status & (SCB_STATUS_ACK_FR | SCB_STATUS_ACK_RNR | SCB_STATUS_ACK_SWI)) {

        e100_rx_srv(bdp);  
        /* restart the RU if it has stopped */
        if ((readw(&bdp->scbp->scb_status) & SCB_RUS_MASK) != SCB_RUS_READY) 
            e100_start_ru(bdp);
    }
    
    /* clean up after tx'ed packets */
    if (intr_status & (SCB_STATUS_ACK_CNA | SCB_STATUS_ACK_CX)) {
        bdp->tx_count = 0;   /* restart tx interrupt batch count */
        e100_tx_srv(bdp);
    }

    e100_enbl_intr(bdp);
	
    try_read_unlock(&(bdp->isolate_lock));
   
    return;
    
}

/* 
 * Procedure:   e100_tx_skb_free
 *
 * Description: routine to free resources of TX skbs.
 *
 *Arguments:
 * bdp - Ptr to this card's e100_bdconfig structure.
 * tcbp- Ptr to the associated tcb of the freed skb.
 *
 * Returns:
 * NONE
 */
static void inline e100_tx_skb_free(bd_config_t * bdp,tcb_t *tcbp)
{
  if (tcbp->tcb_skb) {
    pci_unmap_single(bdp->ppci_dev,tcbp->dma_data_addr,tcbp->tcb_skb->len,PCI_DMA_TODEVICE);
    dev_kfree_skb_irq(tcbp->tcb_skb);
    tcbp->tcb_skb = NULL;
  }
} 

/* 
 * Procedure:   e100_tx_srv
 *
 * Description: This routine services the TX queues. It reclaims the
 *        TCB's & TBD's & other resources used during the transmit
 *        of this buffer. It is called from the ISR. We don't need a tx_lock
 * 	  since we always access buffers which were already prepared.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    NONE
 */



void
e100_tx_srv(bd_config_t * bdp)
{
    buf_pool_t        *tcb_poolp;
    unsigned int       tcb_head = 0;
    tcb_t             *tcbp;
    int                loop_cnt = 0;

    tcb_poolp = &bdp->tcb_pool;
    tcb_head = tcb_poolp->head;
    tcbp = tcb_poolp->data;
    tcbp += tcb_head;

    while ((tcbp->tcb_hdr.cb_status & 
	    __constant_cpu_to_le16(CB_STATUS_COMPLETE)) &&
        (loop_cnt < TxDescriptors[bdp->bd_number])) {

        if (IS_IT_GAP(tcb_poolp)) {
	    e100_tx_skb_free(bdp,tcbp);
            /* move head to next buffer & service it */
            if ((tcb_head + 1) >= TxDescriptors[bdp->bd_number])
                tcbp = tcb_poolp->data;
            else
                tcbp++;

            if (tcbp->tcb_hdr.cb_status & __constant_cpu_to_le16(CB_STATUS_COMPLETE)) {
                e100_tx_skb_free(bdp,tcbp);
            }
            e100_tx_notify_start(bdp, SHORT_STOP);
            break;
        }

	e100_tx_skb_free(bdp,tcbp);    

        /* clear the out of resource condition */
        e100_tx_notify_start(bdp, SHORT_STOP);

        /* move head to next buffer & service it */
        tcb_head++;
        /* check for wrap condition */
        if (tcb_head >= TxDescriptors[bdp->bd_number]) {
            tcb_head = 0;
            tcbp = tcb_poolp->data;
        } else
            tcbp++;
        tcb_poolp->head = tcb_head;
        loop_cnt++;

        tcb_poolp->head = tcb_head;

    }                     /* end of while */

    tcb_poolp->head = tcb_head;
    return;
}

/* 
 * Procedure:   e100_rx_srv
 *
 * Description: This routine processes the RX interrupt & services the 
 *        RX queues. For each successful RFD, it allocates a new msg
 *        block, links that into the RFD list, & sends the old msg upstream.
 *        The new RFD is then put at the end of the free list of RFD's.
 *
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    NONE
 */
void
e100_rx_srv(bd_config_t * bdp)
{
    rfd_t          *rfdp;      /* new rfd, received rfd */
    int          i;
    u16        rfd_status;
    struct sk_buff      *skb, *nskb;
    struct net_device       *dev;
    unsigned int data_sz;
    unsigned int rx_congestion = 0;
    
    dev = bdp->device;
    
    /* current design of rx is as following:
     * 1. socket buffer (skb) used to pass network packet to upper layer
     * 2. all HW host memory structures (like RFDs, RBDs and data buffers)
     *    are placed in a skb's data room
     * 3. when rx process is complete, we change skb internal pointers to exclude
     *    from data area all unrelated things (RFD, RDB) and to leave
     *    just rx'ed packet netto
     * 4. for each skb passed to upper layer, new one is allocated instead.
     * 5. if no skb left, in 2 sec another atempt to allocate skbs will be made
     *    (watchdog trigger SWI intr and isr should allocate new skbs)
     */
    
    for (i = 0; i < RxDescriptors[bdp->bd_number] ; i++ ) {
        skb = bdp->rfd_head;
        if (skb == NULL) /* no buffers left - exit and watchdog take care later */
            return;  
	
        rfdp = RFD_POINTER(skb, bdp);            /* locate RFD within skb */
	
        // sync only the RFD header
        pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb),
			    bdp->rfd_size,PCI_DMA_FROMDEVICE);
        rfd_status = le16_to_cpu(rfdp->rfd_header.cb_status);  /* get RFD's status */
        if (!(rfd_status & RFD_STATUS_COMPLETE))  /* does not contains data yet - exit */
            return;
        
        /* to allow manipulation with current skb we need to advance rfd head */
        bdp->rfd_head = skb->next;
		if (bdp->rfd_tail == skb){
			bdp->rfd_tail = NULL;
		}
        data_sz = le16_to_cpu(rfdp->rfd_act_cnt) & 0x3fff;
        
        // now sync all the data 
        pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb),
                            E100_MIN(data_sz+bdp->rfd_size,sizeof(rfd_t)),
                            PCI_DMA_FROMDEVICE);
        
        // we unmap using DMA_TODEVICE to avoid another memcpy from the 
        // bounce buffer
        pci_unmap_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb),
			 sizeof(rfd_t),PCI_DMA_TODEVICE);
        /* do not free badly recieved packet - move it to the end of skb list for reuse */
        if (!(rfd_status & RFD_STATUS_OK) || rx_congestion) {
            e100_add_skb_to_end(bdp, skb);
            continue;
        }
        /* end of dma access to rfd */
	
        
        bdp->skb_req++;           /* incr number of requested skbs */
        ALLOC_SKBS(bdp, nskb);    /* and get them */
        
        /* set packet size, excluding checksum (2 last bytes) if it is present */
        if ((bdp->flags & DF_CSUM_OFFLOAD) && (bdp->rev_id < D102_REV_ID)) 
            skb_put(skb,(int) data_sz - 2);
        else 
            skb_put(skb, (int)data_sz);
        
#ifdef IANS
        /* Before we give it to the stack lets let ANS process it */
        if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP)   {
            if (bd_ans_os_Receive(bdp, RFD_POINTER(skb, bdp), skb)  == BD_ANS_FAILURE) {
                    dev_kfree_skb_irq(skb);
                continue;
            }
        } else 
#endif /* IANS */         
                                /* set the protocol */
            skb->protocol = eth_type_trans(skb, dev);

        /* set the checksum info */
  
        if (bdp->flags & DF_CSUM_OFFLOAD) {
            if(bdp->rev_id >= D102_REV_ID)  {
                    skb->ip_summed = e100_D102_check_checksum(rfdp);
            } 
            else {
                    skb->ip_summed = e100_D101M_checksum(bdp, rfdp, skb);
            }
        } else {
                skb->ip_summed = CHECKSUM_NONE;
        }

#if (defined __ia64__)	
	//Free low-memory skb buffer without passing it up to the IP stack
		if (non_DMA32_memory_present){
			skb_linearize(skb,GFP_ATOMIC);
		}
#endif 
        
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
        netif_rx(skb);
        
        bdp->drv_stats.net_stats.rx_bytes += skb->len;
#else
        
        if (netif_rx(skb) != NET_RX_DROP) {
            bdp->drv_stats.net_stats.rx_bytes += skb->len;
        } else {
                                /* recycle pending RFDs */
            rx_congestion = 1;
        }
#endif
    }                       /* end of rfd loop */
    
    return;
}


/* 
 * Procedure:   e100_refresh_txthld
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    -     NONE
 */
void
e100_refresh_txthld(bd_config_t * bdp)
{
    basic_cntr_t *pstat = &(bdp->pstats_counters->basic_stats);
    /* as long as tx_per_underrun is not 0, we can go about dynamically *
     * adjusting the xmit threshold. we stop doing that & resort to defaults
     * * once the adjustments become meaningless. the value is adjusted by *
     * dumping the error counters & checking the # of xmit underrun errors *
     * we've had. */
    if (bdp->tx_per_underrun) {
        /* We are going to last values dumped from the dump statistics
         * command */
        if (le32_to_cpu(pstat->xmt_gd_frames)) {
            if (le32_to_cpu(pstat->xmt_uruns)) {
                /* 
                 * if we have had more than one underrun per "DEFAULT #
                 * OF XMITS ALLOWED PER UNDERRUN" good xmits, raise the
                 * THRESHOLD.
                 */
                if ((le32_to_cpu(pstat->xmt_gd_frames) /
                    le32_to_cpu(pstat->xmt_uruns)) <
                    bdp->tx_per_underrun) {
                    bdp->tx_thld += 3;
                }
            }

            /* 
             * if we've had less than one underrun per the DEFAULT number of
             * of good xmits allowed, lower the THOLD but not less than 0 
             */
            if (le32_to_cpu(pstat->xmt_gd_frames) >
                bdp->tx_per_underrun) {
                bdp->tx_thld--;

                if (bdp->tx_thld < 6)
                    bdp->tx_thld = 6;

            }
        }

        /* end good xmits */
        /* 
         * * if our adjustments are becoming unresonable, stop adjusting &
         * resort * to defaults & pray. A THOLD value > 190 means that the
         * adapter will * wait for 190*8=1520 bytes in TX FIFO before it
         * starts xmit. Since * MTU is 1514, it doesn't make any sense for
         * further increase. */
        if (bdp->tx_thld >= 190) {
            bdp->tx_per_underrun = 0;
            bdp->tx_thld = 189;
        }
    }                     /* end underrun check */
    return;
}


/* 
 * Procedure:   e100_prepare_xmit_buff
 *
 * Description: This routine prepare a buffer for transmission. It checks
 *        the message length for the appropiate size. It picks
 *        up a free tcb from the TCB pool & sets up the corresponding
 *        TBD's. If number of fragments are more the the # of TBD/TCB
 *        it copies all the fragments in a coalesce buffer. 
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *      ksb    - Ptr to the skb to send
 *
 * Returns:
 *     ptcb   - Ptr to the prepared TCB
 */
static          ptcb_t
e100_prepare_xmit_buff(bd_config_t * bdp, struct sk_buff * skb)
{
    buf_pool_t     *tcb_poolp;
    buf_pool_t     *tbd_poolp;
    tcb_t          *tcbp, *prev_tcbp;
    tbd_t          *tbdp;
    u16            txcommand;

    tcb_poolp = &(bdp->tcb_pool);
    tbd_poolp = &(bdp->tbd_pool);
    tcbp = tcb_poolp->data;
    tbdp = tbd_poolp->data;

    /* get the TCB & the TBD we may be using for this MSG */
    tcbp += TCB_TO_USE(tcb_poolp);
    tbdp += (TCB_TO_USE(tcb_poolp));

    if (bdp->flags & USE_IPCB) {
      //TBD how do we treat packed integers on multi_platforms
        (tcbp->tcbu).ipcb.ip_activation_high = IPCB_IP_ACTIVATION_DEFAULT;
        (tcbp->tcbu).ipcb.vlan = 0;
        txcommand = CB_IPCB_TRANSMIT | CB_S_BIT | CB_TX_SF_BIT | CB_CID_DEFAULT;
    }
    else 
        txcommand = CB_TRANSMIT | CB_S_BIT | CB_TX_SF_BIT | CB_CID_DEFAULT;
   
#ifdef IANS
    if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) 
        bd_ans_os_Transmit(bdp, tcbp, &skb);
#endif
    tcbp->tcb_hdr.cb_status = 0;
    tcbp->tcb_cnt = 0;
    tcbp->tcb_tbd_num = 1;
    tcbp->tcb_thrshld = bdp->tx_thld;
    tcbp->tcb_tbd_ptr = cpu_to_le32(bdp->tbd_paddr +
        (TCB_TO_USE(tcb_poolp) * sizeof(tbd_t)));
    tcbp->tcb_hdr.cb_cmd = cpu_to_le16(txcommand);


    /* set the I bit on the modulo tcbs, so we will get an interrupt * to
     * clean things up */
    if (!(++bdp->tx_count % e100_batch_tx_frames)) {
        tcbp->tcb_hdr.cb_cmd |= __constant_cpu_to_le16(CB_I_BIT);
    }

    /* save a pointer to the skb to free it later */
    tcbp->tcb_skb = skb;

    tcbp->dma_data_addr = pci_map_single(bdp->ppci_dev,skb->data,skb->len,PCI_DMA_TODEVICE);
    if (bdp->flags & USE_IPCB) {
        /* setup the ipcb fields */
      (tcbp->tcbu).ipcb.tbd_sec_addr.tbd_zero_address =cpu_to_le32(tcbp->dma_data_addr);

        (tcbp->tcbu).ipcb.tbd_sec_size.tbd_zero_size = cpu_to_le16(skb->len);
    } else {
        /* copy the phys addrs and len to the tbds */
      tbdp->tbd_buf_addr = cpu_to_le32(tcbp->dma_data_addr);

        tbdp->tbd_buf_cnt = cpu_to_le32(skb->len);
    }

   
    /* Clear the S-Bit of the Previous Command */
    prev_tcbp = tcb_poolp->data;
    prev_tcbp += PREV_TCB_USED(tcb_poolp);
    prev_tcbp->tcb_hdr.cb_cmd &= __constant_cpu_to_le16((u16)~CB_S_BIT);

    /* update the tail */
    tcb_poolp->tail = NEXT_TCB_TOUSE(tcb_poolp->tail);

    /* start the CU if needed */
    e100_cu_start(bdp, tcbp);

    return (tcbp);
}


/* 
 * Procedure:   e100_prepare_ext_xmit_buff
 *
 * Description: This is a 82558/9 specific routine.
 *  This sets up the extended TCBs and dynamically chains TBDs.
 *      This routine prepare a buffer for transmission. It checks
 *      the message length for the appropiate size. It picks
 *      up a free tcb from the TCB pool & sets up the corresponding
 *      TBD's. If number of fragments are more the the # of TBD/TCB
 *      it copies all the fragments in a coalesce buffer. 
 *
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *      skb    - skb to send.
 *
 * Returns:
 *  ptcb   - Ptr to the prepared TCB
 */
static          ptcb_t
e100_prepare_ext_xmit_buff(bd_config_t * bdp, struct sk_buff * skb)
{
    buf_pool_t     *tcb_poolp;
    tcb_t          *tcbp;
    tcb_t          *prev_tcbp;

    tcb_poolp = &bdp->tcb_pool;
    tcbp = tcb_poolp->data;

    /* get the TCB & the TBD we may be using for this MSG */
    /* since Linux only use 1 physical address the number of tdbs use is 1 * 
     * which will fit into the extended tcb */
    tcbp += TCB_TO_USE(tcb_poolp);

#ifdef IANS
    if (ANS_PRIVATE_DATA_FIELD(bdp)->iANS_status == IANS_COMMUNICATION_UP) 
        bd_ans_os_Transmit(bdp, tcbp, &skb);
#endif

    tcbp->tcb_hdr.cb_status = 0;
    tcbp->tcb_thrshld = bdp->tx_thld;
    tcbp->tcb_hdr.cb_cmd = __constant_cpu_to_le16(CB_S_BIT | CB_TRANSMIT |
                                                  CB_TX_SF_BIT | CB_CID_DEFAULT);

    /* set the I bit on the modulo tcbs, so we will get an interrupt * to
     * clean things up */
    if (!(++bdp->tx_count % e100_batch_tx_frames)) {
        tcbp->tcb_hdr.cb_cmd |= __constant_cpu_to_le16(CB_I_BIT);
    }

    /* save a pointer to the skb to free it later */
    tcbp->tcb_skb = skb;

    /* set the data size of the SKB */
   
    tcbp->dma_data_addr = pci_map_single(bdp->ppci_dev,skb->data,skb->len,PCI_DMA_TODEVICE);
    /* set the ext tbd to the skb */
    (tcbp->tcbu).tcb_ext.tbd0_buf_addr = cpu_to_le32(tcbp->dma_data_addr);
    (tcbp->tcbu).tcb_ext.tbd0_buf_cnt  = cpu_to_le32( skb->len);

    /* clear the S-BIT on the previous tcb */
    prev_tcbp = tcb_poolp->data;
    prev_tcbp += PREV_TCB_USED(tcb_poolp);
    prev_tcbp->tcb_hdr.cb_cmd &= __constant_cpu_to_le16((u16)~CB_S_BIT);

    /* start the CU if needed */
    e100_cu_start(bdp, tcbp);

    /* update the tail */
    tcb_poolp->tail = NEXT_TCB_TOUSE(tcb_poolp->tail);

    return (tcbp);
}


/* Changed for 82558 enhancement */
/* 
 * Procedure:   e100_cu_start
 *
 * Description: This routine issues a CU Start or CU Resume command
 * to the 82558/9. This routine was added because the prepare_ext_xmit_buff
 * takes advantage of the 82558/9's Dynamic TBD chaining feature and has to
 * start the CU as soon as the first TBD is ready. 
 *
 * cu_start must be called while holding the tx_lock ! 
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *      tcbp   - Ptr to the TCB to be transmitted        
 *      
 */
void
e100_cu_start(bd_config_t * bdp, tcb_t * tcbp)
{
    unsigned long	lock_flag;
    int timeout;
  
    spin_lock_irqsave(&(bdp->bd_lock), lock_flag);
    switch(bdp->next_cu_cmd){
     case RESUME_NO_WAIT:
	    /*last cu command was a CU_RESMUE if this is a 558 or newer we dont need to
	     * wait for command word to clear, we reach here only if we are bachlor
	     */
             //	ASSERT(bdp->flags & IS_BACHELOR);
	e100_exec_cmd(bdp,SCB_CUC_RESUME);
	break;        
    case RESUME_WAIT:
        if ((bdp->flags & IS_ICH) &&
            (bdp->cur_line_speed == 10) &&
            (bdp->cur_dplx_mode == HALF_DUPLEX)) {
            e100_wait_exec_cmd(bdp, SCB_CUC_NOOP);
            udelay(1);
        }
        if((e100_wait_exec_cmd(bdp, SCB_CUC_RESUME) == B_TRUE) &&
           (bdp->flags & IS_BACHELOR) && 
		   (!(bdp->flags & IS_ICH))){
			bdp->next_cu_cmd = RESUME_NO_WAIT;
		}
	break;
    case START_WAIT:
        // The last command was a non_tx CU command
        if(e100_wait_scb(bdp) != B_TRUE){
            printk("%s cu_start: timeout waiting for scb\n",
                   bdp->device->name);
            
        }
        timeout = 1000*5; // 5 msec
        E100_WAIT_FOR_CONDITION(timeout,
                                ((readw(&(bdp->scbp->scb_status)) & SCB_CUS_MASK)
                                 != SCB_CUS_ACTIVE));
        if(timeout <= 0){
            printk("%s cu_start:timeout waiting for cu\n",
                   bdp->device->name);
        }
        writel((u32)(tcbp->tcb_paddr),&bdp->scbp->scb_gen_ptr);
        e100_exec_cmd(bdp, SCB_CUC_START);
        bdp->next_cu_cmd = RESUME_WAIT; 
        
        break;
    }
    
    /* save the last tcbp */
    bdp->last_tcbp = tcbp;

    spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag);
    return;
}


/* ====================================================================== */
/* hw                                                                     */
/* ====================================================================== */

/* 
 * Procedure:   SelfTestHardware
 *
 * Description: This routine will issue PORT Self-test command to test the
 *          e100.  The self-test will fail if the adapter's master-enable
 *         bit is not set in the PCI Command Register, or if the adapter
 *         is not seated in a PCI master-enabled slot. we also disable interrupts
 *         when the command is completed.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *    -     B_TRUE if adapter passes self_test
 *        B_FALSE if adapter fails self_test
 */
unsigned char
e100_selftest(bd_config_t *bdp, u32 *st_timeout, u32 *st_result)
{
    u32         SelfTestCommandCode;

    /* initialize the nic state before running test */
    e100_sw_reset(bdp, PORT_SOFTWARE_RESET);
    /* Setup the address of the self_test area */
    SelfTestCommandCode =  bdp->selftest_paddr;

    /* Setup SELF TEST Command Code in D3 - D0 */
    SelfTestCommandCode |= PORT_SELFTEST;

    /* Initialize the self-test signature and results DWORDS */
    bdp->pselftest->st_sign = 0;
    bdp->pselftest->st_result = 0xffffffff;

    /* Do the port command */
    writel(SelfTestCommandCode,&bdp->scbp->scb_port);

    /* Wait 10 milliseconds for the self-test to complete */
    mdelay(10);

    /* disable interrupts since the're now enabled */
    e100_dis_intr(bdp);
    /* if The First Self Test DWORD Still Zero, We've timed out. If the
     * second DWORD is not zero then we have an error. */
    if ((bdp->pselftest->st_sign == 0) ||
        (bdp->pselftest->st_result != 0)) {
        
        if (st_timeout)
            *st_timeout = !(le32_to_cpu(bdp->pselftest->st_sign));
        
        if (st_result)
            *st_result = le32_to_cpu(bdp->pselftest->st_result);
        
        return B_FALSE;
    }

    return B_TRUE;
}

/* 
 * Procedure:   e100_setup_iaaddr
 *
 * Description: This routine will issue the IA setup command.  This command
 *              will notify the 82557 (e100) of what its individual (node)
 *              address is.  This command will be executed in polled mode.
 *
 * Arguments:
 *      bdp      - Ptr to this card's e100_bdconfig structure
 *      peaddr   - Ptr to the new ethernet address
 *
 * Returns:
 *      B_TRUE - If the IA setup command was successfully issued and completed
 *      B_FALSE - If the IA setup command failed to complete properly
 */

unsigned char
e100_setup_iaaddr(bd_config_t * bdp, u8 * peaddr)
{
    unsigned int    i;
    pcb_header_t    pntcb_hdr;
    unsigned char res ;

    /* We lock before we start using the non tcb cmd */
    spin_lock_bh(&bdp->bd_tx_lock);
    
    pntcb_hdr = (pcb_header_t) bdp->pntcb;   /* get hdr of non tcb cmd */
    
    /* Setup the non-transmit command block header for the configure command. */
    pntcb_hdr->cb_cmd = __constant_cpu_to_le16(CB_IA_ADDRESS);
    
    /* Copy in the station's individual address */
    for (i = 0; i < ETH_ALEN; i++) {
        bdp->pntcb->ntcb.setup.ia_addr[i] = peaddr[i];
    }

    if( (res = e100_exec_non_cu_cmd(bdp)) != B_TRUE){ 
            printk(KERN_WARNING "%s IA setup failed\n",bdp->device->name);
    }
    
    spin_unlock_bh(&bdp->bd_tx_lock);
    e100_tx_notify_start(bdp, SHORT_STOP);
    
    return (res);
}


/* 
 * Procedure:   e100_start_ru
 *
 * Description: This routine checks the status of the 82557's receive unit(RU),
 *              and starts the RU if it was not already active.  However,
 *              before restarting the RU, the driver gives the RU the buffers 
 *        it freed up during the servicing of the ISR. If there are
 *        no free buffers to give to the RU, ( i.e. we have reached a
 *        no resource condition ) the RU will not be started till the
 *        next ISR.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NONE
 */


void
e100_start_ru(bd_config_t * bdp)
{
    struct sk_buff       *skb; 

   /* If the receiver is ready, then don't try to restart. */
    if ((readw(&bdp->scbp->scb_status) & SCB_RUS_MASK) == SCB_RUS_READY) {
        return;
    }
    for(skb = bdp->rfd_head; skb != NULL; skb = skb->next){
        pci_dma_sync_single(bdp->ppci_dev,GET_SKB_DMA_ADDR(skb),
			    bdp->rfd_size,PCI_DMA_FROMDEVICE);
	if (!((SKB_RFD_STATUS(skb,bdp) & 
	       __constant_cpu_to_le16(RFD_STATUS_COMPLETE)))){
	    break;
	}
    }
    /* No available buffers */
    if(skb == NULL){
	return;
    }
    spin_lock(&bdp->bd_lock);
    
    if(e100_wait_scb(bdp) == B_FALSE){
            printk("%s start_ru: wait_scb failed\n",
                   bdp->device->name);

    }
    writel(GET_SKB_DMA_ADDR(skb),&bdp->scbp->scb_gen_ptr);
    e100_exec_cmd(bdp, SCB_RUC_START);
    if(bdp->next_cu_cmd == RESUME_NO_WAIT){
            bdp->next_cu_cmd = RESUME_WAIT;
    }
    spin_unlock(&bdp->bd_lock);
}


/* 
 * Procedure:   e100_cmd_complete_location
 *
 * Description: This routine returns a pointer to the location of the 
 *              command-complete DWord in the dump statistical counters area, 
 *              according to the statistical counters mode (557 - basic, 
 *              558 - extended, or 559 - TCO mode)
 *		see e100_configure() for the setting of the statistical 
 *              counters mode.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      pointer to the command complete dword.
 *
 */
static u32 *
e100_cmd_complete_location (bd_config_t * bdp)
{
    u32	   *pcmd_complete;
	
    switch (bdp->stat_mode) {
    case E100_EXTENDED_STATS:
      pcmd_complete = (__u32 *)&(((perr_cntr_558_t)
				  (bdp->pstats_counters))->cmd_complete);
	    break;
    case E100_TCO_STATS:
      pcmd_complete = (__u32 *)&(((perr_cntr_559_t)
				  (bdp->pstats_counters))->cmd_complete);
	    break;
    case E100_BASIC_STATS:
    default:      /* should never happen ! just return something safe */
      pcmd_complete = (__u32 *)
	    &(((perr_cntr_557_t)(bdp->pstats_counters))->cmd_complete);
	    break;
    }
    return pcmd_complete;
}

/* 
 * Procedure:   e100_clr_cntrs
 *
 * Description: This routine will clear the adapter error statistic 
 *              counters.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      B_TRUE  - If successfully cleared stat counters
 *      B_FALSE - If command failed to complete properly
 *
 */
static          unsigned char
e100_clr_cntrs(bd_config_t * bdp)
{
    int  timeout;
    volatile u32 *pcmd_complete;
    
    /* clear the dump counter complete word */
    pcmd_complete = e100_cmd_complete_location (bdp);
    *pcmd_complete = 0;
    
    if (e100_wait_scb(bdp) != B_TRUE)
        return (B_FALSE);

    writel(bdp->stat_cnt_paddr,&bdp->scbp->scb_gen_ptr);
    
    /* Issue the load dump counters address command */
    e100_exec_cmd(bdp, SCB_CUC_DUMP_ADDR);
    
    /* wait for the cmd to be fetched */
    if (e100_wait_scb(bdp) != B_TRUE)
        return (B_FALSE);

    /* wait 10 microseconds for the command to complete */
    udelay(10);
    
    /* Now dump and reset all of the statistics */
    e100_exec_cmd(bdp, SCB_CUC_DUMP_RST_STAT);
    
    /* Now wait for the dump/reset to complete */
    if (bdp->next_cu_cmd == RESUME_NO_WAIT) {
        bdp->next_cu_cmd = RESUME_WAIT;
    }
    
    timeout = 1000*500;
    E100_WAIT_FOR_CONDITION(timeout,
                            (*pcmd_complete == 
                             cpu_to_le32(DUMP_RST_STAT_COMPLETED)));

    if (timeout <= 0) {
	return (B_FALSE);
    }
    
    return (B_TRUE);
}

static unsigned char
e100_update_stats(bd_config_t *bdp)
{
    u32	         *pcmd_complete;
    basic_cntr_t *pstat = &(bdp->pstats_counters->basic_stats);

    // check if last dump command completed
    pcmd_complete = e100_cmd_complete_location (bdp);
    if(*pcmd_complete != le32_to_cpu(DUMP_RST_STAT_COMPLETED) &&
       *pcmd_complete != le32_to_cpu(DUMP_STAT_COMPLETED)){
            return B_FALSE;
    }

    /* increment the statistics */
    bdp->drv_stats.net_stats.rx_packets        += le32_to_cpu(pstat->rcv_gd_frames);
    bdp->drv_stats.net_stats.tx_packets        += le32_to_cpu(pstat->xmt_gd_frames);
    bdp->drv_stats.net_stats.rx_dropped        += le32_to_cpu(pstat->rcv_rsrc_err);
    bdp->drv_stats.net_stats.collisions        += le32_to_cpu(pstat->xmt_ttl_coll);
    bdp->drv_stats.net_stats.rx_length_errors  += le32_to_cpu(pstat->rcv_shrt_frames);
    bdp->drv_stats.net_stats.rx_over_errors    += le32_to_cpu(pstat->rcv_rsrc_err);
    bdp->drv_stats.net_stats.rx_crc_errors     += le32_to_cpu(pstat->rcv_crc_errs);
    bdp->drv_stats.net_stats.rx_frame_errors   += le32_to_cpu(pstat->rcv_algn_errs);
    bdp->drv_stats.net_stats.rx_fifo_errors    += le32_to_cpu(pstat->rcv_oruns);
    bdp->drv_stats.net_stats.tx_aborted_errors += le32_to_cpu(pstat->xmt_max_coll);
    bdp->drv_stats.net_stats.tx_carrier_errors += le32_to_cpu(pstat->xmt_lost_crs);
    bdp->drv_stats.net_stats.tx_fifo_errors    += le32_to_cpu(pstat->xmt_uruns);
    
    bdp->drv_stats.tx_late_col                 += le32_to_cpu(pstat->xmt_late_coll);
    bdp->drv_stats.tx_ok_defrd                 += le32_to_cpu(pstat->xmt_deferred);
    bdp->drv_stats.tx_one_retry                += le32_to_cpu(pstat->xmt_sngl_coll);
    bdp->drv_stats.tx_mt_one_retry             += le32_to_cpu(pstat->xmt_mlt_coll);
    bdp->drv_stats.rcv_cdt_frames              += le32_to_cpu(pstat->rcv_err_coll);

    if (bdp->stat_mode != E100_BASIC_STATS) {
        ext_cntr_t *pex_stat = &bdp->pstats_counters->extended_stats;

        bdp->drv_stats.xmt_fc_pkts        += le32_to_cpu(pex_stat->xmt_fc_frames);
        bdp->drv_stats.rcv_fc_pkts        += le32_to_cpu(pex_stat->rcv_fc_frames);
        bdp->drv_stats.rcv_fc_unsupported += le32_to_cpu(pex_stat->rcv_fc_unsupported);
    }

    if (bdp->stat_mode == E100_TCO_STATS) {  
        tco_cntr_t *ptco_stat = &bdp->pstats_counters->tco_stats;

        bdp->drv_stats.xmt_tco_pkts += le16_to_cpu(ptco_stat->xmt_tco_frames);
        bdp->drv_stats.rcv_tco_pkts += le16_to_cpu(ptco_stat->rcv_tco_frames);
    }

    *pcmd_complete = 0;
    return B_TRUE;
}

/*
 * Procedure:   e100_dump_stat_cntrs
 *
 * Description: This routine will dump the board statistical counters without waiting
 * for stat_dump to complete. Any access to this stats should verify the completion
 * of the command
 *
 * Arguments:
 *      bdp -          Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NONE
 */
void
e100_dump_stats_cntrs(bd_config_t * bdp)
{
    unsigned long lock_flag_bd;
    
    spin_lock_irqsave(&(bdp->bd_lock), lock_flag_bd);

    /* dump h/w stats counters */
    if(e100_wait_exec_cmd(bdp, SCB_CUC_DUMP_RST_STAT) == B_TRUE){
        if(bdp->next_cu_cmd == RESUME_NO_WAIT){
            bdp->next_cu_cmd = RESUME_WAIT;
        }
    }
    
    spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag_bd);
    
    return;
}

/* 
 * Procedure:   e100_exec_non_cu_cmd
 *
 * Description: This routine will submit a command block to be executed,
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 */

unsigned char  e100_exec_non_cu_cmd(bd_config_t * bdp)
{

    pcb_header_t    pntcb_hdr;
    int             timeout, delay;
    unsigned long   lock_flag;
    pntcb_hdr = (pcb_header_t) bdp->pntcb;   /* get hdr of non tcb cmd */

    /* Set the Command Block to be the last command block */
    pntcb_hdr->cb_cmd |= __constant_cpu_to_le16(CB_EL_BIT);

    pntcb_hdr->cb_status = 0;

    pntcb_hdr->cb_lnk_ptr = 0;

    timeout = 1000*500;
    
    /* wait for the last tcb to complete transmition */
    if (bdp->last_tcbp) {
        E100_WAIT_FOR_CONDITION(timeout,
                                (bdp->last_tcbp->tcb_hdr.cb_status & 
                                 __constant_cpu_to_le16(CB_STATUS_COMPLETE)));
    }
    E100_WAIT_FOR_CONDITION(timeout,
                            ((readw(&bdp->scbp->scb_status) & SCB_CUS_MASK)
                             != SCB_CUS_ACTIVE));
    if(timeout <= 0){
        return (B_FALSE);  
    }
    
    spin_lock_irqsave(&bdp->bd_lock, lock_flag);
    
    /* Wait for the SCB command word to clear before we set the general pointer */
    if (e100_wait_scb(bdp) != B_TRUE) {
        spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag);
        return (B_FALSE);
    }


    writel(bdp->nontx_paddr,&bdp->scbp->scb_gen_ptr);

    e100_exec_cmd(bdp, SCB_CUC_START);

    bdp->next_cu_cmd = START_WAIT;

    spin_unlock_irqrestore(&(bdp->bd_lock), lock_flag);
    
    /* now wait for completion of non-cu CB */
    for (delay = 0; delay < 20; delay++) {
        mdelay(1);

        if ((pntcb_hdr->cb_status &
	     __constant_cpu_to_le16(CB_STATUS_COMPLETE))) {
            return  B_TRUE;

        }
    }
    /* didn't get a C bit assume command failed */
    return B_FALSE;
}


/* 
 * Procedure:    e100_wait_scb
 *
 * Description: This routine checks to see if the e100 has accepted a command.
 *              It does so by checking the command field in the SCB, which will
 *              be zeroed by the e100 upon accepting a command.  The loop waits
 *              for up to 5 milliseconds for command acceptance.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      B_TRUE if the SCB cleared within 5 milliseconds.
 *      B_FALSE if it didn't clear within 5 milliseconds
 */
unsigned char
e100_wait_scb(bd_config_t * bdp)
{
    int          wait_count = 5000;

    do {
        if (!readb(&bdp->scbp->scb_cmd_low))
            return B_TRUE;

        udelay(1);

    } while (wait_count--);

    return B_FALSE;
}


/* 
 * Procedure:   e100_sw_reset
 *
 * Description: This routine will issue a software reset to the adapter. It 
 *              will also disable interrupts, as the are enabled after reset.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *        reset_cmd - s/w reset or selective reset. 
 *
 * Returns:
 */
void
e100_sw_reset(bd_config_t * bdp, u32 reset_cmd)
{

        /* Do  a selective reset first to avoid a potential  PCI hang */
        writel(PORT_SELECTIVE_RESET,&bdp->scbp->scb_port);

        /* wait for the reset to take effect */
        udelay(20);
        if(reset_cmd == PORT_SOFTWARE_RESET){
                writel(PORT_SOFTWARE_RESET,&bdp->scbp->scb_port);

                /* wait 20 micro seconds for the reset to take effect */
                udelay(20);
        }
        
    /* Mask off our interrupt line -- its unmasked after reset */
        e100_dis_intr(bdp);
        
        return;
}



/* 
 * Procedure:   e100_load_microcode
 *
 * Description: This routine downloads microcode on to the controller. This
 *      microcode is available for the 82558/9,550. Currently the ucode handles
 *      interrupt bundling & TCO workaround.
 *
 * Arguments:
 *      bdp      - Pointer to this device's board config.
 *      rev_id  - Revision ID of the board.
 *
 * Returns: B_TRUE - Success
 *              B_FALSE - Failure
 *
 */
static unsigned char
e100_load_microcode(bd_config_t * bdp, u8 rev_id)
{
  static u32  d101a_ucode[]    = D101_A_RCVBUNDLE_UCODE;
  static u32  d101b0_ucode[]   = D101_B0_RCVBUNDLE_UCODE;
  static u32  d101ma_ucode[]   = D101M_B_RCVBUNDLE_UCODE;
  static u32  d101s_ucode[]    = D101S_RCVBUNDLE_UCODE;
  static u32  d102_ucode[]     = D102_B_RCVBUNDLE_UCODE;
  static u32  d102c_ucode[]    = D102_C_RCVBUNDLE_UCODE;
  static u32  d102e_ucode[]    = D102_E_RCVBUNDLE_UCODE;

  unsigned int i;
  pcb_header_t pntcb_hdr;
  u32 * ucode_p; //convenient variable to hold the uCode.
  int ucode_size;
  struct bundle_offsets offsets = DEFAULT_BUNDLE_OFFSETS;


  /* user turned ucode loading off */
  if (!ucode[bdp->bd_number])
    return B_FALSE;
  /* this chips do not need ucode */
  if ((bdp->flags & IS_ICH) ||  (bdp->rev_id < D101A4_REV_ID)) {
    return B_FALSE;
  }

  /* Decide which ucode to use by looking at the board's rev_id */
  switch(rev_id){
			
  case(D101A4_REV_ID):
    {
    ucode_p = d101a_ucode;
    ucode_size = sizeof(d101a_ucode);
    SET_OFFSETS(offsets,D101);
    }
    break;
  
  case(D101B0_REV_ID):
    ucode_p = d101b0_ucode;
    ucode_size = sizeof(d101b0_ucode);
    SET_OFFSETS(offsets,D101);
    break;

  case(D101MA_REV_ID):
    ucode_p =  d101ma_ucode;
    ucode_size = sizeof(d101ma_ucode);
    SET_OFFSETS(offsets,D101M);
    break;

  case(D101S_REV_ID):
    ucode_p = d101s_ucode;
    ucode_size = sizeof(d101s_ucode);
    SET_OFFSETS(offsets,D101S);
    break;

  case(D102_REV_ID):
      ucode_p = d102_ucode;
      ucode_size = sizeof(d102_ucode);
      SET_OFFSETS(offsets,D102_B);
    break;
  
  case(D102C_REV_ID):
    ucode_p = d102c_ucode;
    ucode_size = sizeof(d102c_ucode);
    SET_OFFSETS(offsets,D102_C);
    break;

  case(D102E_REV_ID):
    ucode_p = d102e_ucode;
    ucode_size = sizeof(d102e_ucode);
    SET_OFFSETS(offsets,D102_E);
    break;

  default:
    return B_FALSE;      /* we don't have ucode for this board */
    
  } //end switch(rev_id)

  /* Replace interrupt bundling parameters with users'values */
      e100_set_ucode_val(ucode_p,offsets.timer,IntDelay[bdp->bd_number]); 
      
      e100_set_ucode_val(ucode_p,offsets.bundle,BundleMax[bdp->bd_number]);

      /* We wan't to reuse the static sturct so always change value */
  if (BundleSmallFr[bdp->bd_number] == B_TRUE) {
    e100_set_ucode_val(ucode_p,offsets.min_size,0xFFFF);
  } else {
    e100_set_ucode_val(ucode_p,offsets.min_size,0xFF80);
  }
  /* Setup the non-transmit command block header for the command. */
  pntcb_hdr = (pcb_header_t) bdp->pntcb;   /* get hdr of non tcb cmd */
  pntcb_hdr->cb_cmd = __constant_cpu_to_le16(CB_LOAD_MICROCODE);

  /* Copy in the microcode */
  memset((char *)bdp->pntcb->ntcb.load_ucode.ucode_dword,0,
	 sizeof(bdp->pntcb->ntcb.load_ucode.ucode_dword));
  for (i = 0; i < ucode_size / sizeof(u32); i++)
    bdp->pntcb->ntcb.load_ucode.ucode_dword[i] = cpu_to_le32(ucode_p[i]);

  /* Currently no looking issues call only on init & diagnostics */
  return e100_exec_non_cu_cmd(bdp); 
}

/***************************************************************************/
/***************************************************************************/
/*       EEPROM  Functions                                                 */
/***************************************************************************/

/* 
 * Procedure:   e100_rd_pwa_no
 *
 * Description: read pwa (printed wired assembly) number
 */
void 
e100_rd_pwa_no(bd_config_t * bdp)
{
    bdp->pwa_no = ReadEEprom(bdp, EEPROM_PWA_NO);
    bdp->pwa_no <<= 16;
    bdp->pwa_no |= ReadEEprom(bdp, EEPROM_PWA_NO+1);
}


/* 
 * Procedure:   e100_rd_eaddr 
 *
 * Description: Reads the permanent ethernet address from the eprom.
 * 
 * Arguments: 
 *      bdp - Ptr to this card's e100_bdconfig structure
 * 
 * Returns: (none) 
 */
void
e100_rd_eaddr(bd_config_t * bdp)
{
    int        i;
    u16        EepromWordValue;

    for (i = 0; i < 6; i += 2) {
        EepromWordValue =
            ReadEEprom(bdp, EEPROM_NODE_ADDRESS_BYTE_0 + (i / 2));

        bdp->device->dev_addr[i] =
            bdp->perm_node_address[i] = (u8) EepromWordValue;
        bdp->device->dev_addr[i + 1] =
            bdp->perm_node_address[i + 1] = (u8) (EepromWordValue >> 8);
    }
    
    return;
}
 

/***************************************************************************/
/***************************************************************************/
/*       PHY Functions                                                     */
/***************************************************************************/

/* 
 * Procedure:   PhyDetect
 *
 * Description: This routine will detect what phy we are using, set the line
 *              speed, FDX or HDX, and configure the phy if necessary.
 *
 *              The following combinations are supported:
 *              - TX or T4 PHY alone at PHY address 1
 *              - T4 or TX PHY at address 1 and MII PHY at address 0
 *              - 82503 alone (10Base-T mode, no full duplex support)
 *              - 82503 and MII PHY (TX or T4) at address 0
 *
 *              The sequence / priority of detection is as follows:
 *              - PHY 1 with cable termination
 *              - PHY 0 with cable termination
 *              - PHY 1 (if found) without cable termination
 *              - 503 interface
 *
 *              Additionally auto-negotiation capable (NWAY) and parallel
 *              detection PHYs are supported. The flow-chart is described*/
unsigned char
e100_phydetect(bd_config_t * bdp)
{
    unsigned int          CurrPhy;
    unsigned int          Phy1;
    u16        MdiControlReg, MdiStatusReg;
    u8         ReNegotiateTime = 35;
    int             old_speed_duplex;
    int             board_speed_duplex;

    board_speed_duplex = e100_speed_duplex[bdp->bd_number];

    Phy1 = 0;

    /* Check for a phy from address 1 - 31 */
    for (CurrPhy = 1; CurrPhy <= MAX_PHY_ADDR; CurrPhy++) {
        /* Read the MDI control register at CurrPhy. */
        e100_MdiRead(bdp, MDI_CONTROL_REG, CurrPhy, &MdiControlReg);

        /* Read the status register at phy 1 */
        e100_MdiRead(bdp, MDI_STATUS_REG, CurrPhy, &MdiStatusReg);

        /* check if we found a valid phy */
        if (!((MdiControlReg == 0xffff) ||
            ((MdiStatusReg == 0) && (MdiControlReg == 0)))) {
            /* we have a valid phy1 */
            Phy1 = CurrPhy;

            /* Read the status register again because of sticky bits */
            e100_MdiRead(bdp, MDI_STATUS_REG, CurrPhy, &MdiStatusReg);

            /* If there is a valid link then use this Phy. */
            if (MdiStatusReg & MDI_SR_LINK_STATUS) {

                bdp->phy_addr = Phy1;

                return (e100_SetupPhy(bdp));
            }
            /* found a valid phy without a link, so break */
            break;
        }
    }

    /* 
     * Next try to detect a PHY at address 0x00 because there was no Phy 1, 
     * or Phy 1 didn't have link
     */

    /* Read the MDI control register at phy 0 */
    e100_MdiRead(bdp, MDI_CONTROL_REG, 0, &MdiControlReg);

    /* Read the status register at phy 0 */
    e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);

    /* check if we found a valid phy 0 */
    if ((MdiControlReg == 0xffff) ||
        ((MdiStatusReg == 0) && (MdiControlReg == 0))) {
        /* we don't have a valid phy at address 0 */

        if (Phy1) {
            /* no phy 0, so use phy 1 */
            bdp->phy_addr = Phy1;

            /* no phy 0, but there is a phy 1, so use phy 1 */
            return (e100_SetupPhy(bdp));
        } else {
            /* didn't find phy 0 or phy 1, so assume a 503 interface */
            bdp->phy_addr = 32;

            /* 
             *    This fix is for the board which has the 503 interface
             *    and need to have the speed and duplex mode set here.  The only
             *    way for a user to get a FULL duplex setting is to have it forced
             *    in the e100.c file.
             *
             *    The second test is for an invalid setting for the hardware.
             */
            /* The adapter can't autoneg. so set to 10/HALF */
            if (board_speed_duplex == 0) {
                old_speed_duplex = board_speed_duplex;
                board_speed_duplex = e100_speed_duplex[bdp->bd_number] = 1;
                e100_ForceSpeedAndDuplex(bdp);
                /* Restore speed_duplex value. */
                board_speed_duplex = e100_speed_duplex[bdp->bd_number] =
                    old_speed_duplex;
            }
            else if ((board_speed_duplex == 1)
                || (board_speed_duplex == 2)) {
                e100_ForceSpeedAndDuplex(bdp);
            } else if (board_speed_duplex > 2) {
                printk(KERN_ERR "503 serial component detected which does not "
		       "support 100Mbps.\n");
                printk(KERN_ERR "Change the forced speed/duplex "
		       "to a supported setting.\n");
                return (B_FALSE);
            }

            return (B_TRUE);
        }
    } else {
        /* We have a valid phy at address 0.  If phy 0 has a link then * we
         * use phy 0.  If Phy 0 doesn't have a link then we use Phy 1 * (
         * which also doesn't have a link ) if phy 1 is present, else use *
         * phy 0 if phy 1 is not present */
        /* If phy 1 was present, then we must isolate phy 1 before we *
         * enable phy 0 to see if Phy 0 has a link. */
        if (Phy1) {
            /* isolate phy 1 */
            e100_MdiWrite(bdp, MDI_CONTROL_REG, Phy1, MDI_CR_ISOLATE);

            /* wait 100 milliseconds for the phy to isolate. */
            udelay(200);
        }

#ifdef PHY_NC3133
        if ((bdp->sub_ven_id == 0x0E11) &&
            (bdp->sub_dev_id == 0xB0E1)) {
            u16        MdiIntReg;

            bdp->phy_addr = 0;

            /* Compaq NC3133 100BASE FX adapter module; will always be at */
            /* Phy address 0; unisolate Phy 0                             */
            e100_MdiRead(bdp, MDI_CONTROL_REG, bdp->phy_addr, &MdiControlReg);
            MdiControlReg &= ~MDI_CR_ISOLATE;
            e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr, MdiControlReg);
            mdelay(100);

            /* enable 100BASE fiber interface */
            e100_MdiWrite(bdp, MDI_NC3133_CONFIG_REG, bdp->phy_addr,
                          MDI_NC3133_100FX_ENABLE);

            if ((e100_speed_duplex[bdp->bd_number] != 0) &&
                (e100_speed_duplex[bdp->bd_number] != 4)) {
                /* just inform user about 100 full */
                printk(KERN_ERR
                       "NC3133 NIC can only run at 100Mbps full duplex.\n");
            }

            e100_speed_duplex[bdp->bd_number] = 4; /* 100 full */
            e100_ForceSpeedAndDuplex(bdp);

            /* enable interrupts */
            e100_MdiRead(bdp, MDI_NC3133_INT_ENABLE_REG,
                         bdp->phy_addr, &MdiIntReg);
            MdiIntReg |= MDI_NC3133_INT_ENABLE;
            e100_MdiWrite(bdp, MDI_NC3133_INT_ENABLE_REG,
                          bdp->phy_addr, MdiIntReg);

            return (e100_SetupPhy(bdp)); 
        }
#endif /* PHY_NC3133 */

        /* Since this Phy is at address 0, we must enable it.  So clear */
        /* the isolate bit, and set the auto-speed select bit */
        e100_MdiWrite(bdp, MDI_CONTROL_REG, 0, MDI_CR_AUTO_SELECT);

        /* wait 100 milliseconds for the phy to be enabled. */
        udelay(200);

        /* restart the auto-negotion process */
        e100_MdiWrite(bdp, MDI_CONTROL_REG, 0,
            MDI_CR_RESTART_AUTO_NEG | MDI_CR_AUTO_SELECT);

        /* wait no more than 3.5 seconds for auto-negotiation to complete */
        while (ReNegotiateTime) {
            /* Read the status register twice because of sticky bits */
            e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);
            e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);

            if (MdiStatusReg & MDI_SR_AUTO_NEG_COMPLETE)
                break;

            mdelay(10);
            ReNegotiateTime--;
        }

        /* Read the status register again because of sticky bits */
        e100_MdiRead(bdp, MDI_STATUS_REG, 0, &MdiStatusReg);

        /* If the link was not set */
        if (!(MdiStatusReg & MDI_SR_LINK_STATUS)) {
            /* the link wasn't set, so use phy 1 if phy 1 was present */
            if (Phy1) {
                /* isolate phy 0 */
                e100_MdiWrite(bdp, MDI_CONTROL_REG, 0, MDI_CR_ISOLATE);

                /* wait for the phy to isolate. */
                udelay(100);

                /* Now re-enable PHY 1 */
                e100_MdiWrite(bdp, MDI_CONTROL_REG, Phy1,
                    MDI_CR_AUTO_SELECT);

                /* wait 100 milliseconds for the phy to be enabled. */
                udelay(100);
                
                /* restart the auto-negotion process */
                e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr,
                    MDI_CR_RESTART_AUTO_NEG |
                    MDI_CR_AUTO_SELECT);

                bdp->phy_addr = Phy1;

                /* Don't wait for it 2 complete (no link from earlier) */
                return (e100_SetupPhy(bdp));
            }

        }

        /* Definitely using Phy 0 */
        bdp->phy_addr = 0;

        return (e100_SetupPhy(bdp));
    }
}


/* 
 * Procedure:   e100_SetupPhy
 *
 * Description: This routine will setup phy 1 or phy 0 so that it is configured
 *              to match line speed.  This driver assumes assume the adapter 
 *        is automatically setting the line speed, and the duplex mode. 
 *        At the end of this routine, any truly Phy specific code will 
 *        be executed (each Phy has its own quirks, and some require 
 *        that certain special bits are set).
 *
 *   NOTE:  The driver assumes that SPEED and FORCEFDX are specified at the
 *          same time. If FORCEDPX is set without speed being set, the driver
 *          will encouter a fatal error.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Result:
 * Returns:
 *      B_TRUE  - If the phy could be configured correctly
 *      B_FALSE - If the phy couldn't be configured correctly, because an 
 *           */
static          unsigned char
e100_SetupPhy(bd_config_t * bdp)
{
    u16        MdiIdLowReg, MdiIdHighReg;
    u16        MdiMiscReg;
    unsigned int    PhyId;
    int             board_speed_duplex;

    board_speed_duplex = e100_speed_duplex[bdp->bd_number];

    /* Find out specifically what Phy this is.  We do this because for *
     * certain phys there are specific bits that must be set so that the *
     * phy and the 82557 work together properly. */

    e100_MdiRead(bdp, PHY_ID_REG_1, bdp->phy_addr, &MdiIdLowReg);
    e100_MdiRead(bdp, PHY_ID_REG_2, bdp->phy_addr, &MdiIdHighReg);

    PhyId = ((unsigned int) MdiIdLowReg | ((unsigned int) MdiIdHighReg << 16));

    bdp->PhyState = 0;
    bdp->PhyDelay = 0;

    /* get the revsion field of the Phy ID so that we'll be able to detect */
    /* future revs of the same Phy. */
    PhyId &= PHY_MODEL_REV_ID_MASK;
    bdp->PhyId = PhyId;     

    /* If Intel Phy, set flag to indicate this */
    if (PhyId == PHY_82555_TX) {
        bdp->flags |= DF_PHY_82555;
    }

    /* Handle the National TX */
    if (PhyId == PHY_NSC_TX) {
        e100_MdiRead(bdp, NSC_CONG_CONTROL_REG, bdp->phy_addr,
            &MdiMiscReg);

        MdiMiscReg |= NSC_TX_CONG_TXREADY;

        /* If we are configured to do congestion control, then enable the */
        /* congestion control bit in the National Phy */
        if (e100_cong_enbl)
            MdiMiscReg |= NSC_TX_CONG_ENABLE;
        else
            MdiMiscReg &= ~NSC_TX_CONG_ENABLE;

        e100_MdiWrite(bdp, NSC_CONG_CONTROL_REG, bdp->phy_addr,
            MdiMiscReg);
    }

    if ((board_speed_duplex >= 1) && (board_speed_duplex <= 4))
        e100_ForceSpeedAndDuplex(bdp);

    /* Set bdp values for speed and duplex modes only if autonegotiation *
     * happened. If it was forced, the bdp values would have been set by *
     * the ForceSpeedAndUplex routine. If it isn't then we need to check * to 
     * see if autoneg has completed and if we need to restart it. */
    if (!((board_speed_duplex >= 1) && (board_speed_duplex <= 4))) {
        e100_auto_neg(bdp);
        e100_FindPhySpeedAndDpx(bdp, PhyId);
    }
    return (B_TRUE);
}


/* 
 * Procedure:   e100_fix_polarity
 *
 * Description:
 *      Fix for 82555 auto-polarity toggle problem. With a short cable 
 *      connecting an 82555 with an 840A link partner, if the medium is noisy,
 *      the 82555 sometime thinks that the polarity might be wrong and so 
 *      toggles polarity. This happens repeatedly and results in a high bit 
 *      error rate.
 *      NOTE: This happens only at 10 Mbps
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_fix_polarity (bd_config_t * bdp)
{
    unsigned long   PhyAdd;
    unsigned short  Status;
    unsigned short  errors;
    int             speed;

    PhyAdd = bdp->phy_addr;

    /* If the user wants auto-polarity disabled, do only that and nothing *
     * else. * e100_autopolarity == 0 means disable --- we do just the
     * disabling * e100_autopolarity == 1 means enable  --- we do nothing at
     * all * e100_autopolarity >= 2 means we do the workaround code. */
    /* Change for 82558 enhancement */
    if (!(bdp->flags & IS_BACHELOR)) {
        if (e100_autopolarity == 0) {
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL,
                PhyAdd, DISABLE_AUTO_POLARITY);
        } else if (e100_autopolarity >= 2) {
            /* we do this only if we have an 82555 and if link is up */
            if ((bdp->flags & DF_PHY_82555) && (bdp->flags & DF_LINK_UP)) {
                
                e100_MdiRead(bdp, PHY_82555_CSR, PhyAdd, &Status);
                speed = (Status & PHY_82555_SPEED_BIT) ? 100 : 10;

                /* we need to do this only if speed is 10 */
                if (speed == 10) {
                    /* see if we have any end of frame errors */
                    e100_MdiRead(bdp, PHY_82555_EOF_COUNTER, PhyAdd, &errors);

                    /* if non-zero, wait for 100 ms before reading again */
                    if (errors) {
                        udelay(200);
                        e100_MdiRead(bdp, PHY_82555_EOF_COUNTER, PhyAdd, &errors);

                        /* if non-zero again, we disable polarity */
                        if (errors) {
                            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL,
                                PhyAdd, DISABLE_AUTO_POLARITY);
                        }
                    } else {
                        /* it is safe to read the polarity now */
                        e100_MdiRead(bdp, PHY_82555_CSR, PhyAdd, &Status);

                        /* if polarity is normal, disable polarity */
                        if (!(Status & PHY_82555_POLARITY_BIT)) {
                            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL,
                                PhyAdd, DISABLE_AUTO_POLARITY);
                        }
                    }
                }            /* end if speed == 10 */
            }               /* end if PHY 82555 */
        }                  /* end of polarity fix */
    }
}


/* 
 * Procedure:   e100_auto_neg
 *
 * Description: This routine will start autonegotiation and wait
 *                   for it to complete
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_auto_neg(bd_config_t * bdp)
{
    u16               mdi_status_reg;
    unsigned int      i;
    /* first we need to check to see if autoneg has already completed. Sticky 
     * so read twice */
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &(mdi_status_reg));
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &(mdi_status_reg));
    /* if it is finished then leave */
    if (mdi_status_reg & MDI_SR_AUTO_NEG_COMPLETE) {
        return;
    }

    /* if we are capable of performing autoneg then we restart */
    if (mdi_status_reg & MDI_SR_AUTO_SELECT_CAPABLE) {
        e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr,
            MDI_CR_AUTO_SELECT | MDI_CR_RESTART_AUTO_NEG);

        /* now wait for autoneg to complete this could be up to 3 seconds */
        for (i = 0; 
             (!(mdi_status_reg & MDI_SR_AUTO_NEG_COMPLETE)) &&(i < 60); i++) {

            set_current_state(TASK_INTERRUPTIBLE);
            schedule_timeout(E100_MAX(HZ/20,1)); // at least 50 ms

            /* now re-read the value. Sticky so read twice */
            e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr,
                &(mdi_status_reg));
            e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr,
                &(mdi_status_reg));
        }
    }
    return;
}



/* 
 * Procedure:   e100_FindPhySpeedAndDpx
 *
 * Description: This routine will figure out what line speed and duplex mode
 *              the PHY is currently using.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      PhyId - The ID of the PHY in question.
 *
 * Returns:
 *      NOTHING
 */
void
e100_FindPhySpeedAndDpx(bd_config_t * bdp, unsigned int PhyId)
{
    u16 MdiStatusReg;
    u16 MdiMiscReg;
    u16 MdiOwnAdReg;
    u16 MdiLinkPartnerAdReg;

    /* First we should check to see if we have link */
    /* If we don't have link no reason to print a speed and duplex */
    if ( e100_UpdatePhyLinkState(bdp) == B_FALSE ) {
        return;
    }

    /* Check if the PHY was already forced */
    if (bdp->flags & DF_SPEED_FORCED) {
        return;
    }

    /* On the 82559 and later controllers, speed/duplex is part of the *
     * SCB. So, we save an MdiRead and get these from the SCB. * */
    if (bdp->rev_id >= D101MA_REV_ID) {
        /* Read speed */
        if (readb(&bdp->scbp->scb_ext.d101m_scb.scb_gen_stat)
	    & BIT_1)
            bdp->cur_line_speed = 100;
        else
            bdp->cur_line_speed = 10;

        /* Read duplex */
        if (readb(&bdp->scbp->scb_ext.d101m_scb.scb_gen_stat)
	    & BIT_2)
            bdp->cur_dplx_mode = FULL_DUPLEX;
        else
            bdp->cur_dplx_mode = HALF_DUPLEX;

        return;
    }

    /* If this is a Phy 100, then read bits 1 and 0 of extended register 0,
     * * to get the current speed and duplex settings. */
    if ((PhyId == PHY_100_A) ||
        (PhyId == PHY_100_C) || (PhyId == PHY_82555_TX)) {
        /* Read Phy 100 extended register 0 */
        e100_MdiRead(bdp, EXTENDED_REG_0, bdp->phy_addr, &MdiMiscReg);

        /* Get current speed setting */
        if (MdiMiscReg & PHY_100_ER0_SPEED_INDIC)
            bdp->cur_line_speed = 100;
        else
            bdp->cur_line_speed = 10;

        /* Get current duplex setting -- if bit is set then FDX is enabled */
        if (MdiMiscReg & PHY_100_ER0_FDX_INDIC)
            bdp->cur_dplx_mode = FULL_DUPLEX;
        else
            bdp->cur_dplx_mode = HALF_DUPLEX;

        return;
    }

    /* See if link partner was capable of Auto-Negotiation (bit 0, reg 6) */
    e100_MdiRead(bdp, AUTO_NEG_EXPANSION_REG, bdp->phy_addr, &MdiMiscReg);

    /* See if Auto-Negotiation was complete (bit 5, reg 1) */
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &MdiStatusReg);

    /* If a True NWAY connection was made, then we can detect speed/dplx *
     * by ANDing our adapter's advertised abilities with our link partner's * 
     * advertised ablilities, and then assuming that the highest common *
     * denominator was chosed by NWAY. */
    if ((MdiMiscReg & NWAY_EX_LP_NWAY) &&
        (MdiStatusReg & MDI_SR_AUTO_NEG_COMPLETE)) {

        /* Read our advertisement register */
        e100_MdiRead(bdp, AUTO_NEG_ADVERTISE_REG, bdp->phy_addr,
            &MdiOwnAdReg);

        /* Read our link partner's advertisement register */
        e100_MdiRead(bdp, AUTO_NEG_LINK_PARTNER_REG, bdp->phy_addr,
            &MdiLinkPartnerAdReg);

        /* AND the two advertisement registers together, and get rid of any
         * * extraneous bits. */
        MdiOwnAdReg &= (MdiLinkPartnerAdReg & NWAY_LP_ABILITY);

        /* Get speed setting */
        if (MdiOwnAdReg &
            (NWAY_AD_TX_HALF_DPX | NWAY_AD_TX_FULL_DPX |
                NWAY_AD_T4_CAPABLE)) bdp->cur_line_speed = 100;
        else
            bdp->cur_line_speed = 10;

        /* Get duplex setting -- use priority resolution algorithm */
        if (MdiOwnAdReg & (NWAY_AD_T4_CAPABLE)) {
            bdp->cur_dplx_mode = HALF_DUPLEX;
            return;
        } else if (MdiOwnAdReg & (NWAY_AD_TX_FULL_DPX)) {
            bdp->cur_dplx_mode = FULL_DUPLEX;
            return;
        } else if (MdiOwnAdReg & (NWAY_AD_TX_HALF_DPX)) {
            bdp->cur_dplx_mode = HALF_DUPLEX;
            return;
        } else if (MdiOwnAdReg & (NWAY_AD_10T_FULL_DPX)) {
            bdp->cur_dplx_mode = FULL_DUPLEX;
            return;
        } else {
            bdp->cur_dplx_mode = HALF_DUPLEX;
            return;
        }
    }

    /* If we are connected to a dumb (non-NWAY) repeater or hub, and the line 
     * speed was determined automatically by parallel detection, then we have
     * no way of knowing exactly what speed the PHY is set to unless that PHY
     * has a propietary register which indicates speed in this situation.  The
     * NSC TX PHY does have such a register.  Also, since NWAY didn't establish
     * the connection, the duplex setting should HALF duplex. 
     */

    bdp->cur_dplx_mode = HALF_DUPLEX;

    if (PhyId == PHY_NSC_TX) {
        /* Read register 25 to get the SPEED_10 bit */
        e100_MdiRead(bdp, NSC_SPEED_IND_REG, bdp->phy_addr, &MdiMiscReg);

        /* If bit 6 was set then we're at 10Mbps */
        if (MdiMiscReg & NSC_TX_SPD_INDC_SPEED)
            bdp->cur_line_speed = 10;
        else
            bdp->cur_line_speed = 100;

    } else {
        /* If we don't know what line speed we are set at, then we'll default 
         * to 10Mbps */
        bdp->cur_line_speed = 10;
    }
}


/* 
 * Procedure: e100_ForceSpeedAndDuplex
 *
 * Description: This routine forces line speed and duplex mode of the
 * adapter based on the values the user has set in e100.c.
 *
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *
 * Returns: void
 *
 */
void
e100_ForceSpeedAndDuplex(bd_config_t * bdp)
{
    u16                  control;
    int                  board_speed_duplex;
    int neg_timeout    = 2*HZ; //2 sec in jiffies
    int sleep_time     = E100_MAX(HZ/20,1) ;// at least 50 msec
    board_speed_duplex = e100_speed_duplex[bdp->bd_number];

    bdp->flags |= DF_SPEED_FORCED;
    e100_MdiRead(bdp, MDI_CONTROL_REG, bdp->phy_addr, &control);
    control &= ~MDI_CR_AUTO_SELECT;

    /* Check e100.c values */
    switch (board_speed_duplex) {
        /* 10 half */
    case 1:
        control &= ~MDI_CR_10_100;
        control &= ~MDI_CR_FULL_HALF;
        bdp->cur_line_speed = 10;
        bdp->cur_dplx_mode = HALF_DUPLEX;
        break;

        /* 10 full */
    case 2:
        control &= ~MDI_CR_10_100;
        control |= MDI_CR_FULL_HALF;
        bdp->cur_line_speed = 10;
        bdp->cur_dplx_mode = FULL_DUPLEX;
        break;

        /* 100 half */
    case 3:
        control |= MDI_CR_10_100;
        control &= ~MDI_CR_FULL_HALF;
        bdp->cur_line_speed = 100;
        bdp->cur_dplx_mode = HALF_DUPLEX;
        break;

        /* 100 full */
    case 4:
        control |= MDI_CR_10_100;
        control |= MDI_CR_FULL_HALF;
        bdp->cur_line_speed = 100;
        bdp->cur_dplx_mode = FULL_DUPLEX;
        break;
    }

    e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr, control);

    /* loop must run at least once */
    do {
            set_current_state(TASK_INTERRUPTIBLE);
            schedule_timeout(sleep_time);
            /* check if there's no link */
            if ( e100_UpdatePhyLinkState(bdp) == B_TRUE ) {
                    break;
            }
            neg_timeout -= sleep_time; // in msec
    } while (neg_timeout > 0);
}


/* 
 * Procedure: e100_phy_check
 * 
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *                  
 *
 * Returns: void
 *
 */
void
e100_phy_check(bd_config_t * bdp)
{
    unsigned char old_link;
    
    old_link = (bdp->flags & DF_LINK_UP) ? 1 : 0; 
    e100_FindPhySpeedAndDpx(bdp, bdp->PhyId);

    if (!old_link && (bdp->flags & DF_LINK_UP)) {
        printk(KERN_ERR "e100: %s NIC Link is Up %d Mbps %s duplex\n",
               bdp->device->name, bdp->cur_line_speed,
               (bdp->cur_dplx_mode == HALF_DUPLEX) ? "Half" : "Full");
    }

    if (old_link && !(bdp->flags & DF_LINK_UP)) {
        /* reset the zerol lock state */
        bdp->ZeroLockState = ZLOCK_INITIAL;

        // set auto lock for phy auto-negotiation on link up
        e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0);

        printk(KERN_ERR "e100: %s NIC Link is Down\n", bdp->device->name);
     }

    if ((!(bdp->flags & DF_PHY_82555)) || (bdp->flags & DF_SPEED_FORCED))
        return;

    if (bdp->flags & DF_LINK_UP) {
        switch (bdp->PhyState) {
        case 0:
            break;
        case 1:
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL, bdp->phy_addr, 0x0000);
            break;
        case 2:
            e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0x3000);
            break;
        }
        bdp->PhyState = 0;
        bdp->PhyDelay = 0;
    } else if (!bdp->PhyDelay--) {
        switch (bdp->PhyState) {
        case 0:
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL, bdp->phy_addr,
                EXTENDED_SQUELCH_BIT);
            bdp->PhyState = 1;
            break;
        case 1:
            e100_MdiWrite(bdp, PHY_82555_SPECIAL_CONTROL, bdp->phy_addr,
                0x0000);
            e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0x2010);
            bdp->PhyState = 2;
            break;
        case 2:
            e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0x3000);
            bdp->PhyState = 0;
            break;
        }

        e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr,
            MDI_CR_AUTO_SELECT | MDI_CR_RESTART_AUTO_NEG);
        bdp->PhyDelay = 3;
    }
}


void e100_ResetPhy(bd_config_t *bdp)
{
    u16 mdi_control_reg;

    mdi_control_reg = (MDI_CR_AUTO_SELECT | MDI_CR_RESTART_AUTO_NEG |
        MDI_CR_RESET);

    e100_MdiWrite(bdp, MDI_CONTROL_REG, bdp->phy_addr, mdi_control_reg);

    udelay(100);
}


/* 
 * Procedure: e100_UpdatePhyLinkState
 * 
 * Description: This routine updates the link status of the adapter
 *
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *                  
 *
 * Returns: B_TRUE - If a link is found
 *              B_FALSE - If there is no link
 *
 */
unsigned char
e100_UpdatePhyLinkState(bd_config_t * bdp)
{
    /* Check link status */
    if (e100_GetPhyLinkState(bdp) == B_TRUE) {
        bdp->flags |= DF_LINK_UP;
    } else {
        bdp->flags &= ~DF_LINK_UP;
    }

    return (bdp->flags & DF_LINK_UP) ? B_TRUE : B_FALSE;
}

/* 
 * Procedure: e100_GetPhyLinkState
 * 
 * Description: This routine checks the link status of the adapter
 *
 * Arguments:  bdp - Pointer to the bd_config_t structure for the board
 *                  
 *
 * Returns: B_TRUE - If a link is found
 *              B_FALSE - If there is no link
 *
 */
unsigned char
e100_GetPhyLinkState(bd_config_t * bdp)
{
    u16 Status;

    /* Check link status */
    /* If the controller is a 82559 or later one, link status is available
     * from the CSR. This avoids the MdiRead. */
    if (bdp->rev_id >= D101MA_REV_ID) {
        if (readb(&bdp->scbp->scb_ext.d101m_scb.scb_gen_stat)
	    & BIT_0) {
            /* Link is up */
            return (B_TRUE);
        } else 
            /* Link is down */
            return (B_FALSE);
    }
    else {
        /* Read the status register */
        e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &Status);

        /* Read the status register again because of sticky bits */
        e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &Status);

        if (Status & MDI_SR_LINK_STATUS) {
            return (B_TRUE);
        } else {
            return (B_FALSE);
        }
    }       
}

/* 
 * Procedure:   e100_MdiWrite
 *
 * Description: This routine will write a value to the specified MII register
 *              of an external MDI compliant device (e.g. PHY 100).  The
 *              command will execute in polled mode.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      RegAddress - The MII register that we are writing to
 *      PhyAddress - The MDI address of the Phy component.
 *      DataValue - The value that we are writing to the MII register.
 *
 * Returns:
 *      NOTHING
 */
void
e100_MdiWrite(bd_config_t * bdp,
    u32 RegAddress, u32 PhyAddress, u16 DataValue)
{
    int e100_retry;
    u32 temp_val;

    temp_val = (((u32) DataValue) |
        (RegAddress << 16) | (PhyAddress << 21) | (MDI_WRITE <<
            26));
    writel(temp_val,&bdp->scbp->scb_mdi_cntrl);

    /* wait 20usec before checking status */
    udelay(20);     

    /* poll for the mdi write to complete */
    e100_retry = E100_CMD_WAIT;
    while ((!(readl(&bdp->scbp->scb_mdi_cntrl) & MDI_PHY_READY)) && (e100_retry)) {
        udelay(20); 
        e100_retry--;
    }
}


/* 
 * Procedure:   e100_MdiRead
 *
 * Description: This routine will read a value from the specified MII register
 *              of an external MDI compliant device (e.g. PHY 100), and return
 *              it to the calling routine.  The command will execute in polled
 *              mode.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *      RegAddress - The MII register that we are reading from
 *      PhyAddress - The MDI address of the Phy component.
 *
 * Results:
 *      DataValue - The value that we read from the MII register.
 *
 * Returns:
 *      NOTHING
 */
void
e100_MdiRead(bd_config_t * bdp,
    u32 RegAddress, u32 PhyAddress, u16 * DataValue)
{
    int e100_retry;
    u32 temp_val;

    /* Issue the read command to the MDI control register. */
    temp_val =
        ((RegAddress << 16) | (PhyAddress << 21) | (MDI_READ << 26));
    writel(temp_val,&bdp->scbp->scb_mdi_cntrl);

    /* wait 20usec before checking status */
    udelay(20);

    /* poll for the mdi read to complete */
    e100_retry = E100_CMD_WAIT;
    while ((!(readl(&bdp->scbp->scb_mdi_cntrl) & MDI_PHY_READY)) && (e100_retry)) {
        udelay(20);
        e100_retry--;
    }

    /* return 0 blindly as datavalue if we have timed out * and hope that
     * someone above smells a rat */

    if (!e100_retry)
        *DataValue = 0;

    // return the lower word
    *DataValue = (u16) readl(&bdp->scbp->scb_mdi_cntrl);
}


/*
 * Procedure: e100_D102_check_checksum
 * 
 * Description: Checks the D102 RFD flags to see if the checksum passed
 *
 * Arguments:  rfdp pointer to rfd
 *               
 */
 
static unsigned char
e100_D102_check_checksum(rfd_t *rfdp)
{
    u16 status = le16_to_cpu(rfdp->rfd_header.cb_status);

    if (/* frame parsing succeed */
        (status & RFD_PARSE_BIT)
        /* frame recognized as a TCP or UDP frame */
        && (((rfdp->rcvparserstatus & CHECKSUM_PROTOCOL_MASK) == RFD_TCP_PACKET) || 
            ((rfdp->rcvparserstatus & CHECKSUM_PROTOCOL_MASK) == RFD_UDP_PACKET))
        /* checksum was calculated */
        && (rfdp->checksumstatus & TCPUDP_CHECKSUM_BIT_VALID) 
        /* and it happens to be valid */
        && (rfdp->checksumstatus & TCPUDP_CHECKSUM_VALID)){ 

        return CHECKSUM_UNNECESSARY;
    }
    return CHECKSUM_NONE;

}

/* e100_D101M_checksum
 *  Description: sets the skb->csum value from d101 csum foubd at the end of the Rx frame
 *  the D101M sums all words in frame excluding the ethernet II header(14 bytes)
 * so incase the packet is ethernet II & the protocol is IP, all is need is to assign 
 * this value to skb->csum 
 */
static unsigned char
e100_D101M_checksum(bd_config_t *bdp,rfd_t *rfdp,struct sk_buff *skb)
{
        unsigned short proto = (skb->protocol); 

#ifdef IANS
        if (ANS_PRIVATE_DATA_FIELD(bdp)->routing_mode 
            == IANS_ROUTING_ON) {
                if (ANS_PRIVATE_DATA_FIELD(bdp)->attributed_mode) {
                        return CHECKSUM_NONE;
                } else {
                        proto = (unsigned short)get_unaligned(
                                      &(iANSGetReceiveAttributeHeader(skb)->OriginalProtocol));
                } 
        }
#endif /* IANS */

        if (proto == __constant_htons(ETH_P_IP)) {
        
        /* if the frame is layer 2 padded don't set the csum
         * starting from 2.4.4, this is done by the ip_rcv routine */
#if   ( LINUX_VERSION_CODE < KERNEL_VERSION(2,4,4) )
        {
            struct iphdr * iph = (struct iphdr *)skb->data ;
            
            if (ntohs(iph->tot_len) < skb->len){
                return CHECKSUM_NONE;
            }
        }
#endif
        
        skb->csum = get_unaligned( (u16 *)(skb->tail));
        return  CHECKSUM_HW;
        }
        return CHECKSUM_NONE;
}

/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/***************************************************************************/
/*       Auxilary Functions                                                */
/***************************************************************************/


/* 
 * Procedure:   e100_print_brd_conf
 *
 * Description: This routine printd the board configuration.
 *
 * Arguments:
 *      bdp    - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NONE
 *
 */
void
e100_print_brd_conf(bd_config_t * bdp)
{
    if (bdp->flags & DF_LINK_UP) {
        printk(KERN_NOTICE "  Mem:0x%08lx  IRQ:%d  Speed:%d Mbps  Dx:%s\n",
               (unsigned long)bdp->device->mem_start, bdp->device->irq,
               bdp->cur_line_speed, (bdp->cur_dplx_mode == FULL_DUPLEX) ? "Full" : "Half");
    } else {
        printk(KERN_NOTICE "  Mem:0x%08lx  IRQ:%d  Speed:%d Mbps  Dx:%s\n",
               (unsigned long)bdp->device->mem_start, bdp->device->irq, 0, "N/A");

        /* Auto negotiation failed so we should display an error */
        printk(KERN_NOTICE "  Failed to detect cable link.\n");
        printk(KERN_NOTICE "  Speed and duplex will be determined at time of connection.\n");
    }
    
    /* Print the string if checksum Offloading was enabled */
    if (bdp->flags & DF_CSUM_OFFLOAD) 
        printk(KERN_NOTICE "  Hardware receive checksums enabled\n");
    else 
        printk(KERN_NOTICE "  Hardware receive checksums disabled\n");
    
    if ((bdp->flags & DF_UCODE_LOADED))
        printk(KERN_NOTICE "  cpu cycle saver enabled\n");
}


/* New routine for checking sub-dev & sub-ven IDs. */

/* 
 * Procedure:   e100_GetBrandingMesg
 *
 * Description: This routine checks if the sub_ven and sub_dev found
 * on the board is a valid one for the driver to load. If it is, the
 * routine determines the right string to be printed. The routine knows
 * what IDs to load on by scanning a predefined array.
 *
 * Arguments:
 *      sub_ven - Subsystem vendor ID on the board
 *      sub_dev - Subsystem device ID on the board
 *
 * Returns:
 *      1 - if it is valid to load on this board
 *      0 - if it is not valid to load on this board
 *
 */
char *
e100_GetBrandingMesg(bd_config_t *bdp)
{
    u16    sub_ven, sub_dev;
    char        *mesg = NULL;
    int         i = 0;

    sub_ven = bdp->sub_ven_id;
    sub_dev = bdp->sub_dev_id;
    
    /* Go through the list of all valid device, vendor and subsystem IDs */
    while (e100_vendor_info_array[i].idstr != NULL) {
        /* Look for a match on device id */
        if ((e100_vendor_info_array[i].dev_id == bdp->ppci_dev->device)
            || (e100_vendor_info_array[i].dev_id == CATCHALL)) {
            /* Look for a match on sub_ven */
            if ((e100_vendor_info_array[i].sub_ven == sub_ven)
                /* Is this driver to load on all adapters from this vendor? */
                || (e100_vendor_info_array[i].sub_ven == CATCHALL)) { 
                /* Look for a match on sub_dev */
                if ((e100_vendor_info_array[i].sub_dev == sub_dev)
                    /* Is this driver to load on all adapters with this subsytem dev id? */
                    || (e100_vendor_info_array[i].sub_dev == CATCHALL)) {
                    mesg = e100_vendor_info_array[i].idstr;
                    break;
                }
            }
        }
        i++;
    }

    if (mesg)   strncpy(e100id_string, mesg, sizeof(e100id_string)-1);
    else        printk(KERN_WARNING "e100: Vendor ID Mismatch\n");
    return mesg;
    
}




/* 
 * Procedure:   e100_dis_intr
 *
 * Description: This routine disables interrupts at the hardware, by setting
 *              the M (mask) bit in the adapter's CSR SCB command word.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_dis_intr(bd_config_t * bdp)
{
    /* Disable interrupts on our PCI board by setting the mask bit */
    writeb(SCB_INT_MASK,&bdp->scbp->scb_cmd_hi);
}


/* 
 * Procedure:   e100_enbl_intr
 *
 * Description: This routine enables interrupts at the hardware, by resetting
 *              the M (mask) bit in the adapter's CSR SCB command word
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *
 * Returns:
 *      NOTHING
 */
void
e100_enbl_intr(bd_config_t * bdp)
{
    /* Enable interrupts on our PCI board by clearing the mask bit */
    writeb(0,&bdp->scbp->scb_cmd_hi);
}


void
e100_trigger_SWI(bd_config_t * bdp)
{
    /* Trigger interrupt on our PCI board by asserting SWI bit */
    writeb(SCB_SOFT_INT,&bdp->scbp->scb_cmd_hi);
}



/*****************************************************************************
 * Name:        e100_get_pci_info
 *
 * Description: This routine finds all PCI adapters that have the given Device
 *              ID and Vendor ID.  It will store the IRQ, I/O, mem address,
 *              amd node address for each adapter in the
 *              CardsFound structure.  This routine will also enable the bus
 *              master bit on any of our adapters (some BIOS don't do this).
 *
 *
 * Arguments:
 *      vendor_id - Vendor ID of our adapter.
 *      device_id - Device ID of our adapter.
 *
 * Returns:
 *      B_TRUE     - if found pci devices successfully
 *      B_FALSE     - if no pci devices found
 *
 * Modification log:
 * Date      Who  Description
 * --------  ---  --------------------------------------------------------
 *
 *****************************************************************************/
static unsigned char
e100_get_pci_info(struct pci_dev * pcid, bd_config_t * bdp)
{
    u32 tmp_base_addr;
    u16 pci_cmd = 0;
    u16 regValue;

    /* dev and ven ID have already been check so it is our device */
    pci_read_config_byte(pcid, PCI_REVISION_ID, (u8 *) & (bdp->rev_id));
    pci_read_config_word(pcid, PCI_SUBSYSTEM_ID, (u16 *) & (bdp->sub_dev_id));
    pci_read_config_word(pcid, PCI_SUBSYSTEM_VENDOR_ID, (u16 *) & (bdp->sub_ven_id));
    pci_read_config_word(pcid, PCI_COMMAND, (u16 *) & (pci_cmd));
    
    pci_read_config_word(pcid, PMCSR, &regValue);
    regValue |= PM_ENABLE_BIT;
    pci_write_config_word(pcid, PMCSR, regValue);
    
    /* if Bus Mastering is off, turn it on! */
    pci_set_master(pcid);

    /* address #0 is a memory mapping */
    bdp->scbp = (pscb_t) ioremap(pci_resource_start(pcid, 0) & PCI_BASE_ADDRESS_MEM_MASK,
                                 sizeof(scb_t));
    
    if (!bdp->scbp) {
        printk(KERN_ERR "%s - %s: Failed to map PCI address 0x%lX\n",
               e100_short_driver_name, bdp->device->name,
               pci_resource_start(pcid, 0));
        return B_FALSE;
    }
    
    bdp->device->mem_start = pci_resource_start(pcid, 0);
    bdp->device->mem_end   = bdp->device->mem_start + sizeof(scb_t);
    /* address #1 is a IO region */
    tmp_base_addr = (u32)pci_resource_start(pcid, 1);
    bdp->io_start = (tmp_base_addr & ~0x3UL);
  
    return B_TRUE;
}



/**************************************************************************\
 **
 ** PROC NAME:     e100_handle_zero_lock_state
 **    This function manages a state machine that controls
 **    the driver's zero locking algorithm.
 **    This function is called by e100_watchdog() every ~2 second.
 ** States:
 **    The current link handling state is stored in 
 **    bdp->ZeroLockState, and is one of:
 **    ZLOCK_INITIAL, ZLOCK_READING, ZLOCK_SLEEPING
 **    Detailed description of the states and the transitions
 **    between states is found below.
 **    Note that any time the link is down / there is a reset
 **    state will be changed outside this function to ZLOCK_INITIAL
 ** Algorithm:
 **    1. If link is up & 100 Mbps continue else stay in #1:
 **    2. Set 'auto lock'
 **    3. Read & Store 100 times 'Zero' locked in 1 sec interval
 **    4. If max zero read >= 0xB continue else goto 1
 **    5. Set most popular 'Zero' read in #3
 **    6. Sleep 5 minutes
 **    7. Read number of errors, if it is > 300 goto 2 else goto 6
 ** Data Structures (in DRIVER_DATA):
 **    ZeroLockState           - current state of the algorithm
 **    ZeroLockReadCounter     - counts number of reads (up to 100)
 **    ZeroLockReadData[i] - counts number of times 'Zero' read was i, 0 <= i <= 15
 **    ZeroLockSleepCounter - keeps track of "sleep" time (up to 300 secs = 5 minutes)
 **                                
 ** Parameters:    DRIVER_DATA    *bdp
 **
 **                bdp  - Pointer to HSM's adapter data space
 **
 ** Return Value:  NONE
 **
 ** See Also:      e100_watchdog()
 **
 \**************************************************************************/
static void e100_handle_zero_lock_state(bd_config_t * bdp)
{
    u16        ArrayPosition;
    u16        EqRegValue;
    u8         MostPopularZero;
    u16        ErrorCounter;

    switch (bdp->ZeroLockState) {
    case ZLOCK_INITIAL:

        if ( ((u8)bdp->rev_id <= D102_REV_ID) || 
            !(bdp->cur_line_speed == 100) || 
            !(bdp->flags & DF_LINK_UP) ) 
        {
            break;
        }
                
        //initialize hw and sw and start reading                        
                
        e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, 0);
        // reset read counters:
        bdp->ZeroLockReadCounter = 0;
        for (ArrayPosition=0; ArrayPosition < 16; ArrayPosition++)
            bdp->ZeroLockReadData[ArrayPosition] = 0;
        // start reading in the next call back:
        bdp->ZeroLockState = ZLOCK_READING;

        /* fall through !! */
                
    case ZLOCK_READING:
        // state: reading (100 times) zero locked in 1 sec interval
        // prev states: ZLOCK_INITIAL
        // next states: ZLOCK_INITIAL, ZLOCK_SLEEPING

        e100_MdiRead(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, &EqRegValue);
        ArrayPosition = (EqRegValue & ZLOCK_ZERO_MASK) >> 4;
        bdp->ZeroLockReadData[ArrayPosition]++;
        bdp->ZeroLockReadCounter++;

        if (bdp->ZeroLockReadCounter == ZLOCK_MAX_READS)
        {
            // check if we have read a 'Zero' value of 0xB or greater:
            if ((bdp->ZeroLockReadData[0xB]) || (bdp->ZeroLockReadData[0xC]) ||
                (bdp->ZeroLockReadData[0xD]) || (bdp->ZeroLockReadData[0xE]) ||
                (bdp->ZeroLockReadData[0xF]))
            {
                // we have read a 'Zero' value of 0xB or greater, find the most popular 'Zero'
                // value and lock it:
                MostPopularZero = 0;
                // this loop finds the most popular 'Zero':
                for (ArrayPosition = 1; ArrayPosition < 16; ArrayPosition++)
                {
                    if (bdp->ZeroLockReadData[ArrayPosition] > bdp->ZeroLockReadData[MostPopularZero])
                        MostPopularZero = ArrayPosition;
                }
                // now lock the most popular 'Zero': 
                EqRegValue = (ZLOCK_SET_ZERO | MostPopularZero);
                e100_MdiWrite(bdp, PHY_82555_MDI_EQUALIZER_CSR, bdp->phy_addr, EqRegValue);

                // sleep for 5 minutes:
                bdp->ZeroLockSleepCounter = jiffies;
                bdp->ZeroLockState = ZLOCK_SLEEPING;
                // we will be reading the # of errors after 5 minutes, so we need to reset the
                // error counters - these registers are self clearing on read , so just read them:
                                
                e100_MdiRead(bdp, PHY_82555_SYMBOL_ERR, bdp->phy_addr, &ErrorCounter);
            }
            else
            {
                // we did not read a 'Zero' value of 0xB or above. go back to the start:
                bdp->ZeroLockState = ZLOCK_INITIAL;
            }

        }
        break;
        
    case ZLOCK_SLEEPING:
        // state: sleeping for 5 minutes
        // prev states: ZLOCK_READING
        // next states: ZLOCK_READING, ZLOCK_SLEEPING

        // if 5 minutes have passed:
        if (( jiffies - bdp->ZeroLockSleepCounter ) >= ZLOCK_MAX_SLEEP)
        {
            // read and sum up the number of errors:
            e100_MdiRead(bdp, PHY_82555_SYMBOL_ERR, bdp->phy_addr, &ErrorCounter);
            // if we have more than 300 errors (this number was calculated according
            //to the spec max allowed errors (80 errors per 1 million frames)
            //for 5 minutes in 100 Mbps (or the user specified max BER number)
            if (ErrorCounter > ber[bdp->bd_number])
            {
                // start again in the next callback:
                bdp->ZeroLockState = ZLOCK_INITIAL;
            }
            else
            {
                // we don't have more errors than allowed, sleep for another 5 minutes:
                bdp->ZeroLockSleepCounter = jiffies;
            }
        }
        break;
    } // switch
} // e100_handle_zero_lock_state

static void
e100_tcb_add_C_bit(bd_config_t* bdp)
{
    tcb_t* tcbp = (tcb_t*)bdp->tcb_pool.data;
    int i;
    
    for (i=0;i< TxDescriptors[bdp->bd_number];i++,tcbp++) {
        tcbp->tcb_hdr.cb_status |= cpu_to_le16(CB_STATUS_COMPLETE);
    }
}

void 
e100_isolate_driver(bd_config_t *bdp)
{
    spin_write_lock( &(bdp->isolate_lock));
    
    del_timer_sync(&bdp->timer_id);
    
    e100_tx_notify_stop(bdp, SHORT_STOP);
    
    bdp->last_tcbp = NULL;
    
    e100_sw_reset(bdp, PORT_SELECTIVE_RESET);
}

/* 
 * Procedure:   e100_hw_reset_recover
 *
 * Description: This routine will recover the hw after reset.
 *
 * Arguments:
 *      bdp - Ptr to this card's e100_bdconfig structure
 *        reset_cmd - s/w reset or selective reset. 
 *
 * Returns:
 *        B_TRUE upon success
 *        B_FALSE upon failure
 */
unsigned char
e100_hw_reset_recover(bd_config_t *bdp, u32 reset_cmd)
{
    bdp->last_tcbp = NULL;
    if(reset_cmd == PORT_SOFTWARE_RESET){

        /*load CU & RU base */
        if (e100_wait_scb(bdp) != B_TRUE){
            printk(KERN_ERR "e100_hw_reset_recover: Wait failed\n");
            return B_FALSE;
        }
        writel(0,&bdp->scbp->scb_gen_ptr);
        e100_exec_cmd(bdp, SCB_CUC_LOAD_BASE);

        if (e100_wait_scb(bdp) != B_TRUE){
            printk(KERN_ERR "e100_hw_reset_recover: Wait failed\n");
            return B_FALSE;
        }
        if (e100_load_microcode(bdp, bdp->rev_id) == B_TRUE) 
            mdelay(1);   

        writel(0,&bdp->scbp->scb_gen_ptr);
        e100_exec_cmd(bdp, SCB_RUC_LOAD_BASE);

        /* Issue the load dump counters address command */
        if (e100_wait_scb(bdp) != B_TRUE){
            printk(KERN_ERR "e100_hw_reset_recover: Wait failed\n");
            return B_FALSE;
        }
        writel(bdp->stat_cnt_paddr,&bdp->scbp->scb_gen_ptr);
        e100_exec_cmd(bdp, SCB_CUC_DUMP_ADDR);

        if(e100_setup_iaaddr(bdp, bdp->device->dev_addr) != B_TRUE){
            printk(KERN_ERR "e100_hw_reset_recover: setup iaaddr failed\n");
            return B_FALSE;
        }


        e100_set_multi_exec(bdp->device);


        /* Change for 82558 enhancement */
        /* If 82558/9 and if the user has enabled flow control, set up * the
         * Flow Control Reg. in the CSR */
        if ((bdp->flags & IS_BACHELOR) && (flow_control[bdp->bd_number] == TRUE)) {
            writeb(DFLT_FC_THLD,&bdp->scbp->scb_ext.d101_scb.scb_fc_thld);
            writeb(DFLT_FC_CMD,&bdp->scbp->scb_ext.d101_scb.scb_fc_xon_xoff);
        }

    }

    e100_force_config(bdp);

    return B_TRUE;
}

void 
e100_deisolate_driver(bd_config_t *bdp, unsigned char recover)
{
    if(recover){
        
        bdp->next_cu_cmd = START_WAIT;
        bdp->last_tcbp = NULL;
        
        /* lets reset the chip */
        e100_sw_reset(bdp, PORT_SELECTIVE_RESET);
        
        if( e100_hw_reset_recover(bdp,PORT_SELECTIVE_RESET) != B_TRUE)
            printk(KERN_ERR "e100_deisolate_driver: HW reset recover failed.\n");
        
        if (e100_wait_scb(bdp) != B_TRUE)
            printk(KERN_ERR "e100_deisolate_driver: Wait failed.\n");
        e100_start_ru(bdp);
        
        
        /* relaunch watchdog timer in 2 sec */
        bdp->timer_id.expires = jiffies + (2 * HZ);
        add_timer(&bdp->timer_id);
        
        // we must clear tcbs since we may have lost Tx intrrupt
        // or have unsent frames on the tcb chain
        e100_tcb_add_C_bit(bdp);
        e100_tx_srv(bdp);

        e100_enbl_intr(bdp);
    }
    
    spin_write_unlock( &(bdp->isolate_lock) );
    e100_tx_notify_start(bdp, SHORT_STOP);
}

#ifdef E100_ETHTOOL_IOCTL
static int e100_do_ethtool_ioctl (struct net_device *dev, struct ifreq *ifr)
{
	struct ethtool_cmd ecmd;
	int rc = -EOPNOTSUPP;

	if (copy_from_user(&ecmd, ifr->ifr_data, sizeof(ecmd.cmd)))
		return -EFAULT;

	switch (ecmd.cmd) {
		case ETHTOOL_GSET:
			rc = e100_ethtool_get_settings(dev, ifr);
			break;

		case ETHTOOL_SSET:
			rc = e100_ethtool_set_settings(dev, ifr);
			break;
	#ifdef ETHTOOL_GDRVINFO
		case ETHTOOL_GDRVINFO:
			rc = e100_ethtool_get_drvinfo (dev, ifr);
			break;
	#endif //ETHTOOL_GDRVINFO
		default:
			break;
	}//switch

	return rc;
}

static int e100_ethtool_get_settings (struct net_device *dev, struct ifreq *ifr)
{
    bd_config_t    *bdp;
    struct ethtool_cmd ecmd;
    
    memset ((void *)&ecmd, 0, sizeof(ecmd));
    
    bdp = (bd_config_t *) dev->priv;
    
    ecmd.supported = bdp->speed_duplex_caps;
    
    ecmd.port = (bdp->speed_duplex_caps & SUPPORTED_TP)?PORT_TP:PORT_FIBRE;
    ecmd.transceiver = XCVR_INTERNAL;
    ecmd.phy_address = bdp->phy_addr;
    
    ecmd.speed = bdp->cur_line_speed;		
    ecmd.duplex = (bdp->cur_dplx_mode==HALF_DUPLEX) ? DUPLEX_HALF : DUPLEX_FULL;
    
    ecmd.autoneg = AUTONEG_ENABLE;
    
    if(copy_to_user(ifr->ifr_data, &ecmd, sizeof(ecmd))) 
        return -EFAULT;
    
    return 0;
}

static int e100_ethtool_set_settings (struct net_device *dev, struct ifreq *ifr)
{
    bd_config_t *bdp;
    int          current_duplex;
    int          e100_new_speed_duplex;
    int          ethtool_new_speed_duplex;
    int          speed_duplex_change_required;
    struct ethtool_cmd ecmd;
    
    if (!capable(CAP_NET_ADMIN)){
        return -EPERM;
    }
    
    bdp = (bd_config_t *) dev->priv;
    
    if (bdp->flags & DF_OPENED ) {
        return -EBUSY;
    }	
    
    if (copy_from_user(&ecmd, ifr->ifr_data, sizeof(ecmd))){
        return -EFAULT;
    }
    current_duplex = (bdp->cur_dplx_mode==HALF_DUPLEX) ? DUPLEX_HALF : DUPLEX_FULL;
    speed_duplex_change_required =
        (ecmd.speed != bdp->cur_line_speed) || (ecmd.duplex != current_duplex);
    
    if ((ecmd.autoneg == AUTONEG_ENABLE) && speed_duplex_change_required) {
        return -EINVAL;
    }

    if ((ecmd.autoneg == AUTONEG_ENABLE) && (bdp->speed_duplex_caps & SUPPORTED_Autoneg)){
        bdp->flags &= ~DF_SPEED_FORCED;
        e100_auto_neg(bdp);
        e100_FindPhySpeedAndDpx(bdp, bdp->PhyId);
    } else {
        if (speed_duplex_change_required) {
            if (ecmd.speed == SPEED_10){
                if (ecmd.duplex==DUPLEX_HALF){
                    e100_new_speed_duplex = E100_SPEED_10_HALF;
                    ethtool_new_speed_duplex = SUPPORTED_10baseT_Half;
                
                } else {
                    e100_new_speed_duplex = E100_SPEED_10_FULL;
                    ethtool_new_speed_duplex = SUPPORTED_10baseT_Full;
                }
                
            } else {
                if (ecmd.duplex==DUPLEX_HALF){
                    e100_new_speed_duplex = E100_SPEED_100_HALF;
                    ethtool_new_speed_duplex = SUPPORTED_100baseT_Half;

                } else {
                    e100_new_speed_duplex = E100_SPEED_100_FULL;
                    ethtool_new_speed_duplex = SUPPORTED_100baseT_Full;
                }
            }
            
            if (bdp->speed_duplex_caps & ethtool_new_speed_duplex){
                e100_speed_duplex[bdp->bd_number] = e100_new_speed_duplex;
                e100_ForceSpeedAndDuplex(bdp);

            } else {
                return -EOPNOTSUPP;
            }
            
        }
    }

    return 0;
}

#ifdef ETHTOOL_GDRVINFO
static int e100_ethtool_get_drvinfo (struct net_device *dev, struct ifreq *ifr)
{
    bd_config_t    *bdp;
    struct ethtool_drvinfo info;
    
    memset ((void *)&info, 0, sizeof(info));
    
    bdp = (bd_config_t *) dev->priv;
    
    /* strncopy with sizeof-1 insures terminating zero for each string
       field because of memset zero for whole info structure above*/
    
    strncpy(info.driver, e100_full_driver_name, sizeof(info.driver)-1);
    strncpy(info.version, e100_version, sizeof(info.version)-1);
    strncpy(info.fw_version, e100_GetBrandingMesg(bdp), sizeof(info.fw_version)-1);
    strncpy(info.bus_info,bdp->ppci_dev->slot_name, sizeof(info.bus_info)-1);
    
    if (copy_to_user(ifr->ifr_data, &info, sizeof(info))) 
        return -EFAULT;
    
    return 0;
}
#endif //ETHTOOL_GDRVINFO

static inline int e100_10BaseT_adapter (bd_config_t * bdp)
{
  return ((bdp->ppci_dev->device == 0x1229 ) &&
          (bdp->sub_ven_id == 0x8086)&&
          (bdp->sub_dev_id == 0x0003));
}
static void e100_get_speed_duplex_caps(bd_config_t * bdp)
{
    u16        Status;
    
    e100_MdiRead(bdp, MDI_STATUS_REG, bdp->phy_addr, &Status);
    
    bdp->speed_duplex_caps = 0;
    
    bdp->speed_duplex_caps |= (Status & MDI_SR_AUTO_SELECT_CAPABLE)?SUPPORTED_Autoneg:0;
    
    bdp->speed_duplex_caps |= (Status & MDI_SR_10T_HALF_DPX)?SUPPORTED_10baseT_Half:0;
    
    bdp->speed_duplex_caps |= (Status & MDI_SR_10T_FULL_DPX)?SUPPORTED_10baseT_Full:0;

    bdp->speed_duplex_caps |= (Status & MDI_SR_TX_HALF_DPX)?SUPPORTED_100baseT_Half:0;
    
    bdp->speed_duplex_caps |= (Status & MDI_SR_TX_FULL_DPX)?SUPPORTED_100baseT_Full:0;
    
#ifdef PHY_NC3133
    if ((bdp->sub_ven_id == 0x0E11) && (bdp->sub_dev_id == 0xB0E1))
        bdp->speed_duplex_caps = (SUPPORTED_FIBRE | SUPPORTED_100baseT_Full);
	else
#endif /*PHY_NC3133*/
            bdp->speed_duplex_caps |= SUPPORTED_TP;

        // Old 10BaseT card does not support Mdi Status register
        if ((Status == 0xFFFF) && e100_10BaseT_adapter(bdp)) {
                bdp->speed_duplex_caps = (SUPPORTED_10baseT_Half | SUPPORTED_TP);
        }
    
}
#endif /*E100_ETHTOOL_IOCTL*/

#ifdef E100_MII_IOCTL
static int e100_mii_ioctl(struct net_device *dev, struct ifreq *ifr, int cmd)
{	
    bd_config_t *bdp;
    struct mii_ioctl_data *data_ptr = (struct mii_ioctl_data *)&(ifr->ifr_data);
    
    bdp = (bd_config_t *) dev->priv; 
    
    switch(cmd) {
    case SIOCGMIIPHY:		
        data_ptr->phy_id = bdp->phy_addr & 0x1f;
        break;
        
    case SIOCGMIIREG:
        if (!capable(CAP_NET_ADMIN))
            return -EPERM;
        spin_lock_bh(&(bdp->mdi_access_lock));
        e100_MdiRead(bdp, data_ptr->reg_num & 0x1f, bdp->phy_addr, &(data_ptr->val_out));
        spin_unlock_bh(&(bdp->mdi_access_lock));
        break;
        
    case SIOCSMIIREG:		
        if (!capable(CAP_NET_ADMIN))
            return -EPERM;
        if (bdp->flags & DF_OPENED ){
            return -EBUSY;
        }  
        spin_lock_bh(&(bdp->mdi_access_lock));
        e100_MdiWrite(bdp, data_ptr->reg_num & 0x1f, bdp->phy_addr, data_ptr->val_in);
        spin_unlock_bh(&(bdp->mdi_access_lock));
        break;
    default:
        return -EOPNOTSUPP;
    }     
    return 0;
}
#endif //E100_MII_IOCTL
