// $Id: hello.cpp,v 1.5.2.6 2002/01/22 19:49:34 tm Exp $
// PDFlib client: hello example in C++
//
//

#include <iostream>

#include "pdflib.hpp"

int
main(void)
{
#ifdef	PDF_THROWS_CPP_EXCEPTIONS
    try
    {
#endif
	int font;
	PDFlib p;				// the PDFlib object

	// Open new PDF file
	if (p.open("hello.pdf") == -1) {
	    cerr << "Error: cannot open PDF file hello.pdf" << endl;
	    return 99;
	}

	p.set_info("Creator", "hello.cpp");
	p.set_info("Author", "Thomas Merz");
	p.set_info("Title", "Hello, world (C++)!");

	// start a new page
	p.begin_page((float) a4_width, (float) a4_height);

	// Change "host" encoding to "winansi" or whatever you need!
	font = p.findfont("Helvetica-Bold", "host", 0);

	p.setfont(font, 24);
	p.set_text_pos(50, 700);
	p.show("Hello, world!");
	p.continue_text("(says C++)");
	p.end_page();				// finish page
	p.close();				// close PDF document

#ifdef	PDF_THROWS_CPP_EXCEPTIONS
    }
    catch (PDFlib::Exception &ex)
    {
	cerr << "PDFlib EXCEPTION: " << ex.get_message() << endl;
	return 99;
    }
#endif

    return 0;
}
