/*
 * Demo of runtime debugging facilities provided by ASSERT.H and DEBUG.H
 *
 * Compile comamnds:
 *	cc debug -fop				<= No debug messages
 *	cc debug -fop DEBUG=1		<= Some debug messages
 *	cc debug -fop DEBUG=2		<= More debug messages
 *	cc debug -fop DEBUG=3		<= All debug messages
 *
 * After compiling, run the program and note the output. Also, note
 * the size of the compiled program file, which will grow as more
 * debugging code is added.
 */
#include <stdio.h>		/* Standard I/O definition */
#include <assert.h>		/* Runtime error checking */
#include <debug.h>		/* Runtime debug messages */

#ifdef DEBUG
	#message Debugging level: DEBUG
#endif

main()
{
	unsigned i, j;

	Debug(("Program starting\n"))		/* Always (when DEBUG) */

	Debug1(("Starting loop\n"))			/* Inhibited at level 1 */
	for(i=0; i < 10; ++i) {
		assert(i < 9)					/* Runtime error check */
		Debug2(("i=%u", i))				/* Inhibited at level 2 */
		for(j=0; j < i; ++j)
			putc(' ', stdout);
		fputs(".\n", stdout); }
	Debug1(("Ending loop\n"))			/* Inhibited at level 1 */

	Debug(("Program terminating\n"))	/* Always (when DEBUG) */
}
