/*  Copy related functions

    Copyright (c) Marty M. Peritsky 1996.
    All Rights Reserved.

    See COPY.TXT for more details.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <stdio.h>
#include <dos.h>
#include "copy.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define BUF_SIZE 8192
#define BIN_SW   0
#define ASC_SW   1
#define TRUE     1
#define FALSE    0

// F U N C T I O N S ////////////////////////////////////////////////////////

void copy1(char *file_in, int ab_in, char *file_out, int ab_out, int appnd, int z_switch, int same_date)
{
    char buf[BUF_SIZE];   
    FILE *fpin, *fpout;
    size_t n, i;
    union REGS regs;
    int asc_eof=FALSE;

    fpin=fopen(file_in, "rb");
    if (fpin == NULL)
        {
        printf("Unable to open %s\n", file_in);
        main_exit(1);
        } // end if.

    fpout=fopen(file_out, appnd ? "r+b" : "wb");
    if (fpout == NULL)
        {
        printf("Unable to open %s\n", file_out);
        main_exit(1);
        } // end if.

    if (appnd)
        fseek(fpout, ((ab_out == ASC_SW) ? -1L : 0L), SEEK_END);

    // When appending with the destination /a switch set, the output file
    // is assumed to end in CTRL-Z. The above statement "removes" the CTRL-Z.
    // Otherwise it simply sets the file position to the end of the file.
    do
        {
        n=fread(buf, sizeof(char), BUF_SIZE, fpin);
        if (ab_in == ASC_SW)
            {
            for (i=0;i<n;i++)
                {
                if (buf[i] == 0x1A)
                    {
                    asc_eof=TRUE;
                    break;
                    } // end if.

                } // end for.

            n=i;
            } // end if.

        if (z_switch)
            {
            for (i=0;i<n;i++)
                {
                buf[i]=(buf[i] & 0x7F);         
                } // end for.

            } // end if.

        if (n>0)
            {
            if (fwrite(buf, sizeof(char), n, fpout) != n)
                {
                printf("Error writing %s\n", file_out);
                main_exit(1);
                } // end if.

            } // end if.

        } // end do.
    while (!(( n == 0) || asc_eof || ((!ab_in) && (n != BUF_SIZE))));

    // The "while" statement above tests for three possible eof indicators:
    // First, n==0, which happens when copying from CON and the user presses
    // CTRL+Z.  Second, asc_eof, which happens when there is an embedded
    // CTRL+Z in a source file and /a is turned on for the source file; and
    // third, a binary copy is being performed and less than a full buffer is
    // read.
    if (ab_out == ASC_SW)
        {
        buf[0]=0x1A;
        if (fwrite(buf, sizeof(char), 1, fpout) != 1)
            {
            printf("Error writing %s\n", file_out);
            main_exit(1);
            } // end if.

        } // end if.

    if (same_date)
        {
        fflush(fpout);                  // So no more writes occur.
        regs.h.ah=0x57;                 // DOS file-date/time service.
        regs.h.al=0;                    // "Get" (in CX and DX).
        regs.x.bx=fpin->fd;             // Source file's handle.
        intdos(&regs, &regs);           // Int 21h.
        regs.h.ah=0x57;                 // DOS file-date/time service.
        regs.h.al=1;                    // "Set" (from CX and DX).
        regs.x.bx=fpout->fd;            // Destination file's handle.
        intdos(&regs, &regs);           // Int 21h.
        } // end if.

    if (fclose(fpin) != 0)
        {
        printf("Error closing %s\n", file_in);
        main_exit(1);
        } // end if.

    if (fclose(fpout) != 0)
        {
        printf("Error closing %s\n", file_out);
        main_exit(1);
        } // end if.

} // end copy1.
