#ifndef DIRECT_H_
#define DIRECT_H_

#include <dos.h>
#include <time.h>

#include "..\..\engine\header\rdwrsect.h"
#include "..\..\engine\header\fat.h"

struct DirectoryEntry
{
    char    filename[8];              /* file name.              */
    char    extension[3];             /* extension.              */
    char    attribute;                /* file attribute.         */
    char    reserved[10];             /* reserved.               */
    short   timestamp;                /* time last modified.     */
    short   datestamp;                /* date last modified.     */
    CLUSTER firstclust;               /* first cluster of file.  */
    long    filesize;                 /* file size.              */
};

struct DirectoryPosition
{
	SECTOR sector;
	int    offset;
};

struct LongFileNameEntry
{
       unsigned char NameIndex;
       unsigned      Part1[5];
       unsigned char Attributes;
       unsigned char reserved;
       unsigned char checksum;
       unsigned      Part2[6];
       CLUSTER       firstclust;
       unsigned      Part3[2];
};



#define LASTLABEL    0x00
#define CHARE5hLABEL 0x05
#define DOTLABEL     0x2E
#define DELETEDLABEL 0xE5

#define IsLastLabel(entry) ((entry).filename[0] == LASTLABEL)
#define IsDeletedLabel(entry) ((unsigned char) (entry).filename[0] == DELETEDLABEL)

#define IsCurrentDir(entry) (((entry).filename[0] == '.') && \
			     ((entry).filename[1] == ' '))

#define IsPreviousDir(entry) (((entry).filename[0] == '.') && \
			      ((entry).filename[1] == '.') && \
			      ((entry).filename[2] == ' '))

/*
   macro implementing int IsLFNEntry (DirectoryEntry* entry);
*/

#define IsLFNEntry(x) (((x)->attribute & FA_RDONLY) && \
		       ((x)->attribute & FA_HIDDEN) && \
		       ((x)->attribute & FA_SYSTEM) && \
		       ((x)->attribute & FA_LABEL))


int GetDirectoryStart(RDWRHandle handle);
int ReadDirEntry(RDWRHandle handle, int index,
		 struct DirectoryEntry* entry);
int WriteDirEntry(RDWRHandle handle, int index,
		  struct DirectoryEntry* entry);
int GetRootDirPosition(RDWRHandle handle, int index,
		       struct DirectoryPosition* pos);
int IsRootDirPosition(RDWRHandle handle, struct DirectoryPosition* pos);
void UnPackTimeDateStamp(struct tm* time, short timestamp, short datestamp);
void PackTimeDateStamp(struct tm* time, short* timestamp, short* datestamp);

#endif

