/*  Express HTML Help Graphical User Interface

    Copyright (c) Express Software 1998.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include "help.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define FsX 12
#define FsY 6
#define FsW 66
#define FsH 17

#define BmX 21
#define BmY 5
#define BmW 58
#define BmH 20

#define BoX 29
#define BoY 15
#define BoW 48
#define BoH 9
#define BoX2 (BoX+22)

#define SiX 40
#define SiY 18
#define SiW 32
#define SiH 6

#define FmX 4
#define FmY 14
#define FmW 74
#define FmH 5

#define BARX (FsX+FsW-3)
#define BARY (FsY+3)
#define BARLEN (n) // (n-2)

// F U N C T I O N S ////////////////////////////////////////////////////////

int write_int(int attr, int x, int y, int w, unsigned long xx)
{
    char tmp[30];
 
    sprintf(tmp,"%*ld",w,xx);
    write_string(attr,x,y,tmp);
    return 0;

} // end write_int.

/////////////////////////////////////////////////////////////////////////////

void cmd_error(char *msg)
{
    if (!quiet)
        fprintf(stderr,"\nError: %s\n", msg);

    exit(1);

} // end cmd_error.

/////////////////////////////////////////////////////////////////////////////

void get_base_dir(char *path)
{
    int i;
    char *p, *q;
 
    p=path+strlen(path)-1;
    while (p != path && *p != '\\' && *p != '/')
        p--;
 
    if (*p == '\\' || *p == '/')
        strncpy(base_dir,path,p-path+1);
    else
        base_dir[0]=0;

} // end get_base_dir.

/////////////////////////////////////////////////////////////////////////////

void parse_arg(char *str, char **argv, int argv_size)
{
    int i=0;
    char *p=str;
 
    while (1)
        {
        while (*p == ' ' || *p == '\t')
            p++;

        if (*p == 0)
            break;

        if (i >= argv_size-1)
            break;

        argv[i++]=p;
        while (*p != ' ' && *p != '\t' && *p != 0)
            p++;

        if (*p == 0)
            break;

        *p=0;
        p++;
        } // end while.

    argv[i]=0;

} // end pars_arg.

/////////////////////////////////////////////////////////////////////////////

void edit_str_field(struct event *ev, int ev_mask, int attr, int x, int y, int maxlen, char *str, int *pos)
{
    int i;
 
    while (1)
        {
        i=strlen(str);
        if(*pos > i)
           *pos=i;

        if (*pos == maxlen - 1)
            (*pos)--;

        clear_window(attr,x+i,y,maxlen-i-1,1);
        write_string(attr,x,y,str);
        move_cursor(x+*pos,y);

        get_event(ev,ev_mask|EV_KEY);
        if (!(ev->ev_type & EV_KEY))
            break;
     
        if (ev->scan==0x47E0 || ev->scan==0x4700)  // Home.
            {
            *pos=0;
            } // end if.
        else if (ev->scan==0x4FE0 || ev->scan==0x4F00) // End.
            {
            *pos=strlen(str);
            } // end else.
        else if (*pos>0 && (ev->scan==0x4BE0 || ev->scan==0x4B00)) // Left.
            {
            (*pos)--;
            } // end else.
        else if (*pos<strlen(str) && (ev->scan==0x4DE0 || ev->scan==0x4D00)) // Right.
            {
            (*pos)++;
            } // end else.
        else if (ev->key==8 && *pos>0)  // Backspace.
            {
            for (i=*pos;i<maxlen && str[i]!=0;i++)
                str[i-1]=str[i];

            str[i-1]=0;
            (*pos)--;
            } // end else.
        else if (ev->scan==0x5300 || ev->scan==0x53E0) // Del.
            {
            for (i=*pos;i<maxlen && str[i]!=0;i++)
                str[i]=str[i+1];

            str[i]=0;
            } // end else.
        else if (ev->key>=' ')
            {
            if (strlen(str)<maxlen-1)
               {
               for (i=maxlen-1;i>*pos;i--)
                   str[i]=str[i-1];

               str[i]=ev->key;
               (*pos)++;
               } // end if.

            } // end else.
        else
            break;

        } // end while.

} // end edit_str_field.

/////////////////////////////////////////////////////////////////////////////

void edit_int_field(struct event *ev, int ev_mask, int attr, int x, int y, int field_len, unsigned long *n, unsigned long limit)
{
    int i;
 
    while (1)
        {
        if(field_len>0)
            {
            sprintf(tmp,"%*lu",field_len,*n);
            move_cursor(x+field_len-1,y);
            } // end if.
        else
            {
            sprintf(tmp,"%-*lu",-field_len,*n);
            for (i=0;tmp[i]!=' ' && tmp[i]!=0;i++);
            move_cursor(x+i,y);
            } // end else.

        write_string(attr,x,y,tmp);
        get_event(ev,ev_mask|EV_KEY);
        if (!(ev->ev_type & EV_KEY))
            break;
     
        if (ev->key==8 || ev->scan==0x5300 || ev->scan==0x53E0) // Backspace || Del.
            {
            (*n)/=10;
            } // end if.
        else if (ev->key == '+')
            {
            if ((*n) < limit)
                (*n)++;

            } // end else.
        else if (ev->key=='-')
            {
            if ((*n) > 0)
                (*n)--;

            } // end else.
        else if (ev->key>='0' && ev->key<='9')
            {
            i=ev->key-'0';
            if (limit>=i && (*n)<=(limit-i)/10)
                (*n)=(*n)*10+i;

            } // end else.
        else
            break;

        } // end while.

} // end edit_int_field.

/////////////////////////////////////////////////////////////////////////////

int get_keys(unsigned short *keys, int num_keys)
{
    struct event ev;
    int i, x, y, w, h, q;
 
    x=1;
    w=80;
    y=23;
    h=3;

    save_window(x,y,w,h,buf);
    border_window(Yellow+BakWhite, x, y, w, h, Border22f);
    write_string(Yellow+BakWhite, x+53, y+h-1," Esc, BkSp, \\ - quote ");

    q=0;
    while (1)
        {
        clear_window(BrWhite+BakBlack, x+2, y+1, w-4, 1);
        for (i=0;i<num_keys;i++)
            {
            sprintf(tmp,"%04X",keys[i]);
            write_string(BrWhite+BakBlack,x+2+5*i,y+1,tmp);
            } // end for.

        move_cursor(x+2+5*i,y+1);
        get_event(&ev,EV_KEY);
        if (q == 0 && ev.key == 27)
            break;
        else if (q == 0 && ev.key == 8)
            {
            if (num_keys > 0)
                num_keys--;

            } // end else.
        else if (q == 0 && ev.key == '\\')
            {
            if (num_keys < 15)
                q=1;

            } // end else.
        else if (num_keys < 15)
            {
            keys[num_keys++]=ev.scan;
            q=0;
            } // end else.

        } // end while.
 
    for (i=num_keys;i<15;i++)
        keys[i]=0;
 
    load_window(x,y,w,h,buf);
    return num_keys;

} // end get_keys.

/////////////////////////////////////////////////////////////////////////////

int enter_string(int x, int y, char *prompt, int maxlen, char *str, char *help)
{
    struct event ev;
    int i, w, x2, w2;
 
    w2=73-x-strlen(prompt);
    if (w2 > maxlen)
        w2=maxlen;

    w=strlen(prompt)+5+w2;
    x2=x+strlen(prompt)+3;
    save_window(x,y,w,3,buf);
    border_window(Yellow+BakWhite,x,y,w,3, Border22f);
    write_string(Black+BakWhite,x+2,y+1,prompt);
 
    if (help != 0)
        write_string(Yellow+BakWhite, x+w-14, y+2, " F1 - Help ");

    i=0;
    str[0]=0;

    while (1)
        {
        edit_str_field(&ev, 0, BrWhite+BakBlack, x2, y+1, w2, str, &i);
     
        if (ev.key == 27)
            {
            i=0;
            break;
            } // end if.

        if (ev.key == 13)
            {
            i=1;
            break;
            } // end if.

        if (ev.scan==0x3B00 && help!=0) // F1 - Help.
            {
            html_view(help);
            } // end if.

        } // end while.

    load_window(x,y,w,3,buf);
    return i;

} // end enter_string.

/////////////////////////////////////////////////////////////////////////////

void show_error(char *msg)
{
    int x, y=12, w, h=4, pressed;
    struct event ev;
    static char buf[4*80*2];

    w = strlen(msg)+6;
    if (w%2 == 1)
        w++;

    if (w > 78)
        w=78;

    x = (80-w)/2+1;
 
    save_window(x,y,w,h,buf);
    border_window(Yellow+BakRed,x,y,w,h, Border22f);
    write_string(BrWhite+BakRed, x+3, y+1, msg);
    write_string(Black+BakWhite, x+w/2-2, y+2," OK ");
    pressed=0;
    while (1)
        {
        get_event(&ev, EV_KEY | EV_MOUSE);

        if ((ev.ev_type & EV_KEY) && (ev.key==27 || ev.key==13))
            break;

        if (ev.ev_type & EV_MOUSE)
            if (ev.x>=x+w/2-2 && ev.x<x+w/2+2 && ev.y==y+2)
                {
                if (ev.left==1)
                    pressed=1;

                if (ev.left==0 && pressed==1)
                    break;

                } // end if.
            else
                pressed=0;

        } // end while.

    load_window(x,y,w,h,buf);

} // end show_error.
