/* keydefpo.h */

/*
 * history
 * 26 apr 02: tom ehlert - creation
 */

#define LANGUAGE "portugese"
#define STATUS   "first try"

/********************************************************
 * PORTUGESE keyboard mappings				*
 ********************************************************/

/* keyboard image (by arkady)

Standard layout characters+scancodes:
ͻ
~29!02@03#04$05%06^07&08*09(0A)0B-0C=0DBacksp 0E
Ķ
Tab 0Fq10w11e12r13t14y15u16i17o18p19[1A]1B      
 < 
 Caps 3Aa1Es1Fd20f21g22h23j24k25l26;27'28Enter 1C
Ķ
 Shift 2A z2Cx2Dc2Ev2Fb30n31m32,33.34/35 Shift 36 
Ķ
 Ctrl 1D Alt 38\56    Spacebar 39    \2BAlt E38Ctrl E1D
ͼ
*/

/* copied mostly from norvegian,
   changed

	 5  4 $  .  . 
	12  ' ?  .  . .
	13     .  . .
	26  + *  .  . 
	27   `  .  . .
	39C    .  . .
	40     .  . .
	41  \ | #28 . .
	43  ~ ^ #28 . .
	83N . .  .  . !255
*/

uchar scancodetable[] = {

 /* 2 */ PUNCT_ALTGR	 (0x03, '2', '"',	 '@') /*  3 2 #34  .  . @ */
 /* 3 */ PUNCT_ALTGR	 (0x04, '3', '#',	0x9C) /*  4 3 #35  .  .  */
 /* 4 */ PUNCT_ALTGR	 (0x05, '4', '$',	0xF5) /*  5 4  $   .  .  */
 /* 5 */ PUNCT		 (0x06, '5', '%'	    ) /*  6 5  %   .  . . */
 /* 6 */ PUNCT_CTRL	 (0x07, '6', '&',0x1E	    ) /*  7 6  &  #30 . . */
 /* 7 */ PUNCT_ALTGR	 (0x08, '7', '/',	 '{') /*  8 7  /   .  . { */
 /* 8 */ PUNCT_CTRL_ALTGR(0x09, '8', '(',0x1B,	 '[') /*  9 8  (  #27 . [ */
 /* 9 */ PUNCT_CTRL_ALTGR(0x0A, '9', ')',0x1D,	 ']') /* 10 9  )  #29 . ] */
 /* 0 */ PUNCT_ALTGR	 (0x0B, '0', '=',	 '}') /* 11 0  =   .  . } */
 /* - */ PUNCT		 (0x0C,'\'', '?'	    ) /* 12 '  ?   .  . . */
 /* = */ PUNCT		 (0x0D,0xAE,0xAF	    ) /* 13      .  . . */

 /* [ */ PUNCT_ALTGR	 (0x1A,0x86,0x8F,	0xF9) /* 26  + *  .  .  */
 /* ] */ PUNCT		 (0x1B,0xEF, '`'	    ) /* 27   `  .  . . */
 /* ; */ ALPHA		 (0x27,0x87,0x80	    ) /* 39C    .  . . */
 /* ' */ PUNCT		 (0x28,0xA7,0xA6	    ) /* 40     .  . . */
 /* ~ */ PUNCT		 (0x29,'\\', '|'	    ) /* 41  \ | #28 . . */
 /* \ */ PUNCT		 (0x2B, '~', '^'	    ) /* 43  ~ ^ #28 . . */
 /* , */ PUNCT		 (0x33, ',', ';'	    ) /* 51  , ;  .  . . */
 /* . */ PUNCT		 (0x34, '.', ':'	    ) /* 52  . :  .  . . */
 /* / */ PUNCT		 (0x35, '-', '_'	    ) /* 53  - _ #31 . . */
 /*   */ PUNCT		 (0x56, '<', '>'	    ) /* 86  < >  .  . . */
	 0
};
