#include "dir16.h"
#include "fatio.h"	/* readfat */

/* if printdirents knows the DPB, it checks un-delete-ability */

void printdirents(Byte * buffer, struct DPB * dpb)
{
  int i,j,state;
  char x;
  Word fatchain;
  struct dirent * DE;

  j = 0;
  for (i=1;i<512;i++) {
    if (buffer[i] == buffer[i-1]) { j++; }
  }
  if (j>500) {
    printf("printdirents: empty sector\n");
    return;
  }

  for (i=0;i<512;i+=32) {
    if (buffer[i] != 0) {
      printf("\n");
      DE = (struct dirent *)(buffer+i);
      if (DE->f_name[0] == D_DELCHAR) {
        if (dpb != (struct DPB *) 0) {
          state = readfat(dpb->drive,DE->cluster,&fatchain,dpb);
          if ((state<0) || (fatchain!=0)) {
            printf("Del/Lost:  ");	/* first cluster reused */
          } else {
            printf("UnDelAble: ");	/* undelete possible */
          }
        } else {
          printf(  "Deleted:   ");	/* deleted, did not check */
        }
      } else {
        printf(    "           ");	/* normal file */
      }

      for (j=0;j<8;j++) {
        x = DE->f_name[j];
        if (x<32) { x = '?'; }
        if (x>126) { x = '?'; }
        printf("%c",x);
      }
      printf(".");
      for (j=0;j<3;j++) {
        x = DE->f_ext[j];
        if (x<32) { x = '?'; }
        if (x>126) { x = '?'; }
        printf("%c",x);
      }
      printf(" %2.2d:%2.2d:%2.2d",HofTime(DE->f_time),
        MofTime(DE->f_time), SofTime(DE->f_time));
      printf(" %2.2d.%2.2d.%d", DofDate(DE->f_date),
        MofDate(DE->f_date), YofDate(DE->f_date));
      printf(" @%5.5d, size %10.10ld",DE->cluster,DE->f_size);

      if ((DE->f_attrib & D_LONG) == D_LONG) {
        printf(" <LONG>");
      } else {
        if (DE->f_attrib & D_RO) { printf(" ro"); }
        if (DE->f_attrib & D_HIDE) { printf(" hide"); }
        if (DE->f_attrib & D_SYS) { printf(" sys"); }
        if (DE->f_attrib & D_VOL) { printf(" label"); }
      }
      if (DE->f_attrib & D_DIR) { printf(" dir"); }
      if (DE->f_attrib & D_ARCH) { printf(" a"); }
      if (DE->cluster_hi) {
        printf("\nWarning: ClusterHI=%x ", DE->cluster_hi);
      }
    } else {
      printf("<eof>");
    }
  }
  printf("\n");
}

