#include "fatio.h"
#include <stdio.h>	/* printf */

Byte fatbuf1[1024];
Byte fatbuf2[1024];
Dword lastfatbuf = 0xffffffff; /* number of sector in buffer */


int writefat(int drive, Word slot, Word value, struct DPB * dpb)
{
  printf("WRITE FAT NOT IMPLEMENTED !\n"); /* slot == 0 for flush */
  printf("Drive: %d, Slot: %u, Value: %u\n", drive, slot, value);
  printf("DPB at %p\n",dpb); /* PS: would use separate buffers */
  return -1;
}

int readfat(int drive, Word slot, Word * value, struct DPB * dpb)
{
  Word val1;
  Word val2;
  Dword offs;	/* intermediate values have 17 or 18 bits */
  Dword fatsector = dpb->numressec; /* skip reserved */
  value[0] = 0;
  
  if (dpb->maxclustnum > 0xff6) {  /* fat16 */
    offs = slot; offs <<= 1;
  } else { /* fat12 */
    offs = slot; offs = ((offs<<1)+offs) >> 1; /* 1.5by/slot! */
  }
  fatsector += offs>>9; /* assume 512 by per sector */
  offs &= 511; /* may be 511 for FAT12, sigh */

  if (fatsector != lastfatbuf)
  {
    if (readsector(drive, fatsector, fatbuf1)<0) { return -1; }
    if (readsector(drive, fatsector+1, fatbuf1+512)<0) { return -1; }
    if (dpb->fats > 1) {
      if (readsector(drive, fatsector + dpb->secperfat,
        fatbuf2)<0) { return -1; }
      if (readsector(drive, fatsector + dpb->secperfat + 1,
        fatbuf2+512)<0) { return -1; }
    }
    lastfatbuf = fatsector; /* buffer this */
  } /* else already in buffer */

  if (dpb->maxclustnum > 0xff6) { /* fat16 */
    val1 = fatbuf1[offs+1]; val1 <<= 8;
    val1 += fatbuf1[offs];
    val2 = fatbuf2[offs+1]; val2 <<= 8;
    val2 += fatbuf2[offs];
  } else { /* fat12 */
    if ((slot & 1) == 0) {
      val1 = fatbuf1[offs+1] & 15; val1 <<= 8;
      val1 += fatbuf1[offs];
      val2 = fatbuf2[offs+1] & 15; val2 <<= 8;
      val2 += fatbuf2[offs];
    } else {
      val1 = fatbuf1[offs+1]; val1 <<= 4;
      val1 |= fatbuf1[offs] >> 4;
      val2 = fatbuf2[offs+1]; val2 <<= 4;
      val2 |= fatbuf2[offs] >> 4;
    }
  }

  value[0] = val1;

  if (dpb->fats < 2) { val2 = val1; }
  if (val1 != val2) {
    printf("FAT inconsistency: #1 %u or #2 %u ???\n", val1, val2);
    printf("always using FAT1 in this case!\n");
    printf("Slot: %u  offset: %lu  sectors: %lu/%lu\n",
      slot, offs, fatsector, fatsector + dpb->secperfat);
  }

  return 0;
}

/* fat12 packs 3, 4, 5, 6 as bytes 3,40,0, 5,60,0, ... */

