class Q_EXPORT QFont					// font class
{
public:
    enum CharSet   {
	             ISO_8859_1,
		     Latin1,
		     AnyCharSet,
		     ISO_8859_2,
		     Latin2,
		     ISO_8859_3,
		     Latin3,
		     ISO_8859_4,
		     Latin4,
		     ISO_8859_5,
		     ISO_8859_6,
		     ISO_8859_7,
		     ISO_8859_8,
		     ISO_8859_9,
		     Latin5,
		     ISO_8859_10,
		     Latin6,
		     ISO_8859_11,
		     ISO_8859_12,
		     ISO_8859_13,
		     Latin7,
		     ISO_8859_14,
		     Latin8,
		     ISO_8859_15,
		     Latin9,
		     KOI8R,
		     Set_Ja,
		     Set_1,
		     Set_Ko,
		     Set_Th_TH,
		     Set_Zh,
		     Set_Zh_TW,
		     Set_N,
		     Unicode,
		     Set_GBK,
		     Set_Big5
		    };
    enum StyleHint {
	             Helvetica,
		     Times,
		     Courier,
		     OldEnglish,
		     System,
		     AnyStyle,
		     SansSerif,
		     Serif,
		     TypeWriter,
		     Decorative
                   };
    enum Weight	   {
	             Light,
		     Normal,
		     DemiBold,
		     Bold,
		     Black
                   };
    QFont();					// default font
    QFont( const QString &family, int pointSize = 12, int weight = QFont::Normal, bool italic = FALSE );
    QFont( const QString &family, int pointSize, int weight, bool italic, CharSet charSet );
    QFont( const QFont & );
    ~QFont();

    QString	family()	const prop(family);
    void	setFamily( const QString &) prop(family);
    int		pointSize()	const prop(pointSize);
    float	pointSizeFloat()	const prop(pointSizeFloat);
    void	setPointSize( int ) prop(pointSize);
    void	setPointSizeFloat( float ) prop(pointSizeFloat);
    int		pixelSize() const prop(pixelSize);
    void	setPixelSize( int ) prop(pixelSize);
    void	setPixelSizeFloat( float ) prop(pixelSizeFloat);
    Weight	weight()	const prop(weight);
    void	setWeight( Weight ) prop(weight);
    bool	bold()		const prop(bold);
    void	setBold( bool ) prop(bold);
    bool	italic()	const prop(italic);
    void	setItalic( bool ) prop(italic);
    bool	underline()	const prop(underline);
    void	setUnderline( bool ) prop(underline);
    bool	strikeOut()	const prop(strikeOut);
    void	setStrikeOut( bool ) prop(strikeOut);
    bool	fixedPitch()	const prop(fixedPitch);
    void	setFixedPitch( bool ) prop(fixedPitch);
    StyleHint	styleHint()	const prop(styleHint);
    void	setStyleHint( StyleHint ) prop(styleHint);
    CharSet	charSet()	const prop(charSet);
    void	setCharSet( CharSet ) prop(charSet);

    bool	rawMode()      const prop(rawMode);
    void	setRawMode( bool ) prop(rawMode);

    bool	exactMatch()	const;

    bool	operator==( const QFont & ) const;
    bool	operator!=( const QFont & ) const;
    bool	isCopyOf( const QFont & ) const;

    void	setRawName( const QString & ) prop(rawName);
    QString	rawName() const prop(rawName);

    QString	key() const prop(key);

    static QString encodingName( CharSet );

    static QFont defaultFont();
    static void setDefaultFont( const QFont & );

    static QString substitute( const QString &familyName );
    static void insertSubstitution( const QString&, const QString &);
    static void removeSubstitution( const QString &);
    static QStringList substitutions();
};
