//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QColor;
import org.kde.qt.QtSupport;
import java.util.ArrayList;

/**

 Class for handling Palettes.
 This class makes it easy to handle palettes.
 A palette is a set of colors. This class can read
 and write palettes from and to a file.
 This class uses the "GIMP" palette file format.
 This class is totally unrelated to QPalette.
		@author Waldo Bastian (bastian@kde.org)

		@version  kpalette.h,v 1.10 2003/08/16 19:44:57 coolo

		@short    Class for handling Palettes.

*/
public class KPalette implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KPalette(Class dummy){}

	/**	
		 Used to specify whether a palette may be edited.
				@short    Used to specify whether a palette may be edited.
		@see #editable
		@see #setEditable
	*/
	public static final int Yes = 0;
	public static final int No = 1;
	public static final int Ask = 2;

	/**	
		 KPalette constructor. Creates a KPalette from a file
		 the filename is derived from the name.
			@param name The name of palette as returned by getPaletteList()
				@short    KPalette constructor.
	*/
	public KPalette(String name) {
		newKPalette(name);
	}
	private native void newKPalette(String name);
	public KPalette() {
		newKPalette();
	}
	private native void newKPalette();
	/**	
		 KPalette copy constructor.
				@short    KPalette copy constructor.
	*/
	public KPalette(KPalette arg1) {
		newKPalette(arg1);
	}
	private native void newKPalette(KPalette arg1);
	/**	
		 Save the palette
				@return 'true' if successful

		@short    Save the palette
	*/
	public native boolean save();
	/**	
		 Get the description of the palette.
				@return the description of the palette.

		@short    Get the description of the palette.
	*/
	public native String description();
	/**	   	
		 Set the description of the palette.
			@param desc the new description
				@short     	  Set the description of the palette.
	*/
	public native void setDescription(String desc);
	/**	
		 Get the name of the palette. 
				@return the name of the palette

		@short    Get the name of the palette.
	*/
	public native String name();
	/**	
		 Set the name of the palette.
			@param name the name of the palette
				@short    Set the name of the palette.
	*/
	public native void setName(String name);
	/**	
		 Returns whether the palette may be edited.
				@return the state of the palette

		@short    Returns whether the palette may be edited.
	*/
	public native int editable();
	/**	
		 Change whether the palette may be edited.
			@param editable the state of the palette
				@short    Change whether the palette may be edited.
	*/
	public native void setEditable(int editable);
	/**	
		 Return the number of colors in the palette.
				@return the number of colors

		@short    Return the number of colors in the palette.
	*/
	public native int nrColors();
	/**	
		 Find color by index.
			@param index the index of the desired color
				@return The <code>index</code> -th color of the palette, null if not found.

		@short    Find color by index.
	*/
	public native QColor color(int index);
	/**	
		 Find index by <code>color.</code>
			@param color the color to find
				@return The index of the color in the palette or -1 if the
 color is not found.

		@short    Find index by <code>color.</code>
	*/
	public native int findColor(QColor color);
	/**	
		 Find color name by <code>index.</code>
			@param index the index of the color
				@return The name of the <code>index</code> -th color.
 Note that not all palettes have named the colors. Null is
 returned if the color does not exist or has no name.

		@short    Find color name by <code>index.</code>
	*/
	public native String colorName(int index);
	/**	
		 Find color name by <code>color.</code>
				@return The name of color according to this palette.
 Note that not all palettes have named the colors.
 Note also that each palette can give the same color
 a different name.

		@short    Find color name by <code>color.</code>
	*/
	public native String colorName(QColor color);
	/**	
		 Add a color.
			@param newColor The color to add.
			@param newColorName The name of the color, null to remove 
		                     the name.
				@return The index of the added color.

		@short    Add a color.
	*/
	public native int addColor(QColor newColor, String newColorName);
	public native int addColor(QColor newColor);
	/**	
		 Change a color.
			@param index Index of the color to change
			@param newColor The new color.
			@param newColorName The new color name, null to remove 
		                     the name.
				@return The index of the new color or -1 if the color couldn't
 be changed.

		@short    Change a color.
	*/
	public native int changeColor(int index, QColor newColor, String newColorName);
	public native int changeColor(int index, QColor newColor);
	/**	
		 Change a color.
			@param oldColor The original color
			@param newColor The new color.
			@param newColorName The new color name, null to remove 
		                     the name.
				@return The index of the new color or -1 if the color couldn't
 be changed.

		@short    Change a color.
	*/
	public native int changeColor(QColor oldColor, QColor newColor, String newColorName);
	public native int changeColor(QColor oldColor, QColor newColor);
	/**	
		 Query which KDE palettes are installed.
				@return A list with a palette names.
    
		@short    Query which KDE palettes are installed.
	*/
	public static native ArrayList getPaletteList();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
