/*  aKode: FrameDecoder parent-type

    Copyright (C) 2004 Allan Sandfeld Jensen <kde@carewolf.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef _AKODE_FRAMEDECODER_H
#define _AKODE_FRAMEDECODER_H

#include "decoder.h"

namespace aKode {

class AudioFrame;

//! A generic interface for frame-based decoders

/*!
 * FrameDecoder's are the first of the two decoder types in aKodeLib.
 * They work by decoding one audio-frame at a time. It is up to
 * the decoder itself to decide how large a frame is.
 */

class FrameDecoder : public Decoder
{
public:
    /*!
     * Reads one frame from the decoder.
     * It is advisable to reuse the the same frame for every readFrame()-call,
     * as the frame size is likely to be constant in the same file,
     * which saves re-allocations.
     *
     * If readFrame returns false, it can be one of three things:
     * 1. End-of-File (check eof()).
     * 2. Fatal error (check error()).
     * 3. Recoverable error (call readFrame again)
     */
    virtual bool readFrame(AudioFrame*) = 0;
};

} // namespace

#endif
