// cmodule.cpp
//
// Copyright (C) 2001 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include "cmodule.h"
#include "systray.h"

#include <kconfig.h>
#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qspinbox.h>

#include <noatun/app.h>
#include <noatun/pluginloader.h>


YHModule::YHModule(QObject *_parent)
	: CModule(i18n("System Tray Icon"), i18n("Configure System Tray Icon"),
		"bottom", _parent)
{
	QVBoxLayout *layout = new QVBoxLayout(this, 0, KDialog::spacingHint());

	tip = new QCheckBox(i18n("Show a tooltip for the current track"), this);
	passivePopup = new QCheckBox(i18n("Announce tracks with a popup window"), this);
	connect(passivePopup, SIGNAL(toggled(bool)), this, SLOT(slotPassivePopupChanged(bool)));

	QHBox *timeoutBox = new QHBox(this);
	timeoutBox->setSpacing(KDialog::spacingHint());
	new QLabel(i18n("Display popup window for"), timeoutBox);
	passivePopupTimeout = new QSpinBox(1, 60, 5, timeoutBox);
	passivePopupTimeout->setSuffix(i18n("Seconds", " s"));
	// fill remaining space
	timeoutBox->setStretchFactor(new QLabel(timeoutBox), 1);

	passivePopupCovers = new QCheckBox(i18n("Show covers in popup window"), this);
	passivePopupButtons = new QCheckBox(i18n("Show buttons in popup window"), this);

	icon = new QButtonGroup(1, Horizontal, i18n("State Icon Display"), this, "icon");
	icon->setExclusive(true);
	new QRadioButton(i18n("Blink"), icon);
	new QRadioButton(i18n("Show"), icon);
	new QRadioButton(i18n("None"), icon);

	layout->addWidget(tip);
	layout->addWidget(passivePopup);
        layout->addWidget(timeoutBox);
	layout->addWidget(passivePopupCovers);
        layout->addWidget(passivePopupButtons);
	layout->addWidget(icon);
	layout->addStretch();

	reopen();
	applySettings();
}


void YHModule::save()
{
	KConfig *c = KGlobal::config();
	c->setGroup("Young Hickory");
	int iconPressed = icon->id(icon->selected());
	c->writeEntry("icon", iconPressed);
	c->writeEntry("tip", tip->isChecked());
	c->writeEntry("passivePopup", passivePopup->isChecked());
	c->writeEntry("passivePopupTimeout", passivePopupTimeout->value());
	c->writeEntry("passivePopupCovers", passivePopupCovers->isChecked());
	c->writeEntry("passivePopupButtons", passivePopupButtons->isChecked());
	c->sync();

	applySettings();
}


void YHModule::reopen()
{
	KConfig *c = KGlobal::config();
	c->setGroup("Young Hickory");
	static_cast<QRadioButton *>(icon->find(c->readLongNumEntry("icon", 1)))->setChecked(true);
	tip->setChecked(c->readBoolEntry("tip", true));
	passivePopup->setChecked(c->readBoolEntry("passivePopup", true));
	passivePopupTimeout->setValue(c->readNumEntry("passivePopupTimeout", 5));
	passivePopupCovers->setChecked(c->readBoolEntry("passivePopupCovers", true));
	passivePopupButtons->setChecked(c->readBoolEntry("passivePopupButtons", true));
}


void YHModule::applySettings()
{
	NoatunSystray *yh = NoatunSystray::self;
	if(!yh)
		return;

	int iconPressed = icon->id(icon->selected());
	yh->setBlink((NoatunSystray::Blink)iconPressed);
	yh->setTip(tip->isChecked());
	yh->setPassivePopup(passivePopup->isChecked());
	yh->setPopupTimeout(passivePopupTimeout->value());
	yh->setShowCovers(passivePopupCovers->isChecked());
	yh->setShowButtons(passivePopupButtons->isChecked());
}


void YHModule::slotPassivePopupChanged(bool check)
{
	passivePopupTimeout->setEnabled(check);
	passivePopupCovers->setEnabled(check);
	passivePopupButtons->setEnabled(check);
}

#include "cmodule.moc"
