/*
* unixdrop.h -- Declaration of class KUnixDrop.
* Generated by newclass on Sun Nov 30 23:28:07 EST 1997.
*/
#ifndef SSK_UNIXDROP_H
#define SSK_UNIXDROP_H

class QDateTime;
class QFileInfo;
class QWidget;
class KDropDialog;

#include<qstring.h>

#include"polldrop.h"

/**
 * Implements Maildrop monitor for UNIX mailboxes.
 * @short Maildrop monitor for UNIX mailboxes.
 * @author Sirtaj Singh Kang (taj@kde.org)
 * @version $Id: unixdrop.h,v 1.3 2003/06/11 21:10:06 ravi Exp $
 */
class KUnixDrop : public KPollableDrop
{
private:
	bool touched();
	bool locked();
	int doCount();

	QDateTime	*_lastMod;
	QFileInfo	*_info;
	QFileInfo	*_lockInfo;
	unsigned	_lastSize;

	QString		_file;
	bool		_valid;
	char		*_buffer;
	int		_totalCount;

	char *lineBuffer();

public:
	static const char *FileConfigKey;

public:
	/**
	* KUnixDrop Constructor
	*/
	KUnixDrop();

	virtual ~KUnixDrop();

	virtual void recheck();

	virtual bool valid();
	virtual bool canReadSubjects() {return true;}

	/**
	* Read the Subjects. As the whole mbox file is scanned, the complete
	* message is stored in the returned KornMailSubject instances. Therefore
	* canReadMail() is useless and retunrs false (in KMailDrop).
	*/
	virtual QValueVector<KornMailSubject> * doReadSubjects(bool * stop);

	QString file() const { return _file; }
	void setFile(const QString & file);

	virtual QString type() const { return QString::fromUtf8("mbox"); }

	virtual KMailDrop *clone() const;

	virtual bool readConfigGroup ( const KConfigBase& cfg );
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;

	virtual void addConfigPage( KDropCfgDialog * );

private:
	KUnixDrop& operator=( const KUnixDrop& other );

};


#endif // SSK_UNIXDROP_H
