//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QImage;
import org.kde.qt.QWidget;

/**

 This is a base class for scanning dialogs. You can derive from this class
 and implement your own dialog. An implementation is available in
 kdegraphics/libkscan.
 Application developers that wish to add scanning support to their program
 can use the static method <code>KScanDialog</code>.getScanDialog() to get an instance
 of the user's preferred scanning dialog.
 Typical usage looks like this (e.g. in a slotShowScanDialog() method):
 <pre>
 if ( !m_scanDialog ) {
     m_scanDialog = KScanDialog.getScanDialog( this, "scandialog" );
     if ( !m_scanDialog ) // no scanning support installed?
         return;
     connect( m_scanDialog, SIGNAL("finalImage( QImage, int )"),
              SLOT("slotScanned( QImage, int )"));
 }
 if ( m_scanDialog.setup() ) // only if scanner configured/available
     m_scanDialog.show();
 </pre>
 This will create and show a non-modal scanning dialog. Connect to more
 signals if you like.
 If you implement an own scan-dialog, you also have to implement a
 KScanDialogFactory.
 See {@link KScanDialogSignals} for signals emitted by KScanDialog
		@author Carsten Pfeiffer <pfeiffer@kde.org>
 
		@short A baseclass and accessor for Scanning Dialogs.

*/
public class KScanDialog extends KDialogBase  {
	protected KScanDialog(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Reimplement this if you need to set up some things, before showing the
		 dialog, e.g. to ask the user for the scanner device to use. If you
		 return false (e.g. there is no device available or the user aborted
		 device selection), the dialog will not be shown.
				@return true by default.
     
		@short    Reimplement this if you need to set up some things, before showing the  dialog, e.
	*/
	public native boolean setup();
	/**	
		 Creates the user's preferred scanning dialog and returns it,
		 or null if no scan-support
		 is available. Pass a suitable <code>parent</code> widget, if you like. If you
		 don't you have to 'delete' the returned pointer yourself.
			@param parent the QWidget's parent, or 0
			@param name the name of the QObject, can be 0
			@param modal if true the dialog is model
				@return the KScanDialog, or 0 if the function failed
     
		@short    Creates the user's preferred scanning dialog and returns it,  or 0L if no scan-support  is available.
	*/
	public static native KScanDialog getScanDialog(QWidget parent, String name, boolean modal);
	public static native KScanDialog getScanDialog(QWidget parent, String name);
	public static native KScanDialog getScanDialog(QWidget parent);
	public static native KScanDialog getScanDialog();
	/**	
		 Constructs the scan dialog. If you implement an own dialog, you can
		 customize it with the usual KDialogBase flags.
			@param dialogFace the KDialogBase.DialogType
			@param buttonMask a ORed mask of all buttons (see
		 KDialogBase.ButtonCode)
			@param parent the QWidget's parent, or 0
			@param name the name of the QObject, can be 0
			@param modal if true the dialog is model
				@short    Constructs the scan dialog.
		@see KDialogBase
	*/
	public KScanDialog(int dialogFace, int buttonMask, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKScanDialog(dialogFace,buttonMask,parent,name,modal);
	}
	private native void newKScanDialog(int dialogFace, int buttonMask, QWidget parent, String name, boolean modal);
	public KScanDialog(int dialogFace, int buttonMask, QWidget parent, String name) {
		super((Class) null);
		newKScanDialog(dialogFace,buttonMask,parent,name);
	}
	private native void newKScanDialog(int dialogFace, int buttonMask, QWidget parent, String name);
	public KScanDialog(int dialogFace, int buttonMask, QWidget parent) {
		super((Class) null);
		newKScanDialog(dialogFace,buttonMask,parent);
	}
	private native void newKScanDialog(int dialogFace, int buttonMask, QWidget parent);
	public KScanDialog(int dialogFace, int buttonMask) {
		super((Class) null);
		newKScanDialog(dialogFace,buttonMask);
	}
	private native void newKScanDialog(int dialogFace, int buttonMask);
	public KScanDialog(int dialogFace) {
		super((Class) null);
		newKScanDialog(dialogFace);
	}
	private native void newKScanDialog(int dialogFace);
	public KScanDialog() {
		super((Class) null);
		newKScanDialog();
	}
	private native void newKScanDialog();
	/**	
		 Returns the current id for an image. You can use that in your subclass
		 for the signals. The id is used in the signals to let people know
		 which preview and which text-recognition belongs to which scan.
				@return the current id for the image

		@short    Returns the current id for an image.
		@see #nextId
		@see #finalImage
		@see #preview
		@see #textRecognized
	*/
	protected native int id();
	/**	
		 Returns the id for the next image. You can use that in your subclass
		 for the signals.
			     		@return the id for the next image

		@short    Returns the id for the next image.
		@see #id
		@see #finalImage
		@see #preview
		@see #textRecognized
	*/
	protected native int nextId();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
