# This is part of the dragdrop example.


from qt import *


def canDecode(e):
    return e.provides( "secret/magic" )


def decode(e): 
    payload = str(e.data( "secret/magic" ))
    if ( str(payload) != '' ):
        e.accept()
        return QString("The secret number is "+str(ord(payload)) )

    return None


class SecretDrag(QStoredDrag):
    def __init__(self, secret, parent=None, name=None):
        QStoredDrag.__init__(self, 'secret/magic', parent, name)
        data = QByteArray(chr(secret))
        self.setEncodedData( data )

        
# XPM 
picture_xpm = [
    "16 16 3 1",
    " 	c None",
    ".	c #000000",
    "X	c #FFFF00",
    "     .....      ",
    "   ..XXXXX..    ",
    "  .XXXXXXXXX.   ",
    " .XXXXXXXXXXX.  ",
    " .XX..XXX..XX.  ",
    ".XXXXXXXXXXXXX. ",
    ".XX...XXX...XX. ",
    ".XXX..XXX..XXX. ",
    ".XXXXXXXXXXXXX. ",
    ".XXXXXX.XXXXXX. ",
    " .XX.XX.XX.XX.  ",
    " .XXX..X..XXX.  ",
    "  .XXXXXXXXX.   ",
    "   ..XXXXX..    ",
    "     .....      ",
    "                "
]


class SecretSource(QLabel):
    def __init__(self, secret, parent=None, name=None):
        QLabel.__init__(self, "Secret", parent, name)
        self.setEraseColor( Qt.blue.light() )
        self.setFrameStyle( QLabel.Box | QLabel.Sunken )
        self.setMinimumHeight( self.sizeHint().height()*2 )
        self.setAlignment( QLabel.AlignCenter )
        self.mySecret = secret

    def mousePressEvent(self, e): 
        sd = SecretDrag( self.mySecret, self )
        sd.setPixmap(QPixmap(picture_xpm),QPoint(8,8))
        sd.dragCopy()
        self.mySecret = self.mySecret + 1
