/*
 *  Unix SMB/CIFS implementation.
 *  RPC Pipe client / server routines
 *
 *  Copyright (C) Luke Kenneth Casson Leighton 1997-2001.
 *  Copyright (C) Andrew Bartlett
 *  Copyright (C) Andrew Tridgell
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

/* NT error codes.  please read nterr.h */

#include "includes.h"
#include "../libcli/ldap/ldap_errors.h"
#undef strcasecmp

#if !defined(N_)
#define N_(string) string
#endif

#define DOS_CODE(class, code) { #class ":" #code, NT_STATUS_DOS(class, code) }
#define LDAP_CODE(code) { #code, NT_STATUS_LDAP(code) }

typedef struct
{
	const char *nt_errstr;
	NTSTATUS nt_errcode;
} nt_err_code_struct;

const nt_err_code_struct nt_errs[] =
{
	{ "NT_STATUS_OK", NT_STATUS_OK },
	{ "STATUS_NO_MORE_FILES", STATUS_NO_MORE_FILES },
	{ "STATUS_STOPPED_ON_SYMLINK", STATUS_STOPPED_ON_SYMLINK },
	{ "STATUS_NO_MORE_EAS", STATUS_NO_MORE_EAS },
	{ "STATUS_INVALID_EA_NAME", STATUS_INVALID_EA_NAME },
	{ "STATUS_EA_LIST_INCONSISTENT", STATUS_EA_LIST_INCONSISTENT },
	{ "STATUS_INVALID_EA_FLAG", STATUS_INVALID_EA_FLAG },
	{ "NT_STATUS_UNSUCCESSFUL", NT_STATUS_UNSUCCESSFUL },
	{ "NT_STATUS_NOT_IMPLEMENTED", NT_STATUS_NOT_IMPLEMENTED },
	{ "NT_STATUS_INVALID_INFO_CLASS", NT_STATUS_INVALID_INFO_CLASS },
	{ "NT_STATUS_INFO_LENGTH_MISMATCH", NT_STATUS_INFO_LENGTH_MISMATCH },
	{ "NT_STATUS_ACCESS_VIOLATION", NT_STATUS_ACCESS_VIOLATION },
	{ "STATUS_BUFFER_OVERFLOW", STATUS_BUFFER_OVERFLOW },
	{ "NT_STATUS_IN_PAGE_ERROR", NT_STATUS_IN_PAGE_ERROR },
	{ "NT_STATUS_PAGEFILE_QUOTA", NT_STATUS_PAGEFILE_QUOTA },
	{ "NT_STATUS_INVALID_HANDLE", NT_STATUS_INVALID_HANDLE },
	{ "NT_STATUS_BAD_INITIAL_STACK", NT_STATUS_BAD_INITIAL_STACK },
	{ "NT_STATUS_BAD_INITIAL_PC", NT_STATUS_BAD_INITIAL_PC },
	{ "NT_STATUS_INVALID_CID", NT_STATUS_INVALID_CID },
	{ "NT_STATUS_TIMER_NOT_CANCELED", NT_STATUS_TIMER_NOT_CANCELED },
	{ "NT_STATUS_INVALID_PARAMETER", NT_STATUS_INVALID_PARAMETER },
	{ "NT_STATUS_NO_SUCH_DEVICE", NT_STATUS_NO_SUCH_DEVICE },
	{ "NT_STATUS_NO_SUCH_FILE", NT_STATUS_NO_SUCH_FILE },
	{ "NT_STATUS_INVALID_DEVICE_REQUEST", NT_STATUS_INVALID_DEVICE_REQUEST },
	{ "NT_STATUS_END_OF_FILE", NT_STATUS_END_OF_FILE },
	{ "NT_STATUS_WRONG_VOLUME", NT_STATUS_WRONG_VOLUME },
	{ "NT_STATUS_NO_MEDIA_IN_DEVICE", NT_STATUS_NO_MEDIA_IN_DEVICE },
	{ "NT_STATUS_UNRECOGNIZED_MEDIA", NT_STATUS_UNRECOGNIZED_MEDIA },
	{ "NT_STATUS_NONEXISTENT_SECTOR", NT_STATUS_NONEXISTENT_SECTOR },
	{ "NT_STATUS_MORE_PROCESSING_REQUIRED", NT_STATUS_MORE_PROCESSING_REQUIRED },
	{ "NT_STATUS_NO_MEMORY", NT_STATUS_NO_MEMORY },
	{ "NT_STATUS_CONFLICTING_ADDRESSES", NT_STATUS_CONFLICTING_ADDRESSES },
	{ "NT_STATUS_NOT_MAPPED_VIEW", NT_STATUS_NOT_MAPPED_VIEW },
	{ "NT_STATUS_UNABLE_TO_FREE_VM", NT_STATUS_UNABLE_TO_FREE_VM },
	{ "NT_STATUS_UNABLE_TO_DELETE_SECTION", NT_STATUS_UNABLE_TO_DELETE_SECTION },
	{ "NT_STATUS_INVALID_SYSTEM_SERVICE", NT_STATUS_INVALID_SYSTEM_SERVICE },
	{ "NT_STATUS_ILLEGAL_INSTRUCTION", NT_STATUS_ILLEGAL_INSTRUCTION },
	{ "NT_STATUS_INVALID_LOCK_SEQUENCE", NT_STATUS_INVALID_LOCK_SEQUENCE },
	{ "NT_STATUS_INVALID_VIEW_SIZE", NT_STATUS_INVALID_VIEW_SIZE },
	{ "NT_STATUS_INVALID_FILE_FOR_SECTION", NT_STATUS_INVALID_FILE_FOR_SECTION },
	{ "NT_STATUS_ALREADY_COMMITTED", NT_STATUS_ALREADY_COMMITTED },
	{ "NT_STATUS_ACCESS_DENIED", NT_STATUS_ACCESS_DENIED },
	{ "NT_STATUS_BUFFER_TOO_SMALL", NT_STATUS_BUFFER_TOO_SMALL },
	{ "NT_STATUS_OBJECT_TYPE_MISMATCH", NT_STATUS_OBJECT_TYPE_MISMATCH },
	{ "NT_STATUS_NONCONTINUABLE_EXCEPTION", NT_STATUS_NONCONTINUABLE_EXCEPTION },
	{ "NT_STATUS_INVALID_DISPOSITION", NT_STATUS_INVALID_DISPOSITION },
	{ "NT_STATUS_UNWIND", NT_STATUS_UNWIND },
	{ "NT_STATUS_BAD_STACK", NT_STATUS_BAD_STACK },
	{ "NT_STATUS_INVALID_UNWIND_TARGET", NT_STATUS_INVALID_UNWIND_TARGET },
	{ "NT_STATUS_NOT_LOCKED", NT_STATUS_NOT_LOCKED },
	{ "NT_STATUS_PARITY_ERROR", NT_STATUS_PARITY_ERROR },
	{ "NT_STATUS_UNABLE_TO_DECOMMIT_VM", NT_STATUS_UNABLE_TO_DECOMMIT_VM },
	{ "NT_STATUS_NOT_COMMITTED", NT_STATUS_NOT_COMMITTED },
	{ "NT_STATUS_INVALID_PORT_ATTRIBUTES", NT_STATUS_INVALID_PORT_ATTRIBUTES },
	{ "NT_STATUS_PORT_MESSAGE_TOO_LONG", NT_STATUS_PORT_MESSAGE_TOO_LONG },
	{ "NT_STATUS_INVALID_PARAMETER_MIX", NT_STATUS_INVALID_PARAMETER_MIX },
	{ "NT_STATUS_INVALID_QUOTA_LOWER", NT_STATUS_INVALID_QUOTA_LOWER },
	{ "NT_STATUS_DISK_CORRUPT_ERROR", NT_STATUS_DISK_CORRUPT_ERROR },
	{ "NT_STATUS_OBJECT_NAME_INVALID", NT_STATUS_OBJECT_NAME_INVALID },
	{ "NT_STATUS_OBJECT_NAME_NOT_FOUND", NT_STATUS_OBJECT_NAME_NOT_FOUND },
	{ "NT_STATUS_OBJECT_NAME_COLLISION", NT_STATUS_OBJECT_NAME_COLLISION },
	{ "NT_STATUS_HANDLE_NOT_WAITABLE", NT_STATUS_HANDLE_NOT_WAITABLE },
	{ "NT_STATUS_PORT_DISCONNECTED", NT_STATUS_PORT_DISCONNECTED },
	{ "NT_STATUS_DEVICE_ALREADY_ATTACHED", NT_STATUS_DEVICE_ALREADY_ATTACHED },
	{ "NT_STATUS_OBJECT_PATH_INVALID", NT_STATUS_OBJECT_PATH_INVALID },
	{ "NT_STATUS_OBJECT_PATH_NOT_FOUND", NT_STATUS_OBJECT_PATH_NOT_FOUND },
	{ "NT_STATUS_OBJECT_PATH_SYNTAX_BAD", NT_STATUS_OBJECT_PATH_SYNTAX_BAD },
	{ "NT_STATUS_DATA_OVERRUN", NT_STATUS_DATA_OVERRUN },
	{ "NT_STATUS_DATA_LATE_ERROR", NT_STATUS_DATA_LATE_ERROR },
	{ "NT_STATUS_DATA_ERROR", NT_STATUS_DATA_ERROR },
	{ "NT_STATUS_CRC_ERROR", NT_STATUS_CRC_ERROR },
	{ "NT_STATUS_SECTION_TOO_BIG", NT_STATUS_SECTION_TOO_BIG },
	{ "NT_STATUS_PORT_CONNECTION_REFUSED", NT_STATUS_PORT_CONNECTION_REFUSED },
	{ "NT_STATUS_INVALID_PORT_HANDLE", NT_STATUS_INVALID_PORT_HANDLE },
	{ "NT_STATUS_SHARING_VIOLATION", NT_STATUS_SHARING_VIOLATION },
	{ "NT_STATUS_QUOTA_EXCEEDED", NT_STATUS_QUOTA_EXCEEDED },
	{ "NT_STATUS_INVALID_PAGE_PROTECTION", NT_STATUS_INVALID_PAGE_PROTECTION },
	{ "NT_STATUS_MUTANT_NOT_OWNED", NT_STATUS_MUTANT_NOT_OWNED },
	{ "NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED", NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED },
	{ "NT_STATUS_PORT_ALREADY_SET", NT_STATUS_PORT_ALREADY_SET },
	{ "NT_STATUS_SECTION_NOT_IMAGE", NT_STATUS_SECTION_NOT_IMAGE },
	{ "NT_STATUS_SUSPEND_COUNT_EXCEEDED", NT_STATUS_SUSPEND_COUNT_EXCEEDED },
	{ "NT_STATUS_THREAD_IS_TERMINATING", NT_STATUS_THREAD_IS_TERMINATING },
	{ "NT_STATUS_BAD_WORKING_SET_LIMIT", NT_STATUS_BAD_WORKING_SET_LIMIT },
	{ "NT_STATUS_INCOMPATIBLE_FILE_MAP", NT_STATUS_INCOMPATIBLE_FILE_MAP },
	{ "NT_STATUS_SECTION_PROTECTION", NT_STATUS_SECTION_PROTECTION },
	{ "NT_STATUS_EAS_NOT_SUPPORTED", NT_STATUS_EAS_NOT_SUPPORTED },
	{ "NT_STATUS_EA_TOO_LARGE", NT_STATUS_EA_TOO_LARGE },
	{ "NT_STATUS_NONEXISTENT_EA_ENTRY", NT_STATUS_NONEXISTENT_EA_ENTRY },
	{ "NT_STATUS_NO_EAS_ON_FILE", NT_STATUS_NO_EAS_ON_FILE },
	{ "NT_STATUS_EA_CORRUPT_ERROR", NT_STATUS_EA_CORRUPT_ERROR },
	{ "NT_STATUS_FILE_LOCK_CONFLICT", NT_STATUS_FILE_LOCK_CONFLICT },
	{ "NT_STATUS_LOCK_NOT_GRANTED", NT_STATUS_LOCK_NOT_GRANTED },
	{ "NT_STATUS_DELETE_PENDING", NT_STATUS_DELETE_PENDING },
	{ "NT_STATUS_CTL_FILE_NOT_SUPPORTED", NT_STATUS_CTL_FILE_NOT_SUPPORTED },
	{ "NT_STATUS_UNKNOWN_REVISION", NT_STATUS_UNKNOWN_REVISION },
	{ "NT_STATUS_REVISION_MISMATCH", NT_STATUS_REVISION_MISMATCH },
	{ "NT_STATUS_INVALID_OWNER", NT_STATUS_INVALID_OWNER },
	{ "NT_STATUS_INVALID_PRIMARY_GROUP", NT_STATUS_INVALID_PRIMARY_GROUP },
	{ "NT_STATUS_NO_IMPERSONATION_TOKEN", NT_STATUS_NO_IMPERSONATION_TOKEN },
	{ "NT_STATUS_CANT_DISABLE_MANDATORY", NT_STATUS_CANT_DISABLE_MANDATORY },
	{ "NT_STATUS_NO_LOGON_SERVERS", NT_STATUS_NO_LOGON_SERVERS },
	{ "NT_STATUS_NO_SUCH_LOGON_SESSION", NT_STATUS_NO_SUCH_LOGON_SESSION },
	{ "NT_STATUS_NO_SUCH_PRIVILEGE", NT_STATUS_NO_SUCH_PRIVILEGE },
	{ "NT_STATUS_PRIVILEGE_NOT_HELD", NT_STATUS_PRIVILEGE_NOT_HELD },
	{ "NT_STATUS_INVALID_ACCOUNT_NAME", NT_STATUS_INVALID_ACCOUNT_NAME },
	{ "NT_STATUS_USER_EXISTS", NT_STATUS_USER_EXISTS },
	{ "NT_STATUS_NO_SUCH_USER", NT_STATUS_NO_SUCH_USER },
	{ "NT_STATUS_GROUP_EXISTS", NT_STATUS_GROUP_EXISTS },
	{ "NT_STATUS_NO_SUCH_GROUP", NT_STATUS_NO_SUCH_GROUP },
	{ "NT_STATUS_MEMBER_IN_GROUP", NT_STATUS_MEMBER_IN_GROUP },
	{ "NT_STATUS_MEMBER_NOT_IN_GROUP", NT_STATUS_MEMBER_NOT_IN_GROUP },
	{ "NT_STATUS_LAST_ADMIN", NT_STATUS_LAST_ADMIN },
	{ "NT_STATUS_WRONG_PASSWORD", NT_STATUS_WRONG_PASSWORD },
	{ "NT_STATUS_ILL_FORMED_PASSWORD", NT_STATUS_ILL_FORMED_PASSWORD },
	{ "NT_STATUS_PASSWORD_RESTRICTION", NT_STATUS_PASSWORD_RESTRICTION },
	{ "NT_STATUS_LOGON_FAILURE", NT_STATUS_LOGON_FAILURE },
	{ "NT_STATUS_ACCOUNT_RESTRICTION", NT_STATUS_ACCOUNT_RESTRICTION },
	{ "NT_STATUS_INVALID_LOGON_HOURS", NT_STATUS_INVALID_LOGON_HOURS },
	{ "NT_STATUS_INVALID_WORKSTATION", NT_STATUS_INVALID_WORKSTATION },
	{ "NT_STATUS_PASSWORD_EXPIRED", NT_STATUS_PASSWORD_EXPIRED },
	{ "NT_STATUS_ACCOUNT_DISABLED", NT_STATUS_ACCOUNT_DISABLED },
	{ "NT_STATUS_NONE_MAPPED", NT_STATUS_NONE_MAPPED },
	{ "NT_STATUS_TOO_MANY_LUIDS_REQUESTED", NT_STATUS_TOO_MANY_LUIDS_REQUESTED },
	{ "NT_STATUS_LUIDS_EXHAUSTED", NT_STATUS_LUIDS_EXHAUSTED },
	{ "NT_STATUS_INVALID_SUB_AUTHORITY", NT_STATUS_INVALID_SUB_AUTHORITY },
	{ "NT_STATUS_INVALID_ACL", NT_STATUS_INVALID_ACL },
	{ "NT_STATUS_INVALID_SID", NT_STATUS_INVALID_SID },
	{ "NT_STATUS_INVALID_SECURITY_DESCR", NT_STATUS_INVALID_SECURITY_DESCR },
	{ "NT_STATUS_PROCEDURE_NOT_FOUND", NT_STATUS_PROCEDURE_NOT_FOUND },
	{ "NT_STATUS_INVALID_IMAGE_FORMAT", NT_STATUS_INVALID_IMAGE_FORMAT },
	{ "NT_STATUS_NO_TOKEN", NT_STATUS_NO_TOKEN },
	{ "NT_STATUS_BAD_INHERITANCE_ACL", NT_STATUS_BAD_INHERITANCE_ACL },
	{ "NT_STATUS_RANGE_NOT_LOCKED", NT_STATUS_RANGE_NOT_LOCKED },
	{ "NT_STATUS_DISK_FULL", NT_STATUS_DISK_FULL },
	{ "NT_STATUS_SERVER_DISABLED", NT_STATUS_SERVER_DISABLED },
	{ "NT_STATUS_SERVER_NOT_DISABLED", NT_STATUS_SERVER_NOT_DISABLED },
	{ "NT_STATUS_TOO_MANY_GUIDS_REQUESTED", NT_STATUS_TOO_MANY_GUIDS_REQUESTED },
	{ "NT_STATUS_GUIDS_EXHAUSTED", NT_STATUS_GUIDS_EXHAUSTED },
	{ "NT_STATUS_INVALID_ID_AUTHORITY", NT_STATUS_INVALID_ID_AUTHORITY },
	{ "NT_STATUS_AGENTS_EXHAUSTED", NT_STATUS_AGENTS_EXHAUSTED },
	{ "NT_STATUS_INVALID_VOLUME_LABEL", NT_STATUS_INVALID_VOLUME_LABEL },
	{ "NT_STATUS_SECTION_NOT_EXTENDED", NT_STATUS_SECTION_NOT_EXTENDED },
	{ "NT_STATUS_NOT_MAPPED_DATA", NT_STATUS_NOT_MAPPED_DATA },
	{ "NT_STATUS_RESOURCE_DATA_NOT_FOUND", NT_STATUS_RESOURCE_DATA_NOT_FOUND },
	{ "NT_STATUS_RESOURCE_TYPE_NOT_FOUND", NT_STATUS_RESOURCE_TYPE_NOT_FOUND },
	{ "NT_STATUS_RESOURCE_NAME_NOT_FOUND", NT_STATUS_RESOURCE_NAME_NOT_FOUND },
	{ "NT_STATUS_ARRAY_BOUNDS_EXCEEDED", NT_STATUS_ARRAY_BOUNDS_EXCEEDED },
	{ "NT_STATUS_FLOAT_DENORMAL_OPERAND", NT_STATUS_FLOAT_DENORMAL_OPERAND },
	{ "NT_STATUS_FLOAT_DIVIDE_BY_ZERO", NT_STATUS_FLOAT_DIVIDE_BY_ZERO },
	{ "NT_STATUS_FLOAT_INEXACT_RESULT", NT_STATUS_FLOAT_INEXACT_RESULT },
	{ "NT_STATUS_FLOAT_INVALID_OPERATION", NT_STATUS_FLOAT_INVALID_OPERATION },
	{ "NT_STATUS_FLOAT_OVERFLOW", NT_STATUS_FLOAT_OVERFLOW },
	{ "NT_STATUS_FLOAT_STACK_CHECK", NT_STATUS_FLOAT_STACK_CHECK },
	{ "NT_STATUS_FLOAT_UNDERFLOW", NT_STATUS_FLOAT_UNDERFLOW },
	{ "NT_STATUS_INTEGER_DIVIDE_BY_ZERO", NT_STATUS_INTEGER_DIVIDE_BY_ZERO },
	{ "NT_STATUS_INTEGER_OVERFLOW", NT_STATUS_INTEGER_OVERFLOW },
	{ "NT_STATUS_PRIVILEGED_INSTRUCTION", NT_STATUS_PRIVILEGED_INSTRUCTION },
	{ "NT_STATUS_TOO_MANY_PAGING_FILES", NT_STATUS_TOO_MANY_PAGING_FILES },
	{ "NT_STATUS_FILE_INVALID", NT_STATUS_FILE_INVALID },
	{ "NT_STATUS_ALLOTTED_SPACE_EXCEEDED", NT_STATUS_ALLOTTED_SPACE_EXCEEDED },
	{ "NT_STATUS_INSUFFICIENT_RESOURCES", NT_STATUS_INSUFFICIENT_RESOURCES },
	{ "NT_STATUS_DFS_EXIT_PATH_FOUND", NT_STATUS_DFS_EXIT_PATH_FOUND },
	{ "NT_STATUS_DEVICE_DATA_ERROR", NT_STATUS_DEVICE_DATA_ERROR },
	{ "NT_STATUS_DEVICE_NOT_CONNECTED", NT_STATUS_DEVICE_NOT_CONNECTED },
	{ "NT_STATUS_DEVICE_POWER_FAILURE", NT_STATUS_DEVICE_POWER_FAILURE },
	{ "NT_STATUS_FREE_VM_NOT_AT_BASE", NT_STATUS_FREE_VM_NOT_AT_BASE },
	{ "NT_STATUS_MEMORY_NOT_ALLOCATED", NT_STATUS_MEMORY_NOT_ALLOCATED },
	{ "NT_STATUS_WORKING_SET_QUOTA", NT_STATUS_WORKING_SET_QUOTA },
	{ "NT_STATUS_MEDIA_WRITE_PROTECTED", NT_STATUS_MEDIA_WRITE_PROTECTED },
	{ "NT_STATUS_DEVICE_NOT_READY", NT_STATUS_DEVICE_NOT_READY },
	{ "NT_STATUS_INVALID_GROUP_ATTRIBUTES", NT_STATUS_INVALID_GROUP_ATTRIBUTES },
	{ "NT_STATUS_BAD_IMPERSONATION_LEVEL", NT_STATUS_BAD_IMPERSONATION_LEVEL },
	{ "NT_STATUS_CANT_OPEN_ANONYMOUS", NT_STATUS_CANT_OPEN_ANONYMOUS },
	{ "NT_STATUS_BAD_VALIDATION_CLASS", NT_STATUS_BAD_VALIDATION_CLASS },
	{ "NT_STATUS_BAD_TOKEN_TYPE", NT_STATUS_BAD_TOKEN_TYPE },
	{ "NT_STATUS_BAD_MASTER_BOOT_RECORD", NT_STATUS_BAD_MASTER_BOOT_RECORD },
	{ "NT_STATUS_INSTRUCTION_MISALIGNMENT", NT_STATUS_INSTRUCTION_MISALIGNMENT },
	{ "NT_STATUS_INSTANCE_NOT_AVAILABLE", NT_STATUS_INSTANCE_NOT_AVAILABLE },
	{ "NT_STATUS_PIPE_NOT_AVAILABLE", NT_STATUS_PIPE_NOT_AVAILABLE },
	{ "NT_STATUS_INVALID_PIPE_STATE", NT_STATUS_INVALID_PIPE_STATE },
	{ "NT_STATUS_PIPE_BUSY", NT_STATUS_PIPE_BUSY },
	{ "NT_STATUS_ILLEGAL_FUNCTION", NT_STATUS_ILLEGAL_FUNCTION },
	{ "NT_STATUS_PIPE_DISCONNECTED", NT_STATUS_PIPE_DISCONNECTED },
	{ "NT_STATUS_PIPE_CLOSING", NT_STATUS_PIPE_CLOSING },
	{ "NT_STATUS_PIPE_CONNECTED", NT_STATUS_PIPE_CONNECTED },
	{ "NT_STATUS_PIPE_LISTENING", NT_STATUS_PIPE_LISTENING },
	{ "NT_STATUS_INVALID_READ_MODE", NT_STATUS_INVALID_READ_MODE },
	{ "NT_STATUS_IO_TIMEOUT", NT_STATUS_IO_TIMEOUT },
	{ "NT_STATUS_FILE_FORCED_CLOSED", NT_STATUS_FILE_FORCED_CLOSED },
	{ "NT_STATUS_PROFILING_NOT_STARTED", NT_STATUS_PROFILING_NOT_STARTED },
	{ "NT_STATUS_PROFILING_NOT_STOPPED", NT_STATUS_PROFILING_NOT_STOPPED },
	{ "NT_STATUS_COULD_NOT_INTERPRET", NT_STATUS_COULD_NOT_INTERPRET },
	{ "NT_STATUS_FILE_IS_A_DIRECTORY", NT_STATUS_FILE_IS_A_DIRECTORY },
	{ "NT_STATUS_NOT_SUPPORTED", NT_STATUS_NOT_SUPPORTED },
	{ "NT_STATUS_REMOTE_NOT_LISTENING", NT_STATUS_REMOTE_NOT_LISTENING },
	{ "NT_STATUS_DUPLICATE_NAME", NT_STATUS_DUPLICATE_NAME },
	{ "NT_STATUS_BAD_NETWORK_PATH", NT_STATUS_BAD_NETWORK_PATH },
	{ "NT_STATUS_NETWORK_BUSY", NT_STATUS_NETWORK_BUSY },
	{ "NT_STATUS_DEVICE_DOES_NOT_EXIST", NT_STATUS_DEVICE_DOES_NOT_EXIST },
	{ "NT_STATUS_TOO_MANY_COMMANDS", NT_STATUS_TOO_MANY_COMMANDS },
	{ "NT_STATUS_ADAPTER_HARDWARE_ERROR", NT_STATUS_ADAPTER_HARDWARE_ERROR },
	{ "NT_STATUS_INVALID_NETWORK_RESPONSE", NT_STATUS_INVALID_NETWORK_RESPONSE },
	{ "NT_STATUS_UNEXPECTED_NETWORK_ERROR", NT_STATUS_UNEXPECTED_NETWORK_ERROR },
	{ "NT_STATUS_BAD_REMOTE_ADAPTER", NT_STATUS_BAD_REMOTE_ADAPTER },
	{ "NT_STATUS_PRINT_QUEUE_FULL", NT_STATUS_PRINT_QUEUE_FULL },
	{ "NT_STATUS_NO_SPOOL_SPACE", NT_STATUS_NO_SPOOL_SPACE },
	{ "NT_STATUS_PRINT_CANCELLED", NT_STATUS_PRINT_CANCELLED },
	{ "NT_STATUS_NETWORK_NAME_DELETED", NT_STATUS_NETWORK_NAME_DELETED },
	{ "NT_STATUS_NETWORK_ACCESS_DENIED", NT_STATUS_NETWORK_ACCESS_DENIED },
	{ "NT_STATUS_BAD_DEVICE_TYPE", NT_STATUS_BAD_DEVICE_TYPE },
	{ "NT_STATUS_BAD_NETWORK_NAME", NT_STATUS_BAD_NETWORK_NAME },
	{ "NT_STATUS_TOO_MANY_NAMES", NT_STATUS_TOO_MANY_NAMES },
	{ "NT_STATUS_TOO_MANY_SESSIONS", NT_STATUS_TOO_MANY_SESSIONS },
	{ "NT_STATUS_SHARING_PAUSED", NT_STATUS_SHARING_PAUSED },
	{ "NT_STATUS_REQUEST_NOT_ACCEPTED", NT_STATUS_REQUEST_NOT_ACCEPTED },
	{ "NT_STATUS_REDIRECTOR_PAUSED", NT_STATUS_REDIRECTOR_PAUSED },
	{ "NT_STATUS_NET_WRITE_FAULT", NT_STATUS_NET_WRITE_FAULT },
	{ "NT_STATUS_PROFILING_AT_LIMIT", NT_STATUS_PROFILING_AT_LIMIT },
	{ "NT_STATUS_NOT_SAME_DEVICE", NT_STATUS_NOT_SAME_DEVICE },
	{ "NT_STATUS_FILE_RENAMED", NT_STATUS_FILE_RENAMED },
	{ "NT_STATUS_VIRTUAL_CIRCUIT_CLOSED", NT_STATUS_VIRTUAL_CIRCUIT_CLOSED },
	{ "NT_STATUS_NO_SECURITY_ON_OBJECT", NT_STATUS_NO_SECURITY_ON_OBJECT },
	{ "NT_STATUS_CANT_WAIT", NT_STATUS_CANT_WAIT },
	{ "NT_STATUS_PIPE_EMPTY", NT_STATUS_PIPE_EMPTY },
	{ "NT_STATUS_CANT_ACCESS_DOMAIN_INFO", NT_STATUS_CANT_ACCESS_DOMAIN_INFO },
	{ "NT_STATUS_CANT_TERMINATE_SELF", NT_STATUS_CANT_TERMINATE_SELF },
	{ "NT_STATUS_INVALID_SERVER_STATE", NT_STATUS_INVALID_SERVER_STATE },
	{ "NT_STATUS_INVALID_DOMAIN_STATE", NT_STATUS_INVALID_DOMAIN_STATE },
	{ "NT_STATUS_INVALID_DOMAIN_ROLE", NT_STATUS_INVALID_DOMAIN_ROLE },
	{ "NT_STATUS_NO_SUCH_DOMAIN", NT_STATUS_NO_SUCH_DOMAIN },
	{ "NT_STATUS_DOMAIN_EXISTS", NT_STATUS_DOMAIN_EXISTS },
	{ "NT_STATUS_DOMAIN_LIMIT_EXCEEDED", NT_STATUS_DOMAIN_LIMIT_EXCEEDED },
	{ "NT_STATUS_OPLOCK_NOT_GRANTED", NT_STATUS_OPLOCK_NOT_GRANTED },
	{ "NT_STATUS_INVALID_OPLOCK_PROTOCOL", NT_STATUS_INVALID_OPLOCK_PROTOCOL },
	{ "NT_STATUS_INTERNAL_DB_CORRUPTION", NT_STATUS_INTERNAL_DB_CORRUPTION },
	{ "NT_STATUS_INTERNAL_ERROR", NT_STATUS_INTERNAL_ERROR },
	{ "NT_STATUS_GENERIC_NOT_MAPPED", NT_STATUS_GENERIC_NOT_MAPPED },
	{ "NT_STATUS_BAD_DESCRIPTOR_FORMAT", NT_STATUS_BAD_DESCRIPTOR_FORMAT },
	{ "NT_STATUS_INVALID_USER_BUFFER", NT_STATUS_INVALID_USER_BUFFER },
	{ "NT_STATUS_UNEXPECTED_IO_ERROR", NT_STATUS_UNEXPECTED_IO_ERROR },
	{ "NT_STATUS_UNEXPECTED_MM_CREATE_ERR", NT_STATUS_UNEXPECTED_MM_CREATE_ERR },
	{ "NT_STATUS_UNEXPECTED_MM_MAP_ERROR", NT_STATUS_UNEXPECTED_MM_MAP_ERROR },
	{ "NT_STATUS_UNEXPECTED_MM_EXTEND_ERR", NT_STATUS_UNEXPECTED_MM_EXTEND_ERR },
	{ "NT_STATUS_NOT_LOGON_PROCESS", NT_STATUS_NOT_LOGON_PROCESS },
	{ "NT_STATUS_LOGON_SESSION_EXISTS", NT_STATUS_LOGON_SESSION_EXISTS },
	{ "NT_STATUS_INVALID_PARAMETER_1", NT_STATUS_INVALID_PARAMETER_1 },
	{ "NT_STATUS_INVALID_PARAMETER_2", NT_STATUS_INVALID_PARAMETER_2 },
	{ "NT_STATUS_INVALID_PARAMETER_3", NT_STATUS_INVALID_PARAMETER_3 },
	{ "NT_STATUS_INVALID_PARAMETER_4", NT_STATUS_INVALID_PARAMETER_4 },
	{ "NT_STATUS_INVALID_PARAMETER_5", NT_STATUS_INVALID_PARAMETER_5 },
	{ "NT_STATUS_INVALID_PARAMETER_6", NT_STATUS_INVALID_PARAMETER_6 },
	{ "NT_STATUS_INVALID_PARAMETER_7", NT_STATUS_INVALID_PARAMETER_7 },
	{ "NT_STATUS_INVALID_PARAMETER_8", NT_STATUS_INVALID_PARAMETER_8 },
	{ "NT_STATUS_INVALID_PARAMETER_9", NT_STATUS_INVALID_PARAMETER_9 },
	{ "NT_STATUS_INVALID_PARAMETER_10", NT_STATUS_INVALID_PARAMETER_10 },
	{ "NT_STATUS_INVALID_PARAMETER_11", NT_STATUS_INVALID_PARAMETER_11 },
	{ "NT_STATUS_INVALID_PARAMETER_12", NT_STATUS_INVALID_PARAMETER_12 },
	{ "NT_STATUS_REDIRECTOR_NOT_STARTED", NT_STATUS_REDIRECTOR_NOT_STARTED },
	{ "NT_STATUS_REDIRECTOR_STARTED", NT_STATUS_REDIRECTOR_STARTED },
	{ "NT_STATUS_STACK_OVERFLOW", NT_STATUS_STACK_OVERFLOW },
	{ "NT_STATUS_NO_SUCH_PACKAGE", NT_STATUS_NO_SUCH_PACKAGE },
	{ "NT_STATUS_BAD_FUNCTION_TABLE", NT_STATUS_BAD_FUNCTION_TABLE },
	{ "NT_STATUS_DIRECTORY_NOT_EMPTY", NT_STATUS_DIRECTORY_NOT_EMPTY },
	{ "NT_STATUS_FILE_CORRUPT_ERROR", NT_STATUS_FILE_CORRUPT_ERROR },
	{ "NT_STATUS_NOT_A_DIRECTORY", NT_STATUS_NOT_A_DIRECTORY },
	{ "NT_STATUS_BAD_LOGON_SESSION_STATE", NT_STATUS_BAD_LOGON_SESSION_STATE },
	{ "NT_STATUS_LOGON_SESSION_COLLISION", NT_STATUS_LOGON_SESSION_COLLISION },
	{ "NT_STATUS_NAME_TOO_LONG", NT_STATUS_NAME_TOO_LONG },
	{ "NT_STATUS_FILES_OPEN", NT_STATUS_FILES_OPEN },
	{ "NT_STATUS_CONNECTION_IN_USE", NT_STATUS_CONNECTION_IN_USE },
	{ "NT_STATUS_MESSAGE_NOT_FOUND", NT_STATUS_MESSAGE_NOT_FOUND },
	{ "NT_STATUS_PROCESS_IS_TERMINATING", NT_STATUS_PROCESS_IS_TERMINATING },
	{ "NT_STATUS_INVALID_LOGON_TYPE", NT_STATUS_INVALID_LOGON_TYPE },
	{ "NT_STATUS_NO_GUID_TRANSLATION", NT_STATUS_NO_GUID_TRANSLATION },
	{ "NT_STATUS_CANNOT_IMPERSONATE", NT_STATUS_CANNOT_IMPERSONATE },
	{ "NT_STATUS_IMAGE_ALREADY_LOADED", NT_STATUS_IMAGE_ALREADY_LOADED },
	{ "NT_STATUS_ABIOS_NOT_PRESENT", NT_STATUS_ABIOS_NOT_PRESENT },
	{ "NT_STATUS_ABIOS_LID_NOT_EXIST", NT_STATUS_ABIOS_LID_NOT_EXIST },
	{ "NT_STATUS_ABIOS_LID_ALREADY_OWNED", NT_STATUS_ABIOS_LID_ALREADY_OWNED },
	{ "NT_STATUS_ABIOS_NOT_LID_OWNER", NT_STATUS_ABIOS_NOT_LID_OWNER },
	{ "NT_STATUS_ABIOS_INVALID_COMMAND", NT_STATUS_ABIOS_INVALID_COMMAND },
	{ "NT_STATUS_ABIOS_INVALID_LID", NT_STATUS_ABIOS_INVALID_LID },
	{ "NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE", NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE },
	{ "NT_STATUS_ABIOS_INVALID_SELECTOR", NT_STATUS_ABIOS_INVALID_SELECTOR },
	{ "NT_STATUS_NO_LDT", NT_STATUS_NO_LDT },
	{ "NT_STATUS_INVALID_LDT_SIZE", NT_STATUS_INVALID_LDT_SIZE },
	{ "NT_STATUS_INVALID_LDT_OFFSET", NT_STATUS_INVALID_LDT_OFFSET },
	{ "NT_STATUS_INVALID_LDT_DESCRIPTOR", NT_STATUS_INVALID_LDT_DESCRIPTOR },
	{ "NT_STATUS_INVALID_IMAGE_NE_FORMAT", NT_STATUS_INVALID_IMAGE_NE_FORMAT },
	{ "NT_STATUS_RXACT_INVALID_STATE", NT_STATUS_RXACT_INVALID_STATE },
	{ "NT_STATUS_RXACT_COMMIT_FAILURE", NT_STATUS_RXACT_COMMIT_FAILURE },
	{ "NT_STATUS_MAPPED_FILE_SIZE_ZERO", NT_STATUS_MAPPED_FILE_SIZE_ZERO },
	{ "NT_STATUS_TOO_MANY_OPENED_FILES", NT_STATUS_TOO_MANY_OPENED_FILES },
	{ "NT_STATUS_CANCELLED", NT_STATUS_CANCELLED },
	{ "NT_STATUS_CANNOT_DELETE", NT_STATUS_CANNOT_DELETE },
	{ "NT_STATUS_INVALID_COMPUTER_NAME", NT_STATUS_INVALID_COMPUTER_NAME },
	{ "NT_STATUS_FILE_DELETED", NT_STATUS_FILE_DELETED },
	{ "NT_STATUS_SPECIAL_ACCOUNT", NT_STATUS_SPECIAL_ACCOUNT },
	{ "NT_STATUS_SPECIAL_GROUP", NT_STATUS_SPECIAL_GROUP },
	{ "NT_STATUS_SPECIAL_USER", NT_STATUS_SPECIAL_USER },
	{ "NT_STATUS_MEMBERS_PRIMARY_GROUP", NT_STATUS_MEMBERS_PRIMARY_GROUP },
	{ "NT_STATUS_FILE_CLOSED", NT_STATUS_FILE_CLOSED },
	{ "NT_STATUS_TOO_MANY_THREADS", NT_STATUS_TOO_MANY_THREADS },
	{ "NT_STATUS_THREAD_NOT_IN_PROCESS", NT_STATUS_THREAD_NOT_IN_PROCESS },
	{ "NT_STATUS_TOKEN_ALREADY_IN_USE", NT_STATUS_TOKEN_ALREADY_IN_USE },
	{ "NT_STATUS_PAGEFILE_QUOTA_EXCEEDED", NT_STATUS_PAGEFILE_QUOTA_EXCEEDED },
	{ "NT_STATUS_COMMITMENT_LIMIT", NT_STATUS_COMMITMENT_LIMIT },
	{ "NT_STATUS_INVALID_IMAGE_LE_FORMAT", NT_STATUS_INVALID_IMAGE_LE_FORMAT },
	{ "NT_STATUS_INVALID_IMAGE_NOT_MZ", NT_STATUS_INVALID_IMAGE_NOT_MZ },
	{ "NT_STATUS_INVALID_IMAGE_PROTECT", NT_STATUS_INVALID_IMAGE_PROTECT },
	{ "NT_STATUS_INVALID_IMAGE_WIN_16", NT_STATUS_INVALID_IMAGE_WIN_16 },
	{ "NT_STATUS_LOGON_SERVER_CONFLICT", NT_STATUS_LOGON_SERVER_CONFLICT },
	{ "NT_STATUS_TIME_DIFFERENCE_AT_DC", NT_STATUS_TIME_DIFFERENCE_AT_DC },
	{ "NT_STATUS_SYNCHRONIZATION_REQUIRED", NT_STATUS_SYNCHRONIZATION_REQUIRED },
	{ "NT_STATUS_DLL_NOT_FOUND", NT_STATUS_DLL_NOT_FOUND },
	{ "NT_STATUS_OPEN_FAILED", NT_STATUS_OPEN_FAILED },
	{ "NT_STATUS_IO_PRIVILEGE_FAILED", NT_STATUS_IO_PRIVILEGE_FAILED },
	{ "NT_STATUS_ORDINAL_NOT_FOUND", NT_STATUS_ORDINAL_NOT_FOUND },
	{ "NT_STATUS_ENTRYPOINT_NOT_FOUND", NT_STATUS_ENTRYPOINT_NOT_FOUND },
	{ "NT_STATUS_CONTROL_C_EXIT", NT_STATUS_CONTROL_C_EXIT },
	{ "NT_STATUS_LOCAL_DISCONNECT", NT_STATUS_LOCAL_DISCONNECT },
	{ "NT_STATUS_REMOTE_DISCONNECT", NT_STATUS_REMOTE_DISCONNECT },
	{ "NT_STATUS_REMOTE_RESOURCES", NT_STATUS_REMOTE_RESOURCES },
	{ "NT_STATUS_LINK_FAILED", NT_STATUS_LINK_FAILED },
	{ "NT_STATUS_LINK_TIMEOUT", NT_STATUS_LINK_TIMEOUT },
	{ "NT_STATUS_INVALID_CONNECTION", NT_STATUS_INVALID_CONNECTION },
	{ "NT_STATUS_INVALID_ADDRESS", NT_STATUS_INVALID_ADDRESS },
	{ "NT_STATUS_DLL_INIT_FAILED", NT_STATUS_DLL_INIT_FAILED },
	{ "NT_STATUS_MISSING_SYSTEMFILE", NT_STATUS_MISSING_SYSTEMFILE },
	{ "NT_STATUS_UNHANDLED_EXCEPTION", NT_STATUS_UNHANDLED_EXCEPTION },
	{ "NT_STATUS_APP_INIT_FAILURE", NT_STATUS_APP_INIT_FAILURE },
	{ "NT_STATUS_PAGEFILE_CREATE_FAILED", NT_STATUS_PAGEFILE_CREATE_FAILED },
	{ "NT_STATUS_NO_PAGEFILE", NT_STATUS_NO_PAGEFILE },
	{ "NT_STATUS_INVALID_LEVEL", NT_STATUS_INVALID_LEVEL },
	{ "NT_STATUS_WRONG_PASSWORD_CORE", NT_STATUS_WRONG_PASSWORD_CORE },
	{ "NT_STATUS_ILLEGAL_FLOAT_CONTEXT", NT_STATUS_ILLEGAL_FLOAT_CONTEXT },
	{ "NT_STATUS_PIPE_BROKEN", NT_STATUS_PIPE_BROKEN },
	{ "NT_STATUS_REGISTRY_CORRUPT", NT_STATUS_REGISTRY_CORRUPT },
	{ "NT_STATUS_REGISTRY_IO_FAILED", NT_STATUS_REGISTRY_IO_FAILED },
	{ "NT_STATUS_NO_EVENT_PAIR", NT_STATUS_NO_EVENT_PAIR },
	{ "NT_STATUS_UNRECOGNIZED_VOLUME", NT_STATUS_UNRECOGNIZED_VOLUME },
	{ "NT_STATUS_SERIAL_NO_DEVICE_INITED", NT_STATUS_SERIAL_NO_DEVICE_INITED },
	{ "NT_STATUS_NO_SUCH_ALIAS", NT_STATUS_NO_SUCH_ALIAS },
	{ "NT_STATUS_MEMBER_NOT_IN_ALIAS", NT_STATUS_MEMBER_NOT_IN_ALIAS },
	{ "NT_STATUS_MEMBER_IN_ALIAS", NT_STATUS_MEMBER_IN_ALIAS },
	{ "NT_STATUS_ALIAS_EXISTS", NT_STATUS_ALIAS_EXISTS },
	{ "NT_STATUS_LOGON_NOT_GRANTED", NT_STATUS_LOGON_NOT_GRANTED },
	{ "NT_STATUS_TOO_MANY_SECRETS", NT_STATUS_TOO_MANY_SECRETS },
	{ "NT_STATUS_SECRET_TOO_LONG", NT_STATUS_SECRET_TOO_LONG },
	{ "NT_STATUS_INTERNAL_DB_ERROR", NT_STATUS_INTERNAL_DB_ERROR },
	{ "NT_STATUS_FULLSCREEN_MODE", NT_STATUS_FULLSCREEN_MODE },
	{ "NT_STATUS_TOO_MANY_CONTEXT_IDS", NT_STATUS_TOO_MANY_CONTEXT_IDS },
	{ "NT_STATUS_LOGON_TYPE_NOT_GRANTED", NT_STATUS_LOGON_TYPE_NOT_GRANTED },
	{ "NT_STATUS_NOT_REGISTRY_FILE", NT_STATUS_NOT_REGISTRY_FILE },
	{ "NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED", NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED },
	{ "NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR", NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR },
	{ "NT_STATUS_FT_MISSING_MEMBER", NT_STATUS_FT_MISSING_MEMBER },
	{ "NT_STATUS_ILL_FORMED_SERVICE_ENTRY", NT_STATUS_ILL_FORMED_SERVICE_ENTRY },
	{ "NT_STATUS_ILLEGAL_CHARACTER", NT_STATUS_ILLEGAL_CHARACTER },
	{ "NT_STATUS_UNMAPPABLE_CHARACTER", NT_STATUS_UNMAPPABLE_CHARACTER },
	{ "NT_STATUS_UNDEFINED_CHARACTER", NT_STATUS_UNDEFINED_CHARACTER },
	{ "NT_STATUS_FLOPPY_VOLUME", NT_STATUS_FLOPPY_VOLUME },
	{ "NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND", NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND },
	{ "NT_STATUS_FLOPPY_WRONG_CYLINDER", NT_STATUS_FLOPPY_WRONG_CYLINDER },
	{ "NT_STATUS_FLOPPY_UNKNOWN_ERROR", NT_STATUS_FLOPPY_UNKNOWN_ERROR },
	{ "NT_STATUS_FLOPPY_BAD_REGISTERS", NT_STATUS_FLOPPY_BAD_REGISTERS },
	{ "NT_STATUS_DISK_RECALIBRATE_FAILED", NT_STATUS_DISK_RECALIBRATE_FAILED },
	{ "NT_STATUS_DISK_OPERATION_FAILED", NT_STATUS_DISK_OPERATION_FAILED },
	{ "NT_STATUS_DISK_RESET_FAILED", NT_STATUS_DISK_RESET_FAILED },
	{ "NT_STATUS_SHARED_IRQ_BUSY", NT_STATUS_SHARED_IRQ_BUSY },
	{ "NT_STATUS_FT_ORPHANING", NT_STATUS_FT_ORPHANING },
	{ "NT_STATUS_PARTITION_FAILURE", NT_STATUS_PARTITION_FAILURE },
	{ "NT_STATUS_INVALID_BLOCK_LENGTH", NT_STATUS_INVALID_BLOCK_LENGTH },
	{ "NT_STATUS_DEVICE_NOT_PARTITIONED", NT_STATUS_DEVICE_NOT_PARTITIONED },
	{ "NT_STATUS_UNABLE_TO_LOCK_MEDIA", NT_STATUS_UNABLE_TO_LOCK_MEDIA },
	{ "NT_STATUS_UNABLE_TO_UNLOAD_MEDIA", NT_STATUS_UNABLE_TO_UNLOAD_MEDIA },
	{ "NT_STATUS_EOM_OVERFLOW", NT_STATUS_EOM_OVERFLOW },
	{ "NT_STATUS_NO_MEDIA", NT_STATUS_NO_MEDIA },
	{ "NT_STATUS_NO_SUCH_MEMBER", NT_STATUS_NO_SUCH_MEMBER },
	{ "NT_STATUS_INVALID_MEMBER", NT_STATUS_INVALID_MEMBER },
	{ "NT_STATUS_KEY_DELETED", NT_STATUS_KEY_DELETED },
	{ "NT_STATUS_NO_LOG_SPACE", NT_STATUS_NO_LOG_SPACE },
	{ "NT_STATUS_TOO_MANY_SIDS", NT_STATUS_TOO_MANY_SIDS },
	{ "NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED", NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED },
	{ "NT_STATUS_KEY_HAS_CHILDREN", NT_STATUS_KEY_HAS_CHILDREN },
	{ "NT_STATUS_CHILD_MUST_BE_VOLATILE", NT_STATUS_CHILD_MUST_BE_VOLATILE },
	{ "NT_STATUS_DEVICE_CONFIGURATION_ERROR", NT_STATUS_DEVICE_CONFIGURATION_ERROR },
	{ "NT_STATUS_DRIVER_INTERNAL_ERROR", NT_STATUS_DRIVER_INTERNAL_ERROR },
	{ "NT_STATUS_INVALID_DEVICE_STATE", NT_STATUS_INVALID_DEVICE_STATE },
	{ "NT_STATUS_IO_DEVICE_ERROR", NT_STATUS_IO_DEVICE_ERROR },
	{ "NT_STATUS_DEVICE_PROTOCOL_ERROR", NT_STATUS_DEVICE_PROTOCOL_ERROR },
	{ "NT_STATUS_BACKUP_CONTROLLER", NT_STATUS_BACKUP_CONTROLLER },
	{ "NT_STATUS_LOG_FILE_FULL", NT_STATUS_LOG_FILE_FULL },
	{ "NT_STATUS_TOO_LATE", NT_STATUS_TOO_LATE },
	{ "NT_STATUS_NO_TRUST_LSA_SECRET", NT_STATUS_NO_TRUST_LSA_SECRET },
	{ "NT_STATUS_NO_TRUST_SAM_ACCOUNT", NT_STATUS_NO_TRUST_SAM_ACCOUNT },
	{ "NT_STATUS_TRUSTED_DOMAIN_FAILURE", NT_STATUS_TRUSTED_DOMAIN_FAILURE },
	{ "NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE", NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE },
	{ "NT_STATUS_EVENTLOG_FILE_CORRUPT", NT_STATUS_EVENTLOG_FILE_CORRUPT },
	{ "NT_STATUS_EVENTLOG_CANT_START", NT_STATUS_EVENTLOG_CANT_START },
	{ "NT_STATUS_TRUST_FAILURE", NT_STATUS_TRUST_FAILURE },
	{ "NT_STATUS_MUTANT_LIMIT_EXCEEDED", NT_STATUS_MUTANT_LIMIT_EXCEEDED },
	{ "NT_STATUS_NETLOGON_NOT_STARTED", NT_STATUS_NETLOGON_NOT_STARTED },
	{ "NT_STATUS_ACCOUNT_EXPIRED", NT_STATUS_ACCOUNT_EXPIRED },
	{ "NT_STATUS_POSSIBLE_DEADLOCK", NT_STATUS_POSSIBLE_DEADLOCK },
	{ "NT_STATUS_NETWORK_CREDENTIAL_CONFLICT", NT_STATUS_NETWORK_CREDENTIAL_CONFLICT },
	{ "NT_STATUS_REMOTE_SESSION_LIMIT", NT_STATUS_REMOTE_SESSION_LIMIT },
	{ "NT_STATUS_EVENTLOG_FILE_CHANGED", NT_STATUS_EVENTLOG_FILE_CHANGED },
	{ "NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT", NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT },
	{ "NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT", NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT },
	{ "NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT", NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT },
	{ "NT_STATUS_DOMAIN_TRUST_INCONSISTENT", NT_STATUS_DOMAIN_TRUST_INCONSISTENT },
	{ "NT_STATUS_FS_DRIVER_REQUIRED", NT_STATUS_FS_DRIVER_REQUIRED },
	{ "NT_STATUS_NO_USER_SESSION_KEY", NT_STATUS_NO_USER_SESSION_KEY },
	{ "NT_STATUS_USER_SESSION_DELETED", NT_STATUS_USER_SESSION_DELETED },
	{ "NT_STATUS_RESOURCE_LANG_NOT_FOUND", NT_STATUS_RESOURCE_LANG_NOT_FOUND },
	{ "NT_STATUS_INSUFF_SERVER_RESOURCES", NT_STATUS_INSUFF_SERVER_RESOURCES },
	{ "NT_STATUS_INVALID_BUFFER_SIZE", NT_STATUS_INVALID_BUFFER_SIZE },
	{ "NT_STATUS_INVALID_ADDRESS_COMPONENT", NT_STATUS_INVALID_ADDRESS_COMPONENT },
	{ "NT_STATUS_INVALID_ADDRESS_WILDCARD", NT_STATUS_INVALID_ADDRESS_WILDCARD },
	{ "NT_STATUS_TOO_MANY_ADDRESSES", NT_STATUS_TOO_MANY_ADDRESSES },
	{ "NT_STATUS_ADDRESS_ALREADY_EXISTS", NT_STATUS_ADDRESS_ALREADY_EXISTS },
	{ "NT_STATUS_ADDRESS_CLOSED", NT_STATUS_ADDRESS_CLOSED },
	{ "NT_STATUS_CONNECTION_DISCONNECTED", NT_STATUS_CONNECTION_DISCONNECTED },
	{ "NT_STATUS_CONNECTION_RESET", NT_STATUS_CONNECTION_RESET },
	{ "NT_STATUS_TOO_MANY_NODES", NT_STATUS_TOO_MANY_NODES },
	{ "NT_STATUS_TRANSACTION_ABORTED", NT_STATUS_TRANSACTION_ABORTED },
	{ "NT_STATUS_TRANSACTION_TIMED_OUT", NT_STATUS_TRANSACTION_TIMED_OUT },
	{ "NT_STATUS_TRANSACTION_NO_RELEASE", NT_STATUS_TRANSACTION_NO_RELEASE },
	{ "NT_STATUS_TRANSACTION_NO_MATCH", NT_STATUS_TRANSACTION_NO_MATCH },
	{ "NT_STATUS_TRANSACTION_RESPONDED", NT_STATUS_TRANSACTION_RESPONDED },
	{ "NT_STATUS_TRANSACTION_INVALID_ID", NT_STATUS_TRANSACTION_INVALID_ID },
	{ "NT_STATUS_TRANSACTION_INVALID_TYPE", NT_STATUS_TRANSACTION_INVALID_TYPE },
	{ "NT_STATUS_NOT_SERVER_SESSION", NT_STATUS_NOT_SERVER_SESSION },
	{ "NT_STATUS_NOT_CLIENT_SESSION", NT_STATUS_NOT_CLIENT_SESSION },
	{ "NT_STATUS_CANNOT_LOAD_REGISTRY_FILE", NT_STATUS_CANNOT_LOAD_REGISTRY_FILE },
	{ "NT_STATUS_DEBUG_ATTACH_FAILED", NT_STATUS_DEBUG_ATTACH_FAILED },
	{ "NT_STATUS_SYSTEM_PROCESS_TERMINATED", NT_STATUS_SYSTEM_PROCESS_TERMINATED },
	{ "NT_STATUS_DATA_NOT_ACCEPTED", NT_STATUS_DATA_NOT_ACCEPTED },
	{ "NT_STATUS_NO_BROWSER_SERVERS_FOUND", NT_STATUS_NO_BROWSER_SERVERS_FOUND },
	{ "NT_STATUS_VDM_HARD_ERROR", NT_STATUS_VDM_HARD_ERROR },
	{ "NT_STATUS_DRIVER_CANCEL_TIMEOUT", NT_STATUS_DRIVER_CANCEL_TIMEOUT },
	{ "NT_STATUS_REPLY_MESSAGE_MISMATCH", NT_STATUS_REPLY_MESSAGE_MISMATCH },
	{ "NT_STATUS_MAPPED_ALIGNMENT", NT_STATUS_MAPPED_ALIGNMENT },
	{ "NT_STATUS_IMAGE_CHECKSUM_MISMATCH", NT_STATUS_IMAGE_CHECKSUM_MISMATCH },
	{ "NT_STATUS_LOST_WRITEBEHIND_DATA", NT_STATUS_LOST_WRITEBEHIND_DATA },
	{ "NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID", NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID },
	{ "NT_STATUS_PASSWORD_MUST_CHANGE", NT_STATUS_PASSWORD_MUST_CHANGE },
	{ "NT_STATUS_NOT_FOUND", NT_STATUS_NOT_FOUND },
	{ "NT_STATUS_NOT_TINY_STREAM", NT_STATUS_NOT_TINY_STREAM },
	{ "NT_STATUS_RECOVERY_FAILURE", NT_STATUS_RECOVERY_FAILURE },
	{ "NT_STATUS_STACK_OVERFLOW_READ", NT_STATUS_STACK_OVERFLOW_READ },
	{ "NT_STATUS_FAIL_CHECK", NT_STATUS_FAIL_CHECK },
	{ "NT_STATUS_DUPLICATE_OBJECTID", NT_STATUS_DUPLICATE_OBJECTID },
	{ "NT_STATUS_OBJECTID_EXISTS", NT_STATUS_OBJECTID_EXISTS },
	{ "NT_STATUS_CONVERT_TO_LARGE", NT_STATUS_CONVERT_TO_LARGE },
	{ "NT_STATUS_RETRY", NT_STATUS_RETRY },
	{ "NT_STATUS_FOUND_OUT_OF_SCOPE", NT_STATUS_FOUND_OUT_OF_SCOPE },
	{ "NT_STATUS_ALLOCATE_BUCKET", NT_STATUS_ALLOCATE_BUCKET },
	{ "NT_STATUS_PROPSET_NOT_FOUND", NT_STATUS_PROPSET_NOT_FOUND },
	{ "NT_STATUS_MARSHALL_OVERFLOW", NT_STATUS_MARSHALL_OVERFLOW },
	{ "NT_STATUS_INVALID_VARIANT", NT_STATUS_INVALID_VARIANT },
	{ "NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND", NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND },
	{ "NT_STATUS_ACCOUNT_LOCKED_OUT", NT_STATUS_ACCOUNT_LOCKED_OUT },
	{ "NT_STATUS_HANDLE_NOT_CLOSABLE", NT_STATUS_HANDLE_NOT_CLOSABLE },
	{ "NT_STATUS_CONNECTION_REFUSED", NT_STATUS_CONNECTION_REFUSED },
	{ "NT_STATUS_GRACEFUL_DISCONNECT", NT_STATUS_GRACEFUL_DISCONNECT },
	{ "NT_STATUS_ADDRESS_ALREADY_ASSOCIATED", NT_STATUS_ADDRESS_ALREADY_ASSOCIATED },
	{ "NT_STATUS_ADDRESS_NOT_ASSOCIATED", NT_STATUS_ADDRESS_NOT_ASSOCIATED },
	{ "NT_STATUS_CONNECTION_INVALID", NT_STATUS_CONNECTION_INVALID },
	{ "NT_STATUS_CONNECTION_ACTIVE", NT_STATUS_CONNECTION_ACTIVE },
	{ "NT_STATUS_NETWORK_UNREACHABLE", NT_STATUS_NETWORK_UNREACHABLE },
	{ "NT_STATUS_HOST_UNREACHABLE", NT_STATUS_HOST_UNREACHABLE },
	{ "NT_STATUS_PROTOCOL_UNREACHABLE", NT_STATUS_PROTOCOL_UNREACHABLE },
	{ "NT_STATUS_PORT_UNREACHABLE", NT_STATUS_PORT_UNREACHABLE },
	{ "NT_STATUS_REQUEST_ABORTED", NT_STATUS_REQUEST_ABORTED },
	{ "NT_STATUS_CONNECTION_ABORTED", NT_STATUS_CONNECTION_ABORTED },
	{ "NT_STATUS_BAD_COMPRESSION_BUFFER", NT_STATUS_BAD_COMPRESSION_BUFFER },
	{ "NT_STATUS_USER_MAPPED_FILE", NT_STATUS_USER_MAPPED_FILE },
	{ "NT_STATUS_AUDIT_FAILED", NT_STATUS_AUDIT_FAILED },
	{ "NT_STATUS_TIMER_RESOLUTION_NOT_SET", NT_STATUS_TIMER_RESOLUTION_NOT_SET },
	{ "NT_STATUS_CONNECTION_COUNT_LIMIT", NT_STATUS_CONNECTION_COUNT_LIMIT },
	{ "NT_STATUS_LOGIN_TIME_RESTRICTION", NT_STATUS_LOGIN_TIME_RESTRICTION },
	{ "NT_STATUS_LOGIN_WKSTA_RESTRICTION", NT_STATUS_LOGIN_WKSTA_RESTRICTION },
	{ "NT_STATUS_IMAGE_MP_UP_MISMATCH", NT_STATUS_IMAGE_MP_UP_MISMATCH },
	{ "NT_STATUS_INSUFFICIENT_LOGON_INFO", NT_STATUS_INSUFFICIENT_LOGON_INFO },
	{ "NT_STATUS_BAD_DLL_ENTRYPOINT", NT_STATUS_BAD_DLL_ENTRYPOINT },
	{ "NT_STATUS_BAD_SERVICE_ENTRYPOINT", NT_STATUS_BAD_SERVICE_ENTRYPOINT },
	{ "NT_STATUS_LPC_REPLY_LOST", NT_STATUS_LPC_REPLY_LOST },
	{ "NT_STATUS_IP_ADDRESS_CONFLICT1", NT_STATUS_IP_ADDRESS_CONFLICT1 },
	{ "NT_STATUS_IP_ADDRESS_CONFLICT2", NT_STATUS_IP_ADDRESS_CONFLICT2 },
	{ "NT_STATUS_REGISTRY_QUOTA_LIMIT", NT_STATUS_REGISTRY_QUOTA_LIMIT },
	{ "NT_STATUS_PATH_NOT_COVERED", NT_STATUS_PATH_NOT_COVERED },
	{ "NT_STATUS_NO_CALLBACK_ACTIVE", NT_STATUS_NO_CALLBACK_ACTIVE },
	{ "NT_STATUS_LICENSE_QUOTA_EXCEEDED", NT_STATUS_LICENSE_QUOTA_EXCEEDED },
	{ "NT_STATUS_PWD_TOO_SHORT", NT_STATUS_PWD_TOO_SHORT },
	{ "NT_STATUS_PWD_TOO_RECENT", NT_STATUS_PWD_TOO_RECENT },
	{ "NT_STATUS_PWD_HISTORY_CONFLICT", NT_STATUS_PWD_HISTORY_CONFLICT },
	{ "NT_STATUS_PLUGPLAY_NO_DEVICE", NT_STATUS_PLUGPLAY_NO_DEVICE },
	{ "NT_STATUS_UNSUPPORTED_COMPRESSION", NT_STATUS_UNSUPPORTED_COMPRESSION },
	{ "NT_STATUS_INVALID_HW_PROFILE", NT_STATUS_INVALID_HW_PROFILE },
	{ "NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH", NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH },
	{ "NT_STATUS_DRIVER_ORDINAL_NOT_FOUND", NT_STATUS_DRIVER_ORDINAL_NOT_FOUND },
	{ "NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND", NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND },
	{ "NT_STATUS_RESOURCE_NOT_OWNED", NT_STATUS_RESOURCE_NOT_OWNED },
	{ "NT_STATUS_TOO_MANY_LINKS", NT_STATUS_TOO_MANY_LINKS },
	{ "NT_STATUS_QUOTA_LIST_INCONSISTENT", NT_STATUS_QUOTA_LIST_INCONSISTENT },
	{ "NT_STATUS_FILE_IS_OFFLINE", NT_STATUS_FILE_IS_OFFLINE },
	{ "NT_STATUS_DS_NO_MORE_RIDS", NT_STATUS_DS_NO_MORE_RIDS },
	{ "NT_STATUS_IO_REPARSE_DATA_INVALID",
	  NT_STATUS_IO_REPARSE_DATA_INVALID },
	{ "NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED",
	  NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED },
	{ "NT_STATUS_NOT_A_REPARSE_POINT", NT_STATUS_NOT_A_REPARSE_POINT },
	{ "NT_STATUS_NO_MORE_ENTRIES", NT_STATUS_NO_MORE_ENTRIES },
	{ "NT_STATUS_FILE_NOT_AVAILABLE", NT_STATUS_FILE_NOT_AVAILABLE },
	{ "NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED", NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED },
	{ "NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX", NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX },
	{ "NT_STATUS_RPC_UNKNOWN_IF", NT_STATUS_RPC_UNKNOWN_IF },
	{ "NT_STATUS_RPC_CALL_FAILED", NT_STATUS_RPC_CALL_FAILED },
	{ "NT_STATUS_RPC_PROTOCOL_ERROR", NT_STATUS_RPC_PROTOCOL_ERROR },
	{ "NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE", NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE },
	{ "NT_STATUS_RPC_CANNOT_SUPPORT", NT_STATUS_RPC_CANNOT_SUPPORT },
	{ "NT_STATUS_RPC_SEC_PKG_ERROR", NT_STATUS_RPC_SEC_PKG_ERROR },
	{ "NT_STATUS_RPC_SS_CONTEXT_MISMATCH", NT_STATUS_RPC_SS_CONTEXT_MISMATCH },
	{ "NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE", NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE },
	{ "NT_STATUS_RPC_BAD_STUB_DATA", NT_STATUS_RPC_BAD_STUB_DATA },
	{ "NT_STATUS_RPC_INVALID_PIPE_OBJECT", NT_STATUS_RPC_INVALID_PIPE_OBJECT },
	{ "NT_STATUS_RPC_INVALID_PIPE_OPERATION", NT_STATUS_RPC_INVALID_PIPE_OPERATION },
	{ "NT_STATUS_RPC_WRONG_PIPE_VERSION", NT_STATUS_RPC_WRONG_PIPE_VERSION },
	{ "NT_STATUS_RPC_PIPE_CLOSED", NT_STATUS_RPC_PIPE_CLOSED },
	{ "NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR", NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR },
	{ "NT_STATUS_RPC_PIPE_EMPTY", NT_STATUS_RPC_PIPE_EMPTY },
	{ "NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED", NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED },
	{ "NT_STATUS_OBJECTID_NOT_FOUND", NT_STATUS_OBJECTID_NOT_FOUND },
	{ "NT_STATUS_NETWORK_SESSION_EXPIRED", NT_STATUS_NETWORK_SESSION_EXPIRED },
	{ "NT_STATUS_ALL_SIDS_FILTERED", NT_STATUS_ALL_SIDS_FILTERED },
	{ "NT_STATUS_DOWNGRADE_DETECTED", NT_STATUS_DOWNGRADE_DETECTED },
	{ "NT_STATUS_NO_S4U_PROT_SUPPORT", NT_STATUS_NO_S4U_PROT_SUPPORT },
	{ "NT_STATUS_CROSSREALM_DELEGATION_FAILURE", NT_STATUS_CROSSREALM_DELEGATION_FAILURE },
	{ "NT_STATUS_INVALID_LOCK_RANGE", NT_STATUS_INVALID_LOCK_RANGE },
	{ "NT_STATUS_ERROR_DS_OBJ_STRING_NAME_EXISTS", NT_STATUS_ERROR_DS_OBJ_STRING_NAME_EXISTS },
	{ "NT_STATUS_ERROR_DS_INCOMPATIBLE_VERSION", NT_STATUS_ERROR_DS_INCOMPATIBLE_VERSION },
	{ "STATUS_MORE_ENTRIES", STATUS_MORE_ENTRIES },
	{ "STATUS_SOME_UNMAPPED", STATUS_SOME_UNMAPPED },
	{ "STATUS_NOTIFY_CLEANUP", STATUS_NOTIFY_CLEANUP },
	{ "STATUS_NOTIFY_ENUM_DIR", STATUS_NOTIFY_ENUM_DIR },

	/*
	 * New descriptions for new errors generated from
	 * [MS-ERREF] http://msdn.microsoft.com/en-us/library/cc704588.aspx
	 */

	{ "NT_STATUS_WAIT_1", NT_STATUS_WAIT_1 },
	{ "NT_STATUS_WAIT_2", NT_STATUS_WAIT_2 },
	{ "NT_STATUS_WAIT_3", NT_STATUS_WAIT_3 },
	{ "NT_STATUS_WAIT_63", NT_STATUS_WAIT_63 },
	{ "NT_STATUS_ABANDONED", NT_STATUS_ABANDONED },
	{ "NT_STATUS_ABANDONED_WAIT_0", NT_STATUS_ABANDONED_WAIT_0 },
	{ "NT_STATUS_ABANDONED_WAIT_63", NT_STATUS_ABANDONED_WAIT_63 },
	{ "NT_STATUS_USER_APC", NT_STATUS_USER_APC },
	{ "NT_STATUS_ALERTED", NT_STATUS_ALERTED },
	{ "NT_STATUS_TIMEOUT", NT_STATUS_TIMEOUT },
	{ "NT_STATUS_REPARSE", NT_STATUS_REPARSE },
	{ "NT_STATUS_NOT_ALL_ASSIGNED", NT_STATUS_NOT_ALL_ASSIGNED },
	{ "NT_STATUS_OPLOCK_BREAK_IN_PROGRESS", NT_STATUS_OPLOCK_BREAK_IN_PROGRESS },
	{ "NT_STATUS_VOLUME_MOUNTED", NT_STATUS_VOLUME_MOUNTED },
	{ "NT_STATUS_RXACT_COMMITTED", NT_STATUS_RXACT_COMMITTED },
	{ "NT_STATUS_NO_QUOTAS_FOR_ACCOUNT", NT_STATUS_NO_QUOTAS_FOR_ACCOUNT },
	{ "NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED", NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED },
	{ "NT_STATUS_PAGE_FAULT_TRANSITION", NT_STATUS_PAGE_FAULT_TRANSITION },
	{ "NT_STATUS_PAGE_FAULT_DEMAND_ZERO", NT_STATUS_PAGE_FAULT_DEMAND_ZERO },
	{ "NT_STATUS_PAGE_FAULT_COPY_ON_WRITE", NT_STATUS_PAGE_FAULT_COPY_ON_WRITE },
	{ "NT_STATUS_PAGE_FAULT_GUARD_PAGE", NT_STATUS_PAGE_FAULT_GUARD_PAGE },
	{ "NT_STATUS_PAGE_FAULT_PAGING_FILE", NT_STATUS_PAGE_FAULT_PAGING_FILE },
	{ "NT_STATUS_CACHE_PAGE_LOCKED", NT_STATUS_CACHE_PAGE_LOCKED },
	{ "NT_STATUS_CRASH_DUMP", NT_STATUS_CRASH_DUMP },
	{ "NT_STATUS_BUFFER_ALL_ZEROS", NT_STATUS_BUFFER_ALL_ZEROS },
	{ "NT_STATUS_REPARSE_OBJECT", NT_STATUS_REPARSE_OBJECT },
	{ "NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED", NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED },
	{ "NT_STATUS_TRANSLATION_COMPLETE", NT_STATUS_TRANSLATION_COMPLETE },
	{ "NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY", NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY },
	{ "NT_STATUS_NOTHING_TO_TERMINATE", NT_STATUS_NOTHING_TO_TERMINATE },
	{ "NT_STATUS_PROCESS_NOT_IN_JOB", NT_STATUS_PROCESS_NOT_IN_JOB },
	{ "NT_STATUS_PROCESS_IN_JOB", NT_STATUS_PROCESS_IN_JOB },
	{ "NT_STATUS_VOLSNAP_HIBERNATE_READY", NT_STATUS_VOLSNAP_HIBERNATE_READY },
	{ "NT_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY", NT_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY },
	{ "NT_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED", NT_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED },
	{ "NT_STATUS_INTERRUPT_STILL_CONNECTED", NT_STATUS_INTERRUPT_STILL_CONNECTED },
	{ "NT_STATUS_PROCESS_CLONED", NT_STATUS_PROCESS_CLONED },
	{ "NT_STATUS_FILE_LOCKED_WITH_ONLY_READERS", NT_STATUS_FILE_LOCKED_WITH_ONLY_READERS },
	{ "NT_STATUS_FILE_LOCKED_WITH_WRITERS", NT_STATUS_FILE_LOCKED_WITH_WRITERS },
	{ "NT_STATUS_RESOURCEMANAGER_READ_ONLY", NT_STATUS_RESOURCEMANAGER_READ_ONLY },
	{ "NT_STATUS_WAIT_FOR_OPLOCK", NT_STATUS_WAIT_FOR_OPLOCK },
	{ "NT_STATUS_DBG_EXCEPTION_HANDLED", NT_STATUS_DBG_EXCEPTION_HANDLED },
	{ "NT_STATUS_DBG_CONTINUE", NT_STATUS_DBG_CONTINUE },
	{ "NT_STATUS_FLT_IO_COMPLETE", NT_STATUS_FLT_IO_COMPLETE },
	{ "NT_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY", NT_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY },
	{ "NT_STATUS_OBJECT_NAME_EXISTS", NT_STATUS_OBJECT_NAME_EXISTS },
	{ "NT_STATUS_THREAD_WAS_SUSPENDED", NT_STATUS_THREAD_WAS_SUSPENDED },
	{ "NT_STATUS_WORKING_SET_LIMIT_RANGE", NT_STATUS_WORKING_SET_LIMIT_RANGE },
	{ "NT_STATUS_IMAGE_NOT_AT_BASE", NT_STATUS_IMAGE_NOT_AT_BASE },
	{ "NT_STATUS_RXACT_STATE_CREATED", NT_STATUS_RXACT_STATE_CREATED },
	{ "NT_STATUS_SEGMENT_NOTIFICATION", NT_STATUS_SEGMENT_NOTIFICATION },
	{ "NT_STATUS_LOCAL_USER_SESSION_KEY", NT_STATUS_LOCAL_USER_SESSION_KEY },
	{ "NT_STATUS_BAD_CURRENT_DIRECTORY", NT_STATUS_BAD_CURRENT_DIRECTORY },
	{ "NT_STATUS_SERIAL_MORE_WRITES", NT_STATUS_SERIAL_MORE_WRITES },
	{ "NT_STATUS_REGISTRY_RECOVERED", NT_STATUS_REGISTRY_RECOVERED },
	{ "NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP", NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP },
	{ "NT_STATUS_FT_WRITE_RECOVERY", NT_STATUS_FT_WRITE_RECOVERY },
	{ "NT_STATUS_SERIAL_COUNTER_TIMEOUT", NT_STATUS_SERIAL_COUNTER_TIMEOUT },
	{ "NT_STATUS_NULL_LM_PASSWORD", NT_STATUS_NULL_LM_PASSWORD },
	{ "NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH", NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH },
	{ "NT_STATUS_RECEIVE_PARTIAL", NT_STATUS_RECEIVE_PARTIAL },
	{ "NT_STATUS_RECEIVE_EXPEDITED", NT_STATUS_RECEIVE_EXPEDITED },
	{ "NT_STATUS_RECEIVE_PARTIAL_EXPEDITED", NT_STATUS_RECEIVE_PARTIAL_EXPEDITED },
	{ "NT_STATUS_EVENT_DONE", NT_STATUS_EVENT_DONE },
	{ "NT_STATUS_EVENT_PENDING", NT_STATUS_EVENT_PENDING },
	{ "NT_STATUS_CHECKING_FILE_SYSTEM", NT_STATUS_CHECKING_FILE_SYSTEM },
	{ "NT_STATUS_FATAL_APP_EXIT", NT_STATUS_FATAL_APP_EXIT },
	{ "NT_STATUS_PREDEFINED_HANDLE", NT_STATUS_PREDEFINED_HANDLE },
	{ "NT_STATUS_WAS_UNLOCKED", NT_STATUS_WAS_UNLOCKED },
	{ "NT_STATUS_SERVICE_NOTIFICATION", NT_STATUS_SERVICE_NOTIFICATION },
	{ "NT_STATUS_WAS_LOCKED", NT_STATUS_WAS_LOCKED },
	{ "NT_STATUS_LOG_HARD_ERROR", NT_STATUS_LOG_HARD_ERROR },
	{ "NT_STATUS_ALREADY_WIN32", NT_STATUS_ALREADY_WIN32 },
	{ "NT_STATUS_WX86_UNSIMULATE", NT_STATUS_WX86_UNSIMULATE },
	{ "NT_STATUS_WX86_CONTINUE", NT_STATUS_WX86_CONTINUE },
	{ "NT_STATUS_WX86_SINGLE_STEP", NT_STATUS_WX86_SINGLE_STEP },
	{ "NT_STATUS_WX86_BREAKPOINT", NT_STATUS_WX86_BREAKPOINT },
	{ "NT_STATUS_WX86_EXCEPTION_CONTINUE", NT_STATUS_WX86_EXCEPTION_CONTINUE },
	{ "NT_STATUS_WX86_EXCEPTION_LASTCHANCE", NT_STATUS_WX86_EXCEPTION_LASTCHANCE },
	{ "NT_STATUS_WX86_EXCEPTION_CHAIN", NT_STATUS_WX86_EXCEPTION_CHAIN },
	{ "NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE", NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE },
	{ "NT_STATUS_NO_YIELD_PERFORMED", NT_STATUS_NO_YIELD_PERFORMED },
	{ "NT_STATUS_TIMER_RESUME_IGNORED", NT_STATUS_TIMER_RESUME_IGNORED },
	{ "NT_STATUS_ARBITRATION_UNHANDLED", NT_STATUS_ARBITRATION_UNHANDLED },
	{ "NT_STATUS_CARDBUS_NOT_SUPPORTED", NT_STATUS_CARDBUS_NOT_SUPPORTED },
	{ "NT_STATUS_WX86_CREATEWX86TIB", NT_STATUS_WX86_CREATEWX86TIB },
	{ "NT_STATUS_MP_PROCESSOR_MISMATCH", NT_STATUS_MP_PROCESSOR_MISMATCH },
	{ "NT_STATUS_HIBERNATED", NT_STATUS_HIBERNATED },
	{ "NT_STATUS_RESUME_HIBERNATION", NT_STATUS_RESUME_HIBERNATION },
	{ "NT_STATUS_FIRMWARE_UPDATED", NT_STATUS_FIRMWARE_UPDATED },
	{ "NT_STATUS_DRIVERS_LEAKING_LOCKED_PAGES", NT_STATUS_DRIVERS_LEAKING_LOCKED_PAGES },
	{ "NT_STATUS_MESSAGE_RETRIEVED", NT_STATUS_MESSAGE_RETRIEVED },
	{ "NT_STATUS_SYSTEM_POWERSTATE_TRANSITION", NT_STATUS_SYSTEM_POWERSTATE_TRANSITION },
	{ "NT_STATUS_ALPC_CHECK_COMPLETION_LIST", NT_STATUS_ALPC_CHECK_COMPLETION_LIST },
	{ "NT_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION", NT_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION },
	{ "NT_STATUS_ACCESS_AUDIT_BY_POLICY", NT_STATUS_ACCESS_AUDIT_BY_POLICY },
	{ "NT_STATUS_ABANDON_HIBERFILE", NT_STATUS_ABANDON_HIBERFILE },
	{ "NT_STATUS_BIZRULES_NOT_ENABLED", NT_STATUS_BIZRULES_NOT_ENABLED },
	{ "NT_STATUS_WAKE_SYSTEM", NT_STATUS_WAKE_SYSTEM },
	{ "NT_STATUS_DS_SHUTTING_DOWN", NT_STATUS_DS_SHUTTING_DOWN },
	{ "NT_STATUS_DBG_REPLY_LATER", NT_STATUS_DBG_REPLY_LATER },
	{ "NT_STATUS_DBG_UNABLE_TO_PROVIDE_HANDLE", NT_STATUS_DBG_UNABLE_TO_PROVIDE_HANDLE },
	{ "NT_STATUS_DBG_TERMINATE_THREAD", NT_STATUS_DBG_TERMINATE_THREAD },
	{ "NT_STATUS_DBG_TERMINATE_PROCESS", NT_STATUS_DBG_TERMINATE_PROCESS },
	{ "NT_STATUS_DBG_CONTROL_C", NT_STATUS_DBG_CONTROL_C },
	{ "NT_STATUS_DBG_PRINTEXCEPTION_C", NT_STATUS_DBG_PRINTEXCEPTION_C },
	{ "NT_STATUS_DBG_RIPEXCEPTION", NT_STATUS_DBG_RIPEXCEPTION },
	{ "NT_STATUS_DBG_CONTROL_BREAK", NT_STATUS_DBG_CONTROL_BREAK },
	{ "NT_STATUS_DBG_COMMAND_EXCEPTION", NT_STATUS_DBG_COMMAND_EXCEPTION },
	{ "NT_STATUS_RPC_UUID_LOCAL_ONLY", NT_STATUS_RPC_UUID_LOCAL_ONLY },
	{ "NT_STATUS_RPC_SEND_INCOMPLETE", NT_STATUS_RPC_SEND_INCOMPLETE },
	{ "NT_STATUS_CTX_CDM_CONNECT", NT_STATUS_CTX_CDM_CONNECT },
	{ "NT_STATUS_CTX_CDM_DISCONNECT", NT_STATUS_CTX_CDM_DISCONNECT },
	{ "NT_STATUS_SXS_RELEASE_ACTIVATION_CONTEXT", NT_STATUS_SXS_RELEASE_ACTIVATION_CONTEXT },
	{ "NT_STATUS_RECOVERY_NOT_NEEDED", NT_STATUS_RECOVERY_NOT_NEEDED },
	{ "NT_STATUS_RM_ALREADY_STARTED", NT_STATUS_RM_ALREADY_STARTED },
	{ "NT_STATUS_LOG_NO_RESTART", NT_STATUS_LOG_NO_RESTART },
	{ "NT_STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST", NT_STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST },
	{ "NT_STATUS_GRAPHICS_PARTIAL_DATA_POPULATED", NT_STATUS_GRAPHICS_PARTIAL_DATA_POPULATED },
	{ "NT_STATUS_GRAPHICS_DRIVER_MISMATCH", NT_STATUS_GRAPHICS_DRIVER_MISMATCH },
	{ "NT_STATUS_GRAPHICS_MODE_NOT_PINNED", NT_STATUS_GRAPHICS_MODE_NOT_PINNED },
	{ "NT_STATUS_GRAPHICS_NO_PREFERRED_MODE", NT_STATUS_GRAPHICS_NO_PREFERRED_MODE },
	{ "NT_STATUS_GRAPHICS_DATASET_IS_EMPTY", NT_STATUS_GRAPHICS_DATASET_IS_EMPTY },
	{ "NT_STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET", NT_STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET },
	{ "NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED", NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED },
	{ "NT_STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS", NT_STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS },
	{ "NT_STATUS_GRAPHICS_LEADLINK_START_DEFERRED", NT_STATUS_GRAPHICS_LEADLINK_START_DEFERRED },
	{ "NT_STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY", NT_STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY },
	{ "NT_STATUS_GRAPHICS_START_DEFERRED", NT_STATUS_GRAPHICS_START_DEFERRED },
	{ "NT_STATUS_NDIS_INDICATION_REQUIRED", NT_STATUS_NDIS_INDICATION_REQUIRED },
	{ "NT_STATUS_GUARD_PAGE_VIOLATION", NT_STATUS_GUARD_PAGE_VIOLATION },
	{ "NT_STATUS_DATATYPE_MISALIGNMENT", NT_STATUS_DATATYPE_MISALIGNMENT },
	{ "NT_STATUS_BREAKPOINT", NT_STATUS_BREAKPOINT },
	{ "NT_STATUS_SINGLE_STEP", NT_STATUS_SINGLE_STEP },
	{ "NT_STATUS_WAKE_SYSTEM_DEBUGGER", NT_STATUS_WAKE_SYSTEM_DEBUGGER },
	{ "NT_STATUS_HANDLES_CLOSED", NT_STATUS_HANDLES_CLOSED },
	{ "NT_STATUS_NO_INHERITANCE", NT_STATUS_NO_INHERITANCE },
	{ "NT_STATUS_GUID_SUBSTITUTION_MADE", NT_STATUS_GUID_SUBSTITUTION_MADE },
	{ "NT_STATUS_PARTIAL_COPY", NT_STATUS_PARTIAL_COPY },
	{ "NT_STATUS_DEVICE_PAPER_EMPTY", NT_STATUS_DEVICE_PAPER_EMPTY },
	{ "NT_STATUS_DEVICE_POWERED_OFF", NT_STATUS_DEVICE_POWERED_OFF },
	{ "NT_STATUS_DEVICE_OFF_LINE", NT_STATUS_DEVICE_OFF_LINE },
	{ "NT_STATUS_DEVICE_BUSY", NT_STATUS_DEVICE_BUSY },
	{ "NT_STATUS_VERIFY_REQUIRED", NT_STATUS_VERIFY_REQUIRED },
	{ "NT_STATUS_EXTRANEOUS_INFORMATION", NT_STATUS_EXTRANEOUS_INFORMATION },
	{ "NT_STATUS_RXACT_COMMIT_NECESSARY", NT_STATUS_RXACT_COMMIT_NECESSARY },
	{ "NT_STATUS_FILEMARK_DETECTED", NT_STATUS_FILEMARK_DETECTED },
	{ "NT_STATUS_MEDIA_CHANGED", NT_STATUS_MEDIA_CHANGED },
	{ "NT_STATUS_BUS_RESET", NT_STATUS_BUS_RESET },
	{ "NT_STATUS_END_OF_MEDIA", NT_STATUS_END_OF_MEDIA },
	{ "NT_STATUS_BEGINNING_OF_MEDIA", NT_STATUS_BEGINNING_OF_MEDIA },
	{ "NT_STATUS_MEDIA_CHECK", NT_STATUS_MEDIA_CHECK },
	{ "NT_STATUS_SETMARK_DETECTED", NT_STATUS_SETMARK_DETECTED },
	{ "NT_STATUS_NO_DATA_DETECTED", NT_STATUS_NO_DATA_DETECTED },
	{ "NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES", NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES },
	{ "NT_STATUS_SERVER_HAS_OPEN_HANDLES", NT_STATUS_SERVER_HAS_OPEN_HANDLES },
	{ "NT_STATUS_ALREADY_DISCONNECTED", NT_STATUS_ALREADY_DISCONNECTED },
	{ "NT_STATUS_LONGJUMP", NT_STATUS_LONGJUMP },
	{ "NT_STATUS_CLEANER_CARTRIDGE_INSTALLED", NT_STATUS_CLEANER_CARTRIDGE_INSTALLED },
	{ "NT_STATUS_PLUGPLAY_QUERY_VETOED", NT_STATUS_PLUGPLAY_QUERY_VETOED },
	{ "NT_STATUS_UNWIND_CONSOLIDATE", NT_STATUS_UNWIND_CONSOLIDATE },
	{ "NT_STATUS_REGISTRY_HIVE_RECOVERED", NT_STATUS_REGISTRY_HIVE_RECOVERED },
	{ "NT_STATUS_DLL_MIGHT_BE_INSECURE", NT_STATUS_DLL_MIGHT_BE_INSECURE },
	{ "NT_STATUS_DLL_MIGHT_BE_INCOMPATIBLE", NT_STATUS_DLL_MIGHT_BE_INCOMPATIBLE },
	{ "NT_STATUS_DEVICE_REQUIRES_CLEANING", NT_STATUS_DEVICE_REQUIRES_CLEANING },
	{ "NT_STATUS_DEVICE_DOOR_OPEN", NT_STATUS_DEVICE_DOOR_OPEN },
	{ "NT_STATUS_DATA_LOST_REPAIR", NT_STATUS_DATA_LOST_REPAIR },
	{ "NT_STATUS_DBG_EXCEPTION_NOT_HANDLED", NT_STATUS_DBG_EXCEPTION_NOT_HANDLED },
	{ "NT_STATUS_CLUSTER_NODE_ALREADY_UP", NT_STATUS_CLUSTER_NODE_ALREADY_UP },
	{ "NT_STATUS_CLUSTER_NODE_ALREADY_DOWN", NT_STATUS_CLUSTER_NODE_ALREADY_DOWN },
	{ "NT_STATUS_CLUSTER_NETWORK_ALREADY_ONLINE", NT_STATUS_CLUSTER_NETWORK_ALREADY_ONLINE },
	{ "NT_STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE", NT_STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE },
	{ "NT_STATUS_CLUSTER_NODE_ALREADY_MEMBER", NT_STATUS_CLUSTER_NODE_ALREADY_MEMBER },
	{ "NT_STATUS_COULD_NOT_RESIZE_LOG", NT_STATUS_COULD_NOT_RESIZE_LOG },
	{ "NT_STATUS_NO_TXF_METADATA", NT_STATUS_NO_TXF_METADATA },
	{ "NT_STATUS_CANT_RECOVER_WITH_HANDLE_OPEN", NT_STATUS_CANT_RECOVER_WITH_HANDLE_OPEN },
	{ "NT_STATUS_TXF_METADATA_ALREADY_PRESENT", NT_STATUS_TXF_METADATA_ALREADY_PRESENT },
	{ "NT_STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET", NT_STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET },
	{ "NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED", NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED },
	{ "NT_STATUS_FLT_BUFFER_TOO_SMALL", NT_STATUS_FLT_BUFFER_TOO_SMALL },
	{ "NT_STATUS_FVE_PARTIAL_METADATA", NT_STATUS_FVE_PARTIAL_METADATA },
	{ "NT_STATUS_FVE_TRANSIENT_STATE", NT_STATUS_FVE_TRANSIENT_STATE },
	{ "NT_STATUS_VARIABLE_NOT_FOUND", NT_STATUS_VARIABLE_NOT_FOUND },
	{ "NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT", NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT },
	{ "NT_STATUS_IMAGE_ALREADY_LOADED_AS_DLL", NT_STATUS_IMAGE_ALREADY_LOADED_AS_DLL },
	{ "NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING", NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING },
	{ "NT_STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME", NT_STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME },
	{ "NT_STATUS_SECURITY_STREAM_IS_INCONSISTENT", NT_STATUS_SECURITY_STREAM_IS_INCONSISTENT },
	{ "NT_STATUS_INVALID_ACE_CONDITION", NT_STATUS_INVALID_ACE_CONDITION },
	{ "NT_STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT", NT_STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT },
	{ "NT_STATUS_NOTIFICATION_GUID_ALREADY_DEFINED", NT_STATUS_NOTIFICATION_GUID_ALREADY_DEFINED },
	{ "NT_STATUS_NETWORK_OPEN_RESTRICTION", NT_STATUS_NETWORK_OPEN_RESTRICTION },
	{ "NT_STATUS_EVALUATION_EXPIRATION", NT_STATUS_EVALUATION_EXPIRATION },
	{ "NT_STATUS_ILLEGAL_DLL_RELOCATION", NT_STATUS_ILLEGAL_DLL_RELOCATION },
	{ "NT_STATUS_LICENSE_VIOLATION", NT_STATUS_LICENSE_VIOLATION },
	{ "NT_STATUS_DLL_INIT_FAILED_LOGOFF", NT_STATUS_DLL_INIT_FAILED_LOGOFF },
	{ "NT_STATUS_DRIVER_UNABLE_TO_LOAD", NT_STATUS_DRIVER_UNABLE_TO_LOAD },
	{ "NT_STATUS_DFS_UNAVAILABLE", NT_STATUS_DFS_UNAVAILABLE },
	{ "NT_STATUS_VOLUME_DISMOUNTED", NT_STATUS_VOLUME_DISMOUNTED },
	{ "NT_STATUS_WX86_INTERNAL_ERROR", NT_STATUS_WX86_INTERNAL_ERROR },
	{ "NT_STATUS_WX86_FLOAT_STACK_CHECK", NT_STATUS_WX86_FLOAT_STACK_CHECK },
	{ "NT_STATUS_VALIDATE_CONTINUE", NT_STATUS_VALIDATE_CONTINUE },
	{ "NT_STATUS_NO_MATCH", NT_STATUS_NO_MATCH },
	{ "NT_STATUS_NO_MORE_MATCHES", NT_STATUS_NO_MORE_MATCHES },
	{ "NT_STATUS_IO_REPARSE_TAG_INVALID", NT_STATUS_IO_REPARSE_TAG_INVALID },
	{ "NT_STATUS_IO_REPARSE_TAG_MISMATCH", NT_STATUS_IO_REPARSE_TAG_MISMATCH },
	{ "NT_STATUS_REPARSE_POINT_NOT_RESOLVED", NT_STATUS_REPARSE_POINT_NOT_RESOLVED },
	{ "NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT", NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT },
	{ "NT_STATUS_RANGE_LIST_CONFLICT", NT_STATUS_RANGE_LIST_CONFLICT },
	{ "NT_STATUS_SOURCE_ELEMENT_EMPTY", NT_STATUS_SOURCE_ELEMENT_EMPTY },
	{ "NT_STATUS_DESTINATION_ELEMENT_FULL", NT_STATUS_DESTINATION_ELEMENT_FULL },
	{ "NT_STATUS_ILLEGAL_ELEMENT_ADDRESS", NT_STATUS_ILLEGAL_ELEMENT_ADDRESS },
	{ "NT_STATUS_MAGAZINE_NOT_PRESENT", NT_STATUS_MAGAZINE_NOT_PRESENT },
	{ "NT_STATUS_REINITIALIZATION_NEEDED", NT_STATUS_REINITIALIZATION_NEEDED },
	{ "NT_STATUS_ENCRYPTION_FAILED", NT_STATUS_ENCRYPTION_FAILED },
	{ "NT_STATUS_DECRYPTION_FAILED", NT_STATUS_DECRYPTION_FAILED },
	{ "NT_STATUS_RANGE_NOT_FOUND", NT_STATUS_RANGE_NOT_FOUND },
	{ "NT_STATUS_NO_RECOVERY_POLICY", NT_STATUS_NO_RECOVERY_POLICY },
	{ "NT_STATUS_NO_EFS", NT_STATUS_NO_EFS },
	{ "NT_STATUS_WRONG_EFS", NT_STATUS_WRONG_EFS },
	{ "NT_STATUS_NO_USER_KEYS", NT_STATUS_NO_USER_KEYS },
	{ "NT_STATUS_FILE_NOT_ENCRYPTED", NT_STATUS_FILE_NOT_ENCRYPTED },
	{ "NT_STATUS_NOT_EXPORT_FORMAT", NT_STATUS_NOT_EXPORT_FORMAT },
	{ "NT_STATUS_FILE_ENCRYPTED", NT_STATUS_FILE_ENCRYPTED },
	{ "NT_STATUS_WMI_GUID_NOT_FOUND", NT_STATUS_WMI_GUID_NOT_FOUND },
	{ "NT_STATUS_WMI_INSTANCE_NOT_FOUND", NT_STATUS_WMI_INSTANCE_NOT_FOUND },
	{ "NT_STATUS_WMI_ITEMID_NOT_FOUND", NT_STATUS_WMI_ITEMID_NOT_FOUND },
	{ "NT_STATUS_WMI_TRY_AGAIN", NT_STATUS_WMI_TRY_AGAIN },
	{ "NT_STATUS_SHARED_POLICY", NT_STATUS_SHARED_POLICY },
	{ "NT_STATUS_POLICY_OBJECT_NOT_FOUND", NT_STATUS_POLICY_OBJECT_NOT_FOUND },
	{ "NT_STATUS_POLICY_ONLY_IN_DS", NT_STATUS_POLICY_ONLY_IN_DS },
	{ "NT_STATUS_VOLUME_NOT_UPGRADED", NT_STATUS_VOLUME_NOT_UPGRADED },
	{ "NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE", NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE },
	{ "NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR", NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR },
	{ "NT_STATUS_NO_TRACKING_SERVICE", NT_STATUS_NO_TRACKING_SERVICE },
	{ "NT_STATUS_SERVER_SID_MISMATCH", NT_STATUS_SERVER_SID_MISMATCH },
	{ "NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE", NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE },
	{ "NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX", NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX },
	{ "NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED", NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED },
	{ "NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS", NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS },
	{ "NT_STATUS_DS_BUSY", NT_STATUS_DS_BUSY },
	{ "NT_STATUS_DS_UNAVAILABLE", NT_STATUS_DS_UNAVAILABLE },
	{ "NT_STATUS_DS_NO_RIDS_ALLOCATED", NT_STATUS_DS_NO_RIDS_ALLOCATED },
	{ "NT_STATUS_DS_INCORRECT_ROLE_OWNER", NT_STATUS_DS_INCORRECT_ROLE_OWNER },
	{ "NT_STATUS_DS_RIDMGR_INIT_ERROR", NT_STATUS_DS_RIDMGR_INIT_ERROR },
	{ "NT_STATUS_DS_OBJ_CLASS_VIOLATION", NT_STATUS_DS_OBJ_CLASS_VIOLATION },
	{ "NT_STATUS_DS_CANT_ON_NON_LEAF", NT_STATUS_DS_CANT_ON_NON_LEAF },
	{ "NT_STATUS_DS_CANT_ON_RDN", NT_STATUS_DS_CANT_ON_RDN },
	{ "NT_STATUS_DS_CANT_MOD_OBJ_CLASS", NT_STATUS_DS_CANT_MOD_OBJ_CLASS },
	{ "NT_STATUS_DS_CROSS_DOM_MOVE_FAILED", NT_STATUS_DS_CROSS_DOM_MOVE_FAILED },
	{ "NT_STATUS_DS_GC_NOT_AVAILABLE", NT_STATUS_DS_GC_NOT_AVAILABLE },
	{ "NT_STATUS_DIRECTORY_SERVICE_REQUIRED", NT_STATUS_DIRECTORY_SERVICE_REQUIRED },
	{ "NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT", NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT },
	{ "NT_STATUS_CANT_ENABLE_DENY_ONLY", NT_STATUS_CANT_ENABLE_DENY_ONLY },
	{ "NT_STATUS_FLOAT_MULTIPLE_FAULTS", NT_STATUS_FLOAT_MULTIPLE_FAULTS },
	{ "NT_STATUS_FLOAT_MULTIPLE_TRAPS", NT_STATUS_FLOAT_MULTIPLE_TRAPS },
	{ "NT_STATUS_DEVICE_REMOVED", NT_STATUS_DEVICE_REMOVED },
	{ "NT_STATUS_JOURNAL_DELETE_IN_PROGRESS", NT_STATUS_JOURNAL_DELETE_IN_PROGRESS },
	{ "NT_STATUS_JOURNAL_NOT_ACTIVE", NT_STATUS_JOURNAL_NOT_ACTIVE },
	{ "NT_STATUS_NOINTERFACE", NT_STATUS_NOINTERFACE },
	{ "NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED", NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED },
	{ "NT_STATUS_DRIVER_FAILED_SLEEP", NT_STATUS_DRIVER_FAILED_SLEEP },
	{ "NT_STATUS_MUTUAL_AUTHENTICATION_FAILED", NT_STATUS_MUTUAL_AUTHENTICATION_FAILED },
	{ "NT_STATUS_CORRUPT_SYSTEM_FILE", NT_STATUS_CORRUPT_SYSTEM_FILE },
	{ "NT_STATUS_DATATYPE_MISALIGNMENT_ERROR", NT_STATUS_DATATYPE_MISALIGNMENT_ERROR },
	{ "NT_STATUS_WMI_READ_ONLY", NT_STATUS_WMI_READ_ONLY },
	{ "NT_STATUS_WMI_SET_FAILURE", NT_STATUS_WMI_SET_FAILURE },
	{ "NT_STATUS_COMMITMENT_MINIMUM", NT_STATUS_COMMITMENT_MINIMUM },
	{ "NT_STATUS_REG_NAT_CONSUMPTION", NT_STATUS_REG_NAT_CONSUMPTION },
	{ "NT_STATUS_TRANSPORT_FULL", NT_STATUS_TRANSPORT_FULL },
	{ "NT_STATUS_DS_SAM_INIT_FAILURE", NT_STATUS_DS_SAM_INIT_FAILURE },
	{ "NT_STATUS_ONLY_IF_CONNECTED", NT_STATUS_ONLY_IF_CONNECTED },
	{ "NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION", NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION },
	{ "NT_STATUS_PNP_RESTART_ENUMERATION", NT_STATUS_PNP_RESTART_ENUMERATION },
	{ "NT_STATUS_JOURNAL_ENTRY_DELETED", NT_STATUS_JOURNAL_ENTRY_DELETED },
	{ "NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID", NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID },
	{ "NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE", NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE },
	{ "NT_STATUS_PNP_REBOOT_REQUIRED", NT_STATUS_PNP_REBOOT_REQUIRED },
	{ "NT_STATUS_POWER_STATE_INVALID", NT_STATUS_POWER_STATE_INVALID },
	{ "NT_STATUS_DS_INVALID_GROUP_TYPE", NT_STATUS_DS_INVALID_GROUP_TYPE },
	{ "NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN", NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN },
	{ "NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN", NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN },
	{ "NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER", NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER },
	{ "NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER", NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER },
	{ "NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER", NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER },
	{ "NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER", NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER },
	{ "NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER", NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER },
	{ "NT_STATUS_DS_HAVE_PRIMARY_MEMBERS", NT_STATUS_DS_HAVE_PRIMARY_MEMBERS },
	{ "NT_STATUS_WMI_NOT_SUPPORTED", NT_STATUS_WMI_NOT_SUPPORTED },
	{ "NT_STATUS_INSUFFICIENT_POWER", NT_STATUS_INSUFFICIENT_POWER },
	{ "NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD", NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD },
	{ "NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY", NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY },
	{ "NT_STATUS_DS_CANT_START", NT_STATUS_DS_CANT_START },
	{ "NT_STATUS_DS_INIT_FAILURE", NT_STATUS_DS_INIT_FAILURE },
	{ "NT_STATUS_SAM_INIT_FAILURE", NT_STATUS_SAM_INIT_FAILURE },
	{ "NT_STATUS_DS_GC_REQUIRED", NT_STATUS_DS_GC_REQUIRED },
	{ "NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY", NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY },
	{ "NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS", NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS },
	{ "NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED", NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED },
	{ "NT_STATUS_CANNOT_MAKE", NT_STATUS_CANNOT_MAKE },
	{ "NT_STATUS_SYSTEM_SHUTDOWN", NT_STATUS_SYSTEM_SHUTDOWN },
	{ "NT_STATUS_DS_INIT_FAILURE_CONSOLE", NT_STATUS_DS_INIT_FAILURE_CONSOLE },
	{ "NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE", NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE },
	{ "NT_STATUS_UNFINISHED_CONTEXT_DELETED", NT_STATUS_UNFINISHED_CONTEXT_DELETED },
	{ "NT_STATUS_NO_TGT_REPLY", NT_STATUS_NO_TGT_REPLY },
	{ "NT_STATUS_NO_IP_ADDRESSES", NT_STATUS_NO_IP_ADDRESSES },
	{ "NT_STATUS_WRONG_CREDENTIAL_HANDLE", NT_STATUS_WRONG_CREDENTIAL_HANDLE },
	{ "NT_STATUS_CRYPTO_SYSTEM_INVALID", NT_STATUS_CRYPTO_SYSTEM_INVALID },
	{ "NT_STATUS_MAX_REFERRALS_EXCEEDED", NT_STATUS_MAX_REFERRALS_EXCEEDED },
	{ "NT_STATUS_MUST_BE_KDC", NT_STATUS_MUST_BE_KDC },
	{ "NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED", NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED },
	{ "NT_STATUS_TOO_MANY_PRINCIPALS", NT_STATUS_TOO_MANY_PRINCIPALS },
	{ "NT_STATUS_NO_PA_DATA", NT_STATUS_NO_PA_DATA },
	{ "NT_STATUS_PKINIT_NAME_MISMATCH", NT_STATUS_PKINIT_NAME_MISMATCH },
	{ "NT_STATUS_SMARTCARD_LOGON_REQUIRED", NT_STATUS_SMARTCARD_LOGON_REQUIRED },
	{ "NT_STATUS_KDC_INVALID_REQUEST", NT_STATUS_KDC_INVALID_REQUEST },
	{ "NT_STATUS_KDC_UNABLE_TO_REFER", NT_STATUS_KDC_UNABLE_TO_REFER },
	{ "NT_STATUS_KDC_UNKNOWN_ETYPE", NT_STATUS_KDC_UNKNOWN_ETYPE },
	{ "NT_STATUS_SHUTDOWN_IN_PROGRESS", NT_STATUS_SHUTDOWN_IN_PROGRESS },
	{ "NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS", NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS },
	{ "NT_STATUS_NOT_SUPPORTED_ON_SBS", NT_STATUS_NOT_SUPPORTED_ON_SBS },
	{ "NT_STATUS_WMI_GUID_DISCONNECTED", NT_STATUS_WMI_GUID_DISCONNECTED },
	{ "NT_STATUS_WMI_ALREADY_DISABLED", NT_STATUS_WMI_ALREADY_DISABLED },
	{ "NT_STATUS_WMI_ALREADY_ENABLED", NT_STATUS_WMI_ALREADY_ENABLED },
	{ "NT_STATUS_MFT_TOO_FRAGMENTED", NT_STATUS_MFT_TOO_FRAGMENTED },
	{ "NT_STATUS_COPY_PROTECTION_FAILURE", NT_STATUS_COPY_PROTECTION_FAILURE },
	{ "NT_STATUS_CSS_AUTHENTICATION_FAILURE", NT_STATUS_CSS_AUTHENTICATION_FAILURE },
	{ "NT_STATUS_CSS_KEY_NOT_PRESENT", NT_STATUS_CSS_KEY_NOT_PRESENT },
	{ "NT_STATUS_CSS_KEY_NOT_ESTABLISHED", NT_STATUS_CSS_KEY_NOT_ESTABLISHED },
	{ "NT_STATUS_CSS_SCRAMBLED_SECTOR", NT_STATUS_CSS_SCRAMBLED_SECTOR },
	{ "NT_STATUS_CSS_REGION_MISMATCH", NT_STATUS_CSS_REGION_MISMATCH },
	{ "NT_STATUS_CSS_RESETS_EXHAUSTED", NT_STATUS_CSS_RESETS_EXHAUSTED },
	{ "NT_STATUS_PKINIT_FAILURE", NT_STATUS_PKINIT_FAILURE },
	{ "NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE", NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE },
	{ "NT_STATUS_NO_KERB_KEY", NT_STATUS_NO_KERB_KEY },
	{ "NT_STATUS_HOST_DOWN", NT_STATUS_HOST_DOWN },
	{ "NT_STATUS_UNSUPPORTED_PREAUTH", NT_STATUS_UNSUPPORTED_PREAUTH },
	{ "NT_STATUS_EFS_ALG_BLOB_TOO_BIG", NT_STATUS_EFS_ALG_BLOB_TOO_BIG },
	{ "NT_STATUS_PORT_NOT_SET", NT_STATUS_PORT_NOT_SET },
	{ "NT_STATUS_DEBUGGER_INACTIVE", NT_STATUS_DEBUGGER_INACTIVE },
	{ "NT_STATUS_DS_VERSION_CHECK_FAILURE", NT_STATUS_DS_VERSION_CHECK_FAILURE },
	{ "NT_STATUS_AUDITING_DISABLED", NT_STATUS_AUDITING_DISABLED },
	{ "NT_STATUS_PRENT4_MACHINE_ACCOUNT", NT_STATUS_PRENT4_MACHINE_ACCOUNT },
	{ "NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER", NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER },
	{ "NT_STATUS_INVALID_IMAGE_WIN_32", NT_STATUS_INVALID_IMAGE_WIN_32 },
	{ "NT_STATUS_INVALID_IMAGE_WIN_64", NT_STATUS_INVALID_IMAGE_WIN_64 },
	{ "NT_STATUS_BAD_BINDINGS", NT_STATUS_BAD_BINDINGS },
	{ "NT_STATUS_APPHELP_BLOCK", NT_STATUS_APPHELP_BLOCK },
	{ "NT_STATUS_NOT_SAFE_MODE_DRIVER", NT_STATUS_NOT_SAFE_MODE_DRIVER },
	{ "NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT", NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT },
	{ "NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH", NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH },
	{ "NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER", NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER },
	{ "NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER", NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER },
	{ "NT_STATUS_FAILED_DRIVER_ENTRY", NT_STATUS_FAILED_DRIVER_ENTRY },
	{ "NT_STATUS_DEVICE_ENUMERATION_ERROR", NT_STATUS_DEVICE_ENUMERATION_ERROR },
	{ "NT_STATUS_MOUNT_POINT_NOT_RESOLVED", NT_STATUS_MOUNT_POINT_NOT_RESOLVED },
	{ "NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER", NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER },
	{ "NT_STATUS_MCA_OCCURED", NT_STATUS_MCA_OCCURED },
	{ "NT_STATUS_DRIVER_BLOCKED_CRITICAL", NT_STATUS_DRIVER_BLOCKED_CRITICAL },
	{ "NT_STATUS_DRIVER_BLOCKED", NT_STATUS_DRIVER_BLOCKED },
	{ "NT_STATUS_DRIVER_DATABASE_ERROR", NT_STATUS_DRIVER_DATABASE_ERROR },
	{ "NT_STATUS_SYSTEM_HIVE_TOO_LARGE", NT_STATUS_SYSTEM_HIVE_TOO_LARGE },
	{ "NT_STATUS_INVALID_IMPORT_OF_NON_DLL", NT_STATUS_INVALID_IMPORT_OF_NON_DLL },
	{ "NT_STATUS_NO_SECRETS", NT_STATUS_NO_SECRETS },
	{ "NT_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY", NT_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY },
	{ "NT_STATUS_FAILED_STACK_SWITCH", NT_STATUS_FAILED_STACK_SWITCH },
	{ "NT_STATUS_HEAP_CORRUPTION", NT_STATUS_HEAP_CORRUPTION },
	{ "NT_STATUS_SMARTCARD_WRONG_PIN", NT_STATUS_SMARTCARD_WRONG_PIN },
	{ "NT_STATUS_SMARTCARD_CARD_BLOCKED", NT_STATUS_SMARTCARD_CARD_BLOCKED },
	{ "NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED", NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED },
	{ "NT_STATUS_SMARTCARD_NO_CARD", NT_STATUS_SMARTCARD_NO_CARD },
	{ "NT_STATUS_SMARTCARD_NO_KEY_CONTAINER", NT_STATUS_SMARTCARD_NO_KEY_CONTAINER },
	{ "NT_STATUS_SMARTCARD_NO_CERTIFICATE", NT_STATUS_SMARTCARD_NO_CERTIFICATE },
	{ "NT_STATUS_SMARTCARD_NO_KEYSET", NT_STATUS_SMARTCARD_NO_KEYSET },
	{ "NT_STATUS_SMARTCARD_IO_ERROR", NT_STATUS_SMARTCARD_IO_ERROR },
	{ "NT_STATUS_SMARTCARD_CERT_REVOKED", NT_STATUS_SMARTCARD_CERT_REVOKED },
	{ "NT_STATUS_ISSUING_CA_UNTRUSTED", NT_STATUS_ISSUING_CA_UNTRUSTED },
	{ "NT_STATUS_REVOCATION_OFFLINE_C", NT_STATUS_REVOCATION_OFFLINE_C },
	{ "NT_STATUS_PKINIT_CLIENT_FAILURE", NT_STATUS_PKINIT_CLIENT_FAILURE },
	{ "NT_STATUS_SMARTCARD_CERT_EXPIRED", NT_STATUS_SMARTCARD_CERT_EXPIRED },
	{ "NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD", NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD },
	{ "NT_STATUS_SMARTCARD_SILENT_CONTEXT", NT_STATUS_SMARTCARD_SILENT_CONTEXT },
	{ "NT_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED", NT_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED },
	{ "NT_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED", NT_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED },
	{ "NT_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED", NT_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED },
	{ "NT_STATUS_DS_NAME_NOT_UNIQUE", NT_STATUS_DS_NAME_NOT_UNIQUE },
	{ "NT_STATUS_DS_DUPLICATE_ID_FOUND", NT_STATUS_DS_DUPLICATE_ID_FOUND },
	{ "NT_STATUS_DS_GROUP_CONVERSION_ERROR", NT_STATUS_DS_GROUP_CONVERSION_ERROR },
	{ "NT_STATUS_VOLSNAP_PREPARE_HIBERNATE", NT_STATUS_VOLSNAP_PREPARE_HIBERNATE },
	{ "NT_STATUS_USER2USER_REQUIRED", NT_STATUS_USER2USER_REQUIRED },
	{ "NT_STATUS_STACK_BUFFER_OVERRUN", NT_STATUS_STACK_BUFFER_OVERRUN },
	{ "NT_STATUS_REVOCATION_OFFLINE_KDC", NT_STATUS_REVOCATION_OFFLINE_KDC },
	{ "NT_STATUS_ISSUING_CA_UNTRUSTED_KDC", NT_STATUS_ISSUING_CA_UNTRUSTED_KDC },
	{ "NT_STATUS_KDC_CERT_EXPIRED", NT_STATUS_KDC_CERT_EXPIRED },
	{ "NT_STATUS_KDC_CERT_REVOKED", NT_STATUS_KDC_CERT_REVOKED },
	{ "NT_STATUS_PARAMETER_QUOTA_EXCEEDED", NT_STATUS_PARAMETER_QUOTA_EXCEEDED },
	{ "NT_STATUS_HIBERNATION_FAILURE", NT_STATUS_HIBERNATION_FAILURE },
	{ "NT_STATUS_DELAY_LOAD_FAILED", NT_STATUS_DELAY_LOAD_FAILED },
	{ "NT_STATUS_AUTHENTICATION_FIREWALL_FAILED", NT_STATUS_AUTHENTICATION_FIREWALL_FAILED },
	{ "NT_STATUS_VDM_DISALLOWED", NT_STATUS_VDM_DISALLOWED },
	{ "NT_STATUS_HUNG_DISPLAY_DRIVER_THREAD", NT_STATUS_HUNG_DISPLAY_DRIVER_THREAD },
	{ "NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE", NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE },
	{ "NT_STATUS_INVALID_CRUNTIME_PARAMETER", NT_STATUS_INVALID_CRUNTIME_PARAMETER },
	{ "NT_STATUS_NTLM_BLOCKED", NT_STATUS_NTLM_BLOCKED },
	{ "NT_STATUS_DS_SRC_SID_EXISTS_IN_FOREST", NT_STATUS_DS_SRC_SID_EXISTS_IN_FOREST },
	{ "NT_STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST", NT_STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST },
	{ "NT_STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST", NT_STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST },
	{ "NT_STATUS_INVALID_USER_PRINCIPAL_NAME", NT_STATUS_INVALID_USER_PRINCIPAL_NAME },
	{ "NT_STATUS_ASSERTION_FAILURE", NT_STATUS_ASSERTION_FAILURE },
	{ "NT_STATUS_VERIFIER_STOP", NT_STATUS_VERIFIER_STOP },
	{ "NT_STATUS_CALLBACK_POP_STACK", NT_STATUS_CALLBACK_POP_STACK },
	{ "NT_STATUS_INCOMPATIBLE_DRIVER_BLOCKED", NT_STATUS_INCOMPATIBLE_DRIVER_BLOCKED },
	{ "NT_STATUS_HIVE_UNLOADED", NT_STATUS_HIVE_UNLOADED },
	{ "NT_STATUS_COMPRESSION_DISABLED", NT_STATUS_COMPRESSION_DISABLED },
	{ "NT_STATUS_FILE_SYSTEM_LIMITATION", NT_STATUS_FILE_SYSTEM_LIMITATION },
	{ "NT_STATUS_INVALID_IMAGE_HASH", NT_STATUS_INVALID_IMAGE_HASH },
	{ "NT_STATUS_NOT_CAPABLE", NT_STATUS_NOT_CAPABLE },
	{ "NT_STATUS_REQUEST_OUT_OF_SEQUENCE", NT_STATUS_REQUEST_OUT_OF_SEQUENCE },
	{ "NT_STATUS_IMPLEMENTATION_LIMIT", NT_STATUS_IMPLEMENTATION_LIMIT },
	{ "NT_STATUS_ELEVATION_REQUIRED", NT_STATUS_ELEVATION_REQUIRED },
	{ "NT_STATUS_NO_SECURITY_CONTEXT", NT_STATUS_NO_SECURITY_CONTEXT },
	{ "NT_STATUS_PKU2U_CERT_FAILURE", NT_STATUS_PKU2U_CERT_FAILURE },
	{ "NT_STATUS_BEYOND_VDL", NT_STATUS_BEYOND_VDL },
	{ "NT_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS", NT_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS },
	{ "NT_STATUS_PTE_CHANGED", NT_STATUS_PTE_CHANGED },
	{ "NT_STATUS_PURGE_FAILED", NT_STATUS_PURGE_FAILED },
	{ "NT_STATUS_CRED_REQUIRES_CONFIRMATION", NT_STATUS_CRED_REQUIRES_CONFIRMATION },
	{ "NT_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE", NT_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE },
	{ "NT_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER", NT_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER },
	{ "NT_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE", NT_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE },
	{ "NT_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE", NT_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE },
	{ "NT_STATUS_CS_ENCRYPTION_FILE_NOT_CSE", NT_STATUS_CS_ENCRYPTION_FILE_NOT_CSE },
	{ "NT_STATUS_INVALID_LABEL", NT_STATUS_INVALID_LABEL },
	{ "NT_STATUS_DRIVER_PROCESS_TERMINATED", NT_STATUS_DRIVER_PROCESS_TERMINATED },
	{ "NT_STATUS_AMBIGUOUS_SYSTEM_DEVICE", NT_STATUS_AMBIGUOUS_SYSTEM_DEVICE },
	{ "NT_STATUS_SYSTEM_DEVICE_NOT_FOUND", NT_STATUS_SYSTEM_DEVICE_NOT_FOUND },
	{ "NT_STATUS_RESTART_BOOT_APPLICATION", NT_STATUS_RESTART_BOOT_APPLICATION },
	{ "NT_STATUS_INSUFFICIENT_NVRAM_RESOURCES", NT_STATUS_INSUFFICIENT_NVRAM_RESOURCES },
	{ "NT_STATUS_NO_RANGES_PROCESSED", NT_STATUS_NO_RANGES_PROCESSED },
	{ "NT_STATUS_DEVICE_FEATURE_NOT_SUPPORTED", NT_STATUS_DEVICE_FEATURE_NOT_SUPPORTED },
	{ "NT_STATUS_DEVICE_UNREACHABLE", NT_STATUS_DEVICE_UNREACHABLE },
	{ "NT_STATUS_INVALID_TOKEN", NT_STATUS_INVALID_TOKEN },
	{ "NT_STATUS_INVALID_TASK_NAME", NT_STATUS_INVALID_TASK_NAME },
	{ "NT_STATUS_INVALID_TASK_INDEX", NT_STATUS_INVALID_TASK_INDEX },
	{ "NT_STATUS_THREAD_ALREADY_IN_TASK", NT_STATUS_THREAD_ALREADY_IN_TASK },
	{ "NT_STATUS_CALLBACK_BYPASS", NT_STATUS_CALLBACK_BYPASS },
	{ "NT_STATUS_FAIL_FAST_EXCEPTION", NT_STATUS_FAIL_FAST_EXCEPTION },
	{ "NT_STATUS_IMAGE_CERT_REVOKED", NT_STATUS_IMAGE_CERT_REVOKED },
	{ "NT_STATUS_PORT_CLOSED", NT_STATUS_PORT_CLOSED },
	{ "NT_STATUS_MESSAGE_LOST", NT_STATUS_MESSAGE_LOST },
	{ "NT_STATUS_INVALID_MESSAGE", NT_STATUS_INVALID_MESSAGE },
	{ "NT_STATUS_REQUEST_CANCELED", NT_STATUS_REQUEST_CANCELED },
	{ "NT_STATUS_RECURSIVE_DISPATCH", NT_STATUS_RECURSIVE_DISPATCH },
	{ "NT_STATUS_LPC_RECEIVE_BUFFER_EXPECTED", NT_STATUS_LPC_RECEIVE_BUFFER_EXPECTED },
	{ "NT_STATUS_LPC_INVALID_CONNECTION_USAGE", NT_STATUS_LPC_INVALID_CONNECTION_USAGE },
	{ "NT_STATUS_LPC_REQUESTS_NOT_ALLOWED", NT_STATUS_LPC_REQUESTS_NOT_ALLOWED },
	{ "NT_STATUS_RESOURCE_IN_USE", NT_STATUS_RESOURCE_IN_USE },
	{ "NT_STATUS_HARDWARE_MEMORY_ERROR", NT_STATUS_HARDWARE_MEMORY_ERROR },
	{ "NT_STATUS_THREADPOOL_HANDLE_EXCEPTION", NT_STATUS_THREADPOOL_HANDLE_EXCEPTION },
	{ "NT_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED", NT_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED },
	{ "NT_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED", NT_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED },
	{ "NT_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED", NT_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED },
	{ "NT_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED", NT_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED },
	{ "NT_STATUS_THREADPOOL_RELEASED_DURING_OPERATION", NT_STATUS_THREADPOOL_RELEASED_DURING_OPERATION },
	{ "NT_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING", NT_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING },
	{ "NT_STATUS_APC_RETURNED_WHILE_IMPERSONATING", NT_STATUS_APC_RETURNED_WHILE_IMPERSONATING },
	{ "NT_STATUS_PROCESS_IS_PROTECTED", NT_STATUS_PROCESS_IS_PROTECTED },
	{ "NT_STATUS_MCA_EXCEPTION", NT_STATUS_MCA_EXCEPTION },
	{ "NT_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE", NT_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE },
	{ "NT_STATUS_SYMLINK_CLASS_DISABLED", NT_STATUS_SYMLINK_CLASS_DISABLED },
	{ "NT_STATUS_INVALID_IDN_NORMALIZATION", NT_STATUS_INVALID_IDN_NORMALIZATION },
	{ "NT_STATUS_NO_UNICODE_TRANSLATION", NT_STATUS_NO_UNICODE_TRANSLATION },
	{ "NT_STATUS_ALREADY_REGISTERED", NT_STATUS_ALREADY_REGISTERED },
	{ "NT_STATUS_CONTEXT_MISMATCH", NT_STATUS_CONTEXT_MISMATCH },
	{ "NT_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST", NT_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST },
	{ "NT_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY", NT_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY },
	{ "NT_STATUS_INVALID_THREAD", NT_STATUS_INVALID_THREAD },
	{ "NT_STATUS_CALLBACK_RETURNED_TRANSACTION", NT_STATUS_CALLBACK_RETURNED_TRANSACTION },
	{ "NT_STATUS_CALLBACK_RETURNED_LDR_LOCK", NT_STATUS_CALLBACK_RETURNED_LDR_LOCK },
	{ "NT_STATUS_CALLBACK_RETURNED_LANG", NT_STATUS_CALLBACK_RETURNED_LANG },
	{ "NT_STATUS_CALLBACK_RETURNED_PRI_BACK", NT_STATUS_CALLBACK_RETURNED_PRI_BACK },
	{ "NT_STATUS_DISK_REPAIR_DISABLED", NT_STATUS_DISK_REPAIR_DISABLED },
	{ "NT_STATUS_DS_DOMAIN_RENAME_IN_PROGRESS", NT_STATUS_DS_DOMAIN_RENAME_IN_PROGRESS },
	{ "NT_STATUS_DISK_QUOTA_EXCEEDED", NT_STATUS_DISK_QUOTA_EXCEEDED },
	{ "NT_STATUS_CONTENT_BLOCKED", NT_STATUS_CONTENT_BLOCKED },
	{ "NT_STATUS_BAD_CLUSTERS", NT_STATUS_BAD_CLUSTERS },
	{ "NT_STATUS_VOLUME_DIRTY", NT_STATUS_VOLUME_DIRTY },
	{ "NT_STATUS_FILE_CHECKED_OUT", NT_STATUS_FILE_CHECKED_OUT },
	{ "NT_STATUS_CHECKOUT_REQUIRED", NT_STATUS_CHECKOUT_REQUIRED },
	{ "NT_STATUS_BAD_FILE_TYPE", NT_STATUS_BAD_FILE_TYPE },
	{ "NT_STATUS_FILE_TOO_LARGE", NT_STATUS_FILE_TOO_LARGE },
	{ "NT_STATUS_FORMS_AUTH_REQUIRED", NT_STATUS_FORMS_AUTH_REQUIRED },
	{ "NT_STATUS_VIRUS_INFECTED", NT_STATUS_VIRUS_INFECTED },
	{ "NT_STATUS_VIRUS_DELETED", NT_STATUS_VIRUS_DELETED },
	{ "NT_STATUS_BAD_MCFG_TABLE", NT_STATUS_BAD_MCFG_TABLE },
	{ "NT_STATUS_CANNOT_BREAK_OPLOCK", NT_STATUS_CANNOT_BREAK_OPLOCK },
	{ "NT_STATUS_WOW_ASSERTION", NT_STATUS_WOW_ASSERTION },
	{ "NT_STATUS_INVALID_SIGNATURE", NT_STATUS_INVALID_SIGNATURE },
	{ "NT_STATUS_HMAC_NOT_SUPPORTED", NT_STATUS_HMAC_NOT_SUPPORTED },
	{ "NT_STATUS_IPSEC_QUEUE_OVERFLOW", NT_STATUS_IPSEC_QUEUE_OVERFLOW },
	{ "NT_STATUS_ND_QUEUE_OVERFLOW", NT_STATUS_ND_QUEUE_OVERFLOW },
	{ "NT_STATUS_HOPLIMIT_EXCEEDED", NT_STATUS_HOPLIMIT_EXCEEDED },
	{ "NT_STATUS_PROTOCOL_NOT_SUPPORTED", NT_STATUS_PROTOCOL_NOT_SUPPORTED },
	{ "NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED", NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED },
	{ "NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR", NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR },
	{ "NT_STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR", NT_STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR },
	{ "NT_STATUS_XML_PARSE_ERROR", NT_STATUS_XML_PARSE_ERROR },
	{ "NT_STATUS_XMLDSIG_ERROR", NT_STATUS_XMLDSIG_ERROR },
	{ "NT_STATUS_WRONG_COMPARTMENT", NT_STATUS_WRONG_COMPARTMENT },
	{ "NT_STATUS_AUTHIP_FAILURE", NT_STATUS_AUTHIP_FAILURE },
	{ "NT_STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS", NT_STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS },
	{ "NT_STATUS_DS_OID_NOT_FOUND", NT_STATUS_DS_OID_NOT_FOUND },
	{ "NT_STATUS_HASH_NOT_SUPPORTED", NT_STATUS_HASH_NOT_SUPPORTED },
	{ "NT_STATUS_HASH_NOT_PRESENT", NT_STATUS_HASH_NOT_PRESENT },
	{ "NT_STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED", NT_STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED },
	{ "NT_STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED", NT_STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED },
	{ "NT_STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED", NT_STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED },
	{ "NT_STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED", NT_STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED },
	{ "NT_STATUS_DBG_NO_STATE_CHANGE", NT_STATUS_DBG_NO_STATE_CHANGE },
	{ "NT_STATUS_DBG_APP_NOT_IDLE", NT_STATUS_DBG_APP_NOT_IDLE },
	{ "NT_STATUS_RPC_INVALID_STRING_BINDING", NT_STATUS_RPC_INVALID_STRING_BINDING },
	{ "NT_STATUS_RPC_WRONG_KIND_OF_BINDING", NT_STATUS_RPC_WRONG_KIND_OF_BINDING },
	{ "NT_STATUS_RPC_INVALID_BINDING", NT_STATUS_RPC_INVALID_BINDING },
	{ "NT_STATUS_RPC_INVALID_RPC_PROTSEQ", NT_STATUS_RPC_INVALID_RPC_PROTSEQ },
	{ "NT_STATUS_RPC_INVALID_STRING_UUID", NT_STATUS_RPC_INVALID_STRING_UUID },
	{ "NT_STATUS_RPC_INVALID_ENDPOINT_FORMAT", NT_STATUS_RPC_INVALID_ENDPOINT_FORMAT },
	{ "NT_STATUS_RPC_INVALID_NET_ADDR", NT_STATUS_RPC_INVALID_NET_ADDR },
	{ "NT_STATUS_RPC_NO_ENDPOINT_FOUND", NT_STATUS_RPC_NO_ENDPOINT_FOUND },
	{ "NT_STATUS_RPC_INVALID_TIMEOUT", NT_STATUS_RPC_INVALID_TIMEOUT },
	{ "NT_STATUS_RPC_OBJECT_NOT_FOUND", NT_STATUS_RPC_OBJECT_NOT_FOUND },
	{ "NT_STATUS_RPC_ALREADY_REGISTERED", NT_STATUS_RPC_ALREADY_REGISTERED },
	{ "NT_STATUS_RPC_TYPE_ALREADY_REGISTERED", NT_STATUS_RPC_TYPE_ALREADY_REGISTERED },
	{ "NT_STATUS_RPC_ALREADY_LISTENING", NT_STATUS_RPC_ALREADY_LISTENING },
	{ "NT_STATUS_RPC_NO_PROTSEQS_REGISTERED", NT_STATUS_RPC_NO_PROTSEQS_REGISTERED },
	{ "NT_STATUS_RPC_NOT_LISTENING", NT_STATUS_RPC_NOT_LISTENING },
	{ "NT_STATUS_RPC_UNKNOWN_MGR_TYPE", NT_STATUS_RPC_UNKNOWN_MGR_TYPE },
	{ "NT_STATUS_RPC_NO_BINDINGS", NT_STATUS_RPC_NO_BINDINGS },
	{ "NT_STATUS_RPC_NO_PROTSEQS", NT_STATUS_RPC_NO_PROTSEQS },
	{ "NT_STATUS_RPC_CANT_CREATE_ENDPOINT", NT_STATUS_RPC_CANT_CREATE_ENDPOINT },
	{ "NT_STATUS_RPC_OUT_OF_RESOURCES", NT_STATUS_RPC_OUT_OF_RESOURCES },
	{ "NT_STATUS_RPC_SERVER_UNAVAILABLE", NT_STATUS_RPC_SERVER_UNAVAILABLE },
	{ "NT_STATUS_RPC_SERVER_TOO_BUSY", NT_STATUS_RPC_SERVER_TOO_BUSY },
	{ "NT_STATUS_RPC_INVALID_NETWORK_OPTIONS", NT_STATUS_RPC_INVALID_NETWORK_OPTIONS },
	{ "NT_STATUS_RPC_NO_CALL_ACTIVE", NT_STATUS_RPC_NO_CALL_ACTIVE },
	{ "NT_STATUS_RPC_CALL_FAILED_DNE", NT_STATUS_RPC_CALL_FAILED_DNE },
	{ "NT_STATUS_RPC_UNSUPPORTED_TRANS_SYN", NT_STATUS_RPC_UNSUPPORTED_TRANS_SYN },
	{ "NT_STATUS_RPC_UNSUPPORTED_TYPE", NT_STATUS_RPC_UNSUPPORTED_TYPE },
	{ "NT_STATUS_RPC_INVALID_TAG", NT_STATUS_RPC_INVALID_TAG },
	{ "NT_STATUS_RPC_INVALID_BOUND", NT_STATUS_RPC_INVALID_BOUND },
	{ "NT_STATUS_RPC_NO_ENTRY_NAME", NT_STATUS_RPC_NO_ENTRY_NAME },
	{ "NT_STATUS_RPC_INVALID_NAME_SYNTAX", NT_STATUS_RPC_INVALID_NAME_SYNTAX },
	{ "NT_STATUS_RPC_UUID_NO_ADDRESS", NT_STATUS_RPC_UUID_NO_ADDRESS },
	{ "NT_STATUS_RPC_DUPLICATE_ENDPOINT", NT_STATUS_RPC_DUPLICATE_ENDPOINT },
	{ "NT_STATUS_RPC_UNKNOWN_AUTHN_TYPE", NT_STATUS_RPC_UNKNOWN_AUTHN_TYPE },
	{ "NT_STATUS_RPC_MAX_CALLS_TOO_SMALL", NT_STATUS_RPC_MAX_CALLS_TOO_SMALL },
	{ "NT_STATUS_RPC_STRING_TOO_LONG", NT_STATUS_RPC_STRING_TOO_LONG },
	{ "NT_STATUS_RPC_PROTSEQ_NOT_FOUND", NT_STATUS_RPC_PROTSEQ_NOT_FOUND },
	{ "NT_STATUS_RPC_BINDING_HAS_NO_AUTH", NT_STATUS_RPC_BINDING_HAS_NO_AUTH },
	{ "NT_STATUS_RPC_UNKNOWN_AUTHN_SERVICE", NT_STATUS_RPC_UNKNOWN_AUTHN_SERVICE },
	{ "NT_STATUS_RPC_UNKNOWN_AUTHN_LEVEL", NT_STATUS_RPC_UNKNOWN_AUTHN_LEVEL },
	{ "NT_STATUS_RPC_INVALID_AUTH_IDENTITY", NT_STATUS_RPC_INVALID_AUTH_IDENTITY },
	{ "NT_STATUS_RPC_UNKNOWN_AUTHZ_SERVICE", NT_STATUS_RPC_UNKNOWN_AUTHZ_SERVICE },
	{ "NT_STATUS_EPT_INVALID_ENTRY", NT_STATUS_EPT_INVALID_ENTRY },
	{ "NT_STATUS_EPT_CANT_PERFORM_OP", NT_STATUS_EPT_CANT_PERFORM_OP },
	{ "NT_STATUS_EPT_NOT_REGISTERED", NT_STATUS_EPT_NOT_REGISTERED },
	{ "NT_STATUS_RPC_NOTHING_TO_EXPORT", NT_STATUS_RPC_NOTHING_TO_EXPORT },
	{ "NT_STATUS_RPC_INCOMPLETE_NAME", NT_STATUS_RPC_INCOMPLETE_NAME },
	{ "NT_STATUS_RPC_INVALID_VERS_OPTION", NT_STATUS_RPC_INVALID_VERS_OPTION },
	{ "NT_STATUS_RPC_NO_MORE_MEMBERS", NT_STATUS_RPC_NO_MORE_MEMBERS },
	{ "NT_STATUS_RPC_NOT_ALL_OBJS_UNEXPORTED", NT_STATUS_RPC_NOT_ALL_OBJS_UNEXPORTED },
	{ "NT_STATUS_RPC_INTERFACE_NOT_FOUND", NT_STATUS_RPC_INTERFACE_NOT_FOUND },
	{ "NT_STATUS_RPC_ENTRY_ALREADY_EXISTS", NT_STATUS_RPC_ENTRY_ALREADY_EXISTS },
	{ "NT_STATUS_RPC_ENTRY_NOT_FOUND", NT_STATUS_RPC_ENTRY_NOT_FOUND },
	{ "NT_STATUS_RPC_NAME_SERVICE_UNAVAILABLE", NT_STATUS_RPC_NAME_SERVICE_UNAVAILABLE },
	{ "NT_STATUS_RPC_INVALID_NAF_ID", NT_STATUS_RPC_INVALID_NAF_ID },
	{ "NT_STATUS_RPC_NO_CONTEXT_AVAILABLE", NT_STATUS_RPC_NO_CONTEXT_AVAILABLE },
	{ "NT_STATUS_RPC_INTERNAL_ERROR", NT_STATUS_RPC_INTERNAL_ERROR },
	{ "NT_STATUS_RPC_ZERO_DIVIDE", NT_STATUS_RPC_ZERO_DIVIDE },
	{ "NT_STATUS_RPC_ADDRESS_ERROR", NT_STATUS_RPC_ADDRESS_ERROR },
	{ "NT_STATUS_RPC_FP_DIV_ZERO", NT_STATUS_RPC_FP_DIV_ZERO },
	{ "NT_STATUS_RPC_FP_UNDERFLOW", NT_STATUS_RPC_FP_UNDERFLOW },
	{ "NT_STATUS_RPC_FP_OVERFLOW", NT_STATUS_RPC_FP_OVERFLOW },
	{ "NT_STATUS_RPC_CALL_IN_PROGRESS", NT_STATUS_RPC_CALL_IN_PROGRESS },
	{ "NT_STATUS_RPC_NO_MORE_BINDINGS", NT_STATUS_RPC_NO_MORE_BINDINGS },
	{ "NT_STATUS_RPC_GROUP_MEMBER_NOT_FOUND", NT_STATUS_RPC_GROUP_MEMBER_NOT_FOUND },
	{ "NT_STATUS_EPT_CANT_CREATE", NT_STATUS_EPT_CANT_CREATE },
	{ "NT_STATUS_RPC_INVALID_OBJECT", NT_STATUS_RPC_INVALID_OBJECT },
	{ "NT_STATUS_RPC_NO_INTERFACES", NT_STATUS_RPC_NO_INTERFACES },
	{ "NT_STATUS_RPC_CALL_CANCELLED", NT_STATUS_RPC_CALL_CANCELLED },
	{ "NT_STATUS_RPC_BINDING_INCOMPLETE", NT_STATUS_RPC_BINDING_INCOMPLETE },
	{ "NT_STATUS_RPC_COMM_FAILURE", NT_STATUS_RPC_COMM_FAILURE },
	{ "NT_STATUS_RPC_UNSUPPORTED_AUTHN_LEVEL", NT_STATUS_RPC_UNSUPPORTED_AUTHN_LEVEL },
	{ "NT_STATUS_RPC_NO_PRINC_NAME", NT_STATUS_RPC_NO_PRINC_NAME },
	{ "NT_STATUS_RPC_NOT_RPC_ERROR", NT_STATUS_RPC_NOT_RPC_ERROR },
	{ "NT_STATUS_RPC_NOT_CANCELLED", NT_STATUS_RPC_NOT_CANCELLED },
	{ "NT_STATUS_RPC_INVALID_ASYNC_HANDLE", NT_STATUS_RPC_INVALID_ASYNC_HANDLE },
	{ "NT_STATUS_RPC_INVALID_ASYNC_CALL", NT_STATUS_RPC_INVALID_ASYNC_CALL },
	{ "NT_STATUS_RPC_PROXY_ACCESS_DENIED", NT_STATUS_RPC_PROXY_ACCESS_DENIED },
	{ "NT_STATUS_RPC_NO_MORE_ENTRIES", NT_STATUS_RPC_NO_MORE_ENTRIES },
	{ "NT_STATUS_RPC_SS_CHAR_TRANS_OPEN_FAIL", NT_STATUS_RPC_SS_CHAR_TRANS_OPEN_FAIL },
	{ "NT_STATUS_RPC_SS_CHAR_TRANS_SHORT_FILE", NT_STATUS_RPC_SS_CHAR_TRANS_SHORT_FILE },
	{ "NT_STATUS_RPC_SS_IN_NULL_CONTEXT", NT_STATUS_RPC_SS_IN_NULL_CONTEXT },
	{ "NT_STATUS_RPC_SS_CONTEXT_DAMAGED", NT_STATUS_RPC_SS_CONTEXT_DAMAGED },
	{ "NT_STATUS_RPC_SS_HANDLES_MISMATCH", NT_STATUS_RPC_SS_HANDLES_MISMATCH },
	{ "NT_STATUS_RPC_SS_CANNOT_GET_CALL_HANDLE", NT_STATUS_RPC_SS_CANNOT_GET_CALL_HANDLE },
	{ "NT_STATUS_RPC_NULL_REF_POINTER", NT_STATUS_RPC_NULL_REF_POINTER },
	{ "NT_STATUS_RPC_BYTE_COUNT_TOO_SMALL", NT_STATUS_RPC_BYTE_COUNT_TOO_SMALL },
	{ "NT_STATUS_RPC_INVALID_ES_ACTION", NT_STATUS_RPC_INVALID_ES_ACTION },
	{ "NT_STATUS_RPC_WRONG_ES_VERSION", NT_STATUS_RPC_WRONG_ES_VERSION },
	{ "NT_STATUS_RPC_WRONG_STUB_VERSION", NT_STATUS_RPC_WRONG_STUB_VERSION },
	{ "NT_STATUS_PNP_BAD_MPS_TABLE", NT_STATUS_PNP_BAD_MPS_TABLE },
	{ "NT_STATUS_PNP_TRANSLATION_FAILED", NT_STATUS_PNP_TRANSLATION_FAILED },
	{ "NT_STATUS_PNP_IRQ_TRANSLATION_FAILED", NT_STATUS_PNP_IRQ_TRANSLATION_FAILED },
	{ "NT_STATUS_PNP_INVALID_ID", NT_STATUS_PNP_INVALID_ID },
	{ "NT_STATUS_IO_REISSUE_AS_CACHED", NT_STATUS_IO_REISSUE_AS_CACHED },
	{ "NT_STATUS_CTX_WINSTATION_NAME_INVALID", NT_STATUS_CTX_WINSTATION_NAME_INVALID },
	{ "NT_STATUS_CTX_INVALID_PD", NT_STATUS_CTX_INVALID_PD },
	{ "NT_STATUS_CTX_PD_NOT_FOUND", NT_STATUS_CTX_PD_NOT_FOUND },
	{ "NT_STATUS_CTX_CLOSE_PENDING", NT_STATUS_CTX_CLOSE_PENDING },
	{ "NT_STATUS_CTX_NO_OUTBUF", NT_STATUS_CTX_NO_OUTBUF },
	{ "NT_STATUS_CTX_MODEM_INF_NOT_FOUND", NT_STATUS_CTX_MODEM_INF_NOT_FOUND },
	{ "NT_STATUS_CTX_INVALID_MODEMNAME", NT_STATUS_CTX_INVALID_MODEMNAME },
	{ "NT_STATUS_CTX_RESPONSE_ERROR", NT_STATUS_CTX_RESPONSE_ERROR },
	{ "NT_STATUS_CTX_MODEM_RESPONSE_TIMEOUT", NT_STATUS_CTX_MODEM_RESPONSE_TIMEOUT },
	{ "NT_STATUS_CTX_MODEM_RESPONSE_NO_CARRIER", NT_STATUS_CTX_MODEM_RESPONSE_NO_CARRIER },
	{ "NT_STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE", NT_STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE },
	{ "NT_STATUS_CTX_MODEM_RESPONSE_BUSY", NT_STATUS_CTX_MODEM_RESPONSE_BUSY },
	{ "NT_STATUS_CTX_MODEM_RESPONSE_VOICE", NT_STATUS_CTX_MODEM_RESPONSE_VOICE },
	{ "NT_STATUS_CTX_TD_ERROR", NT_STATUS_CTX_TD_ERROR },
	{ "NT_STATUS_CTX_LICENSE_CLIENT_INVALID", NT_STATUS_CTX_LICENSE_CLIENT_INVALID },
	{ "NT_STATUS_CTX_LICENSE_NOT_AVAILABLE", NT_STATUS_CTX_LICENSE_NOT_AVAILABLE },
	{ "NT_STATUS_CTX_LICENSE_EXPIRED", NT_STATUS_CTX_LICENSE_EXPIRED },
	{ "NT_STATUS_CTX_WINSTATION_NOT_FOUND", NT_STATUS_CTX_WINSTATION_NOT_FOUND },
	{ "NT_STATUS_CTX_WINSTATION_NAME_COLLISION", NT_STATUS_CTX_WINSTATION_NAME_COLLISION },
	{ "NT_STATUS_CTX_WINSTATION_BUSY", NT_STATUS_CTX_WINSTATION_BUSY },
	{ "NT_STATUS_CTX_BAD_VIDEO_MODE", NT_STATUS_CTX_BAD_VIDEO_MODE },
	{ "NT_STATUS_CTX_GRAPHICS_INVALID", NT_STATUS_CTX_GRAPHICS_INVALID },
	{ "NT_STATUS_CTX_NOT_CONSOLE", NT_STATUS_CTX_NOT_CONSOLE },
	{ "NT_STATUS_CTX_CLIENT_QUERY_TIMEOUT", NT_STATUS_CTX_CLIENT_QUERY_TIMEOUT },
	{ "NT_STATUS_CTX_CONSOLE_DISCONNECT", NT_STATUS_CTX_CONSOLE_DISCONNECT },
	{ "NT_STATUS_CTX_CONSOLE_CONNECT", NT_STATUS_CTX_CONSOLE_CONNECT },
	{ "NT_STATUS_CTX_SHADOW_DENIED", NT_STATUS_CTX_SHADOW_DENIED },
	{ "NT_STATUS_CTX_WINSTATION_ACCESS_DENIED", NT_STATUS_CTX_WINSTATION_ACCESS_DENIED },
	{ "NT_STATUS_CTX_INVALID_WD", NT_STATUS_CTX_INVALID_WD },
	{ "NT_STATUS_CTX_WD_NOT_FOUND", NT_STATUS_CTX_WD_NOT_FOUND },
	{ "NT_STATUS_CTX_SHADOW_INVALID", NT_STATUS_CTX_SHADOW_INVALID },
	{ "NT_STATUS_CTX_SHADOW_DISABLED", NT_STATUS_CTX_SHADOW_DISABLED },
	{ "NT_STATUS_RDP_PROTOCOL_ERROR", NT_STATUS_RDP_PROTOCOL_ERROR },
	{ "NT_STATUS_CTX_CLIENT_LICENSE_NOT_SET", NT_STATUS_CTX_CLIENT_LICENSE_NOT_SET },
	{ "NT_STATUS_CTX_CLIENT_LICENSE_IN_USE", NT_STATUS_CTX_CLIENT_LICENSE_IN_USE },
	{ "NT_STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE", NT_STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE },
	{ "NT_STATUS_CTX_SHADOW_NOT_RUNNING", NT_STATUS_CTX_SHADOW_NOT_RUNNING },
	{ "NT_STATUS_CTX_LOGON_DISABLED", NT_STATUS_CTX_LOGON_DISABLED },
	{ "NT_STATUS_CTX_SECURITY_LAYER_ERROR", NT_STATUS_CTX_SECURITY_LAYER_ERROR },
	{ "NT_STATUS_TS_INCOMPATIBLE_SESSIONS", NT_STATUS_TS_INCOMPATIBLE_SESSIONS },
	{ "NT_STATUS_MUI_FILE_NOT_FOUND", NT_STATUS_MUI_FILE_NOT_FOUND },
	{ "NT_STATUS_MUI_INVALID_FILE", NT_STATUS_MUI_INVALID_FILE },
	{ "NT_STATUS_MUI_INVALID_RC_CONFIG", NT_STATUS_MUI_INVALID_RC_CONFIG },
	{ "NT_STATUS_MUI_INVALID_LOCALE_NAME", NT_STATUS_MUI_INVALID_LOCALE_NAME },
	{ "NT_STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME", NT_STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME },
	{ "NT_STATUS_MUI_FILE_NOT_LOADED", NT_STATUS_MUI_FILE_NOT_LOADED },
	{ "NT_STATUS_RESOURCE_ENUM_USER_STOP", NT_STATUS_RESOURCE_ENUM_USER_STOP },
	{ "NT_STATUS_CLUSTER_INVALID_NODE", NT_STATUS_CLUSTER_INVALID_NODE },
	{ "NT_STATUS_CLUSTER_NODE_EXISTS", NT_STATUS_CLUSTER_NODE_EXISTS },
	{ "NT_STATUS_CLUSTER_JOIN_IN_PROGRESS", NT_STATUS_CLUSTER_JOIN_IN_PROGRESS },
	{ "NT_STATUS_CLUSTER_NODE_NOT_FOUND", NT_STATUS_CLUSTER_NODE_NOT_FOUND },
	{ "NT_STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND", NT_STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND },
	{ "NT_STATUS_CLUSTER_NETWORK_EXISTS", NT_STATUS_CLUSTER_NETWORK_EXISTS },
	{ "NT_STATUS_CLUSTER_NETWORK_NOT_FOUND", NT_STATUS_CLUSTER_NETWORK_NOT_FOUND },
	{ "NT_STATUS_CLUSTER_NETINTERFACE_EXISTS", NT_STATUS_CLUSTER_NETINTERFACE_EXISTS },
	{ "NT_STATUS_CLUSTER_NETINTERFACE_NOT_FOUND", NT_STATUS_CLUSTER_NETINTERFACE_NOT_FOUND },
	{ "NT_STATUS_CLUSTER_INVALID_REQUEST", NT_STATUS_CLUSTER_INVALID_REQUEST },
	{ "NT_STATUS_CLUSTER_INVALID_NETWORK_PROVIDER", NT_STATUS_CLUSTER_INVALID_NETWORK_PROVIDER },
	{ "NT_STATUS_CLUSTER_NODE_DOWN", NT_STATUS_CLUSTER_NODE_DOWN },
	{ "NT_STATUS_CLUSTER_NODE_UNREACHABLE", NT_STATUS_CLUSTER_NODE_UNREACHABLE },
	{ "NT_STATUS_CLUSTER_NODE_NOT_MEMBER", NT_STATUS_CLUSTER_NODE_NOT_MEMBER },
	{ "NT_STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS", NT_STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS },
	{ "NT_STATUS_CLUSTER_INVALID_NETWORK", NT_STATUS_CLUSTER_INVALID_NETWORK },
	{ "NT_STATUS_CLUSTER_NO_NET_ADAPTERS", NT_STATUS_CLUSTER_NO_NET_ADAPTERS },
	{ "NT_STATUS_CLUSTER_NODE_UP", NT_STATUS_CLUSTER_NODE_UP },
	{ "NT_STATUS_CLUSTER_NODE_PAUSED", NT_STATUS_CLUSTER_NODE_PAUSED },
	{ "NT_STATUS_CLUSTER_NODE_NOT_PAUSED", NT_STATUS_CLUSTER_NODE_NOT_PAUSED },
	{ "NT_STATUS_CLUSTER_NO_SECURITY_CONTEXT", NT_STATUS_CLUSTER_NO_SECURITY_CONTEXT },
	{ "NT_STATUS_CLUSTER_NETWORK_NOT_INTERNAL", NT_STATUS_CLUSTER_NETWORK_NOT_INTERNAL },
	{ "NT_STATUS_CLUSTER_POISONED", NT_STATUS_CLUSTER_POISONED },
	{ "NT_STATUS_ACPI_INVALID_OPCODE", NT_STATUS_ACPI_INVALID_OPCODE },
	{ "NT_STATUS_ACPI_STACK_OVERFLOW", NT_STATUS_ACPI_STACK_OVERFLOW },
	{ "NT_STATUS_ACPI_ASSERT_FAILED", NT_STATUS_ACPI_ASSERT_FAILED },
	{ "NT_STATUS_ACPI_INVALID_INDEX", NT_STATUS_ACPI_INVALID_INDEX },
	{ "NT_STATUS_ACPI_INVALID_ARGUMENT", NT_STATUS_ACPI_INVALID_ARGUMENT },
	{ "NT_STATUS_ACPI_FATAL", NT_STATUS_ACPI_FATAL },
	{ "NT_STATUS_ACPI_INVALID_SUPERNAME", NT_STATUS_ACPI_INVALID_SUPERNAME },
	{ "NT_STATUS_ACPI_INVALID_ARGTYPE", NT_STATUS_ACPI_INVALID_ARGTYPE },
	{ "NT_STATUS_ACPI_INVALID_OBJTYPE", NT_STATUS_ACPI_INVALID_OBJTYPE },
	{ "NT_STATUS_ACPI_INVALID_TARGETTYPE", NT_STATUS_ACPI_INVALID_TARGETTYPE },
	{ "NT_STATUS_ACPI_INCORRECT_ARGUMENT_COUNT", NT_STATUS_ACPI_INCORRECT_ARGUMENT_COUNT },
	{ "NT_STATUS_ACPI_ADDRESS_NOT_MAPPED", NT_STATUS_ACPI_ADDRESS_NOT_MAPPED },
	{ "NT_STATUS_ACPI_INVALID_EVENTTYPE", NT_STATUS_ACPI_INVALID_EVENTTYPE },
	{ "NT_STATUS_ACPI_HANDLER_COLLISION", NT_STATUS_ACPI_HANDLER_COLLISION },
	{ "NT_STATUS_ACPI_INVALID_DATA", NT_STATUS_ACPI_INVALID_DATA },
	{ "NT_STATUS_ACPI_INVALID_REGION", NT_STATUS_ACPI_INVALID_REGION },
	{ "NT_STATUS_ACPI_INVALID_ACCESS_SIZE", NT_STATUS_ACPI_INVALID_ACCESS_SIZE },
	{ "NT_STATUS_ACPI_ACQUIRE_GLOBAL_LOCK", NT_STATUS_ACPI_ACQUIRE_GLOBAL_LOCK },
	{ "NT_STATUS_ACPI_ALREADY_INITIALIZED", NT_STATUS_ACPI_ALREADY_INITIALIZED },
	{ "NT_STATUS_ACPI_NOT_INITIALIZED", NT_STATUS_ACPI_NOT_INITIALIZED },
	{ "NT_STATUS_ACPI_INVALID_MUTEX_LEVEL", NT_STATUS_ACPI_INVALID_MUTEX_LEVEL },
	{ "NT_STATUS_ACPI_MUTEX_NOT_OWNED", NT_STATUS_ACPI_MUTEX_NOT_OWNED },
	{ "NT_STATUS_ACPI_MUTEX_NOT_OWNER", NT_STATUS_ACPI_MUTEX_NOT_OWNER },
	{ "NT_STATUS_ACPI_RS_ACCESS", NT_STATUS_ACPI_RS_ACCESS },
	{ "NT_STATUS_ACPI_INVALID_TABLE", NT_STATUS_ACPI_INVALID_TABLE },
	{ "NT_STATUS_ACPI_REG_HANDLER_FAILED", NT_STATUS_ACPI_REG_HANDLER_FAILED },
	{ "NT_STATUS_ACPI_POWER_REQUEST_FAILED", NT_STATUS_ACPI_POWER_REQUEST_FAILED },
	{ "NT_STATUS_SXS_SECTION_NOT_FOUND", NT_STATUS_SXS_SECTION_NOT_FOUND },
	{ "NT_STATUS_SXS_CANT_GEN_ACTCTX", NT_STATUS_SXS_CANT_GEN_ACTCTX },
	{ "NT_STATUS_SXS_INVALID_ACTCTXDATA_FORMAT", NT_STATUS_SXS_INVALID_ACTCTXDATA_FORMAT },
	{ "NT_STATUS_SXS_ASSEMBLY_NOT_FOUND", NT_STATUS_SXS_ASSEMBLY_NOT_FOUND },
	{ "NT_STATUS_SXS_MANIFEST_FORMAT_ERROR", NT_STATUS_SXS_MANIFEST_FORMAT_ERROR },
	{ "NT_STATUS_SXS_MANIFEST_PARSE_ERROR", NT_STATUS_SXS_MANIFEST_PARSE_ERROR },
	{ "NT_STATUS_SXS_ACTIVATION_CONTEXT_DISABLED", NT_STATUS_SXS_ACTIVATION_CONTEXT_DISABLED },
	{ "NT_STATUS_SXS_KEY_NOT_FOUND", NT_STATUS_SXS_KEY_NOT_FOUND },
	{ "NT_STATUS_SXS_VERSION_CONFLICT", NT_STATUS_SXS_VERSION_CONFLICT },
	{ "NT_STATUS_SXS_WRONG_SECTION_TYPE", NT_STATUS_SXS_WRONG_SECTION_TYPE },
	{ "NT_STATUS_SXS_THREAD_QUERIES_DISABLED", NT_STATUS_SXS_THREAD_QUERIES_DISABLED },
	{ "NT_STATUS_SXS_ASSEMBLY_MISSING", NT_STATUS_SXS_ASSEMBLY_MISSING },
	{ "NT_STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET", NT_STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET },
	{ "NT_STATUS_SXS_EARLY_DEACTIVATION", NT_STATUS_SXS_EARLY_DEACTIVATION },
	{ "NT_STATUS_SXS_INVALID_DEACTIVATION", NT_STATUS_SXS_INVALID_DEACTIVATION },
	{ "NT_STATUS_SXS_MULTIPLE_DEACTIVATION", NT_STATUS_SXS_MULTIPLE_DEACTIVATION },
	{ "NT_STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY", NT_STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY },
	{ "NT_STATUS_SXS_PROCESS_TERMINATION_REQUESTED", NT_STATUS_SXS_PROCESS_TERMINATION_REQUESTED },
	{ "NT_STATUS_SXS_CORRUPT_ACTIVATION_STACK", NT_STATUS_SXS_CORRUPT_ACTIVATION_STACK },
	{ "NT_STATUS_SXS_CORRUPTION", NT_STATUS_SXS_CORRUPTION },
	{ "NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE", NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE },
	{ "NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME", NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME },
	{ "NT_STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE", NT_STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE },
	{ "NT_STATUS_SXS_IDENTITY_PARSE_ERROR", NT_STATUS_SXS_IDENTITY_PARSE_ERROR },
	{ "NT_STATUS_SXS_COMPONENT_STORE_CORRUPT", NT_STATUS_SXS_COMPONENT_STORE_CORRUPT },
	{ "NT_STATUS_SXS_FILE_HASH_MISMATCH", NT_STATUS_SXS_FILE_HASH_MISMATCH },
	{ "NT_STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT", NT_STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT },
	{ "NT_STATUS_SXS_IDENTITIES_DIFFERENT", NT_STATUS_SXS_IDENTITIES_DIFFERENT },
	{ "NT_STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT", NT_STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT },
	{ "NT_STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY", NT_STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY },
	{ "NT_STATUS_ADVANCED_INSTALLER_FAILED", NT_STATUS_ADVANCED_INSTALLER_FAILED },
	{ "NT_STATUS_XML_ENCODING_MISMATCH", NT_STATUS_XML_ENCODING_MISMATCH },
	{ "NT_STATUS_SXS_MANIFEST_TOO_BIG", NT_STATUS_SXS_MANIFEST_TOO_BIG },
	{ "NT_STATUS_SXS_SETTING_NOT_REGISTERED", NT_STATUS_SXS_SETTING_NOT_REGISTERED },
	{ "NT_STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE", NT_STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE },
	{ "NT_STATUS_SMI_PRIMITIVE_INSTALLER_FAILED", NT_STATUS_SMI_PRIMITIVE_INSTALLER_FAILED },
	{ "NT_STATUS_GENERIC_COMMAND_FAILED", NT_STATUS_GENERIC_COMMAND_FAILED },
	{ "NT_STATUS_SXS_FILE_HASH_MISSING", NT_STATUS_SXS_FILE_HASH_MISSING },
	{ "NT_STATUS_TRANSACTIONAL_CONFLICT", NT_STATUS_TRANSACTIONAL_CONFLICT },
	{ "NT_STATUS_INVALID_TRANSACTION", NT_STATUS_INVALID_TRANSACTION },
	{ "NT_STATUS_TRANSACTION_NOT_ACTIVE", NT_STATUS_TRANSACTION_NOT_ACTIVE },
	{ "NT_STATUS_TM_INITIALIZATION_FAILED", NT_STATUS_TM_INITIALIZATION_FAILED },
	{ "NT_STATUS_RM_NOT_ACTIVE", NT_STATUS_RM_NOT_ACTIVE },
	{ "NT_STATUS_RM_METADATA_CORRUPT", NT_STATUS_RM_METADATA_CORRUPT },
	{ "NT_STATUS_TRANSACTION_NOT_JOINED", NT_STATUS_TRANSACTION_NOT_JOINED },
	{ "NT_STATUS_DIRECTORY_NOT_RM", NT_STATUS_DIRECTORY_NOT_RM },
	{ "NT_STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE", NT_STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE },
	{ "NT_STATUS_LOG_RESIZE_INVALID_SIZE", NT_STATUS_LOG_RESIZE_INVALID_SIZE },
	{ "NT_STATUS_REMOTE_FILE_VERSION_MISMATCH", NT_STATUS_REMOTE_FILE_VERSION_MISMATCH },
	{ "NT_STATUS_CRM_PROTOCOL_ALREADY_EXISTS", NT_STATUS_CRM_PROTOCOL_ALREADY_EXISTS },
	{ "NT_STATUS_TRANSACTION_PROPAGATION_FAILED", NT_STATUS_TRANSACTION_PROPAGATION_FAILED },
	{ "NT_STATUS_CRM_PROTOCOL_NOT_FOUND", NT_STATUS_CRM_PROTOCOL_NOT_FOUND },
	{ "NT_STATUS_TRANSACTION_SUPERIOR_EXISTS", NT_STATUS_TRANSACTION_SUPERIOR_EXISTS },
	{ "NT_STATUS_TRANSACTION_REQUEST_NOT_VALID", NT_STATUS_TRANSACTION_REQUEST_NOT_VALID },
	{ "NT_STATUS_TRANSACTION_NOT_REQUESTED", NT_STATUS_TRANSACTION_NOT_REQUESTED },
	{ "NT_STATUS_TRANSACTION_ALREADY_ABORTED", NT_STATUS_TRANSACTION_ALREADY_ABORTED },
	{ "NT_STATUS_TRANSACTION_ALREADY_COMMITTED", NT_STATUS_TRANSACTION_ALREADY_COMMITTED },
	{ "NT_STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER", NT_STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER },
	{ "NT_STATUS_CURRENT_TRANSACTION_NOT_VALID", NT_STATUS_CURRENT_TRANSACTION_NOT_VALID },
	{ "NT_STATUS_LOG_GROWTH_FAILED", NT_STATUS_LOG_GROWTH_FAILED },
	{ "NT_STATUS_OBJECT_NO_LONGER_EXISTS", NT_STATUS_OBJECT_NO_LONGER_EXISTS },
	{ "NT_STATUS_STREAM_MINIVERSION_NOT_FOUND", NT_STATUS_STREAM_MINIVERSION_NOT_FOUND },
	{ "NT_STATUS_STREAM_MINIVERSION_NOT_VALID", NT_STATUS_STREAM_MINIVERSION_NOT_VALID },
	{ "NT_STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION", NT_STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION },
	{ "NT_STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT", NT_STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT },
	{ "NT_STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS", NT_STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS },
	{ "NT_STATUS_HANDLE_NO_LONGER_VALID", NT_STATUS_HANDLE_NO_LONGER_VALID },
	{ "NT_STATUS_LOG_CORRUPTION_DETECTED", NT_STATUS_LOG_CORRUPTION_DETECTED },
	{ "NT_STATUS_RM_DISCONNECTED", NT_STATUS_RM_DISCONNECTED },
	{ "NT_STATUS_ENLISTMENT_NOT_SUPERIOR", NT_STATUS_ENLISTMENT_NOT_SUPERIOR },
	{ "NT_STATUS_FILE_IDENTITY_NOT_PERSISTENT", NT_STATUS_FILE_IDENTITY_NOT_PERSISTENT },
	{ "NT_STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY", NT_STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY },
	{ "NT_STATUS_CANT_CROSS_RM_BOUNDARY", NT_STATUS_CANT_CROSS_RM_BOUNDARY },
	{ "NT_STATUS_TXF_DIR_NOT_EMPTY", NT_STATUS_TXF_DIR_NOT_EMPTY },
	{ "NT_STATUS_INDOUBT_TRANSACTIONS_EXIST", NT_STATUS_INDOUBT_TRANSACTIONS_EXIST },
	{ "NT_STATUS_TM_VOLATILE", NT_STATUS_TM_VOLATILE },
	{ "NT_STATUS_ROLLBACK_TIMER_EXPIRED", NT_STATUS_ROLLBACK_TIMER_EXPIRED },
	{ "NT_STATUS_TXF_ATTRIBUTE_CORRUPT", NT_STATUS_TXF_ATTRIBUTE_CORRUPT },
	{ "NT_STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION", NT_STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION },
	{ "NT_STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED", NT_STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED },
	{ "NT_STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE", NT_STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE },
	{ "NT_STATUS_TRANSACTION_REQUIRED_PROMOTION", NT_STATUS_TRANSACTION_REQUIRED_PROMOTION },
	{ "NT_STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION", NT_STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION },
	{ "NT_STATUS_TRANSACTIONS_NOT_FROZEN", NT_STATUS_TRANSACTIONS_NOT_FROZEN },
	{ "NT_STATUS_TRANSACTION_FREEZE_IN_PROGRESS", NT_STATUS_TRANSACTION_FREEZE_IN_PROGRESS },
	{ "NT_STATUS_NOT_SNAPSHOT_VOLUME", NT_STATUS_NOT_SNAPSHOT_VOLUME },
	{ "NT_STATUS_NO_SAVEPOINT_WITH_OPEN_FILES", NT_STATUS_NO_SAVEPOINT_WITH_OPEN_FILES },
	{ "NT_STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION", NT_STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION },
	{ "NT_STATUS_TM_IDENTITY_MISMATCH", NT_STATUS_TM_IDENTITY_MISMATCH },
	{ "NT_STATUS_FLOATED_SECTION", NT_STATUS_FLOATED_SECTION },
	{ "NT_STATUS_CANNOT_ACCEPT_TRANSACTED_WORK", NT_STATUS_CANNOT_ACCEPT_TRANSACTED_WORK },
	{ "NT_STATUS_CANNOT_ABORT_TRANSACTIONS", NT_STATUS_CANNOT_ABORT_TRANSACTIONS },
	{ "NT_STATUS_TRANSACTION_NOT_FOUND", NT_STATUS_TRANSACTION_NOT_FOUND },
	{ "NT_STATUS_RESOURCEMANAGER_NOT_FOUND", NT_STATUS_RESOURCEMANAGER_NOT_FOUND },
	{ "NT_STATUS_ENLISTMENT_NOT_FOUND", NT_STATUS_ENLISTMENT_NOT_FOUND },
	{ "NT_STATUS_TRANSACTIONMANAGER_NOT_FOUND", NT_STATUS_TRANSACTIONMANAGER_NOT_FOUND },
	{ "NT_STATUS_TRANSACTIONMANAGER_NOT_ONLINE", NT_STATUS_TRANSACTIONMANAGER_NOT_ONLINE },
	{ "NT_STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION", NT_STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION },
	{ "NT_STATUS_TRANSACTION_NOT_ROOT", NT_STATUS_TRANSACTION_NOT_ROOT },
	{ "NT_STATUS_TRANSACTION_OBJECT_EXPIRED", NT_STATUS_TRANSACTION_OBJECT_EXPIRED },
	{ "NT_STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION", NT_STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION },
	{ "NT_STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED", NT_STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED },
	{ "NT_STATUS_TRANSACTION_RECORD_TOO_LONG", NT_STATUS_TRANSACTION_RECORD_TOO_LONG },
	{ "NT_STATUS_NO_LINK_TRACKING_IN_TRANSACTION", NT_STATUS_NO_LINK_TRACKING_IN_TRANSACTION },
	{ "NT_STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION", NT_STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION },
	{ "NT_STATUS_TRANSACTION_INTEGRITY_VIOLATED", NT_STATUS_TRANSACTION_INTEGRITY_VIOLATED },
	{ "NT_STATUS_EXPIRED_HANDLE", NT_STATUS_EXPIRED_HANDLE },
	{ "NT_STATUS_TRANSACTION_NOT_ENLISTED", NT_STATUS_TRANSACTION_NOT_ENLISTED },
	{ "NT_STATUS_LOG_SECTOR_INVALID", NT_STATUS_LOG_SECTOR_INVALID },
	{ "NT_STATUS_LOG_SECTOR_PARITY_INVALID", NT_STATUS_LOG_SECTOR_PARITY_INVALID },
	{ "NT_STATUS_LOG_SECTOR_REMAPPED", NT_STATUS_LOG_SECTOR_REMAPPED },
	{ "NT_STATUS_LOG_BLOCK_INCOMPLETE", NT_STATUS_LOG_BLOCK_INCOMPLETE },
	{ "NT_STATUS_LOG_INVALID_RANGE", NT_STATUS_LOG_INVALID_RANGE },
	{ "NT_STATUS_LOG_BLOCKS_EXHAUSTED", NT_STATUS_LOG_BLOCKS_EXHAUSTED },
	{ "NT_STATUS_LOG_READ_CONTEXT_INVALID", NT_STATUS_LOG_READ_CONTEXT_INVALID },
	{ "NT_STATUS_LOG_RESTART_INVALID", NT_STATUS_LOG_RESTART_INVALID },
	{ "NT_STATUS_LOG_BLOCK_VERSION", NT_STATUS_LOG_BLOCK_VERSION },
	{ "NT_STATUS_LOG_BLOCK_INVALID", NT_STATUS_LOG_BLOCK_INVALID },
	{ "NT_STATUS_LOG_READ_MODE_INVALID", NT_STATUS_LOG_READ_MODE_INVALID },
	{ "NT_STATUS_LOG_METADATA_CORRUPT", NT_STATUS_LOG_METADATA_CORRUPT },
	{ "NT_STATUS_LOG_METADATA_INVALID", NT_STATUS_LOG_METADATA_INVALID },
	{ "NT_STATUS_LOG_METADATA_INCONSISTENT", NT_STATUS_LOG_METADATA_INCONSISTENT },
	{ "NT_STATUS_LOG_RESERVATION_INVALID", NT_STATUS_LOG_RESERVATION_INVALID },
	{ "NT_STATUS_LOG_CANT_DELETE", NT_STATUS_LOG_CANT_DELETE },
	{ "NT_STATUS_LOG_CONTAINER_LIMIT_EXCEEDED", NT_STATUS_LOG_CONTAINER_LIMIT_EXCEEDED },
	{ "NT_STATUS_LOG_START_OF_LOG", NT_STATUS_LOG_START_OF_LOG },
	{ "NT_STATUS_LOG_POLICY_ALREADY_INSTALLED", NT_STATUS_LOG_POLICY_ALREADY_INSTALLED },
	{ "NT_STATUS_LOG_POLICY_NOT_INSTALLED", NT_STATUS_LOG_POLICY_NOT_INSTALLED },
	{ "NT_STATUS_LOG_POLICY_INVALID", NT_STATUS_LOG_POLICY_INVALID },
	{ "NT_STATUS_LOG_POLICY_CONFLICT", NT_STATUS_LOG_POLICY_CONFLICT },
	{ "NT_STATUS_LOG_PINNED_ARCHIVE_TAIL", NT_STATUS_LOG_PINNED_ARCHIVE_TAIL },
	{ "NT_STATUS_LOG_RECORD_NONEXISTENT", NT_STATUS_LOG_RECORD_NONEXISTENT },
	{ "NT_STATUS_LOG_RECORDS_RESERVED_INVALID", NT_STATUS_LOG_RECORDS_RESERVED_INVALID },
	{ "NT_STATUS_LOG_SPACE_RESERVED_INVALID", NT_STATUS_LOG_SPACE_RESERVED_INVALID },
	{ "NT_STATUS_LOG_TAIL_INVALID", NT_STATUS_LOG_TAIL_INVALID },
	{ "NT_STATUS_LOG_FULL", NT_STATUS_LOG_FULL },
	{ "NT_STATUS_LOG_MULTIPLEXED", NT_STATUS_LOG_MULTIPLEXED },
	{ "NT_STATUS_LOG_DEDICATED", NT_STATUS_LOG_DEDICATED },
	{ "NT_STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS", NT_STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS },
	{ "NT_STATUS_LOG_ARCHIVE_IN_PROGRESS", NT_STATUS_LOG_ARCHIVE_IN_PROGRESS },
	{ "NT_STATUS_LOG_EPHEMERAL", NT_STATUS_LOG_EPHEMERAL },
	{ "NT_STATUS_LOG_NOT_ENOUGH_CONTAINERS", NT_STATUS_LOG_NOT_ENOUGH_CONTAINERS },
	{ "NT_STATUS_LOG_CLIENT_ALREADY_REGISTERED", NT_STATUS_LOG_CLIENT_ALREADY_REGISTERED },
	{ "NT_STATUS_LOG_CLIENT_NOT_REGISTERED", NT_STATUS_LOG_CLIENT_NOT_REGISTERED },
	{ "NT_STATUS_LOG_FULL_HANDLER_IN_PROGRESS", NT_STATUS_LOG_FULL_HANDLER_IN_PROGRESS },
	{ "NT_STATUS_LOG_CONTAINER_READ_FAILED", NT_STATUS_LOG_CONTAINER_READ_FAILED },
	{ "NT_STATUS_LOG_CONTAINER_WRITE_FAILED", NT_STATUS_LOG_CONTAINER_WRITE_FAILED },
	{ "NT_STATUS_LOG_CONTAINER_OPEN_FAILED", NT_STATUS_LOG_CONTAINER_OPEN_FAILED },
	{ "NT_STATUS_LOG_CONTAINER_STATE_INVALID", NT_STATUS_LOG_CONTAINER_STATE_INVALID },
	{ "NT_STATUS_LOG_STATE_INVALID", NT_STATUS_LOG_STATE_INVALID },
	{ "NT_STATUS_LOG_PINNED", NT_STATUS_LOG_PINNED },
	{ "NT_STATUS_LOG_METADATA_FLUSH_FAILED", NT_STATUS_LOG_METADATA_FLUSH_FAILED },
	{ "NT_STATUS_LOG_INCONSISTENT_SECURITY", NT_STATUS_LOG_INCONSISTENT_SECURITY },
	{ "NT_STATUS_LOG_APPENDED_FLUSH_FAILED", NT_STATUS_LOG_APPENDED_FLUSH_FAILED },
	{ "NT_STATUS_LOG_PINNED_RESERVATION", NT_STATUS_LOG_PINNED_RESERVATION },
	{ "NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD", NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD },
	{ "NT_STATUS_FLT_NO_HANDLER_DEFINED", NT_STATUS_FLT_NO_HANDLER_DEFINED },
	{ "NT_STATUS_FLT_CONTEXT_ALREADY_DEFINED", NT_STATUS_FLT_CONTEXT_ALREADY_DEFINED },
	{ "NT_STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST", NT_STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST },
	{ "NT_STATUS_FLT_DISALLOW_FAST_IO", NT_STATUS_FLT_DISALLOW_FAST_IO },
	{ "NT_STATUS_FLT_INVALID_NAME_REQUEST", NT_STATUS_FLT_INVALID_NAME_REQUEST },
	{ "NT_STATUS_FLT_NOT_SAFE_TO_POST_OPERATION", NT_STATUS_FLT_NOT_SAFE_TO_POST_OPERATION },
	{ "NT_STATUS_FLT_NOT_INITIALIZED", NT_STATUS_FLT_NOT_INITIALIZED },
	{ "NT_STATUS_FLT_FILTER_NOT_READY", NT_STATUS_FLT_FILTER_NOT_READY },
	{ "NT_STATUS_FLT_POST_OPERATION_CLEANUP", NT_STATUS_FLT_POST_OPERATION_CLEANUP },
	{ "NT_STATUS_FLT_INTERNAL_ERROR", NT_STATUS_FLT_INTERNAL_ERROR },
	{ "NT_STATUS_FLT_DELETING_OBJECT", NT_STATUS_FLT_DELETING_OBJECT },
	{ "NT_STATUS_FLT_MUST_BE_NONPAGED_POOL", NT_STATUS_FLT_MUST_BE_NONPAGED_POOL },
	{ "NT_STATUS_FLT_DUPLICATE_ENTRY", NT_STATUS_FLT_DUPLICATE_ENTRY },
	{ "NT_STATUS_FLT_CBDQ_DISABLED", NT_STATUS_FLT_CBDQ_DISABLED },
	{ "NT_STATUS_FLT_DO_NOT_ATTACH", NT_STATUS_FLT_DO_NOT_ATTACH },
	{ "NT_STATUS_FLT_DO_NOT_DETACH", NT_STATUS_FLT_DO_NOT_DETACH },
	{ "NT_STATUS_FLT_INSTANCE_ALTITUDE_COLLISION", NT_STATUS_FLT_INSTANCE_ALTITUDE_COLLISION },
	{ "NT_STATUS_FLT_INSTANCE_NAME_COLLISION", NT_STATUS_FLT_INSTANCE_NAME_COLLISION },
	{ "NT_STATUS_FLT_FILTER_NOT_FOUND", NT_STATUS_FLT_FILTER_NOT_FOUND },
	{ "NT_STATUS_FLT_VOLUME_NOT_FOUND", NT_STATUS_FLT_VOLUME_NOT_FOUND },
	{ "NT_STATUS_FLT_INSTANCE_NOT_FOUND", NT_STATUS_FLT_INSTANCE_NOT_FOUND },
	{ "NT_STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND", NT_STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND },
	{ "NT_STATUS_FLT_INVALID_CONTEXT_REGISTRATION", NT_STATUS_FLT_INVALID_CONTEXT_REGISTRATION },
	{ "NT_STATUS_FLT_NAME_CACHE_MISS", NT_STATUS_FLT_NAME_CACHE_MISS },
	{ "NT_STATUS_FLT_NO_DEVICE_OBJECT", NT_STATUS_FLT_NO_DEVICE_OBJECT },
	{ "NT_STATUS_FLT_VOLUME_ALREADY_MOUNTED", NT_STATUS_FLT_VOLUME_ALREADY_MOUNTED },
	{ "NT_STATUS_FLT_ALREADY_ENLISTED", NT_STATUS_FLT_ALREADY_ENLISTED },
	{ "NT_STATUS_FLT_CONTEXT_ALREADY_LINKED", NT_STATUS_FLT_CONTEXT_ALREADY_LINKED },
	{ "NT_STATUS_FLT_NO_WAITER_FOR_REPLY", NT_STATUS_FLT_NO_WAITER_FOR_REPLY },
	{ "NT_STATUS_MONITOR_NO_DESCRIPTOR", NT_STATUS_MONITOR_NO_DESCRIPTOR },
	{ "NT_STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT", NT_STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT },
	{ "NT_STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM", NT_STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM },
	{ "NT_STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK", NT_STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK },
	{ "NT_STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED", NT_STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED },
	{ "NT_STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK", NT_STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK },
	{ "NT_STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK", NT_STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK },
	{ "NT_STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA", NT_STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA },
	{ "NT_STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK", NT_STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK },
	{ "NT_STATUS_MONITOR_INVALID_MANUFACTURE_DATE", NT_STATUS_MONITOR_INVALID_MANUFACTURE_DATE },
	{ "NT_STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER", NT_STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER },
	{ "NT_STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER", NT_STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER },
	{ "NT_STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER", NT_STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER },
	{ "NT_STATUS_GRAPHICS_ADAPTER_WAS_RESET", NT_STATUS_GRAPHICS_ADAPTER_WAS_RESET },
	{ "NT_STATUS_GRAPHICS_INVALID_DRIVER_MODEL", NT_STATUS_GRAPHICS_INVALID_DRIVER_MODEL },
	{ "NT_STATUS_GRAPHICS_PRESENT_MODE_CHANGED", NT_STATUS_GRAPHICS_PRESENT_MODE_CHANGED },
	{ "NT_STATUS_GRAPHICS_PRESENT_OCCLUDED", NT_STATUS_GRAPHICS_PRESENT_OCCLUDED },
	{ "NT_STATUS_GRAPHICS_PRESENT_DENIED", NT_STATUS_GRAPHICS_PRESENT_DENIED },
	{ "NT_STATUS_GRAPHICS_CANNOTCOLORCONVERT", NT_STATUS_GRAPHICS_CANNOTCOLORCONVERT },
	{ "NT_STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED", NT_STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED },
	{ "NT_STATUS_GRAPHICS_PRESENT_UNOCCLUDED", NT_STATUS_GRAPHICS_PRESENT_UNOCCLUDED },
	{ "NT_STATUS_GRAPHICS_NO_VIDEO_MEMORY", NT_STATUS_GRAPHICS_NO_VIDEO_MEMORY },
	{ "NT_STATUS_GRAPHICS_CANT_LOCK_MEMORY", NT_STATUS_GRAPHICS_CANT_LOCK_MEMORY },
	{ "NT_STATUS_GRAPHICS_ALLOCATION_BUSY", NT_STATUS_GRAPHICS_ALLOCATION_BUSY },
	{ "NT_STATUS_GRAPHICS_TOO_MANY_REFERENCES", NT_STATUS_GRAPHICS_TOO_MANY_REFERENCES },
	{ "NT_STATUS_GRAPHICS_TRY_AGAIN_LATER", NT_STATUS_GRAPHICS_TRY_AGAIN_LATER },
	{ "NT_STATUS_GRAPHICS_TRY_AGAIN_NOW", NT_STATUS_GRAPHICS_TRY_AGAIN_NOW },
	{ "NT_STATUS_GRAPHICS_ALLOCATION_INVALID", NT_STATUS_GRAPHICS_ALLOCATION_INVALID },
	{ "NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE", NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE },
	{ "NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED", NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED },
	{ "NT_STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION", NT_STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION },
	{ "NT_STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE", NT_STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE },
	{ "NT_STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION", NT_STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION },
	{ "NT_STATUS_GRAPHICS_ALLOCATION_CLOSED", NT_STATUS_GRAPHICS_ALLOCATION_CLOSED },
	{ "NT_STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE", NT_STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE },
	{ "NT_STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE", NT_STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE },
	{ "NT_STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE", NT_STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE },
	{ "NT_STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST", NT_STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST },
	{ "NT_STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE", NT_STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY", NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED", NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED", NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN", NT_STATUS_GRAPHICS_INVALID_VIDPN },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE", NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET", NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET },
	{ "NT_STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED", NT_STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET", NT_STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET", NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET },
	{ "NT_STATUS_GRAPHICS_INVALID_FREQUENCY", NT_STATUS_GRAPHICS_INVALID_FREQUENCY },
	{ "NT_STATUS_GRAPHICS_INVALID_ACTIVE_REGION", NT_STATUS_GRAPHICS_INVALID_ACTIVE_REGION },
	{ "NT_STATUS_GRAPHICS_INVALID_TOTAL_REGION", NT_STATUS_GRAPHICS_INVALID_TOTAL_REGION },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE", NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE", NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE },
	{ "NT_STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET", NT_STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET },
	{ "NT_STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY", NT_STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET", NT_STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET", NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET", NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET },
	{ "NT_STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET", NT_STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET },
	{ "NT_STATUS_GRAPHICS_TARGET_ALREADY_IN_SET", NT_STATUS_GRAPHICS_TARGET_ALREADY_IN_SET },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH", NT_STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH },
	{ "NT_STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY", NT_STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET", NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE", NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE },
	{ "NT_STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET", NT_STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET },
	{ "NT_STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET", NT_STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET },
	{ "NT_STATUS_GRAPHICS_STALE_MODESET", NT_STATUS_GRAPHICS_STALE_MODESET },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET", NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE", NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE },
	{ "NT_STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN", NT_STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN },
	{ "NT_STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE", NT_STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE },
	{ "NT_STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION", NT_STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION },
	{ "NT_STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES", NT_STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES },
	{ "NT_STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY", NT_STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE", NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE },
	{ "NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET", NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET", NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR", NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR },
	{ "NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET", NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET },
	{ "NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET", NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET },
	{ "NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE", NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE", NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE },
	{ "NT_STATUS_GRAPHICS_RESOURCES_NOT_RELATED", NT_STATUS_GRAPHICS_RESOURCES_NOT_RELATED },
	{ "NT_STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE", NT_STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE },
	{ "NT_STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE", NT_STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE },
	{ "NT_STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET", NT_STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET },
	{ "NT_STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER", NT_STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER },
	{ "NT_STATUS_GRAPHICS_NO_VIDPNMGR", NT_STATUS_GRAPHICS_NO_VIDPNMGR },
	{ "NT_STATUS_GRAPHICS_NO_ACTIVE_VIDPN", NT_STATUS_GRAPHICS_NO_ACTIVE_VIDPN },
	{ "NT_STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY", NT_STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_MONITOR_NOT_CONNECTED", NT_STATUS_GRAPHICS_MONITOR_NOT_CONNECTED },
	{ "NT_STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY", NT_STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE", NT_STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE },
	{ "NT_STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE", NT_STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE },
	{ "NT_STATUS_GRAPHICS_INVALID_STRIDE", NT_STATUS_GRAPHICS_INVALID_STRIDE },
	{ "NT_STATUS_GRAPHICS_INVALID_PIXELFORMAT", NT_STATUS_GRAPHICS_INVALID_PIXELFORMAT },
	{ "NT_STATUS_GRAPHICS_INVALID_COLORBASIS", NT_STATUS_GRAPHICS_INVALID_COLORBASIS },
	{ "NT_STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE", NT_STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE },
	{ "NT_STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY", NT_STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY },
	{ "NT_STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT", NT_STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT },
	{ "NT_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE", NT_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE },
	{ "NT_STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN", NT_STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN },
	{ "NT_STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL", NT_STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL },
	{ "NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION", NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION },
	{ "NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED", NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_INVALID_GAMMA_RAMP", NT_STATUS_GRAPHICS_INVALID_GAMMA_RAMP },
	{ "NT_STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED", NT_STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED", NT_STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_MODE_NOT_IN_MODESET", NT_STATUS_GRAPHICS_MODE_NOT_IN_MODESET },
	{ "NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON", NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON },
	{ "NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE", NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE },
	{ "NT_STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE", NT_STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE },
	{ "NT_STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS", NT_STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS },
	{ "NT_STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING", NT_STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING },
	{ "NT_STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED", NT_STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED },
	{ "NT_STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS", NT_STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS },
	{ "NT_STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT", NT_STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT },
	{ "NT_STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM", NT_STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN", NT_STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN },
	{ "NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT", NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT },
	{ "NT_STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED", NT_STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED },
	{ "NT_STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION", NT_STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION },
	{ "NT_STATUS_GRAPHICS_INVALID_CLIENT_TYPE", NT_STATUS_GRAPHICS_INVALID_CLIENT_TYPE },
	{ "NT_STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET", NT_STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET },
	{ "NT_STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED", NT_STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED },
	{ "NT_STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED", NT_STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER", NT_STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER },
	{ "NT_STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED", NT_STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED },
	{ "NT_STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED", NT_STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED },
	{ "NT_STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY", NT_STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY },
	{ "NT_STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED", NT_STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED },
	{ "NT_STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON", NT_STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON },
	{ "NT_STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE", NT_STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE },
	{ "NT_STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER", NT_STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER },
	{ "NT_STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED", NT_STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED },
	{ "NT_STATUS_GRAPHICS_OPM_NOT_SUPPORTED", NT_STATUS_GRAPHICS_OPM_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_COPP_NOT_SUPPORTED", NT_STATUS_GRAPHICS_COPP_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_UAB_NOT_SUPPORTED", NT_STATUS_GRAPHICS_UAB_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS", NT_STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS },
	{ "NT_STATUS_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL", NT_STATUS_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL },
	{ "NT_STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST", NT_STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST },
	{ "NT_STATUS_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME", NT_STATUS_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME },
	{ "NT_STATUS_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP", NT_STATUS_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP },
	{ "NT_STATUS_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED", NT_STATUS_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_OPM_INVALID_POINTER", NT_STATUS_GRAPHICS_OPM_INVALID_POINTER },
	{ "NT_STATUS_GRAPHICS_OPM_INTERNAL_ERROR", NT_STATUS_GRAPHICS_OPM_INTERNAL_ERROR },
	{ "NT_STATUS_GRAPHICS_OPM_INVALID_HANDLE", NT_STATUS_GRAPHICS_OPM_INVALID_HANDLE },
	{ "NT_STATUS_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE", NT_STATUS_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE },
	{ "NT_STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH", NT_STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH },
	{ "NT_STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED", NT_STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED },
	{ "NT_STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED", NT_STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED },
	{ "NT_STATUS_GRAPHICS_PVP_HFS_FAILED", NT_STATUS_GRAPHICS_PVP_HFS_FAILED },
	{ "NT_STATUS_GRAPHICS_OPM_INVALID_SRM", NT_STATUS_GRAPHICS_OPM_INVALID_SRM },
	{ "NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP", NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP },
	{ "NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP", NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP },
	{ "NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA", NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA },
	{ "NT_STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET", NT_STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET },
	{ "NT_STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH", NT_STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH },
	{ "NT_STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE", NT_STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE },
	{ "NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS", NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS },
	{ "NT_STATUS_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS", NT_STATUS_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS },
	{ "NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS", NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS },
	{ "NT_STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST", NT_STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST },
	{ "NT_STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR", NT_STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR },
	{ "NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS", NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS },
	{ "NT_STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED", NT_STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST", NT_STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST },
	{ "NT_STATUS_GRAPHICS_I2C_NOT_SUPPORTED", NT_STATUS_GRAPHICS_I2C_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST", NT_STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST },
	{ "NT_STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA", NT_STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA },
	{ "NT_STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA", NT_STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA },
	{ "NT_STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED", NT_STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_DDCCI_INVALID_DATA", NT_STATUS_GRAPHICS_DDCCI_INVALID_DATA },
	{ "NT_STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE", NT_STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE },
	{ "NT_STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING", NT_STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING },
	{ "NT_STATUS_GRAPHICS_MCA_INTERNAL_ERROR", NT_STATUS_GRAPHICS_MCA_INTERNAL_ERROR },
	{ "NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND", NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND },
	{ "NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH", NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH },
	{ "NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM", NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM },
	{ "NT_STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE", NT_STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE },
	{ "NT_STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS", NT_STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS },
	{ "NT_STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED", NT_STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME", NT_STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME },
	{ "NT_STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP", NT_STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP },
	{ "NT_STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED", NT_STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED },
	{ "NT_STATUS_GRAPHICS_INVALID_POINTER", NT_STATUS_GRAPHICS_INVALID_POINTER },
	{ "NT_STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE", NT_STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE },
	{ "NT_STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL", NT_STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL },
	{ "NT_STATUS_GRAPHICS_INTERNAL_ERROR", NT_STATUS_GRAPHICS_INTERNAL_ERROR },
	{ "NT_STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS", NT_STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS },
	{ "NT_STATUS_FVE_LOCKED_VOLUME", NT_STATUS_FVE_LOCKED_VOLUME },
	{ "NT_STATUS_FVE_NOT_ENCRYPTED", NT_STATUS_FVE_NOT_ENCRYPTED },
	{ "NT_STATUS_FVE_BAD_INFORMATION", NT_STATUS_FVE_BAD_INFORMATION },
	{ "NT_STATUS_FVE_TOO_SMALL", NT_STATUS_FVE_TOO_SMALL },
	{ "NT_STATUS_FVE_FAILED_WRONG_FS", NT_STATUS_FVE_FAILED_WRONG_FS },
	{ "NT_STATUS_FVE_FAILED_BAD_FS", NT_STATUS_FVE_FAILED_BAD_FS },
	{ "NT_STATUS_FVE_FS_NOT_EXTENDED", NT_STATUS_FVE_FS_NOT_EXTENDED },
	{ "NT_STATUS_FVE_FS_MOUNTED", NT_STATUS_FVE_FS_MOUNTED },
	{ "NT_STATUS_FVE_NO_LICENSE", NT_STATUS_FVE_NO_LICENSE },
	{ "NT_STATUS_FVE_ACTION_NOT_ALLOWED", NT_STATUS_FVE_ACTION_NOT_ALLOWED },
	{ "NT_STATUS_FVE_BAD_DATA", NT_STATUS_FVE_BAD_DATA },
	{ "NT_STATUS_FVE_VOLUME_NOT_BOUND", NT_STATUS_FVE_VOLUME_NOT_BOUND },
	{ "NT_STATUS_FVE_NOT_DATA_VOLUME", NT_STATUS_FVE_NOT_DATA_VOLUME },
	{ "NT_STATUS_FVE_CONV_READ_ERROR", NT_STATUS_FVE_CONV_READ_ERROR },
	{ "NT_STATUS_FVE_CONV_WRITE_ERROR", NT_STATUS_FVE_CONV_WRITE_ERROR },
	{ "NT_STATUS_FVE_OVERLAPPED_UPDATE", NT_STATUS_FVE_OVERLAPPED_UPDATE },
	{ "NT_STATUS_FVE_FAILED_SECTOR_SIZE", NT_STATUS_FVE_FAILED_SECTOR_SIZE },
	{ "NT_STATUS_FVE_FAILED_AUTHENTICATION", NT_STATUS_FVE_FAILED_AUTHENTICATION },
	{ "NT_STATUS_FVE_NOT_OS_VOLUME", NT_STATUS_FVE_NOT_OS_VOLUME },
	{ "NT_STATUS_FVE_KEYFILE_NOT_FOUND", NT_STATUS_FVE_KEYFILE_NOT_FOUND },
	{ "NT_STATUS_FVE_KEYFILE_INVALID", NT_STATUS_FVE_KEYFILE_INVALID },
	{ "NT_STATUS_FVE_KEYFILE_NO_VMK", NT_STATUS_FVE_KEYFILE_NO_VMK },
	{ "NT_STATUS_FVE_TPM_DISABLED", NT_STATUS_FVE_TPM_DISABLED },
	{ "NT_STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO", NT_STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO },
	{ "NT_STATUS_FVE_TPM_INVALID_PCR", NT_STATUS_FVE_TPM_INVALID_PCR },
	{ "NT_STATUS_FVE_TPM_NO_VMK", NT_STATUS_FVE_TPM_NO_VMK },
	{ "NT_STATUS_FVE_PIN_INVALID", NT_STATUS_FVE_PIN_INVALID },
	{ "NT_STATUS_FVE_AUTH_INVALID_APPLICATION", NT_STATUS_FVE_AUTH_INVALID_APPLICATION },
	{ "NT_STATUS_FVE_AUTH_INVALID_CONFIG", NT_STATUS_FVE_AUTH_INVALID_CONFIG },
	{ "NT_STATUS_FVE_DEBUGGER_ENABLED", NT_STATUS_FVE_DEBUGGER_ENABLED },
	{ "NT_STATUS_FVE_DRY_RUN_FAILED", NT_STATUS_FVE_DRY_RUN_FAILED },
	{ "NT_STATUS_FVE_BAD_METADATA_POINTER", NT_STATUS_FVE_BAD_METADATA_POINTER },
	{ "NT_STATUS_FVE_OLD_METADATA_COPY", NT_STATUS_FVE_OLD_METADATA_COPY },
	{ "NT_STATUS_FVE_REBOOT_REQUIRED", NT_STATUS_FVE_REBOOT_REQUIRED },
	{ "NT_STATUS_FVE_RAW_ACCESS", NT_STATUS_FVE_RAW_ACCESS },
	{ "NT_STATUS_FVE_RAW_BLOCKED", NT_STATUS_FVE_RAW_BLOCKED },
	{ "NT_STATUS_FVE_NO_FEATURE_LICENSE", NT_STATUS_FVE_NO_FEATURE_LICENSE },
	{ "NT_STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED", NT_STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED },
	{ "NT_STATUS_FVE_CONV_RECOVERY_FAILED", NT_STATUS_FVE_CONV_RECOVERY_FAILED },
	{ "NT_STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG", NT_STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG },
	{ "NT_STATUS_FVE_VOLUME_TOO_SMALL", NT_STATUS_FVE_VOLUME_TOO_SMALL },
	{ "NT_STATUS_FWP_CALLOUT_NOT_FOUND", NT_STATUS_FWP_CALLOUT_NOT_FOUND },
	{ "NT_STATUS_FWP_CONDITION_NOT_FOUND", NT_STATUS_FWP_CONDITION_NOT_FOUND },
	{ "NT_STATUS_FWP_FILTER_NOT_FOUND", NT_STATUS_FWP_FILTER_NOT_FOUND },
	{ "NT_STATUS_FWP_LAYER_NOT_FOUND", NT_STATUS_FWP_LAYER_NOT_FOUND },
	{ "NT_STATUS_FWP_PROVIDER_NOT_FOUND", NT_STATUS_FWP_PROVIDER_NOT_FOUND },
	{ "NT_STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND", NT_STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND },
	{ "NT_STATUS_FWP_SUBLAYER_NOT_FOUND", NT_STATUS_FWP_SUBLAYER_NOT_FOUND },
	{ "NT_STATUS_FWP_NOT_FOUND", NT_STATUS_FWP_NOT_FOUND },
	{ "NT_STATUS_FWP_ALREADY_EXISTS", NT_STATUS_FWP_ALREADY_EXISTS },
	{ "NT_STATUS_FWP_IN_USE", NT_STATUS_FWP_IN_USE },
	{ "NT_STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS", NT_STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS },
	{ "NT_STATUS_FWP_WRONG_SESSION", NT_STATUS_FWP_WRONG_SESSION },
	{ "NT_STATUS_FWP_NO_TXN_IN_PROGRESS", NT_STATUS_FWP_NO_TXN_IN_PROGRESS },
	{ "NT_STATUS_FWP_TXN_IN_PROGRESS", NT_STATUS_FWP_TXN_IN_PROGRESS },
	{ "NT_STATUS_FWP_TXN_ABORTED", NT_STATUS_FWP_TXN_ABORTED },
	{ "NT_STATUS_FWP_SESSION_ABORTED", NT_STATUS_FWP_SESSION_ABORTED },
	{ "NT_STATUS_FWP_INCOMPATIBLE_TXN", NT_STATUS_FWP_INCOMPATIBLE_TXN },
	{ "NT_STATUS_FWP_TIMEOUT", NT_STATUS_FWP_TIMEOUT },
	{ "NT_STATUS_FWP_NET_EVENTS_DISABLED", NT_STATUS_FWP_NET_EVENTS_DISABLED },
	{ "NT_STATUS_FWP_INCOMPATIBLE_LAYER", NT_STATUS_FWP_INCOMPATIBLE_LAYER },
	{ "NT_STATUS_FWP_KM_CLIENTS_ONLY", NT_STATUS_FWP_KM_CLIENTS_ONLY },
	{ "NT_STATUS_FWP_LIFETIME_MISMATCH", NT_STATUS_FWP_LIFETIME_MISMATCH },
	{ "NT_STATUS_FWP_BUILTIN_OBJECT", NT_STATUS_FWP_BUILTIN_OBJECT },
	{ "NT_STATUS_FWP_TOO_MANY_BOOTTIME_FILTERS", NT_STATUS_FWP_TOO_MANY_BOOTTIME_FILTERS },
	{ "NT_STATUS_FWP_TOO_MANY_CALLOUTS", NT_STATUS_FWP_TOO_MANY_CALLOUTS },
	{ "NT_STATUS_FWP_NOTIFICATION_DROPPED", NT_STATUS_FWP_NOTIFICATION_DROPPED },
	{ "NT_STATUS_FWP_TRAFFIC_MISMATCH", NT_STATUS_FWP_TRAFFIC_MISMATCH },
	{ "NT_STATUS_FWP_INCOMPATIBLE_SA_STATE", NT_STATUS_FWP_INCOMPATIBLE_SA_STATE },
	{ "NT_STATUS_FWP_NULL_POINTER", NT_STATUS_FWP_NULL_POINTER },
	{ "NT_STATUS_FWP_INVALID_ENUMERATOR", NT_STATUS_FWP_INVALID_ENUMERATOR },
	{ "NT_STATUS_FWP_INVALID_FLAGS", NT_STATUS_FWP_INVALID_FLAGS },
	{ "NT_STATUS_FWP_INVALID_NET_MASK", NT_STATUS_FWP_INVALID_NET_MASK },
	{ "NT_STATUS_FWP_INVALID_RANGE", NT_STATUS_FWP_INVALID_RANGE },
	{ "NT_STATUS_FWP_INVALID_INTERVAL", NT_STATUS_FWP_INVALID_INTERVAL },
	{ "NT_STATUS_FWP_ZERO_LENGTH_ARRAY", NT_STATUS_FWP_ZERO_LENGTH_ARRAY },
	{ "NT_STATUS_FWP_NULL_DISPLAY_NAME", NT_STATUS_FWP_NULL_DISPLAY_NAME },
	{ "NT_STATUS_FWP_INVALID_ACTION_TYPE", NT_STATUS_FWP_INVALID_ACTION_TYPE },
	{ "NT_STATUS_FWP_INVALID_WEIGHT", NT_STATUS_FWP_INVALID_WEIGHT },
	{ "NT_STATUS_FWP_MATCH_TYPE_MISMATCH", NT_STATUS_FWP_MATCH_TYPE_MISMATCH },
	{ "NT_STATUS_FWP_TYPE_MISMATCH", NT_STATUS_FWP_TYPE_MISMATCH },
	{ "NT_STATUS_FWP_OUT_OF_BOUNDS", NT_STATUS_FWP_OUT_OF_BOUNDS },
	{ "NT_STATUS_FWP_RESERVED", NT_STATUS_FWP_RESERVED },
	{ "NT_STATUS_FWP_DUPLICATE_CONDITION", NT_STATUS_FWP_DUPLICATE_CONDITION },
	{ "NT_STATUS_FWP_DUPLICATE_KEYMOD", NT_STATUS_FWP_DUPLICATE_KEYMOD },
	{ "NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER", NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER },
	{ "NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER", NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER },
	{ "NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER", NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER },
	{ "NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT", NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT },
	{ "NT_STATUS_FWP_INCOMPATIBLE_AUTH_METHOD", NT_STATUS_FWP_INCOMPATIBLE_AUTH_METHOD },
	{ "NT_STATUS_FWP_INCOMPATIBLE_DH_GROUP", NT_STATUS_FWP_INCOMPATIBLE_DH_GROUP },
	{ "NT_STATUS_FWP_EM_NOT_SUPPORTED", NT_STATUS_FWP_EM_NOT_SUPPORTED },
	{ "NT_STATUS_FWP_NEVER_MATCH", NT_STATUS_FWP_NEVER_MATCH },
	{ "NT_STATUS_FWP_PROVIDER_CONTEXT_MISMATCH", NT_STATUS_FWP_PROVIDER_CONTEXT_MISMATCH },
	{ "NT_STATUS_FWP_INVALID_PARAMETER", NT_STATUS_FWP_INVALID_PARAMETER },
	{ "NT_STATUS_FWP_TOO_MANY_SUBLAYERS", NT_STATUS_FWP_TOO_MANY_SUBLAYERS },
	{ "NT_STATUS_FWP_CALLOUT_NOTIFICATION_FAILED", NT_STATUS_FWP_CALLOUT_NOTIFICATION_FAILED },
	{ "NT_STATUS_FWP_INCOMPATIBLE_AUTH_CONFIG", NT_STATUS_FWP_INCOMPATIBLE_AUTH_CONFIG },
	{ "NT_STATUS_FWP_INCOMPATIBLE_CIPHER_CONFIG", NT_STATUS_FWP_INCOMPATIBLE_CIPHER_CONFIG },
	{ "NT_STATUS_FWP_DUPLICATE_AUTH_METHOD", NT_STATUS_FWP_DUPLICATE_AUTH_METHOD },
	{ "NT_STATUS_FWP_TCPIP_NOT_READY", NT_STATUS_FWP_TCPIP_NOT_READY },
	{ "NT_STATUS_FWP_INJECT_HANDLE_CLOSING", NT_STATUS_FWP_INJECT_HANDLE_CLOSING },
	{ "NT_STATUS_FWP_INJECT_HANDLE_STALE", NT_STATUS_FWP_INJECT_HANDLE_STALE },
	{ "NT_STATUS_FWP_CANNOT_PEND", NT_STATUS_FWP_CANNOT_PEND },
	{ "NT_STATUS_NDIS_CLOSING", NT_STATUS_NDIS_CLOSING },
	{ "NT_STATUS_NDIS_BAD_VERSION", NT_STATUS_NDIS_BAD_VERSION },
	{ "NT_STATUS_NDIS_BAD_CHARACTERISTICS", NT_STATUS_NDIS_BAD_CHARACTERISTICS },
	{ "NT_STATUS_NDIS_ADAPTER_NOT_FOUND", NT_STATUS_NDIS_ADAPTER_NOT_FOUND },
	{ "NT_STATUS_NDIS_OPEN_FAILED", NT_STATUS_NDIS_OPEN_FAILED },
	{ "NT_STATUS_NDIS_DEVICE_FAILED", NT_STATUS_NDIS_DEVICE_FAILED },
	{ "NT_STATUS_NDIS_MULTICAST_FULL", NT_STATUS_NDIS_MULTICAST_FULL },
	{ "NT_STATUS_NDIS_MULTICAST_EXISTS", NT_STATUS_NDIS_MULTICAST_EXISTS },
	{ "NT_STATUS_NDIS_MULTICAST_NOT_FOUND", NT_STATUS_NDIS_MULTICAST_NOT_FOUND },
	{ "NT_STATUS_NDIS_REQUEST_ABORTED", NT_STATUS_NDIS_REQUEST_ABORTED },
	{ "NT_STATUS_NDIS_RESET_IN_PROGRESS", NT_STATUS_NDIS_RESET_IN_PROGRESS },
	{ "NT_STATUS_NDIS_INVALID_PACKET", NT_STATUS_NDIS_INVALID_PACKET },
	{ "NT_STATUS_NDIS_INVALID_DEVICE_REQUEST", NT_STATUS_NDIS_INVALID_DEVICE_REQUEST },
	{ "NT_STATUS_NDIS_ADAPTER_NOT_READY", NT_STATUS_NDIS_ADAPTER_NOT_READY },
	{ "NT_STATUS_NDIS_INVALID_LENGTH", NT_STATUS_NDIS_INVALID_LENGTH },
	{ "NT_STATUS_NDIS_INVALID_DATA", NT_STATUS_NDIS_INVALID_DATA },
	{ "NT_STATUS_NDIS_BUFFER_TOO_SHORT", NT_STATUS_NDIS_BUFFER_TOO_SHORT },
	{ "NT_STATUS_NDIS_INVALID_OID", NT_STATUS_NDIS_INVALID_OID },
	{ "NT_STATUS_NDIS_ADAPTER_REMOVED", NT_STATUS_NDIS_ADAPTER_REMOVED },
	{ "NT_STATUS_NDIS_UNSUPPORTED_MEDIA", NT_STATUS_NDIS_UNSUPPORTED_MEDIA },
	{ "NT_STATUS_NDIS_GROUP_ADDRESS_IN_USE", NT_STATUS_NDIS_GROUP_ADDRESS_IN_USE },
	{ "NT_STATUS_NDIS_FILE_NOT_FOUND", NT_STATUS_NDIS_FILE_NOT_FOUND },
	{ "NT_STATUS_NDIS_ERROR_READING_FILE", NT_STATUS_NDIS_ERROR_READING_FILE },
	{ "NT_STATUS_NDIS_ALREADY_MAPPED", NT_STATUS_NDIS_ALREADY_MAPPED },
	{ "NT_STATUS_NDIS_RESOURCE_CONFLICT", NT_STATUS_NDIS_RESOURCE_CONFLICT },
	{ "NT_STATUS_NDIS_MEDIA_DISCONNECTED", NT_STATUS_NDIS_MEDIA_DISCONNECTED },
	{ "NT_STATUS_NDIS_INVALID_ADDRESS", NT_STATUS_NDIS_INVALID_ADDRESS },
	{ "NT_STATUS_NDIS_PAUSED", NT_STATUS_NDIS_PAUSED },
	{ "NT_STATUS_NDIS_INTERFACE_NOT_FOUND", NT_STATUS_NDIS_INTERFACE_NOT_FOUND },
	{ "NT_STATUS_NDIS_UNSUPPORTED_REVISION", NT_STATUS_NDIS_UNSUPPORTED_REVISION },
	{ "NT_STATUS_NDIS_INVALID_PORT", NT_STATUS_NDIS_INVALID_PORT },
	{ "NT_STATUS_NDIS_INVALID_PORT_STATE", NT_STATUS_NDIS_INVALID_PORT_STATE },
	{ "NT_STATUS_NDIS_LOW_POWER_STATE", NT_STATUS_NDIS_LOW_POWER_STATE },
	{ "NT_STATUS_NDIS_NOT_SUPPORTED", NT_STATUS_NDIS_NOT_SUPPORTED },
	{ "NT_STATUS_NDIS_OFFLOAD_POLICY", NT_STATUS_NDIS_OFFLOAD_POLICY },
	{ "NT_STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED", NT_STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED },
	{ "NT_STATUS_NDIS_OFFLOAD_PATH_REJECTED", NT_STATUS_NDIS_OFFLOAD_PATH_REJECTED },
	{ "NT_STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED", NT_STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED },
	{ "NT_STATUS_NDIS_DOT11_MEDIA_IN_USE", NT_STATUS_NDIS_DOT11_MEDIA_IN_USE },
	{ "NT_STATUS_NDIS_DOT11_POWER_STATE_INVALID", NT_STATUS_NDIS_DOT11_POWER_STATE_INVALID },
	{ "NT_STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL", NT_STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL },
	{ "NT_STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL", NT_STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL },
	{ "NT_STATUS_IPSEC_BAD_SPI", NT_STATUS_IPSEC_BAD_SPI },
	{ "NT_STATUS_IPSEC_SA_LIFETIME_EXPIRED", NT_STATUS_IPSEC_SA_LIFETIME_EXPIRED },
	{ "NT_STATUS_IPSEC_WRONG_SA", NT_STATUS_IPSEC_WRONG_SA },
	{ "NT_STATUS_IPSEC_REPLAY_CHECK_FAILED", NT_STATUS_IPSEC_REPLAY_CHECK_FAILED },
	{ "NT_STATUS_IPSEC_INVALID_PACKET", NT_STATUS_IPSEC_INVALID_PACKET },
	{ "NT_STATUS_IPSEC_INTEGRITY_CHECK_FAILED", NT_STATUS_IPSEC_INTEGRITY_CHECK_FAILED },
	{ "NT_STATUS_IPSEC_CLEAR_TEXT_DROP", NT_STATUS_IPSEC_CLEAR_TEXT_DROP },
	{ "NT_STATUS_IPSEC_AUTH_FIREWALL_DROP", NT_STATUS_IPSEC_AUTH_FIREWALL_DROP },
	{ "NT_STATUS_IPSEC_THROTTLE_DROP", NT_STATUS_IPSEC_THROTTLE_DROP },
	{ "NT_STATUS_IPSEC_DOSP_BLOCK", NT_STATUS_IPSEC_DOSP_BLOCK },
	{ "NT_STATUS_IPSEC_DOSP_RECEIVED_MULTICAST", NT_STATUS_IPSEC_DOSP_RECEIVED_MULTICAST },
	{ "NT_STATUS_IPSEC_DOSP_INVALID_PACKET", NT_STATUS_IPSEC_DOSP_INVALID_PACKET },
	{ "NT_STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED", NT_STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED },
	{ "NT_STATUS_IPSEC_DOSP_MAX_ENTRIES", NT_STATUS_IPSEC_DOSP_MAX_ENTRIES },
	{ "NT_STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED", NT_STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED },
	{ "NT_STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES", NT_STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES },
	{ "NT_STATUS_VOLMGR_MIRROR_NOT_SUPPORTED", NT_STATUS_VOLMGR_MIRROR_NOT_SUPPORTED },
	{ "NT_STATUS_VOLMGR_RAID5_NOT_SUPPORTED", NT_STATUS_VOLMGR_RAID5_NOT_SUPPORTED },
	{ "NT_STATUS_VIRTDISK_PROVIDER_NOT_FOUND", NT_STATUS_VIRTDISK_PROVIDER_NOT_FOUND },
	{ "NT_STATUS_VIRTDISK_NOT_VIRTUAL_DISK", NT_STATUS_VIRTDISK_NOT_VIRTUAL_DISK },
	{ "NT_STATUS_VHD_PARENT_VHD_ACCESS_DENIED", NT_STATUS_VHD_PARENT_VHD_ACCESS_DENIED },
	{ "NT_STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH", NT_STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH },
	{ "NT_STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED", NT_STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED },
	{ "NT_STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT", NT_STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT },
	{ "NT_STATUS_VHD_SHARED", NT_STATUS_VHD_SHARED },
	{ "NT_STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP", NT_STATUS_SMB_NO_PREAUTH_INTEGRITY_HASH_OVERLAP },
	{ "NT_STATUS_SMB_BAD_CLUSTER_DIALECT", NT_STATUS_SMB_BAD_CLUSTER_DIALECT },

	DOS_CODE(ERRDOS, ERRsuccess),
	DOS_CODE(ERRDOS, ERRbadfunc),
	DOS_CODE(ERRDOS, ERRbadfile),
	DOS_CODE(ERRDOS, ERRbadpath),
	DOS_CODE(ERRDOS, ERRnofids),
	DOS_CODE(ERRDOS, ERRnoaccess),
	DOS_CODE(ERRDOS, ERRbadfid),
	DOS_CODE(ERRDOS, ERRbadmcb),
	DOS_CODE(ERRDOS, ERRnomem),
	DOS_CODE(ERRDOS, ERRbadmem),
	DOS_CODE(ERRDOS, ERRbadenv),
	DOS_CODE(ERRDOS, ERRbadaccess),
	DOS_CODE(ERRDOS, ERRbaddata),
	DOS_CODE(ERRDOS, ERRres),
	DOS_CODE(ERRDOS, ERRbaddrive),
	DOS_CODE(ERRDOS, ERRremcd),
	DOS_CODE(ERRDOS, ERRdiffdevice),
	DOS_CODE(ERRDOS, ERRnofiles),
	DOS_CODE(ERRDOS, ERRgeneral),
	DOS_CODE(ERRDOS, ERRbadshare),
	DOS_CODE(ERRDOS, ERRlock),
	DOS_CODE(ERRDOS, ERRunsup),
	DOS_CODE(ERRDOS, ERRnetnamedel),
	DOS_CODE(ERRDOS, ERRnosuchshare),
	DOS_CODE(ERRDOS, ERRfilexists),
	DOS_CODE(ERRDOS, ERRinvalidparam),
	DOS_CODE(ERRDOS, ERRcannotopen),
	DOS_CODE(ERRDOS, ERRinsufficientbuffer),
	DOS_CODE(ERRDOS, ERRinvalidname),
	DOS_CODE(ERRDOS, ERRunknownlevel),
	DOS_CODE(ERRDOS, ERRnotlocked),
	DOS_CODE(ERRDOS, ERRinvalidpath),
	DOS_CODE(ERRDOS, ERRcancelviolation),
	DOS_CODE(ERRDOS, ERRnoatomiclocks),
	DOS_CODE(ERRDOS, ERRrename),
	DOS_CODE(ERRDOS, ERRbadpipe),
	DOS_CODE(ERRDOS, ERRpipebusy),
	DOS_CODE(ERRDOS, ERRpipeclosing),
	DOS_CODE(ERRDOS, ERRnotconnected),
	DOS_CODE(ERRDOS, ERRmoredata),
	DOS_CODE(ERRDOS, ERRnomoreitems),
	DOS_CODE(ERRDOS, ERRbaddirectory),
	DOS_CODE(ERRDOS, ERReasnotsupported),
	DOS_CODE(ERRDOS, ERRlogonfailure),
	DOS_CODE(ERRDOS, ERRbuftoosmall),
	DOS_CODE(ERRDOS, ERRunknownipc),
	DOS_CODE(ERRDOS, ERRnosuchprintjob),
	DOS_CODE(ERRDOS, ERRinvgroup),
	DOS_CODE(ERRDOS, ERRnoipc),
	DOS_CODE(ERRDOS, ERRdriveralreadyinstalled),
	DOS_CODE(ERRDOS, ERRunknownprinterport),
	DOS_CODE(ERRDOS, ERRunknownprinterdriver),
	DOS_CODE(ERRDOS, ERRunknownprintprocessor),
	DOS_CODE(ERRDOS, ERRinvalidseparatorfile),
	DOS_CODE(ERRDOS, ERRinvalidjobpriority),
	DOS_CODE(ERRDOS, ERRinvalidprintername),
	DOS_CODE(ERRDOS, ERRprinteralreadyexists),
	DOS_CODE(ERRDOS, ERRinvalidprintercommand),
	DOS_CODE(ERRDOS, ERRinvaliddatatype),
	DOS_CODE(ERRDOS, ERRinvalidenvironment),
	DOS_CODE(ERRDOS, ERRunknownprintmonitor),
	DOS_CODE(ERRDOS, ERRprinterdriverinuse),
	DOS_CODE(ERRDOS, ERRspoolfilenotfound),
	DOS_CODE(ERRDOS, ERRnostartdoc),
	DOS_CODE(ERRDOS, ERRnoaddjob),
	DOS_CODE(ERRDOS, ERRprintprocessoralreadyinstalled),
	DOS_CODE(ERRDOS, ERRprintmonitoralreadyinstalled),
	DOS_CODE(ERRDOS, ERRinvalidprintmonitor),
	DOS_CODE(ERRDOS, ERRprintmonitorinuse),
	DOS_CODE(ERRDOS, ERRprinterhasjobsqueued),
	DOS_CODE(ERRDOS, ERReainconsistent),

	DOS_CODE(ERRSRV, ERRerror),
	DOS_CODE(ERRSRV, ERRbadpw),
	DOS_CODE(ERRSRV, ERRbadtype),
	DOS_CODE(ERRSRV, ERRaccess),
	DOS_CODE(ERRSRV, ERRinvnid),
	DOS_CODE(ERRSRV, ERRinvnetname),
	DOS_CODE(ERRSRV, ERRinvdevice),
	DOS_CODE(ERRSRV, ERRqfull),
	DOS_CODE(ERRSRV, ERRqtoobig),
	DOS_CODE(ERRSRV, ERRinvpfid),
	DOS_CODE(ERRSRV, ERRsmbcmd),
	DOS_CODE(ERRSRV, ERRsrverror),
	DOS_CODE(ERRSRV, ERRfilespecs),
	DOS_CODE(ERRSRV, ERRbadlink),
	DOS_CODE(ERRSRV, ERRbadpermits),
	DOS_CODE(ERRSRV, ERRbadpid),
	DOS_CODE(ERRSRV, ERRsetattrmode),
	DOS_CODE(ERRSRV, ERRpaused),
	DOS_CODE(ERRSRV, ERRmsgoff),
	DOS_CODE(ERRSRV, ERRnoroom),
	DOS_CODE(ERRSRV, ERRrmuns),
	DOS_CODE(ERRSRV, ERRtimeout),
	DOS_CODE(ERRSRV, ERRnoresource),
	DOS_CODE(ERRSRV, ERRtoomanyuids),
	DOS_CODE(ERRSRV, ERRbaduid),
	DOS_CODE(ERRSRV, ERRuseMPX),
	DOS_CODE(ERRSRV, ERRuseSTD),
	DOS_CODE(ERRSRV, ERRcontMPX),
	DOS_CODE(ERRSRV, ERRnosupport),
	DOS_CODE(ERRSRV, ERRunknownsmb),

	DOS_CODE(ERRHRD, ERRnowrite),
	DOS_CODE(ERRHRD, ERRbadunit),
	DOS_CODE(ERRHRD, ERRnotready),
	DOS_CODE(ERRHRD, ERRbadcmd),
	DOS_CODE(ERRHRD, ERRdata),
	DOS_CODE(ERRHRD, ERRbadreq),
	DOS_CODE(ERRHRD, ERRseek),
	DOS_CODE(ERRHRD, ERRbadmedia),
	DOS_CODE(ERRHRD, ERRbadsector),
	DOS_CODE(ERRHRD, ERRnopaper),
	DOS_CODE(ERRHRD, ERRwrite),
	DOS_CODE(ERRHRD, ERRread),
	DOS_CODE(ERRHRD, ERRgeneral),
	DOS_CODE(ERRHRD, ERRwrongdisk),
	DOS_CODE(ERRHRD, ERRFCBunavail),
	DOS_CODE(ERRHRD, ERRsharebufexc),
	DOS_CODE(ERRHRD, ERRdiskfull),

	LDAP_CODE(LDAP_SUCCESS),
	LDAP_CODE(LDAP_OPERATIONS_ERROR),
	LDAP_CODE(LDAP_PROTOCOL_ERROR),
	LDAP_CODE(LDAP_TIME_LIMIT_EXCEEDED),
	LDAP_CODE(LDAP_SIZE_LIMIT_EXCEEDED),
	LDAP_CODE(LDAP_COMPARE_FALSE),
	LDAP_CODE(LDAP_COMPARE_TRUE),
	LDAP_CODE(LDAP_AUTH_METHOD_NOT_SUPPORTED),
	LDAP_CODE(LDAP_STRONG_AUTH_REQUIRED),
	LDAP_CODE(LDAP_REFERRAL),
	LDAP_CODE(LDAP_ADMIN_LIMIT_EXCEEDED),
	LDAP_CODE(LDAP_UNAVAILABLE_CRITICAL_EXTENSION),
	LDAP_CODE(LDAP_CONFIDENTIALITY_REQUIRED),
	LDAP_CODE(LDAP_SASL_BIND_IN_PROGRESS),
	LDAP_CODE(LDAP_NO_SUCH_ATTRIBUTE),
	LDAP_CODE(LDAP_UNDEFINED_ATTRIBUTE_TYPE),
	LDAP_CODE(LDAP_INAPPROPRIATE_MATCHING),
	LDAP_CODE(LDAP_CONSTRAINT_VIOLATION),
	LDAP_CODE(LDAP_ATTRIBUTE_OR_VALUE_EXISTS),
	LDAP_CODE(LDAP_INVALID_ATTRIBUTE_SYNTAX),
	LDAP_CODE(LDAP_NO_SUCH_OBJECT),
	LDAP_CODE(LDAP_ALIAS_PROBLEM),
	LDAP_CODE(LDAP_INVALID_DN_SYNTAX),
	LDAP_CODE(LDAP_ALIAS_DEREFERENCING_PROBLEM),
	LDAP_CODE(LDAP_INAPPROPRIATE_AUTHENTICATION),
	LDAP_CODE(LDAP_INVALID_CREDENTIALS),
	LDAP_CODE(LDAP_INSUFFICIENT_ACCESS_RIGHTS),
	LDAP_CODE(LDAP_BUSY),
	LDAP_CODE(LDAP_UNAVAILABLE),
	LDAP_CODE(LDAP_UNWILLING_TO_PERFORM),
	LDAP_CODE(LDAP_LOOP_DETECT),
	LDAP_CODE(LDAP_NAMING_VIOLATION),
	LDAP_CODE(LDAP_OBJECT_CLASS_VIOLATION),
	LDAP_CODE(LDAP_NOT_ALLOWED_ON_NON_LEAF),
	LDAP_CODE(LDAP_NOT_ALLOWED_ON_RDN),
	LDAP_CODE(LDAP_ENTRY_ALREADY_EXISTS),
	LDAP_CODE(LDAP_OBJECT_CLASS_MODS_PROHIBITED),
	LDAP_CODE(LDAP_AFFECTS_MULTIPLE_DSAS),
	LDAP_CODE(LDAP_OTHER),

	{ NULL, NT_STATUS(0) }
};

/* These need sorting..... */

const nt_err_code_struct nt_err_desc[] =
{
	{ N_("Success"), 				NT_STATUS_OK },
	{ N_("Undetermined error"), 		NT_STATUS_UNSUCCESSFUL },
	{ N_("Access denied"), 			NT_STATUS_ACCESS_DENIED },
	{ N_("Account locked out"), 		NT_STATUS_ACCOUNT_LOCKED_OUT },
	{ N_("Must change password"), 		NT_STATUS_PASSWORD_MUST_CHANGE },
	{ N_("Password is too short"), 		NT_STATUS_PWD_TOO_SHORT },
	{ N_("Password is too recent"), 		NT_STATUS_PWD_TOO_RECENT },
	{ N_("Password history conflict"), 		NT_STATUS_PWD_HISTORY_CONFLICT },
	{ N_("No logon servers"), 			NT_STATUS_NO_LOGON_SERVERS },
	{ N_("Improperly formed account name"), 	NT_STATUS_INVALID_ACCOUNT_NAME },
	{ N_("User exists"), 			NT_STATUS_USER_EXISTS },
	{ N_("No such user"), 			NT_STATUS_NO_SUCH_USER },
	{ N_("Group exists"), 			NT_STATUS_GROUP_EXISTS },
	{ N_("No such group"), 			NT_STATUS_NO_SUCH_GROUP },
	{ N_("Member not in group"), 		NT_STATUS_MEMBER_NOT_IN_GROUP },
	{ N_("Wrong Password"), 			NT_STATUS_WRONG_PASSWORD },
	{ N_("Ill formed password"), 		NT_STATUS_ILL_FORMED_PASSWORD },
	{ N_("Password restriction"), 		NT_STATUS_PASSWORD_RESTRICTION },
	{ N_("Logon failure"), 			NT_STATUS_LOGON_FAILURE },
	{ N_("Account restriction"), 		NT_STATUS_ACCOUNT_RESTRICTION },
	{ N_("Invalid logon hours"), 		NT_STATUS_INVALID_LOGON_HOURS },
	{ N_("Invalid workstation"), 		NT_STATUS_INVALID_WORKSTATION },
	{ N_("Password expired"), 			NT_STATUS_PASSWORD_EXPIRED },
	{ N_("Account disabled"), 			NT_STATUS_ACCOUNT_DISABLED },
	{ N_("Unexpected information received"), 	NT_STATUS_INVALID_PARAMETER },
	{ N_("Memory allocation error"), 		NT_STATUS_NO_MEMORY },
	{ N_("No domain controllers located"), 	NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND },
	{ N_("Account locked out"), 		NT_STATUS_ACCOUNT_LOCKED_OUT },
	{ N_("Named pipe not available"), 		NT_STATUS_PIPE_NOT_AVAILABLE },
	{ N_("Not implemented"), 			NT_STATUS_NOT_IMPLEMENTED },
	{ N_("Invalid information class"), 		NT_STATUS_INVALID_INFO_CLASS },
	{ N_("Information length mismatch"), 	NT_STATUS_INFO_LENGTH_MISMATCH },
	{ N_("Access violation"), 			NT_STATUS_ACCESS_VIOLATION },
	{ N_("Invalid handle"), 			NT_STATUS_INVALID_HANDLE },
	{ N_("Invalid parameter"), 			NT_STATUS_INVALID_PARAMETER },
	{ N_("No memory"), 				NT_STATUS_NO_MEMORY },
	{ N_("Buffer too small"), 			NT_STATUS_BUFFER_TOO_SMALL },
	{ N_("Revision mismatch"), 			NT_STATUS_REVISION_MISMATCH },
	{ N_("No logon servers"), 			NT_STATUS_NO_LOGON_SERVERS },
	{ N_("No such logon session"), 		NT_STATUS_NO_SUCH_LOGON_SESSION },
	{ N_("No such privilege"), 			NT_STATUS_NO_SUCH_PRIVILEGE },
	{ N_("Procedure not found"), 		NT_STATUS_PROCEDURE_NOT_FOUND },
	{ N_("Server disabled"), 			NT_STATUS_SERVER_DISABLED },
	{ N_("Invalid pipe state"), 		NT_STATUS_INVALID_PIPE_STATE },
	{ N_("Named pipe busy"), 			NT_STATUS_PIPE_BUSY },
	{ N_("Illegal function"),		 	NT_STATUS_ILLEGAL_FUNCTION },
	{ N_("Named pipe disconnected"), 		NT_STATUS_PIPE_DISCONNECTED },
	{ N_("Named pipe closing"), 		NT_STATUS_PIPE_CLOSING },
	{ N_("Remote host not listening"), 		NT_STATUS_REMOTE_NOT_LISTENING },
	{ N_("Duplicate name on network"), 		NT_STATUS_DUPLICATE_NAME },
	{ N_("Print queue is full"), 		NT_STATUS_PRINT_QUEUE_FULL },
	{ N_("No print spool space available"), 	NT_STATUS_NO_SPOOL_SPACE },
	{ N_("The network name cannot be found"),   NT_STATUS_BAD_NETWORK_NAME },
	{ N_("The connection was refused"),         NT_STATUS_CONNECTION_REFUSED },
	{ N_("Too many names"), 			NT_STATUS_TOO_MANY_NAMES },
	{ N_("Too many sessions"), 			NT_STATUS_TOO_MANY_SESSIONS },
	{ N_("Invalid server state"), 		NT_STATUS_INVALID_SERVER_STATE },
	{ N_("Invalid domain state"), 		NT_STATUS_INVALID_DOMAIN_STATE },
	{ N_("Invalid domain role"), 		NT_STATUS_INVALID_DOMAIN_ROLE },
	{ N_("No such domain"), 			NT_STATUS_NO_SUCH_DOMAIN },
	{ N_("Domain exists"), 			NT_STATUS_DOMAIN_EXISTS },
	{ N_("Domain limit exceeded"), 		NT_STATUS_DOMAIN_LIMIT_EXCEEDED },
	{ N_("Bad logon session state"), 		NT_STATUS_BAD_LOGON_SESSION_STATE },
	{ N_("Logon session collision"), 		NT_STATUS_LOGON_SESSION_COLLISION },
	{ N_("Invalid logon type"), 		NT_STATUS_INVALID_LOGON_TYPE },
	{ N_("Cancelled"), 				NT_STATUS_CANCELLED },
	{ N_("Invalid computer name"), 		NT_STATUS_INVALID_COMPUTER_NAME },
	{ N_("Logon server conflict"), 		NT_STATUS_LOGON_SERVER_CONFLICT },
	{ N_("Time difference at domain controller"), NT_STATUS_TIME_DIFFERENCE_AT_DC },
	{ N_("Pipe broken"), 			NT_STATUS_PIPE_BROKEN },
	{ N_("Registry corrupt"), 			NT_STATUS_REGISTRY_CORRUPT },
	{ N_("Too many secrets"), 			NT_STATUS_TOO_MANY_SECRETS },
	{ N_("Too many SIDs"), 			NT_STATUS_TOO_MANY_SIDS },
	{ N_("Lanmanager cross encryption required"), NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED },
	{ N_("Log file full"), 			NT_STATUS_LOG_FILE_FULL },
	{ N_("No trusted LSA secret"), 		NT_STATUS_NO_TRUST_LSA_SECRET },
	{ N_("No trusted SAM account"), 		NT_STATUS_NO_TRUST_SAM_ACCOUNT },
	{ N_("Trusted domain failure"), 		NT_STATUS_TRUSTED_DOMAIN_FAILURE },
	{ N_("Trust relationship failure"), 	NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE },
	{ N_("Trust failure"), 			NT_STATUS_TRUST_FAILURE },
	{ N_("Netlogon service not started"), 	NT_STATUS_NETLOGON_NOT_STARTED },
	{ N_("Account expired"), 			NT_STATUS_ACCOUNT_EXPIRED },
	{ N_("Network credential conflict"), 	NT_STATUS_NETWORK_CREDENTIAL_CONFLICT },
	{ N_("Remote session limit"), 		NT_STATUS_REMOTE_SESSION_LIMIT },
	{ N_("No logon interdomain trust account"), NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT },
	{ N_("No logon workstation trust account"), NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT },
	{ N_("No logon server trust account"), 	NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT },
	{ N_("Domain trust inconsistent"), 		NT_STATUS_DOMAIN_TRUST_INCONSISTENT },
	{ N_("No user session key available"), 	NT_STATUS_NO_USER_SESSION_KEY },
	{ N_("User session deleted"), 		NT_STATUS_USER_SESSION_DELETED },
	{ N_("Insufficient server resources"), 	NT_STATUS_INSUFF_SERVER_RESOURCES },
	{ N_("Insufficient logon information"), 	NT_STATUS_INSUFFICIENT_LOGON_INFO },

	{ N_("License quota exceeded"), 		NT_STATUS_LICENSE_QUOTA_EXCEEDED },
	{ N_("No more files"),			STATUS_NO_MORE_FILES },

	/*
	 * New descriptions for existing errors generated from
	 * [MS-ERREF] http://msdn.microsoft.com/en-us/library/cc704588.aspx
	 */

	{ N_("The operation that was requested is pending completion."), STATUS_PENDING },
	{ N_("Returned by enumeration APIs to indicate more information is available to successive calls."), STATUS_MORE_ENTRIES },
	{ N_("Some of the information to be translated has not been translated."), STATUS_SOME_UNMAPPED },
	{ N_("Indicates that a notify change request has been completed due to closing the handle that made the notify change request."), STATUS_NOTIFY_CLEANUP },
	{ N_("Indicates that a notify change request is being completed and that the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes."), STATUS_NOTIFY_ENUM_DIR },
	{ N_("The file is temporarily unavailable."), NT_STATUS_FILE_NOT_AVAILABLE },
	{ N_("{Buffer Overflow} The data was too large to fit into the specified buffer."), STATUS_BUFFER_OVERFLOW },
	{ N_("{No More EAs} No more extended attributes (EAs) were found for the file."), STATUS_NO_MORE_EAS },
	{ N_("{Illegal EA} The specified extended attribute (EA) name contains at least one illegal character."), STATUS_INVALID_EA_NAME },
	{ N_("{Inconsistent EA List} The extended attribute (EA) list is inconsistent."), STATUS_EA_LIST_INCONSISTENT },
	{ N_("{Invalid EA Flag} An invalid extended attribute (EA) flag was set."), STATUS_INVALID_EA_FLAG },
	{ N_("{No More Entries} No more entries are available from an enumeration operation."), NT_STATUS_NO_MORE_ENTRIES },
	{ N_("The create operation stopped after reaching a symbolic link."), NT_STATUS_INACCESSIBLE_SYSTEM_SHORTCUT },
	{ N_("The instruction at 0x%08lx referenced memory at 0x%08lx. The required data was not placed into memory because of an I/O error status of 0x%08lx."), NT_STATUS_IN_PAGE_ERROR },
	{ N_("The page file quota for the process has been exhausted."), NT_STATUS_PAGEFILE_QUOTA },
	{ N_("An invalid initial stack was specified in a call to NtCreateThread."), NT_STATUS_BAD_INITIAL_STACK },
	{ N_("An invalid initial start address was specified in a call to NtCreateThread."), NT_STATUS_BAD_INITIAL_PC },
	{ N_("An invalid client ID was specified."), NT_STATUS_INVALID_CID },
	{ N_("An attempt was made to cancel or set a timer that has an associated APC and the specified thread is not the thread that originally set the timer with an associated APC routine."), NT_STATUS_TIMER_NOT_CANCELED },
	{ N_("A device that does not exist was specified."), NT_STATUS_NO_SUCH_DEVICE },
	{ N_("{File Not Found} The file %hs does not exist."), NT_STATUS_NO_SUCH_FILE },
	{ N_("The specified request is not a valid operation for the target device."), NT_STATUS_INVALID_DEVICE_REQUEST },
	{ N_("The end-of-file marker has been reached. There is no valid data in the file beyond this marker."), NT_STATUS_END_OF_FILE },
	{ N_("{Wrong Volume} The wrong volume is in the drive. Insert volume %hs into drive %hs."), NT_STATUS_WRONG_VOLUME },
	{ N_("{No Disk} There is no disk in the drive. Insert a disk into drive %hs."), NT_STATUS_NO_MEDIA_IN_DEVICE },
	{ N_("{Unknown Disk Format} The disk in drive %hs is not formatted properly. Check the disk, and reformat it, if needed."), NT_STATUS_UNRECOGNIZED_MEDIA },
	{ N_("{Sector Not Found} The specified sector does not exist."), NT_STATUS_NONEXISTENT_SECTOR },
	{ N_("{Still Busy} The specified I/O request packet (IRP) cannot be disposed of because the I/O operation is not complete."), NT_STATUS_MORE_PROCESSING_REQUIRED },
	{ N_("{Conflicting Address Range} The specified address range conflicts with the address space."), NT_STATUS_CONFLICTING_ADDRESSES },
	{ N_("The address range to unmap is not a mapped view."), NT_STATUS_NOT_MAPPED_VIEW },
	{ N_("The virtual memory cannot be freed."), NT_STATUS_UNABLE_TO_FREE_VM },
	{ N_("The specified section cannot be deleted."), NT_STATUS_UNABLE_TO_DELETE_SECTION },
	{ N_("An invalid system service was specified in a system service call."), NT_STATUS_INVALID_SYSTEM_SERVICE },
	{ N_("{EXCEPTION} Illegal Instruction An attempt was made to execute an illegal instruction."), NT_STATUS_ILLEGAL_INSTRUCTION },
	{ N_("{Invalid Lock Sequence} An attempt was made to execute an invalid lock sequence."), NT_STATUS_INVALID_LOCK_SEQUENCE },
	{ N_("{Invalid Mapping} An attempt was made to create a view for a section that is bigger than the section."), NT_STATUS_INVALID_VIEW_SIZE },
	{ N_("{Bad File} The attributes of the specified mapping file for a section of memory cannot be read."), NT_STATUS_INVALID_FILE_FOR_SECTION },
	{ N_("{Already Committed} The specified address range is already committed."), NT_STATUS_ALREADY_COMMITTED },
	{ N_("{Wrong Type} There is a mismatch between the type of object that is required by the requested operation and the type of object that is specified in the request."), NT_STATUS_OBJECT_TYPE_MISMATCH },
	{ N_("{EXCEPTION} Cannot Continue Windows cannot continue from this exception."), NT_STATUS_NONCONTINUABLE_EXCEPTION },
	{ N_("An invalid exception disposition was returned by an exception handler."), NT_STATUS_INVALID_DISPOSITION },
	{ N_("Unwind exception code."), NT_STATUS_UNWIND },
	{ N_("An invalid or unaligned stack was encountered during an unwind operation."), NT_STATUS_BAD_STACK },
	{ N_("An invalid unwind target was encountered during an unwind operation."), NT_STATUS_INVALID_UNWIND_TARGET },
	{ N_("An attempt was made to unlock a page of memory that was not locked."), NT_STATUS_NOT_LOCKED },
	{ N_("A device parity error on an I/O operation."), NT_STATUS_PARITY_ERROR },
	{ N_("An attempt was made to decommit uncommitted virtual memory."), NT_STATUS_UNABLE_TO_DECOMMIT_VM },
	{ N_("An attempt was made to change the attributes on memory that has not been committed."), NT_STATUS_NOT_COMMITTED },
	{ N_("Invalid object attributes specified to NtCreatePort or invalid port attributes specified to NtConnectPort."), NT_STATUS_INVALID_PORT_ATTRIBUTES },
	{ N_("The length of the message that was passed to NtRequestPort or NtRequestWaitReplyPort is longer than the maximum message that is allowed by the port."), NT_STATUS_PORT_MESSAGE_TOO_LONG },
	{ N_("An invalid combination of parameters was specified."), NT_STATUS_INVALID_PARAMETER_MIX },
	{ N_("An attempt was made to lower a quota limit below the current usage."), NT_STATUS_INVALID_QUOTA_LOWER },
	{ N_("{Corrupt Disk} The file system structure on the disk is corrupt and unusable. Run the Chkdsk utility on the volume %hs."), NT_STATUS_DISK_CORRUPT_ERROR },
	{ N_("The object name is invalid."), NT_STATUS_OBJECT_NAME_INVALID },
	{ N_("The object name is not found."), NT_STATUS_OBJECT_NAME_NOT_FOUND },
	{ N_("The object name already exists."), NT_STATUS_OBJECT_NAME_COLLISION },
	{ N_("An attempt was made to send a message to a disconnected communication port."), NT_STATUS_PORT_DISCONNECTED },
	{ N_("An attempt was made to attach to a device that was already attached to another device."), NT_STATUS_DEVICE_ALREADY_ATTACHED },
	{ N_("The object path component was not a directory object."), NT_STATUS_OBJECT_PATH_INVALID },
	{ N_("{Path Not Found} The path %hs does not exist."), NT_STATUS_OBJECT_PATH_NOT_FOUND },
	{ N_("The object path component was not a directory object."), NT_STATUS_OBJECT_PATH_SYNTAX_BAD },
	{ N_("{Data Overrun} A data overrun error occurred."), NT_STATUS_DATA_OVERRUN },
	{ N_("{Data Late} A data late error occurred."), NT_STATUS_DATA_LATE_ERROR },
	{ N_("{Data Error} An error occurred in reading or writing data."), NT_STATUS_DATA_ERROR },
	{ N_("{Bad CRC} A cyclic redundancy check (CRC) checksum error occurred."), NT_STATUS_CRC_ERROR },
	{ N_("{Section Too Large} The specified section is too big to map the file."), NT_STATUS_SECTION_TOO_BIG },
	{ N_("The NtConnectPort request is refused."), NT_STATUS_PORT_CONNECTION_REFUSED },
	{ N_("The type of port handle is invalid for the operation that is requested."), NT_STATUS_INVALID_PORT_HANDLE },
	{ N_("A file cannot be opened because the share access flags are incompatible."), NT_STATUS_SHARING_VIOLATION },
	{ N_("Insufficient quota exists to complete the operation."), NT_STATUS_QUOTA_EXCEEDED },
	{ N_("The specified page protection was not valid."), NT_STATUS_INVALID_PAGE_PROTECTION },
	{ N_("An attempt to release a mutant object was made by a thread that was not the owner of the mutant object."), NT_STATUS_MUTANT_NOT_OWNED },
	{ N_("An attempt was made to release a semaphore such that its maximum count would have been exceeded."), NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED },
	{ N_("An attempt was made to set the DebugPort or ExceptionPort of a process, but a port already exists in the process, or an attempt was made to set the CompletionPort of a file but a port was already set in the file, or an attempt was made to set the associated completion port of an ALPC port but it is already set."), NT_STATUS_PORT_ALREADY_SET },
	{ N_("An attempt was made to query image information on a section that does not map an image."), NT_STATUS_SECTION_NOT_IMAGE },
	{ N_("An attempt was made to suspend a thread whose suspend count was at its maximum."), NT_STATUS_SUSPEND_COUNT_EXCEEDED },
	{ N_("An attempt was made to suspend a thread that has begun termination."), NT_STATUS_THREAD_IS_TERMINATING },
	{ N_("An attempt was made to set the working set limit to an invalid value (for example, the minimum greater than maximum)."), NT_STATUS_BAD_WORKING_SET_LIMIT },
	{ N_("A section was created to map a file that is not compatible with an already existing section that maps the same file."), NT_STATUS_INCOMPATIBLE_FILE_MAP },
	{ N_("A view to a section specifies a protection that is incompatible with the protection of the initial view."), NT_STATUS_SECTION_PROTECTION },
	{ N_("An operation involving EAs failed because the file system does not support EAs."), NT_STATUS_EAS_NOT_SUPPORTED },
	{ N_("An EA operation failed because the EA set is too large."), NT_STATUS_EA_TOO_LARGE },
	{ N_("An EA operation failed because the name or EA index is invalid."), NT_STATUS_NONEXISTENT_EA_ENTRY },
	{ N_("The file for which EAs were requested has no EAs."), NT_STATUS_NO_EAS_ON_FILE },
	{ N_("The EA is corrupt and cannot be read."), NT_STATUS_EA_CORRUPT_ERROR },
	{ N_("A requested read/write cannot be granted due to a conflicting file lock."), NT_STATUS_FILE_LOCK_CONFLICT },
	{ N_("A requested file lock cannot be granted due to other existing locks."), NT_STATUS_LOCK_NOT_GRANTED },
	{ N_("A non-close operation has been requested of a file object that has a delete pending."), NT_STATUS_DELETE_PENDING },
	{ N_("An attempt was made to set the control attribute on a file. This attribute is not supported in the destination file system."), NT_STATUS_CTL_FILE_NOT_SUPPORTED },
	{ N_("Indicates a revision number that was encountered or specified is not one that is known by the service. It may be a more recent revision than the service is aware of."), NT_STATUS_UNKNOWN_REVISION },
	{ N_("Indicates a particular security ID may not be assigned as the owner of an object."), NT_STATUS_INVALID_OWNER },
	{ N_("Indicates a particular security ID may not be assigned as the primary group of an object."), NT_STATUS_INVALID_PRIMARY_GROUP },
	{ N_("An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client."), NT_STATUS_NO_IMPERSONATION_TOKEN },
	{ N_("A mandatory group may not be disabled."), NT_STATUS_CANT_DISABLE_MANDATORY },
	{ N_("A required privilege is not held by the client."), NT_STATUS_PRIVILEGE_NOT_HELD },
	{ N_("The specified user account is already in the specified group account. Also used to indicate a group cannot be deleted because it contains a member."), NT_STATUS_MEMBER_IN_GROUP },
	{ N_("Indicates the requested operation would disable or delete the last remaining administration account. This is not allowed to prevent creating a situation in which the system cannot be administrated."), NT_STATUS_LAST_ADMIN },
	{ N_("None of the information to be translated has been translated."), NT_STATUS_NONE_MAPPED },
	{ N_("The number of LUIDs requested may not be allocated with a single allocation."), NT_STATUS_TOO_MANY_LUIDS_REQUESTED },
	{ N_("Indicates there are no more LUIDs to allocate."), NT_STATUS_LUIDS_EXHAUSTED },
	{ N_("Indicates the sub-authority value is invalid for the particular use."), NT_STATUS_INVALID_SUB_AUTHORITY },
	{ N_("Indicates the ACL structure is not valid."), NT_STATUS_INVALID_ACL },
	{ N_("Indicates the SID structure is not valid."), NT_STATUS_INVALID_SID },
	{ N_("Indicates the SECURITY_DESCRIPTOR structure is not valid."), NT_STATUS_INVALID_SECURITY_DESCR },
	{ N_("{Bad Image} %hs is either not designed to run on Windows or it contains an error. Try installing the program again using the original installation media or contact your system administrator or the software vendor for support."), NT_STATUS_INVALID_IMAGE_FORMAT },
	{ N_("An attempt was made to reference a token that does not exist. This is typically done by referencing the token that is associated with a thread when the thread is not impersonating a client."), NT_STATUS_NO_TOKEN },
	{ N_("Indicates that an attempt to build either an inherited ACL or ACE was not successful. This can be caused by a number of things. One of the more probable causes is the replacement of a CreatorId with a SID that did not fit into the ACE or ACL."), NT_STATUS_BAD_INHERITANCE_ACL },
	{ N_("The range specified in NtUnlockFile was not locked."), NT_STATUS_RANGE_NOT_LOCKED },
	{ N_("An operation failed because the disk was full."), NT_STATUS_DISK_FULL },
	{ N_("The GUID allocation server is enabled at the moment."), NT_STATUS_SERVER_NOT_DISABLED },
	{ N_("Too many GUIDs were requested from the allocation server at once."), NT_STATUS_TOO_MANY_GUIDS_REQUESTED },
	{ N_("The GUIDs could not be allocated because the Authority Agent was exhausted."), NT_STATUS_GUIDS_EXHAUSTED },
	{ N_("The value provided was an invalid value for an identifier authority."), NT_STATUS_INVALID_ID_AUTHORITY },
	{ N_("No more authority agent values are available for the particular identifier authority value."), NT_STATUS_AGENTS_EXHAUSTED },
	{ N_("An invalid volume label has been specified."), NT_STATUS_INVALID_VOLUME_LABEL },
	{ N_("A mapped section could not be extended."), NT_STATUS_SECTION_NOT_EXTENDED },
	{ N_("Specified section to flush does not map a data file."), NT_STATUS_NOT_MAPPED_DATA },
	{ N_("Indicates the specified image file did not contain a resource section."), NT_STATUS_RESOURCE_DATA_NOT_FOUND },
	{ N_("Indicates the specified resource type cannot be found in the image file."), NT_STATUS_RESOURCE_TYPE_NOT_FOUND },
	{ N_("Indicates the specified resource name cannot be found in the image file."), NT_STATUS_RESOURCE_NAME_NOT_FOUND },
	{ N_("{EXCEPTION} Array bounds exceeded."), NT_STATUS_ARRAY_BOUNDS_EXCEEDED },
	{ N_("{EXCEPTION} Floating-point denormal operand."), NT_STATUS_FLOAT_DENORMAL_OPERAND },
	{ N_("{EXCEPTION} Floating-point division by zero."), NT_STATUS_FLOAT_DIVIDE_BY_ZERO },
	{ N_("{EXCEPTION} Floating-point inexact result."), NT_STATUS_FLOAT_INEXACT_RESULT },
	{ N_("{EXCEPTION} Floating-point invalid operation."), NT_STATUS_FLOAT_INVALID_OPERATION },
	{ N_("{EXCEPTION} Floating-point overflow."), NT_STATUS_FLOAT_OVERFLOW },
	{ N_("{EXCEPTION} Floating-point stack check."), NT_STATUS_FLOAT_STACK_CHECK },
	{ N_("{EXCEPTION} Floating-point underflow."), NT_STATUS_FLOAT_UNDERFLOW },
	{ N_("{EXCEPTION} Integer division by zero."), NT_STATUS_INTEGER_DIVIDE_BY_ZERO },
	{ N_("{EXCEPTION} Integer overflow."), NT_STATUS_INTEGER_OVERFLOW },
	{ N_("{EXCEPTION} Privileged instruction."), NT_STATUS_PRIVILEGED_INSTRUCTION },
	{ N_("An attempt was made to install more paging files than the system supports."), NT_STATUS_TOO_MANY_PAGING_FILES },
	{ N_("The volume for a file has been externally altered such that the opened file is no longer valid."), NT_STATUS_FILE_INVALID },
	{ N_("When a block of memory is allotted for future updates, such as the memory allocated to hold discretionary access control and primary group information, successive updates may exceed the amount of memory originally allotted. Because a quota may already have been charged to several processes that have handles to the object, it is not reasonable to alter the size of the allocated memory. Instead, a request that requires more memory than has been allotted must fail and the STATUS_ALLOTTED_SPACE_EXCEEDED error returned."), NT_STATUS_ALLOTTED_SPACE_EXCEEDED },
	{ N_("Insufficient system resources exist to complete the API."), NT_STATUS_INSUFFICIENT_RESOURCES },
	{ N_("An attempt has been made to open a DFS exit path control file."), NT_STATUS_DFS_EXIT_PATH_FOUND },
	{ N_("There are bad blocks (sectors) on the hard disk."), NT_STATUS_DEVICE_DATA_ERROR },
	{ N_("There is bad cabling, non-termination, or the controller is not able to obtain access to the hard disk."), NT_STATUS_DEVICE_NOT_CONNECTED },
	{ N_("Virtual memory cannot be freed because the base address is not the base of the region and a region size of zero was specified."), NT_STATUS_FREE_VM_NOT_AT_BASE },
	{ N_("An attempt was made to free virtual memory that is not allocated."), NT_STATUS_MEMORY_NOT_ALLOCATED },
	{ N_("The working set is not big enough to allow the requested pages to be locked."), NT_STATUS_WORKING_SET_QUOTA },
	{ N_("{Write Protect Error} The disk cannot be written to because it is write-protected. Remove the write protection from the volume %hs in drive %hs."), NT_STATUS_MEDIA_WRITE_PROTECTED },
	{ N_("{Drive Not Ready} The drive is not ready for use; its door may be open. Check drive %hs and make sure that a disk is inserted and that the drive door is closed."), NT_STATUS_DEVICE_NOT_READY },
	{ N_("The specified attributes are invalid or are incompatible with the attributes for the group as a whole."), NT_STATUS_INVALID_GROUP_ATTRIBUTES },
	{ N_("A specified impersonation level is invalid. Also used to indicate that a required impersonation level was not provided."), NT_STATUS_BAD_IMPERSONATION_LEVEL },
	{ N_("An attempt was made to open an anonymous-level token. Anonymous tokens may not be opened."), NT_STATUS_CANT_OPEN_ANONYMOUS },
	{ N_("The validation information class requested was invalid."), NT_STATUS_BAD_VALIDATION_CLASS },
	{ N_("The type of a token object is inappropriate for its attempted use."), NT_STATUS_BAD_TOKEN_TYPE },
	{ N_("The type of a token object is inappropriate for its attempted use."), NT_STATUS_BAD_MASTER_BOOT_RECORD },
	{ N_("An attempt was made to execute an instruction at an unaligned address and the host system does not support unaligned instruction references."), NT_STATUS_INSTRUCTION_MISALIGNMENT },
	{ N_("The maximum named pipe instance count has been reached."), NT_STATUS_INSTANCE_NOT_AVAILABLE },
	{ N_("The specified named pipe is in the connected state."), NT_STATUS_PIPE_CONNECTED },
	{ N_("The specified named pipe is in the listening state."), NT_STATUS_PIPE_LISTENING },
	{ N_("The specified named pipe is not in message mode."), NT_STATUS_INVALID_READ_MODE },
	{ N_("{Device Timeout} The specified I/O operation on %hs was not completed before the time-out period expired."), NT_STATUS_IO_TIMEOUT },
	{ N_("The specified file has been closed by another process."), NT_STATUS_FILE_FORCED_CLOSED },
	{ N_("Profiling is not started."), NT_STATUS_PROFILING_NOT_STARTED },
	{ N_("Profiling is not stopped."), NT_STATUS_PROFILING_NOT_STOPPED },
	{ N_("The passed ACL did not contain the minimum required information."), NT_STATUS_COULD_NOT_INTERPRET },
	{ N_("The file that was specified as a target is a directory, and the caller specified that it could be anything but a directory."), NT_STATUS_FILE_IS_A_DIRECTORY },
	{ N_("The request is not supported."), NT_STATUS_NOT_SUPPORTED },
	{ N_("The network path cannot be located."), NT_STATUS_BAD_NETWORK_PATH },
	{ N_("The network is busy."), NT_STATUS_NETWORK_BUSY },
	{ N_("This device does not exist."), NT_STATUS_DEVICE_DOES_NOT_EXIST },
	{ N_("The network BIOS command limit has been reached."), NT_STATUS_TOO_MANY_COMMANDS },
	{ N_("An I/O adapter hardware error has occurred."), NT_STATUS_ADAPTER_HARDWARE_ERROR },
	{ N_("The network responded incorrectly."), NT_STATUS_INVALID_NETWORK_RESPONSE },
	{ N_("An unexpected network error occurred."), NT_STATUS_UNEXPECTED_NETWORK_ERROR },
	{ N_("The remote adapter is not compatible."), NT_STATUS_BAD_REMOTE_ADAPTER },
	{ N_("The requested print file has been canceled."), NT_STATUS_PRINT_CANCELLED },
	{ N_("The network name was deleted."), NT_STATUS_NETWORK_NAME_DELETED },
	{ N_("Network access is denied."), NT_STATUS_NETWORK_ACCESS_DENIED },
	{ N_("{Incorrect Network Resource Type} The specified device type (LPT, for example) conflicts with the actual device type on the remote resource."), NT_STATUS_BAD_DEVICE_TYPE },
	{ N_("File sharing has been temporarily paused."), NT_STATUS_SHARING_PAUSED },
	{ N_("No more connections can be made to this remote computer at this time because the computer has already accepted the maximum number of connections."), NT_STATUS_REQUEST_NOT_ACCEPTED },
	{ N_("Print or disk redirection is temporarily paused."), NT_STATUS_REDIRECTOR_PAUSED },
	{ N_("A network data fault occurred."), NT_STATUS_NET_WRITE_FAULT },
	{ N_("The number of active profiling objects is at the maximum and no more may be started."), NT_STATUS_PROFILING_AT_LIMIT },
	{ N_("{Incorrect Volume} The destination file of a rename request is located on a different device than the source of the rename request."), NT_STATUS_NOT_SAME_DEVICE },
	{ N_("The specified file has been renamed and thus cannot be modified."), NT_STATUS_FILE_RENAMED },
	{ N_("{Network Request Timeout} The session with a remote server has been disconnected because the time-out interval for a request has expired."), NT_STATUS_VIRTUAL_CIRCUIT_CLOSED },
	{ N_("Indicates an attempt was made to operate on the security of an object that does not have security associated with it."), NT_STATUS_NO_SECURITY_ON_OBJECT },
	{ N_("Used to indicate that an operation cannot continue without blocking for I/O."), NT_STATUS_CANT_WAIT },
	{ N_("Used to indicate that a read operation was done on an empty pipe."), NT_STATUS_PIPE_EMPTY },
	{ N_("Configuration information could not be read from the domain controller, either because the machine is unavailable or access has been denied."), NT_STATUS_CANT_ACCESS_DOMAIN_INFO },
	{ N_("Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process."), NT_STATUS_CANT_TERMINATE_SELF },
	{ N_("An error status returned when the opportunistic lock (oplock) request is denied."), NT_STATUS_OPLOCK_NOT_GRANTED },
	{ N_("An error status returned when an invalid opportunistic lock (oplock) acknowledgment is received by a file system."), NT_STATUS_INVALID_OPLOCK_PROTOCOL },
	{ N_("This error indicates that the requested operation cannot be completed due to a catastrophic media failure or an on-disk data structure corruption."), NT_STATUS_INTERNAL_DB_CORRUPTION },
	{ N_("An internal error occurred."), NT_STATUS_INTERNAL_ERROR },
	{ N_("Indicates generic access types were contained in an access mask which should already be mapped to non-generic access types."), NT_STATUS_GENERIC_NOT_MAPPED },
	{ N_("Indicates a security descriptor is not in the necessary format (absolute or self-relative)."), NT_STATUS_BAD_DESCRIPTOR_FORMAT },
	{ N_("An access to a user buffer failed at an expected point in time. This code is defined because the caller does not want to accept STATUS_ACCESS_VIOLATION in its filter."), NT_STATUS_INVALID_USER_BUFFER },
	{ N_("If an I/O error that is not defined in the standard FsRtl filter is returned, it is converted to the following error, which is guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."), NT_STATUS_UNEXPECTED_IO_ERROR },
	{ N_("If an MM error that is not defined in the standard FsRtl filter is returned, it is converted to one of the following errors, which are guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."), NT_STATUS_UNEXPECTED_MM_CREATE_ERR },
	{ N_("If an MM error that is not defined in the standard FsRtl filter is returned, it is converted to one of the following errors, which are guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."), NT_STATUS_UNEXPECTED_MM_MAP_ERROR },
	{ N_("If an MM error that is not defined in the standard FsRtl filter is returned, it is converted to one of the following errors, which are guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."), NT_STATUS_UNEXPECTED_MM_EXTEND_ERR },
	{ N_("The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process."), NT_STATUS_NOT_LOGON_PROCESS },
	{ N_("An attempt has been made to start a new session manager or LSA logon session by using an ID that is already in use."), NT_STATUS_LOGON_SESSION_EXISTS },
	{ N_("An invalid parameter was passed to a service or function as the first argument."), NT_STATUS_INVALID_PARAMETER_1 },
	{ N_("An invalid parameter was passed to a service or function as the second argument."), NT_STATUS_INVALID_PARAMETER_2 },
	{ N_("An invalid parameter was passed to a service or function as the third argument."), NT_STATUS_INVALID_PARAMETER_3 },
	{ N_("An invalid parameter was passed to a service or function as the fourth argument."), NT_STATUS_INVALID_PARAMETER_4 },
	{ N_("An invalid parameter was passed to a service or function as the fifth argument."), NT_STATUS_INVALID_PARAMETER_5 },
	{ N_("An invalid parameter was passed to a service or function as the sixth argument."), NT_STATUS_INVALID_PARAMETER_6 },
	{ N_("An invalid parameter was passed to a service or function as the seventh argument."), NT_STATUS_INVALID_PARAMETER_7 },
	{ N_("An invalid parameter was passed to a service or function as the eighth argument."), NT_STATUS_INVALID_PARAMETER_8 },
	{ N_("An invalid parameter was passed to a service or function as the ninth argument."), NT_STATUS_INVALID_PARAMETER_9 },
	{ N_("An invalid parameter was passed to a service or function as the tenth argument."), NT_STATUS_INVALID_PARAMETER_10 },
	{ N_("An invalid parameter was passed to a service or function as the eleventh argument."), NT_STATUS_INVALID_PARAMETER_11 },
	{ N_("An invalid parameter was passed to a service or function as the twelfth argument."), NT_STATUS_INVALID_PARAMETER_12 },
	{ N_("An attempt was made to access a network file, but the network software was not yet started."), NT_STATUS_REDIRECTOR_NOT_STARTED },
	{ N_("An attempt was made to start the redirector, but the redirector has already been started."), NT_STATUS_REDIRECTOR_STARTED },
	{ N_("A new guard page for the stack cannot be created."), NT_STATUS_STACK_OVERFLOW },
	{ N_("A specified authentication package is unknown."), NT_STATUS_NO_SUCH_PACKAGE },
	{ N_("A malformed function table was encountered during an unwind operation."), NT_STATUS_BAD_FUNCTION_TABLE },
	{ N_("Indicates that the directory trying to be deleted is not empty."), NT_STATUS_DIRECTORY_NOT_EMPTY },
	{ N_("{Corrupt File} The file or directory %hs is corrupt and unreadable. Run the Chkdsk utility."), NT_STATUS_FILE_CORRUPT_ERROR },
	{ N_("A requested opened file is not a directory."), NT_STATUS_NOT_A_DIRECTORY },
	{ N_("A specified name string is too long for its intended use."), NT_STATUS_NAME_TOO_LONG },
	{ N_("The user attempted to force close the files on a redirected drive, but there were opened files on the drive, and the user did not specify a sufficient level of force."), NT_STATUS_FILES_OPEN },
	{ N_("The user attempted to force close the files on a redirected drive, but there were opened directories on the drive, and the user did not specify a sufficient level of force."), NT_STATUS_CONNECTION_IN_USE },
	{ N_("RtlFindMessage could not locate the requested message ID in the message table resource."), NT_STATUS_MESSAGE_NOT_FOUND },
	{ N_("An attempt was made to duplicate an object handle into or out of an exiting process."), NT_STATUS_PROCESS_IS_TERMINATING },
	{ N_("Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail."), NT_STATUS_NO_GUID_TRANSLATION },
	{ N_("Indicates that an attempt has been made to impersonate via a named pipe that has not yet been read from."), NT_STATUS_CANNOT_IMPERSONATE },
	{ N_("Indicates that the specified image is already loaded."), NT_STATUS_IMAGE_ALREADY_LOADED },
	{ N_("Indicates that an attempt was made to change the size of the LDT for a process that has no LDT."), NT_STATUS_NO_LDT },
	{ N_("Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors."), NT_STATUS_INVALID_LDT_SIZE },
	{ N_("Indicates that the starting value for the LDT information was not an integral multiple of the selector size."), NT_STATUS_INVALID_LDT_OFFSET },
	{ N_("Indicates that the user supplied an invalid descriptor when trying to set up LDT descriptors."), NT_STATUS_INVALID_LDT_DESCRIPTOR },
	{ N_("The specified image file did not have the correct format. It appears to be NE format."), NT_STATUS_INVALID_IMAGE_NE_FORMAT },
	{ N_("Indicates that the transaction state of a registry subtree is incompatible with the requested operation. For example, a request has been made to start a new transaction with one already in progress, or a request has been made to apply a transaction when one is not currently in progress."), NT_STATUS_RXACT_INVALID_STATE },
	{ N_("Indicates an error has occurred during a registry transaction commit. The database has been left in an unknown, but probably inconsistent, state. The state of the registry transaction is left as COMMITTING."), NT_STATUS_RXACT_COMMIT_FAILURE },
	{ N_("An attempt was made to map a file of size zero with the maximum size specified as zero."), NT_STATUS_MAPPED_FILE_SIZE_ZERO },
	{ N_("Too many files are opened on a remote server. This error should only be returned by the Windows redirector on a remote drive."), NT_STATUS_TOO_MANY_OPENED_FILES },
	{ N_("An attempt has been made to remove a file or directory that cannot be deleted."), NT_STATUS_CANNOT_DELETE },
	{ N_("An I/O request other than close was performed on a file after it was deleted, which can only happen to a request that did not complete before the last handle was closed via NtClose."), NT_STATUS_FILE_DELETED },
	{ N_("Indicates an operation that is incompatible with built-in accounts has been attempted on a built-in (special) SAM account. For example, built-in accounts cannot be deleted."), NT_STATUS_SPECIAL_ACCOUNT },
	{ N_("The operation requested may not be performed on the specified group because it is a built-in special group."), NT_STATUS_SPECIAL_GROUP },
	{ N_("The operation requested may not be performed on the specified user because it is a built-in special user."), NT_STATUS_SPECIAL_USER },
	{ N_("Indicates a member cannot be removed from a group because the group is currently the member's primary group."), NT_STATUS_MEMBERS_PRIMARY_GROUP },
	{ N_("An I/O request other than close and several other special case operations was attempted using a file object that had already been closed."), NT_STATUS_FILE_CLOSED },
	{ N_("Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads."), NT_STATUS_TOO_MANY_THREADS },
	{ N_("An attempt was made to operate on a thread within a specific process, but the specified thread is not in the specified process."), NT_STATUS_THREAD_NOT_IN_PROCESS },
	{ N_("An attempt was made to establish a token for use as a primary token but the token is already in use. A token can only be the primary token of one process at a time."), NT_STATUS_TOKEN_ALREADY_IN_USE },
	{ N_("The page file quota was exceeded."), NT_STATUS_PAGEFILE_QUOTA_EXCEEDED },
	{ N_("{Out of Virtual Memory} Your system is low on virtual memory. To ensure that Windows runs correctly, increase the size of your virtual memory paging file. For more information, see Help."), NT_STATUS_COMMITMENT_LIMIT },
	{ N_("The specified image file did not have the correct format: it appears to be LE format."), NT_STATUS_INVALID_IMAGE_LE_FORMAT },
	{ N_("The specified image file did not have the correct format: it did not have an initial MZ."), NT_STATUS_INVALID_IMAGE_NOT_MZ },
	{ N_("The specified image file did not have the correct format: it did not have a proper e_lfarlc in the MZ header."), NT_STATUS_INVALID_IMAGE_PROTECT },
	{ N_("The specified image file did not have the correct format: it appears to be a 16-bit Windows image."), NT_STATUS_INVALID_IMAGE_WIN_16 },
	{ N_("The SAM database on a Windows Server is significantly out of synchronization with the copy on the domain controller. A complete synchronization is required."), NT_STATUS_SYNCHRONIZATION_REQUIRED },
	{ N_("{Unable To Locate Component} This application has failed to start because %hs was not found. Reinstalling the application may fix this problem."), NT_STATUS_DLL_NOT_FOUND },
	{ N_("The NtCreateFile API failed. This error should never be returned to an application; it is a place holder for the Windows LAN Manager Redirector to use in its internal error-mapping routines."), NT_STATUS_OPEN_FAILED },
	{ N_("{Privilege Failed} The I/O permissions for the process could not be changed."), NT_STATUS_IO_PRIVILEGE_FAILED },
	{ N_("{Ordinal Not Found} The ordinal %ld could not be located in the dynamic link library %hs."), NT_STATUS_ORDINAL_NOT_FOUND },
	{ N_("{Entry Point Not Found} The procedure entry point %hs could not be located in the dynamic link library %hs."), NT_STATUS_ENTRYPOINT_NOT_FOUND },
	{ N_("{Application Exit by CTRL+C} The application terminated as a result of a CTRL+C."), NT_STATUS_CONTROL_C_EXIT },
	{ N_("{Virtual Circuit Closed} The network transport on your computer has closed a network connection. There may or may not be I/O requests outstanding."), NT_STATUS_LOCAL_DISCONNECT },
	{ N_("{Virtual Circuit Closed} The network transport on a remote computer has closed a network connection. There may or may not be I/O requests outstanding."), NT_STATUS_REMOTE_DISCONNECT },
	{ N_("{Insufficient Resources on Remote Computer} The remote computer has insufficient resources to complete the network request. For example, the remote computer may not have enough available memory to carry out the request at this time."), NT_STATUS_REMOTE_RESOURCES },
	{ N_("{Virtual Circuit Closed} An existing connection (virtual circuit) has been broken at the remote computer. There is probably something wrong with the network software protocol or the network hardware on the remote computer."), NT_STATUS_LINK_FAILED },
	{ N_("{Virtual Circuit Closed} The network transport on your computer has closed a network connection because it had to wait too long for a response from the remote computer."), NT_STATUS_LINK_TIMEOUT },
	{ N_("The connection handle that was given to the transport was invalid."), NT_STATUS_INVALID_CONNECTION },
	{ N_("The address handle that was given to the transport was invalid."), NT_STATUS_INVALID_ADDRESS },
	{ N_("{DLL Initialization Failed} Initialization of the dynamic link library %hs failed. The process is terminating abnormally."), NT_STATUS_DLL_INIT_FAILED },
	{ N_("{Missing System File} The required system file %hs is bad or missing."), NT_STATUS_MISSING_SYSTEMFILE },
	{ N_("{Application Error} The exception %s (0x%08lx) occurred in the application at location 0x%08lx."), NT_STATUS_UNHANDLED_EXCEPTION },
	{ N_("{Application Error} The application failed to initialize properly (0x%lx). Click OK to terminate the application."), NT_STATUS_APP_INIT_FAILURE },
	{ N_("{Unable to Create Paging File} The creation of the paging file %hs failed (%lx). The requested size was %ld."), NT_STATUS_PAGEFILE_CREATE_FAILED },
	{ N_("{No Paging File Specified} No paging file was specified in the system configuration."), NT_STATUS_NO_PAGEFILE },
	{ N_("{Incorrect System Call Level} An invalid level was passed into the specified system call."), NT_STATUS_INVALID_LEVEL },
	{ N_("{Incorrect Password to LAN Manager Server} You specified an incorrect password to a LAN Manager 2.x or MS-NET server."), NT_STATUS_WRONG_PASSWORD_CORE },
	{ N_("{EXCEPTION} A real-mode application issued a floating-point instruction and floating-point hardware is not present."), NT_STATUS_ILLEGAL_FLOAT_CONTEXT },
	{ N_("An I/O operation initiated by the Registry failed and cannot be recovered. The registry could not read in, write out, or flush one of the files that contain the system's image of the registry."), NT_STATUS_REGISTRY_IO_FAILED },
	{ N_("An event pair synchronization operation was performed using the thread-specific client/server event pair object, but no event pair object was associated with the thread."), NT_STATUS_NO_EVENT_PAIR },
	{ N_("The volume does not contain a recognized file system. Be sure that all required file system drivers are loaded and that the volume is not corrupt."), NT_STATUS_UNRECOGNIZED_VOLUME },
	{ N_("No serial device was successfully initialized. The serial driver will unload."), NT_STATUS_SERIAL_NO_DEVICE_INITED },
	{ N_("The specified local group does not exist."), NT_STATUS_NO_SUCH_ALIAS },
	{ N_("The specified account name is not a member of the group."), NT_STATUS_MEMBER_NOT_IN_ALIAS },
	{ N_("The specified account name is already a member of the group."), NT_STATUS_MEMBER_IN_ALIAS },
	{ N_("The specified local group already exists."), NT_STATUS_ALIAS_EXISTS },
	{ N_("A requested type of logon (for example, interactive, network, and service) is not granted by the local security policy of the target system. Ask the system administrator to grant the necessary form of logon."), NT_STATUS_LOGON_NOT_GRANTED },
	{ N_("The length of a secret exceeds the maximum allowable length. The length and number of secrets is limited to satisfy U.S. State Department export restrictions."), NT_STATUS_SECRET_TOO_LONG },
	{ N_("The local security authority (LSA) database contains an internal inconsistency."), NT_STATUS_INTERNAL_DB_ERROR },
	{ N_("The requested operation cannot be performed in full-screen mode."), NT_STATUS_FULLSCREEN_MODE },
	{ N_("During a logon attempt, the user's security context accumulated too many security IDs. This is a very unusual situation. Remove the user from some global or local groups to reduce the number of security IDs to incorporate into the security context."), NT_STATUS_TOO_MANY_CONTEXT_IDS },
	{ N_("A user has requested a type of logon (for example, interactive or network) that has not been granted. An administrator has control over who may logon interactively and through the network."), NT_STATUS_LOGON_TYPE_NOT_GRANTED },
	{ N_("The system has attempted to load or restore a file into the registry, and the specified file is not in the format of a registry file."), NT_STATUS_NOT_REGISTRY_FILE },
	{ N_("An attempt was made to change a user password in the security account manager without providing the necessary Windows cross-encrypted password."), NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED },
	{ N_("A Windows Server has an incorrect configuration."), NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR },
	{ N_("An attempt was made to explicitly access the secondary copy of information via a device control to the fault tolerance driver and the secondary copy is not present in the system."), NT_STATUS_FT_MISSING_MEMBER },
	{ N_("A configuration registry node that represents a driver service entry was ill-formed and did not contain the required value entries."), NT_STATUS_ILL_FORMED_SERVICE_ENTRY },
	{ N_("An illegal character was encountered. For a multibyte character set, this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE."), NT_STATUS_ILLEGAL_CHARACTER },
	{ N_("No mapping for the Unicode character exists in the target multibyte code page."), NT_STATUS_UNMAPPABLE_CHARACTER },
	{ N_("The Unicode character is not defined in the Unicode character set that is installed on the system."), NT_STATUS_UNDEFINED_CHARACTER },
	{ N_("The paging file cannot be created on a floppy disk."), NT_STATUS_FLOPPY_VOLUME },
	{ N_("{Floppy Disk Error} While accessing a floppy disk, an ID address mark was not found."), NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND },
	{ N_("{Floppy Disk Error} While accessing a floppy disk, the track address from the sector ID field was found to be different from the track address that is maintained by the controller."), NT_STATUS_FLOPPY_WRONG_CYLINDER },
	{ N_("{Floppy Disk Error} The floppy disk controller reported an error that is not recognized by the floppy disk driver."), NT_STATUS_FLOPPY_UNKNOWN_ERROR },
	{ N_("{Floppy Disk Error} While accessing a floppy-disk, the controller returned inconsistent results via its registers."), NT_STATUS_FLOPPY_BAD_REGISTERS },
	{ N_("{Hard Disk Error} While accessing the hard disk, a recalibrate operation failed, even after retries."), NT_STATUS_DISK_RECALIBRATE_FAILED },
	{ N_("{Hard Disk Error} While accessing the hard disk, a disk operation failed even after retries."), NT_STATUS_DISK_OPERATION_FAILED },
	{ N_("{Hard Disk Error} While accessing the hard disk, a disk controller reset was needed, but even that failed."), NT_STATUS_DISK_RESET_FAILED },
	{ N_("An attempt was made to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened. Two concurrent opens of devices that share an IRQ and only work via interrupts is not supported for the particular bus type that the devices use."), NT_STATUS_SHARED_IRQ_BUSY },
	{ N_("{FT Orphaning} A disk that is part of a fault-tolerant volume can no longer be accessed."), NT_STATUS_FT_ORPHANING },
	{ N_("The tape could not be partitioned."), NT_STATUS_PARTITION_FAILURE },
	{ N_("When accessing a new tape of a multi-volume partition, the current blocksize is incorrect."), NT_STATUS_INVALID_BLOCK_LENGTH },
	{ N_("The tape partition information could not be found when loading a tape."), NT_STATUS_DEVICE_NOT_PARTITIONED },
	{ N_("An attempt to lock the eject media mechanism failed."), NT_STATUS_UNABLE_TO_LOCK_MEDIA },
	{ N_("An attempt to unload media failed."), NT_STATUS_UNABLE_TO_UNLOAD_MEDIA },
	{ N_("The physical end of tape was detected."), NT_STATUS_EOM_OVERFLOW },
	{ N_("{No Media} There is no media in the drive. Insert media into drive %hs."), NT_STATUS_NO_MEDIA },
	{ N_("A member could not be added to or removed from the local group because the member does not exist."), NT_STATUS_NO_SUCH_MEMBER },
	{ N_("A new member could not be added to a local group because the member has the wrong account type."), NT_STATUS_INVALID_MEMBER },
	{ N_("An illegal operation was attempted on a registry key that has been marked for deletion."), NT_STATUS_KEY_DELETED },
	{ N_("The system could not allocate the required space in a registry log."), NT_STATUS_NO_LOG_SPACE },
	{ N_("An attempt was made to create a symbolic link in a registry key that already has subkeys or values."), NT_STATUS_KEY_HAS_CHILDREN },
	{ N_("An attempt was made to create a stable subkey under a volatile parent key."), NT_STATUS_CHILD_MUST_BE_VOLATILE },
	{ N_("The I/O device is configured incorrectly or the configuration parameters to the driver are incorrect."), NT_STATUS_DEVICE_CONFIGURATION_ERROR },
	{ N_("An error was detected between two drivers or within an I/O driver."), NT_STATUS_DRIVER_INTERNAL_ERROR },
	{ N_("The device is not in a valid state to perform this request."), NT_STATUS_INVALID_DEVICE_STATE },
	{ N_("The I/O device reported an I/O error."), NT_STATUS_IO_DEVICE_ERROR },
	{ N_("A protocol error was detected between the driver and the device."), NT_STATUS_DEVICE_PROTOCOL_ERROR },
	{ N_("This operation is only allowed for the primary domain controller of the domain."), NT_STATUS_BACKUP_CONTROLLER },
	{ N_("A write operation was attempted to a volume after it was dismounted."), NT_STATUS_TOO_LATE },
	{ N_("The Eventlog log file is corrupt."), NT_STATUS_EVENTLOG_FILE_CORRUPT },
	{ N_("No Eventlog log file could be opened. The Eventlog service did not start."), NT_STATUS_EVENTLOG_CANT_START },
	{ N_("An attempt was made to acquire a mutant such that its maximum count would have been exceeded."), NT_STATUS_MUTANT_LIMIT_EXCEEDED },
	{ N_("{EXCEPTION} Possible deadlock condition."), NT_STATUS_POSSIBLE_DEADLOCK },
	{ N_("The log file has changed between reads."), NT_STATUS_EVENTLOG_FILE_CHANGED },
	{ N_("A volume has been accessed for which a file system driver is required that has not yet been loaded."), NT_STATUS_FS_DRIVER_REQUIRED },
	{ N_("A requested file lock operation cannot be processed due to an invalid byte range."), NT_STATUS_INVALID_LOCK_RANGE },
	{ N_("Indicates the specified resource language ID cannot be found in the image file."), NT_STATUS_RESOURCE_LANG_NOT_FOUND },
	{ N_("The size of the buffer is invalid for the specified operation."), NT_STATUS_INVALID_BUFFER_SIZE },
	{ N_("The transport rejected the specified network address as invalid."), NT_STATUS_INVALID_ADDRESS_COMPONENT },
	{ N_("The transport rejected the specified network address due to invalid use of a wildcard."), NT_STATUS_INVALID_ADDRESS_WILDCARD },
	{ N_("The transport address could not be opened because all the available addresses are in use."), NT_STATUS_TOO_MANY_ADDRESSES },
	{ N_("The transport address could not be opened because it already exists."), NT_STATUS_ADDRESS_ALREADY_EXISTS },
	{ N_("The transport address is now closed."), NT_STATUS_ADDRESS_CLOSED },
	{ N_("The transport connection is now disconnected."), NT_STATUS_CONNECTION_DISCONNECTED },
	{ N_("The transport connection has been reset."), NT_STATUS_CONNECTION_RESET },
	{ N_("The transport cannot dynamically acquire any more nodes."), NT_STATUS_TOO_MANY_NODES },
	{ N_("The transport aborted a pending transaction."), NT_STATUS_TRANSACTION_ABORTED },
	{ N_("The transport timed out a request that is waiting for a response."), NT_STATUS_TRANSACTION_TIMED_OUT },
	{ N_("The transport did not receive a release for a pending response."), NT_STATUS_TRANSACTION_NO_RELEASE },
	{ N_("The transport did not find a transaction that matches the specific token."), NT_STATUS_TRANSACTION_NO_MATCH },
	{ N_("The transport had previously responded to a transaction request."), NT_STATUS_TRANSACTION_RESPONDED },
	{ N_("The transport does not recognize the specified transaction request ID."), NT_STATUS_TRANSACTION_INVALID_ID },
	{ N_("The transport does not recognize the specified transaction request type."), NT_STATUS_TRANSACTION_INVALID_TYPE },
	{ N_("The transport can only process the specified request on the server side of a session."), NT_STATUS_NOT_SERVER_SESSION },
	{ N_("The transport can only process the specified request on the client side of a session."), NT_STATUS_NOT_CLIENT_SESSION },
	{ N_("{Registry File Failure} The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable."), NT_STATUS_CANNOT_LOAD_REGISTRY_FILE },
	{ N_("{Unexpected Failure in DebugActiveProcess} An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error."), NT_STATUS_DEBUG_ATTACH_FAILED },
	{ N_("{Fatal System Error} The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down."), NT_STATUS_SYSTEM_PROCESS_TERMINATED },
	{ N_("{Data Not Accepted} The TDI client could not handle the data received during an indication."), NT_STATUS_DATA_NOT_ACCEPTED },
	{ N_("{Unable to Retrieve Browser Server List} The list of servers for this workgroup is not currently available."), NT_STATUS_NO_BROWSER_SERVERS_FOUND },
	{ N_("NTVDM encountered a hard error."), NT_STATUS_VDM_HARD_ERROR },
	{ N_("{Cancel Timeout} The driver %hs failed to complete a canceled I/O request in the allotted time."), NT_STATUS_DRIVER_CANCEL_TIMEOUT },
	{ N_("{Reply Message Mismatch} An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message."), NT_STATUS_REPLY_MESSAGE_MISMATCH },
	{ N_("{Mapped View Alignment Incorrect} An attempt was made to map a view of a file, but either the specified base address or the offset into the file were not aligned on the proper allocation granularity."), NT_STATUS_MAPPED_ALIGNMENT },
	{ N_("{Bad Image Checksum} The image %hs is possibly corrupt. The header checksum does not match the computed checksum."), NT_STATUS_IMAGE_CHECKSUM_MISMATCH },
	{ N_("{Delayed Write Failed} Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Try to save this file elsewhere."), NT_STATUS_LOST_WRITEBEHIND_DATA },
	{ N_("The parameters passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window."), NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID },
	{ N_("The object was not found."), NT_STATUS_NOT_FOUND },
	{ N_("The stream is not a tiny stream."), NT_STATUS_NOT_TINY_STREAM },
	{ N_("A transaction recovery failed."), NT_STATUS_RECOVERY_FAILURE },
	{ N_("The request must be handled by the stack overflow code."), NT_STATUS_STACK_OVERFLOW_READ },
	{ N_("A consistency check failed."), NT_STATUS_FAIL_CHECK },
	{ N_("The attempt to insert the ID in the index failed because the ID is already in the index."), NT_STATUS_DUPLICATE_OBJECTID },
	{ N_("The attempt to set the object ID failed because the object already has an ID."), NT_STATUS_OBJECTID_EXISTS },
	{ N_("Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing oNode is moved or the extent stream is converted to a large stream."), NT_STATUS_CONVERT_TO_LARGE },
	{ N_("The request needs to be retried."), NT_STATUS_RETRY },
	{ N_("The attempt to find the object found an object on the volume that matches by ID; however, it is out of the scope of the handle that is used for the operation."), NT_STATUS_FOUND_OUT_OF_SCOPE },
	{ N_("The bucket array must be grown. Retry the transaction after doing so."), NT_STATUS_ALLOCATE_BUCKET },
	{ N_("The specified property set does not exist on the object."), NT_STATUS_PROPSET_NOT_FOUND },
	{ N_("The user/kernel marshaling buffer has overflowed."), NT_STATUS_MARSHALL_OVERFLOW },
	{ N_("The supplied variant structure contains invalid data."), NT_STATUS_INVALID_VARIANT },
	{ N_("NtClose was called on a handle that was protected from close via NtSetInformationObject."), NT_STATUS_HANDLE_NOT_CLOSABLE },
	{ N_("The transport connection was gracefully closed."), NT_STATUS_GRACEFUL_DISCONNECT },
	{ N_("The transport endpoint already has an address associated with it."), NT_STATUS_ADDRESS_ALREADY_ASSOCIATED },
	{ N_("An address has not yet been associated with the transport endpoint."), NT_STATUS_ADDRESS_NOT_ASSOCIATED },
	{ N_("An operation was attempted on a nonexistent transport connection."), NT_STATUS_CONNECTION_INVALID },
	{ N_("An invalid operation was attempted on an active transport connection."), NT_STATUS_CONNECTION_ACTIVE },
	{ N_("The remote network is not reachable by the transport."), NT_STATUS_NETWORK_UNREACHABLE },
	{ N_("The remote system is not reachable by the transport."), NT_STATUS_HOST_UNREACHABLE },
	{ N_("The remote system does not support the transport protocol."), NT_STATUS_PROTOCOL_UNREACHABLE },
	{ N_("No service is operating at the destination port of the transport on the remote system."), NT_STATUS_PORT_UNREACHABLE },
	{ N_("The request was aborted."), NT_STATUS_REQUEST_ABORTED },
	{ N_("The transport connection was aborted by the local system."), NT_STATUS_CONNECTION_ABORTED },
	{ N_("The specified buffer contains ill-formed data."), NT_STATUS_BAD_COMPRESSION_BUFFER },
	{ N_("The requested operation cannot be performed on a file with a user mapped section open."), NT_STATUS_USER_MAPPED_FILE },
	{ N_("{Audit Failed} An attempt to generate a security audit failed."), NT_STATUS_AUDIT_FAILED },
	{ N_("The timer resolution was not previously set by the current process."), NT_STATUS_TIMER_RESOLUTION_NOT_SET },
	{ N_("A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached."), NT_STATUS_CONNECTION_COUNT_LIMIT },
	{ N_("Attempting to log on during an unauthorized time of day for this account."), NT_STATUS_LOGIN_TIME_RESTRICTION },
	{ N_("The account is not authorized to log on from this station."), NT_STATUS_LOGIN_WKSTA_RESTRICTION },
	{ N_("{UP/MP Image Mismatch} The image %hs has been modified for use on a uniprocessor system, but you are running it on a multiprocessor machine. Reinstall the image file."), NT_STATUS_IMAGE_MP_UP_MISMATCH },
	{ N_("{Invalid DLL Entrypoint} The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entry point should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly."), NT_STATUS_BAD_DLL_ENTRYPOINT },
	{ N_("{Invalid Service Callback Entrypoint} The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entry point should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly."), NT_STATUS_BAD_SERVICE_ENTRYPOINT },
	{ N_("The server received the messages but did not send a reply."), NT_STATUS_LPC_REPLY_LOST },
	{ N_("There is an IP address conflict with another system on the network."), NT_STATUS_IP_ADDRESS_CONFLICT1 },
	{ N_("There is an IP address conflict with another system on the network."), NT_STATUS_IP_ADDRESS_CONFLICT2 },
	{ N_("{Low On Registry Space} The system has reached the maximum size that is allowed for the system part of the registry. Additional storage requests will be ignored."), NT_STATUS_REGISTRY_QUOTA_LIMIT },
	{ N_("The contacted server does not support the indicated part of the DFS namespace."), NT_STATUS_PATH_NOT_COVERED },
	{ N_("A callback return system service cannot be executed when no callback is active."), NT_STATUS_NO_CALLBACK_ACTIVE },
	{ N_("You have attempted to load a legacy device driver while its device instance had been disabled."), NT_STATUS_PLUGPLAY_NO_DEVICE },
	{ N_("The specified compression format is unsupported."), NT_STATUS_UNSUPPORTED_COMPRESSION },
	{ N_("The specified hardware profile configuration is invalid."), NT_STATUS_INVALID_HW_PROFILE },
	{ N_("The specified Plug and Play registry device path is invalid."), NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH },
	{ N_("{Driver Entry Point Not Found} The %hs device driver could not locate the ordinal %ld in driver %hs."), NT_STATUS_DRIVER_ORDINAL_NOT_FOUND },
	{ N_("{Driver Entry Point Not Found} The %hs device driver could not locate the entry point %hs in driver %hs."), NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND },
	{ N_("{Application Error} The application attempted to release a resource it did not own. Click OK to terminate the application."), NT_STATUS_RESOURCE_NOT_OWNED },
	{ N_("An attempt was made to create more links on a file than the file system supports."), NT_STATUS_TOO_MANY_LINKS },
	{ N_("The specified quota list is internally inconsistent with its descriptor."), NT_STATUS_QUOTA_LIST_INCONSISTENT },
	{ N_("The specified file has been relocated to offline storage."), NT_STATUS_FILE_IS_OFFLINE },
	{ N_("The NTFS file or directory is not a reparse point."), NT_STATUS_NOT_A_REPARSE_POINT },
	{ N_("The user data passed for the NTFS reparse point is invalid."), NT_STATUS_IO_REPARSE_DATA_INVALID },
	{ N_("The layered file system driver for this I/O tag did not handle it when needed."), NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED },
	{ N_("The directory service has exhausted the pool of relative identifiers."), NT_STATUS_DS_NO_MORE_RIDS },
	{ N_("This operation cannot be performed on the current domain."), NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED },
	{ N_("An object ID was not found in the file."), NT_STATUS_OBJECTID_NOT_FOUND },
	{ N_("The client session has expired; so the client must re-authenticate to continue accessing the remote resources."), NT_STATUS_NETWORK_SESSION_EXPIRED },
	{ N_("The SID filtering operation removed all SIDs."), NT_STATUS_ALL_SIDS_FILTERED },
	{ N_("The system detected a possible attempt to compromise security. Ensure that you can contact the server that authenticated you."), NT_STATUS_DOWNGRADE_DETECTED },
	{ N_("The Kerberos subsystem encountered an error. A service for user protocol request was made against a domain controller which does not support service for user."), NT_STATUS_NO_S4U_PROT_SUPPORT },
	{ N_("An attempt was made by this server to make a Kerberos constrained delegation request for a target that is outside the server realm. This action is not supported and the resulting error indicates a misconfiguration on the allowed-to-delegate-to list for this server. Contact your administrator."), NT_STATUS_CROSSREALM_DELEGATION_FAILURE },
	{ N_("The RPC protocol sequence is not supported."), NT_STATUS_RPC_PROTSEQ_NOT_SUPPORTED },
	{ N_("The interface is unknown."), NT_STATUS_RPC_UNKNOWN_IF },
	{ N_("The RPC failed."), NT_STATUS_RPC_CALL_FAILED },
	{ N_("An RPC protocol error occurred."), NT_STATUS_RPC_PROTOCOL_ERROR },
	{ N_("The name syntax is not supported."), NT_STATUS_RPC_UNSUPPORTED_NAME_SYNTAX },
	{ N_("The procedure number is out of range."), NT_STATUS_RPC_PROCNUM_OUT_OF_RANGE },
	{ N_("The requested operation is not supported."), NT_STATUS_RPC_CANNOT_SUPPORT },
	{ N_("A security package-specific error occurred."), NT_STATUS_RPC_SEC_PKG_ERROR },
	{ N_("The context handle does not match any known context handles."), NT_STATUS_RPC_SS_CONTEXT_MISMATCH },
	{ N_("The stub received bad data."), NT_STATUS_RPC_BAD_STUB_DATA },
	{ N_("The RPC pipe object is invalid or corrupt."), NT_STATUS_RPC_INVALID_PIPE_OBJECT },
	{ N_("An invalid operation was attempted on an RPC pipe object."), NT_STATUS_RPC_INVALID_PIPE_OPERATION },
	{ N_("Unsupported RPC pipe version."), NT_STATUS_RPC_WRONG_PIPE_VERSION },
	{ N_("The RPC pipe object has already been closed."), NT_STATUS_RPC_PIPE_CLOSED },
	{ N_("The RPC call completed before all pipes were processed."), NT_STATUS_RPC_PIPE_DISCIPLINE_ERROR },
	{ N_("No more data is available from the RPC pipe."), NT_STATUS_RPC_PIPE_EMPTY },

	/*
	 * New descriptions for new errors generated from
	 * [MS-ERREF] http://msdn.microsoft.com/en-us/library/cc704588.aspx
	 */
	{ N_("The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."), NT_STATUS_WAIT_1 },
	{ N_("The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."), NT_STATUS_WAIT_2 },
	{ N_("The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."), NT_STATUS_WAIT_3 },
	{ N_("The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."), NT_STATUS_WAIT_63 },
	{ N_("The caller attempted to wait for a mutex that has been abandoned."), NT_STATUS_ABANDONED },
	{ N_("The caller attempted to wait for a mutex that has been abandoned."), NT_STATUS_ABANDONED_WAIT_0 },
	{ N_("The caller attempted to wait for a mutex that has been abandoned."), NT_STATUS_ABANDONED_WAIT_63 },
	{ N_("A user-mode APC was delivered before the given Interval expired."), NT_STATUS_USER_APC },
	{ N_("The delay completed because the thread was alerted."), NT_STATUS_ALERTED },
	{ N_("The given Timeout interval expired."), NT_STATUS_TIMEOUT },
	{ N_("A reparse should be performed by the Object Manager because the name of the file resulted in a symbolic link."), NT_STATUS_REPARSE },
	{ N_("Indicates not all privileges or groups that are referenced are assigned to the caller. This allows, for example, all privileges to be disabled without having to know exactly which privileges are assigned."), NT_STATUS_NOT_ALL_ASSIGNED },
	{ N_("An open/create operation completed while an opportunistic lock (oplock) break is underway."), NT_STATUS_OPLOCK_BREAK_IN_PROGRESS },
	{ N_("A new volume has been mounted by a file system."), NT_STATUS_VOLUME_MOUNTED },
	{ N_("This success level status indicates that the transaction state already exists for the registry subtree but that a transaction commit was previously aborted. The commit has now been completed."), NT_STATUS_RXACT_COMMITTED },
	{ N_("{No Quotas} No system quota limits are specifically set for this account."), NT_STATUS_NO_QUOTAS_FOR_ACCOUNT },
	{ N_("{Connect Failure on Primary Transport} An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport."), NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED },
	{ N_("The page fault was a transition fault."), NT_STATUS_PAGE_FAULT_TRANSITION },
	{ N_("The page fault was a demand zero fault."), NT_STATUS_PAGE_FAULT_DEMAND_ZERO },
	{ N_("The page fault was a demand zero fault."), NT_STATUS_PAGE_FAULT_COPY_ON_WRITE },
	{ N_("The page fault was a demand zero fault."), NT_STATUS_PAGE_FAULT_GUARD_PAGE },
	{ N_("The page fault was satisfied by reading from a secondary storage device."), NT_STATUS_PAGE_FAULT_PAGING_FILE },
	{ N_("The cached page was locked during operation."), NT_STATUS_CACHE_PAGE_LOCKED },
	{ N_("The crash dump exists in a paging file."), NT_STATUS_CRASH_DUMP },
	{ N_("The specified buffer contains all zeros."), NT_STATUS_BUFFER_ALL_ZEROS },
	{ N_("A reparse should be performed by the Object Manager because the name of the file resulted in a symbolic link."), NT_STATUS_REPARSE_OBJECT },
	{ N_("The device has succeeded a query-stop and its resource requirements have changed."), NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED },
	{ N_("The translator has translated these resources into the global space and no additional translations should be performed."), NT_STATUS_TRANSLATION_COMPLETE },
	{ N_("The directory service evaluated group memberships locally, because it was unable to contact a global catalog server."), NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY },
	{ N_("A process being terminated has no threads to terminate."), NT_STATUS_NOTHING_TO_TERMINATE },
	{ N_("The specified process is not part of a job."), NT_STATUS_PROCESS_NOT_IN_JOB },
	{ N_("The specified process is part of a job."), NT_STATUS_PROCESS_IN_JOB },
	{ N_("{Volume Shadow Copy Service} The system is now ready for hibernation."), NT_STATUS_VOLSNAP_HIBERNATE_READY },
	{ N_("A file system or file system filter driver has successfully completed an FsFilter operation."), NT_STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY },
	{ N_("The specified interrupt vector was already connected."), NT_STATUS_INTERRUPT_VECTOR_ALREADY_CONNECTED },
	{ N_("The specified interrupt vector is still connected."), NT_STATUS_INTERRUPT_STILL_CONNECTED },
	{ N_("The current process is a cloned process."), NT_STATUS_PROCESS_CLONED },
	{ N_("The file was locked and all users of the file can only read."), NT_STATUS_FILE_LOCKED_WITH_ONLY_READERS },
	{ N_("The file was locked and at least one user of the file can write."), NT_STATUS_FILE_LOCKED_WITH_WRITERS },
	{ N_("The specified ResourceManager made no changes or updates to the resource under this transaction."), NT_STATUS_RESOURCEMANAGER_READ_ONLY },
	{ N_("An operation is blocked and waiting for an oplock."), NT_STATUS_WAIT_FOR_OPLOCK },
	{ N_("Debugger handled the exception."), NT_STATUS_DBG_EXCEPTION_HANDLED },
	{ N_("The debugger continued."), NT_STATUS_DBG_CONTINUE },
	{ N_("The IO was completed by a filter."), NT_STATUS_FLT_IO_COMPLETE },
	{ N_("A threadpool worker thread entered a callback at thread affinity %p and exited at affinity %p. This is unexpected, indicating that the callback missed restoring the priority."), NT_STATUS_CALLBACK_RETURNED_THREAD_AFFINITY },
	{ N_("{Object Exists} An attempt was made to create an object but the object name already exists."), NT_STATUS_OBJECT_NAME_EXISTS },
	{ N_("{Thread Suspended} A thread termination occurred while the thread was suspended. The thread resumed, and termination proceeded."), NT_STATUS_THREAD_WAS_SUSPENDED },
	{ N_("{Working Set Range Error} An attempt was made to set the working set minimum or maximum to values that are outside the allowable range."), NT_STATUS_WORKING_SET_LIMIT_RANGE },
	{ N_("{Image Relocated} An image file could not be mapped at the address that is specified in the image file. Local fixes must be performed on this image."), NT_STATUS_IMAGE_NOT_AT_BASE },
	{ N_("This informational level status indicates that a specified registry subtree transaction state did not yet exist and had to be created."), NT_STATUS_RXACT_STATE_CREATED },
	{ N_("{Segment Load} A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so that a debugger can load, unload, or track symbols and breakpoints within these 16-bit segments."), NT_STATUS_SEGMENT_NOTIFICATION },
	{ N_("{Local Session Key} A user session key was requested for a local remote procedure call (RPC) connection. The session key that is returned is a constant value and not unique to this connection."), NT_STATUS_LOCAL_USER_SESSION_KEY },
	{ N_("{Invalid Current Directory} The process cannot switch to the startup current directory %hs. Select OK to set the current directory to %hs, or select CANCEL to exit."), NT_STATUS_BAD_CURRENT_DIRECTORY },
	{ N_("{Serial IOCTL Complete} A serial I/O operation was completed by another write to a serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)"), NT_STATUS_SERIAL_MORE_WRITES },
	{ N_("{Registry Recovery} One of the files that contains the system registry data had to be recovered by using a log or alternate copy. The recovery was successful."), NT_STATUS_REGISTRY_RECOVERED },
	{ N_("{Redundant Read} To satisfy a read request, the Windows NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume but was unable to reassign the failing area of the device."), NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP },
	{ N_("{Redundant Write} To satisfy a write request, the Windows NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume but was unable to reassign the failing area of the device."), NT_STATUS_FT_WRITE_RECOVERY },
	{ N_("{Serial IOCTL Timeout} A serial I/O operation completed because the time-out period expired. (The IOCTL_SERIAL_XOFF_COUNTER had not reached zero.)"), NT_STATUS_SERIAL_COUNTER_TIMEOUT },
	{ N_("{Password Too Complex} The Windows password is too complex to be converted to a LAN Manager password. The LAN Manager password that returned is a NULL string."), NT_STATUS_NULL_LM_PASSWORD },
	{ N_("{Machine Type Mismatch} The image file %hs is valid but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load."), NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH },
	{ N_("{Partial Data Received} The network transport returned partial data to its client. The remaining data will be sent later."), NT_STATUS_RECEIVE_PARTIAL },
	{ N_("{Expedited Data Received} The network transport returned data to its client that was marked as expedited by the remote system."), NT_STATUS_RECEIVE_EXPEDITED },
	{ N_("{Partial Expedited Data Received} The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later."), NT_STATUS_RECEIVE_PARTIAL_EXPEDITED },
	{ N_("{TDI Event Done} The TDI indication has completed successfully."), NT_STATUS_EVENT_DONE },
	{ N_("{TDI Event Pending} The TDI indication has entered the pending state."), NT_STATUS_EVENT_PENDING },
	{ N_("Checking file system on %wZ."), NT_STATUS_CHECKING_FILE_SYSTEM },
	{ N_("{Fatal Application Exit} %hs"), NT_STATUS_FATAL_APP_EXIT },
	{ N_("The specified registry key is referenced by a predefined handle."), NT_STATUS_PREDEFINED_HANDLE },
	{ N_("{Page Unlocked} The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process."), NT_STATUS_WAS_UNLOCKED },
	{ N_("%hs"), NT_STATUS_SERVICE_NOTIFICATION },
	{ N_("{Page Locked} One of the pages to lock was already locked."), NT_STATUS_WAS_LOCKED },
	{ N_("Application popup: %1 : %2"), NT_STATUS_LOG_HARD_ERROR },
	{ N_("A Win32 process already exists."), NT_STATUS_ALREADY_WIN32 },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_UNSIMULATE },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_CONTINUE },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_SINGLE_STEP },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_BREAKPOINT },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_EXCEPTION_CONTINUE },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_EXCEPTION_LASTCHANCE },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_EXCEPTION_CHAIN },
	{ N_("{Machine Type Mismatch} The image file %hs is valid but is for a machine type other than the current machine."), NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE },
	{ N_("A yield execution was performed and no thread was available to run."), NT_STATUS_NO_YIELD_PERFORMED },
	{ N_("The resume flag to a timer API was ignored."), NT_STATUS_TIMER_RESUME_IGNORED },
	{ N_("The arbiter has deferred arbitration of these resources to its parent."), NT_STATUS_ARBITRATION_UNHANDLED },
	{ N_("The device has detected a CardBus card in its slot."), NT_STATUS_CARDBUS_NOT_SUPPORTED },
	{ N_("An exception status code that is used by the Win32 x86 emulation subsystem."), NT_STATUS_WX86_CREATEWX86TIB },
	{ N_("The CPUs in this multiprocessor system are not all the same revision level. To use all processors, the operating system restricts itself to the features of the least capable processor in the system. If problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported."), NT_STATUS_MP_PROCESSOR_MISMATCH },
	{ N_("The system was put into hibernation."), NT_STATUS_HIBERNATED },
	{ N_("The system was resumed from hibernation."), NT_STATUS_RESUME_HIBERNATION },
	{ N_("Windows has detected that the system firmware (BIOS) was updated [previous firmware date = %2, current firmware date %3]."), NT_STATUS_FIRMWARE_UPDATED },
	{ N_("A device driver is leaking locked I/O pages and is causing system degradation. The system has automatically enabled the tracking code to try and catch the culprit."), NT_STATUS_DRIVERS_LEAKING_LOCKED_PAGES },
	{ N_("The ALPC message being canceled has already been retrieved from the queue on the other side."), NT_STATUS_MESSAGE_RETRIEVED },
	{ N_("The system power state is transitioning from %2 to %3."), NT_STATUS_SYSTEM_POWERSTATE_TRANSITION },
	{ N_("The receive operation was successful. Check the ALPC completion list for the received message."), NT_STATUS_ALPC_CHECK_COMPLETION_LIST },
	{ N_("The system power state is transitioning from %2 to %3 but could enter %4."), NT_STATUS_SYSTEM_POWERSTATE_COMPLEX_TRANSITION },
	{ N_("Access to %1 is monitored by policy rule %2."), NT_STATUS_ACCESS_AUDIT_BY_POLICY },
	{ N_("A valid hibernation file has been invalidated and should be abandoned."), NT_STATUS_ABANDON_HIBERFILE },
	{ N_("Business rule scripts are disabled for the calling application."), NT_STATUS_BIZRULES_NOT_ENABLED },
	{ N_("The system has awoken."), NT_STATUS_WAKE_SYSTEM },
	{ N_("The directory service is shutting down."), NT_STATUS_DS_SHUTTING_DOWN },
	{ N_("Debugger will reply later."), NT_STATUS_DBG_REPLY_LATER },
	{ N_("Debugger cannot provide a handle."), NT_STATUS_DBG_UNABLE_TO_PROVIDE_HANDLE },
	{ N_("Debugger terminated the thread."), NT_STATUS_DBG_TERMINATE_THREAD },
	{ N_("Debugger terminated the process."), NT_STATUS_DBG_TERMINATE_PROCESS },
	{ N_("Debugger obtained control of C."), NT_STATUS_DBG_CONTROL_C },
	{ N_("Debugger printed an exception on control C."), NT_STATUS_DBG_PRINTEXCEPTION_C },
	{ N_("Debugger received a RIP exception."), NT_STATUS_DBG_RIPEXCEPTION },
	{ N_("Debugger received a control break."), NT_STATUS_DBG_CONTROL_BREAK },
	{ N_("Debugger command communication exception."), NT_STATUS_DBG_COMMAND_EXCEPTION },
	{ N_("A UUID that is valid only on this computer has been allocated."), NT_STATUS_RPC_UUID_LOCAL_ONLY },
	{ N_("Some data remains to be sent in the request buffer."), NT_STATUS_RPC_SEND_INCOMPLETE },
	{ N_("The Client Drive Mapping Service has connected on Terminal Connection."), NT_STATUS_CTX_CDM_CONNECT },
	{ N_("The Client Drive Mapping Service has disconnected on Terminal Connection."), NT_STATUS_CTX_CDM_DISCONNECT },
	{ N_("A kernel mode component is releasing a reference on an activation context."), NT_STATUS_SXS_RELEASE_ACTIVATION_CONTEXT },
	{ N_("The transactional resource manager is already consistent. Recovery is not needed."), NT_STATUS_RECOVERY_NOT_NEEDED },
	{ N_("The transactional resource manager has already been started."), NT_STATUS_RM_ALREADY_STARTED },
	{ N_("The log service encountered a log stream with no restart area."), NT_STATUS_LOG_NO_RESTART },
	{ N_("{Display Driver Recovered From Failure} The %hs display driver has detected a failure and recovered from it. Some graphical operations may have failed. The next time you restart the machine, a dialog box appears, giving you an opportunity to upload data about this failure to Microsoft."), NT_STATUS_VIDEO_DRIVER_DEBUG_REPORT_REQUEST },
	{ N_("The specified buffer is not big enough to contain the entire requested dataset. Partial data is populated up to the size of the buffer. The caller needs to provide a buffer of the size as specified in the partially populated buffer's content (interface specific)."), NT_STATUS_GRAPHICS_PARTIAL_DATA_POPULATED },
	{ N_("The kernel driver detected a version mismatch between it and the user mode driver."), NT_STATUS_GRAPHICS_DRIVER_MISMATCH },
	{ N_("No mode is pinned on the specified VidPN source/target."), NT_STATUS_GRAPHICS_MODE_NOT_PINNED },
	{ N_("The specified mode set does not specify a preference for one of its modes."), NT_STATUS_GRAPHICS_NO_PREFERRED_MODE },
	{ N_("The specified dataset (for example, mode set, frequency range set, descriptor set, or topology) is empty."), NT_STATUS_GRAPHICS_DATASET_IS_EMPTY },
	{ N_("The specified dataset (for example, mode set, frequency range set, descriptor set, or topology) does not contain any more elements."), NT_STATUS_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET },
	{ N_("The specified content transformation is not pinned on the specified VidPN present path."), NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED },
	{ N_("The child device presence was not reliably detected."), NT_STATUS_GRAPHICS_UNKNOWN_CHILD_STATUS },
	{ N_("Starting the lead adapter in a linked configuration has been temporarily deferred."), NT_STATUS_GRAPHICS_LEADLINK_START_DEFERRED },
	{ N_("The display adapter is being polled for children too frequently at the same polling level."), NT_STATUS_GRAPHICS_POLLING_TOO_FREQUENTLY },
	{ N_("Starting the adapter has been temporarily deferred."), NT_STATUS_GRAPHICS_START_DEFERRED },
	{ N_("The request will be completed later by an NDIS status indication."), NT_STATUS_NDIS_INDICATION_REQUIRED },
	{ N_("{EXCEPTION} Guard Page Exception A page of memory that marks the end of a data structure, such as a stack or an array, has been accessed."), NT_STATUS_GUARD_PAGE_VIOLATION },
	{ N_("{EXCEPTION} Alignment Fault A data type misalignment was detected in a load or store instruction."), NT_STATUS_DATATYPE_MISALIGNMENT },
	{ N_("{EXCEPTION} Breakpoint A breakpoint has been reached."), NT_STATUS_BREAKPOINT },
	{ N_("{EXCEPTION} Single Step A single step or trace operation has just been completed."), NT_STATUS_SINGLE_STEP },
	{ N_("{Kernel Debugger Awakened} The system debugger was awakened by an interrupt."), NT_STATUS_WAKE_SYSTEM_DEBUGGER },
	{ N_("{Handles Closed} Handles to objects have been automatically closed because of the requested operation."), NT_STATUS_HANDLES_CLOSED },
	{ N_("{Non-Inheritable ACL} An access control list (ACL) contains no components that can be inherited."), NT_STATUS_NO_INHERITANCE },
	{ N_("{GUID Substitution} During the translation of a globally unique identifier (GUID) to a Windows security ID (SID), no administratively defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended."), NT_STATUS_GUID_SUBSTITUTION_MADE },
	{ N_("Because of protection conflicts, not all the requested bytes could be copied."), NT_STATUS_PARTIAL_COPY },
	{ N_("{Out of Paper} The printer is out of paper."), NT_STATUS_DEVICE_PAPER_EMPTY },
	{ N_("{Device Power Is Off} The printer power has been turned off."), NT_STATUS_DEVICE_POWERED_OFF },
	{ N_("{Device Offline} The printer has been taken offline."), NT_STATUS_DEVICE_OFF_LINE },
	{ N_("{Device Busy} The device is currently busy."), NT_STATUS_DEVICE_BUSY },
	{ N_("{Verifying Disk} The media has changed and a verify operation is in progress; therefore, no reads or writes may be performed to the device, except those that are used in the verify operation."), NT_STATUS_VERIFY_REQUIRED },
	{ N_("{Too Much Information} The specified access control list (ACL) contained more information than was expected."), NT_STATUS_EXTRANEOUS_INFORMATION },
	{ N_("This warning level status indicates that the transaction state already exists for the registry subtree, but that a transaction commit was previously aborted. The commit has NOT been completed but has not been rolled back either; therefore, it may still be committed, if needed."), NT_STATUS_RXACT_COMMIT_NECESSARY },
	{ N_("{Filemark Found} A filemark was detected."), NT_STATUS_FILEMARK_DETECTED },
	{ N_("{Media Changed} The media may have changed."), NT_STATUS_MEDIA_CHANGED },
	{ N_("{I/O Bus Reset} An I/O bus reset was detected."), NT_STATUS_BUS_RESET },
	{ N_("{End of Media} The end of the media was encountered."), NT_STATUS_END_OF_MEDIA },
	{ N_("The beginning of a tape or partition has been detected."), NT_STATUS_BEGINNING_OF_MEDIA },
	{ N_("{Media Changed} The media may have changed."), NT_STATUS_MEDIA_CHECK },
	{ N_("A tape access reached a set mark."), NT_STATUS_SETMARK_DETECTED },
	{ N_("During a tape access, the end of the data written is reached."), NT_STATUS_NO_DATA_DETECTED },
	{ N_("The redirector is in use and cannot be unloaded."), NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES },
	{ N_("The server is in use and cannot be unloaded."), NT_STATUS_SERVER_HAS_OPEN_HANDLES },
	{ N_("The specified connection has already been disconnected."), NT_STATUS_ALREADY_DISCONNECTED },
	{ N_("A long jump has been executed."), NT_STATUS_LONGJUMP },
	{ N_("A cleaner cartridge is present in the tape library."), NT_STATUS_CLEANER_CARTRIDGE_INSTALLED },
	{ N_("The Plug and Play query operation was not successful."), NT_STATUS_PLUGPLAY_QUERY_VETOED },
	{ N_("A frame consolidation has been executed."), NT_STATUS_UNWIND_CONSOLIDATE },
	{ N_("{Registry Hive Recovered} The registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost."), NT_STATUS_REGISTRY_HIVE_RECOVERED },
	{ N_("The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?"), NT_STATUS_DLL_MIGHT_BE_INSECURE },
	{ N_("The application is loading executable code from the module %hs. This is secure but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?"), NT_STATUS_DLL_MIGHT_BE_INCOMPATIBLE },
	{ N_("The device has indicated that cleaning is necessary."), NT_STATUS_DEVICE_REQUIRES_CLEANING },
	{ N_("The device has indicated that its door is open. Further operations require it closed and secured."), NT_STATUS_DEVICE_DOOR_OPEN },
	{ N_("Windows discovered a corruption in the file %hs. This file has now been repaired. Check if any data in the file was lost because of the corruption."), NT_STATUS_DATA_LOST_REPAIR },
	{ N_("Debugger did not handle the exception."), NT_STATUS_DBG_EXCEPTION_NOT_HANDLED },
	{ N_("The cluster node is already up."), NT_STATUS_CLUSTER_NODE_ALREADY_UP },
	{ N_("The cluster node is already down."), NT_STATUS_CLUSTER_NODE_ALREADY_DOWN },
	{ N_("The cluster network is already online."), NT_STATUS_CLUSTER_NETWORK_ALREADY_ONLINE },
	{ N_("The cluster network is already offline."), NT_STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE },
	{ N_("The cluster node is already a member of the cluster."), NT_STATUS_CLUSTER_NODE_ALREADY_MEMBER },
	{ N_("The log could not be set to the requested size."), NT_STATUS_COULD_NOT_RESIZE_LOG },
	{ N_("There is no transaction metadata on the file."), NT_STATUS_NO_TXF_METADATA },
	{ N_("The file cannot be recovered because there is a handle still open on it."), NT_STATUS_CANT_RECOVER_WITH_HANDLE_OPEN },
	{ N_("Transaction metadata is already present on this file and cannot be superseded."), NT_STATUS_TXF_METADATA_ALREADY_PRESENT },
	{ N_("A transaction scope could not be entered because the scope handler has not been initialized."), NT_STATUS_TRANSACTION_SCOPE_CALLBACKS_NOT_SET },
	{ N_("{Display Driver Stopped Responding and recovered} The %hs display driver has stopped working normally. The recovery had been performed."), NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED },
	{ N_("{Buffer too small} The buffer is too small to contain the entry. No information has been written to the buffer."), NT_STATUS_FLT_BUFFER_TOO_SMALL },
	{ N_("Volume metadata read or write is incomplete."), NT_STATUS_FVE_PARTIAL_METADATA },
	{ N_("BitLocker encryption keys were ignored because the volume was in a transient state."), NT_STATUS_FVE_TRANSIENT_STATE },
	{ N_("Indicates the specified environment variable name was not found in the specified environment block."), NT_STATUS_VARIABLE_NOT_FOUND },
	{ N_("The basic input/output system (BIOS) failed to connect a system interrupt to the device or bus for which the device is connected."), NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT },
	{ N_("Indicates that the specified image is already loaded as a DLL."), NT_STATUS_IMAGE_ALREADY_LOADED_AS_DLL },
	{ N_("Short name settings may not be changed on this volume due to the global registry setting."), NT_STATUS_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING },
	{ N_("Short names are not enabled on this volume."), NT_STATUS_SHORT_NAMES_NOT_ENABLED_ON_VOLUME },
	{ N_("The security stream for the given volume is in an inconsistent state. Please run CHKDSK on the volume."), NT_STATUS_SECURITY_STREAM_IS_INCONSISTENT },
	{ N_("The specified access control entry (ACE) contains an invalid condition."), NT_STATUS_INVALID_ACE_CONDITION },
	{ N_("The subsystem needed to support the image type is not present."), NT_STATUS_IMAGE_SUBSYSTEM_NOT_PRESENT },
	{ N_("The specified file already has a notification GUID associated with it."), NT_STATUS_NOTIFICATION_GUID_ALREADY_DEFINED },
	{ N_("A remote open failed because the network open restrictions were not satisfied."), NT_STATUS_NETWORK_OPEN_RESTRICTION },
	{ N_("{Windows Evaluation Notification} The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, upgrade this installation by using a licensed distribution of this product."), NT_STATUS_EVALUATION_EXPIRATION },
	{ N_("{Illegal System DLL Relocation} The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range that is reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL."), NT_STATUS_ILLEGAL_DLL_RELOCATION },
	{ N_("{License Violation} The system has detected tampering with your registered product type. This is a violation of your software license. Tampering with the product type is not permitted."), NT_STATUS_LICENSE_VIOLATION },
	{ N_("{DLL Initialization Failed} The application failed to initialize because the window station is shutting down."), NT_STATUS_DLL_INIT_FAILED_LOGOFF },
	{ N_("{Unable to Load Device Driver} %hs device driver could not be loaded. Error Status was 0x%x."), NT_STATUS_DRIVER_UNABLE_TO_LOAD },
	{ N_("DFS is unavailable on the contacted server."), NT_STATUS_DFS_UNAVAILABLE },
	{ N_("An operation was attempted to a volume after it was dismounted."), NT_STATUS_VOLUME_DISMOUNTED },
	{ N_("An internal error occurred in the Win32 x86 emulation subsystem."), NT_STATUS_WX86_INTERNAL_ERROR },
	{ N_("Win32 x86 emulation subsystem floating-point stack check."), NT_STATUS_WX86_FLOAT_STACK_CHECK },
	{ N_("The validation process needs to continue on to the next step."), NT_STATUS_VALIDATE_CONTINUE },
	{ N_("There was no match for the specified key in the index."), NT_STATUS_NO_MATCH },
	{ N_("There are no more matches for the current index enumeration."), NT_STATUS_NO_MORE_MATCHES },
	{ N_("The Windows I/O reparse tag passed for the NTFS reparse point is invalid."), NT_STATUS_IO_REPARSE_TAG_INVALID },
	{ N_("The Windows I/O reparse tag does not match the one that is in the NTFS reparse point."), NT_STATUS_IO_REPARSE_TAG_MISMATCH },
	{ N_("The NTFS symbolic link could not be resolved even though the initial file name is valid."), NT_STATUS_REPARSE_POINT_NOT_RESOLVED },
	{ N_("The NTFS directory is a reparse point."), NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT },
	{ N_("The range could not be added to the range list because of a conflict."), NT_STATUS_RANGE_LIST_CONFLICT },
	{ N_("The specified medium changer source element contains no media."), NT_STATUS_SOURCE_ELEMENT_EMPTY },
	{ N_("The specified medium changer destination element already contains media."), NT_STATUS_DESTINATION_ELEMENT_FULL },
	{ N_("The specified medium changer element does not exist."), NT_STATUS_ILLEGAL_ELEMENT_ADDRESS },
	{ N_("The specified element is contained in a magazine that is no longer present."), NT_STATUS_MAGAZINE_NOT_PRESENT },
	{ N_("The device requires re-initialization due to hardware errors."), NT_STATUS_REINITIALIZATION_NEEDED },
	{ N_("The file encryption attempt failed."), NT_STATUS_ENCRYPTION_FAILED },
	{ N_("The file decryption attempt failed."), NT_STATUS_DECRYPTION_FAILED },
	{ N_("The specified range could not be found in the range list."), NT_STATUS_RANGE_NOT_FOUND },
	{ N_("There is no encryption recovery policy configured for this system."), NT_STATUS_NO_RECOVERY_POLICY },
	{ N_("The required encryption driver is not loaded for this system."), NT_STATUS_NO_EFS },
	{ N_("The file was encrypted with a different encryption driver than is currently loaded."), NT_STATUS_WRONG_EFS },
	{ N_("There are no EFS keys defined for the user."), NT_STATUS_NO_USER_KEYS },
	{ N_("The specified file is not encrypted."), NT_STATUS_FILE_NOT_ENCRYPTED },
	{ N_("The specified file is not in the defined EFS export format."), NT_STATUS_NOT_EXPORT_FORMAT },
	{ N_("The specified file is encrypted and the user does not have the ability to decrypt it."), NT_STATUS_FILE_ENCRYPTED },
	{ N_("The GUID passed was not recognized as valid by a WMI data provider."), NT_STATUS_WMI_GUID_NOT_FOUND },
	{ N_("The instance name passed was not recognized as valid by a WMI data provider."), NT_STATUS_WMI_INSTANCE_NOT_FOUND },
	{ N_("The data item ID passed was not recognized as valid by a WMI data provider."), NT_STATUS_WMI_ITEMID_NOT_FOUND },
	{ N_("The WMI request could not be completed and should be retried."), NT_STATUS_WMI_TRY_AGAIN },
	{ N_("The policy object is shared and can only be modified at the root."), NT_STATUS_SHARED_POLICY },
	{ N_("The policy object does not exist when it should."), NT_STATUS_POLICY_OBJECT_NOT_FOUND },
	{ N_("The requested policy information only lives in the Ds."), NT_STATUS_POLICY_ONLY_IN_DS },
	{ N_("The volume must be upgraded to enable this feature."), NT_STATUS_VOLUME_NOT_UPGRADED },
	{ N_("The remote storage service is not operational at this time."), NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE },
	{ N_("The remote storage service encountered a media error."), NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR },
	{ N_("The tracking (workstation) service is not running."), NT_STATUS_NO_TRACKING_SERVICE },
	{ N_("The server process is running under a SID that is different from the SID that is required by client."), NT_STATUS_SERVER_SID_MISMATCH },
	{ N_("The specified directory service attribute or value does not exist."), NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE },
	{ N_("The attribute syntax specified to the directory service is invalid."), NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX },
	{ N_("The attribute type specified to the directory service is not defined."), NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED },
	{ N_("The specified directory service attribute or value already exists."), NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS },
	{ N_("The directory service is busy."), NT_STATUS_DS_BUSY },
	{ N_("The directory service is unavailable."), NT_STATUS_DS_UNAVAILABLE },
	{ N_("The directory service was unable to allocate a relative identifier."), NT_STATUS_DS_NO_RIDS_ALLOCATED },
	{ N_("The requested operation could not be performed because the directory service is not the master for that type of operation."), NT_STATUS_DS_INCORRECT_ROLE_OWNER },
	{ N_("The directory service was unable to initialize the subsystem that allocates relative identifiers."), NT_STATUS_DS_RIDMGR_INIT_ERROR },
	{ N_("The requested operation did not satisfy one or more constraints that are associated with the class of the object."), NT_STATUS_DS_OBJ_CLASS_VIOLATION },
	{ N_("The directory service can perform the requested operation only on a leaf object."), NT_STATUS_DS_CANT_ON_NON_LEAF },
	{ N_("The directory service cannot perform the requested operation on the Relatively Defined Name (RDN) attribute of an object."), NT_STATUS_DS_CANT_ON_RDN },
	{ N_("The directory service detected an attempt to modify the object class of an object."), NT_STATUS_DS_CANT_MOD_OBJ_CLASS },
	{ N_("An error occurred while performing a cross domain move operation."), NT_STATUS_DS_CROSS_DOM_MOVE_FAILED },
	{ N_("Unable to contact the global catalog server."), NT_STATUS_DS_GC_NOT_AVAILABLE },
	{ N_("The requested operation requires a directory service, and none was available."), NT_STATUS_DIRECTORY_SERVICE_REQUIRED },
	{ N_("The reparse attribute cannot be set because it is incompatible with an existing attribute."), NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT },
	{ N_("A group marked \"use for deny only\" cannot be enabled."), NT_STATUS_CANT_ENABLE_DENY_ONLY },
	{ N_("{EXCEPTION} Multiple floating-point faults."), NT_STATUS_FLOAT_MULTIPLE_FAULTS },
	{ N_("{EXCEPTION} Multiple floating-point traps."), NT_STATUS_FLOAT_MULTIPLE_TRAPS },
	{ N_("The device has been removed."), NT_STATUS_DEVICE_REMOVED },
	{ N_("The volume change journal is being deleted."), NT_STATUS_JOURNAL_DELETE_IN_PROGRESS },
	{ N_("The volume change journal is not active."), NT_STATUS_JOURNAL_NOT_ACTIVE },
	{ N_("The requested interface is not supported."), NT_STATUS_NOINTERFACE },
	{ N_("A directory service resource limit has been exceeded."), NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED },
	{ N_("{System Standby Failed} The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode."), NT_STATUS_DRIVER_FAILED_SLEEP },
	{ N_("Mutual Authentication failed. The server password is out of date at the domain controller."), NT_STATUS_MUTUAL_AUTHENTICATION_FAILED },
	{ N_("The system file %1 has become corrupt and has been replaced."), NT_STATUS_CORRUPT_SYSTEM_FILE },
	{ N_("{EXCEPTION} Alignment Error A data type misalignment error was detected in a load or store instruction."), NT_STATUS_DATATYPE_MISALIGNMENT_ERROR },
	{ N_("The WMI data item or data block is read-only."), NT_STATUS_WMI_READ_ONLY },
	{ N_("The WMI data item or data block could not be changed."), NT_STATUS_WMI_SET_FAILURE },
	{ N_("{Virtual Memory Minimum Too Low} Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help."), NT_STATUS_COMMITMENT_MINIMUM },
	{ N_("{EXCEPTION} Register NaT consumption faults. A NaT value is consumed on a non-speculative instruction."), NT_STATUS_REG_NAT_CONSUMPTION },
	{ N_("The transport element of the medium changer contains media, which is causing the operation to fail."), NT_STATUS_TRANSPORT_FULL },
	{ N_("Security Accounts Manager initialization failed because of the following error: %hs Error Status: 0x%x. Click OK to shut down this system and restart in Directory Services Restore Mode. Check the event log for more detailed information."), NT_STATUS_DS_SAM_INIT_FAILURE },
	{ N_("This operation is supported only when you are connected to the server."), NT_STATUS_ONLY_IF_CONNECTED },
	{ N_("Only an administrator can modify the membership list of an administrative group."), NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION },
	{ N_("A device was removed so enumeration must be restarted."), NT_STATUS_PNP_RESTART_ENUMERATION },
	{ N_("The journal entry has been deleted from the journal."), NT_STATUS_JOURNAL_ENTRY_DELETED },
	{ N_("Cannot change the primary group ID of a domain controller account."), NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID },
	{ N_("{Fatal System Error} The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down."), NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE },
	{ N_("The device will not start without a reboot."), NT_STATUS_PNP_REBOOT_REQUIRED },
	{ N_("The power state of the current device cannot support this request."), NT_STATUS_POWER_STATE_INVALID },
	{ N_("The specified group type is invalid."), NT_STATUS_DS_INVALID_GROUP_TYPE },
	{ N_("In a mixed domain, no nesting of a global group if the group is security enabled."), NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN },
	{ N_("In a mixed domain, cannot nest local groups with other local groups, if the group is security enabled."), NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN },
	{ N_("A global group cannot have a local group as a member."), NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER },
	{ N_("A global group cannot have a universal group as a member."), NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER },
	{ N_("A universal group cannot have a local group as a member."), NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER },
	{ N_("A global group cannot have a cross-domain member."), NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER },
	{ N_("A local group cannot have another cross-domain local group as a member."), NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER },
	{ N_("Cannot change to a security-disabled group because primary members are in this group."), NT_STATUS_DS_HAVE_PRIMARY_MEMBERS },
	{ N_("The WMI operation is not supported by the data block or method."), NT_STATUS_WMI_NOT_SUPPORTED },
	{ N_("There is not enough power to complete the requested operation."), NT_STATUS_INSUFFICIENT_POWER },
	{ N_("The Security Accounts Manager needs to get the boot password."), NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD },
	{ N_("The Security Accounts Manager needs to get the boot key from the floppy disk."), NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY },
	{ N_("The directory service cannot start."), NT_STATUS_DS_CANT_START },
	{ N_("The directory service could not start because of the following error: %hs Error Status: 0x%x. Click OK to shut down this system and restart in Directory Services Restore Mode. Check the event log for more detailed information."), NT_STATUS_DS_INIT_FAILURE },
	{ N_("The Security Accounts Manager initialization failed because of the following error: %hs Error Status: 0x%x. Click OK to shut down this system and restart in Safe Mode. Check the event log for more detailed information."), NT_STATUS_SAM_INIT_FAILURE },
	{ N_("The requested operation can be performed only on a global catalog server."), NT_STATUS_DS_GC_REQUIRED },
	{ N_("A local group can only be a member of other local groups in the same domain."), NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY },
	{ N_("Foreign security principals cannot be members of universal groups."), NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS },
	{ N_("Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased."), NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED },
	{ N_("The directory or file cannot be created."), NT_STATUS_CANNOT_MAKE },
	{ N_("The system is in the process of shutting down."), NT_STATUS_SYSTEM_SHUTDOWN },
	{ N_("Directory Services could not start because of the following error: %hs Error Status: 0x%x. Click OK to shut down the system. You can use the recovery console to diagnose the system further."), NT_STATUS_DS_INIT_FAILURE_CONSOLE },
	{ N_("Security Accounts Manager initialization failed because of the following error: %hs Error Status: 0x%x. Click OK to shut down the system. You can use the recovery console to diagnose the system further."), NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE },
	{ N_("A security context was deleted before the context was completed. This is considered a logon failure."), NT_STATUS_UNFINISHED_CONTEXT_DELETED },
	{ N_("The client is trying to negotiate a context and the server requires user-to-user but did not send a TGT reply."), NT_STATUS_NO_TGT_REPLY },
	{ N_("Unable to accomplish the requested task because the local machine does not have any IP addresses."), NT_STATUS_NO_IP_ADDRESSES },
	{ N_("The supplied credential handle does not match the credential that is associated with the security context."), NT_STATUS_WRONG_CREDENTIAL_HANDLE },
	{ N_("The crypto system or checksum function is invalid because a required function is unavailable."), NT_STATUS_CRYPTO_SYSTEM_INVALID },
	{ N_("The number of maximum ticket referrals has been exceeded."), NT_STATUS_MAX_REFERRALS_EXCEEDED },
	{ N_("The local machine must be a Kerberos KDC (domain controller) and it is not."), NT_STATUS_MUST_BE_KDC },
	{ N_("The other end of the security negotiation requires strong crypto but it is not supported on the local machine."), NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED },
	{ N_("The KDC reply contained more than one principal name."), NT_STATUS_TOO_MANY_PRINCIPALS },
	{ N_("Expected to find PA data for a hint of what etype to use, but it was not found."), NT_STATUS_NO_PA_DATA },
	{ N_("The client certificate does not contain a valid UPN, or does not match the client name in the logon request. Contact your administrator."), NT_STATUS_PKINIT_NAME_MISMATCH },
	{ N_("Smart card logon is required and was not used."), NT_STATUS_SMARTCARD_LOGON_REQUIRED },
	{ N_("An invalid request was sent to the KDC."), NT_STATUS_KDC_INVALID_REQUEST },
	{ N_("The KDC was unable to generate a referral for the service requested."), NT_STATUS_KDC_UNABLE_TO_REFER },
	{ N_("The encryption type requested is not supported by the KDC."), NT_STATUS_KDC_UNKNOWN_ETYPE },
	{ N_("A system shutdown is in progress."), NT_STATUS_SHUTDOWN_IN_PROGRESS },
	{ N_("The server machine is shutting down."), NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS },
	{ N_("This operation is not supported on a computer running Windows Server 2003 for Small Business Server."), NT_STATUS_NOT_SUPPORTED_ON_SBS },
	{ N_("The WMI GUID is no longer available."), NT_STATUS_WMI_GUID_DISCONNECTED },
	{ N_("Collection or events for the WMI GUID is already disabled."), NT_STATUS_WMI_ALREADY_DISABLED },
	{ N_("Collection or events for the WMI GUID is already enabled."), NT_STATUS_WMI_ALREADY_ENABLED },
	{ N_("The master file table on the volume is too fragmented to complete this operation."), NT_STATUS_MFT_TOO_FRAGMENTED },
	{ N_("Copy protection failure."), NT_STATUS_COPY_PROTECTION_FAILURE },
	{ N_("Copy protection error—DVD CSS Authentication failed."), NT_STATUS_CSS_AUTHENTICATION_FAILURE },
	{ N_("Copy protection error—The specified sector does not contain a valid key."), NT_STATUS_CSS_KEY_NOT_PRESENT },
	{ N_("Copy protection error—DVD session key not established."), NT_STATUS_CSS_KEY_NOT_ESTABLISHED },
	{ N_("Copy protection error—The read failed because the sector is encrypted."), NT_STATUS_CSS_SCRAMBLED_SECTOR },
	{ N_("Copy protection error—The region of the specified DVD does not correspond to the region setting of the drive."), NT_STATUS_CSS_REGION_MISMATCH },
	{ N_("Copy protection error—The region setting of the drive may be permanent."), NT_STATUS_CSS_RESETS_EXHAUSTED },
	{ N_("The Kerberos protocol encountered an error while validating the KDC certificate during smart card logon. There is more information in the system event log."), NT_STATUS_PKINIT_FAILURE },
	{ N_("The Kerberos protocol encountered an error while attempting to use the smart card subsystem."), NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE },
	{ N_("The target server does not have acceptable Kerberos credentials."), NT_STATUS_NO_KERB_KEY },
	{ N_("The transport determined that the remote system is down."), NT_STATUS_HOST_DOWN },
	{ N_("An unsupported pre-authentication mechanism was presented to the Kerberos package."), NT_STATUS_UNSUPPORTED_PREAUTH },
	{ N_("The encryption algorithm that is used on the source file needs a bigger key buffer than the one that is used on the destination file."), NT_STATUS_EFS_ALG_BLOB_TOO_BIG },
	{ N_("An attempt to remove a processes DebugPort was made, but a port was not already associated with the process."), NT_STATUS_PORT_NOT_SET },
	{ N_("An attempt to do an operation on a debug port failed because the port is in the process of being deleted."), NT_STATUS_DEBUGGER_INACTIVE },
	{ N_("This version of Windows is not compatible with the behavior version of the directory forest, domain, or domain controller."), NT_STATUS_DS_VERSION_CHECK_FAILURE },
	{ N_("The specified event is currently not being audited."), NT_STATUS_AUDITING_DISABLED },
	{ N_("The machine account was created prior to Windows NT 4.0. The account needs to be recreated."), NT_STATUS_PRENT4_MACHINE_ACCOUNT },
	{ N_("An account group cannot have a universal group as a member."), NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER },
	{ N_("The specified image file did not have the correct format; it appears to be a 32-bit Windows image."), NT_STATUS_INVALID_IMAGE_WIN_32 },
	{ N_("The specified image file did not have the correct format; it appears to be a 64-bit Windows image."), NT_STATUS_INVALID_IMAGE_WIN_64 },
	{ N_("The client's supplied SSPI channel bindings were incorrect."), NT_STATUS_BAD_BINDINGS },
	{ N_("The AppHelp dialog box canceled; thus preventing the application from starting."), NT_STATUS_APPHELP_BLOCK },
	{ N_("The driver was not loaded because the system is starting in safe mode."), NT_STATUS_NOT_SAFE_MODE_DRIVER },
	{ N_("Access to %1 has been restricted by your Administrator by the default software restriction policy level."), NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT },
	{ N_("Access to %1 has been restricted by your Administrator by location with policy rule %2 placed on path %3."), NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH },
	{ N_("Access to %1 has been restricted by your Administrator by software publisher policy."), NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER },
	{ N_("Access to %1 has been restricted by your Administrator by policy rule %2."), NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER },
	{ N_("The driver was not loaded because it failed its initialization call."), NT_STATUS_FAILED_DRIVER_ENTRY },
	{ N_("The device encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection."), NT_STATUS_DEVICE_ENUMERATION_ERROR },
	{ N_("The create operation failed because the name contained at least one mount point that resolves to a volume to which the specified device object is not attached."), NT_STATUS_MOUNT_POINT_NOT_RESOLVED },
	{ N_("The device object parameter is either not a valid device object or is not attached to the volume that is specified by the file name."), NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER },
	{ N_("A machine check error has occurred. Check the system event log for additional information."), NT_STATUS_MCA_OCCURED },
	{ N_("Driver %2 has been blocked from loading."), NT_STATUS_DRIVER_BLOCKED_CRITICAL },
	{ N_("Driver %2 has been blocked from loading."), NT_STATUS_DRIVER_BLOCKED },
	{ N_("There was error [%2] processing the driver database."), NT_STATUS_DRIVER_DATABASE_ERROR },
	{ N_("System hive size has exceeded its limit."), NT_STATUS_SYSTEM_HIVE_TOO_LARGE },
	{ N_("A dynamic link library (DLL) referenced a module that was neither a DLL nor the process's executable image."), NT_STATUS_INVALID_IMPORT_OF_NON_DLL },
	{ N_("The local account store does not contain secret material for the specified account."), NT_STATUS_NO_SECRETS },
	{ N_("Access to %1 has been restricted by your Administrator by policy rule %2."), NT_STATUS_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY },
	{ N_("The system was not able to allocate enough memory to perform a stack switch."), NT_STATUS_FAILED_STACK_SWITCH },
	{ N_("A heap has been corrupted."), NT_STATUS_HEAP_CORRUPTION },
	{ N_("An incorrect PIN was presented to the smart card."), NT_STATUS_SMARTCARD_WRONG_PIN },
	{ N_("The smart card is blocked."), NT_STATUS_SMARTCARD_CARD_BLOCKED },
	{ N_("No PIN was presented to the smart card."), NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED },
	{ N_("No smart card is available."), NT_STATUS_SMARTCARD_NO_CARD },
	{ N_("The requested key container does not exist on the smart card."), NT_STATUS_SMARTCARD_NO_KEY_CONTAINER },
	{ N_("The requested certificate does not exist on the smart card."), NT_STATUS_SMARTCARD_NO_CERTIFICATE },
	{ N_("The requested keyset does not exist."), NT_STATUS_SMARTCARD_NO_KEYSET },
	{ N_("A communication error with the smart card has been detected."), NT_STATUS_SMARTCARD_IO_ERROR },
	{ N_("The smart card certificate used for authentication has been revoked. Contact your system administrator. There may be additional information in the event log."), NT_STATUS_SMARTCARD_CERT_REVOKED },
	{ N_("An untrusted certificate authority was detected while processing the smart card certificate that is used for authentication. Contact your system administrator."), NT_STATUS_ISSUING_CA_UNTRUSTED },
	{ N_("The revocation status of the smart card certificate that is used for authentication could not be determined. Contact your system administrator."), NT_STATUS_REVOCATION_OFFLINE_C },
	{ N_("The smart card certificate used for authentication was not trusted. Contact your system administrator."), NT_STATUS_PKINIT_CLIENT_FAILURE },
	{ N_("The smart card certificate used for authentication has expired. Contact your system administrator."), NT_STATUS_SMARTCARD_CERT_EXPIRED },
	{ N_("The driver could not be loaded because a previous version of the driver is still in memory."), NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD },
	{ N_("The smart card provider could not perform the action because the context was acquired as silent."), NT_STATUS_SMARTCARD_SILENT_CONTEXT },
	{ N_("The delegated trust creation quota of the current user has been exceeded."), NT_STATUS_PER_USER_TRUST_QUOTA_EXCEEDED },
	{ N_("The total delegated trust creation quota has been exceeded."), NT_STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED },
	{ N_("The delegated trust deletion quota of the current user has been exceeded."), NT_STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED },
	{ N_("The requested name already exists as a unique identifier."), NT_STATUS_DS_NAME_NOT_UNIQUE },
	{ N_("The requested object has a non-unique identifier and cannot be retrieved."), NT_STATUS_DS_DUPLICATE_ID_FOUND },
	{ N_("The group cannot be converted due to attribute restrictions on the requested group type."), NT_STATUS_DS_GROUP_CONVERSION_ERROR },
	{ N_("{Volume Shadow Copy Service} Wait while the Volume Shadow Copy Service prepares volume %hs for hibernation."), NT_STATUS_VOLSNAP_PREPARE_HIBERNATE },
	{ N_("Kerberos sub-protocol User2User is required."), NT_STATUS_USER2USER_REQUIRED },
	{ N_("The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application."), NT_STATUS_STACK_BUFFER_OVERRUN },
	{ N_("The revocation status of the domain controller certificate used for smart card authentication could not be determined. There is additional information in the system event log. Contact your system administrator."), NT_STATUS_REVOCATION_OFFLINE_KDC },
	{ N_("An untrusted certificate authority was detected while processing the domain controller certificate used for authentication. There is additional information in the system event log. Contact your system administrator."), NT_STATUS_ISSUING_CA_UNTRUSTED_KDC },
	{ N_("The domain controller certificate used for smart card logon has expired. Contact your system administrator with the contents of your system event log."), NT_STATUS_KDC_CERT_EXPIRED },
	{ N_("The domain controller certificate used for smart card logon has been revoked. Contact your system administrator with the contents of your system event log."), NT_STATUS_KDC_CERT_REVOKED },
	{ N_("Data present in one of the parameters is more than the function can operate on."), NT_STATUS_PARAMETER_QUOTA_EXCEEDED },
	{ N_("The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted."), NT_STATUS_HIBERNATION_FAILURE },
	{ N_("An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed."), NT_STATUS_DELAY_LOAD_FAILED },
	{ N_("Logon Failure: The machine you are logging onto is protected by an authentication firewall. The specified account is not allowed to authenticate to the machine."), NT_STATUS_AUTHENTICATION_FIREWALL_FAILED },
	{ N_("%hs is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator."), NT_STATUS_VDM_DISALLOWED },
	{ N_("{Display Driver Stopped Responding} The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft."), NT_STATUS_HUNG_DISPLAY_DRIVER_THREAD },
	{ N_("The Desktop heap encountered an error while allocating session memory. There is more information in the system event log."), NT_STATUS_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE },
	{ N_("An invalid parameter was passed to a C runtime function."), NT_STATUS_INVALID_CRUNTIME_PARAMETER },
	{ N_("The authentication failed because NTLM was blocked."), NT_STATUS_NTLM_BLOCKED },
	{ N_("The source object's SID already exists in destination forest."), NT_STATUS_DS_SRC_SID_EXISTS_IN_FOREST },
	{ N_("The domain name of the trusted domain already exists in the forest."), NT_STATUS_DS_DOMAIN_NAME_EXISTS_IN_FOREST },
	{ N_("The flat name of the trusted domain already exists in the forest."), NT_STATUS_DS_FLAT_NAME_EXISTS_IN_FOREST },
	{ N_("The User Principal Name (UPN) is invalid."), NT_STATUS_INVALID_USER_PRINCIPAL_NAME },
	{ N_("There has been an assertion failure."), NT_STATUS_ASSERTION_FAILURE },
	{ N_("Application verifier has found an error in the current process."), NT_STATUS_VERIFIER_STOP },
	{ N_("A user mode unwind is in progress."), NT_STATUS_CALLBACK_POP_STACK },
	{ N_("%2 has been blocked from loading due to incompatibility with this system. Contact your software vendor for a compatible version of the driver."), NT_STATUS_INCOMPATIBLE_DRIVER_BLOCKED },
	{ N_("Illegal operation attempted on a registry key which has already been unloaded."), NT_STATUS_HIVE_UNLOADED },
	{ N_("Compression is disabled for this volume."), NT_STATUS_COMPRESSION_DISABLED },
	{ N_("The requested operation could not be completed due to a file system limitation."), NT_STATUS_FILE_SYSTEM_LIMITATION },
	{ N_("The hash for image %hs cannot be found in the system catalogs. The image is likely corrupt or the victim of tampering."), NT_STATUS_INVALID_IMAGE_HASH },
	{ N_("The implementation is not capable of performing the request."), NT_STATUS_NOT_CAPABLE },
	{ N_("The requested operation is out of order with respect to other operations."), NT_STATUS_REQUEST_OUT_OF_SEQUENCE },
	{ N_("An operation attempted to exceed an implementation-defined limit."), NT_STATUS_IMPLEMENTATION_LIMIT },
	{ N_("The requested operation requires elevation."), NT_STATUS_ELEVATION_REQUIRED },
	{ N_("The required security context does not exist."), NT_STATUS_NO_SECURITY_CONTEXT },
	{ N_("The PKU2U protocol encountered an error while attempting to utilize the associated certificates."), NT_STATUS_PKU2U_CERT_FAILURE },
	{ N_("The operation was attempted beyond the valid data length of the file."), NT_STATUS_BEYOND_VDL },
	{ N_("The attempted write operation encountered a write already in progress for some portion of the range."), NT_STATUS_ENCOUNTERED_WRITE_IN_PROGRESS },
	{ N_("The page fault mappings changed in the middle of processing a fault so the operation must be retried."), NT_STATUS_PTE_CHANGED },
	{ N_("The attempt to purge this file from memory failed to purge some or all the data from memory."), NT_STATUS_PURGE_FAILED },
	{ N_("The requested credential requires confirmation."), NT_STATUS_CRED_REQUIRES_CONFIRMATION },
	{ N_("The remote server sent an invalid response for a file being opened with Client Side Encryption."), NT_STATUS_CS_ENCRYPTION_INVALID_SERVER_RESPONSE },
	{ N_("Client Side Encryption is not supported by the remote server even though it claims to support it."), NT_STATUS_CS_ENCRYPTION_UNSUPPORTED_SERVER },
	{ N_("File is encrypted and should be opened in Client Side Encryption mode."), NT_STATUS_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE },
	{ N_("A new encrypted file is being created and a $EFS needs to be provided."), NT_STATUS_CS_ENCRYPTION_NEW_ENCRYPTED_FILE },
	{ N_("The SMB client requested a CSE FSCTL on a non-CSE file."), NT_STATUS_CS_ENCRYPTION_FILE_NOT_CSE },
	{ N_("Indicates a particular Security ID may not be assigned as the label of an object."), NT_STATUS_INVALID_LABEL },
	{ N_("The process hosting the driver for this device has terminated."), NT_STATUS_DRIVER_PROCESS_TERMINATED },
	{ N_("The requested system device cannot be identified due to multiple indistinguishable devices potentially matching the identification criteria."), NT_STATUS_AMBIGUOUS_SYSTEM_DEVICE },
	{ N_("The requested system device cannot be found."), NT_STATUS_SYSTEM_DEVICE_NOT_FOUND },
	{ N_("This boot application must be restarted."), NT_STATUS_RESTART_BOOT_APPLICATION },
	{ N_("Insufficient NVRAM resources exist to complete the API. A reboot might be required."), NT_STATUS_INSUFFICIENT_NVRAM_RESOURCES },
	{ N_("No ranges for the specified operation were able to be processed."), NT_STATUS_NO_RANGES_PROCESSED },
	{ N_("The storage device does not support Offload Write."), NT_STATUS_DEVICE_FEATURE_NOT_SUPPORTED },
	{ N_("Data cannot be moved because the source device cannot communicate with the destination device."), NT_STATUS_DEVICE_UNREACHABLE },
	{ N_("The token representing the data is invalid or expired."), NT_STATUS_INVALID_TOKEN },
	{ N_("The specified task name is invalid."), NT_STATUS_INVALID_TASK_NAME },
	{ N_("The specified task index is invalid."), NT_STATUS_INVALID_TASK_INDEX },
	{ N_("The specified thread is already joining a task."), NT_STATUS_THREAD_ALREADY_IN_TASK },
	{ N_("A callback has requested to bypass native code."), NT_STATUS_CALLBACK_BYPASS },
	{ N_("A fail fast exception occurred. Exception handlers will not be invoked and the process will be terminated immediately."), NT_STATUS_FAIL_FAST_EXCEPTION },
	{ N_("Windows cannot verify the digital signature for this file. The signing certificate for this file has been revoked."), NT_STATUS_IMAGE_CERT_REVOKED },
	{ N_("The ALPC port is closed."), NT_STATUS_PORT_CLOSED },
	{ N_("The ALPC message requested is no longer available."), NT_STATUS_MESSAGE_LOST },
	{ N_("The ALPC message supplied is invalid."), NT_STATUS_INVALID_MESSAGE },
	{ N_("The ALPC message has been canceled."), NT_STATUS_REQUEST_CANCELED },
	{ N_("Invalid recursive dispatch attempt."), NT_STATUS_RECURSIVE_DISPATCH },
	{ N_("No receive buffer has been supplied in a synchronous request."), NT_STATUS_LPC_RECEIVE_BUFFER_EXPECTED },
	{ N_("The connection port is used in an invalid context."), NT_STATUS_LPC_INVALID_CONNECTION_USAGE },
	{ N_("The ALPC port does not accept new request messages."), NT_STATUS_LPC_REQUESTS_NOT_ALLOWED },
	{ N_("The resource requested is already in use."), NT_STATUS_RESOURCE_IN_USE },
	{ N_("The hardware has reported an uncorrectable memory error."), NT_STATUS_HARDWARE_MEMORY_ERROR },
	{ N_("Status 0x%08x was returned, waiting on handle 0x%x for wait 0x%p, in waiter 0x%p."), NT_STATUS_THREADPOOL_HANDLE_EXCEPTION },
	{ N_("After a callback to 0x%p(0x%p), a completion call to Set event(0x%p) failed with status 0x%08x."), NT_STATUS_THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED },
	{ N_("After a callback to 0x%p(0x%p), a completion call to ReleaseSemaphore(0x%p, %d) failed with status 0x%08x."), NT_STATUS_THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED },
	{ N_("After a callback to 0x%p(0x%p), a completion call to ReleaseMutex(%p) failed with status 0x%08x."), NT_STATUS_THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED },
	{ N_("After a callback to 0x%p(0x%p), a completion call to FreeLibrary(%p) failed with status 0x%08x."), NT_STATUS_THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED },
	{ N_("The thread pool 0x%p was released while a thread was posting a callback to 0x%p(0x%p) to it."), NT_STATUS_THREADPOOL_RELEASED_DURING_OPERATION },
	{ N_("A thread pool worker thread is impersonating a client, after a callback to 0x%p(0x%p). This is unexpected, indicating that the callback is missing a call to revert the impersonation."), NT_STATUS_CALLBACK_RETURNED_WHILE_IMPERSONATING },
	{ N_("A thread pool worker thread is impersonating a client, after executing an APC. This is unexpected, indicating that the APC is missing a call to revert the impersonation."), NT_STATUS_APC_RETURNED_WHILE_IMPERSONATING },
	{ N_("Either the target process, or the target thread's containing process, is a protected process."), NT_STATUS_PROCESS_IS_PROTECTED },
	{ N_("A thread is getting dispatched with MCA EXCEPTION because of MCA."), NT_STATUS_MCA_EXCEPTION },
	{ N_("The client certificate account mapping is not unique."), NT_STATUS_CERTIFICATE_MAPPING_NOT_UNIQUE },
	{ N_("The symbolic link cannot be followed because its type is disabled."), NT_STATUS_SYMLINK_CLASS_DISABLED },
	{ N_("Indicates that the specified string is not valid for IDN normalization."), NT_STATUS_INVALID_IDN_NORMALIZATION },
	{ N_("No mapping for the Unicode character exists in the target multi-byte code page."), NT_STATUS_NO_UNICODE_TRANSLATION },
	{ N_("The provided callback is already registered."), NT_STATUS_ALREADY_REGISTERED },
	{ N_("The provided context did not match the target."), NT_STATUS_CONTEXT_MISMATCH },
	{ N_("The specified port already has a completion list."), NT_STATUS_PORT_ALREADY_HAS_COMPLETION_LIST },
	{ N_("A threadpool worker thread entered a callback at thread base priority 0x%x and exited at priority 0x%x. This is unexpected, indicating that the callback missed restoring the priority."), NT_STATUS_CALLBACK_RETURNED_THREAD_PRIORITY },
	{ N_("An invalid thread, handle %p, is specified for this operation. Possibly, a threadpool worker thread was specified."), NT_STATUS_INVALID_THREAD },
	{ N_("A threadpool worker thread entered a callback, which left transaction state. This is unexpected, indicating that the callback missed clearing the transaction."), NT_STATUS_CALLBACK_RETURNED_TRANSACTION },
	{ N_("A threadpool worker thread entered a callback, which left the loader lock held. This is unexpected, indicating that the callback missed releasing the lock."), NT_STATUS_CALLBACK_RETURNED_LDR_LOCK },
	{ N_("A threadpool worker thread entered a callback, which left with preferred languages set. This is unexpected, indicating that the callback missed clearing them."), NT_STATUS_CALLBACK_RETURNED_LANG },
	{ N_("A threadpool worker thread entered a callback, which left with background priorities set. This is unexpected, indicating that the callback missed restoring the original priorities."), NT_STATUS_CALLBACK_RETURNED_PRI_BACK },
	{ N_("The attempted operation required self healing to be enabled."), NT_STATUS_DISK_REPAIR_DISABLED },
	{ N_("The directory service cannot perform the requested operation because a domain rename operation is in progress."), NT_STATUS_DS_DOMAIN_RENAME_IN_PROGRESS },
	{ N_("An operation failed because the storage quota was exceeded."), NT_STATUS_DISK_QUOTA_EXCEEDED },
	{ N_("An operation failed because the content was blocked."), NT_STATUS_CONTENT_BLOCKED },
	{ N_("The operation could not be completed due to bad clusters on disk."), NT_STATUS_BAD_CLUSTERS },
	{ N_("The operation could not be completed because the volume is dirty. Please run the Chkdsk utility and try again."), NT_STATUS_VOLUME_DIRTY },
	{ N_("This file is checked out or locked for editing by another user."), NT_STATUS_FILE_CHECKED_OUT },
	{ N_("The file must be checked out before saving changes."), NT_STATUS_CHECKOUT_REQUIRED },
	{ N_("The file type being saved or retrieved has been blocked."), NT_STATUS_BAD_FILE_TYPE },
	{ N_("The file size exceeds the limit allowed and cannot be saved."), NT_STATUS_FILE_TOO_LARGE },
	{ N_("Access Denied. Before opening files in this location, you must first browse to the e.g. site and select the option to log on automatically."), NT_STATUS_FORMS_AUTH_REQUIRED },
	{ N_("The operation did not complete successfully because the file contains a virus."), NT_STATUS_VIRUS_INFECTED },
	{ N_("This file contains a virus and cannot be opened. Due to the nature of this virus, the file has been removed from this location."), NT_STATUS_VIRUS_DELETED },
	{ N_("The resources required for this device conflict with the MCFG table."), NT_STATUS_BAD_MCFG_TABLE },
	{ N_("The operation did not complete successfully because it would cause an oplock to be broken. The caller has requested that existing oplocks not be broken."), NT_STATUS_CANNOT_BREAK_OPLOCK },
	{ N_("WOW Assertion Error."), NT_STATUS_WOW_ASSERTION },
	{ N_("The cryptographic signature is invalid."), NT_STATUS_INVALID_SIGNATURE },
	{ N_("The cryptographic provider does not support HMAC."), NT_STATUS_HMAC_NOT_SUPPORTED },
	{ N_("The IPsec queue overflowed."), NT_STATUS_IPSEC_QUEUE_OVERFLOW },
	{ N_("The neighbor discovery queue overflowed."), NT_STATUS_ND_QUEUE_OVERFLOW },
	{ N_("An Internet Control Message Protocol (ICMP) hop limit exceeded error was received."), NT_STATUS_HOPLIMIT_EXCEEDED },
	{ N_("The protocol is not installed on the local machine."), NT_STATUS_PROTOCOL_NOT_SUPPORTED },
	{ N_("{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused by network connectivity issues. Try to save this file elsewhere."), NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED },
	{ N_("{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error was returned by the server on which the file exists. Try to save this file elsewhere."), NT_STATUS_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR },
	{ N_("{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused if the device has been removed or the media is write-protected."), NT_STATUS_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR },
	{ N_("Windows was unable to parse the requested XML data."), NT_STATUS_XML_PARSE_ERROR },
	{ N_("An error was encountered while processing an XML digital signature."), NT_STATUS_XMLDSIG_ERROR },
	{ N_("This indicates that the caller made the connection request in the wrong routing compartment."), NT_STATUS_WRONG_COMPARTMENT },
	{ N_("This indicates that there was an AuthIP failure when attempting to connect to the remote host."), NT_STATUS_AUTHIP_FAILURE },
	{ N_("OID mapped groups cannot have members."), NT_STATUS_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS },
	{ N_("The specified OID cannot be found."), NT_STATUS_DS_OID_NOT_FOUND },
	{ N_("Hash generation for the specified version and hash type is not enabled on server."), NT_STATUS_HASH_NOT_SUPPORTED },
	{ N_("The hash requests is not present or not up to date with the current file contents."), NT_STATUS_HASH_NOT_PRESENT },
	{ N_("A file system filter on the server has not opted in for Offload Read support."), NT_STATUS_OFFLOAD_READ_FLT_NOT_SUPPORTED },
	{ N_("A file system filter on the server has not opted in for Offload Write support."), NT_STATUS_OFFLOAD_WRITE_FLT_NOT_SUPPORTED },
	{ N_("Offload read operations cannot be performed on: Compressed files Sparse files Encrypted files File system metadata files"), NT_STATUS_OFFLOAD_READ_FILE_NOT_SUPPORTED },
	{ N_("Offload write operations cannot be performed on: Compressed files Sparse files Encrypted files File system metadata files"), NT_STATUS_OFFLOAD_WRITE_FILE_NOT_SUPPORTED },
	{ N_("The debugger did not perform a state change."), NT_STATUS_DBG_NO_STATE_CHANGE },
	{ N_("The debugger found that the application is not idle."), NT_STATUS_DBG_APP_NOT_IDLE },
	{ N_("The string binding is invalid."), NT_STATUS_RPC_INVALID_STRING_BINDING },
	{ N_("The binding handle is not the correct type."), NT_STATUS_RPC_WRONG_KIND_OF_BINDING },
	{ N_("The binding handle is invalid."), NT_STATUS_RPC_INVALID_BINDING },
	{ N_("The RPC protocol sequence is invalid."), NT_STATUS_RPC_INVALID_RPC_PROTSEQ },
	{ N_("The string UUID is invalid."), NT_STATUS_RPC_INVALID_STRING_UUID },
	{ N_("The endpoint format is invalid."), NT_STATUS_RPC_INVALID_ENDPOINT_FORMAT },
	{ N_("The network address is invalid."), NT_STATUS_RPC_INVALID_NET_ADDR },
	{ N_("No endpoint was found."), NT_STATUS_RPC_NO_ENDPOINT_FOUND },
	{ N_("The time-out value is invalid."), NT_STATUS_RPC_INVALID_TIMEOUT },
	{ N_("The object UUID was not found."), NT_STATUS_RPC_OBJECT_NOT_FOUND },
	{ N_("The object UUID has already been registered."), NT_STATUS_RPC_ALREADY_REGISTERED },
	{ N_("The type UUID has already been registered."), NT_STATUS_RPC_TYPE_ALREADY_REGISTERED },
	{ N_("The RPC server is already listening."), NT_STATUS_RPC_ALREADY_LISTENING },
	{ N_("No protocol sequences have been registered."), NT_STATUS_RPC_NO_PROTSEQS_REGISTERED },
	{ N_("The RPC server is not listening."), NT_STATUS_RPC_NOT_LISTENING },
	{ N_("The manager type is unknown."), NT_STATUS_RPC_UNKNOWN_MGR_TYPE },
	{ N_("There are no bindings."), NT_STATUS_RPC_NO_BINDINGS },
	{ N_("There are no protocol sequences."), NT_STATUS_RPC_NO_PROTSEQS },
	{ N_("The endpoint cannot be created."), NT_STATUS_RPC_CANT_CREATE_ENDPOINT },
	{ N_("Insufficient resources are available to complete this operation."), NT_STATUS_RPC_OUT_OF_RESOURCES },
	{ N_("The RPC server is unavailable."), NT_STATUS_RPC_SERVER_UNAVAILABLE },
	{ N_("The RPC server is too busy to complete this operation."), NT_STATUS_RPC_SERVER_TOO_BUSY },
	{ N_("The network options are invalid."), NT_STATUS_RPC_INVALID_NETWORK_OPTIONS },
	{ N_("No RPCs are active on this thread."), NT_STATUS_RPC_NO_CALL_ACTIVE },
	{ N_("The RPC failed and did not execute."), NT_STATUS_RPC_CALL_FAILED_DNE },
	{ N_("The RPC server does not support the transfer syntax."), NT_STATUS_RPC_UNSUPPORTED_TRANS_SYN },
	{ N_("The type UUID is not supported."), NT_STATUS_RPC_UNSUPPORTED_TYPE },
	{ N_("The tag is invalid."), NT_STATUS_RPC_INVALID_TAG },
	{ N_("The array bounds are invalid."), NT_STATUS_RPC_INVALID_BOUND },
	{ N_("The binding does not contain an entry name."), NT_STATUS_RPC_NO_ENTRY_NAME },
	{ N_("The name syntax is invalid."), NT_STATUS_RPC_INVALID_NAME_SYNTAX },
	{ N_("No network address is available to construct a UUID."), NT_STATUS_RPC_UUID_NO_ADDRESS },
	{ N_("The endpoint is a duplicate."), NT_STATUS_RPC_DUPLICATE_ENDPOINT },
	{ N_("The authentication type is unknown."), NT_STATUS_RPC_UNKNOWN_AUTHN_TYPE },
	{ N_("The maximum number of calls is too small."), NT_STATUS_RPC_MAX_CALLS_TOO_SMALL },
	{ N_("The string is too long."), NT_STATUS_RPC_STRING_TOO_LONG },
	{ N_("The RPC protocol sequence was not found."), NT_STATUS_RPC_PROTSEQ_NOT_FOUND },
	{ N_("The binding does not contain any authentication information."), NT_STATUS_RPC_BINDING_HAS_NO_AUTH },
	{ N_("The authentication service is unknown."), NT_STATUS_RPC_UNKNOWN_AUTHN_SERVICE },
	{ N_("The authentication level is unknown."), NT_STATUS_RPC_UNKNOWN_AUTHN_LEVEL },
	{ N_("The security context is invalid."), NT_STATUS_RPC_INVALID_AUTH_IDENTITY },
	{ N_("The authorization service is unknown."), NT_STATUS_RPC_UNKNOWN_AUTHZ_SERVICE },
	{ N_("The entry is invalid."), NT_STATUS_EPT_INVALID_ENTRY },
	{ N_("The operation cannot be performed."), NT_STATUS_EPT_CANT_PERFORM_OP },
	{ N_("No more endpoints are available from the endpoint mapper."), NT_STATUS_EPT_NOT_REGISTERED },
	{ N_("No interfaces have been exported."), NT_STATUS_RPC_NOTHING_TO_EXPORT },
	{ N_("The entry name is incomplete."), NT_STATUS_RPC_INCOMPLETE_NAME },
	{ N_("The version option is invalid."), NT_STATUS_RPC_INVALID_VERS_OPTION },
	{ N_("There are no more members."), NT_STATUS_RPC_NO_MORE_MEMBERS },
	{ N_("There is nothing to unexport."), NT_STATUS_RPC_NOT_ALL_OBJS_UNEXPORTED },
	{ N_("The interface was not found."), NT_STATUS_RPC_INTERFACE_NOT_FOUND },
	{ N_("The entry already exists."), NT_STATUS_RPC_ENTRY_ALREADY_EXISTS },
	{ N_("The entry was not found."), NT_STATUS_RPC_ENTRY_NOT_FOUND },
	{ N_("The name service is unavailable."), NT_STATUS_RPC_NAME_SERVICE_UNAVAILABLE },
	{ N_("The network address family is invalid."), NT_STATUS_RPC_INVALID_NAF_ID },
	{ N_("No security context is available to allow impersonation."), NT_STATUS_RPC_NO_CONTEXT_AVAILABLE },
	{ N_("An internal error occurred in the RPC."), NT_STATUS_RPC_INTERNAL_ERROR },
	{ N_("The RPC server attempted to divide an integer by zero."), NT_STATUS_RPC_ZERO_DIVIDE },
	{ N_("An addressing error occurred in the RPC server."), NT_STATUS_RPC_ADDRESS_ERROR },
	{ N_("A floating point operation at the RPC server caused a divide by zero."), NT_STATUS_RPC_FP_DIV_ZERO },
	{ N_("A floating point underflow occurred at the RPC server."), NT_STATUS_RPC_FP_UNDERFLOW },
	{ N_("A floating point overflow occurred at the RPC server."), NT_STATUS_RPC_FP_OVERFLOW },
	{ N_("An RPC is already in progress for this thread."), NT_STATUS_RPC_CALL_IN_PROGRESS },
	{ N_("There are no more bindings."), NT_STATUS_RPC_NO_MORE_BINDINGS },
	{ N_("The group member was not found."), NT_STATUS_RPC_GROUP_MEMBER_NOT_FOUND },
	{ N_("The endpoint mapper database entry could not be created."), NT_STATUS_EPT_CANT_CREATE },
	{ N_("The object UUID is the nil UUID."), NT_STATUS_RPC_INVALID_OBJECT },
	{ N_("No interfaces have been registered."), NT_STATUS_RPC_NO_INTERFACES },
	{ N_("The RPC was canceled."), NT_STATUS_RPC_CALL_CANCELLED },
	{ N_("The binding handle does not contain all the required information."), NT_STATUS_RPC_BINDING_INCOMPLETE },
	{ N_("A communications failure occurred during an RPC."), NT_STATUS_RPC_COMM_FAILURE },
	{ N_("The requested authentication level is not supported."), NT_STATUS_RPC_UNSUPPORTED_AUTHN_LEVEL },
	{ N_("No principal name was registered."), NT_STATUS_RPC_NO_PRINC_NAME },
	{ N_("The error specified is not a valid Windows RPC error code."), NT_STATUS_RPC_NOT_RPC_ERROR },
	{ N_("The thread was not canceled."), NT_STATUS_RPC_NOT_CANCELLED },
	{ N_("Invalid asynchronous RPC handle."), NT_STATUS_RPC_INVALID_ASYNC_HANDLE },
	{ N_("Invalid asynchronous RPC call handle for this operation."), NT_STATUS_RPC_INVALID_ASYNC_CALL },
	{ N_("Access to the HTTP proxy is denied."), NT_STATUS_RPC_PROXY_ACCESS_DENIED },
	{ N_("The list of RPC servers available for auto-handle binding has been exhausted."), NT_STATUS_RPC_NO_MORE_ENTRIES },
	{ N_("The file designated by DCERPCCHARTRANS cannot be opened."), NT_STATUS_RPC_SS_CHAR_TRANS_OPEN_FAIL },
	{ N_("The file containing the character translation table has fewer than 512 bytes."), NT_STATUS_RPC_SS_CHAR_TRANS_SHORT_FILE },
	{ N_("A null context handle is passed as an [in] parameter."), NT_STATUS_RPC_SS_IN_NULL_CONTEXT },
	{ N_("The context handle changed during a call."), NT_STATUS_RPC_SS_CONTEXT_DAMAGED },
	{ N_("The binding handles passed to an RPC do not match."), NT_STATUS_RPC_SS_HANDLES_MISMATCH },
	{ N_("The stub is unable to get the call handle."), NT_STATUS_RPC_SS_CANNOT_GET_CALL_HANDLE },
	{ N_("A null reference pointer was passed to the stub."), NT_STATUS_RPC_NULL_REF_POINTER },
	{ N_("The enumeration value is out of range."), NT_STATUS_RPC_ENUM_VALUE_OUT_OF_RANGE },
	{ N_("The byte count is too small."), NT_STATUS_RPC_BYTE_COUNT_TOO_SMALL },
	{ N_("Invalid operation on the encoding/decoding handle."), NT_STATUS_RPC_INVALID_ES_ACTION },
	{ N_("Incompatible version of the serializing package."), NT_STATUS_RPC_WRONG_ES_VERSION },
	{ N_("Incompatible version of the RPC stub."), NT_STATUS_RPC_WRONG_STUB_VERSION },
	{ N_("A device is missing in the system BIOS MPS table. This device will not be used. Contact your system vendor for a system BIOS update."), NT_STATUS_PNP_BAD_MPS_TABLE },
	{ N_("A translator failed to translate resources."), NT_STATUS_PNP_TRANSLATION_FAILED },
	{ N_("An IRQ translator failed to translate resources."), NT_STATUS_PNP_IRQ_TRANSLATION_FAILED },
	{ N_("Driver %2 returned an invalid ID for a child device (%3)."), NT_STATUS_PNP_INVALID_ID },
	{ N_("Reissue the given operation as a cached I/O operation"), NT_STATUS_IO_REISSUE_AS_CACHED },
	{ N_("Session name %1 is invalid."), NT_STATUS_CTX_WINSTATION_NAME_INVALID },
	{ N_("The protocol driver %1 is invalid."), NT_STATUS_CTX_INVALID_PD },
	{ N_("The protocol driver %1 was not found in the system path."), NT_STATUS_CTX_PD_NOT_FOUND },
	{ N_("A close operation is pending on the terminal connection."), NT_STATUS_CTX_CLOSE_PENDING },
	{ N_("No free output buffers are available."), NT_STATUS_CTX_NO_OUTBUF },
	{ N_("The MODEM.INF file was not found."), NT_STATUS_CTX_MODEM_INF_NOT_FOUND },
	{ N_("The modem (%1) was not found in the MODEM.INF file."), NT_STATUS_CTX_INVALID_MODEMNAME },
	{ N_("The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem."), NT_STATUS_CTX_RESPONSE_ERROR },
	{ N_("The modem did not respond to the command sent to it. Verify that the modem cable is properly attached and the modem is turned on."), NT_STATUS_CTX_MODEM_RESPONSE_TIMEOUT },
	{ N_("Carrier detection has failed or the carrier has been dropped due to disconnection."), NT_STATUS_CTX_MODEM_RESPONSE_NO_CARRIER },
	{ N_("A dial tone was not detected within the required time. Verify that the phone cable is properly attached and functional."), NT_STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE },
	{ N_("A busy signal was detected at a remote site on callback."), NT_STATUS_CTX_MODEM_RESPONSE_BUSY },
	{ N_("A voice was detected at a remote site on callback."), NT_STATUS_CTX_MODEM_RESPONSE_VOICE },
	{ N_("Transport driver error."), NT_STATUS_CTX_TD_ERROR },
	{ N_("The client you are using is not licensed to use this system. Your logon request is denied."), NT_STATUS_CTX_LICENSE_CLIENT_INVALID },
	{ N_("The system has reached its licensed logon limit. Try again later."), NT_STATUS_CTX_LICENSE_NOT_AVAILABLE },
	{ N_("The system license has expired. Your logon request is denied."), NT_STATUS_CTX_LICENSE_EXPIRED },
	{ N_("The specified session cannot be found."), NT_STATUS_CTX_WINSTATION_NOT_FOUND },
	{ N_("The specified session name is already in use."), NT_STATUS_CTX_WINSTATION_NAME_COLLISION },
	{ N_("The requested operation cannot be completed because the terminal connection is currently processing a connect, disconnect, reset, or delete operation."), NT_STATUS_CTX_WINSTATION_BUSY },
	{ N_("An attempt has been made to connect to a session whose video mode is not supported by the current client."), NT_STATUS_CTX_BAD_VIDEO_MODE },
	{ N_("The application attempted to enable DOS graphics mode. DOS graphics mode is not supported."), NT_STATUS_CTX_GRAPHICS_INVALID },
	{ N_("The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access."), NT_STATUS_CTX_NOT_CONSOLE },
	{ N_("The client failed to respond to the server connect message."), NT_STATUS_CTX_CLIENT_QUERY_TIMEOUT },
	{ N_("Disconnecting the console session is not supported."), NT_STATUS_CTX_CONSOLE_DISCONNECT },
	{ N_("Reconnecting a disconnected session to the console is not supported."), NT_STATUS_CTX_CONSOLE_CONNECT },
	{ N_("The request to control another session remotely was denied."), NT_STATUS_CTX_SHADOW_DENIED },
	{ N_("A process has requested access to a session, but has not been granted those access rights."), NT_STATUS_CTX_WINSTATION_ACCESS_DENIED },
	{ N_("The terminal connection driver %1 is invalid."), NT_STATUS_CTX_INVALID_WD },
	{ N_("The terminal connection driver %1 was not found in the system path."), NT_STATUS_CTX_WD_NOT_FOUND },
	{ N_("The requested session cannot be controlled remotely. You cannot control your own session, a session that is trying to control your session, a session that has no user logged on, or other sessions from the console."), NT_STATUS_CTX_SHADOW_INVALID },
	{ N_("The requested session is not configured to allow remote control."), NT_STATUS_CTX_SHADOW_DISABLED },
	{ N_("The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client."), NT_STATUS_RDP_PROTOCOL_ERROR },
	{ N_("Your request to connect to this terminal server has been rejected. Your terminal server client license number has not been entered for this copy of the terminal client. Contact your system administrator for help in entering a valid, unique license number for this terminal server client. Click OK to continue."), NT_STATUS_CTX_CLIENT_LICENSE_NOT_SET },
	{ N_("Your request to connect to this terminal server has been rejected. Your terminal server client license number is currently being used by another user. Contact your system administrator to obtain a new copy of the terminal server client with a valid, unique license number. Click OK to continue."), NT_STATUS_CTX_CLIENT_LICENSE_IN_USE },
	{ N_("The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported."), NT_STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE },
	{ N_("Remote control could not be terminated because the specified session is not currently being remotely controlled."), NT_STATUS_CTX_SHADOW_NOT_RUNNING },
	{ N_("Your interactive logon privilege has been disabled. Contact your system administrator."), NT_STATUS_CTX_LOGON_DISABLED },
	{ N_("The terminal server security layer detected an error in the protocol stream and has disconnected the client."), NT_STATUS_CTX_SECURITY_LAYER_ERROR },
	{ N_("The target session is incompatible with the current session."), NT_STATUS_TS_INCOMPATIBLE_SESSIONS },
	{ N_("The resource loader failed to find an MUI file."), NT_STATUS_MUI_FILE_NOT_FOUND },
	{ N_("The resource loader failed to load an MUI file because the file failed to pass validation."), NT_STATUS_MUI_INVALID_FILE },
	{ N_("The RC manifest is corrupted with garbage data, is an unsupported version, or is missing a required item."), NT_STATUS_MUI_INVALID_RC_CONFIG },
	{ N_("The RC manifest has an invalid culture name."), NT_STATUS_MUI_INVALID_LOCALE_NAME },
	{ N_("The RC manifest has and invalid ultimate fallback name."), NT_STATUS_MUI_INVALID_ULTIMATEFALLBACK_NAME },
	{ N_("The resource loader cache does not have a loaded MUI entry."), NT_STATUS_MUI_FILE_NOT_LOADED },
	{ N_("The user stopped resource enumeration."), NT_STATUS_RESOURCE_ENUM_USER_STOP },
	{ N_("The cluster node is not valid."), NT_STATUS_CLUSTER_INVALID_NODE },
	{ N_("The cluster node already exists."), NT_STATUS_CLUSTER_NODE_EXISTS },
	{ N_("A node is in the process of joining the cluster."), NT_STATUS_CLUSTER_JOIN_IN_PROGRESS },
	{ N_("The cluster node was not found."), NT_STATUS_CLUSTER_NODE_NOT_FOUND },
	{ N_("The cluster local node information was not found."), NT_STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND },
	{ N_("The cluster network already exists."), NT_STATUS_CLUSTER_NETWORK_EXISTS },
	{ N_("The cluster network was not found."), NT_STATUS_CLUSTER_NETWORK_NOT_FOUND },
	{ N_("The cluster network interface already exists."), NT_STATUS_CLUSTER_NETINTERFACE_EXISTS },
	{ N_("The cluster network interface was not found."), NT_STATUS_CLUSTER_NETINTERFACE_NOT_FOUND },
	{ N_("The cluster request is not valid for this object."), NT_STATUS_CLUSTER_INVALID_REQUEST },
	{ N_("The cluster network provider is not valid."), NT_STATUS_CLUSTER_INVALID_NETWORK_PROVIDER },
	{ N_("The cluster node is down."), NT_STATUS_CLUSTER_NODE_DOWN },
	{ N_("The cluster node is not reachable."), NT_STATUS_CLUSTER_NODE_UNREACHABLE },
	{ N_("The cluster node is not a member of the cluster."), NT_STATUS_CLUSTER_NODE_NOT_MEMBER },
	{ N_("A cluster join operation is not in progress."), NT_STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS },
	{ N_("The cluster network is not valid."), NT_STATUS_CLUSTER_INVALID_NETWORK },
	{ N_("No network adapters are available."), NT_STATUS_CLUSTER_NO_NET_ADAPTERS },
	{ N_("The cluster node is up."), NT_STATUS_CLUSTER_NODE_UP },
	{ N_("The cluster node is paused."), NT_STATUS_CLUSTER_NODE_PAUSED },
	{ N_("The cluster node is not paused."), NT_STATUS_CLUSTER_NODE_NOT_PAUSED },
	{ N_("No cluster security context is available."), NT_STATUS_CLUSTER_NO_SECURITY_CONTEXT },
	{ N_("The cluster network is not configured for internal cluster communication."), NT_STATUS_CLUSTER_NETWORK_NOT_INTERNAL },
	{ N_("The cluster node has been poisoned."), NT_STATUS_CLUSTER_POISONED },
	{ N_("An attempt was made to run an invalid AML opcode."), NT_STATUS_ACPI_INVALID_OPCODE },
	{ N_("The AML interpreter stack has overflowed."), NT_STATUS_ACPI_STACK_OVERFLOW },
	{ N_("An inconsistent state has occurred."), NT_STATUS_ACPI_ASSERT_FAILED },
	{ N_("An attempt was made to access an array outside its bounds."), NT_STATUS_ACPI_INVALID_INDEX },
	{ N_("A required argument was not specified."), NT_STATUS_ACPI_INVALID_ARGUMENT },
	{ N_("A fatal error has occurred."), NT_STATUS_ACPI_FATAL },
	{ N_("An invalid SuperName was specified."), NT_STATUS_ACPI_INVALID_SUPERNAME },
	{ N_("An argument with an incorrect type was specified."), NT_STATUS_ACPI_INVALID_ARGTYPE },
	{ N_("An object with an incorrect type was specified."), NT_STATUS_ACPI_INVALID_OBJTYPE },
	{ N_("A target with an incorrect type was specified."), NT_STATUS_ACPI_INVALID_TARGETTYPE },
	{ N_("An incorrect number of arguments was specified."), NT_STATUS_ACPI_INCORRECT_ARGUMENT_COUNT },
	{ N_("An address failed to translate."), NT_STATUS_ACPI_ADDRESS_NOT_MAPPED },
	{ N_("An incorrect event type was specified."), NT_STATUS_ACPI_INVALID_EVENTTYPE },
	{ N_("A handler for the target already exists."), NT_STATUS_ACPI_HANDLER_COLLISION },
	{ N_("Invalid data for the target was specified."), NT_STATUS_ACPI_INVALID_DATA },
	{ N_("An invalid region for the target was specified."), NT_STATUS_ACPI_INVALID_REGION },
	{ N_("An attempt was made to access a field outside the defined range."), NT_STATUS_ACPI_INVALID_ACCESS_SIZE },
	{ N_("The global system lock could not be acquired."), NT_STATUS_ACPI_ACQUIRE_GLOBAL_LOCK },
	{ N_("An attempt was made to reinitialize the ACPI subsystem."), NT_STATUS_ACPI_ALREADY_INITIALIZED },
	{ N_("The ACPI subsystem has not been initialized."), NT_STATUS_ACPI_NOT_INITIALIZED },
	{ N_("An incorrect mutex was specified."), NT_STATUS_ACPI_INVALID_MUTEX_LEVEL },
	{ N_("The mutex is not currently owned."), NT_STATUS_ACPI_MUTEX_NOT_OWNED },
	{ N_("An attempt was made to access the mutex by a process that was not the owner."), NT_STATUS_ACPI_MUTEX_NOT_OWNER },
	{ N_("An error occurred during an access to region space."), NT_STATUS_ACPI_RS_ACCESS },
	{ N_("An attempt was made to use an incorrect table."), NT_STATUS_ACPI_INVALID_TABLE },
	{ N_("The registration of an ACPI event failed."), NT_STATUS_ACPI_REG_HANDLER_FAILED },
	{ N_("An ACPI power object failed to transition state."), NT_STATUS_ACPI_POWER_REQUEST_FAILED },
	{ N_("The requested section is not present in the activation context."), NT_STATUS_SXS_SECTION_NOT_FOUND },
	{ N_("Windows was unble to process the application binding information. Refer to the system event log for further information."), NT_STATUS_SXS_CANT_GEN_ACTCTX },
	{ N_("The application binding data format is invalid."), NT_STATUS_SXS_INVALID_ACTCTXDATA_FORMAT },
	{ N_("The referenced assembly is not installed on the system."), NT_STATUS_SXS_ASSEMBLY_NOT_FOUND },
	{ N_("The manifest file does not begin with the required tag and format information."), NT_STATUS_SXS_MANIFEST_FORMAT_ERROR },
	{ N_("The manifest file contains one or more syntax errors."), NT_STATUS_SXS_MANIFEST_PARSE_ERROR },
	{ N_("The application attempted to activate a disabled activation context."), NT_STATUS_SXS_ACTIVATION_CONTEXT_DISABLED },
	{ N_("The requested lookup key was not found in any active activation context."), NT_STATUS_SXS_KEY_NOT_FOUND },
	{ N_("A component version required by the application conflicts with another component version that is already active."), NT_STATUS_SXS_VERSION_CONFLICT },
	{ N_("The type requested activation context section does not match the query API used."), NT_STATUS_SXS_WRONG_SECTION_TYPE },
	{ N_("Lack of system resources has required isolated activation to be disabled for the current thread of execution."), NT_STATUS_SXS_THREAD_QUERIES_DISABLED },
	{ N_("The referenced assembly could not be found."), NT_STATUS_SXS_ASSEMBLY_MISSING },
	{ N_("An attempt to set the process default activation context failed because the process default activation context was already set."), NT_STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET },
	{ N_("The activation context being deactivated is not the most recently activated one."), NT_STATUS_SXS_EARLY_DEACTIVATION },
	{ N_("The activation context being deactivated is not active for the current thread of execution."), NT_STATUS_SXS_INVALID_DEACTIVATION },
	{ N_("The activation context being deactivated has already been deactivated."), NT_STATUS_SXS_MULTIPLE_DEACTIVATION },
	{ N_("The activation context of the system default assembly could not be generated."), NT_STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY },
	{ N_("A component used by the isolation facility has requested that the process be terminated."), NT_STATUS_SXS_PROCESS_TERMINATION_REQUESTED },
	{ N_("The activation context activation stack for the running thread of execution is corrupt."), NT_STATUS_SXS_CORRUPT_ACTIVATION_STACK },
	{ N_("The application isolation metadata for this process or thread has become corrupt."), NT_STATUS_SXS_CORRUPTION },
	{ N_("The value of an attribute in an identity is not within the legal range."), NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE },
	{ N_("The name of an attribute in an identity is not within the legal range."), NT_STATUS_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME },
	{ N_("An identity contains two definitions for the same attribute."), NT_STATUS_SXS_IDENTITY_DUPLICATE_ATTRIBUTE },
	{ N_("The identity string is malformed. This may be due to a trailing comma, more than two unnamed attributes, a missing attribute name, or a missing attribute value."), NT_STATUS_SXS_IDENTITY_PARSE_ERROR },
	{ N_("The component store has become corrupted."), NT_STATUS_SXS_COMPONENT_STORE_CORRUPT },
	{ N_("A component's file does not match the verification information present in the component manifest."), NT_STATUS_SXS_FILE_HASH_MISMATCH },
	{ N_("The identities of the manifests are identical, but their contents are different."), NT_STATUS_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT },
	{ N_("The component identities are different."), NT_STATUS_SXS_IDENTITIES_DIFFERENT },
	{ N_("The assembly is not a deployment."), NT_STATUS_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT },
	{ N_("The file is not a part of the assembly."), NT_STATUS_SXS_FILE_NOT_PART_OF_ASSEMBLY },
	{ N_("An advanced installer failed during setup or servicing."), NT_STATUS_ADVANCED_INSTALLER_FAILED },
	{ N_("The character encoding in the XML declaration did not match the encoding used in the document."), NT_STATUS_XML_ENCODING_MISMATCH },
	{ N_("The size of the manifest exceeds the maximum allowed."), NT_STATUS_SXS_MANIFEST_TOO_BIG },
	{ N_("The setting is not registered."), NT_STATUS_SXS_SETTING_NOT_REGISTERED },
	{ N_("One or more required transaction members are not present."), NT_STATUS_SXS_TRANSACTION_CLOSURE_INCOMPLETE },
	{ N_("The SMI primitive installer failed during setup or servicing."), NT_STATUS_SMI_PRIMITIVE_INSTALLER_FAILED },
	{ N_("A generic command executable returned a result that indicates failure."), NT_STATUS_GENERIC_COMMAND_FAILED },
	{ N_("A component is missing file verification information in its manifest."), NT_STATUS_SXS_FILE_HASH_MISSING },
	{ N_("The function attempted to use a name that is reserved for use by another transaction."), NT_STATUS_TRANSACTIONAL_CONFLICT },
	{ N_("The transaction handle associated with this operation is invalid."), NT_STATUS_INVALID_TRANSACTION },
	{ N_("The requested operation was made in the context of a transaction that is no longer active."), NT_STATUS_TRANSACTION_NOT_ACTIVE },
	{ N_("The transaction manager was unable to be successfully initialized. Transacted operations are not supported."), NT_STATUS_TM_INITIALIZATION_FAILED },
	{ N_("Transaction support within the specified file system resource manager was not started or was shut down due to an error."), NT_STATUS_RM_NOT_ACTIVE },
	{ N_("The metadata of the resource manager has been corrupted. The resource manager will not function."), NT_STATUS_RM_METADATA_CORRUPT },
	{ N_("The resource manager attempted to prepare a transaction that it has not successfully joined."), NT_STATUS_TRANSACTION_NOT_JOINED },
	{ N_("The specified directory does not contain a file system resource manager."), NT_STATUS_DIRECTORY_NOT_RM },
	{ N_("The remote server or share does not support transacted file operations."), NT_STATUS_TRANSACTIONS_UNSUPPORTED_REMOTE },
	{ N_("The requested log size for the file system resource manager is invalid."), NT_STATUS_LOG_RESIZE_INVALID_SIZE },
	{ N_("The remote server sent mismatching version number or Fid for a file opened with transactions."), NT_STATUS_REMOTE_FILE_VERSION_MISMATCH },
	{ N_("The resource manager tried to register a protocol that already exists."), NT_STATUS_CRM_PROTOCOL_ALREADY_EXISTS },
	{ N_("The attempt to propagate the transaction failed."), NT_STATUS_TRANSACTION_PROPAGATION_FAILED },
	{ N_("The requested propagation protocol was not registered as a CRM."), NT_STATUS_CRM_PROTOCOL_NOT_FOUND },
	{ N_("The transaction object already has a superior enlistment, and the caller attempted an operation that would have created a new superior. Only a single superior enlistment is allowed."), NT_STATUS_TRANSACTION_SUPERIOR_EXISTS },
	{ N_("The requested operation is not valid on the transaction object in its current state."), NT_STATUS_TRANSACTION_REQUEST_NOT_VALID },
	{ N_("The caller has called a response API, but the response is not expected because the transaction manager did not issue the corresponding request to the caller."), NT_STATUS_TRANSACTION_NOT_REQUESTED },
	{ N_("It is too late to perform the requested operation, because the transaction has already been aborted."), NT_STATUS_TRANSACTION_ALREADY_ABORTED },
	{ N_("It is too late to perform the requested operation, because the transaction has already been committed."), NT_STATUS_TRANSACTION_ALREADY_COMMITTED },
	{ N_("The buffer passed in to NtPushTransaction or NtPullTransaction is not in a valid format."), NT_STATUS_TRANSACTION_INVALID_MARSHALL_BUFFER },
	{ N_("The current transaction context associated with the thread is not a valid handle to a transaction object."), NT_STATUS_CURRENT_TRANSACTION_NOT_VALID },
	{ N_("An attempt to create space in the transactional resource manager's log failed. The failure status has been recorded in the event log."), NT_STATUS_LOG_GROWTH_FAILED },
	{ N_("The object (file, stream, or link) that corresponds to the handle has been deleted by a transaction savepoint rollback."), NT_STATUS_OBJECT_NO_LONGER_EXISTS },
	{ N_("The specified file miniversion was not found for this transacted file open."), NT_STATUS_STREAM_MINIVERSION_NOT_FOUND },
	{ N_("The specified file miniversion was found but has been invalidated. The most likely cause is a transaction savepoint rollback."), NT_STATUS_STREAM_MINIVERSION_NOT_VALID },
	{ N_("A miniversion may be opened only in the context of the transaction that created it."), NT_STATUS_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION },
	{ N_("It is not possible to open a miniversion with modify access."), NT_STATUS_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT },
	{ N_("It is not possible to create any more miniversions for this stream."), NT_STATUS_CANT_CREATE_MORE_STREAM_MINIVERSIONS },
	{ N_("The handle has been invalidated by a transaction. The most likely cause is the presence of memory mapping on a file or an open handle when the transaction ended or rolled back to savepoint."), NT_STATUS_HANDLE_NO_LONGER_VALID },
	{ N_("The log data is corrupt."), NT_STATUS_LOG_CORRUPTION_DETECTED },
	{ N_("The transaction outcome is unavailable because the resource manager responsible for it is disconnected."), NT_STATUS_RM_DISCONNECTED },
	{ N_("The request was rejected because the enlistment in question is not a superior enlistment."), NT_STATUS_ENLISTMENT_NOT_SUPERIOR },
	{ N_("The file cannot be opened in a transaction because its identity depends on the outcome of an unresolved transaction."), NT_STATUS_FILE_IDENTITY_NOT_PERSISTENT },
	{ N_("The operation cannot be performed because another transaction is depending on this property not changing."), NT_STATUS_CANT_BREAK_TRANSACTIONAL_DEPENDENCY },
	{ N_("The operation would involve a single file with two transactional resource managers and is, therefore, not allowed."), NT_STATUS_CANT_CROSS_RM_BOUNDARY },
	{ N_("The $Txf directory must be empty for this operation to succeed."), NT_STATUS_TXF_DIR_NOT_EMPTY },
	{ N_("The operation would leave a transactional resource manager in an inconsistent state and is therefore not allowed."), NT_STATUS_INDOUBT_TRANSACTIONS_EXIST },
	{ N_("The operation could not be completed because the transaction manager does not have a log."), NT_STATUS_TM_VOLATILE },
	{ N_("A rollback could not be scheduled because a previously scheduled rollback has already executed or been queued for execution."), NT_STATUS_ROLLBACK_TIMER_EXPIRED },
	{ N_("The transactional metadata attribute on the file or directory %hs is corrupt and unreadable."), NT_STATUS_TXF_ATTRIBUTE_CORRUPT },
	{ N_("The encryption operation could not be completed because a transaction is active."), NT_STATUS_EFS_NOT_ALLOWED_IN_TRANSACTION },
	{ N_("This object is not allowed to be opened in a transaction."), NT_STATUS_TRANSACTIONAL_OPEN_NOT_ALLOWED },
	{ N_("Memory mapping (creating a mapped section) a remote file under a transaction is not supported."), NT_STATUS_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE },
	{ N_("Promotion was required to allow the resource manager to enlist, but the transaction was set to disallow it."), NT_STATUS_TRANSACTION_REQUIRED_PROMOTION },
	{ N_("This file is open for modification in an unresolved transaction and may be opened for execute only by a transacted reader."), NT_STATUS_CANNOT_EXECUTE_FILE_IN_TRANSACTION },
	{ N_("The request to thaw frozen transactions was ignored because transactions were not previously frozen."), NT_STATUS_TRANSACTIONS_NOT_FROZEN },
	{ N_("Transactions cannot be frozen because a freeze is already in progress."), NT_STATUS_TRANSACTION_FREEZE_IN_PROGRESS },
	{ N_("The target volume is not a snapshot volume. This operation is valid only on a volume mounted as a snapshot."), NT_STATUS_NOT_SNAPSHOT_VOLUME },
	{ N_("The savepoint operation failed because files are open on the transaction, which is not permitted."), NT_STATUS_NO_SAVEPOINT_WITH_OPEN_FILES },
	{ N_("The sparse operation could not be completed because a transaction is active on the file."), NT_STATUS_SPARSE_NOT_ALLOWED_IN_TRANSACTION },
	{ N_("The call to create a transaction manager object failed because the Tm Identity that is stored in the log file does not match the Tm Identity that was passed in as an argument."), NT_STATUS_TM_IDENTITY_MISMATCH },
	{ N_("I/O was attempted on a section object that has been floated as a result of a transaction ending. There is no valid data."), NT_STATUS_FLOATED_SECTION },
	{ N_("The transactional resource manager cannot currently accept transacted work due to a transient condition, such as low resources."), NT_STATUS_CANNOT_ACCEPT_TRANSACTED_WORK },
	{ N_("The transactional resource manager had too many transactions outstanding that could not be aborted. The transactional resource manager has been shut down."), NT_STATUS_CANNOT_ABORT_TRANSACTIONS },
	{ N_("The specified transaction was unable to be opened because it was not found."), NT_STATUS_TRANSACTION_NOT_FOUND },
	{ N_("The specified resource manager was unable to be opened because it was not found."), NT_STATUS_RESOURCEMANAGER_NOT_FOUND },
	{ N_("The specified enlistment was unable to be opened because it was not found."), NT_STATUS_ENLISTMENT_NOT_FOUND },
	{ N_("The specified transaction manager was unable to be opened because it was not found."), NT_STATUS_TRANSACTIONMANAGER_NOT_FOUND },
	{ N_("The specified resource manager was unable to create an enlistment because its associated transaction manager is not online."), NT_STATUS_TRANSACTIONMANAGER_NOT_ONLINE },
	{ N_("The specified transaction manager was unable to create the objects contained in its log file in the Ob namespace. Therefore, the transaction manager was unable to recover."), NT_STATUS_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION },
	{ N_("The call to create a superior enlistment on this transaction object could not be completed because the transaction object specified for the enlistment is a subordinate branch of the transaction. Only the root of the transaction can be enlisted as a superior."), NT_STATUS_TRANSACTION_NOT_ROOT },
	{ N_("Because the associated transaction manager or resource manager has been closed, the handle is no longer valid."), NT_STATUS_TRANSACTION_OBJECT_EXPIRED },
	{ N_("The compression operation could not be completed because a transaction is active on the file."), NT_STATUS_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION },
	{ N_("The specified operation could not be performed on this superior enlistment because the enlistment was not created with the corresponding completion response in the NotificationMask."), NT_STATUS_TRANSACTION_RESPONSE_NOT_ENLISTED },
	{ N_("The specified operation could not be performed because the record to be logged was too long. This can occur because either there are too many enlistments on this transaction or the combined RecoveryInformation being logged on behalf of those enlistments is too long."), NT_STATUS_TRANSACTION_RECORD_TOO_LONG },
	{ N_("The link-tracking operation could not be completed because a transaction is active."), NT_STATUS_NO_LINK_TRACKING_IN_TRANSACTION },
	{ N_("This operation cannot be performed in a transaction."), NT_STATUS_OPERATION_NOT_SUPPORTED_IN_TRANSACTION },
	{ N_("The kernel transaction manager had to abort or forget the transaction because it blocked forward progress."), NT_STATUS_TRANSACTION_INTEGRITY_VIOLATED },
	{ N_("The handle is no longer properly associated with its transaction. It may have been opened in a transactional resource manager that was subsequently forced to restart. Please close the handle and open a new one."), NT_STATUS_EXPIRED_HANDLE },
	{ N_("The specified operation could not be performed because the resource manager is not enlisted in the transaction."), NT_STATUS_TRANSACTION_NOT_ENLISTED },
	{ N_("The log service found an invalid log sector."), NT_STATUS_LOG_SECTOR_INVALID },
	{ N_("The log service encountered a log sector with invalid block parity."), NT_STATUS_LOG_SECTOR_PARITY_INVALID },
	{ N_("The log service encountered a remapped log sector."), NT_STATUS_LOG_SECTOR_REMAPPED },
	{ N_("The log service encountered a partial or incomplete log block."), NT_STATUS_LOG_BLOCK_INCOMPLETE },
	{ N_("The log service encountered an attempt to access data outside the active log range."), NT_STATUS_LOG_INVALID_RANGE },
	{ N_("The log service user-log marshaling buffers are exhausted."), NT_STATUS_LOG_BLOCKS_EXHAUSTED },
	{ N_("The log service encountered an attempt to read from a marshaling area with an invalid read context."), NT_STATUS_LOG_READ_CONTEXT_INVALID },
	{ N_("The log service encountered an invalid log restart area."), NT_STATUS_LOG_RESTART_INVALID },
	{ N_("The log service encountered an invalid log block version."), NT_STATUS_LOG_BLOCK_VERSION },
	{ N_("The log service encountered an invalid log block."), NT_STATUS_LOG_BLOCK_INVALID },
	{ N_("The log service encountered an attempt to read the log with an invalid read mode."), NT_STATUS_LOG_READ_MODE_INVALID },
	{ N_("The log service encountered a corrupted metadata file."), NT_STATUS_LOG_METADATA_CORRUPT },
	{ N_("The log service encountered a metadata file that could not be created by the log file system."), NT_STATUS_LOG_METADATA_INVALID },
	{ N_("The log service encountered a metadata file with inconsistent data."), NT_STATUS_LOG_METADATA_INCONSISTENT },
	{ N_("The log service encountered an attempt to erroneously allocate or dispose reservation space."), NT_STATUS_LOG_RESERVATION_INVALID },
	{ N_("The log service cannot delete the log file or the file system container."), NT_STATUS_LOG_CANT_DELETE },
	{ N_("The log service has reached the maximum allowable containers allocated to a log file."), NT_STATUS_LOG_CONTAINER_LIMIT_EXCEEDED },
	{ N_("The log service has attempted to read or write backward past the start of the log."), NT_STATUS_LOG_START_OF_LOG },
	{ N_("The log policy could not be installed because a policy of the same type is already present."), NT_STATUS_LOG_POLICY_ALREADY_INSTALLED },
	{ N_("The log policy in question was not installed at the time of the request."), NT_STATUS_LOG_POLICY_NOT_INSTALLED },
	{ N_("The installed set of policies on the log is invalid."), NT_STATUS_LOG_POLICY_INVALID },
	{ N_("A policy on the log in question prevented the operation from completing."), NT_STATUS_LOG_POLICY_CONFLICT },
	{ N_("The log space cannot be reclaimed because the log is pinned by the archive tail."), NT_STATUS_LOG_PINNED_ARCHIVE_TAIL },
	{ N_("The log record is not a record in the log file."), NT_STATUS_LOG_RECORD_NONEXISTENT },
	{ N_("The number of reserved log records or the adjustment of the number of reserved log records is invalid."), NT_STATUS_LOG_RECORDS_RESERVED_INVALID },
	{ N_("The reserved log space or the adjustment of the log space is invalid."), NT_STATUS_LOG_SPACE_RESERVED_INVALID },
	{ N_("A new or existing archive tail or the base of the active log is invalid."), NT_STATUS_LOG_TAIL_INVALID },
	{ N_("The log space is exhausted."), NT_STATUS_LOG_FULL },
	{ N_("The log is multiplexed; no direct writes to the physical log are allowed."), NT_STATUS_LOG_MULTIPLEXED },
	{ N_("The operation failed because the log is dedicated."), NT_STATUS_LOG_DEDICATED },
	{ N_("The operation requires an archive context."), NT_STATUS_LOG_ARCHIVE_NOT_IN_PROGRESS },
	{ N_("Log archival is in progress."), NT_STATUS_LOG_ARCHIVE_IN_PROGRESS },
	{ N_("The operation requires a nonephemeral log, but the log is ephemeral."), NT_STATUS_LOG_EPHEMERAL },
	{ N_("The log must have at least two containers before it can be read from or written to."), NT_STATUS_LOG_NOT_ENOUGH_CONTAINERS },
	{ N_("A log client has already registered on the stream."), NT_STATUS_LOG_CLIENT_ALREADY_REGISTERED },
	{ N_("A log client has not been registered on the stream."), NT_STATUS_LOG_CLIENT_NOT_REGISTERED },
	{ N_("A request has already been made to handle the log full condition."), NT_STATUS_LOG_FULL_HANDLER_IN_PROGRESS },
	{ N_("The log service encountered an error when attempting to read from a log container."), NT_STATUS_LOG_CONTAINER_READ_FAILED },
	{ N_("The log service encountered an error when attempting to write to a log container."), NT_STATUS_LOG_CONTAINER_WRITE_FAILED },
	{ N_("The log service encountered an error when attempting to open a log container."), NT_STATUS_LOG_CONTAINER_OPEN_FAILED },
	{ N_("The log service encountered an invalid container state when attempting a requested action."), NT_STATUS_LOG_CONTAINER_STATE_INVALID },
	{ N_("The log service is not in the correct state to perform a requested action."), NT_STATUS_LOG_STATE_INVALID },
	{ N_("The log space cannot be reclaimed because the log is pinned."), NT_STATUS_LOG_PINNED },
	{ N_("The log metadata flush failed."), NT_STATUS_LOG_METADATA_FLUSH_FAILED },
	{ N_("Security on the log and its containers is inconsistent."), NT_STATUS_LOG_INCONSISTENT_SECURITY },
	{ N_("Records were appended to the log or reservation changes were made, but the log could not be flushed."), NT_STATUS_LOG_APPENDED_FLUSH_FAILED },
	{ N_("The log is pinned due to reservation consuming most of the log space. Free some reserved records to make space available."), NT_STATUS_LOG_PINNED_RESERVATION },
	{ N_("{Display Driver Stopped Responding} The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the computer, a dialog box will allow you to upload data about this failure to Microsoft."), NT_STATUS_VIDEO_HUNG_DISPLAY_DRIVER_THREAD },
	{ N_("A handler was not defined by the filter for this operation."), NT_STATUS_FLT_NO_HANDLER_DEFINED },
	{ N_("A context is already defined for this object."), NT_STATUS_FLT_CONTEXT_ALREADY_DEFINED },
	{ N_("Asynchronous requests are not valid for this operation."), NT_STATUS_FLT_INVALID_ASYNCHRONOUS_REQUEST },
	{ N_("This is an internal error code used by the filter manager to determine if a fast I/O operation should be forced down the input/output request packet (IRP) path. Minifilters should never return this value."), NT_STATUS_FLT_DISALLOW_FAST_IO },
	{ N_("An invalid name request was made. The name requested cannot be retrieved at this time."), NT_STATUS_FLT_INVALID_NAME_REQUEST },
	{ N_("Posting this operation to a worker thread for further processing is not safe at this time because it could lead to a system deadlock."), NT_STATUS_FLT_NOT_SAFE_TO_POST_OPERATION },
	{ N_("The Filter Manager was not initialized when a filter tried to register. Make sure that the Filter Manager is loaded as a driver."), NT_STATUS_FLT_NOT_INITIALIZED },
	{ N_("The filter is not ready for attachment to volumes because it has not finished initializing (FltStartFiltering has not been called)."), NT_STATUS_FLT_FILTER_NOT_READY },
	{ N_("The filter must clean up any operation-specific context at this time because it is being removed from the system before the operation is completed by the lower drivers."), NT_STATUS_FLT_POST_OPERATION_CLEANUP },
	{ N_("The Filter Manager had an internal error from which it cannot recover; therefore, the operation has failed. This is usually the result of a filter returning an invalid value from a pre-operation callback."), NT_STATUS_FLT_INTERNAL_ERROR },
	{ N_("The object specified for this action is in the process of being deleted; therefore, the action requested cannot be completed at this time."), NT_STATUS_FLT_DELETING_OBJECT },
	{ N_("A nonpaged pool must be used for this type of context."), NT_STATUS_FLT_MUST_BE_NONPAGED_POOL },
	{ N_("A duplicate handler definition has been provided for an operation."), NT_STATUS_FLT_DUPLICATE_ENTRY },
	{ N_("The callback data queue has been disabled."), NT_STATUS_FLT_CBDQ_DISABLED },
	{ N_("Do not attach the filter to the volume at this time."), NT_STATUS_FLT_DO_NOT_ATTACH },
	{ N_("Do not detach the filter from the volume at this time."), NT_STATUS_FLT_DO_NOT_DETACH },
	{ N_("An instance already exists at this altitude on the volume specified."), NT_STATUS_FLT_INSTANCE_ALTITUDE_COLLISION },
	{ N_("An instance already exists with this name on the volume specified."), NT_STATUS_FLT_INSTANCE_NAME_COLLISION },
	{ N_("The system could not find the filter specified."), NT_STATUS_FLT_FILTER_NOT_FOUND },
	{ N_("The system could not find the volume specified."), NT_STATUS_FLT_VOLUME_NOT_FOUND },
	{ N_("The system could not find the instance specified."), NT_STATUS_FLT_INSTANCE_NOT_FOUND },
	{ N_("No registered context allocation definition was found for the given request."), NT_STATUS_FLT_CONTEXT_ALLOCATION_NOT_FOUND },
	{ N_("An invalid parameter was specified during context registration."), NT_STATUS_FLT_INVALID_CONTEXT_REGISTRATION },
	{ N_("The name requested was not found in the Filter Manager name cache and could not be retrieved from the file system."), NT_STATUS_FLT_NAME_CACHE_MISS },
	{ N_("The requested device object does not exist for the given volume."), NT_STATUS_FLT_NO_DEVICE_OBJECT },
	{ N_("The specified volume is already mounted."), NT_STATUS_FLT_VOLUME_ALREADY_MOUNTED },
	{ N_("The specified transaction context is already enlisted in a transaction."), NT_STATUS_FLT_ALREADY_ENLISTED },
	{ N_("The specified context is already attached to another object."), NT_STATUS_FLT_CONTEXT_ALREADY_LINKED },
	{ N_("No waiter is present for the filter's reply to this message."), NT_STATUS_FLT_NO_WAITER_FOR_REPLY },
	{ N_("A monitor descriptor could not be obtained."), NT_STATUS_MONITOR_NO_DESCRIPTOR },
	{ N_("This release does not support the format of the obtained monitor descriptor."), NT_STATUS_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT },
	{ N_("The checksum of the obtained monitor descriptor is invalid."), NT_STATUS_MONITOR_INVALID_DESCRIPTOR_CHECKSUM },
	{ N_("The monitor descriptor contains an invalid standard timing block."), NT_STATUS_MONITOR_INVALID_STANDARD_TIMING_BLOCK },
	{ N_("WMI data-block registration failed for one of the MSMonitorClass WMI subclasses."), NT_STATUS_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED },
	{ N_("The provided monitor descriptor block is either corrupted or does not contain the monitor's detailed serial number."), NT_STATUS_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK },
	{ N_("The provided monitor descriptor block is either corrupted or does not contain the monitor's user-friendly name."), NT_STATUS_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK },
	{ N_("There is no monitor descriptor data at the specified (offset or size) region."), NT_STATUS_MONITOR_NO_MORE_DESCRIPTOR_DATA },
	{ N_("The monitor descriptor contains an invalid detailed timing block."), NT_STATUS_MONITOR_INVALID_DETAILED_TIMING_BLOCK },
	{ N_("Monitor descriptor contains invalid manufacture date."), NT_STATUS_MONITOR_INVALID_MANUFACTURE_DATE },
	{ N_("Exclusive mode ownership is needed to create an unmanaged primary allocation."), NT_STATUS_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER },
	{ N_("The driver needs more DMA buffer space to complete the requested operation."), NT_STATUS_GRAPHICS_INSUFFICIENT_DMA_BUFFER },
	{ N_("The specified display adapter handle is invalid."), NT_STATUS_GRAPHICS_INVALID_DISPLAY_ADAPTER },
	{ N_("The specified display adapter and all of its state have been reset."), NT_STATUS_GRAPHICS_ADAPTER_WAS_RESET },
	{ N_("The driver stack does not match the expected driver model."), NT_STATUS_GRAPHICS_INVALID_DRIVER_MODEL },
	{ N_("Present happened but ended up into the changed desktop mode."), NT_STATUS_GRAPHICS_PRESENT_MODE_CHANGED },
	{ N_("Nothing to present due to desktop occlusion."), NT_STATUS_GRAPHICS_PRESENT_OCCLUDED },
	{ N_("Not able to present due to denial of desktop access."), NT_STATUS_GRAPHICS_PRESENT_DENIED },
	{ N_("Not able to present with color conversion."), NT_STATUS_GRAPHICS_CANNOTCOLORCONVERT },
	{ N_("Present redirection is disabled (desktop windowing management subsystem is off)."), NT_STATUS_GRAPHICS_PRESENT_REDIRECTION_DISABLED },
	{ N_("Previous exclusive VidPn source owner has released its ownership"), NT_STATUS_GRAPHICS_PRESENT_UNOCCLUDED },
	{ N_("Not enough video memory is available to complete the operation."), NT_STATUS_GRAPHICS_NO_VIDEO_MEMORY },
	{ N_("Could not probe and lock the underlying memory of an allocation."), NT_STATUS_GRAPHICS_CANT_LOCK_MEMORY },
	{ N_("The allocation is currently busy."), NT_STATUS_GRAPHICS_ALLOCATION_BUSY },
	{ N_("An object being referenced has already reached the maximum reference count and cannot be referenced further."), NT_STATUS_GRAPHICS_TOO_MANY_REFERENCES },
	{ N_("A problem could not be solved due to an existing condition. Try again later."), NT_STATUS_GRAPHICS_TRY_AGAIN_LATER },
	{ N_("A problem could not be solved due to an existing condition. Try again now."), NT_STATUS_GRAPHICS_TRY_AGAIN_NOW },
	{ N_("The allocation is invalid."), NT_STATUS_GRAPHICS_ALLOCATION_INVALID },
	{ N_("No more unswizzling apertures are currently available."), NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE },
	{ N_("The current allocation cannot be unswizzled by an aperture."), NT_STATUS_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED },
	{ N_("The request failed because a pinned allocation cannot be evicted."), NT_STATUS_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION },
	{ N_("The allocation cannot be used from its current segment location for the specified operation."), NT_STATUS_GRAPHICS_INVALID_ALLOCATION_USAGE },
	{ N_("A locked allocation cannot be used in the current command buffer."), NT_STATUS_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION },
	{ N_("The allocation being referenced has been closed permanently."), NT_STATUS_GRAPHICS_ALLOCATION_CLOSED },
	{ N_("An invalid allocation instance is being referenced."), NT_STATUS_GRAPHICS_INVALID_ALLOCATION_INSTANCE },
	{ N_("An invalid allocation handle is being referenced."), NT_STATUS_GRAPHICS_INVALID_ALLOCATION_HANDLE },
	{ N_("The allocation being referenced does not belong to the current device."), NT_STATUS_GRAPHICS_WRONG_ALLOCATION_DEVICE },
	{ N_("The specified allocation lost its content."), NT_STATUS_GRAPHICS_ALLOCATION_CONTENT_LOST },
	{ N_("A GPU exception was detected on the given device. The device cannot be scheduled."), NT_STATUS_GRAPHICS_GPU_EXCEPTION_ON_DEVICE },
	{ N_("The specified VidPN topology is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY },
	{ N_("The specified VidPN topology is valid but is not supported by this model of the display adapter."), NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED },
	{ N_("The specified VidPN topology is valid but is not currently supported by the display adapter due to allocation of its resources."), NT_STATUS_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED },
	{ N_("The specified VidPN handle is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN },
	{ N_("The specified video present source is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE },
	{ N_("The specified video present target is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET },
	{ N_("The specified VidPN modality is not supported (for example, at least two of the pinned modes are not co-functional)."), NT_STATUS_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED },
	{ N_("The specified VidPN source mode set is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN_SOURCEMODESET },
	{ N_("The specified VidPN target mode set is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGETMODESET },
	{ N_("The specified video signal frequency is invalid."), NT_STATUS_GRAPHICS_INVALID_FREQUENCY },
	{ N_("The specified video signal active region is invalid."), NT_STATUS_GRAPHICS_INVALID_ACTIVE_REGION },
	{ N_("The specified video signal total region is invalid."), NT_STATUS_GRAPHICS_INVALID_TOTAL_REGION },
	{ N_("The specified video present source mode is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE },
	{ N_("The specified video present target mode is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE },
	{ N_("The pinned mode must remain in the set on the VidPN's co-functional modality enumeration."), NT_STATUS_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET },
	{ N_("The specified video present path is already in the VidPN's topology."), NT_STATUS_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY },
	{ N_("The specified mode is already in the mode set."), NT_STATUS_GRAPHICS_MODE_ALREADY_IN_MODESET },
	{ N_("The specified video present source set is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET },
	{ N_("The specified video present target set is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET },
	{ N_("The specified video present source is already in the video present source set."), NT_STATUS_GRAPHICS_SOURCE_ALREADY_IN_SET },
	{ N_("The specified video present target is already in the video present target set."), NT_STATUS_GRAPHICS_TARGET_ALREADY_IN_SET },
	{ N_("The specified VidPN present path is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN_PRESENT_PATH },
	{ N_("The miniport has no recommendation for augmenting the specified VidPN's topology."), NT_STATUS_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY },
	{ N_("The specified monitor frequency range set is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET },
	{ N_("The specified monitor frequency range is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE },
	{ N_("The specified frequency range is not in the specified monitor frequency range set."), NT_STATUS_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET },
	{ N_("The specified frequency range is already in the specified monitor frequency range set."), NT_STATUS_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET },
	{ N_("The specified mode set is stale. Reacquire the new mode set."), NT_STATUS_GRAPHICS_STALE_MODESET },
	{ N_("The specified monitor source mode set is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCEMODESET },
	{ N_("The specified monitor source mode is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITOR_SOURCE_MODE },
	{ N_("The miniport does not have a recommendation regarding the request to provide a functional VidPN given the current display adapter configuration."), NT_STATUS_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN },
	{ N_("The ID of the specified mode is being used by another mode in the set."), NT_STATUS_GRAPHICS_MODE_ID_MUST_BE_UNIQUE },
	{ N_("The system failed to determine a mode that is supported by both the display adapter and the monitor connected to it."), NT_STATUS_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION },
	{ N_("The number of video present targets must be greater than or equal to the number of video present sources."), NT_STATUS_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES },
	{ N_("The specified present path is not in the VidPN's topology."), NT_STATUS_GRAPHICS_PATH_NOT_IN_TOPOLOGY },
	{ N_("The display adapter must have at least one video present source."), NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE },
	{ N_("The display adapter must have at least one video present target."), NT_STATUS_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET },
	{ N_("The specified monitor descriptor set is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTORSET },
	{ N_("The specified monitor descriptor is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITORDESCRIPTOR },
	{ N_("The specified descriptor is not in the specified monitor descriptor set."), NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET },
	{ N_("The specified descriptor is already in the specified monitor descriptor set."), NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET },
	{ N_("The ID of the specified monitor descriptor is being used by another descriptor in the set."), NT_STATUS_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE },
	{ N_("The specified video present target subset type is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE },
	{ N_("Two or more of the specified resources are not related to each other, as defined by the interface semantics."), NT_STATUS_GRAPHICS_RESOURCES_NOT_RELATED },
	{ N_("The ID of the specified video present source is being used by another source in the set."), NT_STATUS_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE },
	{ N_("The ID of the specified video present target is being used by another target in the set."), NT_STATUS_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE },
	{ N_("The specified VidPN source cannot be used because there is no available VidPN target to connect it to."), NT_STATUS_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET },
	{ N_("The newly arrived monitor could not be associated with a display adapter."), NT_STATUS_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER },
	{ N_("The particular display adapter does not have an associated VidPN manager."), NT_STATUS_GRAPHICS_NO_VIDPNMGR },
	{ N_("The VidPN manager of the particular display adapter does not have an active VidPN."), NT_STATUS_GRAPHICS_NO_ACTIVE_VIDPN },
	{ N_("The specified VidPN topology is stale; obtain the new topology."), NT_STATUS_GRAPHICS_STALE_VIDPN_TOPOLOGY },
	{ N_("No monitor is connected on the specified video present target."), NT_STATUS_GRAPHICS_MONITOR_NOT_CONNECTED },
	{ N_("The specified source is not part of the specified VidPN's topology."), NT_STATUS_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY },
	{ N_("The specified primary surface size is invalid."), NT_STATUS_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE },
	{ N_("The specified visible region size is invalid."), NT_STATUS_GRAPHICS_INVALID_VISIBLEREGION_SIZE },
	{ N_("The specified stride is invalid."), NT_STATUS_GRAPHICS_INVALID_STRIDE },
	{ N_("The specified pixel format is invalid."), NT_STATUS_GRAPHICS_INVALID_PIXELFORMAT },
	{ N_("The specified color basis is invalid."), NT_STATUS_GRAPHICS_INVALID_COLORBASIS },
	{ N_("The specified pixel value access mode is invalid."), NT_STATUS_GRAPHICS_INVALID_PIXELVALUEACCESSMODE },
	{ N_("The specified target is not part of the specified VidPN's topology."), NT_STATUS_GRAPHICS_TARGET_NOT_IN_TOPOLOGY },
	{ N_("Failed to acquire the display mode management interface."), NT_STATUS_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT },
	{ N_("The specified VidPN source is already owned by a DMM client and cannot be used until that client releases it."), NT_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE },
	{ N_("The specified VidPN is active and cannot be accessed."), NT_STATUS_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN },
	{ N_("The specified VidPN's present path importance ordinal is invalid."), NT_STATUS_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL },
	{ N_("The specified VidPN's present path content geometry transformation is invalid."), NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION },
	{ N_("The specified content geometry transformation is not supported on the respective VidPN present path."), NT_STATUS_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED },
	{ N_("The specified gamma ramp is invalid."), NT_STATUS_GRAPHICS_INVALID_GAMMA_RAMP },
	{ N_("The specified gamma ramp is not supported on the respective VidPN present path."), NT_STATUS_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED },
	{ N_("Multisampling is not supported on the respective VidPN present path."), NT_STATUS_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED },
	{ N_("The specified mode is not in the specified mode set."), NT_STATUS_GRAPHICS_MODE_NOT_IN_MODESET },
	{ N_("The specified VidPN topology recommendation reason is invalid."), NT_STATUS_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON },
	{ N_("The specified VidPN present path content type is invalid."), NT_STATUS_GRAPHICS_INVALID_PATH_CONTENT_TYPE },
	{ N_("The specified VidPN present path copy protection type is invalid."), NT_STATUS_GRAPHICS_INVALID_COPYPROTECTION_TYPE },
	{ N_("Only one unassigned mode set can exist at any one time for a particular VidPN source or target."), NT_STATUS_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS },
	{ N_("The specified scan line ordering type is invalid."), NT_STATUS_GRAPHICS_INVALID_SCANLINE_ORDERING },
	{ N_("The topology changes are not allowed for the specified VidPN."), NT_STATUS_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED },
	{ N_("All available importance ordinals are being used in the specified topology."), NT_STATUS_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS },
	{ N_("The specified primary surface has a different private-format attribute than the current primary surface."), NT_STATUS_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT },
	{ N_("The specified mode-pruning algorithm is invalid."), NT_STATUS_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM },
	{ N_("The specified monitor-capability origin is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN },
	{ N_("The specified monitor-frequency range constraint is invalid."), NT_STATUS_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT },
	{ N_("The maximum supported number of present paths has been reached."), NT_STATUS_GRAPHICS_MAX_NUM_PATHS_REACHED },
	{ N_("The miniport requested that augmentation be canceled for the specified source of the specified VidPN's topology."), NT_STATUS_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION },
	{ N_("The specified client type was not recognized."), NT_STATUS_GRAPHICS_INVALID_CLIENT_TYPE },
	{ N_("The client VidPN is not set on this adapter (for example, no user mode-initiated mode changes have taken place on this adapter)."), NT_STATUS_GRAPHICS_CLIENTVIDPN_NOT_SET },
	{ N_("The specified display adapter child device already has an external device connected to it."), NT_STATUS_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED },
	{ N_("The display adapter child device does not support reporting a descriptor."), NT_STATUS_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED },
	{ N_("The display adapter is not linked to any other adapters."), NT_STATUS_GRAPHICS_NOT_A_LINKED_ADAPTER },
	{ N_("The lead adapter in a linked configuration was not enumerated yet."), NT_STATUS_GRAPHICS_LEADLINK_NOT_ENUMERATED },
	{ N_("Some chain adapters in a linked configuration have not yet been enumerated."), NT_STATUS_GRAPHICS_CHAINLINKS_NOT_ENUMERATED },
	{ N_("The chain of linked adapters is not ready to start because of an unknown failure."), NT_STATUS_GRAPHICS_ADAPTER_CHAIN_NOT_READY },
	{ N_("An attempt was made to start a lead link display adapter when the chain links had not yet started."), NT_STATUS_GRAPHICS_CHAINLINKS_NOT_STARTED },
	{ N_("An attempt was made to turn on a lead link display adapter when the chain links were turned off."), NT_STATUS_GRAPHICS_CHAINLINKS_NOT_POWERED_ON },
	{ N_("The adapter link was found in an inconsistent state. Not all adapters are in an expected PNP/power state."), NT_STATUS_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE },
	{ N_("The driver trying to start is not the same as the driver for the posted display adapter."), NT_STATUS_GRAPHICS_NOT_POST_DEVICE_DRIVER },
	{ N_("An operation is being attempted that requires the display adapter to be in a quiescent state."), NT_STATUS_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED },
	{ N_("The driver does not support OPM."), NT_STATUS_GRAPHICS_OPM_NOT_SUPPORTED },
	{ N_("The driver does not support COPP."), NT_STATUS_GRAPHICS_COPP_NOT_SUPPORTED },
	{ N_("The driver does not support UAB."), NT_STATUS_GRAPHICS_UAB_NOT_SUPPORTED },
	{ N_("The specified encrypted parameters are invalid."), NT_STATUS_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS },
	{ N_("An array passed to a function cannot hold all of the data that the function wants to put in it."), NT_STATUS_GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL },
	{ N_("The GDI display device passed to this function does not have any active protected outputs."), NT_STATUS_GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST },
	{ N_("The PVP cannot find an actual GDI display device that corresponds to the passed-in GDI display device name."), NT_STATUS_GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME },
	{ N_("This function failed because the GDI display device passed to it was not attached to the Windows desktop."), NT_STATUS_GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP },
	{ N_("The PVP does not support mirroring display devices because they do not have any protected outputs."), NT_STATUS_GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED },
	{ N_("The function failed because an invalid pointer parameter was passed to it. A pointer parameter is invalid if it is null, is not correctly aligned, or it points to an invalid address or a kernel mode address."), NT_STATUS_GRAPHICS_OPM_INVALID_POINTER },
	{ N_("An internal error caused an operation to fail."), NT_STATUS_GRAPHICS_OPM_INTERNAL_ERROR },
	{ N_("The function failed because the caller passed in an invalid OPM user-mode handle."), NT_STATUS_GRAPHICS_OPM_INVALID_HANDLE },
	{ N_("This function failed because the GDI device passed to it did not have any monitors associated with it."), NT_STATUS_GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE },
	{ N_("A certificate could not be returned because the certificate buffer passed to the function was too small."), NT_STATUS_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH },
	{ N_("DxgkDdiOpmCreateProtectedOutput() could not create a protected output because the video present yarget is in spanning mode."), NT_STATUS_GRAPHICS_OPM_SPANNING_MODE_ENABLED },
	{ N_("DxgkDdiOpmCreateProtectedOutput() could not create a protected output because the video present target is in theater mode."), NT_STATUS_GRAPHICS_OPM_THEATER_MODE_ENABLED },
	{ N_("The function call failed because the display adapter's hardware functionality scan (HFS) failed to validate the graphics hardware."), NT_STATUS_GRAPHICS_PVP_HFS_FAILED },
	{ N_("The HDCP SRM passed to this function did not comply with section 5 of the HDCP 1.1 specification."), NT_STATUS_GRAPHICS_OPM_INVALID_SRM },
	{ N_("The protected output cannot enable the HDCP system because it does not support it."), NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP },
	{ N_("The protected output cannot enable analog copy protection because it does not support it."), NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP },
	{ N_("The protected output cannot enable the CGMS-A protection technology because it does not support it."), NT_STATUS_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA },
	{ N_("DxgkDdiOPMGetInformation() cannot return the version of the SRM being used because the application never successfully passed an SRM to the protected output."), NT_STATUS_GRAPHICS_OPM_HDCP_SRM_NEVER_SET },
	{ N_("DxgkDdiOPMConfigureProtectedOutput() cannot enable the specified output protection technology because the output's screen resolution is too high."), NT_STATUS_GRAPHICS_OPM_RESOLUTION_TOO_HIGH },
	{ N_("DxgkDdiOPMConfigureProtectedOutput() cannot enable HDCP because other physical outputs are using the display adapter's HDCP hardware."), NT_STATUS_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE },
	{ N_("The operating system asynchronously destroyed this OPM-protected output because the operating system state changed. This error typically occurs because the monitor PDO associated with this protected output was removed or stopped, the protected output's session became a nonconsole session, or the protected output's desktop became inactive."), NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS },
	{ N_("OPM functions cannot be called when a session is changing its type. Three types of sessions currently exist: console, disconnected, and remote (RDP or ICA)."), NT_STATUS_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS },
	{ N_("The DxgkDdiOPMGetCOPPCompatibleInformation, DxgkDdiOPMGetInformation, or DxgkDdiOPMConfigureProtectedOutput function failed. This error is returned only if a protected output has OPM semantics. DxgkDdiOPMGetCOPPCompatibleInformation always returns this error if a protected output has OPM semantics. DxgkDdiOPMGetInformation returns this error code if the caller requested COPP-specific information. DxgkDdiOPMConfigureProtectedOutput returns this error when the caller tries to use a COPP-specific command."), NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS },
	{ N_("The DxgkDdiOPMGetInformation and DxgkDdiOPMGetCOPPCompatibleInformation functions return this error code if the passed-in sequence number is not the expected sequence number or the passed-in OMAC value is invalid."), NT_STATUS_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST },
	{ N_("The function failed because an unexpected error occurred inside a display driver."), NT_STATUS_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR },
	{ N_("The DxgkDdiOPMGetCOPPCompatibleInformation, DxgkDdiOPMGetInformation, or DxgkDdiOPMConfigureProtectedOutput function failed. This error is returned only if a protected output has COPP semantics. DxgkDdiOPMGetCOPPCompatibleInformation returns this error code if the caller requested OPM-specific information. DxgkDdiOPMGetInformation always returns this error if a protected output has COPP semantics. DxgkDdiOPMConfigureProtectedOutput returns this error when the caller tries to use an OPM-specific command."), NT_STATUS_GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS },
	{ N_("The DxgkDdiOPMGetCOPPCompatibleInformation and DxgkDdiOPMConfigureProtectedOutput functions return this error if the display driver does not support the DXGKMDT_OPM_GET_ACP_AND_CGMSA_SIGNALING and DXGKMDT_OPM_SET_ACP_AND_CGMSA_SIGNALING GUIDs."), NT_STATUS_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED },
	{ N_("The DxgkDdiOPMConfigureProtectedOutput function returns this error code if the passed-in sequence number is not the expected sequence number or the passed-in OMAC value is invalid."), NT_STATUS_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST },
	{ N_("The monitor connected to the specified video output does not have an I2C bus."), NT_STATUS_GRAPHICS_I2C_NOT_SUPPORTED },
	{ N_("No device on the I2C bus has the specified address."), NT_STATUS_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST },
	{ N_("An error occurred while transmitting data to the device on the I2C bus."), NT_STATUS_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA },
	{ N_("An error occurred while receiving data from the device on the I2C bus."), NT_STATUS_GRAPHICS_I2C_ERROR_RECEIVING_DATA },
	{ N_("The monitor does not support the specified VCP code."), NT_STATUS_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED },
	{ N_("The data received from the monitor is invalid."), NT_STATUS_GRAPHICS_DDCCI_INVALID_DATA },
	{ N_("A function call failed because a monitor returned an invalid timing status byte when the operating system used the DDC/CI get timing report and timing message command to get a timing report from a monitor."), NT_STATUS_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE },
	{ N_("A monitor returned a DDC/CI capabilities string that did not comply with the ACCESS.bus 3.0, DDC/CI 1.1, or MCCS 2 Revision 1 specification."), NT_STATUS_GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING },
	{ N_("An internal error caused an operation to fail."), NT_STATUS_GRAPHICS_MCA_INTERNAL_ERROR },
	{ N_("An operation failed because a DDC/CI message had an invalid value in its command field."), NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND },
	{ N_("This error occurred because a DDC/CI message had an invalid value in its length field."), NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH },
	{ N_("This error occurred because the value in a DDC/CI message's checksum field did not match the message's computed checksum value. This error implies that the data was corrupted while it was being transmitted from a monitor to a computer."), NT_STATUS_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM },
	{ N_("This function failed because an invalid monitor handle was passed to it."), NT_STATUS_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE },
	{ N_("The operating system asynchronously destroyed the monitor that corresponds to this handle because the operating system's state changed. This error typically occurs because the monitor PDO associated with this handle was removed or stopped, or a display mode change occurred. A display mode change occurs when Windows sends a WM_DISPLAYCHANGE message to applications."), NT_STATUS_GRAPHICS_MONITOR_NO_LONGER_EXISTS },
	{ N_("This function can be used only if a program is running in the local console session. It cannot be used if a program is running on a remote desktop session or on a terminal server session."), NT_STATUS_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED },
	{ N_("This function cannot find an actual GDI display device that corresponds to the specified GDI display device name."), NT_STATUS_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME },
	{ N_("The function failed because the specified GDI display device was not attached to the Windows desktop."), NT_STATUS_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP },
	{ N_("This function does not support GDI mirroring display devices because GDI mirroring display devices do not have any physical monitors associated with them."), NT_STATUS_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED },
	{ N_("The function failed because an invalid pointer parameter was passed to it. A pointer parameter is invalid if it is null, is not correctly aligned, or points to an invalid address or to a kernel mode address."), NT_STATUS_GRAPHICS_INVALID_POINTER },
	{ N_("This function failed because the GDI device passed to it did not have a monitor associated with it."), NT_STATUS_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE },
	{ N_("An array passed to the function cannot hold all of the data that the function must copy into the array."), NT_STATUS_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL },
	{ N_("An internal error caused an operation to fail."), NT_STATUS_GRAPHICS_INTERNAL_ERROR },
	{ N_("The function failed because the current session is changing its type. This function cannot be called when the current session is changing its type. Three types of sessions currently exist: console, disconnected, and remote (RDP or ICA)."), NT_STATUS_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS },
	{ N_("The volume must be unlocked before it can be used."), NT_STATUS_FVE_LOCKED_VOLUME },
	{ N_("The volume is fully decrypted and no key is available."), NT_STATUS_FVE_NOT_ENCRYPTED },
	{ N_("The control block for the encrypted volume is not valid."), NT_STATUS_FVE_BAD_INFORMATION },
	{ N_("Not enough free space remains on the volume to allow encryption."), NT_STATUS_FVE_TOO_SMALL },
	{ N_("The partition cannot be encrypted because the file system is not supported."), NT_STATUS_FVE_FAILED_WRONG_FS },
	{ N_("The file system is inconsistent. Run the Check Disk utility."), NT_STATUS_FVE_FAILED_BAD_FS },
	{ N_("The file system does not extend to the end of the volume."), NT_STATUS_FVE_FS_NOT_EXTENDED },
	{ N_("This operation cannot be performed while a file system is mounted on the volume."), NT_STATUS_FVE_FS_MOUNTED },
	{ N_("BitLocker Drive Encryption is not included with this version of Windows."), NT_STATUS_FVE_NO_LICENSE },
	{ N_("The requested action was denied by the FVE control engine."), NT_STATUS_FVE_ACTION_NOT_ALLOWED },
	{ N_("The data supplied is malformed."), NT_STATUS_FVE_BAD_DATA },
	{ N_("The volume is not bound to the system."), NT_STATUS_FVE_VOLUME_NOT_BOUND },
	{ N_("The volume specified is not a data volume."), NT_STATUS_FVE_NOT_DATA_VOLUME },
	{ N_("A read operation failed while converting the volume."), NT_STATUS_FVE_CONV_READ_ERROR },
	{ N_("A write operation failed while converting the volume."), NT_STATUS_FVE_CONV_WRITE_ERROR },
	{ N_("The control block for the encrypted volume was updated by another thread. Try again."), NT_STATUS_FVE_OVERLAPPED_UPDATE },
	{ N_("The volume encryption algorithm cannot be used on this sector size."), NT_STATUS_FVE_FAILED_SECTOR_SIZE },
	{ N_("BitLocker recovery authentication failed."), NT_STATUS_FVE_FAILED_AUTHENTICATION },
	{ N_("The volume specified is not the boot operating system volume."), NT_STATUS_FVE_NOT_OS_VOLUME },
	{ N_("The BitLocker startup key or recovery password could not be read from external media."), NT_STATUS_FVE_KEYFILE_NOT_FOUND },
	{ N_("The BitLocker startup key or recovery password file is corrupt or invalid."), NT_STATUS_FVE_KEYFILE_INVALID },
	{ N_("The BitLocker encryption key could not be obtained from the startup key or the recovery password."), NT_STATUS_FVE_KEYFILE_NO_VMK },
	{ N_("The TPM is disabled."), NT_STATUS_FVE_TPM_DISABLED },
	{ N_("The authorization data for the SRK of the TPM is not zero."), NT_STATUS_FVE_TPM_SRK_AUTH_NOT_ZERO },
	{ N_("The system boot information changed or the TPM locked out access to BitLocker encryption keys until the computer is restarted."), NT_STATUS_FVE_TPM_INVALID_PCR },
	{ N_("The BitLocker encryption key could not be obtained from the TPM."), NT_STATUS_FVE_TPM_NO_VMK },
	{ N_("The BitLocker encryption key could not be obtained from the TPM and PIN."), NT_STATUS_FVE_PIN_INVALID },
	{ N_("A boot application hash does not match the hash computed when BitLocker was turned on."), NT_STATUS_FVE_AUTH_INVALID_APPLICATION },
	{ N_("The Boot Configuration Data (BCD) settings are not supported or have changed because BitLocker was enabled."), NT_STATUS_FVE_AUTH_INVALID_CONFIG },
	{ N_("Boot debugging is enabled. Run Windows Boot Configuration Data Store Editor (bcdedit.exe) to turn it off."), NT_STATUS_FVE_DEBUGGER_ENABLED },
	{ N_("The BitLocker encryption key could not be obtained."), NT_STATUS_FVE_DRY_RUN_FAILED },
	{ N_("The metadata disk region pointer is incorrect."), NT_STATUS_FVE_BAD_METADATA_POINTER },
	{ N_("The backup copy of the metadata is out of date."), NT_STATUS_FVE_OLD_METADATA_COPY },
	{ N_("No action was taken because a system restart is required."), NT_STATUS_FVE_REBOOT_REQUIRED },
	{ N_("No action was taken because BitLocker Drive Encryption is in RAW access mode."), NT_STATUS_FVE_RAW_ACCESS },
	{ N_("BitLocker Drive Encryption cannot enter RAW access mode for this volume."), NT_STATUS_FVE_RAW_BLOCKED },
	{ N_("This feature of BitLocker Drive Encryption is not included with this version of Windows."), NT_STATUS_FVE_NO_FEATURE_LICENSE },
	{ N_("Group policy does not permit turning off BitLocker Drive Encryption on roaming data volumes."), NT_STATUS_FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED },
	{ N_("Bitlocker Drive Encryption failed to recover from aborted conversion. This could be due to either all conversion logs being corrupted or the media being write-protected."), NT_STATUS_FVE_CONV_RECOVERY_FAILED },
	{ N_("The requested virtualization size is too big."), NT_STATUS_FVE_VIRTUALIZED_SPACE_TOO_BIG },
	{ N_("The drive is too small to be protected using BitLocker Drive Encryption."), NT_STATUS_FVE_VOLUME_TOO_SMALL },
	{ N_("The callout does not exist."), NT_STATUS_FWP_CALLOUT_NOT_FOUND },
	{ N_("The filter condition does not exist."), NT_STATUS_FWP_CONDITION_NOT_FOUND },
	{ N_("The filter does not exist."), NT_STATUS_FWP_FILTER_NOT_FOUND },
	{ N_("The layer does not exist."), NT_STATUS_FWP_LAYER_NOT_FOUND },
	{ N_("The provider does not exist."), NT_STATUS_FWP_PROVIDER_NOT_FOUND },
	{ N_("The provider context does not exist."), NT_STATUS_FWP_PROVIDER_CONTEXT_NOT_FOUND },
	{ N_("The sublayer does not exist."), NT_STATUS_FWP_SUBLAYER_NOT_FOUND },
	{ N_("The object does not exist."), NT_STATUS_FWP_NOT_FOUND },
	{ N_("An object with that GUID or LUID already exists."), NT_STATUS_FWP_ALREADY_EXISTS },
	{ N_("The object is referenced by other objects and cannot be deleted."), NT_STATUS_FWP_IN_USE },
	{ N_("The call is not allowed from within a dynamic session."), NT_STATUS_FWP_DYNAMIC_SESSION_IN_PROGRESS },
	{ N_("The call was made from the wrong session and cannot be completed."), NT_STATUS_FWP_WRONG_SESSION },
	{ N_("The call must be made from within an explicit transaction."), NT_STATUS_FWP_NO_TXN_IN_PROGRESS },
	{ N_("The call is not allowed from within an explicit transaction."), NT_STATUS_FWP_TXN_IN_PROGRESS },
	{ N_("The explicit transaction has been forcibly canceled."), NT_STATUS_FWP_TXN_ABORTED },
	{ N_("The session has been canceled."), NT_STATUS_FWP_SESSION_ABORTED },
	{ N_("The call is not allowed from within a read-only transaction."), NT_STATUS_FWP_INCOMPATIBLE_TXN },
	{ N_("The call timed out while waiting to acquire the transaction lock."), NT_STATUS_FWP_TIMEOUT },
	{ N_("The collection of network diagnostic events is disabled."), NT_STATUS_FWP_NET_EVENTS_DISABLED },
	{ N_("The operation is not supported by the specified layer."), NT_STATUS_FWP_INCOMPATIBLE_LAYER },
	{ N_("The call is allowed for kernel-mode callers only."), NT_STATUS_FWP_KM_CLIENTS_ONLY },
	{ N_("The call tried to associate two objects with incompatible lifetimes."), NT_STATUS_FWP_LIFETIME_MISMATCH },
	{ N_("The object is built-in and cannot be deleted."), NT_STATUS_FWP_BUILTIN_OBJECT },
	{ N_("The maximum number of boot-time filters has been reached."), NT_STATUS_FWP_TOO_MANY_BOOTTIME_FILTERS },
	{ N_("The maximum number of callouts has been reached."), NT_STATUS_FWP_TOO_MANY_CALLOUTS },
	{ N_("A notification could not be delivered because a message queue has reached maximum capacity."), NT_STATUS_FWP_NOTIFICATION_DROPPED },
	{ N_("The traffic parameters do not match those for the security association context."), NT_STATUS_FWP_TRAFFIC_MISMATCH },
	{ N_("The call is not allowed for the current security association state."), NT_STATUS_FWP_INCOMPATIBLE_SA_STATE },
	{ N_("A required pointer is null."), NT_STATUS_FWP_NULL_POINTER },
	{ N_("An enumerator is not valid."), NT_STATUS_FWP_INVALID_ENUMERATOR },
	{ N_("The flags field contains an invalid value."), NT_STATUS_FWP_INVALID_FLAGS },
	{ N_("A network mask is not valid."), NT_STATUS_FWP_INVALID_NET_MASK },
	{ N_("An FWP_RANGE is not valid."), NT_STATUS_FWP_INVALID_RANGE },
	{ N_("The time interval is not valid."), NT_STATUS_FWP_INVALID_INTERVAL },
	{ N_("An array that must contain at least one element has a zero length."), NT_STATUS_FWP_ZERO_LENGTH_ARRAY },
	{ N_("The displayData.name field cannot be null."), NT_STATUS_FWP_NULL_DISPLAY_NAME },
	{ N_("The action type is not one of the allowed action types for a filter."), NT_STATUS_FWP_INVALID_ACTION_TYPE },
	{ N_("The filter weight is not valid."), NT_STATUS_FWP_INVALID_WEIGHT },
	{ N_("A filter condition contains a match type that is not compatible with the operands."), NT_STATUS_FWP_MATCH_TYPE_MISMATCH },
	{ N_("An FWP_VALUE or FWPM_CONDITION_VALUE is of the wrong type."), NT_STATUS_FWP_TYPE_MISMATCH },
	{ N_("An integer value is outside the allowed range."), NT_STATUS_FWP_OUT_OF_BOUNDS },
	{ N_("A reserved field is nonzero."), NT_STATUS_FWP_RESERVED },
	{ N_("A filter cannot contain multiple conditions operating on a single field."), NT_STATUS_FWP_DUPLICATE_CONDITION },
	{ N_("A policy cannot contain the same keying module more than once."), NT_STATUS_FWP_DUPLICATE_KEYMOD },
	{ N_("The action type is not compatible with the layer."), NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_LAYER },
	{ N_("The action type is not compatible with the sublayer."), NT_STATUS_FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER },
	{ N_("The raw context or the provider context is not compatible with the layer."), NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER },
	{ N_("The raw context or the provider context is not compatible with the callout."), NT_STATUS_FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT },
	{ N_("The authentication method is not compatible with the policy type."), NT_STATUS_FWP_INCOMPATIBLE_AUTH_METHOD },
	{ N_("The Diffie-Hellman group is not compatible with the policy type."), NT_STATUS_FWP_INCOMPATIBLE_DH_GROUP },
	{ N_("An IKE policy cannot contain an Extended Mode policy."), NT_STATUS_FWP_EM_NOT_SUPPORTED },
	{ N_("The enumeration template or subscription will never match any objects."), NT_STATUS_FWP_NEVER_MATCH },
	{ N_("The provider context is of the wrong type."), NT_STATUS_FWP_PROVIDER_CONTEXT_MISMATCH },
	{ N_("The parameter is incorrect."), NT_STATUS_FWP_INVALID_PARAMETER },
	{ N_("The maximum number of sublayers has been reached."), NT_STATUS_FWP_TOO_MANY_SUBLAYERS },
	{ N_("The notification function for a callout returned an error."), NT_STATUS_FWP_CALLOUT_NOTIFICATION_FAILED },
	{ N_("The IPsec authentication configuration is not compatible with the authentication type."), NT_STATUS_FWP_INCOMPATIBLE_AUTH_CONFIG },
	{ N_("The IPsec cipher configuration is not compatible with the cipher type."), NT_STATUS_FWP_INCOMPATIBLE_CIPHER_CONFIG },
	{ N_("A policy cannot contain the same auth method more than once."), NT_STATUS_FWP_DUPLICATE_AUTH_METHOD },
	{ N_("The TCP/IP stack is not ready."), NT_STATUS_FWP_TCPIP_NOT_READY },
	{ N_("The injection handle is being closed by another thread."), NT_STATUS_FWP_INJECT_HANDLE_CLOSING },
	{ N_("The injection handle is stale."), NT_STATUS_FWP_INJECT_HANDLE_STALE },
	{ N_("The classify cannot be pended."), NT_STATUS_FWP_CANNOT_PEND },
	{ N_("The binding to the network interface is being closed."), NT_STATUS_NDIS_CLOSING },
	{ N_("An invalid version was specified."), NT_STATUS_NDIS_BAD_VERSION },
	{ N_("An invalid characteristics table was used."), NT_STATUS_NDIS_BAD_CHARACTERISTICS },
	{ N_("Failed to find the network interface or the network interface is not ready."), NT_STATUS_NDIS_ADAPTER_NOT_FOUND },
	{ N_("Failed to open the network interface."), NT_STATUS_NDIS_OPEN_FAILED },
	{ N_("The network interface has encountered an internal unrecoverable failure."), NT_STATUS_NDIS_DEVICE_FAILED },
	{ N_("The multicast list on the network interface is full."), NT_STATUS_NDIS_MULTICAST_FULL },
	{ N_("An attempt was made to add a duplicate multicast address to the list."), NT_STATUS_NDIS_MULTICAST_EXISTS },
	{ N_("At attempt was made to remove a multicast address that was never added."), NT_STATUS_NDIS_MULTICAST_NOT_FOUND },
	{ N_("The network interface aborted the request."), NT_STATUS_NDIS_REQUEST_ABORTED },
	{ N_("The network interface cannot process the request because it is being reset."), NT_STATUS_NDIS_RESET_IN_PROGRESS },
	{ N_("An attempt was made to send an invalid packet on a network interface."), NT_STATUS_NDIS_INVALID_PACKET },
	{ N_("The specified request is not a valid operation for the target device."), NT_STATUS_NDIS_INVALID_DEVICE_REQUEST },
	{ N_("The network interface is not ready to complete this operation."), NT_STATUS_NDIS_ADAPTER_NOT_READY },
	{ N_("The length of the buffer submitted for this operation is not valid."), NT_STATUS_NDIS_INVALID_LENGTH },
	{ N_("The data used for this operation is not valid."), NT_STATUS_NDIS_INVALID_DATA },
	{ N_("The length of the submitted buffer for this operation is too small."), NT_STATUS_NDIS_BUFFER_TOO_SHORT },
	{ N_("The network interface does not support this object identifier."), NT_STATUS_NDIS_INVALID_OID },
	{ N_("The network interface has been removed."), NT_STATUS_NDIS_ADAPTER_REMOVED },
	{ N_("The network interface does not support this media type."), NT_STATUS_NDIS_UNSUPPORTED_MEDIA },
	{ N_("An attempt was made to remove a token ring group address that is in use by other components."), NT_STATUS_NDIS_GROUP_ADDRESS_IN_USE },
	{ N_("An attempt was made to map a file that cannot be found."), NT_STATUS_NDIS_FILE_NOT_FOUND },
	{ N_("An error occurred while NDIS tried to map the file."), NT_STATUS_NDIS_ERROR_READING_FILE },
	{ N_("An attempt was made to map a file that is already mapped."), NT_STATUS_NDIS_ALREADY_MAPPED },
	{ N_("An attempt to allocate a hardware resource failed because the resource is used by another component."), NT_STATUS_NDIS_RESOURCE_CONFLICT },
	{ N_("The I/O operation failed because the network media is disconnected or the wireless access point is out of range."), NT_STATUS_NDIS_MEDIA_DISCONNECTED },
	{ N_("The network address used in the request is invalid."), NT_STATUS_NDIS_INVALID_ADDRESS },
	{ N_("The offload operation on the network interface has been paused."), NT_STATUS_NDIS_PAUSED },
	{ N_("The network interface was not found."), NT_STATUS_NDIS_INTERFACE_NOT_FOUND },
	{ N_("The revision number specified in the structure is not supported."), NT_STATUS_NDIS_UNSUPPORTED_REVISION },
	{ N_("The specified port does not exist on this network interface."), NT_STATUS_NDIS_INVALID_PORT },
	{ N_("The current state of the specified port on this network interface does not support the requested operation."), NT_STATUS_NDIS_INVALID_PORT_STATE },
	{ N_("The miniport adapter is in a lower power state."), NT_STATUS_NDIS_LOW_POWER_STATE },
	{ N_("The network interface does not support this request."), NT_STATUS_NDIS_NOT_SUPPORTED },
	{ N_("The TCP connection is not offloadable because of a local policy setting."), NT_STATUS_NDIS_OFFLOAD_POLICY },
	{ N_("The TCP connection is not offloadable by the Chimney offload target."), NT_STATUS_NDIS_OFFLOAD_CONNECTION_REJECTED },
	{ N_("The IP Path object is not in an offloadable state."), NT_STATUS_NDIS_OFFLOAD_PATH_REJECTED },
	{ N_("The wireless LAN interface is in auto-configuration mode and does not support the requested parameter change operation."), NT_STATUS_NDIS_DOT11_AUTO_CONFIG_ENABLED },
	{ N_("The wireless LAN interface is busy and cannot perform the requested operation."), NT_STATUS_NDIS_DOT11_MEDIA_IN_USE },
	{ N_("The wireless LAN interface is power down and does not support the requested operation."), NT_STATUS_NDIS_DOT11_POWER_STATE_INVALID },
	{ N_("The list of wake on LAN patterns is full."), NT_STATUS_NDIS_PM_WOL_PATTERN_LIST_FULL },
	{ N_("The list of low power protocol offloads is full."), NT_STATUS_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL },
	{ N_("The SPI in the packet does not match a valid IPsec SA."), NT_STATUS_IPSEC_BAD_SPI },
	{ N_("The packet was received on an IPsec SA whose lifetime has expired."), NT_STATUS_IPSEC_SA_LIFETIME_EXPIRED },
	{ N_("The packet was received on an IPsec SA that does not match the packet characteristics."), NT_STATUS_IPSEC_WRONG_SA },
	{ N_("The packet sequence number replay check failed."), NT_STATUS_IPSEC_REPLAY_CHECK_FAILED },
	{ N_("The IPsec header and/or trailer in the packet is invalid."), NT_STATUS_IPSEC_INVALID_PACKET },
	{ N_("The IPsec integrity check failed."), NT_STATUS_IPSEC_INTEGRITY_CHECK_FAILED },
	{ N_("IPsec dropped a clear text packet."), NT_STATUS_IPSEC_CLEAR_TEXT_DROP },
	{ N_("IPsec dropped an incoming ESP packet in authenticated firewall mode. This drop is benign."), NT_STATUS_IPSEC_AUTH_FIREWALL_DROP },
	{ N_("IPsec dropped a packet due to DOS throttle."), NT_STATUS_IPSEC_THROTTLE_DROP },
	{ N_("IPsec Dos Protection matched an explicit block rule."), NT_STATUS_IPSEC_DOSP_BLOCK },
	{ N_("IPsec Dos Protection received an IPsec specific multicast packet which is not allowed."), NT_STATUS_IPSEC_DOSP_RECEIVED_MULTICAST },
	{ N_("IPsec Dos Protection received an incorrectly formatted packet."), NT_STATUS_IPSEC_DOSP_INVALID_PACKET },
	{ N_("IPsec Dos Protection failed to lookup state."), NT_STATUS_IPSEC_DOSP_STATE_LOOKUP_FAILED },
	{ N_("IPsec Dos Protection failed to create state because there are already maximum number of entries allowed by policy."), NT_STATUS_IPSEC_DOSP_MAX_ENTRIES },
	{ N_("IPsec Dos Protection received an IPsec negotiation packet for a keying module which is not allowed by policy."), NT_STATUS_IPSEC_DOSP_KEYMOD_NOT_ALLOWED },
	{ N_("IPsec Dos Protection failed to create per internal IP ratelimit queue because there is already maximum number of queues allowed by policy."), NT_STATUS_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES },
	{ N_("The system does not support mirrored volumes."), NT_STATUS_VOLMGR_MIRROR_NOT_SUPPORTED },
	{ N_("The system does not support RAID-5 volumes."), NT_STATUS_VOLMGR_RAID5_NOT_SUPPORTED },
	{ N_("A virtual disk support provider for the specified file was not found."), NT_STATUS_VIRTDISK_PROVIDER_NOT_FOUND },
	{ N_("The specified disk is not a virtual disk."), NT_STATUS_VIRTDISK_NOT_VIRTUAL_DISK },
	{ N_("The chain of virtual hard disks is inaccessible. The process has not been granted access rights to the parent virtual hard disk for the differencing disk."), NT_STATUS_VHD_PARENT_VHD_ACCESS_DENIED },
	{ N_("The chain of virtual hard disks is corrupted. There is a mismatch in the virtual sizes of the parent virtual hard disk and differencing disk."), NT_STATUS_VHD_CHILD_PARENT_SIZE_MISMATCH },
	{ N_("The chain of virtual hard disks is corrupted. A differencing disk is indicated in its own parent chain."), NT_STATUS_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED },
	{ N_("The chain of virtual hard disks is inaccessible. There was an error opening a virtual hard disk further up the chain."), NT_STATUS_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT },
	{ NULL, NT_STATUS(0) }
};

/*****************************************************************************
 Returns an NT_STATUS constant as a string for inclusion in autogen C code.
 *****************************************************************************/

const char *get_nt_error_c_code(TALLOC_CTX *mem_ctx, NTSTATUS nt_code)
{
	char *result;
	int idx = 0;

	while (nt_errs[idx].nt_errstr != NULL) {
		if (NT_STATUS_V(nt_errs[idx].nt_errcode) ==
		    NT_STATUS_V(nt_code)) {
			result = talloc_strdup(mem_ctx, nt_errs[idx].nt_errstr);
			return result;
		}
		idx++;
	}

	result = talloc_asprintf(mem_ctx, "NT_STATUS(0x%08x)",
				 NT_STATUS_V(nt_code));
	return result;
}

/*****************************************************************************
 Returns the NT_STATUS constant matching the string supplied (as an NTSTATUS)
 *****************************************************************************/

NTSTATUS nt_status_string_to_code(const char *nt_status_str)
{
	int idx = 0;

	while (nt_errs[idx].nt_errstr != NULL) {
		if (strcasecmp(nt_errs[idx].nt_errstr, nt_status_str) == 0) {
			return nt_errs[idx].nt_errcode;
		}
		idx++;
	}
	return NT_STATUS_UNSUCCESSFUL;
}

/**
 * Squash an NT_STATUS in line with security requirements.
 * In an attempt to avoid giving the whole game away when users
 * are authenticating, NT replaces both NT_STATUS_NO_SUCH_USER and
 * NT_STATUS_WRONG_PASSWORD with NT_STATUS_LOGON_FAILURE in certain situations
 * (session setups in particular).
 *
 * @param nt_status NTSTATUS input for squashing.
 * @return the 'squashed' nt_status
 **/

NTSTATUS nt_status_squash(NTSTATUS nt_status)
{
	if NT_STATUS_IS_OK(nt_status) {
		return nt_status;
	} else if NT_STATUS_EQUAL(nt_status, NT_STATUS_NO_SUCH_USER) {
		/* Match WinXP and don't give the game away */
		return NT_STATUS_LOGON_FAILURE;

	} else if NT_STATUS_EQUAL(nt_status, NT_STATUS_WRONG_PASSWORD) {
		/* Match WinXP and don't give the game away */
		return NT_STATUS_LOGON_FAILURE;
	} else {
		return nt_status;
	}
}

/*****************************************************************************
 Returns an NT error message.  not amazingly helpful, but better than a number.
 *****************************************************************************/

const char *nt_errstr(NTSTATUS nt_code)
{
	static char msg[20];
	int idx = 0;

	while (nt_errs[idx].nt_errstr != NULL) {
		if (NT_STATUS_V(nt_errs[idx].nt_errcode) ==
		    NT_STATUS_V(nt_code)) {
			return nt_errs[idx].nt_errstr;
		}
		idx++;
	}

	/*
	 * This should not really happen, we should have all error codes
	 * available. We have a problem that this might get wrongly
	 * overwritten by later calls in the same DEBUG statement.
	 */

	snprintf(msg, sizeof(msg), "NT code 0x%08x", NT_STATUS_V(nt_code));
	return msg;
}

/************************************************************************
 Print friendler version fo NT error code
 ***********************************************************************/

const char *get_friendly_nt_error_msg(NTSTATUS nt_code)
{
	int idx = 0;

	while (nt_err_desc[idx].nt_errstr != NULL) {
		if (NT_STATUS_V(nt_err_desc[idx].nt_errcode) == NT_STATUS_V(nt_code)) {
			return nt_err_desc[idx].nt_errstr;
		}
		idx++;
	}

	/* fall back to NT_STATUS_XXX string */

	return nt_errstr(nt_code);
}
