define(function (require, exports, module) {/*
map
 - must be instantiated
*/"use strict"

var prime = require("./index"),
    array = require("./es5/array")

// set, get, count, each, map, filter, some, every, index, remove, keys, values

var Map = prime({

    constructor: function(){
        if (!this || this.constructor !== Map) return new Map
        this.length = 0
        this._values = []
        this._keys = []
    },

    set: function(key, value){
        var index = array.indexOf(this._keys, key)

        if (index === -1){
            this._keys.push(key)
            this._values.push(value)
            this.length++
        } else {
            this._values[index] = value
        }

        return this
    },

    get: function(key){
        var index = array.indexOf(this._keys, key)
        return (index === -1) ? null : this._values[index]
    },

    count: function(){
        return this.length
    },

    each: function(method, context){
        for (var i = 0, l = this.length; i < l; i++){
            if (method.call(context, this._values[i], this._keys[i], this) === false) break
        }
        return this
    },

    backwards: function(method, context){
        for (var i = this.length - 1; i >= 0; i--){
            if (method.call(context, this._values[i], this._keys[i], this) === false) break
        }
        return this
    },

    map: function(method, context){
        var results = new Map
        this.each(function(value, key){
            results.set(key, method.call(context, value, key, this))
        }, this)
        return results
    },

    filter: function(method, context){
        var results = new Map
        this.each(function(value, key){
            if (method.call(context, value, key, this)) results.set(key, value)
        }, this)
        return results
    },

    every: function(method, context){
        var every = true
        this.each(function(value, key){
            if (!method.call(context, value, key, this)) return (every = false)
        }, this)
        return every
    },

    some: function(method, context){
        var some = false
        this.each(function(value, key){
            if (method.call(context, value, key, this)) return !(some = true)
        }, this)
        return some
    },

    index: function(value){
        var index = array.indexOf(this._values, value)
        return (index > -1) ? this._keys[index] : null
    },

    remove: function(key){
        var index = array.indexOf(this._keys, key)

        if (index !== -1){
            this._keys.splice(index, 1)
            this.length--
            return this._values.splice(index, 1)[0]
        }

        return null
    },

    keys: function(){
        return this._keys.slice()
    },

    values: function(){
        return this._values.slice()
    }

})

module.exports = Map

});
