// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0xaed3c714bb42a73d708bcf1dc9a9deebadc913ef42bac6a6178a60n,
  b: -0xf3d6bd1c059b79n,
  r: 0x2a4f893c8ece3n
}, {
  a: -0x8a6d8cb8e32aba50e08fd50aecbda6821e1863bf9a2n,
  b: 0xe19ab8530bce542ec6b4c848fc383a2b688f07976dd523dabn,
  r: -0x8a6d8cb8e32aba50e08fd50aecbda6821e1863bf9a2n
}, {
  a: 0x7cd19a308b217ddd9dcda69ebe37767f09a483cb87060314aeade6f6c619d27c3n,
  b: 0xae30b5c754e0an,
  r: 0x619154797565dn
}, {
  a: -0xaa90d777e849974d7ebebd2ed76dce635e36713e9e0c97cen,
  b: 0xcc2bc7239bf83ecafc74b25750981df258n,
  r: -0xa32d47bc250c5a41d147a862099778685en
}, {
  a: 0x7386178fe1159c4ca3c4e5caa6eda4413926047efd22007931c22ab54bn,
  b: 0xc05100caa704bca144n,
  r: 0x55ead7f83d4a795753n
}, {
  a: -0xa48867cf46692351a59bc89c0ddc9a6d2cd9f72578c0bab72d8389n,
  b: 0x77c2eec6cc0bef33dd4756b223c35a0f2b528f8648a7n,
  r: -0x184a6eed8fcd32399c59605c7255b5614b388be24b44n
}, {
  a: 0xac7681c26f78191107c9cde47f984fc7ffb7bffd0a055fc14n,
  b: -0xe2d91d1a0e1edc3f806a24c36f7ca0a8a9b44b66c9n,
  r: 0xdf0b3460335089fca0b1da676b3d1e9caf15afd3den
}, {
  a: -0x3035011f4adba0c032ddc2fc884ff7663b45cb3baebec0fn,
  b: 0xcc27f9a21470911a61aae50ae118ebcf85ea4dn,
  r: -0xc5ea1db5af95ccdce2844b13b82659be1ac2adn
}, {
  a: -0x2dbe79c42b1e8db7aea4ca9cfaf1350528b096e23f69ea322cn,
  b: -0x82f7e4f2ee432485n,
  r: -0x824bddbaf61ce383n
}, {
  a: 0xc5c7fbeb60fdb9f8e8347ebf9fe303e3223394b2db93ce2n,
  b: 0xcd988b4cb278a39fd3ae58c16616855f01fab0fb0n,
  r: 0xc3b5157e680c8ca66df1bd640c6ad1601bd612b02n
}, {
  a: 0x73dd1e27450edb450fe4bd70494a8ad85a8ad9691bc40bf500a1n,
  b: 0xc8fb467f71be8a6b965d21857ecfdn,
  r: 0x646e6d9fa1e2eb2933b2e5a837d37n
}, {
  a: -0xecb217583ec4240399bfa34560b45f1fd08efd0ebb56b2dn,
  b: 0xeba34abn,
  r: -0xc2d347bn
}, {
  a: 0x29c8a9854802b9317b90683eb82609b3aa695598807fea0482a56567n,
  b: -0xabe5e55b228f8n,
  r: 0x52303615b525fn
}, {
  a: 0x7b532ee90b3945dbed20180632f46c90d0edb558e39456103f50e5a74ff1dn,
  b: 0x17n,
  r: 0x6n
}, {
  a: -0x6f1dbf8dedea796a2423fad9688d71340963da3a4f005f13e9cd4aa03b96c864552cn,
  b: -0x408a4f36ec4a1b74642fb0a4559en,
  r: -0x33c06c53e6e47ca87f36447f1b0n
}, {
  a: -0xe77508ff49bc76c78678676ca1edc82eb167f3b07d3208d89d26582ef74d60n,
  b: -0xf005fb1a8b29035c72980abe4a0715c90n,
  r: -0x159e8c7616079663b4e12765a05cc6d40n
}, {
  a: 0x626749ef019017f53b2c686f26594e6d3c5f247cf0ed7024cca277n,
  b: 0x5bd931ea8c6939115ad69f6ce3c6bbc300320n,
  r: 0x3a4b041c36d0a45ef932745eab473943b1a97n
}, {
  a: -0x960dde134b881d3366d659c7d8c3eb6346f50c08c6f78en,
  b: -0xc9e7fa60f6ce1997012f5a6164138447fa248754985905dc6n,
  r: -0x960dde134b881d3366d659c7d8c3eb6346f50c08c6f78en
}, {
  a: 0x702dc0033e09e9e58ec3fc96f861587ad13cea1ed7b7eb301n,
  b: 0x71f0c97687b4f3318be2fe54b90273n,
  r: 0x4e1859254ac1d42f7c812decef00a3n
}, {
  a: 0x39376649769a0abb26133deee934330ef21a2f90ea89476569630021af6023235n,
  b: -0x4aaaec4085f65ccc9d547beb122160afcbb3n,
  r: 0x3027d5ebb37c5aa438f11dfcafa3b003b91bn
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a % d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: %");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
