function(setup_resource_tests)
  if(CTEST_RESOURCE_ALLOC_ENABLED)
    add_test(NAME ResourceSetup COMMAND "${CMAKE_COMMAND}" -E remove -f "${CMAKE_BINARY_DIR}/ctresalloc.log")
  endif()
endfunction()

function(add_resource_test name sleep_time proc)
  if(CTEST_RESOURCE_ALLOC_ENABLED)
    add_test(NAME "${name}" COMMAND "${CTRESALLOC_COMMAND}" write "${CMAKE_BINARY_DIR}/ctresalloc.log" "${name}" "${sleep_time}" "${proc}")
    set_property(TEST "${name}" PROPERTY DEPENDS ResourceSetup)
  else()
    add_test(NAME "${name}" COMMAND "${CTRESALLOC_COMMAND}" write "${CMAKE_BINARY_DIR}/ctresalloc.log" "${name}" "${sleep_time}")
  endif()
  set_property(TEST "${name}" PROPERTY RESOURCE_GROUPS "${proc}")
  list(APPEND RESOURCE_TESTS "${name}")
  set(RESOURCE_TESTS "${RESOURCE_TESTS}" PARENT_SCOPE)
endfunction()

function(cleanup_resource_tests)
  if(CTEST_RESOURCE_ALLOC_ENABLED)
    file(WRITE "${CMAKE_BINARY_DIR}/restests.txt" "${RESOURCE_TESTS}")
  endif()
endfunction()
