%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2009-2024. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%% This file is generated DO NOT EDIT

-module(wxAuiNotebookEvent).
-moduledoc """
This class is used by the events generated by `m:wxAuiNotebook`.

See:
* `m:wxAuiNotebook`

* `m:wxBookCtrlEvent`

This class is derived, and can use functions, from:

* `m:wxBookCtrlEvent`

* `m:wxNotifyEvent`

* `m:wxCommandEvent`

* `m:wxEvent`

wxWidgets docs: [wxAuiNotebookEvent](https://docs.wxwidgets.org/3.2/classwx_aui_notebook_event.html)

## Events

Use `wxEvtHandler:connect/3` with `wxAuiNotebookEventType` to subscribe to events of this type.
""".
-include("wxe.hrl").
-export([getDragSource/1,getOldSelection/1,getSelection/1,setDragSource/2,
  setOldSelection/2,setSelection/2]).

%% inherited exports
-export([allow/1,getClientData/1,getExtraLong/1,getId/1,getInt/1,getSkipped/1,
  getString/1,getTimestamp/1,isAllowed/1,isChecked/1,isCommandEvent/1,
  isSelection/1,parent_class/1,resumePropagation/2,setInt/2,setString/2,
  shouldPropagate/1,skip/1,skip/2,stopPropagation/1,veto/1]).

-type wxAuiNotebookEvent() :: wx:wx_object().
-include("wx.hrl").
-type wxAuiNotebookEventType() :: 'command_auinotebook_page_close' | 'command_auinotebook_page_changed' | 'command_auinotebook_page_changing' | 'command_auinotebook_button' | 'command_auinotebook_begin_drag' | 'command_auinotebook_end_drag' | 'command_auinotebook_drag_motion' | 'command_auinotebook_allow_dnd' | 'command_auinotebook_tab_middle_down' | 'command_auinotebook_tab_middle_up' | 'command_auinotebook_tab_right_down' | 'command_auinotebook_tab_right_up' | 'command_auinotebook_page_closed' | 'command_auinotebook_drag_done' | 'command_auinotebook_bg_dclick'.
-export_type([wxAuiNotebookEvent/0, wxAuiNotebook/0, wxAuiNotebookEventType/0]).
-doc false.
parent_class(wxBookCtrlEvent) -> true;
parent_class(wxNotifyEvent) -> true;
parent_class(wxCommandEvent) -> true;
parent_class(wxEvent) -> true;
parent_class(_Class) -> erlang:error({badtype, ?MODULE}).

-doc "Sets the selection member variable.".
-spec setSelection(This, Page) -> 'ok' when
	This::wxAuiNotebookEvent(), Page::integer().
setSelection(#wx_ref{type=ThisT}=This,Page)
 when is_integer(Page) ->
  ?CLASS(ThisT,wxAuiNotebookEvent),
  wxe_util:queue_cmd(This,Page,?get_env(),?wxAuiNotebookEvent_SetSelection).

-doc """
Returns the currently selected page, or `wxNOT\_FOUND` if none was selected.

Note: under Windows, `getSelection/1` will return the same value as `getOldSelection/1` when called from the `EVT_BOOKCTRL_PAGE_CHANGING`
handler and not the page which is going to be selected.
""".
-spec getSelection(This) -> integer() when
	This::wxAuiNotebookEvent().
getSelection(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxAuiNotebookEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxAuiNotebookEvent_GetSelection),
  wxe_util:rec(?wxAuiNotebookEvent_GetSelection).

-doc "Sets the id of the page selected before the change.".
-spec setOldSelection(This, Page) -> 'ok' when
	This::wxAuiNotebookEvent(), Page::integer().
setOldSelection(#wx_ref{type=ThisT}=This,Page)
 when is_integer(Page) ->
  ?CLASS(ThisT,wxAuiNotebookEvent),
  wxe_util:queue_cmd(This,Page,?get_env(),?wxAuiNotebookEvent_SetOldSelection).

-doc """
Returns the page that was selected before the change, `wxNOT\_FOUND` if none was
selected.
""".
-spec getOldSelection(This) -> integer() when
	This::wxAuiNotebookEvent().
getOldSelection(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxAuiNotebookEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxAuiNotebookEvent_GetOldSelection),
  wxe_util:rec(?wxAuiNotebookEvent_GetOldSelection).

-doc "".
-spec setDragSource(This, S) -> 'ok' when
	This::wxAuiNotebookEvent(), S::wxAuiNotebook:wxAuiNotebook().
setDragSource(#wx_ref{type=ThisT}=This,#wx_ref{type=ST}=S) ->
  ?CLASS(ThisT,wxAuiNotebookEvent),
  ?CLASS(ST,wxAuiNotebook),
  wxe_util:queue_cmd(This,S,?get_env(),?wxAuiNotebookEvent_SetDragSource).

-doc "".
-spec getDragSource(This) -> wxAuiNotebook:wxAuiNotebook() when
	This::wxAuiNotebookEvent().
getDragSource(#wx_ref{type=ThisT}=This) ->
  ?CLASS(ThisT,wxAuiNotebookEvent),
  wxe_util:queue_cmd(This,?get_env(),?wxAuiNotebookEvent_GetDragSource),
  wxe_util:rec(?wxAuiNotebookEvent_GetDragSource).

 %% From wxBookCtrlEvent
 %% From wxNotifyEvent
-doc false.
veto(This) -> wxNotifyEvent:veto(This).
-doc false.
isAllowed(This) -> wxNotifyEvent:isAllowed(This).
-doc false.
allow(This) -> wxNotifyEvent:allow(This).
 %% From wxCommandEvent
-doc false.
setString(This,String) -> wxCommandEvent:setString(This,String).
-doc false.
setInt(This,IntCommand) -> wxCommandEvent:setInt(This,IntCommand).
-doc false.
isSelection(This) -> wxCommandEvent:isSelection(This).
-doc false.
isChecked(This) -> wxCommandEvent:isChecked(This).
-doc false.
getString(This) -> wxCommandEvent:getString(This).
-doc false.
getInt(This) -> wxCommandEvent:getInt(This).
-doc false.
getExtraLong(This) -> wxCommandEvent:getExtraLong(This).
-doc false.
getClientData(This) -> wxCommandEvent:getClientData(This).
 %% From wxEvent
-doc false.
stopPropagation(This) -> wxEvent:stopPropagation(This).
-doc false.
skip(This, Options) -> wxEvent:skip(This, Options).
-doc false.
skip(This) -> wxEvent:skip(This).
-doc false.
shouldPropagate(This) -> wxEvent:shouldPropagate(This).
-doc false.
resumePropagation(This,PropagationLevel) -> wxEvent:resumePropagation(This,PropagationLevel).
-doc false.
isCommandEvent(This) -> wxEvent:isCommandEvent(This).
-doc false.
getTimestamp(This) -> wxEvent:getTimestamp(This).
-doc false.
getSkipped(This) -> wxEvent:getSkipped(This).
-doc false.
getId(This) -> wxEvent:getId(This).
