# Copyright 2012-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""UserProfile model."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'UserProfile',
    ]


from django.contrib.auth.models import User
from django.db.models import (
    Model,
    OneToOneField,
)
from maasserver import DefaultMeta
from maasserver.models.cleansave import CleanSave
from piston.models import Token


class UserProfile(CleanSave, Model):
    """A User profile to store MAAS specific methods and fields.

    :ivar user: The related User_.

    .. _User: https://docs.djangoproject.com/
       en/dev/topics/auth/
       #storing-additional-information-about-users

    """

    class Meta(DefaultMeta):
        """Needed for South to recognize this model."""

    user = OneToOneField(User)
