/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.framework.JHotDrawRuntimeException;

public abstract class CollectionsFactory {
    private static String JAVA_UTIL_LIST = "java.util.List";
    private static String COLLECTIONS_FACTORY_PACKAGE = "org.jhotdraw.util.collections.jdk";
    private static final CollectionsFactory factory = CollectionsFactory.determineCollectionsFactory();

    public abstract List createList();

    public abstract List createList(Collection var1);

    public abstract List createList(int var1);

    public abstract Map createMap();

    public abstract Map createMap(Map var1);

    public abstract Set createSet();

    public abstract Set createSet(Set var1);

    public static CollectionsFactory current() {
        return factory;
    }

    protected static CollectionsFactory determineCollectionsFactory() {
        String string = null;
        string = CollectionsFactory.isJDK12() ? "12" : "11";
        return CollectionsFactory.createCollectionsFactory(string);
    }

    protected static boolean isJDK12() {
        try {
            Class.forName(JAVA_UTIL_LIST);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    protected static CollectionsFactory createCollectionsFactory(String string) {
        try {
            Class<?> clazz = Class.forName(COLLECTIONS_FACTORY_PACKAGE + string + ".CollectionsFactoryJDK" + string);
            return (CollectionsFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JHotDrawRuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JHotDrawRuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JHotDrawRuntimeException(illegalAccessException);
        }
    }
}

