/*
 * Remmina - The GTK+ Remote Desktop Client
 * Copyright (C) 2016-2023 Antenore Gatta, Giovanni Panozzo
 *
 * Initially based on the plugin "Remmina Plugin EXEC", created and written by
 * Fabio Castelli (Muflone) <muflone@vbsimple.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU General Public License in all respects
 *  for all of the code used other than OpenSSL. *  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so. *  If you
 *  do not wish to do so, delete this exception statement from your
 *  version. *  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#pragma once

#define PLUGIN_NAME        "EXEC"
#define PLUGIN_DESCRIPTION N_("Execute a command")
#define PLUGIN_VERSION     "1.0"
#define PLUGIN_APPICON     "org.remmina.Remmina-tool-symbolic"

#define REMMINA_PLUGIN_INFO(fmt, ...) \
		remmina_plugin_service->_remmina_info(__func__, fmt, ##__VA_ARGS__)

#define REMMINA_PLUGIN_MESSAGE(fmt, ...) \
		remmina_plugin_service->_remmina_message(__func, fmt, ##__VA_ARGS__)

#define REMMINA_PLUGIN_DEBUG(fmt, ...) \
		remmina_plugin_service->_remmina_debug(__func__, fmt, ##__VA_ARGS__)

#define REMMINA_PLUGIN_WARNING(fmt, ...) \
		remmina_plugin_service->_remmina_warning(__func__, fmt, ##__VA_ARGS__)

/* This will intentionally crash Remmina */
#define REMMINA_PLUGIN_ERROR(fmt, ...) \
		remmina_plugin_service->_remmina_error(__func__, fmt, ##__VA_ARGS__)

#define REMMINA_PLUGIN_CRITICAL(fmt, ...) \
		remmina_plugin_service->_remmina_critical(__func__, fmt, ##__VA_ARGS__)
#define REMMINA_PLUGIN_AUDIT(fmt, ...) \
		remmina_plugin_service->_remmina_audit(__func__, fmt, ##__VA_ARGS__)
