/* rygel-gst-transcoder.c generated by valac 0.44.9, the Vala compiler
 * generated from rygel-gst-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Prasanna Modem <prasanna@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <gst/pbutils/pbutils.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define RYGEL_TYPE_GST_TRANSCODER (rygel_gst_transcoder_get_type ())
#define RYGEL_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder))
#define RYGEL_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))
#define RYGEL_IS_GST_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_IS_GST_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_TRANSCODER))
#define RYGEL_GST_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoderClass))

typedef struct _RygelGstTranscoder RygelGstTranscoder;
typedef struct _RygelGstTranscoderClass RygelGstTranscoderClass;
typedef struct _RygelGstTranscoderPrivate RygelGstTranscoderPrivate;
enum  {
	RYGEL_GST_TRANSCODER_0_PROPERTY,
	RYGEL_GST_TRANSCODER_NAME_PROPERTY,
	RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY,
	RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY,
	RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY,
	RYGEL_GST_TRANSCODER_PRESET_PROPERTY,
	RYGEL_GST_TRANSCODER_NUM_PROPERTIES
};
static GParamSpec* rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_GST_DATA_SOURCE (rygel_gst_data_source_get_type ())
#define RYGEL_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSource))
#define RYGEL_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))
#define RYGEL_IS_GST_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_IS_GST_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_GST_DATA_SOURCE))
#define RYGEL_GST_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_GST_DATA_SOURCE, RygelGstDataSourceClass))

typedef struct _RygelGstDataSource RygelGstDataSource;
typedef struct _RygelGstDataSourceClass RygelGstDataSourceClass;
typedef struct _RygelGstDataSourcePrivate RygelGstDataSourcePrivate;
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE
} RygelGstTranscoderError;
#define RYGEL_GST_TRANSCODER_ERROR rygel_gst_transcoder_error_quark ()
struct _RygelGstTranscoder {
	GObject parent_instance;
	RygelGstTranscoderPrivate * priv;
};

struct _RygelGstTranscoderClass {
	GObjectClass parent_class;
	RygelMediaResource* (*get_resource_for_item) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	guint (*get_distance) (RygelGstTranscoder* self, RygelMediaFileItem* item);
	GstEncodingProfile* (*get_encoding_profile) (RygelGstTranscoder* self, RygelMediaFileItem* item);
};

struct _RygelGstTranscoderPrivate {
	gchar* _name;
	gchar* _mime_type;
	gchar* _dlna_profile;
	gchar* _extension;
	gchar* _preset;
	GstElement* decoder;
	GstElement* encoder;
	gboolean link_failed;
};

struct _RygelGstDataSource {
	GObject parent_instance;
	RygelGstDataSourcePrivate * priv;
	GstElement* src;
	RygelMediaResource* res;
};

struct _RygelGstDataSourceClass {
	GObjectClass parent_class;
};

static gint RygelGstTranscoder_private_offset;
static gpointer rygel_gst_transcoder_parent_class = NULL;

GQuark rygel_gst_transcoder_error_quark (void);
GType rygel_gst_transcoder_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelGstTranscoder, g_object_unref)
#define RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET "Rygel DLNA preset"
#define RYGEL_GST_TRANSCODER_DECODE_BIN "decodebin"
#define RYGEL_GST_TRANSCODER_ENCODE_BIN "encodebin"
#define RYGEL_GST_TRANSCODER_DESCRIPTION "Encoder and decoder are not " "compatible"
RygelGstTranscoder* rygel_gst_transcoder_construct (GType object_type,
                                                    const gchar* name,
                                                    const gchar* mime_type,
                                                    const gchar* dlna_profile,
                                                    const gchar* extension);
static void rygel_gst_transcoder_real_constructed (GObject* base);
RygelMediaResource* rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self,
                                                                RygelMediaFileItem* item);
static RygelMediaResource* rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self,
                                                                     RygelMediaFileItem* item);
const gchar* rygel_gst_transcoder_get_name (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self);
const gchar* rygel_gst_transcoder_get_extension (RygelGstTranscoder* self);
guint rygel_gst_transcoder_get_distance (RygelGstTranscoder* self,
                                         RygelMediaFileItem* item);
static guint rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self,
                                              RygelMediaFileItem* item);
GType rygel_gst_data_source_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelGstDataSource, g_object_unref)
RygelGstDataSource* rygel_gst_transcoder_create_source (RygelGstTranscoder* self,
                                                        RygelMediaFileItem* item,
                                                        RygelDataSource* src,
                                                        GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname,
                                            const gchar* name,
                                            GError** error);
GstEncodingProfile* rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self,
                                                               RygelMediaFileItem* item);
static inline void _dynamic_set_profile2 (GstElement* obj,
                            GstEncodingProfile* value);
static inline GstElement* _dynamic_get_profile3 (GstElement* obj);
void rygel_gst_utils_dump_encoding_profile (GstEncodingProfile* profile,
                                            gint indent);
static inline GstEncodingProfile* _dynamic_get_profile4 (GstElement* obj);
static void rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self,
                                                GstElement* decodebin,
                                                GstPad* new_pad);
static void _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender,
                                                                       GstPad* pad,
                                                                       gpointer self);
static void rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self,
                                           GstElement* decodebin);
static void _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender,
                                                                     gpointer self);
RygelGstDataSource* rygel_gst_data_source_new_from_element (GstElement* element);
RygelGstDataSource* rygel_gst_data_source_construct_from_element (GType object_type,
                                                                  GstElement* element);
static GstEncodingProfile* rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self,
                                                                    RygelMediaFileItem* item);
gboolean rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self,
                                                     RygelMediaFileItem* item);
gboolean rygel_gst_transcoder_mime_type_is_a (RygelGstTranscoder* self,
                                              const gchar* mime_type1,
                                              const gchar* mime_type2);
static void rygel_gst_transcoder_set_name (RygelGstTranscoder* self,
                                    const gchar* value);
static void rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self,
                                         const gchar* value);
static void rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self,
                                            const gchar* value);
static void rygel_gst_transcoder_set_extension (RygelGstTranscoder* self,
                                         const gchar* value);
const gchar* rygel_gst_transcoder_get_preset (RygelGstTranscoder* self);
void rygel_gst_transcoder_set_preset (RygelGstTranscoder* self,
                                      const gchar* value);
static void rygel_gst_transcoder_finalize (GObject * obj);
static void _vala_rygel_gst_transcoder_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_rygel_gst_transcoder_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

GQuark
rygel_gst_transcoder_error_quark (void)
{
	return g_quark_from_static_string ("rygel-gst-transcoder-error-quark");
}

static inline gpointer
rygel_gst_transcoder_get_instance_private (RygelGstTranscoder* self)
{
	return G_STRUCT_MEMBER_P (self, RygelGstTranscoder_private_offset);
}

RygelGstTranscoder*
rygel_gst_transcoder_construct (GType object_type,
                                const gchar* name,
                                const gchar* mime_type,
                                const gchar* dlna_profile,
                                const gchar* extension)
{
	RygelGstTranscoder * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	g_return_val_if_fail (dlna_profile != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	self = (RygelGstTranscoder*) g_object_new (object_type, "name", name, "mime-type", mime_type, "dlna-profile", dlna_profile, "extension", extension, NULL);
	return self;
}

static void
rygel_gst_transcoder_real_constructed (GObject* base)
{
	RygelGstTranscoder * self;
	self = (RygelGstTranscoder*) base;
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
	self->priv->link_failed = TRUE;
}

/**
     * Get the supported (transcoded) MediaResource for the given content item
     *
     * @return A MediaResources or null if the transcoder cannot
     * transcode this media item
     */
static RygelMediaResource*
rygel_gst_transcoder_real_get_resource_for_item (RygelGstTranscoder* self,
                                                 RygelMediaFileItem* item)
{
	RygelMediaResource* res = NULL;
	const gchar* _tmp0_;
	RygelMediaResource* _tmp1_;
	RygelMediaResource* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* _tmp4_;
	const gchar* _tmp5_;
	RygelMediaResource* _tmp6_;
	const gchar* _tmp7_;
	RygelMediaResource* _tmp8_;
	RygelMediaResource* _tmp9_;
	RygelMediaResource* _tmp10_;
	RygelMediaResource* result = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = rygel_media_resource_new (_tmp0_);
	res = _tmp1_;
	_tmp2_ = res;
	_tmp3_ = self->priv->_mime_type;
	rygel_media_resource_set_mime_type (_tmp2_, _tmp3_);
	_tmp4_ = res;
	_tmp5_ = self->priv->_dlna_profile;
	rygel_media_resource_set_dlna_profile (_tmp4_, _tmp5_);
	_tmp6_ = res;
	_tmp7_ = self->priv->_extension;
	rygel_media_resource_set_extension (_tmp6_, _tmp7_);
	_tmp8_ = res;
	rygel_media_resource_set_dlna_conversion (_tmp8_, GUPNP_DLNA_CONVERSION_TRANSCODED);
	_tmp9_ = res;
	rygel_media_resource_set_dlna_flags (_tmp9_, ((GUPNP_DLNA_FLAGS_DLNA_V15 | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_BACKGROUND_TRANSFER_MODE) | GUPNP_DLNA_FLAGS_CONNECTION_STALL);
	_tmp10_ = res;
	rygel_media_resource_set_dlna_operation (_tmp10_, GUPNP_DLNA_OPERATION_TIMESEEK);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelMediaResource* _tmp11_;
		glong _tmp12_;
		glong _tmp13_;
		_tmp11_ = res;
		_tmp12_ = rygel_audio_item_get_duration (G_TYPE_CHECK_INSTANCE_TYPE (item, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) item) : NULL);
		_tmp13_ = _tmp12_;
		rygel_media_resource_set_duration (_tmp11_, _tmp13_);
	}
	result = res;
	return result;
}

RygelMediaResource*
rygel_gst_transcoder_get_resource_for_item (RygelGstTranscoder* self,
                                            RygelMediaFileItem* item)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_resource_for_item (self, item);
}

/**
     * Gets a numeric value that gives an gives an estimate of how hard
     * it would be for this transcoder to trancode @item to the target profile of
     * this transcoder.
     *
     * @param item the media item to calculate the distance for
     *
     * @return      the distance from the @item, uint.MIN if providing such a
     *              value is impossible or uint.MAX if it doesn't make any
     *              sense to use this transcoder for @item
     */
static guint
rygel_gst_transcoder_real_get_distance (RygelGstTranscoder* self,
                                        RygelMediaFileItem* item)
{
	guint _tmp0_ = 0U;
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint
rygel_gst_transcoder_get_distance (RygelGstTranscoder* self,
                                   RygelMediaFileItem* item)
{
	g_return_val_if_fail (self != NULL, 0U);
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_distance (self, item);
}

/**
     * Creates a transcoding source.
     *
     * @param src the media item to create the transcoding source for
     * @param src the original (non-transcoding) source
     *
     * @return      the new transcoding source
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
_dynamic_set_profile2 (GstElement* obj,
                       GstEncodingProfile* value)
{
	g_object_set (obj, "profile", value, NULL);
}

static inline GstElement*
_dynamic_get_profile3 (GstElement* obj)
{
	GstElement* result;
	g_object_get (obj, "profile", &result, NULL);
	return result;
}

static inline GstEncodingProfile*
_dynamic_get_profile4 (GstElement* obj)
{
	GstEncodingProfile* result;
	g_object_get (obj, "profile", &result, NULL);
	return result;
}

static void
_rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added (GstElement* _sender,
                                                                  GstPad* pad,
                                                                  gpointer self)
{
	rygel_gst_transcoder_on_decoder_pad_added ((RygelGstTranscoder*) self, _sender, pad);
}

static void
_rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads (GstElement* _sender,
                                                                gpointer self)
{
	rygel_gst_transcoder_on_no_more_pads ((RygelGstTranscoder*) self, _sender);
}

RygelGstDataSource*
rygel_gst_transcoder_create_source (RygelGstTranscoder* self,
                                    RygelMediaFileItem* item,
                                    RygelDataSource* src,
                                    GError** error)
{
	RygelGstDataSource* orig_source = NULL;
	RygelGstDataSource* _tmp0_;
	GstElement* _tmp1_ = NULL;
	GstElement* _tmp2_;
	GstElement* _tmp3_;
	GstElement* _tmp4_ = NULL;
	GstElement* _tmp5_;
	GstElement* _tmp6_;
	GstElement* _tmp7_;
	GstEncodingProfile* _tmp8_;
	GstEncodingProfile* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstElement* _tmp12_;
	GObjectClass* _tmp16_;
	const gchar* _tmp17_;
	GstElement* _tmp18_;
	GstEncodingProfile* _tmp19_;
	GstEncodingProfile* _tmp20_;
	GstBin* bin = NULL;
	GstBin* _tmp21_;
	GstBin* _tmp22_;
	RygelGstDataSource* _tmp23_;
	GstElement* _tmp24_;
	GstElement* _tmp25_;
	GstElement* _tmp26_;
	RygelGstDataSource* _tmp27_;
	GstElement* _tmp28_;
	GstElement* _tmp29_;
	GstElement* _tmp30_;
	GstElement* _tmp31_;
	GstPad* pad = NULL;
	GstElement* _tmp32_;
	GstPad* _tmp33_;
	GstGhostPad* ghost = NULL;
	GstPad* _tmp34_;
	GstGhostPad* _tmp35_;
	GstBin* _tmp36_;
	GstGhostPad* _tmp37_;
	RygelGstDataSource* new_source = NULL;
	GstBin* _tmp38_;
	RygelGstDataSource* _tmp39_;
	RygelGstDataSource* _tmp40_;
	RygelGstDataSource* _tmp41_;
	RygelMediaResource* _tmp42_;
	RygelMediaResource* _tmp43_;
	GError* _inner_error0_ = NULL;
	RygelGstDataSource* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	g_return_val_if_fail (src != NULL, NULL);
	_vala_assert (RYGEL_IS_GST_DATA_SOURCE (src), "src is GstDataSource");
	_tmp0_ = _g_object_ref0 (RYGEL_IS_GST_DATA_SOURCE (src) ? ((RygelGstDataSource*) src) : NULL);
	orig_source = _tmp0_;
	_tmp2_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_DECODE_BIN, RYGEL_GST_TRANSCODER_DECODE_BIN, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (orig_source);
		return NULL;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->decoder);
	self->priv->decoder = _tmp3_;
	_tmp5_ = rygel_gst_utils_create_element (RYGEL_GST_TRANSCODER_ENCODE_BIN, RYGEL_GST_TRANSCODER_ENCODE_BIN, &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (orig_source);
		return NULL;
	}
	_tmp6_ = _tmp4_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->priv->encoder);
	self->priv->encoder = _tmp6_;
	_tmp7_ = self->priv->encoder;
	_tmp8_ = rygel_gst_transcoder_get_encoding_profile (self, item);
	_tmp9_ = _tmp8_;
	_dynamic_set_profile2 (_tmp7_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->encoder;
	_tmp11_ = _dynamic_get_profile3 (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		gchar* message = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp13_ = g_strdup (_ ("Could not create a transcoder configuration. Your GStreamer installati" \
"on might be missing a plug-in"));
		message = _tmp13_;
		_tmp14_ = message;
		_tmp15_ = g_error_new_literal (RYGEL_GST_TRANSCODER_ERROR, RYGEL_GST_TRANSCODER_ERROR_CANT_TRANSCODE, _tmp14_);
		_inner_error0_ = _tmp15_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (message);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (orig_source);
		return NULL;
	}
	_tmp16_ = G_OBJECT_GET_CLASS ((GObject*) self);
	_tmp17_ = g_type_name (G_OBJECT_CLASS_TYPE (_tmp16_));
	g_debug ("rygel-gst-transcoder.vala:143: %s using the following encoding profile" \
":", _tmp17_);
	_tmp18_ = self->priv->encoder;
	_tmp19_ = _dynamic_get_profile4 (_tmp18_);
	_tmp20_ = _tmp19_;
	rygel_gst_utils_dump_encoding_profile (_tmp20_, 2);
	_tmp21_ = (GstBin*) gst_bin_new ("transcoder-source");
	g_object_ref_sink (_tmp21_);
	bin = _tmp21_;
	_tmp22_ = bin;
	_tmp23_ = orig_source;
	_tmp24_ = _tmp23_->src;
	_tmp25_ = self->priv->decoder;
	_tmp26_ = self->priv->encoder;
	gst_bin_add_many (_tmp22_, _tmp24_, _tmp25_, _tmp26_, NULL);
	_tmp27_ = orig_source;
	_tmp28_ = _tmp27_->src;
	_tmp29_ = self->priv->decoder;
	gst_element_link (_tmp28_, _tmp29_);
	_tmp30_ = self->priv->decoder;
	g_signal_connect_object (_tmp30_, "pad-added", (GCallback) _rygel_gst_transcoder_on_decoder_pad_added_gst_element_pad_added, self, 0);
	_tmp31_ = self->priv->decoder;
	g_signal_connect_object (_tmp31_, "no-more-pads", (GCallback) _rygel_gst_transcoder_on_no_more_pads_gst_element_no_more_pads, self, 0);
	_tmp32_ = self->priv->encoder;
	_tmp33_ = gst_element_get_static_pad (_tmp32_, "src");
	pad = _tmp33_;
	_tmp34_ = pad;
	_tmp35_ = (GstGhostPad*) gst_ghost_pad_new (NULL, _tmp34_);
	g_object_ref_sink (_tmp35_);
	ghost = _tmp35_;
	_tmp36_ = bin;
	_tmp37_ = ghost;
	gst_element_add_pad ((GstElement*) _tmp36_, (GstPad*) _tmp37_);
	_tmp38_ = bin;
	_tmp39_ = rygel_gst_data_source_new_from_element ((GstElement*) _tmp38_);
	new_source = _tmp39_;
	_tmp40_ = new_source;
	_tmp41_ = orig_source;
	_tmp42_ = _tmp41_->res;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	_g_object_unref0 (_tmp40_->res);
	_tmp40_->res = _tmp43_;
	result = new_source;
	_g_object_unref0 (ghost);
	_g_object_unref0 (pad);
	_g_object_unref0 (bin);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (orig_source);
	return result;
}

/**
     * Gets the Gst.EncodingProfile for this transcoder.
     *
     * @return      the Gst.EncodingProfile for this transcoder.
     */
static GstEncodingProfile*
rygel_gst_transcoder_real_get_encoding_profile (RygelGstTranscoder* self,
                                                RygelMediaFileItem* item)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_gst_transcoder_get_encoding_profile'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GstEncodingProfile*
rygel_gst_transcoder_get_encoding_profile (RygelGstTranscoder* self,
                                           RygelMediaFileItem* item)
{
	g_return_val_if_fail (self != NULL, NULL);
	return RYGEL_GST_TRANSCODER_GET_CLASS (self)->get_encoding_profile (self, item);
}

static void
rygel_gst_transcoder_on_decoder_pad_added (RygelGstTranscoder* self,
                                           GstElement* decodebin,
                                           GstPad* new_pad)
{
	GstPad* sinkpad = NULL;
	GstElement* _tmp0_;
	GstPad* _tmp1_;
	GstPad* _tmp2_;
	GstPad* _tmp7_;
	gboolean pad_link_ok = FALSE;
	GstPad* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	g_return_if_fail (new_pad != NULL);
	_tmp0_ = self->priv->encoder;
	_tmp1_ = gst_element_get_compatible_pad (_tmp0_, new_pad, NULL);
	_g_object_unref0 (sinkpad);
	sinkpad = _tmp1_;
	_tmp2_ = sinkpad;
	if (_tmp2_ == NULL) {
		GstCaps* caps = NULL;
		GstCaps* _tmp3_;
		GstElement* _tmp4_;
		GstCaps* _tmp5_;
		GstPad* _tmp6_ = NULL;
		_tmp3_ = gst_pad_query_caps (new_pad, NULL);
		caps = _tmp3_;
		_tmp4_ = self->priv->encoder;
		_tmp5_ = caps;
		g_signal_emit_by_name (_tmp4_, "request-pad", _tmp5_, &_tmp6_, NULL);
		_g_object_unref0 (sinkpad);
		sinkpad = _tmp6_;
		_gst_caps_unref0 (caps);
	}
	_tmp7_ = sinkpad;
	if (_tmp7_ == NULL) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = gst_object_get_name ((GstObject*) new_pad);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		g_debug ("rygel-gst-transcoder.vala:185: No compatible encodebin pad found for p" \
"ad '%s', ignoring..", _tmp10_);
		_g_free0 (_tmp10_);
		_g_object_unref0 (sinkpad);
		return;
	}
	_tmp11_ = sinkpad;
	pad_link_ok = gst_pad_link_full (new_pad, _tmp11_, GST_PAD_LINK_CHECK_DEFAULT) == GST_PAD_LINK_OK;
	if (!pad_link_ok) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GstPad* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp12_ = gst_object_get_name ((GstObject*) new_pad);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = sinkpad;
		_tmp16_ = gst_object_get_name ((GstObject*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		g_warning ("rygel-gst-transcoder.vala:193: Failed to link pad '%s' to '%s'", _tmp14_, _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp14_);
	} else {
		self->priv->link_failed = FALSE;
	}
	_g_object_unref0 (sinkpad);
}

static gpointer
_gst_message_ref0 (gpointer self)
{
	return self ? gst_message_ref (self) : NULL;
}

static void
rygel_gst_transcoder_on_no_more_pads (RygelGstTranscoder* self,
                                      GstElement* decodebin)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (decodebin != NULL);
	if (self->priv->link_failed) {
		GstBin* bin = NULL;
		GstElement* _tmp0_;
		GstObject* _tmp1_;
		GstBin* _tmp2_;
		GError* _error_ = NULL;
		GError* _tmp3_;
		GstMessage* message = NULL;
		GstBin* _tmp4_;
		GError* _tmp5_;
		GstMessage* _tmp6_;
		GstBus* bus = NULL;
		GstBin* _tmp7_;
		GstBus* _tmp8_;
		GstBus* _tmp9_;
		GstMessage* _tmp10_;
		GstMessage* _tmp11_;
		_tmp0_ = self->priv->encoder;
		_tmp1_ = gst_object_get_parent ((GstObject*) _tmp0_);
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gst_bin_get_type ()) ? ((GstBin*) _tmp1_) : NULL;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (_tmp1_);
		}
		bin = _tmp2_;
		_tmp3_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Could not link");
		_error_ = _tmp3_;
		_tmp4_ = bin;
		_tmp5_ = _error_;
		_tmp6_ = gst_message_new_error ((GstObject*) _tmp4_, _tmp5_, RYGEL_GST_TRANSCODER_DESCRIPTION);
		message = _tmp6_;
		_tmp7_ = bin;
		_tmp8_ = gst_element_get_bus ((GstElement*) _tmp7_);
		bus = _tmp8_;
		_tmp9_ = bus;
		_tmp10_ = message;
		_tmp11_ = _gst_message_ref0 (_tmp10_);
		gst_bus_post (_tmp9_, _tmp11_);
		_g_object_unref0 (bus);
		_gst_message_unref0 (message);
		_g_error_free0 (_error_);
		_g_object_unref0 (bin);
	}
}

gboolean
rygel_gst_transcoder_transcoding_necessary (RygelGstTranscoder* self,
                                            RygelMediaFileItem* item)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = self->priv->_mime_type;
	_tmp2_ = rygel_media_file_item_get_mime_type (item);
	_tmp3_ = _tmp2_;
	if (rygel_gst_transcoder_mime_type_is_a (self, _tmp1_, _tmp3_)) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_dlna_profile;
		_tmp5_ = rygel_media_file_item_get_dlna_profile (item);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = !_tmp0_;
	return result;
}

gboolean
rygel_gst_transcoder_mime_type_is_a (RygelGstTranscoder* self,
                                     const gchar* mime_type1,
                                     const gchar* mime_type2)
{
	gchar* content_type1 = NULL;
	gchar* _tmp0_;
	gchar* content_type2 = NULL;
	gchar* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type1 != NULL, FALSE);
	g_return_val_if_fail (mime_type2 != NULL, FALSE);
	_tmp0_ = g_content_type_get_mime_type (mime_type1);
	content_type1 = _tmp0_;
	_tmp1_ = g_content_type_get_mime_type (mime_type2);
	content_type2 = _tmp1_;
	result = g_content_type_is_a (content_type1, content_type2);
	_g_free0 (content_type2);
	_g_free0 (content_type1);
	return result;
}

const gchar*
rygel_gst_transcoder_get_name (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_name (RygelGstTranscoder* self,
                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_gst_transcoder_get_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_NAME_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_mime_type (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_mime_type (RygelGstTranscoder* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_gst_transcoder_get_mime_type (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_dlna_profile (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dlna_profile;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_dlna_profile (RygelGstTranscoder* self,
                                       const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_gst_transcoder_get_dlna_profile (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_dlna_profile);
		self->priv->_dlna_profile = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_extension (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extension;
	result = _tmp0_;
	return result;
}

static void
rygel_gst_transcoder_set_extension (RygelGstTranscoder* self,
                                    const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_gst_transcoder_get_extension (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extension);
		self->priv->_extension = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY]);
	}
}

const gchar*
rygel_gst_transcoder_get_preset (RygelGstTranscoder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_preset;
	result = _tmp0_;
	return result;
}

void
rygel_gst_transcoder_set_preset (RygelGstTranscoder* self,
                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, rygel_gst_transcoder_get_preset (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_preset);
		self->priv->_preset = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_PRESET_PROPERTY]);
	}
}

static void
rygel_gst_transcoder_class_init (RygelGstTranscoderClass * klass,
                                 gpointer klass_data)
{
	rygel_gst_transcoder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelGstTranscoder_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_gst_transcoder_real_constructed;
	((RygelGstTranscoderClass *) klass)->get_resource_for_item = (RygelMediaResource* (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_gst_transcoder_real_get_resource_for_item;
	((RygelGstTranscoderClass *) klass)->get_distance = (guint (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_gst_transcoder_real_get_distance;
	((RygelGstTranscoderClass *) klass)->get_encoding_profile = (GstEncodingProfile* (*) (RygelGstTranscoder*, RygelMediaFileItem*)) rygel_gst_transcoder_real_get_encoding_profile;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_gst_transcoder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_gst_transcoder_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_gst_transcoder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_NAME_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY] = g_param_spec_string ("dlna-profile", "dlna-profile", "dlna-profile", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_GST_TRANSCODER_PRESET_PROPERTY, rygel_gst_transcoder_properties[RYGEL_GST_TRANSCODER_PRESET_PROPERTY] = g_param_spec_string ("preset", "preset", "preset", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_gst_transcoder_instance_init (RygelGstTranscoder * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	self->priv = rygel_gst_transcoder_get_instance_private (self);
	_tmp0_ = g_strdup (RYGEL_GST_TRANSCODER_DEFAULT_ENCODING_PRESET);
	self->priv->_preset = _tmp0_;
}

static void
rygel_gst_transcoder_finalize (GObject * obj)
{
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_mime_type);
	_g_free0 (self->priv->_dlna_profile);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_preset);
	_g_object_unref0 (self->priv->decoder);
	_g_object_unref0 (self->priv->encoder);
	G_OBJECT_CLASS (rygel_gst_transcoder_parent_class)->finalize (obj);
}

/**
 * The base Transcoder class used by gstreamer media engine.
 * Each implementation derives from it and must
 * implement get_resources_for_item and get_encoding_profile methods.
 */
GType
rygel_gst_transcoder_get_type (void)
{
	static volatile gsize rygel_gst_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_gst_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelGstTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_gst_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelGstTranscoder), 0, (GInstanceInitFunc) rygel_gst_transcoder_instance_init, NULL };
		GType rygel_gst_transcoder_type_id;
		rygel_gst_transcoder_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelGstTranscoder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		RygelGstTranscoder_private_offset = g_type_add_instance_private (rygel_gst_transcoder_type_id, sizeof (RygelGstTranscoderPrivate));
		g_once_init_leave (&rygel_gst_transcoder_type_id__volatile, rygel_gst_transcoder_type_id);
	}
	return rygel_gst_transcoder_type_id__volatile;
}

static void
_vala_rygel_gst_transcoder_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	switch (property_id) {
		case RYGEL_GST_TRANSCODER_NAME_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_name (self));
		break;
		case RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_mime_type (self));
		break;
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_dlna_profile (self));
		break;
		case RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_extension (self));
		break;
		case RYGEL_GST_TRANSCODER_PRESET_PROPERTY:
		g_value_set_string (value, rygel_gst_transcoder_get_preset (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_gst_transcoder_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	RygelGstTranscoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_GST_TRANSCODER, RygelGstTranscoder);
	switch (property_id) {
		case RYGEL_GST_TRANSCODER_NAME_PROPERTY:
		rygel_gst_transcoder_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_MIME_TYPE_PROPERTY:
		rygel_gst_transcoder_set_mime_type (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_DLNA_PROFILE_PROPERTY:
		rygel_gst_transcoder_set_dlna_profile (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_EXTENSION_PROPERTY:
		rygel_gst_transcoder_set_extension (self, g_value_get_string (value));
		break;
		case RYGEL_GST_TRANSCODER_PRESET_PROPERTY:
		rygel_gst_transcoder_set_preset (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

