/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.derby;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.platform.cloudscape.CloudscapePlatform;
import org.apache.ddlutils.platform.derby.DerbyBuilder;
import org.apache.ddlutils.platform.derby.DerbyModelReader;

public class DerbyPlatform
extends CloudscapePlatform {
    public static final String DATABASENAME = "Derby";
    public static final String JDBC_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    public static final String JDBC_DRIVER_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String JDBC_SUBPROTOCOL = "derby";

    public DerbyPlatform() {
        this.getPlatformInfo().addNativeTypeMapping(8, "DOUBLE");
        this.getPlatformInfo().addNativeTypeMapping(6, "DOUBLE", 8);
        this.setSqlBuilder(new DerbyBuilder(this));
        this.setModelReader(new DerbyModelReader(this));
    }

    public String getName() {
        return DATABASENAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createDatabase(String jdbcDriverClassName, String connectionUrl, String username, String password, Map parameters) throws DatabaseOperationException, UnsupportedOperationException {
        if (!JDBC_DRIVER.equals(jdbcDriverClassName)) {
            if (!JDBC_DRIVER_EMBEDDED.equals(jdbcDriverClassName)) throw new UnsupportedOperationException("Unable to create a Derby database via the driver " + jdbcDriverClassName);
        }
        StringBuffer creationUrl = new StringBuffer();
        Connection connection = null;
        creationUrl.append(connectionUrl);
        creationUrl.append(";create=true");
        if (parameters != null && !parameters.isEmpty()) {
            Iterator it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if ("create".equalsIgnoreCase(entry.getKey().toString())) continue;
                creationUrl.append(";");
                creationUrl.append(entry.getKey().toString());
                creationUrl.append("=");
                if (entry.getValue() == null) continue;
                creationUrl.append(entry.getValue().toString());
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("About to create database using this URL: " + creationUrl.toString()));
        }
        try {
            try {
                Class.forName(jdbcDriverClassName);
                connection = DriverManager.getConnection(creationUrl.toString(), username, password);
                this.logWarnings(connection);
            }
            catch (Exception ex) {
                throw new DatabaseOperationException("Error while trying to create a database", ex);
            }
            Object var11_11 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException ex) {}
        connection.close();
        return;
    }
}

