/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.cliparams.CustomParamProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockDeviceMappingProcessor
extends CustomParamProcessor {
    public static final String interestedParameter = "BlockDeviceMappings";
    private static final Pattern BLOCK_DEVICE_MAPPING_PATTERN = Pattern.compile("(.*?)(?:\\:(.*?))?(?:\\:(.*?))?");
    private static final String KEY_FOR_DEVICE = "device";
    private static final String KEY_FOR_VIRTUAL = "virtual";
    private static final String KEY_FOR_SNAPSHOT_ID = "snapshot-id";
    private static final String KEY_FOR_VOLUME_SIZE = "volume-size";
    private static final String EMPTY_VIRTUAL_DEVICE = "none";
    private static final String SNAPSHOT_PREFIX = "snap";

    @Override
    public Command process(Command command) throws CliCommandoException {
        for (ParamConfig param : command.getCurrentCommandConfig().getNonDirectiveParameters()) {
            if (!interestedParameter.equalsIgnoreCase(param.getName()) || !param.isSpecified().booleanValue()) continue;
            List<Map<String, String>> valuesMaps = param.getValuesMap();
            ArrayList<Map<String, String>> resultsMaps = new ArrayList<Map<String, String>>();
            for (Map<String, String> valuesMap : valuesMaps) {
                for (Map.Entry<String, String> entry : valuesMap.entrySet()) {
                    resultsMaps.add(this.generateParameterizedBDM(entry));
                }
            }
            param.setValuesMap(resultsMaps);
        }
        return command;
    }

    private Map<String, String> generateParameterizedBDM(Map.Entry<String, String> entry) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!entry.getKey().startsWith("/dev/") && entry.getValue().startsWith("/dev/")) {
            throw new BadInputException(ErrorMessages.ErrorCode.BAD_INPUT, "Device name should be the map key and virtual name should be the value.");
        }
        resultMap.put(KEY_FOR_DEVICE, entry.getKey());
        Matcher matcher = BLOCK_DEVICE_MAPPING_PATTERN.matcher(entry.getValue());
        if (!matcher.matches() || matcher.group(1).trim().equalsIgnoreCase(EMPTY_VIRTUAL_DEVICE)) {
            throw new BadInputException(ErrorMessages.ErrorCode.BAD_INPUT, "No value specified for device " + entry.getKey());
        }
        String virtualName = matcher.group(1).trim();
        if (virtualName.length() == 0 || virtualName.toLowerCase().startsWith(SNAPSHOT_PREFIX)) {
            if (matcher.group(1) != null && matcher.group(1).length() > 0) {
                resultMap.put(KEY_FOR_SNAPSHOT_ID, matcher.group(1));
            }
            if (matcher.group(2) != null && matcher.group(2).length() > 0) {
                resultMap.put(KEY_FOR_VOLUME_SIZE, matcher.group(2));
            }
        } else {
            resultMap.put(KEY_FOR_VIRTUAL, virtualName);
        }
        return resultMap;
    }
}

