/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.util.OsPipe;
import com.amazon.aes.webservices.client.AuthDryRunException;
import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.InvalidCertException;
import com.amazon.aes.webservices.client.InvalidKeyException;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.Jec2Impl;
import com.amazon.aes.webservices.client.Jec2Options;
import com.amazon.aes.webservices.client.Jec2SdkImpl;
import com.amazon.aes.webservices.client.Jec2SoapFaultException;
import com.amazon.aes.webservices.client.TagType;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.InvalidRange;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.OnlyOneArgumentExpected;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.ShowVersion;
import com.amazon.aes.webservices.client.cmd.UnexpectedArgument;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.EC2PosixParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import sun.misc.BASE64Encoder;

public abstract class BaseCmd {
    private static final String HIDE_TAGS_DESC = "Do not display tags for tagged resources.";
    private static final String HIDE_TAGS = "hide-tags";
    private static final String TIMEOUT_ARG = "TIMEOUT";
    private static final String KEY_ARG = "KEY";
    private static final String TOKEN_ARG = "TOKEN";
    private static final String URL_ARG = "URL";
    private static final String CERT_ARG = "CERT";
    private static final String[] CERT_DESC = new String[]{"[DEPRECATED] Specify CERT as the X509 certificate to use. Defaults to the value ", "of the EC2_CERT environment variable (if set). Overrides the default."};
    private static final String[] PRIVATE_KEY_DESC = new String[]{"[DEPRECATED] Specify KEY as the private key to use. Defaults to the value of the", "EC2_PRIVATE_KEY environment variable (if set). Overrides the default."};
    private static final String REQUEST_TIMEOUT_DESC = "Specify a request timeout TIMEOUT (in seconds).";
    private static final String CONNECTION_TIMEOUT_DESC = "Specify a connection timeout TIMEOUT (in seconds).";
    private static final String SHOW_NULL_FIELDS_DESC = "Indicate empty fields.";
    private static final String DEBUG_DESC = "Display additional debugging information.";
    private static final String HEADERS_DESC = "Display column headers.";
    private static final String HELP_DESC = "Display this help.";
    private static final String VERBOSE_DESC = "Verbose output.";
    public static final String SPECIFIC_OPTIONS = "SPECIFIC OPTIONS";
    public static final String GENERAL_OPTIONS = "GENERAL OPTIONS";
    private static final String DEFAULT_URL = "https://ec2.amazonaws.com";
    private static final String DEFAULT_REGION = "us-east-1";
    private static final String[] URL_DESC = new String[]{"Specify URL as the web service URL to use. Defaults to the value of", "'https://ec2.amazonaws.com' (us-east-1) or to that of the", "EC2_URL environment variable (if set). Overrides the default."};
    public static final String HEADERS = "headers";
    public static final String DEBUG = "debug";
    public static final String SHOW_NULL_FIELDS = "show-empty-fields";
    public static final String CONNECTION_TIMEOUT = "connection-timeout";
    public static final String REQUEST_TIMEOUT = "request-timeout";
    public static final String HELP = "help";
    public static final String PRIVATE_KEY = "private-key";
    public static final String AWS_ACCESS_KEY = "aws-access-key";
    public static final String AWS_SECRET_KEY = "aws-secret-key";
    public static final String AWS_DELEGATION_TOKEN = "security-token";
    public static final String CERT = "cert";
    public static final String URL = "url";
    public static final String VERBOSE = "verbose";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTIES_ARG = "PROPERTIES";
    public static final String MANIFEST = "manifest";
    public static final String MANIFEST_FILE_PATH = "manifest-file-path";
    public static final String AMI = "ami";
    public static final String INSTANCE = "instance";
    public static final String INSTANCE_ARG = "INSTANCE";
    public static final String INSTANCE_COUNT = "instance-count";
    public static final String KEY_ID = "key";
    public static final String KEY_ID_ARG = "KEY";
    public static final String GROUP = "group";
    public static final String GROUP_ARG = "GROUP";
    public static final String GROUP_ID = "group-id";
    public static final String GROUP_ID_ARG = "GROUP_ID";
    public static final String GROUP_SET = "group-set";
    public static final String USER_DATA = "user-data";
    public static final String USER_DATA_ARG = "USERDATA";
    public static final String USER_DATA_FILE = "user-data-file";
    public static final String USER_DATA_FILE_ARG = "DATA-FILE";
    public static final String EBS_OPTIMIZED = "ebs-optimized";
    public static final String EBS_OPTIMIZED_ARG = "BOOLEAN";
    public static final String[] EBS_OPTIMIZED_DESC = new String[]{"Provides dedicated throughput to Amazon EBS and a software", "stack optimized for EBS I/O. Additional usage charges apply", "when using this option."};
    public static final String ADDRESSING = "addressing";
    public static final String INSTANCE_TYPE = "instance-type";
    public static final String INSTANCE_TYPE_ARG = "INSTANCETYPE";
    public static final String DESCRIPTION = "description";
    public static final String DESCRIPTION_ARG = "DESCRIPTION";
    public static final String PRODUCT_DESCRIPTION = "product-description";
    public static final String PROTOCOL = "protocol";
    public static final String PROTOCOL_ARG = "PROTOCOL";
    public static final String PORT_RANGE = "port-range";
    public static final String PORT_RANGE_ARG = "PORT_RANGE";
    public static final String SOURCE_SUBNET = "source-subnet";
    public static final String DEST_SUBNET = "dest-subnet";
    public static final String SOURCE_GROUP = "source-group";
    public static final String SOURCE_GROUP_USER = "source-group-user";
    public static final String SOURCE_OR_DEST_GROUP = "source-or-dest-group";
    public static final String SOURCE_OR_DEST_GROUP_USER = "source-or-dest-group-user";
    public static final String TIMESTAMP = "timestamp";
    public static final String ICMP_TYPE_CODE = "icmp-type-code";
    public static final String ICMP_TYPE_CODE_ARG = "ICMP_TYPE_CODE";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String ATTRIB = "attrib";
    public static final String ITEM = "item";
    public static final String OWNER = "owner";
    public static final String OWNER_ARG = "OWNER";
    public static final String EXECUTABLE_BY = "executable-by";
    public static final String EXECUTABLE_BY_ARG = "USER";
    public static final String ALL = "all";
    public static final String LAUNCH_PERMISSION = "launch-permission";
    public static final String PRODUCT_CODE = "product-code";
    public static final String RAW_CONSOLE_OUTPUT = "raw-console-output";
    public static final String CREATE_VOLUME_PERMISSION = "create-volume-permission";
    public static final String AMAZON = "amazon";
    public static final String SELF = "self";
    public static final String EXPLICIT = "explicit";
    public static final String ACCOUNT_ID = "account-id";
    public static final String ATTRIBUTE_NAME = "attribute-name";
    public static final String ATTRIBUTE_NAME_DESC = "Fill me in.";
    public static final String AVAILABILITY_ZONE = "availability-zone";
    public static final String AVAILABILITY_ZONE_ARG = "ZONE";
    public static final String KERNEL = "kernel";
    public static final String KERNEL_ARG = "KERNEL";
    public static final String PLACEMENT_GROUP = "placement-group";
    public static final String[] PLACEMENT_GROUP_DESC = new String[]{"Specifies the placement group into which the instances ", "should be launched."};
    public static final String[] BLOCK_DEVICE_MAPPING_DESC = new String[]{"Defines a block device mapping for the image, in the form", "'<device>=<block-device>', where 'block-device' can be one of the", "following:", "", " - 'none': indicates that a block device that would be exposed at the", "   specified device should be suppressed. For example: '/dev/sdb=none'", "", " - 'ephemeral[0-3]': indicates that the Amazon EC2 ephemeral store", "   (instance local storage) should be exposed at the specified device.", "   For example: '/dev/sdc=ephemeral0'.", "", " - '[<snapshot-id>][:<size>[:<delete-on-termination>][:<type>[:<iops>]]]': indicates", "   that an Amazon EBS volume, created from the specified Amazon EBS", "   snapshot, should be exposed at the specified device. The following", "   combinations are supported:", "", "    - '<snapshot-id>': the ID of an Amazon EBS snapshot, which must", "      be owned by the caller. May be left out if a <size> is", "      specified, creating an empty Amazon EBS volume of the specified", "      size.", "", "    - '<size>': the size (GiBs) of the Amazon EBS volume to be", "      created. If a snapshot was specified, this may not be smaller", "      than the size of the snapshot itself.", "", "    - '<delete-on-termination>': indicates whether the Amazon EBS", "      volume should be deleted on instance termination. If not", "      specified, this will default to 'true' and the volume will be", "      deleted.", "", "    - '<type>': specifies the volume type. This can be either", "      'standard' or 'io1'. Defaults to standard.", "", "    - '<iops>': The requested number of I/O operations per", "      second that the volume can support.", "", "   For example: '/dev/sdb=snap-7eb96d16'", "                '/dev/sdc=snap-7eb96d16:80:false'", "                '/dev/sdc=snap-7eb96d16:80:false:io1:100'", "                '/dev/sdd=:120'", "", "See the latest Developer's Guide for further information."};
    public static final String PLACEMENT_GROUP_ARG = "GROUP_NAME";
    public static final String RAMDISK = "ramdisk";
    public static final String RAMDISK_ARG = "RAMDISK";
    public static final String MAPPING_ARG = "MAPPING";
    public static final String PRIV_LAUNCH_KEY = "priv-launch-key";
    public static final String BLOCK_DEVICE_MAPPING = "block-device-mapping";
    public static final String BLOCK_DEVICE_MAPPING_ARG = "MAPPING";
    public static final String VOLUME = "volume";
    public static final String VOLUME_ARG = "VOLUME";
    public static final String VOLUME_SIZE = "size";
    public static final String VOLUME_TYPE = "type";
    public static final String IOPS = "iops";
    public static final String AUTO_ENABLE = "auto-enable-io";
    public static final String AUTO_ENABLE_ARG = "AUTO-ENABLE-IO";
    public static final String DEVICE = "device";
    public static final String DEVICE_ARG = "DEVICE";
    public static final String SNAPSHOT = "snapshot";
    public static final String SNAPSHOT_ARG = "SNAPSHOT";
    public static final String FORCE = "force";
    public static final String NO_REBOOT = "no-reboot";
    public static final String OWNER_AKID = "owner-akid";
    public static final String OWNER_AKID_ARG = "OWNERAKID";
    public static final String OWNER_SAK_ARG = "SECRETKEY";
    public static final String OWNER_SAK = "owner-sak";
    public static final String BUCKET = "bucket";
    public static final String BUCKET_ARG = "BUCKET";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String PREFIX = "prefix";
    public static final String PREFIX_ARG = "PREFIX";
    public static final String EXPIRES = "expires";
    public static final String POLICY = "policy";
    public static final String POLICY_SIGNATURE = "policy-signature";
    public static final String BUNDLE = "bundle";
    public static final String NO_BUCKET_SETUP = "no-bucket-setup";
    public static final String MONITOR = "monitor";
    public static final String MONITOR_ARG = "MONITOR";
    public static final String MONITORING = "monitoring";
    public static final String MONITORING_ARG = "MONITORING";
    public static final String ARCHITECTURE = "architecture";
    public static final String ARCHITECTURE_ARG = "ARCHITECTURE";
    public static final String NAME = "name";
    public static final String NAME_ARG = "NAME";
    public static final String DISABLE_API_TERMINATION = "disable-api-termination";
    public static final String BOOLEAN_ARG = "BOOLEAN";
    public static final String INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR = "instance-initiated-shutdown-behavior";
    public static final String INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_ARG = "BEHAVIOR";
    public static final String LICENSE_ID_ARG = "LICENSE";
    public static final String CAPACITY = "capacity";
    public static final String CAPACITY_ARG = "CAPACITY";
    public static final String LICENSE_POOL = "license-pool";
    public static final String PRIVATE_IP_ADDRESS = "private-ip-address";
    public static final String SOURCE_DEST_CHECK = "source-dest-check";
    public static final String NETWORK_INTERFACE_ATTACHMENTS = "nic-attachments";
    public static final String NETWORK_INTERFACE_ATTACHMENTS_ARG = "NICATTACHMENTS";
    public static final String NETWORK_INTERFACE = "network-interface";
    public static final String NETWORK_INTERFACE_ARG = "NETWORKINTERFACE";
    public static final String DEVICE_INDEX = "device-index";
    public static final String DEVICE_INDEX_ARG = "DEVICEINDEX";
    public static final String ATTACH_PERMISSION = "attach-permission";
    public static final String ASSOCIATE_ADDRESS_PERMISSION = "associate-address-permission";
    public static final String ADD_PERMISSION = "add";
    public static final String ADD_PERMISSION_ARG = "ENTITY";
    public static final String REMOVE_PERMISSION = "remove";
    public static final String REMOVE_PERMISSION_ARG = "ENTITY";
    public static final String ATTACHMENT = "attachment";
    public static final String ATTACHMENT_ARG = "ATTACHMENT";
    public static final String DELETE_ON_TERMINATION = "delete-on-termination";
    public static final String NETWORK_ATTACHMENT = "network-attachment";
    public static final String NETWORK_ATTACHMENT_ARG = "NETWORKATTACHMENT";
    public static final String REQUESTER_MANAGED = "requester-managed";
    public static final String IAM_PROFILE = "iam-profile";
    public static final String ASSOCIATE_PUBLIC_IP_ADDRESS = "associate-public-ip-address";
    public static final String ASSOCIATE_PUBLIC_IP_ADDRESS_ARG = "BOOLEAN";
    public static final String[] ASSOCIATE_PUBLIC_IP_ADDRESS_DESC = new String[]{"Specify whether or not an AWS public IP address should be assigned to the eth0", "of the instances to be launched. Instances launched into a default subnet are", "assigned a public IP address by default."};
    public static final String SRIOV_NET_SUPPORT = "sriov";
    public static final String SRIOV_NET_SUPPORT_ARG = "SRIOV";
    public static final String ALLOCATION_ID = "allocation-id";
    public static final String ALLOCATION_ID_ARG = "ALLOCATION_ID";
    public static final String[] ALLOCATION_ID_DESC = new String[]{"The ALLOCATION_ID to use for the operation.", "Used for VPC elastic IP addresses."};
    public static final String ASSOCIATION_ID = "association-id";
    public static final String ASSOCIATION_ID_ARG = "ASSOCIATION_ID";
    public static final String ASSOCIATION_ID_DESC = "The ASSOCIATION_ID to use for the operation, used for VPC associations";
    public static final String INTERFACE_ID = "interface-id";
    public static final String INTERFACE_ID_ARG = "INTERFACE_ID";
    public static final String INTERFACE_ID_DESC = "The INTERFACE_ID to use for the operation, used for VPC elastic IP addresses";
    public static final String PRICE = "price";
    public static final String REQUEST_TYPE = "type";
    public static final String VALID_UNTIL = "valid-until";
    public static final String VALID_FROM = "valid-from";
    public static final String LAUNCH_GROUP = "launch-group";
    public static final String AZ_GROUP = "availability-zone-group";
    public static final String REQUEST_ID = "request-id";
    public static final String START_TIME = "start-time";
    public static final String END_TIME = "end-time";
    public static final String MAX_RESULTS = "max-results";
    public static final String REGION = "region";
    public static final String REGION_ARG = "REGION";
    public static final String[] REGION_DESC = new String[]{"Specify REGION as the web service region to use.", "This option will override the URL specified by the \"-U URL\" option", "and EC2_URL environment variable.", "This option defaults to the region specified by the EC2_URL environment variable", "or us-east-1 if this environment variable is not set."};
    public static final String DEFAULT_HOST = "ec2.amazonaws.com";
    public static final String OWNER_SAK_DESC = BaseCmd.joinDescription(new String[]{"AWS Secret Access Key of the owner of BUCKET, used to sign the upload", "policy. This parameter is required to generate a policy if --policy", "is not given, and to sign a given or generated policy if --policy-signature", "is not given. This parameter value is not sent to EC2."});
    public static final String OWNER_AKID_DESC = "AWS Access Key Id of the owner of BUCKET.";
    private static final String AWS_ACCESS_KEY_DESC = BaseCmd.joinDescription(new String[]{"AWS Access Key ID. Defaults to the value of the AWS_ACCESS_KEY", "environment variable (if set)."});
    private static final String AWS_SECRET_KEY_DESC = BaseCmd.joinDescription(new String[]{"AWS Secret Access Key. Defaults to the value of the AWS_SECRET_KEY", "environment variable (if set)."});
    private static final String AWS_DELEGATION_TOKEN_DESC = BaseCmd.joinDescription(new String[]{"AWS delegation token. Defaults to the value of the AWS_DELEGATION_TOKEN", "environment variable (if set)."});
    public static final String TYPE = "type";
    public static final String TYPE_ARG = "TYPE";
    public static final String IP_ADDRESS = "ip";
    public static final String IP_ADDRESS_ARG = "IP_ADDRESS";
    public static final String BGP_ASN = "bgp-asn";
    public static final String BGP_ASN_ARG = "BGP_ASN";
    public static final String VPC = "vpc";
    public static final String VPC_ARG = "VPC";
    public static final String CUSTOMER_GATEWAY = "customer-gateway";
    public static final String CUSTOMER_GATEWAY_ARG = "CUSTOMER_GATEWAY";
    public static final String VPN_GATEWAY = "vpn-gateway";
    public static final String VPN_GATEWAY_ARG = "VPN_GATEWAY";
    public static final String VPN_CONNECTION = "vpn-connection";
    public static final String VPN_CONNECTION_ARG = "VPN_CONNECTION";
    public static final String VGW = "vgw";
    public static final String VGW_ARG = "VGW";
    public static final String SUBNET = "subnet";
    public static final String SUBNET_ARG = "SUBNET";
    public static final String DHCP_OPTIONS = "dhcp-options";
    public static final String DHCP_OPTIONS_ARG = "DHCP_OPTIONS";
    public static final String OUTPUT_FORMAT = "format";
    public static final String OUTPUT_FORMAT_ARG = "FORMAT";
    public static final String CIDR = "cidr";
    public static final String CIDR_ARG = "CIDR";
    public static final String STATIC_ROUTES_ONLY = "static-routes-only";
    public static final String STYLESHEET = "stylesheet";
    public static final String STYLESHEET_ARG = "STYLESHEET";
    public static final String IMAGE_LOCATION_ARG = "IMAGE_LOCATION";
    public static final String GROUP_NAME = "group-name";
    public static final String STRATEGY = "strategy";
    public static final String STRATEGY_ARG = "STRATEGY";
    public static final String NETWORK_ACL = "network-acl";
    public static final String NETWORK_ACL_ARG = "NETWORK_ACL";
    public static final String ASSOCIATION = "association";
    public static final String RULE_NUMBER = "rule-number";
    public static final String RULE_NUMBER_ARG = "RULE_NUMBER";
    public static final String EGRESS = "egress";
    public static final String INGRESS = "ingress";
    public static final String ALLOW = "allow";
    public static final String DENY = "deny";
    public static final String ROUTE_TABLE = "route-table";
    public static final String ROUTE_TABLE_ARG = "ROUTE_TABLE";
    public static final String GATEWAY = "gateway";
    public static final String GATEWAY_ARG = "GATEWAY";
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_ARG = "DOMAIN";
    public static final String ROOT_DEVICE = "root-device-name";
    public static final String ROOT_DEVICE_ARG = "ROOTDEVICENAME";
    public static final String BLOCK_DEVICE = "block-device";
    public static final String BLOCK_DEVICE_ARG = "BLOCKDEVICE";
    public static final String FORMAT = "format";
    public static final String FORMAT_ARG = "FORMAT";
    public static final String DISK_IMAGE = "disk-image";
    public static final String VOLUME_DASH_SIZE = "volume-size";
    public static final String VOLUME_DASH_SIZE_ARG = "SIZE";
    public static final String IGNORE_REGION_AFFINITY = "ignore-region-affinity";
    public static final String PLATFORM = "platform";
    public static final String PLATFORM_ARG = "PLATFORM";
    public static final String IMPORT_URL = "manifest-url";
    public static final String IMPORT_URL_ARG = "url";
    public static final String TASK = "task";
    public static final String TASK_ARG = "TASK-ID";
    public static final String DRY_RUN = "dry-run";
    public static final String DONT_VERIFY_FORMAT = "dont-verify-format";
    public static final String NO_UPLOAD = "no-upload";
    public static final String DISK_IMAGE_FORMAT = "disk-image-format";
    public static final String DISK_IMAGE_FORMAT_ARG = "DISK-IMAGE-FORMAT";
    public static final String ENVIRONMENT = "target-environment";
    public static final String ENVIRONMENT_ARG = "TARGET-ENVIRONMENT";
    public static final String CONTAINER_FORMAT = "container-format";
    public static final String CONTAINER_FORMAT_ARG = "CONTAINER-FORMAT";
    public static final String S3_BUCKET = "s3-bucket";
    public static final String S3_BUCKET_ARG = "S3-BUCKET";
    public static final String S3_PREFIX = "s3-prefix";
    public static final String S3_PREFIX_ARG = "S3-PREFIX";
    public static final String SECONDARY_PRIVATE_IP_ADDRESS_COUNT = "secondary-private-ip-address-count";
    public static final String SECONDARY_PRIVATE_IP_ADDRESS_COUNT_ARG = "SECONDARY-PRIVATE-ADDRESS-COUNT";
    public static final String SECONDARY_PRIVATE_IP_ADDRESS = "secondary-private-ip-address";
    public static final String SECONDARY_PRIVATE_IP_ADDRESS_ARG = "SECONDARY-PRIVATE-IP-ADDRESS";
    public static final String ALLOW_REASSIGNMENT = "allow-reassignment";
    public static final String ALLOW_REASSOCIATION = "allow-reassociation";
    public static final String TENANCY = "tenancy";
    public static final String TENANCY_ARG = "TENANCY";
    public static final String FILTER = "filter";
    public static final String FILTER_ARG = "FILTER";
    public static final String FILTER_SHORT_OPTION = "F";
    public static final String FILTER_DESC = "Add a filter criterion for the result-set.";
    public static final String TAG = "tag";
    public static final String TAG_ARG = "TAG";
    public static final String TAG_DESC = "Tag in the form of key[=value].";
    public static final Pattern TAG_PATTERN = Pattern.compile("^((?:[^=]|\\\\=)+)(?:=((?:[^=]|\\\\=)*))?$");
    public static final String ARN_ARG = "ARN";
    public static final String CLIENT_TOKEN = "client-token";
    public static final String CLIENT_TOKEN_ARG = "TOKEN";
    public static final String AUTH_DRY_RUN = "auth-dry-run";
    public static final String AUTH_DRY_RUN_SHORT_OPTION = "D";
    public static final String AUTH_DRY_RUN_DESC = "Check if you can perform the requested action rather than actually performing it.";
    public static final String[] ATTRIBUTE_ARGS = new String[]{"launch-permission", "product-code", "kernel", "ramdisk", "block-device-mapping", "sriov"};
    public static final String[] SNAPSHOT_ATTRIBUTE_ARGS = new String[]{"create-volume-permission", "product-code"};
    public static final String[] ATTRIBUTE_OP_ARGS = new String[]{"add", "remove"};
    protected String name;
    protected List<String> aliases;
    private Options options = new Options();
    protected CommandLine cmd = null;
    private Map<String, String> defaultValues = new HashMap<String, String>();
    private boolean showHelp = false;
    private boolean invalidArgument = false;

    public BaseCmd(String name, String alias) {
        this(name, new String[]{alias});
    }

    public BaseCmd(String name, String[] aliases) {
        this.name = name;
        this.aliases = Arrays.asList(aliases);
    }

    public void printSynopsis() {
        System.out.println("  SYNOPSIS");
        System.out.println("     " + this.name + " (" + this.aliases + ")");
        for (String option : this.getOptionStrings()) {
            System.out.println("     " + this.name + " " + this.getGlobalOptionString() + " " + option);
        }
    }

    protected String getURL() {
        String urlString = "";
        if (this.isOptionSet(REGION)) {
            urlString = String.format("https://ec2.%s.amazonaws.com", this.getOptionValue(REGION));
        } else if (this.isOptionSet("url") || this.hasDefault("url")) {
            urlString = this.getOptionValue("url");
        } else {
            throw new GeneralError("No value or default found for URL");
        }
        return urlString;
    }

    public void printGeneralNotes() {
        System.out.println("  GENERAL NOTES");
        System.out.println("     Any command option/parameter may be passed a value of '-' to indicate");
        System.out.println("     that values for that option should be read from stdin.");
    }

    protected String getGlobalOptionString() {
        return "[GENERAL OPTIONS]";
    }

    public void printDescription() {
        System.out.println("  DESCRIPTION");
    }

    public void printOptions() {
        this.printOptions(false);
    }

    public void printExtraOptionsHeader() {
        System.out.println("  SPECIFIC OPTIONS");
        System.out.println();
    }

    public void printOptions(boolean moreOptions) {
        System.out.println();
        System.out.println("  GENERAL OPTIONS");
        System.out.println();
        if (this.isOnline()) {
            this.printOption(AWS_ACCESS_KEY);
            this.printOption(AWS_SECRET_KEY);
            this.printOption(AWS_DELEGATION_TOKEN);
            this.printOption(PRIVATE_KEY);
            this.printOption(CERT);
            this.printOption("url");
            this.printOption(REGION);
            this.printOption(AUTH_DRY_RUN);
        }
        this.printOption(VERBOSE);
        this.printOption(HELP);
        this.printOption(HEADERS);
        this.printOption(DEBUG);
        this.printOption(SHOW_NULL_FIELDS);
        this.printOption(HIDE_TAGS);
        if (this.isOnline()) {
            this.printOption(CONNECTION_TIMEOUT);
            this.printOption(REQUEST_TIMEOUT);
            if (moreOptions) {
                this.printExtraOptionsHeader();
            }
        }
    }

    protected String rightPad(String s, int width) {
        while (s.length() < width) {
            s = s + ' ';
        }
        return s;
    }

    protected String joinDescription(String s) {
        return s;
    }

    protected static String joinDescription(String[] strs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            sb.append(strs[i]);
            if (i >= strs.length - 1) continue;
            sb.append('\n');
            sb.append("          ");
        }
        return sb.toString();
    }

    protected void printOption(String l) {
        Option opt = this.options.getOption(l);
        String opts = this.describeOption(l);
        System.out.println("     " + opts);
        System.out.println("          " + opt.getDescription());
        System.out.println();
    }

    protected abstract String getOptionString();

    protected List<String> getOptionStrings() {
        ArrayList<String> options = new ArrayList<String>();
        options.add(this.getOptionString());
        return options;
    }

    protected boolean isOnline() {
        return true;
    }

    public void showUsage() {
        this.printSynopsis();
        this.printGeneralNotes();
        this.printDescription();
        this.printOptions();
    }

    protected void init(Options newOpts) {
        this.options.addOption(new Option(null, HIDE_TAGS, false, HIDE_TAGS_DESC));
        this.options.addOption(new Option("h", HELP, false, HELP_DESC));
        this.options.addOption(new Option("?", HELP, false, HELP_DESC));
        this.options.addOption(new Option("H", HEADERS, false, HEADERS_DESC));
        OptionBuilder.withLongOpt((String)DEBUG);
        OptionBuilder.withDescription((String)DEBUG_DESC);
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SHOW_NULL_FIELDS);
        OptionBuilder.withDescription((String)SHOW_NULL_FIELDS_DESC);
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)PRIVATE_KEY);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"KEY");
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(PRIVATE_KEY_DESC));
        this.options.addOption(OptionBuilder.create((String)"K"));
        OptionBuilder.withLongOpt((String)AWS_ACCESS_KEY);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"KEY");
        OptionBuilder.withDescription((String)this.joinDescription(AWS_ACCESS_KEY_DESC));
        this.options.addOption(OptionBuilder.create((String)"O"));
        OptionBuilder.withLongOpt((String)AWS_DELEGATION_TOKEN);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TOKEN");
        OptionBuilder.withDescription((String)this.joinDescription(AWS_DELEGATION_TOKEN_DESC));
        this.options.addOption(OptionBuilder.create((String)"T"));
        OptionBuilder.withLongOpt((String)AWS_SECRET_KEY);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"KEY");
        OptionBuilder.withDescription((String)this.joinDescription(AWS_SECRET_KEY_DESC));
        this.options.addOption(OptionBuilder.create((String)"W"));
        OptionBuilder.withLongOpt((String)CERT);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)CERT_ARG);
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(CERT_DESC));
        this.options.addOption(OptionBuilder.create((String)"C"));
        OptionBuilder.withLongOpt((String)REGION);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)REGION_ARG);
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(REGION_DESC));
        this.options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"url");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)URL_ARG);
        OptionBuilder.withDescription((String)BaseCmd.joinDescription(URL_DESC));
        this.options.addOption(OptionBuilder.create((String)"U"));
        OptionBuilder.withLongOpt((String)AUTH_DRY_RUN);
        OptionBuilder.withDescription((String)this.joinDescription(AUTH_DRY_RUN_DESC));
        this.options.addOption(OptionBuilder.create((String)AUTH_DRY_RUN_SHORT_OPTION));
        if (this.isOnline()) {
            OptionBuilder.withLongOpt((String)CONNECTION_TIMEOUT);
            OptionBuilder.hasArgs();
            OptionBuilder.withArgName((String)TIMEOUT_ARG);
            OptionBuilder.withDescription((String)CONNECTION_TIMEOUT_DESC);
            this.options.addOption(OptionBuilder.create());
            OptionBuilder.withLongOpt((String)REQUEST_TIMEOUT);
            OptionBuilder.hasArgs();
            OptionBuilder.withArgName((String)TIMEOUT_ARG);
            OptionBuilder.withDescription((String)REQUEST_TIMEOUT_DESC);
            this.options.addOption(OptionBuilder.create());
        }
        OptionBuilder.withLongOpt((String)VERBOSE);
        OptionBuilder.withDescription((String)VERBOSE_DESC);
        this.options.addOption(OptionBuilder.create((String)"v"));
        this.appendOpts(newOpts);
    }

    protected void appendOpts(Options newOpts) {
        for (Object o : newOpts.getOptions()) {
            this.options.addOption((Option)o);
        }
    }

    protected void parseOpts(String[] args) {
        EC2PosixParser parser = new EC2PosixParser();
        try {
            this.cmd = parser.parse(this.options, args, false);
        }
        catch (UnrecognizedOptionException uoe) {
            this.invalidArgument = true;
            System.err.println(uoe.getMessage() + " (use -h for usage)");
        }
        catch (ParseException pe) {
            this.invalidArgument = true;
            System.err.println(pe.getMessage() + " (use -h for usage)");
        }
        if (this.cmd != null) {
            if (this.isOptionSet(HELP)) {
                this.showHelp = true;
            }
            if (this.isOnline()) {
                if (!this.isOptionSet(PRIVATE_KEY)) {
                    this.storeDefaultValue(PRIVATE_KEY, this.resolvePath(this.getEnvVar(new String[]{"EC2_PRIVATE_KEY"}, null)));
                } else {
                    this.storeDefaultValue(PRIVATE_KEY, this.resolvePath(this.getOptionValue(PRIVATE_KEY)));
                }
                if (!this.isOptionSet(CERT)) {
                    this.storeDefaultValue(CERT, this.resolvePath(this.getEnvVar(new String[]{"EC2_CERT"}, null)));
                } else {
                    this.storeDefaultValue(CERT, this.resolvePath(this.getOptionValue(CERT)));
                }
                if (!this.isOptionSet("url")) {
                    this.storeDefaultValue("url", this.getEnvVar(new String[]{"EC2_URL", "C3_URL", "AES_URL", "AES_XINO_URL"}, DEFAULT_URL));
                }
                if (!this.isOptionSet(AWS_ACCESS_KEY)) {
                    this.storeDefaultValue(AWS_ACCESS_KEY, this.getEnvVar(new String[]{"AWS_ACCESS_KEY"}, null));
                }
                if (!this.isOptionSet(AWS_SECRET_KEY)) {
                    this.storeDefaultValue(AWS_SECRET_KEY, this.getEnvVar(new String[]{"AWS_SECRET_KEY"}, null));
                }
                if (!this.isOptionSet(AWS_DELEGATION_TOKEN)) {
                    this.storeDefaultValue(AWS_DELEGATION_TOKEN, this.resolvePath(this.getEnvVar(new String[]{"AWS_DELEGATION_TOKEN"}, null)));
                }
            }
        }
    }

    private String getEnvVar(String[] names, String defaultValue) {
        for (int i = 0; i < names.length; ++i) {
            String val = System.getenv(names[i]);
            if (val == null) continue;
            return val;
        }
        return defaultValue;
    }

    private String resolvePath(String path) {
        if (path == null) {
            return path;
        }
        String homeDir = System.getProperty("user.home");
        path = path.replace("~", homeDir);
        if (System.getProperty("ec2.cygwin") != null) {
            try {
                OsPipe fileConv = new OsPipe(new String[]{"cygpath.exe", "-w", path});
                String[] pathLines = fileConv.readLines();
                return pathLines[0];
            }
            catch (IOException e) {
                System.err.println("WARNING: Could not convert Cygwin path [" + e.getMessage() + "]");
            }
            catch (InterruptedException e) {
                System.err.println("WARNING: Interrupted while converting Cygwin path [" + e.getMessage() + "]");
            }
        }
        return path;
    }

    private void storeDefaultValue(String name, String value) {
        if (value == null) {
            return;
        }
        this.defaultValues.put(name, value);
    }

    protected boolean isOptionSet(String name) {
        return this.cmd != null && this.cmd.hasOption(name);
    }

    protected boolean hasDefault(String name) {
        return this.defaultValues.containsKey(name);
    }

    protected String getOptionValue(String name, String defaultValue) {
        if (this.isOptionSet(name)) {
            if (this.options.getOption(name).hasArg()) {
                return this.cmd.getOptionValue(name);
            }
            return "true";
        }
        if (this.defaultValues.containsKey(name)) {
            return this.defaultValues.get(name);
        }
        return defaultValue;
    }

    public String getOptionValue(String name) {
        if (this.isOptionSet(name)) {
            if (this.options.getOption(name).hasArg()) {
                return this.cmd.getOptionValue(name);
            }
            return "true";
        }
        if (this.defaultValues.containsKey(name)) {
            return this.defaultValues.get(name);
        }
        return null;
    }

    protected String[] getOptionValues(String name) {
        if (!this.cmd.hasOption(name)) {
            return new String[0];
        }
        return this.cmd.getOptionValues(name);
    }

    protected String[] getNonOptions() {
        return this.cmd.getArgs();
    }

    protected void assertNonOptionSet(String name) {
        if (this.cmd.getArgList() == null || this.cmd.getArgList().size() == 0) {
            throw new MissingNonOption(name);
        }
    }

    protected void assertOptionSet(String name) {
        if (!this.isOptionSet(name) && !this.hasDefault(name)) {
            throw new MissingArgument(name);
        }
    }

    protected void assertOptionNotSet(String name) {
        if (this.isOptionSet(name)) {
            throw new UnexpectedArgument(name);
        }
    }

    protected void assertOptionsNotSet(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (!this.isOptionSet(names[i])) continue;
            throw new UnexpectedArgument(this.name);
        }
    }

    protected void assertAtLeastOneOptionSet(String[] names) {
        boolean valid = false;
        for (int i = 0; i < names.length; ++i) {
            if (!this.isOptionSet(names[i])) continue;
            valid = true;
        }
        if (!valid) {
            throw new MissingAtLeastOneArgument(names);
        }
    }

    protected void assertOnlyOneOptionSet(String[] names) {
        int count = 0;
        for (int i = 0; i < names.length; ++i) {
            if (!this.isOptionSet(names[i]) || ++count <= 1) continue;
            throw new OnlyOneArgumentExpected(names);
        }
        if (count != 1) {
            throw new OnlyOneArgumentExpected(names);
        }
    }

    protected void warnIfTooManyNonOptions() {
        String[] nonOpts = this.getNonOptions();
        if (nonOpts.length > 1) {
            StringBuffer sb = new StringBuffer(nonOpts[1]);
            for (int i = 2; i < nonOpts.length; ++i) {
                sb.append(", " + nonOpts[i]);
            }
            System.err.println("WARNING:  Ignoring extra parameter(s): [ " + sb + " ]");
        }
    }

    protected int[] parseRange(String range) {
        int max;
        int min;
        if ("-1".equals(range)) {
            return new int[]{0, 65535};
        }
        String[] parts = range.split("-");
        if (parts.length == 2) {
            try {
                min = Integer.parseInt(parts[0]);
                max = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                throw (InvalidRange)new InvalidRange(range).initCause(e);
            }
        }
        try {
            min = max = Integer.parseInt(range);
        }
        catch (NumberFormatException e) {
            throw (InvalidRange)new InvalidRange(range).initCause(e);
        }
        if (max < min || min < 0 || max < 0 || min > 65535 || max > 65535) {
            throw new InvalidRange(range);
        }
        return new int[]{min, max};
    }

    protected String describeOption(String opt) {
        Option o = this.options.getOption(opt);
        if (o == null) {
            throw new RuntimeException("Unknown option " + opt);
        }
        String shortName = o.getOpt();
        String longName = o.getLongOpt();
        String description = null;
        description = shortName == null ? "--" + longName : "-" + shortName + ", --" + longName;
        if (o.hasArg() && o.hasArgName() && !o.getArgName().equalsIgnoreCase("arg")) {
            description = description + " " + o.getArgName();
        }
        return description;
    }

    protected String describeOptions(String[] opts) {
        StringBuffer sb = new StringBuffer(this.describeOption(opts[0]));
        for (int i = 1; i < opts.length; ++i) {
            sb.append(", ");
            sb.append(this.describeOption(opts[i]));
        }
        return sb.toString();
    }

    private String getUserAgent() {
        String version;
        this.getClass().getClassLoader().getResourceAsStream("ec2version.properties");
        try {
            version = ShowVersion.getVersion();
        }
        catch (IOException e) {
            version = "[ioexception]";
        }
        String userAgent = "ec2-api-tools " + version;
        if (this.isOptionSet(VERBOSE)) {
            System.out.println("Setting User-Agent to [" + userAgent + "]");
        }
        return userAgent;
    }

    private void reportException(String[] msg, Throwable e, boolean showStackTrace) {
        for (String line : msg) {
            System.err.println(line);
        }
        if (showStackTrace || this.isOptionSet(DEBUG)) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private void reportException(String msg, Throwable e, boolean showStackTrace) {
        this.reportException(new String[]{msg}, e, showStackTrace);
    }

    public void invoke() {
        block53: {
            Jec2Options jec2Options;
            block52: {
                String timeout;
                block51: {
                    if (this.invalidArgument) {
                        System.exit(1);
                    }
                    if (this.showHelp) {
                        this.showUsage();
                        return;
                    }
                    jec2Options = new Jec2Options();
                    jec2Options.setVerbose(this.isOptionSet(VERBOSE));
                    if (this.isOptionSet(CONNECTION_TIMEOUT)) {
                        timeout = this.getOptionValue(CONNECTION_TIMEOUT);
                        try {
                            jec2Options.setConnectionTimeout(Integer.valueOf(Integer.parseInt(timeout)));
                        }
                        catch (NumberFormatException e) {
                            if (!this.isOptionSet(VERBOSE)) break block51;
                            System.err.println("Connection timeout set to invalid value: " + timeout);
                        }
                    }
                }
                if (this.isOptionSet(REQUEST_TIMEOUT)) {
                    timeout = this.getOptionValue(REQUEST_TIMEOUT);
                    try {
                        jec2Options.setRequestTimeout(Integer.valueOf(Integer.parseInt(timeout)));
                    }
                    catch (NumberFormatException e) {
                        if (!this.isOptionSet(VERBOSE)) break block52;
                        System.err.println("Request timeout set to invalid value: " + timeout);
                    }
                }
            }
            jec2Options.setUserAgent(this.getUserAgent());
            try {
                if (this.isOnline()) {
                    this.assertOptionSet("url");
                    String accessKey = this.getOptionValue(AWS_ACCESS_KEY);
                    String secretKey = this.getOptionValue(AWS_SECRET_KEY);
                    String privateKey = this.getOptionValue(PRIVATE_KEY);
                    String cert = this.getOptionValue(CERT);
                    String delegationToken = this.getOptionValue(AWS_DELEGATION_TOKEN);
                    Boolean dryRun = this.isOptionSet(AUTH_DRY_RUN);
                    Jec2SdkImpl jec2 = null;
                    if (null != accessKey && null != secretKey) {
                        if (this.isOptionSet(DEBUG)) {
                            System.out.println("Using AWS acces key: " + accessKey);
                        }
                        jec2 = new Jec2SdkImpl(accessKey, secretKey, delegationToken, this.getURL(), dryRun, jec2Options);
                    } else if (null != privateKey && null != cert) {
                        if (dryRun.booleanValue()) {
                            throw new AuthDryRunException("The auth-dry-run option can only be used with an AWS Access Key ID and an AWS Secret Key.");
                        }
                        jec2 = new Jec2Impl(new URL(this.getURL()), this.getOptionValue(PRIVATE_KEY), this.getOptionValue(CERT), jec2Options);
                    } else {
                        try {
                            AWSCredentials creds = new InstanceProfileCredentialsProvider().getCredentials();
                            if (this.isOptionSet(DEBUG)) {
                                System.out.println("Using AWS access key: " + creds.getAWSAccessKeyId());
                            }
                            jec2 = new Jec2SdkImpl(creds, this.getURL(), dryRun, jec2Options);
                        }
                        catch (Exception e) {
                            this.assertOptionSet(AWS_ACCESS_KEY);
                            this.assertOptionSet(AWS_SECRET_KEY);
                        }
                    }
                    if (!this.invokeOnline((Jec2)jec2, new Outputter(this.isOptionSet(HEADERS), this.isOptionSet(DEBUG), this.isOptionSet(SHOW_NULL_FIELDS), this.isOptionSet(VERBOSE), !this.isOptionSet(HIDE_TAGS)))) {
                        System.exit(1);
                    }
                    break block53;
                }
                if (!this.invokeOffline(new Outputter(this.isOptionSet(HEADERS), this.isOptionSet(DEBUG), this.isOptionSet(SHOW_NULL_FIELDS), this.isOptionSet(VERBOSE)))) {
                    System.exit(1);
                }
            }
            catch (AuthDryRunException e) {
                this.reportException(e.getMessage(), (Throwable)e, false);
            }
            catch (MissingArgument e) {
                this.reportException("Required option '" + this.describeOption(e.getName()) + "' missing (-h for usage)", (Throwable)e, false);
            }
            catch (UnexpectedArgument e) {
                this.reportException("Unexpected option '" + this.describeOption(e.getName()) + "' encountered (-h for usage)", (Throwable)e, false);
            }
            catch (MissingNonOption e) {
                this.reportException("Required parameter '" + e.getName() + "' missing (-h for usage)", (Throwable)e, false);
            }
            catch (MissingAtLeastOneArgument e) {
                this.reportException("One of required options [" + this.describeOptions(e.getNames()) + "] missing (-h for usage)", (Throwable)e, false);
            }
            catch (OnlyOneArgumentExpected e) {
                this.reportException("One, and only one, of [" + this.describeOptions(e.getNames()) + "] expected (-h for usage)", (Throwable)e, false);
            }
            catch (InvalidArgument e) {
                this.reportException("Invalid argument for option '" + this.describeOption(e.getName()) + "': '" + e.getValue() + "' (-h for usage)", (Throwable)e, false);
            }
            catch (InvalidRange e) {
                this.reportException("Invalid range specified: '" + e.getRange() + "' (use m-n)", (Throwable)e, false);
            }
            catch (InvalidArgumentCombination e) {
                this.reportException(e.getMessage() + " (-h for usage)", (Throwable)e, false);
            }
            catch (MalformedURLException e) {
                this.reportException("Malformed URL: '" + this.getURL() + "'", (Throwable)e, false);
            }
            catch (FileNotFoundException e) {
                this.reportException("File not found: '" + e.getMessage() + "'", (Throwable)e, false);
            }
            catch (UnknownHostException e) {
                this.reportException("Unknown host: '" + this.getURL() + "'", (Throwable)e, false);
            }
            catch (GeneralError e) {
                this.reportException(e.getMessage(), (Throwable)e, false);
            }
            catch (Jec2SoapFaultException e) {
                String faultCode = e.getFault().getFaultCode().getLocalPart();
                String faultString = faultCode + ": " + e.getFault().getMessage();
                if (faultCode.equals("RequestExpired")) {
                    String suggestion = "Your system clock may not be set to the correct time.  Please set it correctly and try again.";
                    this.reportException(new String[]{faultString, suggestion}, (Throwable)e, false);
                } else {
                    this.reportException(faultString, (Throwable)e, false);
                }
            }
            catch (AmazonServiceException e) {
                ArrayList<String> msg = new ArrayList<String>(2);
                String errorType = "Unknown";
                int statusCode = e.getStatusCode();
                if (statusCode >= 400 && statusCode < 500) {
                    errorType = "Client";
                } else if (statusCode >= 500 && statusCode < 600) {
                    errorType = "Service";
                }
                msg.add(errorType + "." + e.getErrorCode() + ": " + e.getMessage());
                if (this.isOptionSet(VERBOSE)) {
                    msg.add("Request ID: " + e.getRequestId());
                }
                this.reportException(msg.toArray(new String[msg.size()]), (Throwable)e, false);
            }
            catch (AmazonClientException e) {
                Throwable cause = e.getCause();
                if (cause instanceof HttpHostConnectException) {
                    String[] msg = new String[]{"Unable to connect to host: '" + this.getURL() + "'", cause.getMessage()};
                    this.reportException(msg, (Throwable)e, false);
                } else {
                    String[] msg = new String[]{"Unknown problem connecting to host: '" + this.getURL() + "'", e.getMessage()};
                    this.reportException(msg, (Throwable)e, false);
                }
            }
            catch (SocketTimeoutException e) {
                this.reportSocketTimeout(e);
            }
            catch (ConnectTimeoutException e) {
                this.reportException(new String[]{"Connection timeout. Please check your URL is correct and try again. If this persists please visit the", "AWS developer forums to see if it's the result of a known issue."}, (Throwable)e, false);
            }
            catch (InvalidKeyException e) {
                this.reportException(new String[]{"Invalid private key: " + e.getMessage(), "Please ensure the file contains a valid private key."}, (Throwable)e, false);
            }
            catch (InvalidCertException e) {
                this.reportException(new String[]{"Invalid X509 certificate: " + e.getMessage(), "Please ensure the file contains a valid X509 certificate."}, (Throwable)e, false);
            }
            catch (ConnectException e) {
                this.reportException("Unable to connect to host: '" + this.getURL() + "'", (Throwable)e, false);
            }
            catch (Exception e) {
                this.reportException("Unexpected error:", (Throwable)e, true);
            }
        }
        System.exit(0);
    }

    private void reportSocketTimeout(SocketTimeoutException e) {
        this.reportException(new String[]{"Read timeout. Please try again later. If this persists please visit the", "AWS developer forums to see if it's the result of a known issue.", "https://forums.aws.amazon.com/forum.jspa?forumID=30&start=0"}, (Throwable)e, false);
    }

    public String getUserDataFile(String str) throws IOException {
        String base64 = null;
        File file = new File(str);
        if (file.canRead() && file.isFile()) {
            try {
                int content_length = (int)file.length();
                FileInputStream ifs = new FileInputStream(file);
                byte[] contents = new byte[content_length];
                int nread = ifs.read(contents);
                assert (nread == content_length);
                base64 = new BASE64Encoder().encode(contents);
            }
            catch (FileNotFoundException nfe) {
                System.err.println("File not found? This is of course impossible.\n" + nfe.toString());
                throw nfe;
            }
        } else {
            throw new InvalidArgument(USER_DATA_FILE, str);
        }
        return base64.replaceAll("\\s", "");
    }

    public byte[] getUserDataFileUnencoded(String str) throws IOException {
        byte[] contents;
        block4: {
            contents = null;
            File file = new File(str);
            if (file.canRead() && file.isFile()) {
                try {
                    int content_length = (int)file.length();
                    FileInputStream ifs = new FileInputStream(file);
                    contents = new byte[content_length];
                    int nread = ifs.read(contents);
                    assert (nread == content_length);
                    break block4;
                }
                catch (FileNotFoundException nfe) {
                    System.err.println("File not found.\n" + nfe.toString());
                    throw nfe;
                }
            }
            throw new InvalidArgument(USER_DATA_FILE, str);
        }
        return contents;
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        throw new RuntimeException("Unimplemented invokeOnline called");
    }

    protected boolean invokeOffline(Outputter out) throws Exception {
        throw new RuntimeException("Unimplemented invokeOffline called");
    }

    public String[] getNames() {
        ArrayList<String> names = new ArrayList<String>(this.aliases);
        names.add(this.name);
        return names.toArray(new String[names.size()]);
    }

    public static Option createOptionWithArgs(String opt, String longOpt, String desc) {
        return BaseCmd.createOptionWithArgs(opt, longOpt, desc, null);
    }

    public static Option createOptionWithArgs(String opt, String longOpt, String[] desc, String argName) {
        return BaseCmd.createOptionWithArgs(opt, longOpt, BaseCmd.joinDescription(desc), argName);
    }

    public static Option createOptionWithArgs(String opt, String longOpt, String desc, String argName) {
        return BaseCmd.createOption(opt, longOpt, desc, argName, true);
    }

    public static Option createOption(String opt, String longOpt, String[] desc) {
        return BaseCmd.createOption(opt, longOpt, BaseCmd.joinDescription(desc), null, false);
    }

    public static Option createOption(String opt, String longOpt, String desc) {
        return BaseCmd.createOption(opt, longOpt, desc, null, false);
    }

    public static Option createOption(String opt, String longOpt, String desc, String argName, boolean hasArg) {
        Option option = new Option(opt, longOpt, hasArg, desc);
        if (hasArg) {
            option.setArgs(-2);
        }
        if (argName != null) {
            option.setArgName(argName);
        }
        return option;
    }

    public Map<String, List<String>> getFilterMap(boolean useNamedParameter) {
        String[] filterOptions = useNamedParameter ? this.getOptionValues(FILTER) : this.getNonOptions();
        LinkedHashMap<String, List<String>> filterMap = new LinkedHashMap<String, List<String>>();
        if (filterOptions != null) {
            for (String filterOption : filterOptions) {
                int index = filterOption.indexOf(61);
                if (index < 0) {
                    throw new GeneralError("Filter definitions must have format 'name=value', but found '" + filterOption + "'");
                }
                String filterKey = filterOption.substring(0, index);
                List filterValues = (List)filterMap.get(filterKey);
                List<String> newFilterValues = Arrays.asList(filterOption.substring(index + 1).split(","));
                if (filterValues == null) {
                    filterMap.put(filterKey, new LinkedList<String>(newFilterValues));
                    continue;
                }
                filterValues.addAll(newFilterValues);
            }
        }
        return filterMap;
    }

    public List<Filter> getFilters(boolean useNamedParameter) {
        Map<String, List<String>> filterMap = this.getFilterMap(useNamedParameter);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Map.Entry<String, List<String>> filterEntry : filterMap.entrySet()) {
            filters.add(new Filter(filterEntry.getKey(), filterEntry.getValue()));
        }
        return filters;
    }

    private static String unescapeTag(String s) {
        if (null == s) {
            return s;
        }
        return s.replaceAll("\\\\=", "=");
    }

    public List<TagType> getTags() throws Exception {
        ArrayList<TagType> tags = new ArrayList<TagType>();
        for (String tagStr : Arrays.asList(this.getOptionValues(TAG))) {
            Matcher m = TAG_PATTERN.matcher(tagStr);
            if (m.matches()) {
                TagType tag;
                if (m.groupCount() == 1) {
                    tag = new TagType(BaseCmd.unescapeTag(m.group(1)));
                } else if (m.groupCount() == 2) {
                    tag = new TagType(BaseCmd.unescapeTag(m.group(1)), BaseCmd.unescapeTag(m.group(2)));
                } else {
                    throw new Exception("'" + tagStr + "' is not a valid tag key or key/value pair.");
                }
                tags.add(tag);
                continue;
            }
            throw new Exception("'" + tagStr + "' is not a valid tag key or key/value pair.");
        }
        return tags;
    }

    public boolean getBooleanOption(String option) {
        String flag = this.getOptionValue(option).toLowerCase();
        if (!"true".equals(flag) && !"false".equals(flag)) {
            throw new InvalidArgument(option, this.getOptionValue(option));
        }
        return Boolean.parseBoolean(flag);
    }

    public Boolean getOptionalBooleanOption(String option) {
        String flag = this.getOptionValue(option);
        if (null == flag) {
            return null;
        }
        if (!"true".equals(flag = flag.toLowerCase()) && !"false".equals(flag)) {
            throw new InvalidArgument(option, this.getOptionValue(option));
        }
        return Boolean.parseBoolean(flag);
    }
}

