/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.ImportInstanceTaskDetails;
import com.amazonaws.services.ec2.model.ImportVolumeTaskDetails;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConversionTask {
    private String conversionTaskId;
    private String expirationTime;
    private ImportInstanceTaskDetails importInstance;
    private ImportVolumeTaskDetails importVolume;
    private String state;
    private String statusMessage;
    private List<Tag> tags;

    public String getConversionTaskId() {
        return this.conversionTaskId;
    }

    public void setConversionTaskId(String conversionTaskId) {
        this.conversionTaskId = conversionTaskId;
    }

    public ConversionTask withConversionTaskId(String conversionTaskId) {
        this.conversionTaskId = conversionTaskId;
        return this;
    }

    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public ConversionTask withExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public ImportInstanceTaskDetails getImportInstance() {
        return this.importInstance;
    }

    public void setImportInstance(ImportInstanceTaskDetails importInstance) {
        this.importInstance = importInstance;
    }

    public ConversionTask withImportInstance(ImportInstanceTaskDetails importInstance) {
        this.importInstance = importInstance;
        return this;
    }

    public ImportVolumeTaskDetails getImportVolume() {
        return this.importVolume;
    }

    public void setImportVolume(ImportVolumeTaskDetails importVolume) {
        this.importVolume = importVolume;
    }

    public ConversionTask withImportVolume(ImportVolumeTaskDetails importVolume) {
        this.importVolume = importVolume;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ConversionTask withState(String state) {
        this.state = state;
        return this;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public ConversionTask withStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public ConversionTask withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public ConversionTask withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conversionTaskId != null) {
            sb.append("ConversionTaskId: " + this.conversionTaskId + ", ");
        }
        if (this.expirationTime != null) {
            sb.append("ExpirationTime: " + this.expirationTime + ", ");
        }
        if (this.importInstance != null) {
            sb.append("ImportInstance: " + this.importInstance + ", ");
        }
        if (this.importVolume != null) {
            sb.append("ImportVolume: " + this.importVolume + ", ");
        }
        if (this.state != null) {
            sb.append("State: " + this.state + ", ");
        }
        if (this.statusMessage != null) {
            sb.append("StatusMessage: " + this.statusMessage + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConversionTaskId() == null ? 0 : this.getConversionTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTime() == null ? 0 : this.getExpirationTime().hashCode());
        hashCode = 31 * hashCode + (this.getImportInstance() == null ? 0 : this.getImportInstance().hashCode());
        hashCode = 31 * hashCode + (this.getImportVolume() == null ? 0 : this.getImportVolume().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTask)) {
            return false;
        }
        ConversionTask other = (ConversionTask)obj;
        if (other.getConversionTaskId() == null ^ this.getConversionTaskId() == null) {
            return false;
        }
        if (other.getConversionTaskId() != null && !other.getConversionTaskId().equals(this.getConversionTaskId())) {
            return false;
        }
        if (other.getExpirationTime() == null ^ this.getExpirationTime() == null) {
            return false;
        }
        if (other.getExpirationTime() != null && !other.getExpirationTime().equals(this.getExpirationTime())) {
            return false;
        }
        if (other.getImportInstance() == null ^ this.getImportInstance() == null) {
            return false;
        }
        if (other.getImportInstance() != null && !other.getImportInstance().equals(this.getImportInstance())) {
            return false;
        }
        if (other.getImportVolume() == null ^ this.getImportVolume() == null) {
            return false;
        }
        if (other.getImportVolume() != null && !other.getImportVolume().equals(this.getImportVolume())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }
}

