/*
 *	for new GOGO-no-coda (1999, 2000)
 *	modified by shigeo, PEN@MarineCat
 */

#ifndef COMMON_DOT_H
#define COMMON_DOT_H

 /*
 *  o[WR[h͂ɋL
 */
#define	VERSION_NUM		0x239
#ifdef BENCH_ONLY
#define VERSION			"ver. 2.39 for only bench"
#else
#define VERSION			"ver. 2.39  (" __DATE__ ")"
#endif

/* deal with path including Japanese characters */
#define JAPANESE_SPC

/* 
 *	WIN32łwaring̗}
 */

#ifdef	WIN32
	#ifdef	_MSC_VER
		#pragma warning( disable : 4305 )	/* const double->float ϊ */
		#pragma warning( disable : 4244 )	/* double->float ϊ */
		#pragma warning( disable : 4761 )	/* Ǝ̌^قȂ */
		#pragma warning( disable : 4018 )	/* signed/unsignedԂ̔r */
	#endif
#endif

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#ifdef __unix__
#include <unistd.h>
#endif

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE
#endif

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

#ifndef PI
#define PI	3.14159265358979
#endif

#define SQRT2	1.414213562373095

#define MONO		1
#define STEREO		2
#define HAN_SIZE	512
#define SCALE		32768
#define	SCALER		(1/32768.)	/* 1/SCALE */

/* MPEG Header Definitions - Mode Values */

#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3

/* Mode Extention */

#define         MPG_MD_MS_LR             2

#ifndef NUL
#define NUL		'\0'
#endif

#ifndef NOERR
#define NOERR	0
#define ERR		1
#endif

#define         Min(A, B)       ((A) < (B) ? (A) : (B))
#define         Max(A, B)       ((A) > (B) ? (A) : (B))

#ifdef WIN32
#	define MAX_FILE_LEN 260
#elif BeOS
#	define MAX_FILE_LEN 1024
#else
#	define MAX_FILE_LEN 256
#endif

#include "l3side.h"

extern int bitsPerFrame_table[15][2];
extern int mean_bits_table[15][2]; 

#define	getframebits( bitsPerFrame, mean_bits, _br, _padding ) \
	{\
		int br = (_br), padding = (_padding);\
\
		*(bitsPerFrame) = bitsPerFrame_table[br][padding];\
		*(mean_bits)    = mean_bits_table[br][padding];\
	}
void	framebitstable_init(void);

int		get_freq_idx(int freqHz, int *version);
int		get_rate_idx(int rate_kbps, int version);
void	*mem_alloc(unsigned long block,char *item);
void	mem_free(void **ptr_addr);
void	memFreeChk(void);

int		WAV_checkFMT(FILE *fp, int *size, int *bit, int *freq, int *channel);
void	term(int rval );
void	term2(int rval, const char *lpszFile, int	line );
int		NormalizeSmpFreq(long freqHz);

/* exit̑pƂTERMĂԂ */
#ifdef	NDEBUG
	#define	TERM(x)		term(x)
#else
	#define	TERM(x)		term2(x, __FILE__, __LINE__ )
#endif

/*
 *   G[\
 */
void disp_err( const char *mesg, ... );

/*
 *	œK`FbNp rdtcsgȂΗON!!!
 *	clockv肽clkbegin(),clkend()ŋ
 */
void clkbegin(void);
void clkend(void);

#ifdef _MAIN_C
#define EXT
#define VAL(x,y) x=y
#else
#define EXT extern
#define VAL(x,y) x
#endif
EXT int		VAL( nid3taglen, 0 );	// refer bitstrem.c
EXT char	VAL( *pid3tag, 0 );		// refer bitstrem.c
EXT struct GLOBAL_VAR{
	int stereo;
	int mode_gr;
	int version;
	int frameSize;   /* = ( version ) ? 1152 : 576 */
	int freq_idx;    /* index for table */
	int inp_freqHz;  /*  input freq Hz ex. 44100 */
	int enc_freqHz;  /* encode freq Hz ex. 44100 */
	int rate_kbps;     /* ex. 128(kbps) */

	/* for header */
	int extension;
	int mode;
	int emphasis;
}gl; /* global variables */

#undef EXT
#undef VAL

#endif		/* COMMON_H */
