/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Strings;

final class JComboBoxItemIndexValidator {
    @RunsInCurrentThread
    static void validateIndex(JComboBox comboBox, int index) {
        if (index < 0) {
            throw JComboBoxItemIndexValidator.invalidIndex(Strings.concat((Object[])new Object[]{JComboBoxItemIndexValidator.itemIndex(index), " should not be less than zero"}));
        }
        int itemCount = comboBox.getItemCount();
        if (itemCount == 0) {
            throw JComboBoxItemIndexValidator.invalidIndex("JComboBox is empty");
        }
        if (index >= 0 && index < itemCount) {
            return;
        }
        throw JComboBoxItemIndexValidator.invalidIndex(Strings.concat((Object[])new Object[]{JComboBoxItemIndexValidator.itemIndex(index), " should be between [", String.valueOf(0), "] and [", String.valueOf(itemCount - 1), "] (inclusive)"}));
    }

    private static String itemIndex(int index) {
        return Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ")"});
    }

    private static IndexOutOfBoundsException invalidIndex(String msg) {
        throw new IndexOutOfBoundsException(msg);
    }

    private JComboBoxItemIndexValidator() {
    }
}

