/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Median<T extends Comparable> {
    final List<T> values;
    final int maxValuesToKeep;
    boolean sorted = false;

    public Median() {
        this(Integer.MAX_VALUE);
    }

    public Median(int maxValuesToKeep) {
        this.maxValuesToKeep = maxValuesToKeep;
        this.values = new ArrayList<T>();
    }

    public boolean isFull() {
        return this.values.size() >= this.maxValuesToKeep;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public T getMedian() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot get median value from empty array");
        }
        return this.getMedian(null);
    }

    public T getMedian(T defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        if (!this.sorted) {
            this.sorted = true;
            Collections.sort(this.values);
        }
        int offset = (int)Math.floor((double)(this.values.size() + 1) * 0.5) - 1;
        return (T)((Comparable)this.values.get(offset));
    }

    public boolean add(T value) {
        if (!this.isFull()) {
            this.sorted = false;
            return this.values.add(value);
        }
        return false;
    }
}

