/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Color;
import org.fest.assertions.Assertions;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.swing.util.Colors;

public class ColorFixture {
    private final Color target;
    private final Description description;

    public ColorFixture(Color target) {
        this(target, (Description)null);
    }

    public ColorFixture(Color target, String description) {
        this(target, (Description)new BasicDescription(description));
    }

    public ColorFixture(Color target, Description description) {
        if (target == null) {
            throw new NullPointerException("The given color should not be null");
        }
        this.target = target;
        this.description = description;
    }

    public ColorFixture requireEqualTo(String hexValue) {
        return this.requireEqualTo(Colors.colorFromHexString(hexValue));
    }

    public ColorFixture requireEqualTo(Color color) {
        Assertions.assertThat((Object)this.target).as(this.description).isEqualTo((Object)color);
        return this;
    }

    public ColorFixture requireNotEqualTo(String hexValue) {
        return this.requireNotEqualTo(Colors.colorFromHexString(hexValue));
    }

    public ColorFixture requireNotEqualTo(Color color) {
        Assertions.assertThat((Object)this.target).as(this.description).isNotEqualTo((Object)color);
        return this;
    }

    public Color target() {
        return this.target;
    }

    public final String description() {
        return this.description != null ? this.description.value() : null;
    }
}

