/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.IOException;
import java.util.ArrayList;

public class RGNMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int n) throws IOException {
        int n2 = this.nCompBytes();
        if (n2 == 0) {
            this._repInfo.setMessage(new ErrorMessage("RGN marker segment at wrong position in codestream"));
            return false;
        }
        int n3 = n2 < 257 ? ModuleBase.readUnsignedByte(this._dstream, this._module) : this._module.readUnsignedShort(this._dstream);
        int n4 = ModuleBase.readUnsignedByte(this._dstream, this._module);
        int n5 = ModuleBase.readUnsignedByte(this._dstream, this._module);
        MainOrTile mainOrTile = this.getMainOrTile();
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        arrayList.add(new Property("ROIStyle", PropertyType.INTEGER, new Integer(n4)));
        arrayList.add(new Property("ROIParameter", PropertyType.INTEGER, new Integer(n5)));
        mainOrTile.setCompProperty(n3, new Property("RegionOfInterest", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

