/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.FileSpecification;
import edu.harvard.hul.ois.jhove.module.pdf.Filter;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PdfStream
extends PdfObject {
    private Stream _stream;
    private PdfDictionary _dict;
    private Filter[] _filters;
    private boolean pdfaCompliant;

    public PdfStream(PdfDictionary pdfDictionary, Stream stream, int n, int n2) throws PdfException {
        super(n, n2);
        this._stream = stream;
        this._dict = pdfDictionary;
        this.pdfaCompliant = true;
        this.extractFilters();
    }

    public PdfStream(PdfDictionary pdfDictionary, Stream stream) throws PdfException {
        this._stream = stream;
        this._dict = pdfDictionary;
        this.pdfaCompliant = true;
        this.extractFilters();
    }

    public PdfDictionary getDict() {
        return this._dict;
    }

    public Stream getStream() {
        return this._stream;
    }

    public String getFileSpecification() {
        PdfObject pdfObject = this._dict.get("F");
        if (pdfObject == null) {
            return null;
        }
        try {
            this.pdfaCompliant = false;
            FileSpecification fileSpecification = new FileSpecification(pdfObject);
            return fileSpecification.getSpecString();
        }
        catch (PdfException pdfException) {
            return null;
        }
    }

    public boolean isPdfaCompliant() {
        return this.pdfaCompliant;
    }

    public Filter[] getFilters() throws PdfException {
        return this._filters;
    }

    public String getFilterName() {
        PdfObject pdfObject;
        PdfObject pdfObject2 = this._dict.get("DecodeParams");
        if (pdfObject2 instanceof PdfDictionary && (pdfObject = ((PdfDictionary)pdfObject2).get("Name")) instanceof PdfSimpleObject) {
            return ((PdfSimpleObject)pdfObject).getStringValue();
        }
        return null;
    }

    private void extractFilters() throws PdfException {
        PdfObject pdfObject;
        boolean bl = false;
        this._filters = new Filter[0];
        PdfObject pdfObject2 = this._dict.get("Filter");
        if (pdfObject2 == null) {
            pdfObject2 = this._dict.get("FFilter");
            if (pdfObject2 == null) {
                return;
            }
            bl = true;
            this.pdfaCompliant = false;
        }
        if (bl) {
            pdfObject = this._dict.get("FDecodeParms");
            if (pdfObject != null) {
                this.pdfaCompliant = false;
            }
        } else {
            pdfObject = this._dict.get("DecodeParms");
        }
        try {
            if (pdfObject2 instanceof PdfArray) {
                Vector vector = ((PdfArray)pdfObject2).getContent();
                int n = vector.size();
                Filter[] filterArray = new Filter[n];
                Vector vector2 = null;
                if (pdfObject != null) {
                    vector2 = ((PdfArray)pdfObject).getContent();
                }
                for (int i = 0; i < n; ++i) {
                    PdfSimpleObject pdfSimpleObject;
                    PdfObject pdfObject3;
                    PdfSimpleObject pdfSimpleObject2 = (PdfSimpleObject)vector.get(i);
                    filterArray[i] = new Filter(pdfSimpleObject2.getStringValue());
                    if (vector2 == null || (pdfObject3 = (PdfObject)vector2.get(i)) instanceof PdfSimpleObject && "null".equals((pdfSimpleObject = (PdfSimpleObject)pdfObject3).getStringValue())) continue;
                    filterArray[i].setDecodeParms((PdfDictionary)vector2.get(i));
                }
                this._filters = filterArray;
            } else {
                Filter[] filterArray = new Filter[]{new Filter(((PdfSimpleObject)pdfObject2).getStringValue())};
                if (pdfObject instanceof PdfDictionary) {
                    filterArray[0].setDecodeParms((PdfDictionary)pdfObject);
                }
                this._filters = filterArray;
            }
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Malformed filter");
        }
    }

    protected List makeFilterList() throws PdfException {
        Filter[] filterArray = this.getFilters();
        if (filterArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(filterArray.length);
        for (int i = 0; i < filterArray.length; ++i) {
            arrayList.add(filterArray[i].getFilterName());
        }
        return arrayList;
    }

    public boolean isImage() {
        PdfObject pdfObject = this._dict.get("Subtype");
        if (pdfObject instanceof PdfSimpleObject) {
            String string = ((PdfSimpleObject)pdfObject).getStringValue();
            return "Image".equals(string);
        }
        return false;
    }
}

